/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.extras;

import eu.hansolo.steelseries.tools.GradientWrapper;
import eu.hansolo.steelseries.tools.Orientation;
import eu.hansolo.steelseries.tools.Util;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class Battery
extends JComponent {
    private static final Util UTIL = Util.INSTANCE;
    private final Rectangle INNER_BOUNDS;
    private int value = 0;
    private boolean initialized = false;
    private BufferedImage batteryImage = UTIL.createImage(1, 1, 3);
    private final Color FULL_BORDER = new Color(7971403);
    private final Color HALF_BORDER = new Color(14395157);
    private final Color EMPTY_BORDER = new Color(11606274);
    private final Color FULL_DARK = new Color(10737766);
    private final Color FULL_LIGHT = new Color(14674262);
    private final Color HALF_DARK = new Color(14990624);
    private final Color HALF_LIGHT = new Color(16184477);
    private final Color EMPTY_DARK = new Color(12986117);
    private final Color EMPTY_LIGHT = new Color(16152880);
    private GradientWrapper borderGradient;
    private GradientWrapper liquidGradientDark;
    private GradientWrapper liquidGradientLight;
    private Orientation lightPosition;
    private final transient ComponentListener COMPONENT_LISTENER = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            Container container = Battery.this.getParent();
            if (container != null && container.getLayout() == null) {
                Battery.this.setSize(Battery.this.getWidth(), Battery.this.getHeight());
            } else {
                Battery.this.setPreferredSize(new Dimension(Battery.this.getWidth(), Battery.this.getHeight()));
            }
            Battery.this.calcInnerBounds();
            Battery.this.init(((Battery)Battery.this).INNER_BOUNDS.width, ((Battery)Battery.this).INNER_BOUNDS.height);
        }
    };

    public Battery() {
        this.lightPosition = Orientation.NORTH;
        this.INNER_BOUNDS = new Rectangle(40, 18);
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
        this.addComponentListener(this.COMPONENT_LISTENER);
    }

    private void init(int n, int n2) {
        if (n <= 1) {
            return;
        }
        if (this.batteryImage != null) {
            this.batteryImage.flush();
        }
        this.batteryImage = this.create_BATTERY_Image(n, n2 - this.getInsets().bottom, this.value);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (!this.initialized) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.translate(this.INNER_BOUNDS.x, this.INNER_BOUNDS.y);
        graphics2D.drawImage((Image)this.batteryImage, 0, 0, null);
        graphics2D.translate(-this.INNER_BOUNDS.x, -this.INNER_BOUNDS.y);
        graphics2D.dispose();
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int n) {
        this.value = n < 0 ? 0 : (n > 100 ? 100 : n);
        this.init(this.getWidth(), this.getHeight());
        this.repaint(this.INNER_BOUNDS);
    }

    public Orientation getLightPosition() {
        return this.lightPosition;
    }

    public void setLightPosition(Orientation orientation) {
        this.lightPosition = orientation;
        this.init(this.getWidth(), this.getHeight());
        this.repaint(this.INNER_BOUNDS);
    }

    public BufferedImage getAsImage() {
        BufferedImage bufferedImage = UTIL.createImage(this.getWidth(), this.getHeight(), 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        this.paintAll(graphics2D);
        graphics2D.dispose();
        return bufferedImage;
    }

    public BufferedImage create_BATTERY_Image(int n, int n2, int n3) {
        if (n <= 0 || n2 <= 0) {
            return UTIL.createImage(1, 1, 3);
        }
        BufferedImage bufferedImage = UTIL.createImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n4 = bufferedImage.getWidth();
        int n5 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n4 * 0.025, (double)n5 * 0.05555555555555555);
        generalPath.lineTo((double)n4 * 0.9, (double)n5 * 0.05555555555555555);
        generalPath.lineTo((double)n4 * 0.9, (double)n5 * 0.9444444444444444);
        generalPath.lineTo((double)n4 * 0.025, (double)n5 * 0.9444444444444444);
        generalPath.lineTo((double)n4 * 0.025, (double)n5 * 0.05555555555555555);
        generalPath.closePath();
        generalPath.moveTo((double)n4 * 0.925, (double)n5 * 0.0);
        generalPath.lineTo((double)n4 * 0.0, (double)n5 * 0.0);
        generalPath.lineTo((double)n4 * 0.0, (double)n5 * 1.0);
        generalPath.lineTo((double)n4 * 0.925, (double)n5 * 1.0);
        generalPath.lineTo((double)n4 * 0.925, (double)n5 * 0.7222222222222222);
        generalPath.curveTo((double)n4 * 0.925, (double)n5 * 0.7222222222222222, (double)n4 * 0.975, (double)n5 * 0.7222222222222222, (double)n4 * 0.975, (double)n5 * 0.7222222222222222);
        generalPath.curveTo((double)n4 * 1.0, (double)n5 * 0.7222222222222222, (double)n4 * 1.0, (double)n5 * 0.6666666666666666, (double)n4 * 1.0, (double)n5 * 0.6666666666666666);
        generalPath.curveTo((double)n4 * 1.0, (double)n5 * 0.6666666666666666, (double)n4 * 1.0, (double)n5 * 0.3333333333333333, (double)n4 * 1.0, (double)n5 * 0.3333333333333333);
        generalPath.curveTo((double)n4 * 1.0, (double)n5 * 0.3333333333333333, (double)n4 * 1.0, (double)n5 * 0.2777777777777778, (double)n4 * 0.975, (double)n5 * 0.2777777777777778);
        generalPath.curveTo((double)n4 * 0.975, (double)n5 * 0.2777777777777778, (double)n4 * 0.925, (double)n5 * 0.2777777777777778, (double)n4 * 0.925, (double)n5 * 0.2777777777777778);
        generalPath.lineTo((double)n4 * 0.925, (double)n5 * 0.0);
        generalPath.closePath();
        Point2D.Double double_ = new Point2D.Double();
        Point2D.Double double_2 = new Point2D.Double();
        switch (this.lightPosition) {
            case NORTH_EAST: {
                ((Point2D)double_).setLocation(generalPath.getBounds2D().getMaxX(), generalPath.getBounds2D().getMinY());
                ((Point2D)double_2).setLocation(generalPath.getBounds2D().getMinX(), generalPath.getBounds2D().getMaxY());
                break;
            }
            case EAST: {
                ((Point2D)double_).setLocation(generalPath.getBounds2D().getMaxX(), 0.0);
                ((Point2D)double_2).setLocation(generalPath.getBounds2D().getMinX(), 0.0);
                break;
            }
            case SOUTH_EAST: {
                ((Point2D)double_).setLocation(generalPath.getBounds2D().getMaxX(), generalPath.getBounds2D().getMaxY());
                ((Point2D)double_2).setLocation(generalPath.getBounds2D().getMinX(), generalPath.getBounds2D().getMinY());
                break;
            }
            case SOUTH: {
                ((Point2D)double_).setLocation(0.0, generalPath.getBounds2D().getMaxY());
                ((Point2D)double_2).setLocation(0.0, generalPath.getBounds2D().getMinY());
                break;
            }
            case SOUTH_WEST: {
                ((Point2D)double_).setLocation(generalPath.getBounds2D().getMinX(), generalPath.getBounds2D().getMaxY());
                ((Point2D)double_2).setLocation(generalPath.getBounds2D().getMaxX(), generalPath.getBounds2D().getMinY());
                break;
            }
            case WEST: {
                ((Point2D)double_).setLocation(generalPath.getBounds2D().getMinX(), 0.0);
                ((Point2D)double_2).setLocation(generalPath.getBounds2D().getMaxX(), 0.0);
                break;
            }
            case NORTH_WEST: {
                ((Point2D)double_).setLocation(generalPath.getBounds2D().getMinX(), generalPath.getBounds2D().getMinY());
                ((Point2D)double_2).setLocation(generalPath.getBounds2D().getMaxX(), generalPath.getBounds2D().getMaxY());
                break;
            }
            default: {
                ((Point2D)double_).setLocation(0.0, generalPath.getBounds2D().getMinY());
                ((Point2D)double_2).setLocation(0.0, generalPath.getBounds2D().getMaxY());
            }
        }
        float[] fArray = new float[]{0.0f, 1.0f};
        Color[] colorArray = new Color[]{new Color(255, 255, 255, 255), new Color(126, 126, 126, 255)};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(generalPath);
        Rectangle2D.Double double_3 = new Rectangle2D.Double((double)n4 * 0.025, (double)n4 * 0.025, (double)n4 * 0.875 * ((double)n3 / 100.0), (double)n5 * 0.88888888888888);
        float[] fArray2 = new float[]{0.0f, 0.4f, 1.0f};
        Color[] colorArray2 = new Color[]{this.EMPTY_BORDER, this.HALF_BORDER, this.FULL_BORDER};
        this.borderGradient = new GradientWrapper(new Point2D.Double(0.0, 0.0), new Point2D.Double(100.0, 0.0), fArray2, colorArray2);
        graphics2D.setPaint(this.borderGradient.getColorAt((float)n3 / 100.0f));
        graphics2D.fill(double_3);
        Rectangle2D.Double double_4 = new Rectangle2D.Double((double)n4 * 0.05, (double)n4 * 0.05, (double)n4 * 0.85 * ((double)n3 / 100.0), (double)n5 * 0.77777777777777);
        Point2D.Double double_5 = new Point2D.Double((double)n4 * 0.05, 0.0);
        Point2D.Double double_6 = new Point2D.Double((double)n4 * 0.875, 0.0);
        float[] fArray3 = new float[]{0.0f, 0.5f, 1.0f};
        Color[] colorArray3 = new Color[]{this.EMPTY_DARK, this.HALF_DARK, this.FULL_DARK};
        Color[] colorArray4 = new Color[]{this.EMPTY_LIGHT, this.HALF_LIGHT, this.FULL_LIGHT};
        float[] fArray4 = new float[]{0.0f, 0.4f, 1.0f};
        this.liquidGradientDark = new GradientWrapper(new Point2D.Double(0.0, 0.0), new Point2D.Double(100.0, 0.0), fArray4, colorArray3);
        this.liquidGradientLight = new GradientWrapper(new Point2D.Double(0.0, 0.0), new Point2D.Double(100.0, 0.0), fArray4, colorArray4);
        Color[] colorArray5 = new Color[]{this.liquidGradientDark.getColorAt((float)n3 / 100.0f), this.liquidGradientLight.getColorAt((float)n3 / 100.0f), this.liquidGradientDark.getColorAt((float)n3 / 100.0f)};
        LinearGradientPaint linearGradientPaint2 = new LinearGradientPaint(double_5, double_6, fArray3, colorArray5);
        graphics2D.setPaint(linearGradientPaint2);
        graphics2D.fill(double_4);
        Rectangle2D.Double double_7 = new Rectangle2D.Double((double)n4 * 0.025, (double)n4 * 0.025, (double)n4 * 0.875, (double)n5 * 0.44444444444444);
        Point2D.Double double_8 = new Point2D.Double(0.0, ((Rectangle2D)double_7).getBounds2D().getMinY());
        Point2D.Double double_9 = new Point2D.Double(0.0, ((Rectangle2D)double_7).getBounds2D().getMaxY());
        float[] fArray5 = new float[]{0.0f, 1.0f};
        Color[] colorArray6 = new Color[]{new Color(1.0f, 1.0f, 1.0f, 0.0f), new Color(1.0f, 1.0f, 1.0f, 0.8f)};
        LinearGradientPaint linearGradientPaint3 = new LinearGradientPaint(double_8, double_9, fArray5, colorArray6);
        graphics2D.setPaint(linearGradientPaint3);
        graphics2D.fill(double_7);
        graphics2D.dispose();
        return bufferedImage;
    }

    private void calcInnerBounds() {
        Insets insets = this.getInsets();
        this.INNER_BOUNDS.setBounds(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(40, 18);
    }

    @Override
    public void setPreferredSize(Dimension dimension) {
        super.setPreferredSize(new Dimension(dimension.width, (int)(0.45 * (double)dimension.width)));
        this.calcInnerBounds();
        this.init(this.INNER_BOUNDS.width, (int)(0.45 * (double)this.INNER_BOUNDS.width));
        this.initialized = true;
    }

    @Override
    public void setSize(int n, int n2) {
        super.setSize(n, (int)(0.45 * (double)n));
        this.calcInnerBounds();
        this.init(this.INNER_BOUNDS.width, (int)(0.45 * (double)this.INNER_BOUNDS.width));
        this.initialized = true;
    }

    @Override
    public void setSize(Dimension dimension) {
        super.setPreferredSize(new Dimension(dimension.width, (int)(0.45 * (double)dimension.width)));
        this.calcInnerBounds();
        this.init(this.INNER_BOUNDS.width, (int)(0.45 * (double)this.INNER_BOUNDS.width));
        this.initialized = true;
    }

    @Override
    public void setBounds(Rectangle rectangle) {
        super.setBounds(new Rectangle(rectangle.x, rectangle.y, rectangle.width, (int)(0.45 * (double)rectangle.width)));
        this.calcInnerBounds();
        this.init(this.INNER_BOUNDS.width, (int)(0.45 * (double)this.INNER_BOUNDS.width));
        this.initialized = true;
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, (int)(0.45 * (double)n3));
        this.calcInnerBounds();
        this.init(this.INNER_BOUNDS.width, (int)(0.45 * (double)this.INNER_BOUNDS.width));
        this.initialized = true;
    }

    @Override
    public void setBorder(Border border) {
        super.setBorder(border);
        this.calcInnerBounds();
        this.init(this.INNER_BOUNDS.width, (int)(0.45 * (double)this.INNER_BOUNDS.width));
    }

    @Override
    public String toString() {
        return "Battery";
    }
}

