/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.extras;

import eu.hansolo.steelseries.extras.Poi;
import eu.hansolo.steelseries.gauges.AbstractGauge;
import eu.hansolo.steelseries.gauges.AbstractRadial;
import eu.hansolo.steelseries.tools.ConicalGradientPaint;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.concurrent.ConcurrentHashMap;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.ease.Linear;
import org.pushingpixels.trident.ease.TimelineEase;

public final class Radar
extends AbstractRadial
implements ActionListener {
    private final Poi MY_LOCATION = new Poi("Home", 0.0, 0.0);
    private double range = 100000.0;
    private static final int INITIAL_WIDTH = 200;
    private double pixelScaleX = this.range / 80.0 / 620.0;
    private double pixelScaleY = this.range / 80.0 / 1000.0;
    private Point2D CENTER_XY = this.MY_LOCATION.getLocationXY();
    private ConcurrentHashMap<String, Poi> pois = new ConcurrentHashMap(64);
    private ConcurrentHashMap<String, Poi> blips = new ConcurrentHashMap(64);
    private final Color BLIP_TEXT_COLOR = new Color(6397541);
    private final Font BLIP_FONT = new Font("Verdana", 0, 6);
    private final Line2D BEAM = new Line2D.Double(100.0, 100.0, 158.0, 158.0);
    private final Point2D CENTER = new Point2D.Double();
    private BufferedImage bImage;
    private BufferedImage beamImage;
    private BufferedImage disabledImage;
    private final Color BEAM_COLOR = new Color(130, 230, 150, 180);
    private double rotationAngle = 0.0;
    private Timeline timeline = new Timeline((Object)this);

    public Radar() {
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public final AbstractGauge init(int n, int n2) {
        int n3;
        int n4 = this.isFrameVisible() ? n : this.getGaugeBounds().width;
        int n5 = n3 = this.isFrameVisible() ? n2 : this.getGaugeBounds().height;
        if (n4 <= 1 || n3 <= 1) {
            return this;
        }
        this.pixelScaleX = this.range / (0.4 * (double)n4) / 620.0;
        this.pixelScaleY = this.range / (0.4 * (double)n4) / 1000.0;
        this.CENTER.setLocation(this.getGaugeBounds().getCenterX(), this.getGaugeBounds().getCenterY());
        if (!this.isFrameVisible()) {
            this.setFramelessOffset((double)(-this.getGaugeBounds().width) * 0.0841121495, (double)(-this.getGaugeBounds().width) * 0.0841121495);
        } else {
            this.setFramelessOffset(this.getGaugeBounds().x, this.getGaugeBounds().y);
        }
        if (this.bImage != null) {
            this.bImage.flush();
        }
        this.bImage = UTIL.createImage(n4, n4, 3);
        if (this.isFrameVisible()) {
            switch (this.getFrameType()) {
                case ROUND: {
                    FRAME_FACTORY.createRadialFrame(n4, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect(), this.bImage);
                    break;
                }
                case SQUARE: {
                    FRAME_FACTORY.createLinearFrame(n4, n4, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect(), this.bImage);
                    break;
                }
                default: {
                    FRAME_FACTORY.createRadialFrame(n4, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect(), this.bImage);
                }
            }
        }
        if (this.isBackgroundVisible()) {
            this.create_BACKGROUND_Image(n4, this.bImage);
        }
        this.create_TICKMARKS_Image(n4, this.bImage);
        if (this.beamImage != null) {
            this.beamImage.flush();
        }
        this.beamImage = this.create_BEAM_Image(n4);
        if (this.disabledImage != null) {
            this.disabledImage.flush();
        }
        this.disabledImage = this.create_DISABLED_Image(n4);
        this.BEAM.setLine(this.CENTER.getX(), this.CENTER.getY(), (double)n4 * 0.79, (double)n3 * 0.79);
        return this;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (!this.isInitialized()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.translate(this.getFramelessOffset().getX(), this.getFramelessOffset().getY());
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.drawImage((Image)this.bImage, 0, 0, null);
        graphics2D.setColor(this.BLIP_TEXT_COLOR);
        graphics2D.setFont(this.BLIP_FONT);
        for (Poi poi : this.blips.values()) {
            if (!(poi.distanceTo(this.MY_LOCATION) < this.range)) continue;
            graphics2D.drawImage((Image)poi.getPoiImage(), (int)(this.CENTER.getX() - (double)poi.getPoiImage().getWidth() / 2.0 + (poi.getLocationXY().getX() - this.CENTER_XY.getX()) / this.pixelScaleX), (int)(this.CENTER.getY() - (double)poi.getPoiImage().getWidth() / 2.0 + (poi.getLocationXY().getY() - this.CENTER_XY.getY()) / this.pixelScaleY), null);
            graphics2D.drawString(poi.getName(), (int)(this.CENTER.getX() - (double)poi.getPoiImage().getWidth() + (poi.getLocationXY().getX() - this.CENTER_XY.getX()) / this.pixelScaleX), (int)(this.CENTER.getY() - (double)poi.getPoiImage().getWidth() + (poi.getLocationXY().getY() - this.CENTER_XY.getY()) / this.pixelScaleY));
        }
        graphics2D.rotate(this.rotationAngle, this.CENTER.getX(), this.CENTER.getY());
        graphics2D.drawImage((Image)this.beamImage, 0, 0, null);
        graphics2D.setTransform(affineTransform);
        graphics2D.rotate(Math.toRadians(-135.0) + this.rotationAngle, this.CENTER.getX(), this.CENTER.getY());
        graphics2D.setColor(this.BEAM_COLOR);
        graphics2D.draw(this.BEAM);
        graphics2D.setTransform(affineTransform);
        if (!this.isEnabled()) {
            graphics2D.drawImage((Image)this.disabledImage, 0, 0, null);
        }
        graphics2D.dispose();
    }

    public double getRotationAngle() {
        return this.rotationAngle;
    }

    public void setRotationAngle(double d) {
        this.rotationAngle = d;
        this.repaint();
    }

    public double getRange() {
        return this.range;
    }

    public void setRange(double d) {
        this.range = d;
        this.checkForBlips();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint();
    }

    public Poi getMyLocation() {
        return this.MY_LOCATION;
    }

    public void setMyLocation(Poi poi) {
        this.MY_LOCATION.setLocation(poi.getLocation());
        this.checkForBlips();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint();
    }

    public void setMyLocation(double d, double d2) {
        this.MY_LOCATION.setLocation(d, d2);
        this.checkForBlips();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint();
    }

    public void addPoi(Poi poi) {
        if (this.pois.keySet().contains(poi.getName())) {
            this.updatePoi(poi.getName(), poi.getLocation());
        } else {
            this.pois.put(poi.getName(), poi);
        }
        this.checkForBlips();
    }

    public void updatePoi(String string, Point2D point2D) {
        if (this.pois.keySet().contains(string)) {
            this.pois.get(string).setLocation(point2D);
            this.checkForBlips();
        }
    }

    public void removePoi(Poi poi) {
        if (this.pois.keySet().contains(poi.getName())) {
            this.pois.remove(poi.getName());
            this.checkForBlips();
        }
    }

    public Poi getPoi(String string) {
        Poi poi = this.pois.keySet().contains(string) ? this.pois.get(string) : null;
        return poi;
    }

    public void animate(boolean bl) {
        if (this.isEnabled()) {
            if (bl) {
                if (this.timeline.getState() != Timeline.TimelineState.PLAYING_FORWARD && this.timeline.getState() != Timeline.TimelineState.SUSPENDED) {
                    this.timeline = new Timeline((Object)this);
                    this.timeline.addPropertyToInterpolate("rotationAngle", (Object)this.rotationAngle, (Object)(Math.PI * 2));
                    this.timeline.setEase((TimelineEase)new Linear());
                    this.timeline.setDuration(5000L);
                    this.timeline.playLoop(Timeline.RepeatBehavior.LOOP);
                } else if (this.timeline.getState() == Timeline.TimelineState.SUSPENDED) {
                    this.timeline.resume();
                }
            } else {
                this.timeline.suspend();
            }
        }
    }

    private void checkForBlips() {
        this.blips.clear();
        for (Poi poi : this.pois.values()) {
            if (!(poi.distanceTo(this.MY_LOCATION) < this.range) || this.blips.keySet().contains(poi.getName())) continue;
            this.blips.put(poi.getName(), poi);
        }
    }

    @Override
    public Point2D getCenter() {
        return new Point2D.Double((double)this.bImage.getWidth() / 2.0 + (double)this.getInnerBounds().x, (double)this.bImage.getHeight() / 2.0 + (double)this.getInnerBounds().y);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return new Rectangle2D.Double(this.bImage.getMinX(), this.bImage.getMinY(), this.bImage.getWidth(), this.bImage.getHeight());
    }

    @Override
    public Rectangle getLcdBounds() {
        return new Rectangle();
    }

    private BufferedImage create_BACKGROUND_Image(int n, BufferedImage bufferedImage) {
        if (n <= 0) {
            return null;
        }
        if (bufferedImage == null) {
            bufferedImage = UTIL.createImage(n, n, 3);
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        Ellipse2D.Double double_ = new Ellipse2D.Double((double)n2 * 0.08411215245723724, (double)n3 * 0.08411215245723724, (double)n2 * 0.8317756652832031, (double)n3 * 0.8317756652832031);
        Point2D.Double double_2 = new Point2D.Double(0.0, double_.getBounds2D().getMinY());
        Point2D.Double double_3 = new Point2D.Double(0.0, double_.getBounds2D().getMaxY());
        float[] fArray = new float[]{0.0f, 1.0f};
        Color[] colorArray = new Color[]{new Color(7940), new Color(79109)};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_2, double_3, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(double_);
        Ellipse2D.Double double_4 = new Ellipse2D.Double((double)n2 * 0.08411215245723724, (double)n3 * 0.08411215245723724, (double)n2 * 0.8317756652832031, (double)n3 * 0.8317756652832031);
        Point2D.Double double_5 = new Point2D.Double(0.5 * (double)n2, 0.5 * (double)n3);
        float[] fArray2 = new float[]{0.0f, 0.7f, 0.71f, 1.0f};
        Color[] colorArray2 = new Color[]{new Color(0, 90, 40, 0), new Color(0, 90, 40, 0), new Color(0, 90, 40, 0), new Color(0, 90, 40, 76)};
        RadialGradientPaint radialGradientPaint = new RadialGradientPaint(double_5, (float)(0.4158878504672897 * (double)n2), fArray2, colorArray2);
        graphics2D.setPaint(radialGradientPaint);
        graphics2D.fill(double_4);
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_TICKMARKS_Image(int n, BufferedImage bufferedImage) {
        double d;
        if (n <= 0) {
            return null;
        }
        if (bufferedImage == null) {
            bufferedImage = UTIL.createImage(n, n, 3);
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        int n2 = bufferedImage.getWidth();
        AffineTransform affineTransform = graphics2D.getTransform();
        BasicStroke basicStroke = new BasicStroke(0.00390625f * (float)n2, 1, 2);
        Font font = new Font("Verdana", 0, (int)(0.02f * (float)n2));
        float f = 0.04f * (float)n2;
        float f2 = 0.015625f * (float)n2;
        float f3 = 0.0234375f * (float)n2;
        float f4 = 0.03125f * (float)n2;
        Color color = new Color(6397541);
        Color color2 = new Color(6397541);
        Color color3 = new Color(86, 119, 92, 100);
        float f5 = (float)n2 * 0.4f;
        Point2D.Double double_ = new Point2D.Double((float)n2 / 2.0f, (float)n2 / 2.0f);
        Point2D.Double double_2 = null;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (d = Math.PI * 2; d >= 0.0; d -= Math.PI / 180) {
            Line2D.Double double_3;
            Point2D.Double double_4;
            Point2D.Double double_5;
            graphics2D.setStroke(basicStroke);
            d2 = Math.sin(d);
            d3 = Math.cos(d);
            graphics2D.setColor(color2);
            if (n6 == 5) {
                graphics2D.setStroke(basicStroke);
                double_5 = new Point2D.Double(((Point2D)double_).getX() + (double)(f5 - f2) * d2, ((Point2D)double_).getY() + (double)(f5 - f2) * d3);
                double_4 = new Point2D.Double(((Point2D)double_).getX() + (double)f5 * d2, ((Point2D)double_).getY() + (double)f5 * d3);
                double_3 = new Line2D.Double(((Point2D)double_5).getX(), ((Point2D)double_5).getY(), ((Point2D)double_4).getX(), ((Point2D)double_4).getY());
                graphics2D.draw(double_3);
                n6 = 0;
            }
            if (n5 == 15) {
                graphics2D.setStroke(basicStroke);
                graphics2D.setColor(color2);
                double_5 = new Point2D.Double(((Point2D)double_).getX() + (double)(f5 - f3) * d2, ((Point2D)double_).getY() + (double)(f5 - f3) * d3);
                double_4 = new Point2D.Double(((Point2D)double_).getX() + (double)f5 * d2, ((Point2D)double_).getY() + (double)f5 * d3);
                double_3 = new Line2D.Double(((Point2D)double_5).getX(), ((Point2D)double_5).getY(), ((Point2D)double_4).getX(), ((Point2D)double_4).getY());
                graphics2D.draw(double_3);
                n5 = 0;
                n3 += 15;
            }
            if (n4 == 30) {
                graphics2D.setStroke(basicStroke);
                graphics2D.setColor(color3);
                double_5 = new Point2D.Double(((Point2D)double_).getX(), ((Point2D)double_).getY());
                double_4 = new Point2D.Double(((Point2D)double_).getX() + (double)(f5 - f * 1.5f) * d2, ((Point2D)double_).getY() + (double)(f5 - f * 1.5f) * d3);
                double_3 = new Line2D.Double(((Point2D)double_5).getX(), ((Point2D)double_5).getY(), ((Point2D)double_4).getX(), ((Point2D)double_4).getY());
                graphics2D.draw(double_3);
                n4 = 0;
                n3 += 30;
            }
            if (n3 == 90) {
                graphics2D.setStroke(basicStroke);
                double_5 = new Point2D.Double(((Point2D)double_).getX() + (double)(f5 - f4) * d2, ((Point2D)double_).getY() + (double)(f5 - f4) * d3);
                double_4 = new Point2D.Double(((Point2D)double_).getX() + (double)f5 * d2, ((Point2D)double_).getY() + (double)f5 * d3);
                graphics2D.setColor(color2);
                double_3 = new Line2D.Double(((Point2D)double_5).getX(), ((Point2D)double_5).getY(), ((Point2D)double_4).getX(), ((Point2D)double_4).getY());
                graphics2D.draw(double_3);
                n3 = 0;
            }
            graphics2D.setFont(font);
            graphics2D.setColor(color);
            double_2 = new Point2D.Double(((Point2D)double_).getX() + (double)(f5 - f) * d2, ((Point2D)double_).getY() + (double)(f5 - f) * d3);
            if (n7 != 360 && n7 % 30 == 0) {
                graphics2D.rotate(Math.toRadians(180.0), ((Point2D)double_).getX(), ((Point2D)double_).getY());
                graphics2D.fill(UTIL.rotateTextAroundCenter(graphics2D, String.valueOf(n7), (int)((Point2D)double_2).getX(), (int)((Point2D)double_2).getY(), Math.PI - d));
            }
            graphics2D.setTransform(affineTransform);
            ++n6;
            ++n5;
            ++n4;
            ++n7;
        }
        d = (double)f5 / 5.0;
        for (int i = 1; i < 6; ++i) {
            graphics2D.setColor(color3);
            graphics2D.draw(new Ellipse2D.Double(((Point2D)double_).getX() - (double)i * d, ((Point2D)double_).getY() - (double)i * d, (double)(i * 2) * d, (double)(i * 2) * d));
            if (i >= 5) continue;
            graphics2D.setColor(color2);
            graphics2D.drawString(String.valueOf((int)(this.range / 5000.0 * (double)i)), (int)((Point2D)double_).getX() + 2, (int)(((Point2D)double_).getY() - d * (double)i - 1.0));
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_BEAM_Image(int n) {
        if (n <= 0) {
            return null;
        }
        BufferedImage bufferedImage = UTIL.createImage(n, n, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        Point2D.Double double_ = new Point2D.Double((double)n2 / 2.0, (double)n3 / 2.0);
        float[] fArray = new float[]{0.0f, 0.001f, 180.0f, 360.0f};
        Color[] colorArray = new Color[]{new Color(55, 178, 72, 100), new Color(0.0f, 0.5f, 0.0f, 0.0f), new Color(0.0f, 0.5f, 0.0f, 0.0f), new Color(55, 178, 72, 100)};
        Ellipse2D.Double double_2 = new Ellipse2D.Double((double)n2 * 0.08411215245723724, (double)n3 * 0.08411215245723724, (double)n2 * 0.8317756652832031, (double)n3 * 0.8317756652832031);
        ConicalGradientPaint conicalGradientPaint = new ConicalGradientPaint(true, double_, 0.0f, fArray, colorArray);
        graphics2D.setPaint(conicalGradientPaint);
        graphics2D.fill(double_2);
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    @Override
    public String toString() {
        return "Radar";
    }
}

