/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.extras;

import eu.hansolo.steelseries.gauges.AbstractGauge;
import eu.hansolo.steelseries.gauges.AbstractRadial;
import eu.hansolo.steelseries.tools.BackgroundColor;
import eu.hansolo.steelseries.tools.ColorDef;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.Timer;
import javax.swing.border.Border;

public class StopWatch
extends AbstractRadial
implements ActionListener {
    private static final double ANGLE_STEP = 6.0;
    private final Timer CLOCK_TIMER;
    private double minutePointerAngle = 0.0;
    private double secondPointerAngle = 0.0;
    private final Rectangle INNER_BOUNDS;
    private final Point2D MAIN_CENTER = new Point2D.Double();
    private final Point2D SMALL_CENTER = new Point2D.Double();
    private BufferedImage bImage;
    private BufferedImage fImage;
    private BufferedImage smallTickmarkImage;
    private BufferedImage mainPointerImage;
    private BufferedImage mainPointerShadowImage;
    private BufferedImage smallPointerImage;
    private BufferedImage smallPointerShadowImage;
    private BufferedImage disabledImage;
    private long start = 0L;
    private long currentMilliSeconds = 0L;
    private long minutes = 0L;
    private long seconds = 0L;
    private long milliSeconds = 0L;
    private boolean running = false;
    private boolean flatNeedle = false;
    private final Color SHADOW_COLOR = new Color(0.0f, 0.0f, 0.0f, 0.65f);

    public StopWatch() {
        this.CLOCK_TIMER = new Timer(100, this);
        this.INNER_BOUNDS = new Rectangle(200, 200);
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
        this.setPointerColor(ColorDef.BLACK);
        this.setBackgroundColor(BackgroundColor.LIGHT_GRAY);
    }

    @Override
    public AbstractGauge init(int n, int n2) {
        if (n <= 1 || n2 <= 1) {
            return this;
        }
        if (!this.isFrameVisible()) {
            this.setFramelessOffset((double)(-this.getInnerBounds().width) * 0.0841121495, (double)(-this.getInnerBounds().width) * 0.0841121495);
        } else {
            this.setFramelessOffset(this.getInnerBounds().x, this.getInnerBounds().y);
        }
        if (this.bImage != null) {
            this.bImage.flush();
        }
        this.bImage = UTIL.createImage(n, n, 3);
        if (this.fImage != null) {
            this.fImage.flush();
        }
        this.fImage = UTIL.createImage(n, n, 3);
        if (this.isFrameVisible()) {
            switch (this.getFrameType()) {
                case SQUARE: {
                    FRAME_FACTORY.createLinearFrame(n, n, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect(), this.bImage);
                    break;
                }
                default: {
                    FRAME_FACTORY.createRadialFrame(n, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect(), this.bImage);
                }
            }
        }
        if (this.isBackgroundVisible()) {
            switch (this.getFrameType()) {
                case SQUARE: {
                    BACKGROUND_FACTORY.createLinearBackground(n, n, this.getBackgroundColor(), this.getCustomBackground(), this.getModel().getTextureColor(), this.bImage);
                    break;
                }
                default: {
                    BACKGROUND_FACTORY.createRadialBackground(n, this.getBackgroundColor(), this.getCustomBackground(), this.getModel().getTextureColor(), this.bImage);
                }
            }
        }
        this.create_TICKMARKS_Image(n, 60.0f, 0.075, 0.14, this.bImage);
        if (this.smallTickmarkImage != null) {
            this.smallTickmarkImage.flush();
        }
        this.smallTickmarkImage = this.create_TICKMARKS_Image((int)(0.285 * (double)n), 30.0f, 0.095, 0.17, null);
        if (this.mainPointerImage != null) {
            this.mainPointerImage.flush();
        }
        this.mainPointerImage = this.create_MAIN_POINTER_Image(n);
        if (this.mainPointerShadowImage != null) {
            this.mainPointerShadowImage.flush();
        }
        this.mainPointerShadowImage = this.create_MAIN_POINTER_SHADOW_Image(n);
        if (this.smallPointerImage != null) {
            this.smallPointerImage.flush();
        }
        this.smallPointerImage = this.create_SMALL_POINTER_Image(n);
        if (this.smallPointerShadowImage != null) {
            this.smallPointerShadowImage.flush();
        }
        this.smallPointerShadowImage = this.create_SMALL_POINTER_SHADOW_Image(n);
        if (this.isForegroundVisible()) {
            switch (this.getFrameType()) {
                case SQUARE: {
                    FOREGROUND_FACTORY.createLinearForeground(n, n, false, this.bImage);
                    break;
                }
                default: {
                    FOREGROUND_FACTORY.createRadialForeground(n, false, this.getForegroundType(), this.fImage);
                }
            }
        }
        if (this.disabledImage != null) {
            this.disabledImage.flush();
        }
        this.disabledImage = DISABLED_FACTORY.createRadialDisabled(n);
        return this;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        this.MAIN_CENTER.setLocation(this.INNER_BOUNDS.getCenterX(), this.INNER_BOUNDS.getCenterX());
        this.SMALL_CENTER.setLocation(this.INNER_BOUNDS.getCenterX(), (double)this.INNER_BOUNDS.width * 0.3130841121);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.translate(this.getFramelessOffset().getX(), this.getFramelessOffset().getY());
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.drawImage((Image)this.bImage, 0, 0, null);
        graphics2D.drawImage((Image)this.smallTickmarkImage, (this.INNER_BOUNDS.width - this.smallTickmarkImage.getWidth()) / 2, (int)(this.SMALL_CENTER.getY() - (double)this.smallTickmarkImage.getHeight() / 2.0), null);
        graphics2D.rotate(Math.toRadians(this.minutePointerAngle + 2.0 * Math.sin(Math.toRadians(this.minutePointerAngle))), this.SMALL_CENTER.getX(), this.SMALL_CENTER.getY());
        graphics2D.drawImage((Image)this.smallPointerShadowImage, 0, 0, null);
        graphics2D.setTransform(affineTransform);
        graphics2D.rotate(Math.toRadians(this.minutePointerAngle), this.SMALL_CENTER.getX(), this.SMALL_CENTER.getY());
        graphics2D.drawImage((Image)this.smallPointerImage, 0, 0, null);
        graphics2D.setTransform(affineTransform);
        graphics2D.rotate(Math.toRadians(this.secondPointerAngle + 2.0 * Math.sin(Math.toRadians(this.secondPointerAngle))), this.MAIN_CENTER.getX(), this.MAIN_CENTER.getY());
        graphics2D.drawImage((Image)this.mainPointerShadowImage, 0, 0, null);
        graphics2D.setTransform(affineTransform);
        graphics2D.rotate(Math.toRadians(this.secondPointerAngle), this.MAIN_CENTER.getX(), this.MAIN_CENTER.getY());
        graphics2D.drawImage((Image)this.mainPointerImage, 0, 0, null);
        graphics2D.setTransform(affineTransform);
        graphics2D.drawImage((Image)this.fImage, 0, 0, null);
        if (!this.isEnabled()) {
            graphics2D.drawImage((Image)this.disabledImage, 0, 0, null);
        }
        graphics2D.translate(-this.getInnerBounds().x, -this.getInnerBounds().y);
        graphics2D.dispose();
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean bl) {
        this.running = bl;
        if (bl) {
            if (!this.CLOCK_TIMER.isRunning()) {
                this.CLOCK_TIMER.start();
                this.start = System.currentTimeMillis();
                this.repaint(this.INNER_BOUNDS);
            }
        } else if (this.CLOCK_TIMER.isRunning()) {
            this.CLOCK_TIMER.stop();
        }
    }

    public void start() {
        this.setRunning(true);
    }

    public void stop() {
        this.setRunning(false);
    }

    public void reset() {
        this.setRunning(false);
        this.start = 0L;
        this.repaint(this.INNER_BOUNDS);
    }

    public String getMeasuredTime() {
        return this.minutes + ":" + this.seconds + ":" + this.milliSeconds;
    }

    public boolean isFlatNeedle() {
        return this.flatNeedle;
    }

    public void setFlatNeedle(boolean bl) {
        this.flatNeedle = bl;
        this.init(this.getWidth(), this.getWidth());
        this.repaint(this.INNER_BOUNDS);
    }

    @Override
    public Point2D getCenter() {
        return new Point2D.Double((double)this.bImage.getWidth() / 2.0 + (double)this.getInnerBounds().x, (double)this.bImage.getHeight() / 2.0 + (double)this.getInnerBounds().y);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return new Rectangle2D.Double(this.bImage.getMinX(), this.bImage.getMinY(), this.bImage.getWidth(), this.bImage.getHeight());
    }

    @Override
    public Rectangle getLcdBounds() {
        return new Rectangle();
    }

    private BufferedImage create_TICKMARKS_Image(int n, float f, double d, double d2, BufferedImage bufferedImage) {
        if (n <= 0) {
            return null;
        }
        if (bufferedImage == null) {
            bufferedImage = UTIL.createImage(n, n, 3);
        }
        FontRenderContext fontRenderContext = new FontRenderContext(null, true, true);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        Font font = new Font("Verdana", 0, (int)(d * (double)n));
        BasicStroke basicStroke = new BasicStroke(0.5f, 1, 2);
        BasicStroke basicStroke2 = new BasicStroke(1.0f, 1, 2);
        BasicStroke basicStroke3 = new BasicStroke(1.5f, 1, 2);
        int n4 = (int)(d2 * (double)n);
        int n5 = (int)(0.025 * (double)n);
        int n6 = (int)(0.035 * (double)n);
        int n7 = (int)(0.045 * (double)n);
        Color color = this.getBackgroundColor().LABEL_COLOR;
        Color color2 = this.getBackgroundColor().LABEL_COLOR;
        float f2 = (float)n2 * 0.4f;
        Point2D.Double double_ = new Point2D.Double((float)n2 / 2.0f, (float)n3 / 2.0f);
        Point2D.Double double_2 = null;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        graphics2D.setFont(font);
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = Math.PI * 2 / (double)f;
        double d6 = -Math.PI;
        float f3 = 0.0f;
        while (Float.compare(f3, f + 1.0f) <= 0) {
            Line2D.Double double_3;
            Point2D.Double double_4;
            Point2D.Double double_5;
            graphics2D.setStroke(basicStroke);
            d3 = Math.sin(d6);
            d4 = Math.cos(d6);
            if (n8 % 2 == 0) {
                graphics2D.setStroke(basicStroke);
                double_5 = new Point2D.Double(((Point2D)double_).getX() + (double)(f2 - (float)n5) * d3, ((Point2D)double_).getY() + (double)(f2 - (float)n5) * d4);
                double_4 = new Point2D.Double(((Point2D)double_).getX() + (double)f2 * d3, ((Point2D)double_).getY() + (double)f2 * d4);
                graphics2D.setColor(color2);
                double_3 = new Line2D.Double(((Point2D)double_5).getX(), ((Point2D)double_5).getY(), ((Point2D)double_4).getX(), ((Point2D)double_4).getY());
                graphics2D.draw(double_3);
            }
            if (n8 == 10 || n8 == 0) {
                graphics2D.setColor(color);
                graphics2D.setStroke(basicStroke2);
                double_4 = new Point2D.Double(((Point2D)double_).getX() + (double)f2 * d3, ((Point2D)double_).getY() + (double)f2 * d4);
                double_2 = new Point2D.Double(((Point2D)double_).getX() + (double)(f2 - (float)n4 + (float)font.getSize() / 2.0f) * d3, ((Point2D)double_).getY() + (double)(f2 - (float)n4 + (float)font.getSize() / 2.0f) * d4 + (double)((float)n4 / 2.5f));
                if (n9 == 5) {
                    TextLayout textLayout = new TextLayout(String.valueOf(Math.round(f3)), graphics2D.getFont(), fontRenderContext);
                    Rectangle2D rectangle2D = textLayout.getBounds();
                    if (Float.compare(f3, f) != 0 && Math.ceil(f3) != 60.0) {
                        graphics2D.drawString(String.valueOf(Math.round(f3)), (int)(((Point2D)double_2).getX() - rectangle2D.getWidth() / 2.0), (int)(((Point2D)double_2).getY() - rectangle2D.getHeight() / 2.0));
                    }
                    graphics2D.setStroke(basicStroke3);
                    double_5 = new Point2D.Double(((Point2D)double_).getX() + (double)(f2 - (float)n7) * d3, ((Point2D)double_).getY() + (double)(f2 - (float)n7) * d4);
                    n9 = 0;
                } else {
                    graphics2D.setStroke(basicStroke2);
                    double_5 = new Point2D.Double(((Point2D)double_).getX() + (double)(f2 - (float)n6) * d3, ((Point2D)double_).getY() + (double)(f2 - (float)n6) * d4);
                }
                graphics2D.setColor(color2);
                double_3 = new Line2D.Double(((Point2D)double_5).getX(), ((Point2D)double_5).getY(), ((Point2D)double_4).getX(), ((Point2D)double_4).getY());
                graphics2D.draw(double_3);
                n8 = 0;
                ++n10;
                ++n9;
            }
            ++n8;
            d6 -= d5 * 0.1;
            f3 += 0.1f;
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_MAIN_POINTER_Image(int n) {
        Color[] colorArray;
        Object[] objectArray;
        Object object;
        Point2D.Double double_;
        Cloneable cloneable;
        if (n <= 0) {
            return null;
        }
        BufferedImage bufferedImage = UTIL.createImage(n, n, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n2 * 0.5093457943925234, (double)n3 * 0.45794392523364486);
        generalPath.lineTo((double)n2 * 0.5, (double)n3 * 0.102803738317757);
        generalPath.lineTo((double)n2 * 0.49065420560747663, (double)n3 * 0.45794392523364486);
        generalPath.curveTo((double)n2 * 0.49065420560747663, (double)n3 * 0.45794392523364486, (double)n2 * 0.49065420560747663, (double)n3 * 0.45794392523364486, (double)n2 * 0.49065420560747663, (double)n3 * 0.45794392523364486);
        generalPath.curveTo((double)n2 * 0.4719626168224299, (double)n3 * 0.46261682242990654, (double)n2 * 0.45794392523364486, (double)n3 * 0.48130841121495327, (double)n2 * 0.45794392523364486, (double)n3 * 0.5);
        generalPath.curveTo((double)n2 * 0.45794392523364486, (double)n3 * 0.5186915887850467, (double)n2 * 0.4719626168224299, (double)n3 * 0.5373831775700935, (double)n2 * 0.49065420560747663, (double)n3 * 0.5420560747663551);
        generalPath.curveTo((double)n2 * 0.49065420560747663, (double)n3 * 0.5420560747663551, (double)n2 * 0.49065420560747663, (double)n3 * 0.5420560747663551, (double)n2 * 0.49065420560747663, (double)n3 * 0.5420560747663551);
        generalPath.lineTo((double)n2 * 0.49065420560747663, (double)n3 * 0.6214953271028038);
        generalPath.lineTo((double)n2 * 0.5093457943925234, (double)n3 * 0.6214953271028038);
        generalPath.lineTo((double)n2 * 0.5093457943925234, (double)n3 * 0.5420560747663551);
        generalPath.curveTo((double)n2 * 0.5093457943925234, (double)n3 * 0.5420560747663551, (double)n2 * 0.5093457943925234, (double)n3 * 0.5420560747663551, (double)n2 * 0.5093457943925234, (double)n3 * 0.5420560747663551);
        generalPath.curveTo((double)n2 * 0.5280373831775701, (double)n3 * 0.5373831775700935, (double)n2 * 0.5420560747663551, (double)n3 * 0.5186915887850467, (double)n2 * 0.5420560747663551, (double)n3 * 0.5);
        generalPath.curveTo((double)n2 * 0.5420560747663551, (double)n3 * 0.48130841121495327, (double)n2 * 0.5280373831775701, (double)n3 * 0.46261682242990654, (double)n2 * 0.5093457943925234, (double)n3 * 0.45794392523364486);
        generalPath.curveTo((double)n2 * 0.5093457943925234, (double)n3 * 0.45794392523364486, (double)n2 * 0.5093457943925234, (double)n3 * 0.45794392523364486, (double)n2 * 0.5093457943925234, (double)n3 * 0.45794392523364486);
        generalPath.closePath();
        if (this.flatNeedle) {
            graphics2D.setColor(this.getPointerColor().MEDIUM);
            graphics2D.fill(generalPath);
        } else {
            cloneable = new Point2D.Double(generalPath.getBounds2D().getMinX(), 0.0);
            double_ = new Point2D.Double(generalPath.getBounds2D().getMaxX(), 0.0);
            object = new float[]{0.0f, 0.3888889f, 0.5f, 0.6111111f, 1.0f};
            objectArray = new Color[]{this.getPointerColor().MEDIUM, this.getPointerColor().MEDIUM, this.getPointerColor().LIGHT, this.getPointerColor().MEDIUM, this.getPointerColor().MEDIUM};
            colorArray = new LinearGradientPaint((Point2D)cloneable, double_, (float[])object, (Color[])objectArray);
            graphics2D.setPaint((Paint)colorArray);
            graphics2D.fill(generalPath);
            graphics2D.setPaint(this.getPointerColor().DARK);
            graphics2D.draw(generalPath);
        }
        cloneable = new Ellipse2D.Double((double)n2 * 0.4672897160053253, (double)n3 * 0.4672897160053253, (double)n2 * 0.06542053818702698, (double)n3 * 0.06542053818702698);
        double_ = new Point2D.Double(0.0, cloneable.getBounds2D().getMaxY());
        object = new Point2D.Double(0.0, cloneable.getBounds2D().getMinY());
        objectArray = new float[]{0.0f, 0.01f, 0.99f, 1.0f};
        colorArray = new Color[]{new Color(230, 179, 92, 255), new Color(230, 179, 92, 255), new Color(196, 130, 0, 255), new Color(196, 130, 0, 255)};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, (Point2D)object, (float[])objectArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill((Shape)((Object)cloneable));
        Ellipse2D.Double double_2 = new Ellipse2D.Double((double)n2 * 0.47663551568984985, (double)n3 * 0.47663551568984985, (double)n2 * 0.04672896862030029, (double)n3 * 0.04672896862030029);
        Point2D.Double double_3 = new Point2D.Double(0.5 * (double)n2, 0.5 * (double)n3);
        float[] fArray = new float[]{0.0f, 0.19f, 0.22f, 0.8f, 0.99f, 1.0f};
        Color[] colorArray2 = new Color[]{new Color(197, 197, 197, 255), new Color(197, 197, 197, 255), new Color(0, 0, 0, 255), new Color(0, 0, 0, 255), new Color(112, 112, 112, 255), new Color(112, 112, 112, 255)};
        RadialGradientPaint radialGradientPaint = new RadialGradientPaint(double_3, (float)(0.02336448598130841 * (double)n2), fArray, colorArray2);
        graphics2D.setPaint(radialGradientPaint);
        graphics2D.fill(double_2);
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_MAIN_POINTER_SHADOW_Image(int n) {
        if (n <= 0) {
            return null;
        }
        BufferedImage bufferedImage = UTIL.createImage(n, n, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n2 * 0.5093457943925234, (double)n3 * 0.45794392523364486);
        generalPath.lineTo((double)n2 * 0.5, (double)n3 * 0.102803738317757);
        generalPath.lineTo((double)n2 * 0.49065420560747663, (double)n3 * 0.45794392523364486);
        generalPath.curveTo((double)n2 * 0.49065420560747663, (double)n3 * 0.45794392523364486, (double)n2 * 0.49065420560747663, (double)n3 * 0.45794392523364486, (double)n2 * 0.49065420560747663, (double)n3 * 0.45794392523364486);
        generalPath.curveTo((double)n2 * 0.4719626168224299, (double)n3 * 0.46261682242990654, (double)n2 * 0.45794392523364486, (double)n3 * 0.48130841121495327, (double)n2 * 0.45794392523364486, (double)n3 * 0.5);
        generalPath.curveTo((double)n2 * 0.45794392523364486, (double)n3 * 0.5186915887850467, (double)n2 * 0.4719626168224299, (double)n3 * 0.5373831775700935, (double)n2 * 0.49065420560747663, (double)n3 * 0.5420560747663551);
        generalPath.curveTo((double)n2 * 0.49065420560747663, (double)n3 * 0.5420560747663551, (double)n2 * 0.49065420560747663, (double)n3 * 0.5420560747663551, (double)n2 * 0.49065420560747663, (double)n3 * 0.5420560747663551);
        generalPath.lineTo((double)n2 * 0.49065420560747663, (double)n3 * 0.6214953271028038);
        generalPath.lineTo((double)n2 * 0.5093457943925234, (double)n3 * 0.6214953271028038);
        generalPath.lineTo((double)n2 * 0.5093457943925234, (double)n3 * 0.5420560747663551);
        generalPath.curveTo((double)n2 * 0.5093457943925234, (double)n3 * 0.5420560747663551, (double)n2 * 0.5093457943925234, (double)n3 * 0.5420560747663551, (double)n2 * 0.5093457943925234, (double)n3 * 0.5420560747663551);
        generalPath.curveTo((double)n2 * 0.5280373831775701, (double)n3 * 0.5373831775700935, (double)n2 * 0.5420560747663551, (double)n3 * 0.5186915887850467, (double)n2 * 0.5420560747663551, (double)n3 * 0.5);
        generalPath.curveTo((double)n2 * 0.5420560747663551, (double)n3 * 0.48130841121495327, (double)n2 * 0.5280373831775701, (double)n3 * 0.46261682242990654, (double)n2 * 0.5093457943925234, (double)n3 * 0.45794392523364486);
        generalPath.curveTo((double)n2 * 0.5093457943925234, (double)n3 * 0.45794392523364486, (double)n2 * 0.5093457943925234, (double)n3 * 0.45794392523364486, (double)n2 * 0.5093457943925234, (double)n3 * 0.45794392523364486);
        generalPath.closePath();
        graphics2D.setPaint(this.SHADOW_COLOR);
        graphics2D.fill(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_SMALL_POINTER_Image(int n) {
        Object object;
        Cloneable cloneable;
        Cloneable cloneable2;
        if (n <= 0) {
            return null;
        }
        BufferedImage bufferedImage = UTIL.createImage(n, n, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n2 * 0.4766355140186916, (double)n3 * 0.3130841121495327);
        generalPath.curveTo((double)n2 * 0.4766355140186916, (double)n3 * 0.32242990654205606, (double)n2 * 0.48598130841121495, (double)n3 * 0.3317757009345794, (double)n2 * 0.4953271028037383, (double)n3 * 0.3364485981308411);
        generalPath.curveTo((double)n2 * 0.4953271028037383, (double)n3 * 0.3364485981308411, (double)n2 * 0.4953271028037383, (double)n3 * 0.35046728971962615, (double)n2 * 0.4953271028037383, (double)n3 * 0.35046728971962615);
        generalPath.lineTo((double)n2 * 0.5046728971962616, (double)n3 * 0.35046728971962615);
        generalPath.curveTo((double)n2 * 0.5046728971962616, (double)n3 * 0.35046728971962615, (double)n2 * 0.5046728971962616, (double)n3 * 0.3364485981308411, (double)n2 * 0.5046728971962616, (double)n3 * 0.3364485981308411);
        generalPath.curveTo((double)n2 * 0.514018691588785, (double)n3 * 0.3317757009345794, (double)n2 * 0.5233644859813084, (double)n3 * 0.32242990654205606, (double)n2 * 0.5233644859813084, (double)n3 * 0.3130841121495327);
        generalPath.curveTo((double)n2 * 0.5233644859813084, (double)n3 * 0.3037383177570093, (double)n2 * 0.514018691588785, (double)n3 * 0.29439252336448596, (double)n2 * 0.5046728971962616, (double)n3 * 0.2897196261682243);
        generalPath.curveTo((double)n2 * 0.5046728971962616, (double)n3 * 0.2897196261682243, (double)n2 * 0.5, (double)n3 * 0.20093457943925233, (double)n2 * 0.5, (double)n3 * 0.20093457943925233);
        generalPath.curveTo((double)n2 * 0.5, (double)n3 * 0.20093457943925233, (double)n2 * 0.4953271028037383, (double)n3 * 0.2897196261682243, (double)n2 * 0.4953271028037383, (double)n3 * 0.2897196261682243);
        generalPath.curveTo((double)n2 * 0.48598130841121495, (double)n3 * 0.29439252336448596, (double)n2 * 0.4766355140186916, (double)n3 * 0.3037383177570093, (double)n2 * 0.4766355140186916, (double)n3 * 0.3130841121495327);
        generalPath.closePath();
        if (this.flatNeedle) {
            graphics2D.setColor(this.getPointerColor().MEDIUM);
            graphics2D.fill(generalPath);
        } else {
            cloneable2 = new Point2D.Double(generalPath.getBounds2D().getMinX(), 0.0);
            cloneable = new Point2D.Double(generalPath.getBounds2D().getMaxX(), 0.0);
            object = new float[]{0.0f, 0.3888889f, 0.5f, 0.6111111f, 1.0f};
            Color[] colorArray = new Color[]{this.getPointerColor().MEDIUM, this.getPointerColor().MEDIUM, this.getPointerColor().LIGHT, this.getPointerColor().MEDIUM, this.getPointerColor().MEDIUM};
            LinearGradientPaint linearGradientPaint = new LinearGradientPaint((Point2D)cloneable2, (Point2D)cloneable, (float[])object, colorArray);
            graphics2D.setPaint(linearGradientPaint);
            graphics2D.fill(generalPath);
            graphics2D.setPaint(this.getPointerColor().DARK);
            graphics2D.draw(generalPath);
        }
        cloneable2 = new Ellipse2D.Double((double)n2 * 0.4813084006309509, (double)n3 * 0.29439252614974976, (double)n2 * (double)0.0373832f, (double)n3 * 0.03738316893577576);
        graphics2D.setColor(new Color(12878336));
        graphics2D.fill((Shape)((Object)cloneable2));
        cloneable = new Ellipse2D.Double((double)n2 * 0.4859813153743744, (double)n3 * (double)0.2990654f, (double)n2 * 0.02803739905357361, (double)n3 * 0.02803739905357361);
        graphics2D.setColor(new Color(0x999999));
        graphics2D.fill((Shape)((Object)cloneable));
        object = new Ellipse2D.Double((double)n2 * (double)0.4906542f, (double)n3 * 0.3037383258342743, (double)n2 * (double)0.01869157f, (double)n3 * (double)0.01869157f);
        graphics2D.setColor(Color.BLACK);
        graphics2D.fill((Shape)object);
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_SMALL_POINTER_SHADOW_Image(int n) {
        if (n <= 0) {
            return null;
        }
        BufferedImage bufferedImage = UTIL.createImage(n, n, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n2 * 0.4766355140186916, (double)n3 * 0.3130841121495327);
        generalPath.curveTo((double)n2 * 0.4766355140186916, (double)n3 * 0.32242990654205606, (double)n2 * 0.48598130841121495, (double)n3 * 0.3317757009345794, (double)n2 * 0.4953271028037383, (double)n3 * 0.3364485981308411);
        generalPath.curveTo((double)n2 * 0.4953271028037383, (double)n3 * 0.3364485981308411, (double)n2 * 0.4953271028037383, (double)n3 * 0.35046728971962615, (double)n2 * 0.4953271028037383, (double)n3 * 0.35046728971962615);
        generalPath.lineTo((double)n2 * 0.5046728971962616, (double)n3 * 0.35046728971962615);
        generalPath.curveTo((double)n2 * 0.5046728971962616, (double)n3 * 0.35046728971962615, (double)n2 * 0.5046728971962616, (double)n3 * 0.3364485981308411, (double)n2 * 0.5046728971962616, (double)n3 * 0.3364485981308411);
        generalPath.curveTo((double)n2 * 0.514018691588785, (double)n3 * 0.3317757009345794, (double)n2 * 0.5233644859813084, (double)n3 * 0.32242990654205606, (double)n2 * 0.5233644859813084, (double)n3 * 0.3130841121495327);
        generalPath.curveTo((double)n2 * 0.5233644859813084, (double)n3 * 0.3037383177570093, (double)n2 * 0.514018691588785, (double)n3 * 0.29439252336448596, (double)n2 * 0.5046728971962616, (double)n3 * 0.2897196261682243);
        generalPath.curveTo((double)n2 * 0.5046728971962616, (double)n3 * 0.2897196261682243, (double)n2 * 0.5, (double)n3 * 0.20093457943925233, (double)n2 * 0.5, (double)n3 * 0.20093457943925233);
        generalPath.curveTo((double)n2 * 0.5, (double)n3 * 0.20093457943925233, (double)n2 * 0.4953271028037383, (double)n3 * 0.2897196261682243, (double)n2 * 0.4953271028037383, (double)n3 * 0.2897196261682243);
        generalPath.curveTo((double)n2 * 0.48598130841121495, (double)n3 * 0.29439252336448596, (double)n2 * 0.4766355140186916, (double)n3 * 0.3037383177570093, (double)n2 * 0.4766355140186916, (double)n3 * 0.3130841121495327);
        generalPath.closePath();
        graphics2D.setPaint(this.SHADOW_COLOR);
        graphics2D.fill(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    public void calcInnerBounds() {
        int n;
        Insets insets = this.getInsets();
        int n2 = n = this.getWidth() - insets.left - insets.right <= this.getHeight() - insets.top - insets.bottom ? this.getWidth() - insets.left - insets.right : this.getHeight() - insets.top - insets.bottom;
        if (!this.isFrameVisible()) {
            this.INNER_BOUNDS.setBounds(insets.left, insets.top, (int)((double)n * 1.202247191), (int)((double)n * 1.202247191));
        } else {
            this.INNER_BOUNDS.setBounds(insets.left, insets.top, n, n);
        }
    }

    @Override
    public Rectangle getInnerBounds() {
        return this.INNER_BOUNDS;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(200, 200);
    }

    @Override
    public void setPreferredSize(Dimension dimension) {
        int n = dimension.width <= dimension.height ? dimension.width : dimension.height;
        super.setPreferredSize(new Dimension(n, n));
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.setInitialized(true);
    }

    @Override
    public void setSize(int n, int n2) {
        int n3 = n <= n2 ? n : n2;
        super.setSize(n3, n3);
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.setInitialized(true);
    }

    @Override
    public void setSize(Dimension dimension) {
        int n = dimension.width <= dimension.height ? dimension.width : dimension.height;
        super.setSize(new Dimension(n, n));
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.setInitialized(true);
    }

    @Override
    public void setBounds(Rectangle rectangle) {
        int n = rectangle.width <= rectangle.height ? rectangle.width : rectangle.height;
        super.setBounds(rectangle.x, rectangle.y, n, n);
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.setInitialized(true);
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        int n5 = n3 <= n4 ? n3 : n4;
        super.setBounds(n, n2, n5, n5);
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.setInitialized(true);
    }

    @Override
    public void setBorder(Border border) {
        super.setBorder(border);
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public void dispose() {
        this.CLOCK_TIMER.removeActionListener(this);
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.CLOCK_TIMER)) {
            this.currentMilliSeconds = System.currentTimeMillis() - this.start;
            this.secondPointerAngle = (double)this.currentMilliSeconds * 6.0 / 1000.0;
            this.minutePointerAngle = this.secondPointerAngle % 1000.0 / 30.0;
            this.minutes = this.currentMilliSeconds % 60000L;
            this.seconds = this.currentMilliSeconds % 60L;
            this.milliSeconds = this.currentMilliSeconds % 1000L;
            this.repaint(this.INNER_BOUNDS);
        }
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        int n = this.getWidth() < this.getHeight() ? this.getWidth() : this.getHeight();
        this.setPreferredSize(new Dimension(n, n));
        if (n < this.getMinimumSize().width || n < this.getMinimumSize().height) {
            this.setPreferredSize(this.getMinimumSize());
        }
        this.calcInnerBounds();
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
    }

    @Override
    public String toString() {
        return "StopWatch";
    }
}

