/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.gauges;

import eu.hansolo.steelseries.gauges.AbstractLinear;
import eu.hansolo.steelseries.gauges.AbstractRadial;
import eu.hansolo.steelseries.tools.BackgroundColor;
import eu.hansolo.steelseries.tools.BackgroundImageFactory;
import eu.hansolo.steelseries.tools.ColorDef;
import eu.hansolo.steelseries.tools.CustomColorDef;
import eu.hansolo.steelseries.tools.CustomLedColor;
import eu.hansolo.steelseries.tools.DesignSet;
import eu.hansolo.steelseries.tools.DisabledImageFactory;
import eu.hansolo.steelseries.tools.ForegroundImageFactory;
import eu.hansolo.steelseries.tools.FrameDesign;
import eu.hansolo.steelseries.tools.FrameEffect;
import eu.hansolo.steelseries.tools.FrameImageFactory;
import eu.hansolo.steelseries.tools.GlowImageFactory;
import eu.hansolo.steelseries.tools.KnobImageFactory;
import eu.hansolo.steelseries.tools.LcdColor;
import eu.hansolo.steelseries.tools.LcdImageFactory;
import eu.hansolo.steelseries.tools.LedColor;
import eu.hansolo.steelseries.tools.LedImageFactory;
import eu.hansolo.steelseries.tools.Model;
import eu.hansolo.steelseries.tools.NumberFormat;
import eu.hansolo.steelseries.tools.Orientation;
import eu.hansolo.steelseries.tools.PointerImageFactory;
import eu.hansolo.steelseries.tools.Section;
import eu.hansolo.steelseries.tools.ThresholdType;
import eu.hansolo.steelseries.tools.TickmarkImageFactory;
import eu.hansolo.steelseries.tools.TickmarkType;
import eu.hansolo.steelseries.tools.Util;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public abstract class AbstractGauge
extends JComponent
implements ComponentListener,
ActionListener,
Serializable {
    private static final long serialVersionUID = 31269L;
    public static final String VALUE_PROPERTY = "value";
    private PropertyChangeSupport propertyChangeSupport;
    protected static final Util UTIL = Util.INSTANCE;
    protected static final FrameImageFactory FRAME_FACTORY = FrameImageFactory.INSTANCE;
    protected static final BackgroundImageFactory BACKGROUND_FACTORY = BackgroundImageFactory.INSTANCE;
    protected static final GlowImageFactory GLOW_FACTORY = GlowImageFactory.INSTANCE;
    protected static final TickmarkImageFactory TICKMARK_FACTORY = TickmarkImageFactory.INSTANCE;
    protected static final LcdImageFactory LCD_FACTORY = LcdImageFactory.INSTANCE;
    protected static final LedImageFactory LED_FACTORY = LedImageFactory.INSTANCE;
    protected static final KnobImageFactory KNOB_FACTORY = KnobImageFactory.INSTANCE;
    protected static final PointerImageFactory POINTER_FACTORY = PointerImageFactory.INSTANCE;
    protected static final ForegroundImageFactory FOREGROUND_FACTORY = ForegroundImageFactory.INSTANCE;
    protected static final DisabledImageFactory DISABLED_FACTORY = DisabledImageFactory.INSTANCE;
    private boolean initialized = false;
    private volatile Model model;
    private DesignSet design1;
    private DesignSet design2;
    private DesignSet activeDesign;
    private ChangeEvent changeEvent;
    private final EventListenerList LISTENER_LIST = new EventListenerList();
    protected static final String THRESHOLD_PROPERTY = "threshold";
    private final Timer GLOW_PULSE;
    private float glowAlpha = 1.0f;
    private double glowAlphaIncrement = -0.1;
    private double glowAlphaCounter = 1.0;
    private BufferedImage ledImageOff;
    private BufferedImage ledImageOn;
    private BufferedImage currentLedImage;
    private final Timer LED_BLINKING_TIMER;
    private boolean ledBlinking = false;
    private boolean ledOn = false;
    private BufferedImage userLedImageOff;
    private BufferedImage userLedImageOn;
    private BufferedImage currentUserLedImage;
    private final Timer USER_LED_BLINKING_TIMER;
    private boolean userLedBlinking = false;
    private boolean userLedOn = false;
    private final Timer PEAK_TIMER;
    private boolean customTickmarkLabelsEnabled = false;
    private ArrayList<Double> customTickmarkLabels;
    private String title = "Title";
    private String unitString = "unit";
    private Font titleAndUnitFont;
    private long stdTimeToValue = 800L;
    private long rtzTimeToValue = 800L;
    private long rtzTimeBackToZero = 1200L;
    private Orientation orientation;

    public AbstractGauge() {
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.model = new Model();
        this.design1 = new DesignSet.Builder().frameDesign(FrameDesign.METAL).frameEffect(FrameEffect.NONE).backgroundColor(BackgroundColor.DARK_GRAY).textureColor(new Color(0x686868)).color(ColorDef.RED).ledColor(LedColor.RED_LED).userLedColor(LedColor.RED_LED).lcdColor(LcdColor.STANDARD_LCD).glowColor(new Color(51, 255, 255)).build();
        this.design2 = new DesignSet.Builder().frameDesign(FrameDesign.METAL).frameEffect(FrameEffect.NONE).backgroundColor(BackgroundColor.WHITE).textureColor(new Color(0xC3C3C3)).color(ColorDef.RED).ledColor(LedColor.RED_LED).userLedColor(LedColor.RED_LED).lcdColor(LcdColor.STANDARD_LCD).glowColor(new Color(51, 255, 255)).build();
        this.activeDesign = this.design1;
        this.GLOW_PULSE = new Timer(50, this);
        this.ledImageOff = this.create_LED_Image(200, 0, this.model.getLedColor());
        this.ledImageOn = this.create_LED_Image(200, 1, this.model.getLedColor());
        this.currentLedImage = this.ledImageOff;
        this.LED_BLINKING_TIMER = new Timer(500, this);
        this.userLedImageOff = this.create_LED_Image(200, 0, this.model.getLedColor());
        this.userLedImageOn = this.create_LED_Image(200, 1, this.model.getLedColor());
        this.currentUserLedImage = this.userLedImageOff;
        this.USER_LED_BLINKING_TIMER = new Timer(500, this);
        this.PEAK_TIMER = new Timer(1000, this);
        this.customTickmarkLabels = new ArrayList(10);
        this.titleAndUnitFont = new Font("Verdana", 0, 10);
        this.orientation = Orientation.NORTH;
        this.addComponentListener(this);
    }

    public abstract AbstractGauge init(int var1, int var2);

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean bl) {
        this.initialized = bl;
    }

    public Model getModel() {
        return this.model;
    }

    public void setModel(Model model) {
        this.model = model;
        this.reInitialize();
    }

    public double getValue() {
        return this.model.getValue();
    }

    public void setValue(double d) {
        if (this.isEnabled()) {
            if (!this.isLogScale()) {
                this.model.setValue(d);
            } else if (d > 0.0) {
                this.model.setValue(d);
            } else {
                this.model.setValue(1.0);
            }
            if (!this.isAutoResetToZero()) {
                if (!this.model.isThresholdBehaviourInverted()) {
                    if (Double.compare(this.model.getValue(), this.model.getThreshold()) >= 0) {
                        if (!this.LED_BLINKING_TIMER.isRunning()) {
                            this.LED_BLINKING_TIMER.start();
                            this.propertyChangeSupport.firePropertyChange(THRESHOLD_PROPERTY, false, true);
                        }
                    } else {
                        this.LED_BLINKING_TIMER.stop();
                        this.setCurrentLedImage(this.getLedImageOff());
                    }
                } else if (Double.compare(this.model.getValue(), this.model.getThreshold()) <= 0) {
                    if (!this.LED_BLINKING_TIMER.isRunning()) {
                        this.LED_BLINKING_TIMER.start();
                        this.propertyChangeSupport.firePropertyChange(THRESHOLD_PROPERTY, false, true);
                    }
                } else {
                    this.LED_BLINKING_TIMER.stop();
                    this.setCurrentLedImage(this.getLedImageOff());
                }
            }
            this.repaint(this.getInnerBounds());
            this.fireStateChanged();
            this.propertyChangeSupport.firePropertyChange(VALUE_PROPERTY, this.model.getOldValue(), this.model.getValue());
        }
    }

    public double getMinValue() {
        return this.model.getNiceMinValue();
    }

    public void setMinValue(double d) {
        this.model.setMinValue(d);
        this.reInitialize();
    }

    public double getMaxValue() {
        return this.model.getNiceMaxValue();
    }

    public void setMaxValue(double d) {
        this.model.setMaxValue(d);
        this.reInitialize();
    }

    public double getPeakValue() {
        return this.model.getPeakValue();
    }

    public void setPeakValue(double d) {
        this.model.setPeakValue(d);
    }

    public boolean isPeakValueVisible() {
        return this.model.isPeakValueVisible();
    }

    public void setPeakValueVisible(boolean bl) {
        this.model.setPeakValueVisible(bl);
    }

    public boolean isAutoResetToZero() {
        return this.model.isAutoResetToZero();
    }

    public void setAutoResetToZero(boolean bl) {
        this.model.setAutoResetToZero(bl);
        if (this.model.isAutoResetToZero()) {
            this.setThresholdVisible(false);
            this.setLedVisible(false);
        }
    }

    public double getThreshold() {
        return this.model.getThreshold();
    }

    public void setThreshold(double d) {
        this.model.setThreshold(d);
        this.repaint(this.getInnerBounds());
    }

    public boolean isThresholdVisible() {
        return this.model.isThresholdVisible();
    }

    public void setThresholdVisible(boolean bl) {
        this.model.setThresholdVisible(bl);
        this.repaint(this.getInnerBounds());
    }

    public boolean isThresholdBehaviourInverted() {
        return this.model.isThresholdBehaviourInverted();
    }

    public void setThresholdBehaviourInverted(boolean bl) {
        this.model.setThresholdBehaviourInverted(bl);
        this.repaint(this.getInnerBounds());
    }

    public boolean isLedVisible() {
        return this.model.isLedVisible();
    }

    public void setLedVisible(boolean bl) {
        this.model.setLedVisible(bl);
        this.repaint(this.getInnerBounds());
    }

    public boolean isUserLedVisible() {
        return this.model.isUserLedVisible();
    }

    public void setUserLedVisible(boolean bl) {
        this.model.setUserLedVisible(bl);
        this.repaint(this.getInnerBounds());
    }

    public DesignSet getDesign1() {
        return this.design1;
    }

    public void setDesign1(DesignSet designSet) {
        this.design1 = designSet;
    }

    public DesignSet getDesign2() {
        return this.design2;
    }

    public void setDesign2(DesignSet designSet) {
        this.design2 = designSet;
    }

    public DesignSet getActiveDesign() {
        return this.activeDesign;
    }

    public void setActiveDesign(DesignSet designSet) {
        boolean bl;
        this.activeDesign = designSet;
        if (designSet.getOuterFrameColor() != null) {
            this.model.setOuterFrameColor(designSet.getOuterFrameColor());
        }
        if (designSet.getInnerFrameColor() != null) {
            this.model.setInnerFrameColor(designSet.getInnerFrameColor());
        }
        if (designSet.getFrameDesign() != null) {
            this.model.setFrameDesign(designSet.getFrameDesign());
        }
        if (designSet.getFrameEffect() != null) {
            this.model.setFrameEffect(designSet.getFrameEffect());
        }
        if (designSet.getTextureColor() != null) {
            this.model.setTextureColor(designSet.getTextureColor());
        }
        if (designSet.getBackgroundColor() != null) {
            this.model.setBackgroundColor(designSet.getBackgroundColor());
        }
        if (designSet.getColor() != null) {
            this.model.setPointerColor(designSet.getColor());
            this.model.setValueColor(designSet.getColor());
        }
        if (designSet.getLedColor() != null) {
            this.model.setLedColor(designSet.getLedColor());
            bl = this.currentLedImage.equals(this.ledImageOn);
            switch (this.getOrientation()) {
                case HORIZONTAL: {
                    this.recreateLedImages(this.getHeight());
                    break;
                }
                case VERTICAL: {
                    this.recreateLedImages(this.getWidth());
                    break;
                }
                default: {
                    this.recreateLedImages();
                }
            }
            if (this.currentLedImage != null) {
                this.currentLedImage.flush();
            }
            BufferedImage bufferedImage = this.currentLedImage = bl ? this.ledImageOn : this.ledImageOff;
        }
        if (designSet.getUserLedColor() != null) {
            this.model.setUserLedColor(designSet.getUserLedColor());
            bl = this.currentUserLedImage.equals(this.userLedImageOn);
            switch (this.getOrientation()) {
                case HORIZONTAL: {
                    this.recreateUserLedImages(this.getHeight());
                    break;
                }
                case VERTICAL: {
                    this.recreateUserLedImages(this.getWidth());
                    break;
                }
                default: {
                    this.recreateUserLedImages();
                }
            }
            if (this.currentUserLedImage != null) {
                this.currentUserLedImage.flush();
            }
            BufferedImage bufferedImage = this.currentUserLedImage = bl ? this.userLedImageOn : this.userLedImageOff;
        }
        if (designSet.getLcdColor() != null) {
            this.model.setLcdColor(designSet.getLcdColor());
        }
        if (designSet.getGlowColor() != null) {
            this.model.setGlowColor(designSet.getGlowColor());
        }
        if (designSet.getColor() != null) {
            this.model.setPointerColor(designSet.getColor());
        }
        if (designSet.getKnobStyle() != null) {
            this.model.setKnobStyle(designSet.getKnobStyle());
        }
        if (designSet.getColor() != null) {
            this.model.setValueColor(designSet.getColor());
        }
        this.reInitialize();
    }

    abstract void toggleDesign();

    abstract Point2D getLedPosition();

    abstract void setLedPosition(double var1, double var3);

    abstract Point2D getUserLedPosition();

    abstract void setUserLedPosition(double var1, double var3);

    public LedColor getLedColor() {
        return this.model.getLedColor();
    }

    public void setLedColor(LedColor ledColor) {
        this.model.setLedColor(ledColor);
        boolean bl = this.currentLedImage.equals(this.ledImageOn);
        switch (this.getOrientation()) {
            case HORIZONTAL: {
                this.recreateLedImages(this.getHeight());
                break;
            }
            case VERTICAL: {
                this.recreateLedImages(this.getWidth());
                break;
            }
            default: {
                this.recreateLedImages();
            }
        }
        if (this.currentLedImage != null) {
            this.currentLedImage.flush();
        }
        this.currentLedImage = bl ? this.ledImageOn : this.ledImageOff;
        this.repaint(this.getInnerBounds());
    }

    public Color getCustomLedColor() {
        return this.model.getCustomLedColor().COLOR;
    }

    public void setCustomLedColor(Color color) {
        this.model.setCustomLedColor(new CustomLedColor(color));
        boolean bl = this.currentLedImage.equals(this.ledImageOn);
        switch (this.getOrientation()) {
            case HORIZONTAL: {
                this.recreateLedImages(this.getHeight());
                break;
            }
            case VERTICAL: {
                this.recreateLedImages(this.getWidth());
                break;
            }
            default: {
                this.recreateLedImages();
            }
        }
        if (this.currentLedImage != null) {
            this.currentLedImage.flush();
        }
        this.currentLedImage = bl ? this.ledImageOn : this.ledImageOff;
        this.repaint(this.getInnerBounds());
    }

    public boolean isLedBlinking() {
        return this.ledBlinking;
    }

    public void setLedBlinking(boolean bl) {
        this.ledBlinking = bl;
        if (bl) {
            this.LED_BLINKING_TIMER.start();
        } else {
            this.setCurrentLedImage(this.getLedImageOff());
            this.LED_BLINKING_TIMER.stop();
        }
    }

    protected BufferedImage getLedImageOn() {
        return this.ledImageOn;
    }

    protected BufferedImage getLedImageOff() {
        return this.ledImageOff;
    }

    protected void recreateLedImages() {
        this.recreateLedImages(this.getInnerBounds().width);
    }

    protected void recreateLedImages(int n) {
        if (this.ledImageOff != null) {
            this.ledImageOff.flush();
        }
        this.ledImageOff = this.create_LED_Image(n, 0, this.model.getLedColor());
        if (this.ledImageOn != null) {
            this.ledImageOn.flush();
        }
        this.ledImageOn = this.create_LED_Image(n, 1, this.model.getLedColor());
    }

    protected BufferedImage getCurrentLedImage() {
        return this.currentLedImage;
    }

    protected void setCurrentLedImage(BufferedImage bufferedImage) {
        if (this.currentLedImage != null) {
            this.currentLedImage.flush();
        }
        this.currentLedImage = bufferedImage;
        this.repaint(this.getInnerBounds());
    }

    protected boolean isLedOn() {
        return this.ledOn;
    }

    public LedColor getUserLedColor() {
        return this.model.getUserLedColor();
    }

    public void setUserLedColor(LedColor ledColor) {
        this.model.setUserLedColor(ledColor);
        boolean bl = this.currentUserLedImage.equals(this.userLedImageOn);
        switch (this.getOrientation()) {
            case HORIZONTAL: {
                this.recreateUserLedImages(this.getHeight());
                break;
            }
            case VERTICAL: {
                this.recreateUserLedImages(this.getWidth());
                break;
            }
            default: {
                this.recreateUserLedImages();
            }
        }
        if (this.currentUserLedImage != null) {
            this.currentUserLedImage.flush();
        }
        this.currentUserLedImage = bl ? this.userLedImageOn : this.userLedImageOff;
        this.repaint(this.getInnerBounds());
    }

    public Color getCustomUserLedColor() {
        return this.model.getCustomUserLedColor().COLOR;
    }

    public void setCustomUserLedColor(Color color) {
        this.model.setCustomUserLedColor(new CustomLedColor(color));
        boolean bl = this.currentUserLedImage.equals(this.ledImageOn);
        switch (this.getOrientation()) {
            case HORIZONTAL: {
                this.recreateUserLedImages(this.getHeight());
                break;
            }
            case VERTICAL: {
                this.recreateUserLedImages(this.getWidth());
                break;
            }
            default: {
                this.recreateUserLedImages();
            }
        }
        if (this.currentUserLedImage != null) {
            this.currentUserLedImage.flush();
        }
        this.currentUserLedImage = bl ? this.userLedImageOn : this.userLedImageOff;
        this.repaint(this.getInnerBounds());
    }

    public boolean isUserLedBlinking() {
        return this.userLedBlinking;
    }

    public void setUserLedBlinking(boolean bl) {
        this.userLedBlinking = bl;
        if (bl) {
            this.USER_LED_BLINKING_TIMER.start();
        } else {
            this.setCurrentUserLedImage(this.getUserLedImageOff());
            this.USER_LED_BLINKING_TIMER.stop();
        }
    }

    protected BufferedImage getUserLedImageOn() {
        return this.userLedImageOn;
    }

    protected BufferedImage getUserLedImageOff() {
        return this.userLedImageOff;
    }

    protected void recreateUserLedImages() {
        this.recreateUserLedImages(this.getInnerBounds().width);
    }

    protected void recreateUserLedImages(int n) {
        if (this.userLedImageOff != null) {
            this.userLedImageOff.flush();
        }
        this.userLedImageOff = this.create_LED_Image(n, 0, this.model.getUserLedColor());
        if (this.userLedImageOn != null) {
            this.userLedImageOn.flush();
        }
        this.userLedImageOn = this.create_LED_Image(n, 1, this.model.getUserLedColor());
    }

    protected BufferedImage getCurrentUserLedImage() {
        return this.currentUserLedImage;
    }

    protected void setCurrentUserLedImage(BufferedImage bufferedImage) {
        if (this.currentUserLedImage != null) {
            this.currentUserLedImage.flush();
        }
        this.currentUserLedImage = bufferedImage;
        this.repaint(this.getInnerBounds());
    }

    public boolean isUserLedOn() {
        return this.userLedOn;
    }

    public void setUserLedOn(boolean bl) {
        this.userLedOn = bl;
        if (this.userLedOn) {
            this.setCurrentUserLedImage(this.userLedImageOn);
        } else {
            this.setCurrentUserLedImage(this.userLedImageOff);
        }
    }

    public double getMinMeasuredValue() {
        return this.model.getMinMeasuredValue();
    }

    protected void setMinMeasuredValue(double d) {
        this.model.setMinMeasuredValue(d);
        this.repaint(this.getInnerBounds());
    }

    public boolean isMinMeasuredValueVisible() {
        return this.model.isMinMeasuredValueVisible();
    }

    public void setMinMeasuredValueVisible(boolean bl) {
        this.model.setMinMeasuredValueVisible(bl);
        this.repaint(this.getInnerBounds());
    }

    public void resetMinMeasuredValue() {
        this.model.resetMinMeasuredValue();
        this.repaint(this.getInnerBounds());
    }

    public void resetMinMeasuredValue(double d) {
        this.model.resetMinMeasuredValue(d);
        this.repaint(this.getInnerBounds());
    }

    public double getMaxMeasuredValue() {
        return this.model.getMaxMeasuredValue();
    }

    protected void setMaxMeasuredValue(double d) {
        this.model.setMaxMeasuredValue(d);
        this.repaint(this.getInnerBounds());
    }

    public boolean isMaxMeasuredValueVisible() {
        return this.model.isMaxMeasuredValueVisible();
    }

    public void setMaxMeasuredValueVisible(boolean bl) {
        this.model.setMaxMeasuredValueVisible(bl);
        this.repaint(this.getInnerBounds());
    }

    public void resetMaxMeasuredValue() {
        this.model.resetMaxMeasuredValue();
        this.repaint(this.getInnerBounds());
    }

    public void resetMaxMeasuredValue(double d) {
        this.model.resetMaxMeasuredValue(d);
        this.repaint(this.getInnerBounds());
    }

    public long getStdTimeToValue() {
        return this.stdTimeToValue;
    }

    public void setStdTimeToValue(long l) {
        this.stdTimeToValue = l < 250L ? 250L : (l > 5000L ? 5000L : l);
    }

    public long getRtzTimeToValue() {
        return this.rtzTimeToValue;
    }

    public void setRtzTimeToValue(long l) {
        this.rtzTimeToValue = l < 250L ? 250L : (l > 5000L ? 5000L : l);
    }

    public long getRtzTimeBackToZero() {
        return this.rtzTimeBackToZero;
    }

    public void setRtzTimeBackToZero(long l) {
        this.rtzTimeBackToZero = l < 250L ? 250L : (l > 5000L ? 5000L : l);
    }

    public Timer getPeakTimer() {
        return this.PEAK_TIMER;
    }

    public void startPeakTimer() {
        if (!this.PEAK_TIMER.isRunning()) {
            this.PEAK_TIMER.start();
        }
    }

    public void stopPeakTimer() {
        if (this.PEAK_TIMER.isRunning()) {
            this.PEAK_TIMER.stop();
        }
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
        this.reInitialize();
    }

    public ColorDef getThresholdColor() {
        return this.model.getThresholdColor();
    }

    public void setThresholdColor(ColorDef colorDef) {
        this.model.setThresholdColor(colorDef);
        this.reInitialize();
    }

    public CustomColorDef getCustomThresholdColor() {
        return this.model.getCustomThresholdColor();
    }

    public void setCustomThresholdColor(CustomColorDef customColorDef) {
        this.model.setCustomThresholdColor(customColorDef);
        this.reInitialize();
    }

    public ThresholdType getThresholdType() {
        return this.model.getThresholdType();
    }

    public void setThresholdType(ThresholdType thresholdType) {
        this.model.setThresholdType(thresholdType);
        this.reInitialize();
    }

    public BufferedImage getAsImage() {
        BufferedImage bufferedImage = UTIL.createImage(this.getWidth(), this.getHeight(), 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        this.paintAll(graphics2D);
        graphics2D.dispose();
        return bufferedImage;
    }

    public boolean isTickmarkColorFromThemeEnabled() {
        return this.model.isTickmarkColorFromThemeEnabled();
    }

    public void setTickmarkColorFromThemeEnabled(boolean bl) {
        this.model.setTickmarkColorFromThemeEnabled(bl);
        this.reInitialize();
    }

    public Color getTickmarkColor() {
        return this.model.getTickmarkColor();
    }

    public void setTickmarkColor(Color color) {
        this.model.setTickmarkColor(color);
        this.reInitialize();
    }

    public boolean isTickmarksVisible() {
        return this.model.isTickmarksVisible();
    }

    public void setTickmarksVisible(boolean bl) {
        this.model.setTickmarksVisible(bl);
        this.reInitialize();
    }

    public boolean isTicklabelsVisible() {
        return this.model.isTicklabelsVisible();
    }

    public void setTicklabelsVisible(boolean bl) {
        this.model.setTicklabelsVisible(bl);
        this.reInitialize();
    }

    public NumberFormat getLabelNumberFormat() {
        return this.model.getLabelNumberFormat();
    }

    public void setLabelNumberFormat(NumberFormat numberFormat) {
        this.model.setLabelNumberFormat(numberFormat);
        this.reInitialize();
    }

    public boolean isCustomTickmarkLabelsEnabled() {
        return this.customTickmarkLabelsEnabled;
    }

    public void setCustomTickmarkLabelsEnabled(boolean bl) {
        this.customTickmarkLabelsEnabled = bl;
        this.reInitialize();
    }

    public List<Double> getCustomTickmarkLabels() {
        ArrayList<Double> arrayList = new ArrayList<Double>(10);
        arrayList.addAll(this.customTickmarkLabels);
        return arrayList;
    }

    public void setCustomTickmarkLabels(double ... dArray) {
        this.customTickmarkLabels.clear();
        double[] dArray2 = dArray;
        int n = dArray2.length;
        for (int i = 0; i < n; ++i) {
            Double d = dArray2[i];
            this.customTickmarkLabels.add(d);
        }
        this.reInitialize();
    }

    public void addCustomTickmarkLabel(double d) {
        this.customTickmarkLabels.add(d);
        this.reInitialize();
    }

    public void resetCustomTickmarkLabels() {
        this.customTickmarkLabels.clear();
        this.reInitialize();
    }

    public List<Section> getTickmarkSections() {
        return this.model.getTickmarkSections();
    }

    public void setTickmarkSections(Section ... sectionArray) {
        this.model.setTickmarkSections(sectionArray);
        this.reInitialize();
    }

    public void addTickmarkSection(Section section) {
        this.model.addTickmarkSection(section);
        this.reInitialize();
    }

    public void resetTickmarkSections() {
        this.model.resetTickmarkSections();
        this.reInitialize();
    }

    public boolean isTickmarkSectionsVisible() {
        return this.model.isTickmarkSectionsVisible();
    }

    public void setTickmarkSectionsVisible(boolean bl) {
        this.model.setTickmarkSectionsVisible(bl);
        this.reInitialize();
    }

    public TickmarkType getMinorTickmarkType() {
        return this.model.getMinorTickmarkType();
    }

    public void setMinorTickmarkType(TickmarkType tickmarkType) {
        this.model.setMinorTickmarkType(tickmarkType);
        this.reInitialize();
    }

    public TickmarkType getMajorTickmarkType() {
        return this.model.getMajorTickmarkType();
    }

    public void setMajorTickmarkType(TickmarkType tickmarkType) {
        this.model.setMajorTickmarkType(tickmarkType);
        this.reInitialize();
    }

    public boolean isMinorTickmarkVisible() {
        return this.model.isMinorTickmarksVisible();
    }

    public void setMinorTickmarkVisible(boolean bl) {
        this.model.setMinorTickmarksVisible(bl);
        this.reInitialize();
    }

    public boolean isMajorTickmarkVisible() {
        return this.model.isMajorTickmarksVisible();
    }

    public void setMajorTickmarkVisible(boolean bl) {
        this.model.setMajorTickmarksVisible(bl);
        this.reInitialize();
    }

    public boolean isNiceScale() {
        return this.model.isNiceScale();
    }

    public void setNiceScale(boolean bl) {
        this.model.setNiceScale(bl);
        this.reInitialize();
    }

    public boolean isLogScale() {
        return this.model.isLogScale();
    }

    public void setLogScale(boolean bl) {
        this.model.setLogScale(bl);
        this.model.setMinValue(0.0);
        this.model.setLabelNumberFormat(NumberFormat.SCIENTIFIC);
        this.reInitialize();
    }

    public double getMinorTickSpacing() {
        return this.model.getMinorTickSpacing();
    }

    public void setMinorTickSpacing(double d) {
        this.model.setMinorTickSpacing(d);
        this.reInitialize();
    }

    public double getMajorTickSpacing() {
        return this.model.getMajorTickSpacing();
    }

    public void setMajorTickSpacing(double d) {
        this.model.setMajorTickSpacing(d);
        this.reInitialize();
    }

    public boolean isTrackVisible() {
        return this.model.isTrackVisible();
    }

    public void setTrackVisible(boolean bl) {
        this.model.setTrackVisible(bl);
        this.reInitialize();
    }

    public double getTrackStart() {
        return this.model.getTrackStart();
    }

    public void setTrackStart(double d) {
        this.model.setTrackStart(d);
        this.reInitialize();
    }

    public double getTrackSection() {
        return this.model.getTrackSection();
    }

    public void setTrackSection(double d) {
        this.model.setTrackSection(d);
        this.reInitialize();
    }

    public double getTrackStop() {
        return this.model.getTrackStop();
    }

    public void setTrackStop(double d) {
        this.model.setTrackStop(d);
        this.reInitialize();
    }

    public Color getTrackStartColor() {
        return this.model.getTrackStartColor();
    }

    public void setTrackStartColor(Color color) {
        this.model.setTrackStartColor(color);
        this.reInitialize();
    }

    public Color getTrackSectionColor() {
        return this.model.getTrackSectionColor();
    }

    public void setTrackSectionColor(Color color) {
        this.model.setTrackSectionColor(color);
        this.reInitialize();
    }

    public Color getTrackStopColor() {
        return this.model.getTrackStopColor();
    }

    public void setTrackStopColor(Color color) {
        this.model.setTrackStopColor(color);
        this.reInitialize();
    }

    public boolean isSectionsVisible() {
        return this.model.isSectionsVisible();
    }

    public void setSectionsVisible(boolean bl) {
        this.model.setSectionsVisible(bl);
        this.reInitialize();
    }

    public boolean isHighlightSection() {
        return this.getModel().isHighlightSection();
    }

    public void setHighlightSection(boolean bl) {
        this.getModel().setHighlightSection(bl);
        this.reInitialize();
    }

    public List<Section> getSections() {
        return this.model.getSections();
    }

    public void setSections(Section ... sectionArray) {
        this.model.setSections(sectionArray);
        this.reInitialize();
    }

    public void addSection(Section section) {
        this.model.addSection(section);
        this.reInitialize();
    }

    public void resetSections() {
        this.model.resetSections();
        this.reInitialize();
    }

    public boolean isAreasVisible() {
        return this.model.isAreasVisible();
    }

    public void setAreasVisible(boolean bl) {
        this.model.setAreasVisible(bl);
        this.reInitialize();
    }

    public boolean isHighlightArea() {
        return this.getModel().isHighlightArea();
    }

    public void setHighlightArea(boolean bl) {
        this.getModel().setHighlightArea(bl);
        this.reInitialize();
    }

    public List<Section> getAreas() {
        return this.model.getAreas();
    }

    public void setAreas(Section ... sectionArray) {
        this.model.setAreas(sectionArray);
        this.reInitialize();
    }

    public void addArea(Section section) {
        this.model.addArea(section);
        this.reInitialize();
    }

    public void resetAreas() {
        this.model.resetAreas();
        this.reInitialize();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
        this.reInitialize();
    }

    public String getUnitString() {
        return this.unitString;
    }

    public void setUnitString(String string) {
        this.unitString = string;
        this.reInitialize();
    }

    public boolean isLabelColorFromThemeEnabled() {
        return this.model.isLabelColorFromThemeEnabled();
    }

    public void setLabelColorFromThemeEnabled(boolean bl) {
        this.model.setLabelColorFromThemeEnabled(bl);
        this.reInitialize();
    }

    public Color getLabelColor() {
        return this.model.getLabelColor();
    }

    public void setLabelColor(Color color) {
        this.model.setLabelColor(color);
        this.reInitialize();
    }

    public boolean isTitleAndUnitFontEnabled() {
        return this.model.isCustomTitleAndUnitFontEnabled();
    }

    public void setTitleAndUnitFontEnabled(boolean bl) {
        this.model.setCustomLcdUnitFontEnabled(bl);
        this.reInitialize();
    }

    public Font getTitleAndUnitFont() {
        return this.titleAndUnitFont;
    }

    public void setTitleAndUnitFont(Font font) {
        this.titleAndUnitFont = font;
        this.reInitialize();
    }

    public FrameDesign getFrameDesign() {
        return this.model.getFrameDesign();
    }

    public void setFrameDesign(FrameDesign frameDesign) {
        this.model.setFrameDesign(frameDesign);
        this.reInitialize();
    }

    public Paint getCustomFrameDesign() {
        return this.model.getCustomFrameDesign();
    }

    public void setCustomFrameDesign(Paint paint) {
        this.model.setCustomFrameDesign(paint);
        this.reInitialize();
    }

    public boolean isFrameVisible() {
        return this.model.isFrameVisible();
    }

    public void setFrameVisible(boolean bl) {
        this.model.setFrameVisible(bl);
        this.calcInnerBounds();
        this.reInitialize();
    }

    public FrameEffect getFrameEffect() {
        return this.model.getFrameEffect();
    }

    public void setFrameEffect(FrameEffect frameEffect) {
        this.model.setFrameEffect(frameEffect);
        this.reInitialize();
    }

    public Color getFrameBaseColor() {
        return this.model.getFrameBaseColor();
    }

    public void setFrameBaseColor(Color color) {
        this.model.setFrameBaseColor(color);
        this.reInitialize();
    }

    public boolean isFrameBaseColorEnabled() {
        return this.model.isFrameBaseColorEnabled();
    }

    public void setFrameBaseColorEnabled(boolean bl) {
        this.model.setFrameBaseColorEnabled(bl);
        this.reInitialize();
    }

    public BackgroundColor getBackgroundColor() {
        return this.model.getBackgroundColor();
    }

    public void setBackgroundColor(BackgroundColor backgroundColor) {
        this.model.setBackgroundColor(backgroundColor);
        this.reInitialize();
    }

    public boolean isBackgroundVisible() {
        return this.model.isBackgroundVisible();
    }

    public void setBackgroundVisible(boolean bl) {
        this.model.setBackgroundVisible(bl);
        this.reInitialize();
    }

    public Color getTextureColor() {
        return this.model.getTextureColor();
    }

    public void setTextureColor(Color color) {
        this.model.setTextureColor(color);
        BACKGROUND_FACTORY.recreatePunchedSheetTexture(color);
        this.reInitialize();
    }

    public Paint getCustomBackground() {
        return this.model.getCustomBackground();
    }

    public void setCustomBackground(Paint paint) {
        this.model.setCustomBackground(paint);
        if (this.model.getBackgroundColor() == BackgroundColor.CUSTOM) {
            this.reInitialize();
        }
    }

    public boolean isCustomLayerVisible() {
        return this.model.isCustomLayerVisible();
    }

    public void setCustomLayerVisible(boolean bl) {
        if (this.model.getCustomLayer() != null) {
            this.model.setCustomLayerVisible(bl);
        }
        this.reInitialize();
    }

    public BufferedImage getCustomLayer() {
        return this.model.getCustomLayer();
    }

    public void setCustomLayer(BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            this.model.setCustomLayerVisible(false);
            return;
        }
        this.model.setCustomLayer(bufferedImage);
        if (this.model.isCustomLayerVisible()) {
            this.reInitialize();
        }
    }

    protected float getGlowAlpha() {
        return this.glowAlpha;
    }

    abstract boolean isGlowVisible();

    public boolean isGlowPulsating() {
        return this.GLOW_PULSE.isRunning();
    }

    public void setGlowPulsating(boolean bl) {
        if (this.isGlowVisible() && bl && !this.GLOW_PULSE.isRunning()) {
            this.GLOW_PULSE.start();
        } else if (this.GLOW_PULSE.isRunning()) {
            this.GLOW_PULSE.stop();
            this.glowAlpha = 1.0f;
        }
    }

    public boolean isForegroundVisible() {
        return this.model.isForegroundVisible();
    }

    public void setForegroundVisible(boolean bl) {
        this.model.setForegroundVisible(bl);
        this.reInitialize();
    }

    protected final BufferedImage create_LED_Image(int n, int n2, LedColor ledColor) {
        return LED_FACTORY.create_LED_Image(n, n2, ledColor, this.model.getCustomLedColor());
    }

    public BufferedImage create_LCD_THRESHOLD_Image(int n, int n2, Color color) {
        if (n <= 0 || n2 <= 0) {
            return null;
        }
        BufferedImage bufferedImage = UTIL.createImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n3 * 0.4444444444444444, (double)n4 * 0.7777777777777778);
        generalPath.lineTo((double)n3 * 0.5555555555555556, (double)n4 * 0.7777777777777778);
        generalPath.lineTo((double)n3 * 0.5555555555555556, (double)n4 * 0.8888888888888888);
        generalPath.lineTo((double)n3 * 0.4444444444444444, (double)n4 * 0.8888888888888888);
        generalPath.lineTo((double)n3 * 0.4444444444444444, (double)n4 * 0.7777777777777778);
        generalPath.closePath();
        generalPath.moveTo((double)n3 * 0.4444444444444444, (double)n4 * 0.3333333333333333);
        generalPath.lineTo((double)n3 * 0.5555555555555556, (double)n4 * 0.3333333333333333);
        generalPath.lineTo((double)n3 * 0.5555555555555556, (double)n4 * 0.7222222222222222);
        generalPath.lineTo((double)n3 * 0.4444444444444444, (double)n4 * 0.7222222222222222);
        generalPath.lineTo((double)n3 * 0.4444444444444444, (double)n4 * 0.3333333333333333);
        generalPath.closePath();
        generalPath.moveTo(0.0, (double)n4);
        generalPath.lineTo(n3, n4);
        generalPath.lineTo((double)n3 * 0.5, 0.0);
        generalPath.lineTo(0.0, (double)n4);
        generalPath.closePath();
        graphics2D.setColor(color);
        graphics2D.fill(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    public abstract void calcInnerBounds();

    public abstract Rectangle getInnerBounds();

    protected abstract Point2D getCenter();

    protected abstract Rectangle2D getBounds2D();

    public void reInitialize() {
        if (this.isInitialized()) {
            this.init(this.getInnerBounds().width, this.getInnerBounds().height);
            this.repaint(this.getInnerBounds());
        }
    }

    @Override
    public void setBorder(Border border) {
        super.setBorder(border);
        this.calcInnerBounds();
        this.reInitialize();
    }

    public JComponent clone() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(this);
            objectOutputStream.flush();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            JComponent jComponent = (JComponent)objectInputStream.readObject();
            objectOutputStream.close();
            objectInputStream.close();
            return jComponent;
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public void dispose() {
        this.LED_BLINKING_TIMER.removeActionListener(this);
        this.USER_LED_BLINKING_TIMER.removeActionListener(this);
        this.PEAK_TIMER.removeActionListener(this);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.LISTENER_LIST.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.LISTENER_LIST.remove(ChangeListener.class, changeListener);
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.LISTENER_LIST.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i + 1]).stateChanged(this.changeEvent);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        if (componentEvent.getComponent() instanceof AbstractRadial) {
            int n = this.getWidth() < this.getHeight() ? this.getWidth() : this.getHeight();
            this.setSize(n, n);
            this.setPreferredSize(this.getSize());
            if (n < this.getMinimumSize().width || n < this.getMinimumSize().height) {
                this.setSize(this.getMinimumSize());
            }
            this.calcInnerBounds();
            this.recreateLedImages();
            if (this.isLedOn()) {
                this.setCurrentLedImage(this.getLedImageOn());
            } else {
                this.setCurrentLedImage(this.getLedImageOff());
            }
            this.recreateUserLedImages();
            if (this.isUserLedOn()) {
                this.setCurrentUserLedImage(this.getUserLedImageOn());
            } else {
                this.setCurrentUserLedImage(this.getUserLedImageOff());
            }
            this.reInitialize();
        }
        if (componentEvent.getComponent() instanceof AbstractLinear) {
            this.setSize(this.getWidth(), this.getHeight());
            this.setPreferredSize(this.getSize());
            this.calcInnerBounds();
            if (this.getWidth() >= this.getHeight()) {
                this.setOrientation(Orientation.HORIZONTAL);
                this.recreateLedImages(this.getInnerBounds().height);
                this.recreateUserLedImages(this.getInnerBounds().height);
                if (this.isLedOn()) {
                    this.setCurrentLedImage(this.getLedImageOn());
                } else {
                    this.setCurrentLedImage(this.getLedImageOff());
                }
                this.setLedPosition(((double)this.getInnerBounds().width - 18.0 - 16.0) / (double)this.getInnerBounds().width, 0.453271028);
                if (this.isUserLedOn()) {
                    this.setCurrentUserLedImage(this.getUserLedImageOn());
                } else {
                    this.setCurrentUserLedImage(this.getUserLedImageOff());
                }
                this.setUserLedPosition(18.0 / (double)this.getInnerBounds().width, 0.453271028);
            } else {
                this.setOrientation(Orientation.VERTICAL);
                this.recreateLedImages(this.getInnerBounds().width);
                this.recreateUserLedImages(this.getInnerBounds().width);
                if (this.isLedOn()) {
                    this.setCurrentLedImage(this.getLedImageOn());
                } else {
                    this.setCurrentLedImage(this.getLedImageOff());
                }
                this.setLedPosition(0.453271028, 18.0 / (double)this.getInnerBounds().height);
                if (this.isUserLedOn()) {
                    this.setCurrentUserLedImage(this.getUserLedImageOn());
                } else {
                    this.setCurrentUserLedImage(this.getUserLedImageOff());
                }
                this.setUserLedPosition(((double)this.getInnerBounds().width - 18.0 - 16.0) / (double)this.getInnerBounds().width, 0.453271028);
            }
            this.reInitialize();
        }
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.LED_BLINKING_TIMER)) {
            this.currentLedImage.flush();
            this.currentLedImage = this.ledOn ? this.getLedImageOn() : this.getLedImageOff();
            this.ledOn ^= true;
            this.repaint((int)((double)this.getInnerBounds().width * this.getLedPosition().getX() + (double)this.getInnerBounds().x), (int)((double)this.getInnerBounds().height * this.getLedPosition().getY() + (double)this.getInnerBounds().y), this.currentLedImage.getWidth(), this.currentLedImage.getHeight());
        }
        if (actionEvent.getSource().equals(this.USER_LED_BLINKING_TIMER)) {
            this.currentUserLedImage.flush();
            this.currentUserLedImage = this.userLedOn ? this.getUserLedImageOn() : this.getUserLedImageOff();
            this.userLedOn ^= true;
            this.repaint((int)((double)this.getInnerBounds().width * this.getUserLedPosition().getX() + (double)this.getInnerBounds().x), (int)((double)this.getInnerBounds().height * this.getUserLedPosition().getY() + (double)this.getInnerBounds().y), this.currentUserLedImage.getWidth(), this.currentUserLedImage.getHeight());
        }
        if (actionEvent.getSource().equals(this.PEAK_TIMER)) {
            this.setPeakValueVisible(false);
            this.PEAK_TIMER.stop();
        }
        if (actionEvent.getSource().equals(this.GLOW_PULSE)) {
            this.glowAlphaCounter += this.glowAlphaIncrement;
            this.glowAlpha = (float)Math.cos(this.glowAlphaCounter);
            if (Float.compare(this.glowAlpha, 1.0f) >= 0) {
                this.glowAlpha = 1.0f;
                this.glowAlphaIncrement = -0.0785398164;
            }
            if (Float.compare(this.glowAlpha, 0.2f) <= 0) {
                this.glowAlpha = 0.0f;
                this.glowAlphaIncrement = 0.0785398164;
            }
            this.repaint(this.getInnerBounds());
        }
    }
}

