/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.gauges;

import eu.hansolo.steelseries.gauges.AbstractGauge;
import eu.hansolo.steelseries.gauges.Lcd;
import eu.hansolo.steelseries.tools.ColorDef;
import eu.hansolo.steelseries.tools.ConicalGradientPaint;
import eu.hansolo.steelseries.tools.CustomColorDef;
import eu.hansolo.steelseries.tools.Direction;
import eu.hansolo.steelseries.tools.ForegroundType;
import eu.hansolo.steelseries.tools.FrameType;
import eu.hansolo.steelseries.tools.GaugeType;
import eu.hansolo.steelseries.tools.KnobStyle;
import eu.hansolo.steelseries.tools.KnobType;
import eu.hansolo.steelseries.tools.LcdColor;
import eu.hansolo.steelseries.tools.NumberSystem;
import eu.hansolo.steelseries.tools.Orientation;
import eu.hansolo.steelseries.tools.PointerType;
import eu.hansolo.steelseries.tools.PostPosition;
import eu.hansolo.steelseries.tools.TicklabelOrientation;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ComponentEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.swing.border.Border;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.TimelineScenario;
import org.pushingpixels.trident.callback.TimelineCallback;
import org.pushingpixels.trident.ease.Sine;
import org.pushingpixels.trident.ease.Spline;
import org.pushingpixels.trident.ease.TimelineEase;

public abstract class AbstractRadial
extends AbstractGauge
implements Lcd {
    protected static final float ANGLE_CONST = 0.0027777778f;
    private final Rectangle INNER_BOUNDS;
    private final Rectangle GAUGE_BOUNDS;
    private final Rectangle FRAMELESS_BOUNDS;
    private final Point2D FRAMELESS_OFFSET;
    private boolean transparentSectionsEnabled = false;
    private boolean transparentAreasEnabled = false;
    private boolean expandedSectionsEnabled = false;
    private Direction tickmarkDirection;
    private Point2D ledPosition;
    private Point2D userLedPosition;
    private String lcdUnitString;
    private double lcdValue = 0.0;
    private String lcdInfoString = "";
    private Timeline lcdTimeline = new Timeline((Object)this);
    private Timeline timeline;
    private final TimelineEase STANDARD_EASING;
    private final TimelineEase RETURN_TO_ZERO_EASING;
    private TimelineCallback timelineCallback;

    public AbstractRadial() {
        this.lcdUnitString = this.getUnitString();
        this.ledPosition = new Point2D.Double(0.6, 0.4);
        this.userLedPosition = new Point2D.Double(0.3, 0.4);
        this.INNER_BOUNDS = new Rectangle(200, 200);
        this.GAUGE_BOUNDS = new Rectangle(200, 200);
        this.FRAMELESS_BOUNDS = new Rectangle(200, 200);
        this.FRAMELESS_OFFSET = new Point2D.Double(0.0, 0.0);
        this.tickmarkDirection = Direction.CLOCKWISE;
        this.timeline = new Timeline((Object)this);
        this.STANDARD_EASING = new Spline(0.5f);
        this.RETURN_TO_ZERO_EASING = new Sine();
        this.addComponentListener(this);
    }

    public GaugeType getGaugeType() {
        return this.getModel().getGaugeType();
    }

    public void setGaugeType(GaugeType gaugeType) {
        this.getModel().setGaugeType(gaugeType);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public FrameType getFrameType() {
        return this.getModel().getFrameType();
    }

    public void setFrameType(FrameType frameType) {
        this.getModel().setFrameType(frameType);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public ForegroundType getForegroundType() {
        return this.getModel().getForegroundType();
    }

    public void setForegroundType(ForegroundType foregroundType) {
        this.getModel().setForegroundType(foregroundType);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public void setValueAnimated(double d) {
        if (this.isEnabled()) {
            double d2;
            if (this.timeline.getState() != Timeline.TimelineState.IDLE) {
                this.timeline.abort();
            }
            double d3 = d < this.getMinValue() ? this.getMinValue() : (d2 = d > this.getMaxValue() ? this.getMaxValue() : d);
            if (!this.isAutoResetToZero()) {
                this.timeline.removeCallback(this.timelineCallback);
                this.timeline = new Timeline((Object)this);
                this.timeline.addPropertyToInterpolate("value", (Object)this.getValue(), (Object)d2);
                this.timeline.setEase(this.STANDARD_EASING);
                this.timeline.setDuration(this.getStdTimeToValue());
                this.timelineCallback = new TimelineCallback(){

                    public void onTimelineStateChanged(Timeline.TimelineState timelineState, Timeline.TimelineState timelineState2, float f, float f2) {
                        if (timelineState2 == Timeline.TimelineState.IDLE) {
                            AbstractRadial.this.repaint(AbstractRadial.this.getInnerBounds());
                        }
                        if (AbstractRadial.this.getValue() > AbstractRadial.this.getMaxMeasuredValue()) {
                            AbstractRadial.this.setMaxMeasuredValue(AbstractRadial.this.getValue());
                        }
                    }

                    public void onTimelinePulse(float f, float f2) {
                        if (AbstractRadial.this.getValue() > AbstractRadial.this.getMaxMeasuredValue()) {
                            AbstractRadial.this.setMaxMeasuredValue(AbstractRadial.this.getValue());
                        }
                        if (AbstractRadial.this.getValue() < AbstractRadial.this.getMinMeasuredValue()) {
                            AbstractRadial.this.setMinMeasuredValue(AbstractRadial.this.getValue());
                        }
                    }
                };
                this.timeline.addCallback(this.timelineCallback);
                this.timeline.play();
            } else {
                TimelineScenario.Sequence sequence = new TimelineScenario.Sequence();
                Timeline timeline = new Timeline((Object)this);
                timeline.addPropertyToInterpolate("value", (Object)this.getValue(), (Object)d2);
                timeline.setEase(this.RETURN_TO_ZERO_EASING);
                timeline.setDuration(this.getRtzTimeToValue());
                timeline.addCallback(new TimelineCallback(){

                    public void onTimelineStateChanged(Timeline.TimelineState timelineState, Timeline.TimelineState timelineState2, float f, float f2) {
                        if (timelineState == Timeline.TimelineState.PLAYING_FORWARD && timelineState2 == Timeline.TimelineState.DONE) {
                            AbstractRadial.this.getModel().setPeakValue(AbstractRadial.this.getValue());
                            AbstractRadial.this.getModel().setPeakValueVisible(true);
                            if (AbstractRadial.this.getPeakTimer().isRunning()) {
                                AbstractRadial.this.stopPeakTimer();
                            }
                            AbstractRadial.this.startPeakTimer();
                            if (AbstractRadial.this.getValue() > AbstractRadial.this.getMaxMeasuredValue()) {
                                AbstractRadial.this.setMaxMeasuredValue(AbstractRadial.this.getValue());
                            }
                        }
                    }

                    public void onTimelinePulse(float f, float f2) {
                        if (AbstractRadial.this.getValue() > AbstractRadial.this.getMaxMeasuredValue()) {
                            AbstractRadial.this.setMaxMeasuredValue(AbstractRadial.this.getValue());
                        }
                        if (AbstractRadial.this.getValue() < AbstractRadial.this.getMinMeasuredValue()) {
                            AbstractRadial.this.setMinMeasuredValue(AbstractRadial.this.getValue());
                        }
                    }
                });
                Timeline timeline2 = new Timeline((Object)this);
                timeline2.addPropertyToInterpolate("value", (Object)d2, (Object)0.0);
                timeline2.setEase(this.RETURN_TO_ZERO_EASING);
                timeline2.setDuration(this.getRtzTimeBackToZero());
                sequence.addScenarioActor((TimelineScenario.TimelineScenarioActor)timeline);
                sequence.addScenarioActor((TimelineScenario.TimelineScenarioActor)timeline2);
                sequence.play();
            }
        }
    }

    public double getAngleStep() {
        return this.getModel().getAngleStep();
    }

    public double getLogAngleStep() {
        return this.getModel().getLogAngleStep();
    }

    public double getFreeAreaAngle() {
        return this.getModel().getFreeAreaAngle();
    }

    public double getRotationOffset() {
        return this.getModel().getRotationOffset();
    }

    public double getTickmarkOffset() {
        return this.getModel().getTickmarkOffset();
    }

    public int getMaxNoOfMinorTicks() {
        return this.getModel().getMaxNoOfMinorTicks();
    }

    public void setMaxNoOfMinorTicks(int n) {
        this.getModel().setMaxNoOfMinorTicks(n);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public int getMaxNoOfMajorTicks() {
        return this.getModel().getMaxNoOfMajorTicks();
    }

    public void setMaxNoOfMajorTicks(int n) {
        this.getModel().setMaxNoOfMajorTicks(n);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Point2D getLedPosition() {
        return this.ledPosition;
    }

    @Override
    public void setLedPosition(double d, double d2) {
        this.ledPosition.setLocation(d, d2);
        this.repaint(this.getInnerBounds());
    }

    public void setLedPosition(Point2D point2D) {
        this.ledPosition.setLocation(point2D);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Point2D getUserLedPosition() {
        return this.userLedPosition;
    }

    @Override
    public void setUserLedPosition(double d, double d2) {
        this.userLedPosition.setLocation(d, d2);
        this.repaint(this.getInnerBounds());
    }

    public void setUserLedPosition(Point2D point2D) {
        this.userLedPosition.setLocation(point2D);
        this.repaint(this.getInnerBounds());
    }

    public Direction getTickmarkDirection() {
        return this.tickmarkDirection;
    }

    public void setTickmarkDirection(Direction direction) {
        this.tickmarkDirection = direction;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public PointerType getPointerType() {
        return this.getModel().getPointerType();
    }

    public void setPointerType(PointerType pointerType) {
        this.getModel().setPointerType(pointerType);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public ColorDef getPointerColor() {
        return this.getModel().getPointerColor();
    }

    public void setPointerColor(ColorDef colorDef) {
        this.getModel().setPointerColor(colorDef);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public boolean isPointerShadowVisible() {
        return this.getModel().isPointerShadowVisible();
    }

    public void setPointerShadowVisible(boolean bl) {
        this.getModel().setPointerShadowVisible(bl);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public Color getCustomPointerColor() {
        return this.getModel().getCustomPointerColor();
    }

    public void setCustomPointerColor(Color color) {
        this.getModel().setCustomPointerColorObject(new CustomColorDef(color));
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public CustomColorDef getCustomPointerColorObject() {
        return this.getModel().getCustomPointerColorObject();
    }

    public KnobType getKnobType() {
        return this.getModel().getKnobType();
    }

    public void setKnobType(KnobType knobType) {
        this.getModel().setKnobType(knobType);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public KnobStyle getKnobStyle() {
        return this.getModel().getKnobStyle();
    }

    public void setKnobStyle(KnobStyle knobStyle) {
        this.getModel().setKnobStyle(knobStyle);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public boolean isLcdVisible() {
        return this.getModel().isLcdVisible();
    }

    public void setLcdVisible(boolean bl) {
        this.getModel().setLcdVisible(bl);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public boolean isRangeOfMeasuredValuesVisible() {
        return this.getModel().isRangeOfMeasuredValuesVisible();
    }

    public void setRangeOfMeasuredValuesVisible(boolean bl) {
        this.getModel().setRangeOfMeasuredValuesVisible(bl);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public boolean isValueCoupled() {
        return this.getModel().isValueCoupled();
    }

    @Override
    public void setValueCoupled(boolean bl) {
        this.getModel().setValueCoupled(bl);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public double getLcdValue() {
        return this.getModel().getLcdValue();
    }

    @Override
    public void setLcdValue(double d) {
        this.lcdValue = !this.isLogScale() ? d : (d > 1.0 ? d : 1.0);
        this.getModel().setLcdValue(this.lcdValue);
        this.repaint(this.getLcdBounds());
    }

    @Override
    public void setLcdValueAnimated(double d) {
        if (this.lcdTimeline.getState() == Timeline.TimelineState.PLAYING_FORWARD || this.lcdTimeline.getState() == Timeline.TimelineState.PLAYING_REVERSE) {
            this.lcdTimeline.abort();
        }
        this.lcdTimeline = new Timeline((Object)this);
        this.lcdTimeline.addPropertyToInterpolate("lcdValue", (Object)this.lcdValue, (Object)d);
        this.lcdTimeline.setEase((TimelineEase)new Spline(0.5f));
        this.lcdTimeline.play();
    }

    @Override
    public double getLcdThreshold() {
        return this.getModel().getLcdThreshold();
    }

    @Override
    public void setLcdThreshold(double d) {
        this.getModel().setLcdThreshold(d);
        if (this.getModel().isLcdThresholdVisible()) {
            this.repaint(this.getInnerBounds());
        }
    }

    @Override
    public boolean isLcdThresholdVisible() {
        return this.getModel().isLcdThresholdVisible();
    }

    @Override
    public void setLcdThresholdVisible(boolean bl) {
        this.getModel().setLcdThresholdVisible(bl);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public boolean isLcdThresholdBehaviourInverted() {
        return this.getModel().isLcdThresholdBehaviourInverted();
    }

    @Override
    public void setLcdThresholdBehaviourInverted(boolean bl) {
        this.getModel().setLcdThresholdBehaviourInverted(bl);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public String getLcdUnitString() {
        return this.lcdUnitString;
    }

    @Override
    public void setLcdUnitString(String string) {
        this.lcdUnitString = string;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public boolean isLcdUnitStringVisible() {
        return this.getModel().isLcdUnitStringVisible();
    }

    @Override
    public void setLcdUnitStringVisible(boolean bl) {
        this.getModel().setLcdUnitStringVisible(bl);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public boolean isDigitalFont() {
        return this.getModel().isDigitalFontEnabled();
    }

    @Override
    public void setDigitalFont(boolean bl) {
        this.getModel().setDigitalFontEnabled(bl);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public boolean isCustomLcdUnitFontEnabled() {
        return this.getModel().isCustomLcdUnitFontEnabled();
    }

    @Override
    public void setCustomLcdUnitFontEnabled(boolean bl) {
        this.getModel().setCustomLcdUnitFontEnabled(bl);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Font getCustomLcdUnitFont() {
        return this.getModel().getCustomLcdUnitFont();
    }

    @Override
    public void setCustomLcdUnitFont(Font font) {
        this.getModel().setCustomLcdUnitFont(font);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public int getLcdDecimals() {
        return this.getModel().getLcdDecimals();
    }

    @Override
    public void setLcdDecimals(int n) {
        this.getModel().setLcdDecimals(n);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public LcdColor getLcdColor() {
        return this.getModel().getLcdColor();
    }

    @Override
    public void setLcdColor(LcdColor lcdColor) {
        this.getModel().setLcdColor(lcdColor);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Paint getCustomLcdBackground() {
        return this.getModel().getCustomLcdBackground();
    }

    @Override
    public void setCustomLcdBackground(Paint paint) {
        this.getModel().setCustomLcdBackground(paint);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Paint createCustomLcdBackgroundPaint(Color[] colorArray) {
        return null;
    }

    @Override
    public Color getCustomLcdForeground() {
        return this.getModel().getCustomLcdForeground();
    }

    @Override
    public void setCustomLcdForeground(Color color) {
        this.getModel().setCustomLcdForeground(color);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public String formatLcdValue(double d) {
        StringBuilder stringBuilder = new StringBuilder(16);
        stringBuilder.append("0");
        if (this.getModel().getLcdDecimals() > 0) {
            stringBuilder.append(".");
        }
        for (int i = 0; i < this.getModel().getLcdDecimals(); ++i) {
            stringBuilder.append("0");
        }
        if (this.getModel().isLcdScientificFormatEnabled()) {
            stringBuilder.append("E0");
        }
        stringBuilder.trimToSize();
        DecimalFormat decimalFormat = new DecimalFormat(stringBuilder.toString(), new DecimalFormatSymbols(Locale.US));
        return decimalFormat.format(d);
    }

    @Override
    public boolean isLcdScientificFormat() {
        return this.getModel().isLcdScientificFormatEnabled();
    }

    @Override
    public void setLcdScientificFormat(boolean bl) {
        this.getModel().setLcdScientificFormatEnabled(bl);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Font getLcdValueFont() {
        return this.getModel().getLcdValueFont();
    }

    @Override
    public void setLcdValueFont(Font font) {
        this.getModel().setLcdValueFont(font);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Font getLcdUnitFont() {
        return this.getModel().getLcdUnitFont();
    }

    @Override
    public void setLcdUnitFont(Font font) {
        this.getModel().setLcdUnitFont(font);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Font getLcdInfoFont() {
        return this.getModel().getLcdInfoFont();
    }

    @Override
    public void setLcdInfoFont(Font font) {
        this.getModel().setLcdInfoFont(font);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public String getLcdInfoString() {
        return this.lcdInfoString;
    }

    @Override
    public void setLcdInfoString(String string) {
        this.lcdInfoString = string;
        this.repaint(this.getInnerBounds());
    }

    @Override
    public NumberSystem getLcdNumberSystem() {
        return this.getModel().getNumberSystem();
    }

    @Override
    public void setLcdNumberSystem(NumberSystem numberSystem) {
        this.getModel().setNumberSystem(numberSystem);
        switch (numberSystem) {
            case HEX: {
                this.lcdInfoString = "hex";
                break;
            }
            case OCT: {
                this.lcdInfoString = "oct";
                break;
            }
            default: {
                this.lcdInfoString = "";
            }
        }
        this.repaint(this.getInnerBounds());
    }

    @Override
    public abstract Rectangle getLcdBounds();

    @Override
    public void toggleDesign() {
        if (this.getActiveDesign().equals(this.getDesign1())) {
            this.setActiveDesign(this.getDesign2());
        } else {
            this.setActiveDesign(this.getDesign1());
        }
    }

    @Override
    public boolean isGlowVisible() {
        return this.getModel().isGlowVisible();
    }

    public void setGlowVisible(boolean bl) {
        this.getModel().setGlowVisible(bl);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public Color getGlowColor() {
        return this.getModel().getGlowColor();
    }

    public void setGlowColor(Color color) {
        this.getModel().setGlowColor(color);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public boolean isGlowing() {
        return this.getModel().isGlowing();
    }

    public void setGlowing(boolean bl) {
        this.getModel().setGlowing(bl);
        this.repaint(this.getInnerBounds());
    }

    public Paint getOuterFrameColor() {
        return FRAME_FACTORY.getOuterFrameColor();
    }

    public void setOuterFrameColor(Paint paint) {
        FRAME_FACTORY.setOuterFrameColor(paint);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public Paint getInnerFrameColor() {
        return FRAME_FACTORY.getInnerFrameColor();
    }

    public void setInnerFrameColor(Paint paint) {
        FRAME_FACTORY.setInnerFrameColor(paint);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public boolean getPostsVisible() {
        return this.getModel().getPostsVisible();
    }

    public void setPostsVisible(boolean bl) {
        this.getModel().setPostsVisible(bl);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public TicklabelOrientation getTicklabelOrientation() {
        return this.getModel().getTicklabelOrientation();
    }

    public void setTicklabelOrientation(TicklabelOrientation ticklabelOrientation) {
        this.getModel().setTicklabelOrienatation(ticklabelOrientation);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public boolean isTransparentSectionsEnabled() {
        return this.transparentSectionsEnabled;
    }

    public void setTransparentSectionsEnabled(boolean bl) {
        this.transparentSectionsEnabled = bl;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public boolean isTransparentAreasEnabled() {
        return this.transparentAreasEnabled;
    }

    public void setTransparentAreasEnabled(boolean bl) {
        this.transparentAreasEnabled = bl;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public boolean isExpandedSectionsEnabled() {
        return this.expandedSectionsEnabled;
    }

    public void setExpandedSectionsEnabled(boolean bl) {
        this.expandedSectionsEnabled = bl;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    protected RadialGradientPaint createSection3DEffectGradient(int n, float f) {
        Color[] colorArray;
        float[] fArray;
        if (this.isExpandedSectionsEnabled()) {
            fArray = new float[]{0.0f, 0.7f, 0.75f, 0.96f, 1.0f};
            colorArray = new Color[]{new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(0.9f, 0.9f, 0.9f, 0.2f), new Color(1.0f, 1.0f, 1.0f, 0.5f), new Color(0.18431373f, 0.18431373f, 0.18431373f, 0.3f), new Color(0.0f, 0.0f, 0.0f, 0.2f)};
        } else {
            fArray = new float[]{0.0f, 0.89f, 0.955f, 1.0f};
            colorArray = new Color[]{new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.3f), new Color(1.0f, 1.0f, 1.0f, 0.6f), new Color(0.0f, 0.0f, 0.0f, 0.4f)};
        }
        Point2D.Double double_ = new Point2D.Double((double)n / 2.0, (double)n / 2.0);
        return new RadialGradientPaint(double_, (float)n * f, fArray, colorArray);
    }

    protected RadialGradientPaint createArea3DEffectGradient(int n, float f) {
        float[] fArray = new float[]{0.0f, 0.6f, 1.0f};
        Color[] colorArray = new Color[]{new Color(1.0f, 1.0f, 1.0f, 0.75f), new Color(1.0f, 1.0f, 1.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.3f)};
        Point2D.Double double_ = new Point2D.Double((double)n / 2.0, (double)n / 2.0);
        return new RadialGradientPaint(double_, (float)n * f, fArray, colorArray);
    }

    protected BufferedImage create_FRAME_Image(int n) {
        switch (this.getFrameType()) {
            case ROUND: {
                return FRAME_FACTORY.createRadialFrame(n, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameBaseColor(), this.isFrameBaseColorEnabled(), this.getFrameEffect());
            }
            case SQUARE: {
                return FRAME_FACTORY.createLinearFrame(n, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameBaseColor(), this.isFrameBaseColorEnabled(), this.getFrameEffect());
            }
        }
        return FRAME_FACTORY.createRadialFrame(n, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameBaseColor(), this.isFrameBaseColorEnabled(), this.getFrameEffect());
    }

    protected BufferedImage create_BACKGROUND_Image(int n) {
        return this.create_BACKGROUND_Image(n, "", "");
    }

    protected BufferedImage create_BACKGROUND_Image(int n, String string, String string2) {
        return this.create_BACKGROUND_Image(n, string, string2, null);
    }

    protected BufferedImage create_BACKGROUND_Image(int n, String string, String string2, BufferedImage bufferedImage) {
        Rectangle2D rectangle2D;
        TextLayout textLayout;
        if (n <= 0) {
            return null;
        }
        if (bufferedImage == null) {
            bufferedImage = UTIL.createImage(n, n, 3);
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        switch (this.getFrameType()) {
            case SQUARE: {
                BACKGROUND_FACTORY.createLinearBackground(n, n, this.getBackgroundColor(), this.getModel().getCustomBackground(), this.getModel().getTextureColor(), bufferedImage);
                break;
            }
            default: {
                BACKGROUND_FACTORY.createRadialBackground(n, this.getBackgroundColor(), this.getModel().getCustomBackground(), this.getModel().getTextureColor(), bufferedImage);
            }
        }
        if (this.isCustomLayerVisible()) {
            graphics2D.drawImage((Image)UTIL.getScaledInstance(this.getCustomLayer(), n2, n3, RenderingHints.VALUE_INTERPOLATION_BICUBIC), 0, 0, null);
        }
        FontRenderContext fontRenderContext = new FontRenderContext(null, true, true);
        if (!string.isEmpty()) {
            if (this.isLabelColorFromThemeEnabled()) {
                graphics2D.setColor(this.getModel().getBackgroundColor().LABEL_COLOR);
            } else {
                graphics2D.setColor(this.getModel().getLabelColor());
            }
            if (this.isTitleAndUnitFontEnabled()) {
                graphics2D.setFont(new Font(this.getTitleAndUnitFont().getFamily(), 0, (int)(0.04672897196261682 * (double)n2)));
            } else {
                graphics2D.setFont(new Font("Verdana", 0, (int)(0.04672897196261682 * (double)n2)));
            }
            textLayout = new TextLayout(string, graphics2D.getFont(), fontRenderContext);
            rectangle2D = textLayout.getBounds();
            graphics2D.drawString(string, (float)(((double)n2 - rectangle2D.getWidth()) / 2.0), 0.3f * (float)n3 + textLayout.getAscent() - textLayout.getDescent());
        }
        if (!string2.isEmpty()) {
            if (this.isLabelColorFromThemeEnabled()) {
                graphics2D.setColor(this.getModel().getBackgroundColor().LABEL_COLOR);
            } else {
                graphics2D.setColor(this.getModel().getLabelColor());
            }
            if (this.isTitleAndUnitFontEnabled()) {
                graphics2D.setFont(new Font(this.getTitleAndUnitFont().getFamily(), 0, (int)(0.04672897196261682 * (double)n2)));
            } else {
                graphics2D.setFont(new Font("Verdana", 0, (int)(0.04672897196261682 * (double)n2)));
            }
            textLayout = new TextLayout(string2, graphics2D.getFont(), fontRenderContext);
            rectangle2D = textLayout.getBounds();
            graphics2D.drawString(string2, (float)(((double)n2 - rectangle2D.getWidth()) / 2.0), 0.38f * (float)n3 + textLayout.getAscent() - textLayout.getDescent());
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    protected BufferedImage create_GLOW_Image(int n, Color color, boolean bl, GaugeType gaugeType, boolean bl2, Orientation orientation) {
        switch (this.getFrameType()) {
            case ROUND: {
                return GLOW_FACTORY.createRadialGlow(n, color, bl, gaugeType, bl2, orientation);
            }
            case SQUARE: {
                return GLOW_FACTORY.createLinearGlow(n, n, color, bl);
            }
        }
        return GLOW_FACTORY.createRadialGlow(n, color, bl, gaugeType, bl2, orientation);
    }

    protected BufferedImage create_TITLE_Image(int n, String string, String string2) {
        return this.create_TITLE_Image(n, string, string2, null);
    }

    protected BufferedImage create_TITLE_Image(int n, String string, String string2, BufferedImage bufferedImage) {
        Rectangle2D rectangle2D;
        TextLayout textLayout;
        if (n <= 0) {
            return UTIL.createImage(1, 1, 3);
        }
        if (bufferedImage == null) {
            bufferedImage = UTIL.createImage(n, n, 3);
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        FontRenderContext fontRenderContext = new FontRenderContext(null, true, true);
        if (!string.isEmpty()) {
            if (this.isLabelColorFromThemeEnabled()) {
                graphics2D.setColor(this.getBackgroundColor().LABEL_COLOR);
            } else {
                graphics2D.setColor(this.getLabelColor());
            }
            if (this.isTitleAndUnitFontEnabled()) {
                graphics2D.setFont(new Font(this.getTitleAndUnitFont().getFamily(), this.getTitleAndUnitFont().getStyle(), this.getTitleAndUnitFont().getSize()));
            } else {
                graphics2D.setFont(new Font("Verdana", 0, (int)(0.04672897196261682 * (double)n2)));
            }
            textLayout = new TextLayout(string, graphics2D.getFont(), fontRenderContext);
            rectangle2D = textLayout.getBounds();
            graphics2D.drawString(string, (float)(((double)n2 - rectangle2D.getWidth()) / 2.0), 0.3f * (float)n3 + textLayout.getAscent() - textLayout.getDescent());
        }
        if (!string2.isEmpty()) {
            if (this.isLabelColorFromThemeEnabled()) {
                graphics2D.setColor(this.getBackgroundColor().LABEL_COLOR);
            } else {
                graphics2D.setColor(this.getLabelColor());
            }
            if (this.isTitleAndUnitFontEnabled()) {
                graphics2D.setFont(new Font(this.getTitleAndUnitFont().getFamily(), this.getTitleAndUnitFont().getStyle(), this.getTitleAndUnitFont().getSize()));
            } else {
                graphics2D.setFont(new Font("Verdana", 0, (int)(0.04672897196261682 * (double)n2)));
            }
            textLayout = new TextLayout(string2, graphics2D.getFont(), fontRenderContext);
            rectangle2D = textLayout.getBounds();
            graphics2D.drawString(string2, (float)(((double)n2 - rectangle2D.getWidth()) / 2.0), 0.37f * (float)n3 + textLayout.getAscent() - textLayout.getDescent());
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    protected BufferedImage create_LCD_Image(int n, int n2, LcdColor lcdColor, Paint paint) {
        return this.create_LCD_Image(new Rectangle2D.Double(0.0, 0.0, n, n2), lcdColor, paint, null);
    }

    protected BufferedImage create_LCD_Image(Rectangle2D rectangle2D, LcdColor lcdColor, Paint paint, BufferedImage bufferedImage) {
        return LCD_FACTORY.create_LCD_Image(rectangle2D, lcdColor, paint, bufferedImage);
    }

    protected BufferedImage create_TRACK_Image(int n, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, Color color, Color color2, Color color3, float f, Point2D point2D, Direction direction, Point2D point2D2) {
        return this.create_TRACK_Image(n, d, d2, d3, d4, d5, d6, d7, d8, color, color2, color3, f, point2D, direction, point2D2, null);
    }

    protected BufferedImage create_TRACK_Image(int n, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, Color color, Color color2, Color color3, float f, Point2D point2D, Direction direction, Point2D point2D2, BufferedImage bufferedImage) {
        Color color4;
        double d9;
        double d10;
        double d11;
        float f2;
        if (n <= 0) {
            return UTIL.createImage(1, 1, 3);
        }
        if (bufferedImage == null) {
            bufferedImage = UTIL.createImage(n, n, 3);
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int n2 = bufferedImage.getWidth();
        if (point2D2 != null) {
            graphics2D.translate(point2D2.getX(), point2D2.getY());
        }
        switch (this.getGaugeType()) {
            case TYPE1: {
                f2 = (float)Math.toDegrees(1.5707963267948966 - d) * 0.00167f * (float)n * 0.0067f;
                break;
            }
            case TYPE2: {
                f2 = (float)Math.toDegrees(Math.PI - d) * 0.00167f * (float)n * 0.0067f;
                break;
            }
            case TYPE3: {
                f2 = (float)Math.toDegrees(4.71238898038469 - d) * 0.00167f * (float)n * 0.0067f;
                break;
            }
            case TYPE4: {
                f2 = (float)Math.toDegrees(Math.PI * 2 - d) * 0.00167f * (float)n * 0.0067f;
                break;
            }
            default: {
                f2 = (float)Math.toDegrees(Math.PI * 2 - d) * 0.00167f * (float)n * 0.0067f;
            }
        }
        if (f2 < 0.25f) {
            f2 = 0.25f;
        }
        BasicStroke basicStroke = new BasicStroke(f2, 1, 2);
        int n3 = (int)(0.035 * (double)n);
        float f3 = (float)n2 * f;
        Point2D.Double double_ = new Point2D.Double();
        Point2D.Double double_2 = new Point2D.Double();
        Line2D.Double double_3 = new Line2D.Double();
        double d12 = 0.0;
        double d13 = 0.0;
        switch (direction) {
            case COUNTER_CLOCKWISE: {
                double d14 = (d4 - d8) * d5;
                double d15 = (d4 - d7) * d5;
                double d16 = (d4 - d6) * d5;
                d11 = -d2 - d / 2.0 - d14;
                d10 = -d2 - d / 2.0 - d15;
                d9 = -d2 - d / 2.0 - d16;
                color4 = color3;
                break;
            }
            default: {
                double d14 = d6 * d5;
                double d15 = d7 * d5;
                double d16 = d8 * d5;
                d11 = -d2 - d / 2.0 - d14 + d3 * d5;
                d10 = -d2 - d / 2.0 - d15 + d3 * d5;
                d9 = -d2 - d / 2.0 - d16 + d3 * d5;
                color4 = color;
            }
        }
        double d17 = 1000.0 / (d4 - d3) < 10.0 ? 10.0 : 1000.0 / (d4 - d3);
        double d18 = 1.0 / d17;
        graphics2D.setStroke(basicStroke);
        float f4 = 0.0f;
        double d19 = d11;
        while (Double.compare(d19, d10) >= 0) {
            d12 = Math.sin(d19);
            d13 = Math.cos(d19);
            switch (direction) {
                case CLOCKWISE: {
                    color4 = UTIL.getColorFromFraction(color, color2, (int)(d7 - d6), (int)f4);
                    break;
                }
                case COUNTER_CLOCKWISE: {
                    color4 = UTIL.getColorFromFraction(color3, color2, (int)(d8 - d7), (int)f4);
                }
            }
            graphics2D.setColor(color4);
            ((Point2D)double_).setLocation(point2D.getX() + (double)(f3 - (float)n3) * d12, point2D.getY() + (double)(f3 - (float)n3) * d13);
            ((Point2D)double_2).setLocation(point2D.getX() + (double)f3 * d12, point2D.getY() + (double)f3 * d13);
            double_3.setLine(double_, double_2);
            graphics2D.draw(double_3);
            d19 -= d5 / d17;
            f4 = (float)((double)f4 + d18);
        }
        f4 = 0.0f;
        d19 = d10;
        while (Double.compare(d19, d9) >= 0) {
            d12 = Math.sin(d19);
            d13 = Math.cos(d19);
            switch (direction) {
                case CLOCKWISE: {
                    color4 = UTIL.getColorFromFraction(color2, color3, (int)(d8 - d7), (int)f4);
                    break;
                }
                case COUNTER_CLOCKWISE: {
                    color4 = UTIL.getColorFromFraction(color2, color, (int)(d7 - d6), (int)f4);
                }
            }
            graphics2D.setColor(color4);
            ((Point2D)double_).setLocation(point2D.getX() + (double)(f3 - (float)n3) * d12, point2D.getY() + (double)(f3 - (float)n3) * d13);
            ((Point2D)double_2).setLocation(point2D.getX() + (double)f3 * d12, point2D.getY() + (double)f3 * d13);
            double_3.setLine(double_, double_2);
            graphics2D.draw(double_3);
            d19 -= d5 / d17;
            f4 = (float)((double)f4 + d18);
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    protected BufferedImage create_POSTS_Image(int n, PostPosition ... postPositionArray) {
        return this.create_POSTS_Image(n, (BufferedImage)null, postPositionArray);
    }

    protected BufferedImage create_POSTS_Image(int n, BufferedImage bufferedImage, PostPosition ... postPositionArray) {
        Object object;
        Object object2;
        Object object3;
        Cloneable cloneable;
        Object object4;
        Color[] colorArray;
        Object object5;
        Object object6;
        Object object7;
        Cloneable cloneable2;
        Object object8;
        Color[] colorArray2;
        Object object9;
        Color[] colorArray3;
        Object object10;
        Object object11;
        Color[] colorArray4;
        Object object12;
        Color[] colorArray5;
        Object object13;
        Object object14;
        Color[] colorArray6;
        Object object15;
        Color[] colorArray7;
        Object object16;
        Cloneable cloneable3;
        Object object17;
        Color[] colorArray8;
        Object object18;
        Color[] colorArray9;
        Object object19;
        Cloneable cloneable4;
        Object object20;
        Color[] colorArray10;
        Object object21;
        Object object22;
        Object object23;
        Cloneable cloneable5;
        Object object24;
        Color[] colorArray11;
        Object object25;
        Object object26;
        Object object27;
        Cloneable cloneable6;
        Object object28;
        Color[] colorArray12;
        Object object29;
        Color[] colorArray13;
        Object object30;
        Object object31;
        Color[] colorArray14;
        Object object32;
        Object object33;
        Object object34;
        Cloneable cloneable7;
        Object object35;
        Color[] colorArray15;
        Object object36;
        Color[] colorArray16;
        Object object37;
        Cloneable cloneable8;
        Object object38;
        Color[] colorArray17;
        Object object39;
        Color[] colorArray18;
        Object object40;
        Cloneable cloneable9;
        Object object41;
        Color[] colorArray19;
        Object object42;
        Color[] colorArray20;
        Object object43;
        Cloneable cloneable10;
        Object object44;
        Color[] colorArray21;
        Object object45;
        Color[] colorArray22;
        Object object46;
        Cloneable cloneable11;
        Object object47;
        Color[] colorArray23;
        Object object48;
        Color[] colorArray24;
        Object object49;
        Object object50;
        Color[] colorArray25;
        Object object51;
        Color[] colorArray26;
        Object object52;
        Cloneable cloneable12;
        Object object53;
        Color[] colorArray27;
        Object object54;
        Color[] colorArray28;
        Object object55;
        Cloneable cloneable13;
        Point2D.Double double_;
        Cloneable cloneable14;
        if (n <= 0) {
            return UTIL.createImage(1, 1, 3);
        }
        if (bufferedImage == null) {
            bufferedImage = UTIL.createImage(n, n, 3);
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        BufferedImage bufferedImage2 = this.create_KNOB_Image((int)Math.ceil((double)n * 0.03738316893577576), KnobType.SMALL_STD_KNOB, this.getModel().getKnobStyle());
        List<PostPosition> list = Arrays.asList(postPositionArray);
        if (list.contains((Object)PostPosition.CENTER)) {
            switch (this.getKnobType()) {
                case SMALL_STD_KNOB: {
                    cloneable14 = new Ellipse2D.Double((double)n2 * 0.4579439163208008, (double)n3 * 0.4579439163208008, (double)n2 * 0.08411216735839844, (double)n3 * 0.08411216735839844);
                    double_ = new Point2D.Double(0.0, cloneable14.getBounds2D().getMinY());
                    cloneable13 = new Point2D.Double(0.0, cloneable14.getBounds2D().getMaxY());
                    object55 = new float[]{0.0f, 0.46f, 1.0f};
                    colorArray28 = new Color[]{new Color(180, 180, 180, 255), new Color(63, 63, 63, 255), new Color(40, 40, 40, 255)};
                    object54 = new LinearGradientPaint(double_, (Point2D)cloneable13, (float[])object55, colorArray28);
                    graphics2D.setPaint((Paint)object54);
                    graphics2D.fill((Shape)((Object)cloneable14));
                    colorArray27 = new Ellipse2D.Double((double)n2 * 0.4672897160053253, (double)n3 * 0.4672897160053253, (double)n2 * 0.06542053818702698, (double)n3 * 0.06542053818702698);
                    object53 = new Point2D.Double(0.0, colorArray27.getBounds2D().getMinY());
                    cloneable12 = new Point2D.Double(0.0, colorArray27.getBounds2D().getMaxY());
                    object52 = new float[]{0.0f, 0.5f, 1.0f};
                    switch (this.getModel().getKnobStyle()) {
                        case BLACK: {
                            colorArray26 = new Color[]{new Color(0xBFBFBF), new Color(2828847), new Color(8224384)};
                            break;
                        }
                        case BRASS: {
                            colorArray26 = new Color[]{new Color(14667950), new Color(8019518), new Color(13614749)};
                            break;
                        }
                        default: {
                            colorArray26 = new Color[]{new Color(0xD7D7D7), new Color(0x747474), new Color(0xD7D7D7)};
                        }
                    }
                    object51 = new LinearGradientPaint((Point2D)object53, (Point2D)cloneable12, (float[])object52, colorArray26);
                    graphics2D.setPaint((Paint)object51);
                    graphics2D.fill((Shape)colorArray27);
                    colorArray25 = new Ellipse2D.Double((double)n2 * 0.4672897160053253, (double)n3 * 0.4672897160053253, (double)n2 * 0.06542053818702698, (double)n3 * 0.06542053818702698);
                    object50 = new Point2D.Double(0.4953271028037383 * (double)n2, 0.49065420560747663 * (double)n3);
                    object49 = new float[]{0.0f, 0.75f, 0.76f, 1.0f};
                    colorArray24 = new Color[]{new Color(0, 0, 0, 0), new Color(0, 0, 0, 0), new Color(0, 0, 0, 1), new Color(0, 0, 0, 51)};
                    object48 = new RadialGradientPaint((Point2D)object50, (float)(0.03271028037383177 * (double)n2), (float[])object49, colorArray24);
                    graphics2D.setPaint((Paint)object48);
                    graphics2D.fill((Shape)colorArray25);
                    break;
                }
                case BIG_STD_KNOB: {
                    colorArray23 = new Ellipse2D.Double((double)n2 * 0.4392523467540741, (double)n3 * 0.4392523467540741, (double)n2 * 0.1214953362941742, (double)n3 * 0.1214953362941742);
                    object47 = new Point2D.Double(0.0, colorArray23.getBounds2D().getMinY());
                    cloneable11 = new Point2D.Double(0.0, colorArray23.getBounds2D().getMaxY());
                    object46 = new float[]{0.0f, 1.0f};
                    switch (this.getModel().getKnobStyle()) {
                        case BLACK: {
                            colorArray22 = new Color[]{new Color(129, 133, 136, 255), new Color(61, 61, 73, 255)};
                            break;
                        }
                        case BRASS: {
                            colorArray22 = new Color[]{new Color(143, 117, 80, 255), new Color(100, 76, 49, 255)};
                            break;
                        }
                        default: {
                            colorArray22 = new Color[]{new Color(152, 152, 152, 255), new Color(118, 121, 126, 255)};
                        }
                    }
                    object45 = new LinearGradientPaint((Point2D)object47, (Point2D)cloneable11, (float[])object46, colorArray22);
                    graphics2D.setPaint((Paint)object45);
                    graphics2D.fill((Shape)colorArray23);
                    colorArray21 = new Ellipse2D.Double((double)n2 * 0.44392523169517517, (double)n3 * 0.44392523169517517, (double)n2 * 0.11214950680732727, (double)n3 * 0.11214950680732727);
                    object44 = new Point2D.Double(0.0, colorArray21.getBounds2D().getMinY());
                    cloneable10 = new Point2D.Double(0.0, colorArray21.getBounds2D().getMaxY());
                    object43 = new float[]{0.0f, 1.0f};
                    switch (this.getModel().getKnobStyle()) {
                        case BLACK: {
                            colorArray20 = new Color[]{new Color(26, 27, 32, 255), new Color(96, 97, 102, 255)};
                            break;
                        }
                        case BRASS: {
                            colorArray20 = new Color[]{new Color(98, 75, 49, 255), new Color(149, 109, 54, 255)};
                            break;
                        }
                        default: {
                            colorArray20 = new Color[]{new Color(118, 121, 126, 255), new Color(191, 191, 191, 255)};
                        }
                    }
                    object42 = new LinearGradientPaint((Point2D)object44, (Point2D)cloneable10, (float[])object43, colorArray20);
                    graphics2D.setPaint((Paint)object42);
                    graphics2D.fill((Shape)colorArray21);
                    colorArray19 = new Ellipse2D.Double((double)n2 * 0.4532710313796997, (double)n3 * 0.4532710313796997, (double)n2 * 0.09345793724060059, (double)n3 * 0.09345793724060059);
                    object41 = new Point2D.Double(0.0, colorArray19.getBounds2D().getMinY());
                    cloneable9 = new Point2D.Double(0.0, colorArray19.getBounds2D().getMaxY());
                    object40 = new float[]{0.0f, 0.47f, 1.0f};
                    switch (this.getModel().getKnobStyle()) {
                        case BLACK: {
                            colorArray18 = new Color[]{new Color(191, 191, 191, 255), new Color(56, 57, 61, 255), new Color(143, 144, 146, 255)};
                            break;
                        }
                        case BRASS: {
                            colorArray18 = new Color[]{new Color(147, 108, 54, 255), new Color(82, 66, 50, 255), new Color(147, 108, 54, 255)};
                            break;
                        }
                        default: {
                            colorArray18 = new Color[]{new Color(191, 191, 191, 255), new Color(116, 116, 116, 255), new Color(143, 144, 146, 255)};
                        }
                    }
                    object39 = new LinearGradientPaint((Point2D)object41, (Point2D)cloneable9, (float[])object40, colorArray18);
                    graphics2D.setPaint((Paint)object39);
                    graphics2D.fill((Shape)colorArray19);
                    colorArray17 = new Ellipse2D.Double((double)n2 * 0.4579439163208008, (double)n3 * 0.4579439163208008, (double)n2 * 0.08411216735839844, (double)n3 * 0.08411216735839844);
                    object38 = new Point2D.Double(0.0, colorArray17.getBounds2D().getMinY());
                    cloneable8 = new Point2D.Double(0.0, colorArray17.getBounds2D().getMaxY());
                    object37 = new float[]{0.0f, 0.21f, 0.5f, 0.78f, 1.0f};
                    switch (this.getModel().getKnobStyle()) {
                        case BLACK: {
                            colorArray16 = new Color[]{new Color(191, 191, 191, 255), new Color(94, 93, 99, 255), new Color(43, 42, 47, 255), new Color(78, 79, 81, 255), new Color(143, 144, 146, 255)};
                            break;
                        }
                        case BRASS: {
                            colorArray16 = new Color[]{new Color(223, 208, 174, 255), new Color(159, 136, 104, 255), new Color(122, 94, 62, 255), new Color(159, 136, 104, 255), new Color(223, 208, 174, 255)};
                            break;
                        }
                        default: {
                            colorArray16 = new Color[]{new Color(215, 215, 215, 255), new Color(139, 142, 145, 255), new Color(100, 100, 100, 255), new Color(139, 142, 145, 255), new Color(215, 215, 215, 255)};
                        }
                    }
                    object36 = new LinearGradientPaint((Point2D)object38, (Point2D)cloneable8, (float[])object37, colorArray16);
                    graphics2D.setPaint((Paint)object36);
                    graphics2D.fill((Shape)colorArray17);
                    break;
                }
                case BIG_CHROME_KNOB: {
                    colorArray15 = new Ellipse2D.Double((double)n2 * 0.42990654706954956, (double)n3 * 0.42990654706954956, (double)n2 * (double)0.1401869f, (double)n3 * (double)0.1401869f);
                    object35 = new Point2D.Double(0.46261682242990654 * (double)n2, 0.4392523364485981 * (double)n3);
                    cloneable7 = new Point2D.Double(0.534428311508238 * (double)n2, 0.5541747420025063 * (double)n3);
                    object34 = new float[]{0.0f, 1.0f};
                    object33 = new Color[]{new Color(129, 139, 140, 255), new Color(166, 171, 175, 255)};
                    object32 = new LinearGradientPaint((Point2D)object35, (Point2D)cloneable7, (float[])object34, (Color[])object33);
                    graphics2D.setPaint((Paint)object32);
                    graphics2D.fill((Shape)colorArray15);
                    colorArray14 = new Ellipse2D.Double((double)n2 * 0.43457943201065063, (double)n3 * 0.43457943201065063, (double)n2 * 0.13084113597869873, (double)n3 * 0.13084113597869873);
                    object31 = new Point2D.Double(colorArray14.getCenterX(), colorArray14.getCenterY());
                    object30 = new float[]{0.0f, 0.09f, 0.12f, 0.16f, 0.25f, 0.29f, 0.33f, 0.38f, 0.48f, 0.52f, 0.65f, 0.69f, 0.8f, 0.83f, 0.87f, 0.97f, 1.0f};
                    colorArray13 = new Color[]{new Color(255, 255, 255, 255), new Color(255, 255, 255, 255), new Color(136, 136, 138, 255), new Color(164, 185, 190, 255), new Color(158, 179, 182, 255), new Color(112, 112, 112, 255), new Color(221, 227, 227, 255), new Color(155, 176, 179, 255), new Color(156, 176, 177, 255), new Color(254, 255, 255, 255), new Color(255, 255, 255, 255), new Color(156, 180, 180, 255), new Color(198, 209, 211, 255), new Color(246, 248, 247, 255), new Color(204, 216, 216, 255), new Color(164, 188, 190, 255), new Color(255, 255, 255, 255)};
                    object29 = new ConicalGradientPaint(false, (Point2D)object31, 0.0f, (float[])object30, colorArray13);
                    graphics2D.setPaint((Paint)object29);
                    graphics2D.fill((Shape)colorArray14);
                    colorArray12 = new Ellipse2D.Double((double)n2 * 0.4672897160053253, (double)n3 * 0.4672897160053253, (double)n2 * 0.06542053818702698, (double)n3 * 0.06542053818702698);
                    object28 = new Point2D.Double(0.48130841121495327 * (double)n2, 0.4719626168224299 * (double)n3);
                    cloneable6 = new Point2D.Double(0.5152780735753257 * (double)n2, 0.5223247123514745 * (double)n3);
                    object27 = new float[]{0.0f, 1.0f};
                    object26 = new Color[]{new Color(225, 235, 232, 255), new Color(196, 207, 207, 255)};
                    object25 = new LinearGradientPaint((Point2D)object28, (Point2D)cloneable6, (float[])object27, (Color[])object26);
                    graphics2D.setPaint((Paint)object25);
                    graphics2D.fill((Shape)colorArray12);
                    colorArray11 = new Ellipse2D.Double((double)n2 * 0.4719626307487488, (double)n3 * 0.4719626307487488, (double)n2 * 0.05607473850250244, (double)n3 * 0.05607473850250244);
                    object24 = new Point2D.Double(0.48130841121495327 * (double)n2, 0.4766355140186916 * (double)n3);
                    cloneable5 = new Point2D.Double(0.5126650226245278 * (double)n2, 0.5231236021993482 * (double)n3);
                    object23 = new float[]{0.0f, 1.0f};
                    object22 = new Color[]{new Color(237, 239, 237, 255), new Color(148, 161, 161, 255)};
                    object21 = new LinearGradientPaint((Point2D)object24, (Point2D)cloneable5, (float[])object23, (Color[])object22);
                    graphics2D.setPaint((Paint)object21);
                    graphics2D.fill((Shape)colorArray11);
                    break;
                }
                case METAL_KNOB: {
                    colorArray10 = new Ellipse2D.Double((double)n2 * 0.4579439163208008, (double)n3 * 0.4579439163208008, (double)n2 * 0.08411216735839844, (double)n3 * 0.08411216735839844);
                    object20 = new Point2D.Double(0.0, colorArray10.getBounds2D().getMinY());
                    cloneable4 = new Point2D.Double(0.0, colorArray10.getBounds2D().getMaxY());
                    object19 = new float[]{0.0f, 0.47f, 1.0f};
                    colorArray9 = new Color[]{new Color(92, 95, 101, 255), new Color(46, 49, 53, 255), new Color(22, 23, 26, 255)};
                    object18 = new LinearGradientPaint((Point2D)object20, (Point2D)cloneable4, (float[])object19, colorArray9);
                    graphics2D.setPaint((Paint)object18);
                    graphics2D.fill((Shape)colorArray10);
                    colorArray8 = new Ellipse2D.Double((double)n2 * 0.46261683106422424, (double)n3 * 0.46261683106422424, (double)n2 * 0.0747663676738739, (double)n3 * 0.0747663676738739);
                    object17 = new Point2D.Double(0.0, colorArray8.getBounds2D().getMinY());
                    cloneable3 = new Point2D.Double(0.0, colorArray8.getBounds2D().getMaxY());
                    object16 = new float[]{0.0f, 1.0f};
                    switch (this.getModel().getKnobStyle()) {
                        case BLACK: {
                            colorArray7 = new Color[]{new Color(2828847), new Color(1710880)};
                            break;
                        }
                        case BRASS: {
                            colorArray7 = new Color[]{new Color(9858614), new Color(8150845)};
                            break;
                        }
                        default: {
                            colorArray7 = new Color[]{new Color(204, 204, 204, 255), new Color(87, 92, 98, 255)};
                        }
                    }
                    object15 = new LinearGradientPaint((Point2D)object17, (Point2D)cloneable3, (float[])object16, colorArray7);
                    graphics2D.setPaint((Paint)object15);
                    graphics2D.fill((Shape)colorArray8);
                    colorArray6 = new GeneralPath();
                    colorArray6.setWindingRule(0);
                    colorArray6.moveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.5280373831775701);
                    colorArray6.curveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.5186915887850467, (double)n2 * 0.5093457943925234, (double)n3 * 0.514018691588785, (double)n2 * 0.5, (double)n3 * 0.514018691588785);
                    colorArray6.curveTo((double)n2 * 0.48598130841121495, (double)n3 * 0.514018691588785, (double)n2 * 0.4766355140186916, (double)n3 * 0.5186915887850467, (double)n2 * 0.4766355140186916, (double)n3 * 0.5280373831775701);
                    colorArray6.curveTo((double)n2 * 0.48130841121495327, (double)n3 * 0.5327102803738317, (double)n2 * 0.49065420560747663, (double)n3 * 0.5373831775700935, (double)n2 * 0.5, (double)n3 * 0.5373831775700935);
                    colorArray6.curveTo((double)n2 * 0.5046728971962616, (double)n3 * 0.5373831775700935, (double)n2 * 0.514018691588785, (double)n3 * 0.5327102803738317, (double)n2 * 0.5186915887850467, (double)n3 * 0.5280373831775701);
                    colorArray6.closePath();
                    object14 = new Point2D.Double(0.5 * (double)n2, 0.5373831775700935 * (double)n3);
                    object13 = new float[]{0.0f, 1.0f};
                    colorArray5 = new Color[]{new Color(255, 255, 255, 153), new Color(255, 255, 255, 0)};
                    object12 = new RadialGradientPaint((Point2D)object14, (float)(0.03271028037383177 * (double)n2), (float[])object13, colorArray5);
                    graphics2D.setPaint((Paint)object12);
                    graphics2D.fill((Shape)colorArray6);
                    colorArray4 = new GeneralPath();
                    colorArray4.setWindingRule(0);
                    colorArray4.moveTo((double)n2 * 0.5327102803738317, (double)n3 * 0.48130841121495327);
                    colorArray4.curveTo((double)n2 * 0.5280373831775701, (double)n3 * 0.4672897196261682, (double)n2 * 0.514018691588785, (double)n3 * 0.45794392523364486, (double)n2 * 0.5, (double)n3 * 0.45794392523364486);
                    colorArray4.curveTo((double)n2 * 0.48130841121495327, (double)n3 * 0.45794392523364486, (double)n2 * 0.4672897196261682, (double)n3 * 0.4672897196261682, (double)n2 * 0.46261682242990654, (double)n3 * 0.48130841121495327);
                    colorArray4.curveTo((double)n2 * 0.4672897196261682, (double)n3 * 0.48598130841121495, (double)n2 * 0.48130841121495327, (double)n3 * 0.49065420560747663, (double)n2 * 0.5, (double)n3 * 0.49065420560747663);
                    colorArray4.curveTo((double)n2 * 0.514018691588785, (double)n3 * 0.49065420560747663, (double)n2 * 0.5280373831775701, (double)n3 * 0.48598130841121495, (double)n2 * 0.5327102803738317, (double)n3 * 0.48130841121495327);
                    colorArray4.closePath();
                    object11 = new Point2D.Double(0.4953271028037383 * (double)n2, 0.45794392523364486 * (double)n3);
                    object10 = new float[]{0.0f, 1.0f};
                    colorArray3 = new Color[]{new Color(255, 255, 255, 191), new Color(255, 255, 255, 0)};
                    object9 = new RadialGradientPaint((Point2D)object11, (float)(0.04906542056074766 * (double)n2), (float[])object10, colorArray3);
                    graphics2D.setPaint((Paint)object9);
                    graphics2D.fill((Shape)colorArray4);
                    colorArray2 = new Ellipse2D.Double((double)n2 * 0.47663551568984985, (double)n3 * 0.4813084006309509, (double)n2 * 0.04205608367919922, (double)n3 * 0.04205608367919922);
                    object8 = new Point2D.Double(0.0, colorArray2.getBounds2D().getMinY());
                    cloneable2 = new Point2D.Double(0.0, colorArray2.getBounds2D().getMaxY());
                    object7 = new float[]{0.0f, 1.0f};
                    object6 = new Color[]{new Color(0, 0, 0, 255), new Color(204, 204, 204, 255)};
                    object5 = new LinearGradientPaint((Point2D)object8, (Point2D)cloneable2, (float[])object7, (Color[])object6);
                    graphics2D.setPaint((Paint)object5);
                    graphics2D.fill((Shape)colorArray2);
                    colorArray = new Ellipse2D.Double((double)n2 * 0.4813084006309509, (double)n3 * 0.4859813153743744, (double)n2 * 0.03271031379699707, (double)n3 * 0.03271028399467468);
                    object4 = new Point2D.Double(0.0, colorArray.getBounds2D().getMinY());
                    cloneable = new Point2D.Double(0.0, colorArray.getBounds2D().getMaxY());
                    object3 = new float[]{0.0f, 1.0f};
                    object2 = new Color[]{new Color(1, 6, 11, 255), new Color(50, 52, 56, 255)};
                    object = new LinearGradientPaint((Point2D)object4, (Point2D)cloneable, (float[])object3, (Color[])object2);
                    graphics2D.setPaint((Paint)object);
                    graphics2D.fill((Shape)colorArray);
                }
            }
        }
        if (list.contains((Object)PostPosition.MIN_BOTTOM)) {
            graphics2D.drawImage((Image)bufferedImage2, (int)((double)n2 * 0.336448609828949), (int)((double)n3 * 0.8037382960319519), null);
        }
        if (list.contains((Object)PostPosition.MAX_BOTTOM)) {
            graphics2D.drawImage((Image)bufferedImage2, (int)((double)n2 * 0.6261682510375977), (int)((double)n3 * 0.8037382960319519), null);
        }
        if (list.contains((Object)PostPosition.MAX_CENTER_BOTTOM)) {
            graphics2D.drawImage((Image)bufferedImage2, (int)((double)n2 * 0.5233644843101501), (int)((double)n3 * 0.8317757248878479), null);
        }
        if (list.contains((Object)PostPosition.MAX_CENTER_TOP)) {
            graphics2D.drawImage((Image)bufferedImage2, (int)((double)n2 * 0.5233644843101501), (int)((double)n3 * 0.13084112107753754), null);
        }
        if (list.contains((Object)PostPosition.MAX_RIGHT)) {
            graphics2D.drawImage((Image)bufferedImage2, (int)((double)n2 * 0.8317757248878479), (int)((double)n3 * 0.514018714427948), null);
        }
        if (list.contains((Object)PostPosition.MIN_LEFT)) {
            graphics2D.drawImage((Image)bufferedImage2, (int)((double)n2 * 0.13084112107753754), (int)((double)n3 * 0.514018714427948), null);
        }
        cloneable14 = graphics2D.getTransform();
        double_ = new Point2D.Double();
        if (list.contains((Object)PostPosition.LOWER_CENTER)) {
            switch (this.getKnobType()) {
                case SMALL_STD_KNOB: {
                    cloneable13 = new Ellipse2D.Double((double)n2 * 0.4579439163208008, (double)n3 * 0.6915887594223022, (double)n2 * 0.08411216735839844, (double)n3 * 0.08411216735839844);
                    switch (this.getOrientation()) {
                        case WEST: {
                            ((Point2D)double_).setLocation(((RectangularShape)cloneable13).getCenterX(), ((RectangularShape)cloneable13).getCenterY());
                            graphics2D.rotate(1.5707963267948966, ((Point2D)double_).getX(), ((Point2D)double_).getY());
                        }
                    }
                    object55 = new Point2D.Double(0.0, cloneable13.getBounds2D().getMinY());
                    colorArray28 = new Point2D.Double(0.0, cloneable13.getBounds2D().getMaxY());
                    object54 = new float[]{0.0f, 0.46f, 1.0f};
                    colorArray27 = new Color[]{new Color(180, 180, 180, 255), new Color(63, 63, 63, 255), new Color(40, 40, 40, 255)};
                    object53 = new LinearGradientPaint((Point2D)object55, (Point2D)colorArray28, (float[])object54, colorArray27);
                    graphics2D.setPaint((Paint)object53);
                    graphics2D.fill((Shape)((Object)cloneable13));
                    cloneable12 = new Ellipse2D.Double((double)n2 * 0.4672897160053253, (double)n3 * 0.7009345889091492, (double)n2 * 0.06542053818702698, (double)n3 * 0.06542056798934937);
                    object52 = new Point2D.Double(0.0, cloneable12.getBounds2D().getMinY());
                    colorArray26 = new Point2D.Double(0.0, cloneable12.getBounds2D().getMaxY());
                    object51 = new float[]{0.0f, 0.5f, 1.0f};
                    switch (this.getModel().getKnobStyle()) {
                        case BLACK: {
                            colorArray25 = new Color[]{new Color(0xBFBFBF), new Color(2828847), new Color(8224384)};
                            break;
                        }
                        case BRASS: {
                            colorArray25 = new Color[]{new Color(14667950), new Color(8019518), new Color(13614749)};
                            break;
                        }
                        default: {
                            colorArray25 = new Color[]{new Color(0xD7D7D7), new Color(0x747474), new Color(0xD7D7D7)};
                        }
                    }
                    object50 = new LinearGradientPaint((Point2D)object52, (Point2D)colorArray26, (float[])object51, colorArray25);
                    graphics2D.setPaint((Paint)object50);
                    graphics2D.fill((Shape)((Object)cloneable12));
                    object49 = new Ellipse2D.Double((double)n2 * 0.4672897160053253, (double)n3 * 0.7009345889091492, (double)n2 * 0.06542053818702698, (double)n3 * 0.06542056798934937);
                    colorArray24 = new Point2D.Double(0.4953271028037383 * (double)n2, 0.7242990654205608 * (double)n3);
                    object48 = new float[]{0.0f, 0.75f, 0.76f, 1.0f};
                    colorArray23 = new Color[]{new Color(0, 0, 0, 0), new Color(0, 0, 0, 0), new Color(0, 0, 0, 1), new Color(0, 0, 0, 51)};
                    object47 = new RadialGradientPaint((Point2D)colorArray24, (float)(0.03271028037383177 * (double)n2), (float[])object48, colorArray23);
                    graphics2D.setPaint((Paint)object47);
                    graphics2D.fill((Shape)object49);
                    break;
                }
                case BIG_STD_KNOB: {
                    cloneable11 = new Ellipse2D.Double((double)n2 * 0.4392523467540741, (double)n3 * 0.672897219657898, (double)n2 * 0.1214953362941742, (double)n3 * 0.1214953064918518);
                    switch (this.getOrientation()) {
                        case WEST: {
                            ((Point2D)double_).setLocation(((RectangularShape)cloneable11).getCenterX(), ((RectangularShape)cloneable11).getCenterY());
                            graphics2D.rotate(1.5707963267948966, ((Point2D)double_).getX(), ((Point2D)double_).getY());
                        }
                    }
                    object46 = new Point2D.Double(0.0, cloneable11.getBounds2D().getMinY());
                    colorArray22 = new Point2D.Double(0.0, cloneable11.getBounds2D().getMaxY());
                    object45 = new float[]{0.0f, 1.0f};
                    switch (this.getModel().getKnobStyle()) {
                        case BLACK: {
                            colorArray21 = new Color[]{new Color(129, 133, 136, 255), new Color(61, 61, 73, 255)};
                            break;
                        }
                        case BRASS: {
                            colorArray21 = new Color[]{new Color(143, 117, 80, 255), new Color(100, 76, 49, 255)};
                            break;
                        }
                        default: {
                            colorArray21 = new Color[]{new Color(152, 152, 152, 255), new Color(118, 121, 126, 255)};
                        }
                    }
                    object44 = new LinearGradientPaint((Point2D)object46, (Point2D)colorArray22, (float[])object45, colorArray21);
                    graphics2D.setPaint((Paint)object44);
                    graphics2D.fill((Shape)((Object)cloneable11));
                    cloneable10 = new Ellipse2D.Double((double)n2 * 0.44392523169517517, (double)n3 * 0.677570104598999, (double)n2 * 0.11214950680732727, (double)n3 * 0.11214953660964966);
                    object43 = new Point2D.Double(0.0, cloneable10.getBounds2D().getMinY());
                    colorArray20 = new Point2D.Double(0.0, cloneable10.getBounds2D().getMaxY());
                    object42 = new float[]{0.0f, 1.0f};
                    switch (this.getModel().getKnobStyle()) {
                        case BLACK: {
                            colorArray19 = new Color[]{new Color(26, 27, 32, 255), new Color(96, 97, 102, 255)};
                            break;
                        }
                        case BRASS: {
                            colorArray19 = new Color[]{new Color(98, 75, 49, 255), new Color(149, 109, 54, 255)};
                            break;
                        }
                        default: {
                            colorArray19 = new Color[]{new Color(118, 121, 126, 255), new Color(191, 191, 191, 255)};
                        }
                    }
                    object41 = new LinearGradientPaint((Point2D)object43, (Point2D)colorArray20, (float[])object42, colorArray19);
                    graphics2D.setPaint((Paint)object41);
                    graphics2D.fill((Shape)((Object)cloneable10));
                    cloneable9 = new Ellipse2D.Double((double)n2 * 0.4532710313796997, (double)n3 * 0.6869158744812012, (double)n2 * 0.09345793724060059, (double)n3 * 0.09345793724060059);
                    object40 = new Point2D.Double(0.0, cloneable9.getBounds2D().getMinY());
                    colorArray18 = new Point2D.Double(0.0, cloneable9.getBounds2D().getMaxY());
                    object39 = new float[]{0.0f, 0.47f, 1.0f};
                    switch (this.getModel().getKnobStyle()) {
                        case BLACK: {
                            colorArray17 = new Color[]{new Color(191, 191, 191, 255), new Color(56, 57, 61, 255), new Color(143, 144, 146, 255)};
                            break;
                        }
                        case BRASS: {
                            colorArray17 = new Color[]{new Color(147, 108, 54, 255), new Color(82, 66, 50, 255), new Color(147, 108, 54, 255)};
                            break;
                        }
                        default: {
                            colorArray17 = new Color[]{new Color(191, 191, 191, 255), new Color(116, 116, 116, 255), new Color(143, 144, 146, 255)};
                        }
                    }
                    object38 = new LinearGradientPaint((Point2D)object40, (Point2D)colorArray18, (float[])object39, colorArray17);
                    graphics2D.setPaint((Paint)object38);
                    graphics2D.fill((Shape)((Object)cloneable9));
                    cloneable8 = new Ellipse2D.Double((double)n2 * 0.4579439163208008, (double)n3 * 0.6915887594223022, (double)n2 * 0.08411216735839844, (double)n3 * 0.08411216735839844);
                    object37 = new Point2D.Double(0.0, cloneable8.getBounds2D().getMinY());
                    colorArray16 = new Point2D.Double(0.0, cloneable8.getBounds2D().getMaxY());
                    object36 = new float[]{0.0f, 0.21f, 0.5f, 0.78f, 1.0f};
                    switch (this.getModel().getKnobStyle()) {
                        case BLACK: {
                            colorArray15 = new Color[]{new Color(191, 191, 191, 255), new Color(94, 93, 99, 255), new Color(43, 42, 47, 255), new Color(78, 79, 81, 255), new Color(143, 144, 146, 255)};
                            break;
                        }
                        case BRASS: {
                            colorArray15 = new Color[]{new Color(223, 208, 174, 255), new Color(159, 136, 104, 255), new Color(122, 94, 62, 255), new Color(159, 136, 104, 255), new Color(223, 208, 174, 255)};
                            break;
                        }
                        default: {
                            colorArray15 = new Color[]{new Color(215, 215, 215, 255), new Color(139, 142, 145, 255), new Color(100, 100, 100, 255), new Color(139, 142, 145, 255), new Color(215, 215, 215, 255)};
                        }
                    }
                    object35 = new LinearGradientPaint((Point2D)object37, (Point2D)colorArray16, (float[])object36, colorArray15);
                    graphics2D.setPaint((Paint)object35);
                    graphics2D.fill((Shape)((Object)cloneable8));
                    break;
                }
                case BIG_CHROME_KNOB: {
                    cloneable7 = new Ellipse2D.Double((double)n2 * (double)0.4f, (double)n3 * 0.6333333253860474, (double)n2 * 0.20000001788139343, (double)n3 * 0.19999998807907104);
                    switch (this.getOrientation()) {
                        case WEST: {
                            ((Point2D)double_).setLocation(((RectangularShape)cloneable7).getCenterX(), ((RectangularShape)cloneable7).getCenterY());
                            graphics2D.rotate(1.5707963267948966, ((Point2D)double_).getX(), ((Point2D)double_).getY());
                        }
                    }
                    object34 = new Point2D.Double(0.44666666666666666 * (double)n2, 0.6466666666666666 * (double)n3);
                    object33 = new Point2D.Double(0.5491177244184196 * (double)n2, 0.8106226319235756 * (double)n3);
                    object32 = new float[]{0.0f, 1.0f};
                    colorArray14 = new Color[]{new Color(129, 139, 140, 255), new Color(166, 171, 175, 255)};
                    object31 = new LinearGradientPaint((Point2D)object34, (Point2D)object33, (float[])object32, colorArray14);
                    graphics2D.setPaint((Paint)object31);
                    graphics2D.fill((Shape)((Object)cloneable7));
                    object30 = new Ellipse2D.Double((double)n2 * 0.40666666626930237, (double)n3 * (double)0.64f, (double)n2 * 0.18666663765907288, (double)n3 * 0.18666666746139526);
                    colorArray13 = new Point2D.Double(((RectangularShape)object30).getCenterX(), ((RectangularShape)object30).getCenterY());
                    object29 = new float[]{0.0f, 0.09f, 0.12f, 0.16f, 0.25f, 0.29f, 0.33f, 0.38f, 0.48f, 0.52f, 0.65f, 0.69f, 0.8f, 0.83f, 0.87f, 0.97f, 1.0f};
                    colorArray12 = new Color[]{new Color(255, 255, 255, 255), new Color(255, 255, 255, 255), new Color(136, 136, 138, 255), new Color(164, 185, 190, 255), new Color(158, 179, 182, 255), new Color(112, 112, 112, 255), new Color(221, 227, 227, 255), new Color(155, 176, 179, 255), new Color(156, 176, 177, 255), new Color(254, 255, 255, 255), new Color(255, 255, 255, 255), new Color(156, 180, 180, 255), new Color(198, 209, 211, 255), new Color(246, 248, 247, 255), new Color(204, 216, 216, 255), new Color(164, 188, 190, 255), new Color(255, 255, 255, 255)};
                    object28 = new ConicalGradientPaint(false, (Point2D)colorArray13, 0.0f, (float[])object29, colorArray12);
                    graphics2D.setPaint((Paint)object28);
                    graphics2D.fill((Shape)object30);
                    cloneable6 = new Ellipse2D.Double((double)n2 * 0.4533333480358124, (double)n3 * 0.6866666674613953, (double)n2 * 0.09333333373069763, (double)n3 * 0.09333330392837524);
                    object27 = new Point2D.Double(0.47333333333333333 * (double)n2, 0.6933333333333334 * (double)n3);
                    object26 = new Point2D.Double(0.5217967183007981 * (double)n2, 0.7651832562881037 * (double)n3);
                    object25 = new float[]{0.0f, 1.0f};
                    colorArray11 = new Color[]{new Color(225, 235, 232, 255), new Color(196, 207, 207, 255)};
                    object24 = new LinearGradientPaint((Point2D)object27, (Point2D)object26, (float[])object25, colorArray11);
                    graphics2D.setPaint((Paint)object24);
                    graphics2D.fill((Shape)((Object)cloneable6));
                    cloneable5 = new Ellipse2D.Double((double)n2 * (double)0.46f, (double)n3 * 0.6933333277702332, (double)n2 * 0.08000001311302185, (double)n3 * 0.07999998331069946);
                    object23 = new Point2D.Double(0.47333333333333333 * (double)n2, 0.7 * (double)n3);
                    object22 = new Point2D.Double(0.518068765610993 * (double)n2, 0.7663230058044033 * (double)n3);
                    object21 = new float[]{0.0f, 1.0f};
                    colorArray10 = new Color[]{new Color(237, 239, 237, 255), new Color(148, 161, 161, 255)};
                    object20 = new LinearGradientPaint((Point2D)object23, (Point2D)object22, (float[])object21, colorArray10);
                    graphics2D.setPaint((Paint)object20);
                    graphics2D.fill((Shape)((Object)cloneable5));
                    break;
                }
                case METAL_KNOB: {
                    cloneable4 = new Ellipse2D.Double((double)n2 * 0.4579439163208008, (double)n3 * 0.6915887594223022, (double)n2 * 0.08411216735839844, (double)n3 * 0.08411216735839844);
                    switch (this.getOrientation()) {
                        case WEST: {
                            ((Point2D)double_).setLocation(((RectangularShape)cloneable4).getCenterX(), ((RectangularShape)cloneable4).getCenterY());
                            graphics2D.rotate(1.5707963267948966, ((Point2D)double_).getX(), ((Point2D)double_).getY());
                        }
                    }
                    object19 = new Point2D.Double(0.0, cloneable4.getBounds2D().getMinY());
                    colorArray9 = new Point2D.Double(0.0, cloneable4.getBounds2D().getMaxY());
                    object18 = new float[]{0.0f, 0.47f, 1.0f};
                    colorArray8 = new Color[]{new Color(92, 95, 101, 255), new Color(46, 49, 53, 255), new Color(22, 23, 26, 255)};
                    object17 = new LinearGradientPaint((Point2D)object19, (Point2D)colorArray9, (float[])object18, colorArray8);
                    graphics2D.setPaint((Paint)object17);
                    graphics2D.fill((Shape)((Object)cloneable4));
                    cloneable3 = new Ellipse2D.Double((double)n2 * 0.46261683106422424, (double)n3 * 0.6962617039680481, (double)n2 * 0.0747663676738739, (double)n3 * 0.07476633787155151);
                    object16 = new Point2D.Double(0.0, cloneable3.getBounds2D().getMinY());
                    colorArray7 = new Point2D.Double(0.0, cloneable3.getBounds2D().getMaxY());
                    object15 = new float[]{0.0f, 1.0f};
                    switch (this.getModel().getKnobStyle()) {
                        case BLACK: {
                            colorArray6 = new Color[]{new Color(2828847), new Color(1710880)};
                            break;
                        }
                        case BRASS: {
                            colorArray6 = new Color[]{new Color(9858614), new Color(8150845)};
                            break;
                        }
                        default: {
                            colorArray6 = new Color[]{new Color(204, 204, 204, 255), new Color(87, 92, 98, 255)};
                        }
                    }
                    object14 = new LinearGradientPaint((Point2D)object16, (Point2D)colorArray7, (float[])object15, colorArray6);
                    graphics2D.setPaint((Paint)object14);
                    graphics2D.fill((Shape)((Object)cloneable3));
                    object13 = new GeneralPath();
                    ((Path2D)object13).setWindingRule(0);
                    ((Path2D.Float)object13).moveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.7616822429906542);
                    ((Path2D.Float)object13).curveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.7523364485981309, (double)n2 * 0.5093457943925234, (double)n3 * 0.7476635514018691, (double)n2 * 0.5, (double)n3 * 0.7476635514018691);
                    ((Path2D.Float)object13).curveTo((double)n2 * 0.48598130841121495, (double)n3 * 0.7476635514018691, (double)n2 * 0.4766355140186916, (double)n3 * 0.7523364485981309, (double)n2 * 0.4766355140186916, (double)n3 * 0.7616822429906542);
                    ((Path2D.Float)object13).curveTo((double)n2 * 0.48130841121495327, (double)n3 * 0.7663551401869159, (double)n2 * 0.49065420560747663, (double)n3 * 0.7710280373831776, (double)n2 * 0.5, (double)n3 * 0.7710280373831776);
                    ((Path2D.Float)object13).curveTo((double)n2 * 0.5046728971962616, (double)n3 * 0.7710280373831776, (double)n2 * 0.514018691588785, (double)n3 * 0.7663551401869159, (double)n2 * 0.5186915887850467, (double)n3 * 0.7616822429906542);
                    ((Path2D)object13).closePath();
                    colorArray5 = new Point2D.Double(0.5 * (double)n2, 0.7710280373831776 * (double)n3);
                    object12 = new float[]{0.0f, 1.0f};
                    colorArray4 = new Color[]{new Color(255, 255, 255, 153), new Color(255, 255, 255, 0)};
                    object11 = new RadialGradientPaint((Point2D)colorArray5, (float)(0.03271028037383177 * (double)n2), (float[])object12, colorArray4);
                    graphics2D.setPaint((Paint)object11);
                    graphics2D.fill((Shape)object13);
                    object10 = new GeneralPath();
                    ((Path2D)object10).setWindingRule(0);
                    ((Path2D.Float)object10).moveTo((double)n2 * 0.5327102803738317, (double)n3 * 0.7149532710280374);
                    ((Path2D.Float)object10).curveTo((double)n2 * 0.5280373831775701, (double)n3 * 0.7009345794392523, (double)n2 * 0.514018691588785, (double)n3 * 0.6915887850467289, (double)n2 * 0.5, (double)n3 * 0.6915887850467289);
                    ((Path2D.Float)object10).curveTo((double)n2 * 0.48130841121495327, (double)n3 * 0.6915887850467289, (double)n2 * 0.4672897196261682, (double)n3 * 0.7009345794392523, (double)n2 * 0.46261682242990654, (double)n3 * 0.7149532710280374);
                    ((Path2D.Float)object10).curveTo((double)n2 * 0.4672897196261682, (double)n3 * 0.719626168224299, (double)n2 * 0.48130841121495327, (double)n3 * 0.7242990654205608, (double)n2 * 0.5, (double)n3 * 0.7242990654205608);
                    ((Path2D.Float)object10).curveTo((double)n2 * 0.514018691588785, (double)n3 * 0.7242990654205608, (double)n2 * 0.5280373831775701, (double)n3 * 0.719626168224299, (double)n2 * 0.5327102803738317, (double)n3 * 0.7149532710280374);
                    ((Path2D)object10).closePath();
                    colorArray3 = new Point2D.Double(0.4953271028037383 * (double)n2, 0.6915887850467289 * (double)n3);
                    object9 = new float[]{0.0f, 1.0f};
                    colorArray2 = new Color[]{new Color(255, 255, 255, 191), new Color(255, 255, 255, 0)};
                    object8 = new RadialGradientPaint((Point2D)colorArray3, (float)(0.04906542056074766 * (double)n2), (float[])object9, colorArray2);
                    graphics2D.setPaint((Paint)object8);
                    graphics2D.fill((Shape)object10);
                    cloneable2 = new Ellipse2D.Double((double)n2 * 0.47663551568984985, (double)n3 * 0.7149532437324524, (double)n2 * 0.04205608367919922, (double)n3 * 0.04205608367919922);
                    object7 = new Point2D.Double(0.0, cloneable2.getBounds2D().getMinY());
                    object6 = new Point2D.Double(0.0, cloneable2.getBounds2D().getMaxY());
                    object5 = new float[]{0.0f, 1.0f};
                    colorArray = new Color[]{new Color(0, 0, 0, 255), new Color(204, 204, 204, 255)};
                    object4 = new LinearGradientPaint((Point2D)object7, (Point2D)object6, (float[])object5, colorArray);
                    graphics2D.setPaint((Paint)object4);
                    graphics2D.fill((Shape)((Object)cloneable2));
                    cloneable = new Ellipse2D.Double((double)n2 * 0.4813084006309509, (double)n3 * 0.7196261882781982, (double)n2 * 0.03271031379699707, (double)n3 * 0.032710254192352295);
                    object3 = new Point2D.Double(0.0, cloneable.getBounds2D().getMinY());
                    object2 = new Point2D.Double(0.0, cloneable.getBounds2D().getMaxY());
                    object = new float[]{0.0f, 1.0f};
                    Color[] colorArray29 = new Color[]{new Color(1, 6, 11, 255), new Color(50, 52, 56, 255)};
                    LinearGradientPaint linearGradientPaint = new LinearGradientPaint((Point2D)object3, (Point2D)object2, (float[])object, colorArray29);
                    graphics2D.setPaint(linearGradientPaint);
                    graphics2D.fill((Shape)((Object)cloneable));
                }
            }
        }
        graphics2D.setTransform((AffineTransform)cloneable14);
        if (list.contains((Object)PostPosition.SMALL_GAUGE_MAX_RIGHT)) {
            switch (this.getOrientation()) {
                case WEST: {
                    ((Point2D)double_).setLocation((double)n2 * 0.7803738117218018 + (double)bufferedImage2.getWidth() / 2.0, (double)n3 * 0.44859811663627625 + (double)bufferedImage2.getHeight() / 2.0);
                    graphics2D.rotate(1.5707963267948966, ((Point2D)double_).getX(), ((Point2D)double_).getY());
                }
            }
            graphics2D.drawImage((Image)bufferedImage2, (int)((double)n2 * 0.7803738117218018), (int)((double)n3 * 0.44859811663627625), null);
            graphics2D.setTransform((AffineTransform)cloneable14);
        }
        if (list.contains((Object)PostPosition.SMALL_GAUGE_MIN_LEFT)) {
            switch (this.getOrientation()) {
                case WEST: {
                    ((Point2D)double_).setLocation((double)n2 * 0.1822429895401001 + (double)bufferedImage2.getWidth() / 2.0, (double)n3 * 0.44859811663627625 + (double)bufferedImage2.getHeight() / 2.0);
                    graphics2D.rotate(1.5707963267948966, ((Point2D)double_).getX(), ((Point2D)double_).getY());
                }
            }
            graphics2D.drawImage((Image)bufferedImage2, (int)((double)n2 * 0.1822429895401001), (int)((double)n3 * 0.44859811663627625), null);
            graphics2D.setTransform((AffineTransform)cloneable14);
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_KNOB_Image(int n, KnobType knobType, KnobStyle knobStyle) {
        return KNOB_FACTORY.create_KNOB_Image(n, knobType, knobStyle);
    }

    protected BufferedImage create_THRESHOLD_Image(int n) {
        return this.create_THRESHOLD_Image(n, 0.0);
    }

    protected BufferedImage create_THRESHOLD_Image(int n, double d) {
        if (n <= 22) {
            return UTIL.createImage(1, 1, 3);
        }
        int n2 = (int)((double)n * 0.0420560748);
        int n3 = (int)((double)n * 0.0981308411);
        BufferedImage bufferedImage = UTIL.createImage(n2, n3, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.rotate(d, (double)n2 / 2.0, (double)n3 / 2.0);
        Point2D.Double double_ = new Point2D.Double();
        Point2D.Double double_2 = new Point2D.Double();
        GeneralPath generalPath = new GeneralPath();
        switch (this.getThresholdType()) {
            case ARROW: {
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.1111111111111111, (double)n3 * 0.047619047619047616);
                generalPath.lineTo((double)n2 * 0.8888888888888888, (double)n3 * 0.047619047619047616);
                generalPath.lineTo((double)n2 * 0.8888888888888888, (double)n3 * 0.3333333333333333);
                generalPath.lineTo((double)n2 * 0.5, (double)n3 * 0.5714285714285714);
                generalPath.lineTo((double)n2 * 0.1111111111111111, (double)n3 * 0.3333333333333333);
                generalPath.closePath();
                ((Point2D)double_).setLocation(0.0, generalPath.getBounds2D().getMinY());
                ((Point2D)double_2).setLocation(0.0, generalPath.getBounds2D().getMaxY());
                break;
            }
            default: {
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.5, (double)n3 * 0.6190476190476191);
                generalPath.lineTo((double)n2 * 0.1111111111111111, (double)n3 * 0.9523809523809523);
                generalPath.lineTo((double)n2 * 0.8888888888888888, (double)n3 * 0.9523809523809523);
                generalPath.closePath();
                ((Point2D)double_).setLocation(0.0, generalPath.getBounds2D().getMaxY());
                ((Point2D)double_2).setLocation(0.0, generalPath.getBounds2D().getMinY());
            }
        }
        float[] fArray = new float[]{0.0f, 0.3f, 0.59f, 1.0f};
        Color[] colorArray = new Color[]{this.getThresholdColor().DARK, this.getThresholdColor().MEDIUM, this.getThresholdColor().MEDIUM, this.getThresholdColor().DARK};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(generalPath);
        graphics2D.setColor(Color.WHITE);
        graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
        graphics2D.draw(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    protected BufferedImage create_MEASURED_VALUE_Image(int n, Color color) {
        return this.create_MEASURED_VALUE_Image(n, color, 0.0);
    }

    protected BufferedImage create_MEASURED_VALUE_Image(int n, Color color, double d) {
        int n2;
        if (n <= 36) {
            return UTIL.createImage(1, 1, 3);
        }
        int n3 = n2 = (int)((double)n * 0.0280373832);
        BufferedImage bufferedImage = UTIL.createImage(n3, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.rotate(d, (double)n3 / 2.0, (double)n2 / 2.0);
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n3 * 0.5, (double)n2);
        generalPath.lineTo(0.0, 0.0);
        generalPath.lineTo((double)n3, 0.0);
        generalPath.closePath();
        graphics2D.setColor(color);
        graphics2D.fill(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    protected BufferedImage create_POINTER_Image(int n) {
        return this.create_POINTER_Image(n, PointerType.TYPE1);
    }

    protected BufferedImage create_POINTER_Image(int n, PointerType pointerType) {
        if (this.getPointerColor() != ColorDef.CUSTOM) {
            return POINTER_FACTORY.createStandardPointer(n, pointerType, this.getPointerColor(), this.getBackgroundColor());
        }
        return POINTER_FACTORY.createStandardPointer(n, pointerType, this.getPointerColor(), this.getModel().getCustomPointerColorObject(), this.getBackgroundColor());
    }

    protected BufferedImage create_POINTER_Image(int n, PointerType pointerType, ColorDef colorDef) {
        return POINTER_FACTORY.createStandardPointer(n, pointerType, colorDef, this.getBackgroundColor());
    }

    protected BufferedImage create_POINTER_Image(int n, PointerType pointerType, ColorDef colorDef, CustomColorDef customColorDef) {
        return POINTER_FACTORY.createStandardPointer(n, pointerType, colorDef, customColorDef, this.getBackgroundColor());
    }

    protected BufferedImage create_POINTER_SHADOW_Image(int n) {
        return this.create_POINTER_SHADOW_Image(n, PointerType.TYPE1);
    }

    protected BufferedImage create_POINTER_SHADOW_Image(int n, PointerType pointerType) {
        return POINTER_FACTORY.createStandardPointerShadow(n, pointerType);
    }

    protected BufferedImage create_FOREGROUND_Image(int n) {
        switch (this.getFrameType()) {
            case ROUND: {
                return FOREGROUND_FACTORY.createRadialForeground(n);
            }
            case SQUARE: {
                return FOREGROUND_FACTORY.createLinearForeground(n, n);
            }
        }
        return FOREGROUND_FACTORY.createRadialForeground(n);
    }

    protected BufferedImage create_FOREGROUND_Image(int n, boolean bl) {
        switch (this.getFrameType()) {
            case ROUND: {
                return FOREGROUND_FACTORY.createRadialForeground(n, bl);
            }
            case SQUARE: {
                return FOREGROUND_FACTORY.createLinearForeground(n, n, bl);
            }
        }
        return FOREGROUND_FACTORY.createRadialForeground(n, bl);
    }

    protected BufferedImage create_FOREGROUND_Image(int n, boolean bl, ForegroundType foregroundType) {
        return this.create_FOREGROUND_Image(n, bl, foregroundType, null);
    }

    protected BufferedImage create_FOREGROUND_Image(int n, boolean bl, ForegroundType foregroundType, BufferedImage bufferedImage) {
        switch (this.getFrameType()) {
            case ROUND: {
                return FOREGROUND_FACTORY.createRadialForeground(n, bl, foregroundType, bufferedImage);
            }
            case SQUARE: {
                return FOREGROUND_FACTORY.createLinearForeground(n, n, bl, bufferedImage);
            }
        }
        return FOREGROUND_FACTORY.createRadialForeground(n, bl, ForegroundType.FG_TYPE1, bufferedImage);
    }

    protected BufferedImage create_DISABLED_Image(int n) {
        return DISABLED_FACTORY.createRadialDisabled(n);
    }

    @Override
    public void calcInnerBounds() {
        Insets insets = this.getInsets();
        int n = this.getWidth() - insets.left - insets.right <= this.getHeight() - insets.top - insets.bottom ? this.getWidth() - insets.left - insets.right : this.getHeight() - insets.top - insets.bottom;
        this.INNER_BOUNDS.setBounds(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
        if (!this.isFrameVisible()) {
            this.GAUGE_BOUNDS.setBounds(insets.left, insets.top, (int)((double)n * 1.202247191), (int)((double)n * 1.202247191));
        } else {
            this.GAUGE_BOUNDS.setBounds(insets.left, insets.top, n, n);
        }
        this.FRAMELESS_BOUNDS.setBounds(insets.left + (int)((double)n * 0.08411215245723724), insets.top + (int)((double)n * 0.08411215245723724), (int)((double)n * 0.8317756652832031), (int)((double)n * 0.8317756652832031));
    }

    @Override
    public Rectangle getInnerBounds() {
        return this.INNER_BOUNDS;
    }

    public Rectangle getGaugeBounds() {
        return this.GAUGE_BOUNDS;
    }

    public Rectangle getFramelessBounds() {
        return this.FRAMELESS_BOUNDS;
    }

    public Point2D getFramelessOffset() {
        return this.FRAMELESS_OFFSET;
    }

    public void setFramelessOffset(double d, double d2) {
        this.FRAMELESS_OFFSET.setLocation(d, d2);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public void setPreferredSize(Dimension dimension) {
        int n = dimension.width <= dimension.height ? dimension.width : dimension.height;
        super.setPreferredSize(new Dimension(n, n));
        this.calcInnerBounds();
        this.init(this.getGaugeBounds().width, this.getGaugeBounds().height);
        this.setInitialized(true);
    }

    @Override
    public void setSize(int n, int n2) {
        int n3 = n <= n2 ? n : n2;
        super.setSize(n3, n3);
        this.calcInnerBounds();
        this.init(this.getGaugeBounds().width, this.getGaugeBounds().height);
        this.setInitialized(true);
    }

    @Override
    public void setSize(Dimension dimension) {
        int n = dimension.width <= dimension.height ? dimension.width : dimension.height;
        super.setSize(new Dimension(n, n));
        this.calcInnerBounds();
        this.init(this.getGaugeBounds().width, this.getGaugeBounds().height);
        this.setInitialized(true);
    }

    @Override
    public void setBounds(Rectangle rectangle) {
        int n = rectangle.width <= rectangle.height ? rectangle.width : rectangle.height;
        super.setBounds(rectangle.x, rectangle.y, n, n);
        this.calcInnerBounds();
        this.init(this.getGaugeBounds().width, this.getGaugeBounds().height);
        this.setInitialized(true);
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        int n5 = n3 <= n4 ? n3 : n4;
        super.setBounds(n, n2, n5, n5);
        this.calcInnerBounds();
        this.init(this.getGaugeBounds().width, this.getGaugeBounds().height);
        this.setInitialized(true);
    }

    @Override
    public void setBorder(Border border) {
        super.setBorder(border);
        this.calcInnerBounds();
        this.init(this.getGaugeBounds().width, this.getGaugeBounds().height);
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        int n = this.getWidth() <= this.getHeight() ? this.getWidth() : this.getHeight();
        Container container = this.getParent();
        if (container != null && container.getLayout() == null) {
            if (n < this.getMinimumSize().width || n < this.getMinimumSize().height) {
                this.setSize(this.getMinimumSize());
            } else {
                this.setSize(n, n);
            }
        } else if (n < this.getMinimumSize().width || n < this.getMinimumSize().height) {
            this.setPreferredSize(this.getMinimumSize());
        } else {
            this.setPreferredSize(new Dimension(n, n));
        }
        this.calcInnerBounds();
        this.recreateLedImages();
        if (this.isLedOn()) {
            this.setCurrentLedImage(this.getLedImageOn());
        } else {
            this.setCurrentLedImage(this.getLedImageOff());
        }
        this.recreateUserLedImages();
        if (this.isUserLedOn()) {
            this.setCurrentUserLedImage(this.getUserLedImageOn());
        } else {
            this.setCurrentUserLedImage(this.getUserLedImageOff());
        }
        this.getModel().setSize(this.getLocation().x, this.getLocation().y, n, n);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public String toString() {
        return "AbstractRadial";
    }
}

