/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.gauges;

import eu.hansolo.steelseries.gauges.AbstractGauge;
import eu.hansolo.steelseries.gauges.AbstractRadial;
import eu.hansolo.steelseries.tools.LcdColor;
import eu.hansolo.steelseries.tools.LedColor;
import eu.hansolo.steelseries.tools.NumberSystem;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Point;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class DigitalRadial
extends AbstractRadial {
    private int noOfActiveLeds = 0;
    private BufferedImage bImage;
    private BufferedImage fImage;
    private BufferedImage lcdThresholdImage;
    private BufferedImage disabledImage;
    private BufferedImage ledGreenOff = UTIL.createImage(24, 24, 3);
    private BufferedImage ledYellowOff = UTIL.createImage(24, 24, 3);
    private BufferedImage ledRedOff = UTIL.createImage(24, 24, 3);
    private BufferedImage ledGreenOn = UTIL.createImage(24, 24, 3);
    private BufferedImage ledYellowOn = UTIL.createImage(24, 24, 3);
    private BufferedImage ledRedOn = UTIL.createImage(24, 24, 3);
    private Color valueColor = new Color(255, 0, 0, 255);
    private final Rectangle2D LCD = new Rectangle2D.Double();
    private Point[] ledPosition;
    private final FontRenderContext RENDER_CONTEXT = new FontRenderContext(null, true, true);
    private TextLayout unitLayout;
    private final Rectangle2D UNIT_BOUNDARY = new Rectangle2D.Double();
    private TextLayout valueLayout;
    private final Rectangle2D VALUE_BOUNDARY = new Rectangle2D.Double();
    private TextLayout infoLayout;
    private final Rectangle2D INFO_BOUNDARY = new Rectangle2D.Double();

    public DigitalRadial() {
        this.setUnitString("");
    }

    @Override
    public final AbstractGauge init(int n, int n2) {
        if (n <= 1 || n2 <= 1) {
            return this;
        }
        if (this.isLcdVisible()) {
            if (this.isDigitalFont()) {
                this.setLcdValueFont(this.getModel().getDigitalBaseFont().deriveFont(0.7f * (float)n * 0.15f));
            } else {
                this.setLcdValueFont(this.getModel().getStandardBaseFont().deriveFont(0.625f * (float)n * 0.15f));
            }
            if (this.isCustomLcdUnitFontEnabled()) {
                this.setLcdUnitFont(this.getCustomLcdUnitFont().deriveFont(0.25f * (float)n * 0.15f));
            } else {
                this.setLcdUnitFont(this.getModel().getStandardBaseFont().deriveFont(0.25f * (float)n * 0.15f));
            }
            this.setLcdInfoFont(this.getModel().getStandardInfoFont().deriveFont(0.15f * (float)n * 0.15f));
        }
        if (this.bImage != null) {
            this.bImage.flush();
        }
        this.bImage = UTIL.createImage(n, n, 3);
        if (this.fImage != null) {
            this.fImage.flush();
        }
        this.fImage = UTIL.createImage(n, n, 3);
        if (this.isFrameVisible()) {
            switch (this.getFrameType()) {
                case ROUND: {
                    FRAME_FACTORY.createRadialFrame(n, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect(), this.bImage);
                    break;
                }
                case SQUARE: {
                    FRAME_FACTORY.createLinearFrame(n, n, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect(), this.bImage);
                    break;
                }
                default: {
                    FRAME_FACTORY.createRadialFrame(n, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect(), this.bImage);
                }
            }
        }
        if (this.isBackgroundVisible()) {
            this.create_BACKGROUND_Image(n, "", "", this.bImage);
        }
        if (this.isForegroundVisible()) {
            switch (this.getFrameType()) {
                case SQUARE: {
                    FOREGROUND_FACTORY.createLinearForeground(n, n, false, this.bImage);
                    break;
                }
                default: {
                    FOREGROUND_FACTORY.createRadialForeground(n, false, this.getForegroundType(), this.fImage);
                }
            }
        }
        if (this.isLcdVisible()) {
            this.create_LCD_Image(new Rectangle2D.Double(((double)this.getGaugeBounds().width - (double)n * 0.48) / 2.0, (double)this.getGaugeBounds().height * 0.425, (double)n * 0.48, (double)n * 0.15), this.getLcdColor(), this.getCustomLcdBackground(), this.bImage);
            this.LCD.setRect(((double)this.getGaugeBounds().width - (double)n * 0.4) / 2.0, (double)this.getGaugeBounds().height * 0.55, (double)n * 0.48, (double)n * 0.15);
            if (this.lcdThresholdImage != null) {
                this.lcdThresholdImage.flush();
            }
            this.lcdThresholdImage = this.create_LCD_THRESHOLD_Image((int)(this.LCD.getHeight() * 0.2045454545), (int)(this.LCD.getHeight() * 0.2045454545), this.getLcdColor().TEXT_COLOR);
        }
        if (this.disabledImage != null) {
            this.disabledImage.flush();
        }
        this.disabledImage = this.create_DISABLED_Image(n);
        this.ledPosition = new Point[]{new Point((int)((double)n * 0.186915887850467), (int)((double)n * 0.649532710280374)), new Point((int)((double)n * 0.116822429906542), (int)((double)n * 0.546728971962617)), new Point((int)((double)n * 0.088785046728972), (int)((double)n * 0.41588785046729)), new Point((int)((double)n * 0.116822429906542), (int)((double)n * 0.285046728971963)), new Point((int)((double)n * 0.177570093457944), (int)((double)n * 0.182242990654206)), new Point((int)((double)n * 0.280373831775701), (int)((double)n * 0.117222429906542)), new Point((int)((double)n * 0.411214953271028), (int)((double)n * 0.0794392523364486)), new Point((int)((double)n * 0.542056074766355), (int)((double)n * 0.117222429906542)), new Point((int)((double)n * 0.649532710280374), (int)((double)n * 0.182242990654206)), new Point((int)((double)n * 0.719626168224299), (int)((double)n * 0.285046728971963)), new Point((int)((double)n * 0.738317757009346), (int)((double)n * 0.41588785046729)), new Point((int)((double)n * 0.710280373831776), (int)((double)n * 0.546728971962617)), new Point((int)((double)n * 0.64018691588785), (int)((double)n * 0.649532710280374))};
        this.ledGreenOff.flush();
        this.ledGreenOff = this.create_LED_OFF_Image(n, LedColor.GREEN);
        this.ledYellowOff.flush();
        this.ledYellowOff = this.create_LED_OFF_Image(n, LedColor.YELLOW);
        this.ledRedOff.flush();
        this.ledRedOff = this.create_LED_OFF_Image(n, LedColor.RED);
        this.ledGreenOn.flush();
        this.ledGreenOn = this.create_LED_ON_Image(n, LedColor.GREEN);
        this.ledYellowOn.flush();
        this.ledYellowOn = this.create_LED_ON_Image(n, LedColor.YELLOW);
        this.ledRedOn.flush();
        this.ledRedOn = this.create_LED_ON_Image(n, LedColor.RED);
        return this;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (!this.isInitialized()) {
            return;
        }
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.translate(this.getInnerBounds().x, this.getInnerBounds().y);
        graphics2D.drawImage((Image)this.bImage, 0, 0, null);
        for (int i = 0; i < 13; ++i) {
            if (i < 7) {
                if (i < this.noOfActiveLeds) {
                    graphics2D.drawImage((Image)this.ledGreenOn, this.ledPosition[i].x, this.ledPosition[i].y, null);
                } else {
                    graphics2D.drawImage((Image)this.ledGreenOff, this.ledPosition[i].x, this.ledPosition[i].y, null);
                }
            }
            if (i >= 7 && i < 12) {
                if (i < this.noOfActiveLeds) {
                    graphics2D.drawImage((Image)this.ledYellowOn, this.ledPosition[i].x, this.ledPosition[i].y, null);
                } else {
                    graphics2D.drawImage((Image)this.ledYellowOff, this.ledPosition[i].x, this.ledPosition[i].y, null);
                }
            }
            if (i != 12) continue;
            if (i < this.noOfActiveLeds) {
                graphics2D.drawImage((Image)this.ledRedOn, this.ledPosition[i].x, this.ledPosition[i].y, null);
                continue;
            }
            graphics2D.drawImage((Image)this.ledRedOff, this.ledPosition[i].x, this.ledPosition[i].y, null);
        }
        if (this.isLcdVisible()) {
            double d;
            if (this.getLcdColor() == LcdColor.CUSTOM) {
                graphics2D.setColor(this.getCustomLcdForeground());
            } else {
                graphics2D.setColor(this.getLcdColor().TEXT_COLOR);
            }
            graphics2D.setFont(this.getLcdUnitFont());
            if (this.isLcdUnitStringVisible()) {
                this.unitLayout = new TextLayout(this.getLcdUnitString(), graphics2D.getFont(), this.RENDER_CONTEXT);
                this.UNIT_BOUNDARY.setFrame(this.unitLayout.getBounds());
                graphics2D.drawString(this.getLcdUnitString(), (int)(((double)this.getGaugeBounds().width - this.LCD.getWidth()) / 2.0 + (this.LCD.getWidth() - this.UNIT_BOUNDARY.getWidth()) - this.LCD.getWidth() * 0.03), (int)((double)this.getGaugeBounds().height * 0.425 + this.LCD.getHeight() * 0.76));
                d = this.UNIT_BOUNDARY.getWidth();
            } else {
                d = 0.0;
            }
            graphics2D.setFont(this.getLcdValueFont());
            switch (this.getModel().getNumberSystem()) {
                case HEX: {
                    this.valueLayout = new TextLayout(Integer.toHexString((int)this.getLcdValue()).toUpperCase(), graphics2D.getFont(), this.RENDER_CONTEXT);
                    this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                    graphics2D.drawString(Integer.toHexString((int)this.getLcdValue()).toUpperCase(), (int)(((double)this.getGaugeBounds().width - this.LCD.getWidth()) / 2.0 + (this.LCD.getWidth() - d - this.VALUE_BOUNDARY.getWidth()) - this.LCD.getWidth() * 0.09), (int)((double)this.getGaugeBounds().height * 0.425 + this.LCD.getHeight() * 0.76));
                    break;
                }
                case OCT: {
                    this.valueLayout = new TextLayout(Integer.toOctalString((int)this.getLcdValue()), graphics2D.getFont(), this.RENDER_CONTEXT);
                    this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                    graphics2D.drawString(Integer.toOctalString((int)this.getLcdValue()), (int)(((double)this.getGaugeBounds().width - this.LCD.getWidth()) / 2.0 + (this.LCD.getWidth() - d - this.VALUE_BOUNDARY.getWidth()) - this.LCD.getWidth() * 0.09), (int)((double)this.getGaugeBounds().height * 0.425 + this.LCD.getHeight() * 0.76));
                    break;
                }
                default: {
                    this.valueLayout = new TextLayout(this.formatLcdValue(this.getLcdValue()), graphics2D.getFont(), this.RENDER_CONTEXT);
                    this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                    graphics2D.drawString(this.formatLcdValue(this.getLcdValue()), (int)(((double)this.getGaugeBounds().width - this.LCD.getWidth()) / 2.0 + (this.LCD.getWidth() - d - this.VALUE_BOUNDARY.getWidth()) - this.LCD.getWidth() * 0.09), (int)((double)this.getGaugeBounds().height * 0.425 + this.LCD.getHeight() * 0.76));
                }
            }
            if (!this.getLcdInfoString().isEmpty()) {
                graphics2D.setFont(this.getLcdInfoFont());
                this.infoLayout = new TextLayout(this.getLcdInfoString(), graphics2D.getFont(), this.RENDER_CONTEXT);
                this.INFO_BOUNDARY.setFrame(this.infoLayout.getBounds());
                graphics2D.drawString(this.getLcdInfoString(), this.LCD.getBounds().x + 5, this.LCD.getBounds().y + (int)this.INFO_BOUNDARY.getHeight() + 5);
            }
            if (this.getLcdNumberSystem() == NumberSystem.DEC && this.isLcdThresholdVisible() && this.getLcdValue() >= this.getLcdThreshold()) {
                graphics2D.drawImage((Image)this.lcdThresholdImage, (int)(this.LCD.getX() + this.LCD.getHeight() * 0.0568181818), (int)(this.LCD.getY() + this.LCD.getHeight() - (double)this.lcdThresholdImage.getHeight() - this.LCD.getHeight() * 0.0568181818), null);
            }
        }
        graphics2D.drawImage((Image)this.fImage, 0, 0, null);
        if (!this.isEnabled()) {
            graphics2D.drawImage((Image)this.disabledImage, 0, 0, null);
        }
        graphics2D.translate(-this.getInnerBounds().x, -this.getInnerBounds().y);
        graphics2D.dispose();
    }

    @Override
    public void setValue(double d) {
        super.setValue(d);
        this.calcNoOfActiveLed();
        if (this.isValueCoupled()) {
            this.setLcdValue(d);
        }
        this.repaint(this.getInnerBounds());
    }

    @Override
    public void setMinValue(double d) {
        super.setMinValue(d);
        this.calcNoOfActiveLed();
        this.repaint(this.getInnerBounds());
    }

    @Override
    public void setMaxValue(double d) {
        super.setMaxValue(d);
        this.calcNoOfActiveLed();
        this.repaint(this.getInnerBounds());
    }

    private void calcNoOfActiveLed() {
        this.noOfActiveLeds = (int)(13.0 / (this.getMaxValue() - this.getMinValue()) * this.getValue());
    }

    public Color getValueColor() {
        return this.valueColor;
    }

    public void setValueColor(Color color) {
        this.valueColor = color;
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Paint createCustomLcdBackgroundPaint(Color[] colorArray) {
        Point2D.Double double_;
        Point2D.Double double_2 = new Point2D.Double(0.0, this.LCD.getMinY() + 1.0);
        if (double_2.equals(double_ = new Point2D.Double(0.0, this.LCD.getMaxY() - 1.0))) {
            ((Point2D)double_).setLocation(0.0, ((Point2D)double_2).getY() + 1.0);
        }
        float[] fArray = new float[]{0.0f, 0.03f, 0.49f, 0.5f, 1.0f};
        Color[] colorArray2 = new Color[]{colorArray[0], colorArray[1], colorArray[2], colorArray[3], colorArray[4]};
        return new LinearGradientPaint(double_2, double_, fArray, colorArray2);
    }

    @Override
    public Point2D getCenter() {
        return new Point2D.Double((double)this.bImage.getWidth() / 2.0 + (double)this.getInnerBounds().x, (double)this.bImage.getHeight() / 2.0 + (double)this.getInnerBounds().y);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return new Rectangle2D.Double(this.bImage.getMinX(), this.bImage.getMinY(), this.bImage.getWidth(), this.bImage.getHeight());
    }

    @Override
    public Rectangle getLcdBounds() {
        return this.LCD.getBounds();
    }

    private BufferedImage create_LED_OFF_Image(int n, LedColor ledColor) {
        Color[] colorArray;
        BufferedImage bufferedImage = UTIL.createImage((int)((double)n * 0.1775700935), (int)((double)n * 0.1775700935), 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        Ellipse2D.Double double_ = new Ellipse2D.Double((double)n2 * 0.21052631735801697, (double)n3 * 0.21052631735801697, (double)n2 * 0.5526316165924072, (double)n3 * 0.5526316165924072);
        Point2D.Double double_2 = new Point2D.Double(0.0, double_.getBounds2D().getMinY());
        Point2D.Double double_3 = new Point2D.Double(0.0, double_.getBounds2D().getMaxY());
        float[] fArray = new float[]{0.0f, 1.0f};
        Color[] colorArray2 = new Color[]{new Color(0, 0, 0, 229), new Color(153, 153, 153, 255)};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_2, double_3, fArray, colorArray2);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(double_);
        Ellipse2D.Double double_4 = new Ellipse2D.Double((double)n2 * 0.2368421107530594, (double)n3 * 0.2368421107530594, (double)n2 * 0.5, (double)n3 * 0.5);
        Point2D.Double double_5 = new Point2D.Double(double_4.getCenterX(), double_4.getCenterY());
        float[] fArray2 = new float[]{0.0f, 0.14f, 0.15f, 1.0f};
        switch (ledColor) {
            case GREEN: {
                colorArray = new Color[]{new Color(28, 126, 0, 255), new Color(28, 126, 0, 255), new Color(28, 126, 0, 255), new Color(27, 100, 0, 255)};
                break;
            }
            case YELLOW: {
                colorArray = new Color[]{new Color(164, 128, 8, 255), new Color(158, 125, 10, 255), new Color(158, 125, 10, 255), new Color(130, 96, 25, 255)};
                break;
            }
            case RED: {
                colorArray = new Color[]{new Color(248, 0, 0, 255), new Color(248, 0, 0, 255), new Color(248, 0, 0, 255), new Color(63, 0, 0, 255)};
                break;
            }
            default: {
                colorArray = new Color[]{new Color(28, 126, 0, 255), new Color(28, 126, 0, 255), new Color(28, 126, 0, 255), new Color(27, 100, 0, 255)};
            }
        }
        RadialGradientPaint radialGradientPaint = new RadialGradientPaint(double_5, 0.25f * (float)n2, fArray2, colorArray);
        graphics2D.setPaint(radialGradientPaint);
        graphics2D.fill(double_4);
        Ellipse2D.Double double_6 = new Ellipse2D.Double((double)n2 * 0.2368421107530594, (double)n3 * 0.2368421107530594, (double)n2 * 0.5, (double)n3 * 0.5);
        Point2D.Double double_7 = new Point2D.Double(0.47368421052631576 * (double)n2, 0.47368421052631576 * (double)n3);
        float[] fArray3 = new float[]{0.0f, 0.86f, 1.0f};
        Color[] colorArray3 = new Color[]{new Color(0, 0, 0, 0), new Color(0, 0, 0, 88), new Color(0, 0, 0, 102)};
        RadialGradientPaint radialGradientPaint2 = new RadialGradientPaint(double_7, (float)(0.25 * (double)n2), fArray3, colorArray3);
        graphics2D.setPaint(radialGradientPaint2);
        graphics2D.fill(double_6);
        Ellipse2D.Double double_8 = new Ellipse2D.Double((double)n2 * 0.3947368562221527, (double)n3 * 0.31578946113586426, (double)n2 * 0.21052631735801697, (double)n3 * 0.1315789520740509);
        Point2D.Double double_9 = new Point2D.Double(0.0, double_8.getBounds2D().getMinY());
        Point2D.Double double_10 = new Point2D.Double(0.0, double_8.getBounds2D().getMaxY());
        float[] fArray4 = new float[]{0.0f, 1.0f};
        Color[] colorArray4 = new Color[]{new Color(255, 255, 255, 102), new Color(255, 255, 255, 0)};
        LinearGradientPaint linearGradientPaint2 = new LinearGradientPaint(double_9, double_10, fArray4, colorArray4);
        graphics2D.setPaint(linearGradientPaint2);
        graphics2D.fill(double_8);
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_LED_ON_Image(int n, LedColor ledColor) {
        Color[] colorArray;
        Color[] colorArray2;
        BufferedImage bufferedImage = UTIL.createImage((int)((double)n * 0.1775700935), (int)((double)n * 0.1775700935), 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        Ellipse2D.Double double_ = new Ellipse2D.Double((double)n2 * 0.21052631735801697, (double)n3 * 0.21052631735801697, (double)n2 * 0.5526316165924072, (double)n3 * 0.5526316165924072);
        Point2D.Double double_2 = new Point2D.Double(0.0, double_.getBounds2D().getMinY());
        Point2D.Double double_3 = new Point2D.Double(0.0, double_.getBounds2D().getMaxY());
        float[] fArray = new float[]{0.0f, 1.0f};
        Color[] colorArray3 = new Color[]{new Color(0, 0, 0, 229), new Color(153, 153, 153, 255)};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_2, double_3, fArray, colorArray3);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(double_);
        Ellipse2D.Double double_4 = new Ellipse2D.Double(0.0, 0.0, n2, n3);
        Point2D.Double double_5 = new Point2D.Double(double_4.getCenterX(), double_4.getCenterY());
        float[] fArray2 = new float[]{0.0f, 0.57f, 0.71f, 0.72f, 0.85f, 0.93f, 0.9301f, 0.99f};
        switch (ledColor) {
            case GREEN: {
                colorArray2 = new Color[]{new Color(165, 255, 0, 255), new Color(165, 255, 0, 101), new Color(165, 255, 0, 63), new Color(165, 255, 0, 62), new Color(165, 255, 0, 31), new Color(165, 255, 0, 13), new Color(165, 255, 0, 12), new Color(165, 255, 0, 0)};
                break;
            }
            case YELLOW: {
                colorArray2 = new Color[]{new Color(255, 102, 0, 255), new Color(255, 102, 0, 101), new Color(255, 102, 0, 63), new Color(255, 102, 0, 62), new Color(255, 102, 0, 31), new Color(255, 102, 0, 13), new Color(255, 102, 0, 12), new Color(255, 102, 0, 0)};
                break;
            }
            case RED: {
                colorArray2 = new Color[]{new Color(255, 0, 0, 255), new Color(255, 0, 0, 101), new Color(255, 0, 0, 63), new Color(255, 0, 0, 62), new Color(255, 0, 0, 31), new Color(255, 0, 0, 13), new Color(255, 0, 0, 12), new Color(255, 0, 0, 0)};
                break;
            }
            default: {
                colorArray2 = new Color[]{new Color(165, 255, 0, 255), new Color(165, 255, 0, 101), new Color(165, 255, 0, 63), new Color(165, 255, 0, 62), new Color(165, 255, 0, 31), new Color(165, 255, 0, 13), new Color(165, 255, 0, 12), new Color(165, 255, 0, 0)};
            }
        }
        RadialGradientPaint radialGradientPaint = new RadialGradientPaint(double_5, 0.5f * (float)n2, fArray2, colorArray2);
        graphics2D.setPaint(radialGradientPaint);
        graphics2D.fill(double_4);
        Ellipse2D.Double double_6 = new Ellipse2D.Double((double)n2 * 0.2368421107530594, (double)n3 * 0.2368421107530594, (double)n2 * 0.5, (double)n3 * 0.5);
        Point2D.Double double_7 = new Point2D.Double(double_6.getCenterX(), double_6.getCenterY());
        float[] fArray3 = new float[]{0.0f, 0.14f, 0.15f, 1.0f};
        switch (ledColor) {
            case GREEN: {
                colorArray = new Color[]{new Color(154, 255, 137, 255), new Color(154, 255, 137, 255), new Color(154, 255, 137, 255), new Color(89, 255, 42, 255)};
                break;
            }
            case YELLOW: {
                colorArray = new Color[]{new Color(251, 255, 140, 255), new Color(251, 255, 140, 255), new Color(251, 255, 140, 255), new Color(250, 249, 60, 255)};
                break;
            }
            case RED: {
                colorArray = new Color[]{new Color(252, 53, 55, 255), new Color(252, 53, 55, 255), new Color(252, 53, 55, 255), new Color(255, 0, 0, 255)};
                break;
            }
            default: {
                colorArray = new Color[]{new Color(154, 255, 137, 255), new Color(154, 255, 137, 255), new Color(154, 255, 137, 255), new Color(89, 255, 42, 255)};
            }
        }
        RadialGradientPaint radialGradientPaint2 = new RadialGradientPaint(double_7, 0.25f * (float)n2, fArray3, colorArray);
        graphics2D.setPaint(radialGradientPaint2);
        graphics2D.fill(double_6);
        Ellipse2D.Double double_8 = new Ellipse2D.Double((double)n2 * 0.2368421107530594, (double)n3 * 0.2368421107530594, (double)n2 * 0.5, (double)n3 * 0.5);
        Point2D.Double double_9 = new Point2D.Double(0.47368421052631576 * (double)n2, 0.47368421052631576 * (double)n3);
        float[] fArray4 = new float[]{0.0f, 0.86f, 1.0f};
        Color[] colorArray4 = new Color[]{new Color(0, 0, 0, 0), new Color(0, 0, 0, 88), new Color(0, 0, 0, 102)};
        RadialGradientPaint radialGradientPaint3 = new RadialGradientPaint(double_9, (float)(0.25 * (double)n2), fArray4, colorArray4);
        graphics2D.setPaint(radialGradientPaint3);
        graphics2D.fill(double_8);
        Ellipse2D.Double double_10 = new Ellipse2D.Double((double)n2 * 0.3947368562221527, (double)n3 * 0.31578946113586426, (double)n2 * 0.21052631735801697, (double)n3 * 0.1315789520740509);
        Point2D.Double double_11 = new Point2D.Double(0.0, double_10.getBounds2D().getMinY());
        Point2D.Double double_12 = new Point2D.Double(0.0, double_10.getBounds2D().getMaxY());
        float[] fArray5 = new float[]{0.0f, 1.0f};
        Color[] colorArray5 = new Color[]{new Color(255, 255, 255, 102), new Color(255, 255, 255, 0)};
        LinearGradientPaint linearGradientPaint2 = new LinearGradientPaint(double_11, double_12, fArray5, colorArray5);
        graphics2D.setPaint(linearGradientPaint2);
        graphics2D.fill(double_10);
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    public String toString() {
        return "DigitalRadial";
    }
}

