/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.gauges;

import eu.hansolo.steelseries.gauges.AbstractGauge;
import eu.hansolo.steelseries.gauges.AbstractLinear;
import eu.hansolo.steelseries.tools.LcdColor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public final class DisplayRectangular
extends AbstractLinear {
    private BufferedImage frameImage;
    private BufferedImage backgroundImage;
    private BufferedImage titleImage;
    private BufferedImage lcdImage;
    private BufferedImage foregroundImage;
    private BufferedImage disabledImage;
    private final FontRenderContext RENDER_CONTEXT = new FontRenderContext(null, true, true);
    private TextLayout unitLayout;
    private final Rectangle2D UNIT_BOUNDARY = new Rectangle2D.Double();
    private TextLayout valueLayout;
    private final Rectangle2D VALUE_BOUNDARY = new Rectangle2D.Double();

    public DisplayRectangular() {
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public final AbstractGauge init(int n, int n2) {
        if (n <= 1 || n2 <= 1) {
            return this;
        }
        if (this.isDigitalFont()) {
            this.setLcdValueFont(LCD_DIGITAL_FONT.deriveFont(0.7f * (float)(n2 - 36)));
        } else {
            this.setLcdValueFont(LCD_STANDARD_FONT.deriveFont(0.625f * (float)(n2 - 36)));
        }
        if (this.isCustomLcdUnitFontEnabled()) {
            this.setLcdUnitFont(this.getCustomLcdUnitFont().deriveFont(0.25f * (float)(n2 - 36)));
        } else {
            this.setLcdUnitFont(LCD_STANDARD_FONT.deriveFont(0.25f * (float)(n2 - 36)));
        }
        if (this.frameImage != null) {
            this.frameImage.flush();
        }
        this.frameImage = this.create_FRAME_Image(n, n2);
        if (this.backgroundImage != null) {
            this.backgroundImage.flush();
        }
        this.backgroundImage = this.create_BACKGROUND_Image(n, n2);
        if (this.titleImage != null) {
            this.titleImage.flush();
        }
        this.titleImage = this.create_TITLE_Image(n, n2, false);
        if (this.lcdImage != null) {
            this.lcdImage.flush();
        }
        this.lcdImage = this.create_LCD_Image(n - 36, n2 - 36, this.getLcdColor(), this.getCustomLcdBackground());
        if (this.foregroundImage != null) {
            this.foregroundImage.flush();
        }
        this.foregroundImage = this.create_FOREGROUND_Image(n, n2);
        if (this.disabledImage != null) {
            this.disabledImage.flush();
        }
        this.disabledImage = this.create_DISABLED_Image(n, n2);
        if (this.backgroundImage != null) {
            this.backgroundImage.flush();
        }
        this.backgroundImage = this.create_BACKGROUND_Image(n, n2);
        if (this.foregroundImage != null) {
            this.foregroundImage.flush();
        }
        this.foregroundImage = this.create_FOREGROUND_Image(n, n2);
        if (this.disabledImage != null) {
            this.disabledImage.flush();
        }
        this.disabledImage = this.create_DISABLED_Image(n, n2);
        return this;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (!this.isInitialized()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.translate(this.getInnerBounds().x, this.getInnerBounds().y);
        if (this.isFrameVisible()) {
            graphics2D.drawImage((Image)this.frameImage, 0, 0, null);
        }
        if (this.isBackgroundVisible()) {
            graphics2D.drawImage((Image)this.backgroundImage, 0, 0, null);
        }
        if (this.isLcdVisible()) {
            double d;
            graphics2D.drawImage((Image)this.lcdImage, 18, 18, null);
            if (this.getLcdColor() == LcdColor.CUSTOM) {
                graphics2D.setColor(this.getCustomLcdForeground());
            } else {
                graphics2D.setColor(this.getLcdColor().TEXT_COLOR);
            }
            graphics2D.setFont(this.getLcdUnitFont());
            if (this.isLcdUnitStringVisible()) {
                this.unitLayout = new TextLayout(this.getLcdUnitString(), graphics2D.getFont(), this.RENDER_CONTEXT);
                this.UNIT_BOUNDARY.setFrame(this.unitLayout.getBounds());
                graphics2D.drawString(this.getLcdUnitString(), (int)((double)this.lcdImage.getWidth() - this.UNIT_BOUNDARY.getWidth() - (double)((float)this.lcdImage.getWidth() * 0.03f)) + 18, (int)((float)this.lcdImage.getHeight() * 0.76f) + 18);
                d = this.UNIT_BOUNDARY.getWidth();
            } else {
                d = 0.0;
            }
            graphics2D.setFont(this.getLcdValueFont());
            this.valueLayout = new TextLayout(this.formatLcdValue(this.getLcdValue()), graphics2D.getFont(), this.RENDER_CONTEXT);
            this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
            graphics2D.drawString(this.formatLcdValue(this.getLcdValue()), (int)((double)this.lcdImage.getWidth() - d - this.VALUE_BOUNDARY.getWidth() - (double)this.lcdImage.getWidth() * 0.09) + 18, (int)((float)this.lcdImage.getHeight() * 0.76f) + 18);
        }
        if (this.isForegroundVisible()) {
            graphics2D.drawImage((Image)this.foregroundImage, 0, 0, null);
        }
        if (!this.isEnabled()) {
            graphics2D.drawImage((Image)this.disabledImage, 0, 0, null);
        }
        graphics2D.translate(-this.getInnerBounds().x, -this.getInnerBounds().y);
        graphics2D.dispose();
    }

    @Override
    public boolean isLcdVisible() {
        return true;
    }

    @Override
    public void setValue(double d) {
        this.setLcdValue(d);
    }

    @Override
    public double getValue() {
        return this.getLcdValue();
    }

    @Override
    public boolean isValueCoupled() {
        return false;
    }

    @Override
    public Paint createCustomLcdBackgroundPaint(Color[] colorArray) {
        Point2D.Double double_ = new Point2D.Double(0.0, 19.0);
        Point2D.Double double_2 = new Point2D.Double(0.0, this.getHeight() - 19);
        if (double_.equals(double_2)) {
            ((Point2D)double_2).setLocation(0.0, ((Point2D)double_).getY() + 1.0);
        }
        float[] fArray = new float[]{0.0f, 0.03f, 0.49f, 0.5f, 1.0f};
        Color[] colorArray2 = new Color[]{colorArray[0], colorArray[1], colorArray[2], colorArray[3], colorArray[4]};
        return new LinearGradientPaint(double_, double_2, fArray, colorArray2);
    }

    @Override
    public Point2D getCenter() {
        return new Point2D.Double((double)this.backgroundImage.getWidth() / 2.0 + (double)this.getInnerBounds().x, (double)this.backgroundImage.getHeight() / 2.0 + (double)this.getInnerBounds().y);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return new Rectangle2D.Double(this.backgroundImage.getMinX(), this.backgroundImage.getMinY(), this.backgroundImage.getWidth(), this.backgroundImage.getHeight());
    }

    @Override
    public Rectangle getLcdBounds() {
        return new Rectangle(17, 17, this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public String toString() {
        return "DisplayRectangular";
    }
}

