/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.gauges;

import eu.hansolo.steelseries.gauges.Lcd;
import eu.hansolo.steelseries.tools.GlowImageFactory;
import eu.hansolo.steelseries.tools.GradientWrapper;
import eu.hansolo.steelseries.tools.LcdColor;
import eu.hansolo.steelseries.tools.NumberSystem;
import eu.hansolo.steelseries.tools.Section;
import eu.hansolo.steelseries.tools.Util;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.Timer;
import javax.swing.border.Border;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.ease.Linear;
import org.pushingpixels.trident.ease.TimelineEase;

public final class DisplaySingle
extends JComponent
implements Lcd,
ActionListener {
    private final Util UTIL = Util.INSTANCE;
    private LcdColor lcdColor = LcdColor.WHITE_LCD;
    private Paint customLcdBackground = Color.BLACK;
    private Color customLcdForeground = Color.WHITE;
    private final Rectangle INNER_BOUNDS = new Rectangle(0, 0, 128, 48);
    private double lcdValue = 0.0;
    private double lcdMinValue = 0.0;
    private double lcdMaxValue = 100.0;
    private double lcdThreshold = 0.0;
    private boolean lcdThresholdVisible = false;
    private boolean lcdThresholdBehaviourInverted = false;
    private BufferedImage lcdThresholdImage;
    private static final String LCD_VALUE_PROPERTY = "lcdValue";
    private static final String LCD_TEXT_PROPERTY = "lcdText";
    private int lcdDecimals = 1;
    private String lcdUnitString = "unit";
    private boolean lcdUnitStringVisible = true;
    private boolean lcdScientificFormat = false;
    private boolean digitalFont = false;
    private boolean useCustomLcdUnitFont = false;
    private Font customLcdUnitFont;
    private Font lcdValueFont;
    private Font lcdUnitFont;
    private String lcdInfoString = "";
    private final Font LCD_STANDARD_FONT;
    private final Font LCD_DIGITAL_FONT;
    private BufferedImage bgImage;
    private Color fgColor;
    private BufferedImage lcdImage;
    private NumberSystem numberSystem;
    private Shape disabledShape;
    private final Color DISABLED_COLOR;
    private Timeline timeline;
    private final transient TimelineEase EASING;
    private final FontRenderContext RENDER_CONTEXT = new FontRenderContext(null, true, true);
    private TextLayout unitLayout;
    private final Rectangle2D UNIT_BOUNDARY = new Rectangle2D.Double();
    private TextLayout valueLayout;
    private final Rectangle2D VALUE_BOUNDARY = new Rectangle2D.Double();
    private Font lcdInfoFont;
    private TextLayout infoLayout;
    private final Rectangle2D INFO_BOUNDARY = new Rectangle2D.Double();
    private boolean sectionsVisible = false;
    private ArrayList<Section> sections;
    private ArrayList<BufferedImage> sectionsBackground;
    private ArrayList<Color> sectionsForeground;
    private boolean qualityOverlayVisible = false;
    private double overlayCornerRadius = 0.0;
    private float overlayFactor = 0.0f;
    private Insets overlayInsets;
    private float factor = 0.0f;
    private Color[] overlayColors;
    private float[] qualityOverlayFractions;
    private Color[] qualityOverlayColors;
    private GradientWrapper qualityOverlayLookup;
    private LinearGradientPaint qualityOverlayGradient;
    private RoundRectangle2D qualityOverlay;
    private boolean glowVisible;
    private Color glowColor;
    private boolean glowing;
    private BufferedImage glowImageOn;
    private boolean lcdNnumericValues;
    private String lcdText;
    private float lcdTextX;
    private Timer TEXT_SCROLLER;
    private final transient ComponentListener COMPONENT_LISTENER = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            Container container = DisplaySingle.this.getParent();
            if (DisplaySingle.this.getWidth() < DisplaySingle.this.getMinimumSize().width && DisplaySingle.this.getHeight() < DisplaySingle.this.getMinimumSize().height) {
                if (container != null && DisplaySingle.this.getParent().getLayout() == null) {
                    DisplaySingle.this.setSize(DisplaySingle.this.getMinimumSize());
                } else {
                    DisplaySingle.this.setPreferredSize(DisplaySingle.this.getMinimumSize());
                }
            }
            if (container != null && DisplaySingle.this.getParent().getLayout() == null) {
                DisplaySingle.this.setSize(DisplaySingle.this.getWidth(), DisplaySingle.this.getHeight());
            } else {
                DisplaySingle.this.setPreferredSize(new Dimension(DisplaySingle.this.getWidth(), DisplaySingle.this.getHeight()));
            }
            DisplaySingle.this.calcInnerBounds();
            DisplaySingle.this.init(((DisplaySingle)DisplaySingle.this).getInnerBounds().width, ((DisplaySingle)DisplaySingle.this).getInnerBounds().height);
        }
    };

    public DisplaySingle() {
        this.customLcdUnitFont = new Font("Verdana", 0, 24);
        this.LCD_STANDARD_FONT = new Font("Verdana", 0, 24);
        this.LCD_DIGITAL_FONT = Util.INSTANCE.getDigitalFont().deriveFont(24).deriveFont(0);
        this.lcdInfoFont = new Font("Verdana", 0, 24);
        this.numberSystem = NumberSystem.DEC;
        this.DISABLED_COLOR = new Color(102, 102, 102, 178);
        this.timeline = new Timeline((Object)this);
        this.EASING = new Linear();
        this.sections = new ArrayList(3);
        this.sectionsBackground = new ArrayList(3);
        this.sectionsForeground = new ArrayList(3);
        this.overlayInsets = new Insets(6, 6, 6, 6);
        this.overlayColors = new Color[]{Color.RED, Color.RED.darker(), Color.RED};
        this.qualityOverlayFractions = new float[]{0.0f, 0.2f, 0.5f, 0.75f, 0.9f, 1.0f};
        this.qualityOverlayColors = new Color[]{Color.RED, Color.RED, Color.ORANGE, Color.YELLOW, Color.GREEN, Color.GREEN};
        this.qualityOverlayLookup = new GradientWrapper(new Point2D.Double(this.INNER_BOUNDS.getBounds2D().getMinX(), 0.0), new Point2D.Double(this.INNER_BOUNDS.getMaxX(), 0.0), this.qualityOverlayFractions, this.qualityOverlayColors);
        this.qualityOverlayGradient = new LinearGradientPaint(new Point2D.Double(0.0, 2.0), new Point2D.Double(0.0, this.INNER_BOUNDS.height - 2), new float[]{0.0f, 0.5f, 1.0f}, new Color[]{Color.RED, Color.RED.darker(), Color.RED});
        this.qualityOverlay = new RoundRectangle2D.Double();
        this.glowVisible = false;
        this.glowColor = new Color(51, 255, 255);
        this.glowing = false;
        this.lcdNnumericValues = true;
        this.lcdText = "";
        this.lcdTextX = 0.0f;
        this.TEXT_SCROLLER = new Timer(60, this);
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
        this.addComponentListener(this.COMPONENT_LISTENER);
    }

    public final void init(int n, int n2) {
        if (n <= 1 || n2 <= 1) {
            return;
        }
        if (this.bgImage != null) {
            this.bgImage.flush();
        }
        if (this.lcdImage != null) {
            this.lcdImage.flush();
        }
        if (this.glowImageOn != null) {
            this.glowImageOn.flush();
        }
        this.glowImageOn = GlowImageFactory.INSTANCE.createLcdGlow(n, n2, this.glowColor, true);
        this.lcdImage = this.create_LCD_Image(n, n2, null);
        double d = n > n2 ? (double)n2 * 0.095 : (double)n * 0.095;
        this.disabledShape = new RoundRectangle2D.Double(0.0, 0.0, n, n2, d, d);
        if (this.isDigitalFont()) {
            this.lcdValueFont = this.LCD_DIGITAL_FONT.deriveFont(0.7f * (float)this.getInnerBounds().height).deriveFont(0);
            this.lcdUnitFont = this.useCustomLcdUnitFont ? this.customLcdUnitFont.deriveFont(0.25f * (float)this.getInnerBounds().height) : this.LCD_STANDARD_FONT.deriveFont(0.25f * (float)this.getInnerBounds().height);
        } else {
            this.lcdValueFont = this.LCD_STANDARD_FONT.deriveFont(0.625f * (float)this.getInnerBounds().height);
            this.lcdUnitFont = this.useCustomLcdUnitFont ? this.customLcdUnitFont.deriveFont(0.25f * (float)this.getInnerBounds().height) : this.LCD_STANDARD_FONT.deriveFont(0.25f * (float)this.getInnerBounds().height);
        }
        this.lcdInfoFont = this.LCD_STANDARD_FONT.deriveFont(0.15f * (float)this.getInnerBounds().height);
        if (this.lcdThresholdImage != null) {
            this.lcdThresholdImage.flush();
        }
        this.lcdThresholdImage = this.create_LCD_THRESHOLD_Image((int)((double)n2 * 0.2045454545), (int)((double)n2 * 0.2045454545), this.lcdColor.TEXT_COLOR);
        if (!this.sections.isEmpty()) {
            this.sectionsBackground.clear();
            this.sectionsForeground.clear();
            float[] fArray = Color.RGBtoHSB(this.lcdColor.GRADIENT_START_COLOR.getRed(), this.lcdColor.GRADIENT_START_COLOR.getGreen(), this.lcdColor.GRADIENT_START_COLOR.getBlue(), null);
            float[] fArray2 = Color.RGBtoHSB(this.lcdColor.GRADIENT_FRACTION1_COLOR.getRed(), this.lcdColor.GRADIENT_FRACTION1_COLOR.getGreen(), this.lcdColor.GRADIENT_FRACTION1_COLOR.getBlue(), null);
            float[] fArray3 = Color.RGBtoHSB(this.lcdColor.GRADIENT_FRACTION2_COLOR.getRed(), this.lcdColor.GRADIENT_FRACTION2_COLOR.getGreen(), this.lcdColor.GRADIENT_FRACTION2_COLOR.getBlue(), null);
            float[] fArray4 = Color.RGBtoHSB(this.lcdColor.GRADIENT_FRACTION3_COLOR.getRed(), this.lcdColor.GRADIENT_FRACTION3_COLOR.getGreen(), this.lcdColor.GRADIENT_FRACTION3_COLOR.getBlue(), null);
            float[] fArray5 = Color.RGBtoHSB(this.lcdColor.GRADIENT_STOP_COLOR.getRed(), this.lcdColor.GRADIENT_STOP_COLOR.getGreen(), this.lcdColor.GRADIENT_STOP_COLOR.getBlue(), null);
            float f = fArray[0];
            float f2 = fArray2[0];
            float f3 = fArray3[0];
            float f4 = fArray4[0];
            float f5 = fArray5[0];
            float f6 = fArray[2];
            float f7 = fArray2[2];
            float f8 = fArray3[2];
            float f9 = fArray4[2];
            float f10 = fArray5[2];
            for (Section section : this.sections) {
                Color color;
                float f11;
                Color[] colorArray;
                float[] fArray6 = Color.RGBtoHSB(section.getColor().getRed(), section.getColor().getGreen(), section.getColor().getBlue(), null);
                float f12 = fArray6[0];
                float f13 = fArray6[1];
                float f14 = fArray6[2];
                if (!this.UTIL.isMonochrome(section.getColor())) {
                    if (this.lcdColor == LcdColor.SECTIONS_LCD) {
                        colorArray = new Color[]{new Color(Color.HSBtoRGB(f12, f13, f6 - 0.31f)), new Color(Color.HSBtoRGB(f12, f13, f7 - 0.31f)), new Color(Color.HSBtoRGB(f12, f13, f8 - 0.31f)), new Color(Color.HSBtoRGB(f12, f13, f9 - 0.31f)), new Color(Color.HSBtoRGB(f12, f13, f10 - 0.31f))};
                    } else {
                        f11 = f12 - f4;
                        colorArray = new Color[]{this.UTIL.setHue(this.lcdColor.GRADIENT_START_COLOR, (f + f11) % 360.0f), this.UTIL.setHue(this.lcdColor.GRADIENT_FRACTION1_COLOR, (f2 + f11) % 360.0f), this.UTIL.setHue(this.lcdColor.GRADIENT_FRACTION2_COLOR, (f3 + f11) % 360.0f), this.UTIL.setHue(this.lcdColor.GRADIENT_FRACTION3_COLOR, (f4 + f11) % 360.0f), this.UTIL.setHue(this.lcdColor.GRADIENT_STOP_COLOR, (f5 + f11) % 360.0f)};
                    }
                    color = this.UTIL.setSaturationBrightness(section.getColor(), 0.57f, 0.83f);
                } else {
                    f11 = f14 - f7;
                    colorArray = new Color[]{this.UTIL.setSaturationBrightness(this.lcdColor.GRADIENT_START_COLOR, 0.0f, f6 + f11), this.UTIL.setSaturationBrightness(this.lcdColor.GRADIENT_FRACTION1_COLOR, 0.0f, f7 + f11), this.UTIL.setSaturationBrightness(this.lcdColor.GRADIENT_FRACTION2_COLOR, 0.0f, f8 + f11), this.UTIL.setSaturationBrightness(this.lcdColor.GRADIENT_FRACTION3_COLOR, 0.0f, f9 + f11), this.UTIL.setSaturationBrightness(this.lcdColor.GRADIENT_STOP_COLOR, 0.0f, f10 + f11)};
                    color = this.UTIL.isDark(section.getColor()) ? Color.WHITE : Color.BLACK;
                }
                this.sectionsBackground.add(this.create_LCD_Image(n, n2, colorArray));
                this.sectionsForeground.add(color);
            }
        }
        this.overlayCornerRadius = n > n2 ? (double)n2 * 0.095 - 1.0 : (double)n * 0.095 - 1.0;
        this.overlayFactor = (float)(this.lcdValue / (this.lcdMaxValue - this.lcdMinValue));
        this.factor = Double.compare(this.overlayFactor, 1.0) > 0 ? 1.0f : (Double.compare(this.overlayFactor, 0.0) < 0 ? 0.0f : this.overlayFactor);
        this.overlayColors = new Color[]{this.UTIL.setAlpha(this.qualityOverlayLookup.getColorAt(this.factor), 0.5f), this.UTIL.setAlpha(this.qualityOverlayLookup.getColorAt(this.factor).darker(), 0.5f), this.UTIL.setAlpha(this.qualityOverlayLookup.getColorAt(this.factor), 0.5f)};
        int n3 = (int)(this.qualityOverlay.getWidth() * this.qualityOverlay.getHeight() * 9.765625E-4);
        this.overlayInsets.set(n3, n3, n3, n3);
        this.qualityOverlayLookup = new GradientWrapper(new Point2D.Double(this.overlayInsets.left, 0.0), new Point2D.Double(this.lcdImage.getMinX() + this.lcdImage.getWidth() - this.overlayInsets.right, 0.0), this.qualityOverlayFractions, this.qualityOverlayColors);
        this.qualityOverlayGradient = new LinearGradientPaint(new Point2D.Double(0.0, this.overlayInsets.top), new Point2D.Double(0.0, n2 - this.overlayInsets.bottom), new float[]{0.0f, 0.5f, 1.0f}, this.overlayColors);
        double d2 = (float)(n - (this.overlayInsets.left + this.overlayInsets.right)) * this.overlayFactor > (float)(n - (this.overlayInsets.left + this.overlayInsets.right)) ? (double)(n - (this.overlayInsets.left + this.overlayInsets.right)) : (double)((float)(n - (this.overlayInsets.left + this.overlayInsets.right)) * this.overlayFactor);
        this.qualityOverlay.setRoundRect(this.overlayInsets.left, this.overlayInsets.top, d2, n2 - (this.overlayInsets.left + this.overlayInsets.right) - 1, this.overlayCornerRadius, this.overlayCornerRadius);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.translate(this.getInnerBounds().x, this.getInnerBounds().y);
        if (this.sectionsVisible && !this.sections.isEmpty()) {
            for (int i = 0; i < this.sections.size(); ++i) {
                if (Double.compare(this.lcdValue, this.sections.get(i).getStart()) >= 0 && Double.compare(this.lcdValue, this.sections.get(i).getStop()) <= 0) {
                    this.bgImage = this.sectionsBackground.get(i);
                    this.fgColor = this.sectionsForeground.get(i);
                    break;
                }
                this.bgImage = this.lcdImage;
                this.fgColor = this.lcdColor.TEXT_COLOR;
            }
            if (this.bgImage == null) {
                this.bgImage = this.lcdImage;
                this.fgColor = null;
            }
        } else {
            this.bgImage = this.lcdImage;
            this.fgColor = null;
        }
        graphics2D.drawImage((Image)this.bgImage, 0, 0, null);
        if (this.qualityOverlayVisible && this.lcdValue > this.lcdMinValue) {
            graphics2D.setPaint(this.qualityOverlayGradient);
            graphics2D.fill(this.qualityOverlay);
        }
        if (this.fgColor == null) {
            if (this.lcdColor == LcdColor.CUSTOM) {
                graphics2D.setColor(this.customLcdForeground);
            } else {
                graphics2D.setColor(this.lcdColor.TEXT_COLOR);
            }
        } else {
            graphics2D.setColor(this.fgColor);
        }
        if (this.lcdNnumericValues) {
            double d;
            graphics2D.setFont(this.lcdUnitFont);
            if (this.lcdUnitStringVisible && !this.lcdUnitString.isEmpty()) {
                this.unitLayout = new TextLayout(this.lcdUnitString, graphics2D.getFont(), this.RENDER_CONTEXT);
                this.UNIT_BOUNDARY.setFrame(this.unitLayout.getBounds());
                graphics2D.drawString(this.lcdUnitString, (int)((double)this.lcdImage.getWidth() - this.UNIT_BOUNDARY.getWidth() - (double)((float)this.lcdImage.getWidth() * 0.03f)), (int)((float)this.lcdImage.getHeight() * 0.76f));
                d = this.UNIT_BOUNDARY.getWidth();
            } else {
                d = 0.0;
            }
            graphics2D.setFont(this.lcdValueFont);
            switch (this.numberSystem) {
                case HEX: {
                    this.valueLayout = new TextLayout(Integer.toHexString((int)this.lcdValue).toUpperCase(), graphics2D.getFont(), this.RENDER_CONTEXT);
                    this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                    graphics2D.drawString(Integer.toHexString((int)this.lcdValue).toUpperCase(), (float)((double)this.lcdImage.getWidth() - d - this.VALUE_BOUNDARY.getWidth() - (double)this.lcdImage.getWidth() * 0.09), (float)this.lcdImage.getHeight() * 0.76f);
                    break;
                }
                case OCT: {
                    this.valueLayout = new TextLayout(Integer.toOctalString((int)this.lcdValue), graphics2D.getFont(), this.RENDER_CONTEXT);
                    this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                    graphics2D.drawString(Integer.toOctalString((int)this.lcdValue), (float)((double)this.lcdImage.getWidth() - d - this.VALUE_BOUNDARY.getWidth() - (double)this.lcdImage.getWidth() * 0.09), (float)this.lcdImage.getHeight() * 0.76f);
                    break;
                }
                default: {
                    this.valueLayout = new TextLayout(this.formatLcdValue(this.lcdValue), graphics2D.getFont(), this.RENDER_CONTEXT);
                    this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                    graphics2D.drawString(this.formatLcdValue(this.lcdValue), (float)((double)this.lcdImage.getWidth() - d - this.VALUE_BOUNDARY.getWidth() - (double)this.lcdImage.getWidth() * 0.09), (float)this.lcdImage.getHeight() * 0.76f);
                }
            }
            if (!this.lcdInfoString.isEmpty()) {
                graphics2D.setFont(this.lcdInfoFont);
                this.infoLayout = new TextLayout(this.lcdInfoString, graphics2D.getFont(), this.RENDER_CONTEXT);
                this.INFO_BOUNDARY.setFrame(this.infoLayout.getBounds());
                graphics2D.drawString(this.lcdInfoString, 5.0f, (float)this.INFO_BOUNDARY.getHeight() + 5.0f);
            }
        } else {
            graphics2D.setFont(this.lcdValueFont);
            if (!this.lcdText.isEmpty()) {
                this.valueLayout = new TextLayout(this.lcdText, graphics2D.getFont(), this.RENDER_CONTEXT);
                this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                if (!this.TEXT_SCROLLER.isRunning()) {
                    this.lcdTextX = (float)this.VALUE_BOUNDARY.getWidth();
                }
                graphics2D.drawString(this.lcdText, (float)this.lcdImage.getWidth() - this.lcdTextX - (float)this.lcdImage.getWidth() * 0.03f, (float)this.lcdImage.getHeight() * 0.76f);
            }
        }
        if (this.numberSystem == NumberSystem.DEC && this.lcdThresholdVisible) {
            if (!this.lcdThresholdBehaviourInverted) {
                if (this.lcdValue >= this.lcdThreshold) {
                    graphics2D.drawImage((Image)this.lcdThresholdImage, 5, this.getHeight() - this.lcdThresholdImage.getHeight() - 5, null);
                }
            } else if (this.lcdValue <= this.lcdThreshold) {
                graphics2D.drawImage((Image)this.lcdThresholdImage, 5, this.getHeight() - this.lcdThresholdImage.getHeight() - 5, null);
            }
        }
        if (this.glowVisible && this.glowing) {
            graphics2D.drawImage((Image)this.glowImageOn, 0, 0, null);
        }
        if (!this.isEnabled()) {
            graphics2D.setColor(this.DISABLED_COLOR);
            graphics2D.fill(this.disabledShape);
        }
        graphics2D.dispose();
    }

    public BufferedImage getAsImage() {
        BufferedImage bufferedImage = this.UTIL.createImage(this.getWidth(), this.getHeight(), 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        this.paintAll(graphics2D);
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    public double getLcdValue() {
        return this.lcdValue;
    }

    @Override
    public void setLcdValue(double d) {
        double d2 = this.lcdValue;
        this.lcdValue = d;
        if (this.qualityOverlayVisible) {
            this.overlayCornerRadius = this.INNER_BOUNDS.width > this.INNER_BOUNDS.height ? (double)this.INNER_BOUNDS.height * 0.095 - 1.0 : (double)this.INNER_BOUNDS.width * 0.095 - 1.0;
            this.overlayFactor = (float)(this.lcdValue / (this.lcdMaxValue - this.lcdMinValue));
            this.factor = Double.compare(this.overlayFactor, 1.0) > 0 ? 1.0f : (Double.compare(this.overlayFactor, 0.0) < 0 ? 0.0f : this.overlayFactor);
            this.overlayColors = new Color[]{this.UTIL.setAlpha(this.qualityOverlayLookup.getColorAt(this.factor), 0.5f), this.UTIL.setAlpha(this.qualityOverlayLookup.getColorAt(this.factor).darker(), 0.5f), this.UTIL.setAlpha(this.qualityOverlayLookup.getColorAt(this.factor), 0.5f)};
            this.qualityOverlayLookup = new GradientWrapper(new Point2D.Double(this.lcdImage.getMinX() + this.overlayInsets.left, 0.0), new Point2D.Double(this.lcdImage.getMinX() + this.lcdImage.getWidth() - this.overlayInsets.right, 0.0), this.qualityOverlayFractions, this.qualityOverlayColors);
            this.qualityOverlayGradient = new LinearGradientPaint(new Point2D.Double(0.0, this.overlayInsets.top), new Point2D.Double(0.0, this.INNER_BOUNDS.height - this.overlayInsets.bottom), new float[]{0.0f, 0.5f, 1.0f}, this.overlayColors);
            this.qualityOverlay.setRoundRect(this.overlayInsets.left, this.overlayInsets.top, (float)(this.INNER_BOUNDS.width - this.overlayInsets.left - this.overlayInsets.right) * this.overlayFactor, this.INNER_BOUNDS.height - this.overlayInsets.top - this.overlayInsets.bottom, this.overlayCornerRadius, this.overlayCornerRadius);
        }
        this.firePropertyChange(LCD_VALUE_PROPERTY, d2, d);
        this.repaint(this.getInnerBounds());
    }

    public double getLcdMinValue() {
        return this.lcdMinValue;
    }

    public void setLcdMinValue(double d) {
        if (Double.compare(d, this.lcdMaxValue) == 0) {
            throw new IllegalArgumentException("Min value cannot be equal to max value");
        }
        if (Double.compare(d, this.lcdMaxValue) > 0) {
            this.lcdMinValue = this.lcdMaxValue;
            this.lcdMaxValue = d;
        } else {
            this.lcdMinValue = d;
        }
        this.init(this.getWidth(), this.getHeight());
        this.repaint(this.getInnerBounds());
    }

    public double getLcdMaxValue() {
        return this.lcdMaxValue;
    }

    public void setLcdMaxValue(double d) {
        if (Double.compare(d, this.lcdMinValue) == 0) {
            throw new IllegalArgumentException("Max value cannot be equal to min value");
        }
        if (Double.compare(d, this.lcdMinValue) < 0) {
            this.lcdMaxValue = this.lcdMinValue;
            this.lcdMinValue = d;
        } else {
            this.lcdMaxValue = d;
        }
        this.init(this.getWidth(), this.getHeight());
        this.repaint(this.getInnerBounds());
    }

    public boolean isLcdNumericValues() {
        return this.lcdNnumericValues;
    }

    public void setLcdNumericValues(boolean bl) {
        if (bl) {
            this.TEXT_SCROLLER.stop();
        }
        this.lcdNnumericValues = bl;
        this.repaint(this.getInnerBounds());
    }

    public String getLcdText() {
        return this.lcdText;
    }

    public void setLcdText(String string) {
        String string2 = this.lcdText;
        this.lcdText = string;
        this.firePropertyChange(LCD_TEXT_PROPERTY, string2, string);
        this.repaint(this.getInnerBounds());
    }

    public boolean isLcdTextScrolling() {
        return this.TEXT_SCROLLER.isRunning();
    }

    public void setLcdTextScrolling(boolean bl) {
        if (!this.isLcdNumericValues()) {
            if (bl) {
                this.TEXT_SCROLLER.start();
            } else {
                this.TEXT_SCROLLER.stop();
            }
        }
    }

    @Override
    public void setLcdValueAnimated(double d) {
        if (this.isEnabled()) {
            if (this.timeline.getState() != Timeline.TimelineState.IDLE) {
                this.timeline.abort();
            }
            this.timeline = new Timeline((Object)this);
            this.timeline.addPropertyToInterpolate(LCD_VALUE_PROPERTY, (Object)this.lcdValue, (Object)d);
            this.timeline.setEase(this.EASING);
            this.timeline.setDuration(2000L);
            this.timeline.play();
        }
    }

    @Override
    public double getLcdThreshold() {
        return this.lcdThreshold;
    }

    @Override
    public void setLcdThreshold(double d) {
        this.lcdThreshold = d;
        if (this.lcdThresholdVisible) {
            this.repaint(this.getInnerBounds());
        }
    }

    @Override
    public boolean isLcdThresholdVisible() {
        return this.lcdThresholdVisible;
    }

    @Override
    public void setLcdThresholdVisible(boolean bl) {
        this.lcdThresholdVisible = bl;
        this.repaint(this.getInnerBounds());
    }

    @Override
    public boolean isLcdThresholdBehaviourInverted() {
        return this.lcdThresholdBehaviourInverted;
    }

    @Override
    public void setLcdThresholdBehaviourInverted(boolean bl) {
        this.lcdThresholdBehaviourInverted = bl;
    }

    @Override
    public int getLcdDecimals() {
        return this.lcdDecimals;
    }

    @Override
    public void setLcdDecimals(int n) {
        this.lcdDecimals = n;
        this.repaint(this.getInnerBounds());
    }

    @Override
    public String getLcdUnitString() {
        return this.lcdUnitString;
    }

    @Override
    public void setLcdUnitString(String string) {
        this.lcdUnitString = string;
        this.repaint(this.getInnerBounds());
    }

    @Override
    public boolean isLcdUnitStringVisible() {
        return this.lcdUnitStringVisible;
    }

    @Override
    public void setLcdUnitStringVisible(boolean bl) {
        this.lcdUnitStringVisible = bl;
        this.repaint(this.getInnerBounds());
    }

    @Override
    public boolean isCustomLcdUnitFontEnabled() {
        return this.useCustomLcdUnitFont;
    }

    @Override
    public void setCustomLcdUnitFontEnabled(boolean bl) {
        this.useCustomLcdUnitFont = bl;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Font getCustomLcdUnitFont() {
        return this.customLcdUnitFont;
    }

    @Override
    public void setCustomLcdUnitFont(Font font) {
        this.customLcdUnitFont = font;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public void setLcdScientificFormat(boolean bl) {
        this.lcdScientificFormat = bl;
    }

    @Override
    public boolean isLcdScientificFormat() {
        return this.lcdScientificFormat;
    }

    @Override
    public boolean isDigitalFont() {
        return this.digitalFont;
    }

    @Override
    public void setDigitalFont(boolean bl) {
        this.digitalFont = bl;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public LcdColor getLcdColor() {
        return this.lcdColor;
    }

    @Override
    public void setLcdColor(LcdColor lcdColor) {
        this.lcdColor = lcdColor;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Paint getCustomLcdBackground() {
        return this.customLcdBackground;
    }

    @Override
    public void setCustomLcdBackground(Paint paint) {
        this.customLcdBackground = paint;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Paint createCustomLcdBackgroundPaint(Color[] colorArray) {
        Point2D.Double double_ = new Point2D.Double(0.0, 1.0);
        Point2D.Double double_2 = new Point2D.Double(0.0, this.getHeight() - 1);
        if (double_.equals(double_2)) {
            ((Point2D)double_2).setLocation(0.0, ((Point2D)double_).getY() + 1.0);
        }
        float[] fArray = new float[]{0.0f, 0.03f, 0.49f, 0.5f, 1.0f};
        Color[] colorArray2 = new Color[]{colorArray[0], colorArray[1], colorArray[2], colorArray[3], colorArray[4]};
        return new LinearGradientPaint(double_, double_2, fArray, colorArray2);
    }

    @Override
    public Color getCustomLcdForeground() {
        return this.customLcdForeground;
    }

    @Override
    public void setCustomLcdForeground(Color color) {
        this.customLcdForeground = color;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public String formatLcdValue(double d) {
        StringBuilder stringBuilder = new StringBuilder(16);
        stringBuilder.append("0");
        if (this.lcdDecimals > 0) {
            stringBuilder.append(".");
        }
        for (int i = 0; i < this.lcdDecimals; ++i) {
            stringBuilder.append("0");
        }
        if (this.lcdScientificFormat) {
            stringBuilder.append("E0");
        }
        DecimalFormat decimalFormat = new DecimalFormat(stringBuilder.toString(), new DecimalFormatSymbols(Locale.US));
        return decimalFormat.format(d);
    }

    @Override
    public boolean isValueCoupled() {
        return false;
    }

    @Override
    public void setValueCoupled(boolean bl) {
    }

    @Override
    public Font getLcdValueFont() {
        return this.lcdValueFont;
    }

    @Override
    public void setLcdValueFont(Font font) {
        this.lcdValueFont = font;
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Font getLcdUnitFont() {
        return this.lcdUnitFont;
    }

    @Override
    public void setLcdUnitFont(Font font) {
        this.lcdUnitFont = font;
        this.repaint(this.getInnerBounds());
    }

    @Override
    public String getLcdInfoString() {
        return this.lcdInfoString;
    }

    @Override
    public void setLcdInfoString(String string) {
        this.lcdInfoString = string;
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Font getLcdInfoFont() {
        return this.lcdInfoFont;
    }

    @Override
    public void setLcdInfoFont(Font font) {
        this.lcdInfoFont = font;
        this.repaint(this.getInnerBounds());
    }

    @Override
    public NumberSystem getLcdNumberSystem() {
        return this.numberSystem;
    }

    @Override
    public void setLcdNumberSystem(NumberSystem numberSystem) {
        this.numberSystem = numberSystem;
        switch (numberSystem) {
            case HEX: {
                this.lcdInfoString = "hex";
                break;
            }
            case OCT: {
                this.lcdInfoString = "oct";
                break;
            }
            default: {
                this.lcdInfoString = "";
            }
        }
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Rectangle getLcdBounds() {
        return this.getInnerBounds();
    }

    public boolean isQualityOverlayVisible() {
        return this.qualityOverlayVisible;
    }

    public void setQualityOverlayVisible(boolean bl) {
        this.qualityOverlayVisible = bl;
        this.repaint(this.getInnerBounds());
    }

    public float[] getQualityOverlayFractions() {
        return (float[])this.qualityOverlayFractions.clone();
    }

    public Color[] getQualityOverlayColors() {
        return (Color[])this.qualityOverlayColors.clone();
    }

    public void setQualityOverlayFractionsAndColors(float[] fArray, Color[] colorArray) {
        if (fArray.length != colorArray.length) {
            return;
        }
        this.qualityOverlayFractions = (float[])fArray.clone();
        this.qualityOverlayColors = (Color[])colorArray.clone();
        this.init(this.getWidth(), this.getHeight());
        this.repaint(this.getInnerBounds());
    }

    public boolean isGlowVisible() {
        return this.glowVisible;
    }

    public void setGlowVisible(boolean bl) {
        this.glowVisible = bl;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint();
    }

    public Color getGlowColor() {
        return this.glowColor;
    }

    public void setGlowColor(Color color) {
        this.glowColor = color;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint();
    }

    public boolean isGlowing() {
        return this.glowing;
    }

    public void setGlowing(boolean bl) {
        this.glowing = bl;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint();
    }

    public boolean isSectionsVisible() {
        return this.sectionsVisible;
    }

    public void setSectionsVisible(boolean bl) {
        this.sectionsVisible = bl;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public List<Section> getSections() {
        ArrayList<Section> arrayList = new ArrayList<Section>(this.sections.size());
        arrayList.addAll(this.sections);
        return arrayList;
    }

    public void setSections(Section ... sectionArray) {
        this.sections.clear();
        for (Section section : sectionArray) {
            this.sections.add(new Section(section.getStart(), section.getStop(), section.getColor()));
        }
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public void addSection(Section section) {
        this.sections.add(section);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public void resetSections() {
        this.sections.clear();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    private BufferedImage create_LCD_Image(int n, int n2, Color[] colorArray) {
        if (n <= 0 || n2 <= 0) {
            return null;
        }
        BufferedImage bufferedImage = this.UTIL.createImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
        Point2D.Double double_2 = new Point2D.Double(0.0, n4);
        if (double_.equals(double_2)) {
            ((Point2D)double_2).setLocation(0.0, ((Point2D)double_).getY() + 1.0);
        }
        float[] fArray = new float[]{0.0f, 0.08f, 0.92f, 1.0f};
        Color[] colorArray2 = new Color[]{new Color(0.4f, 0.4f, 0.4f, 1.0f), new Color(0.5f, 0.5f, 0.5f, 1.0f), new Color(0.5f, 0.5f, 0.5f, 1.0f), new Color(0.9f, 0.9f, 0.9f, 1.0f)};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray2);
        double d = n > n2 ? (double)n2 * 0.095 : (double)n * 0.095;
        RoundRectangle2D.Double double_3 = new RoundRectangle2D.Double(0.0, 0.0, n3, n4, d, d);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(double_3);
        Point2D.Double double_4 = new Point2D.Double(0.0, 1.0);
        Point2D.Double double_5 = new Point2D.Double(0.0, n4 - 1);
        if (double_4.equals(double_5)) {
            ((Point2D)double_5).setLocation(0.0, ((Point2D)double_4).getY() + 1.0);
        }
        float[] fArray2 = new float[]{0.0f, 0.03f, 0.49f, 0.5f, 1.0f};
        if (colorArray == null) {
            colorArray = new Color[]{this.lcdColor.GRADIENT_START_COLOR, this.lcdColor.GRADIENT_FRACTION1_COLOR, this.lcdColor.GRADIENT_FRACTION2_COLOR, this.lcdColor.GRADIENT_FRACTION3_COLOR, this.lcdColor.GRADIENT_STOP_COLOR};
        }
        if (this.lcdColor == LcdColor.CUSTOM) {
            graphics2D.setPaint(this.customLcdBackground);
        } else {
            LinearGradientPaint linearGradientPaint2 = new LinearGradientPaint(double_4, double_5, fArray2, colorArray);
            graphics2D.setPaint(linearGradientPaint2);
        }
        double d2 = ((RoundRectangle2D)double_3).getArcWidth() - 1.0;
        RoundRectangle2D.Double double_6 = new RoundRectangle2D.Double(1.0, 1.0, n3 - 2, n4 - 2, d2, d2);
        graphics2D.fill(double_6);
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_LCD_THRESHOLD_Image(int n, int n2, Color color) {
        if (n <= 0 || n2 <= 0) {
            return null;
        }
        BufferedImage bufferedImage = this.UTIL.createImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n3 * 0.4444444444444444, (double)n4 * 0.7777777777777778);
        generalPath.lineTo((double)n3 * 0.5555555555555556, (double)n4 * 0.7777777777777778);
        generalPath.lineTo((double)n3 * 0.5555555555555556, (double)n4 * 0.8888888888888888);
        generalPath.lineTo((double)n3 * 0.4444444444444444, (double)n4 * 0.8888888888888888);
        generalPath.lineTo((double)n3 * 0.4444444444444444, (double)n4 * 0.7777777777777778);
        generalPath.closePath();
        generalPath.moveTo((double)n3 * 0.4444444444444444, (double)n4 * 0.3333333333333333);
        generalPath.lineTo((double)n3 * 0.5555555555555556, (double)n4 * 0.3333333333333333);
        generalPath.lineTo((double)n3 * 0.5555555555555556, (double)n4 * 0.7222222222222222);
        generalPath.lineTo((double)n3 * 0.4444444444444444, (double)n4 * 0.7222222222222222);
        generalPath.lineTo((double)n3 * 0.4444444444444444, (double)n4 * 0.3333333333333333);
        generalPath.closePath();
        generalPath.moveTo(0.0, (double)n4);
        generalPath.lineTo(n3, n4);
        generalPath.lineTo((double)n3 * 0.5, 0.0);
        generalPath.lineTo(0.0, (double)n4);
        generalPath.closePath();
        graphics2D.setColor(color);
        graphics2D.fill(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    private void calcInnerBounds() {
        Insets insets = this.getInsets();
        this.INNER_BOUNDS.setBounds(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
    }

    private Rectangle getInnerBounds() {
        return this.INNER_BOUNDS;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(128, 48);
    }

    @Override
    public void setPreferredSize(Dimension dimension) {
        super.setPreferredSize(dimension);
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public void setSize(Dimension dimension) {
        super.setSize(dimension);
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public void setBounds(Rectangle rectangle) {
        super.setBounds(rectangle);
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public void setBorder(Border border) {
        super.setBorder(border);
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if ((double)this.lcdTextX > (double)this.lcdImage.getWidth() + this.VALUE_BOUNDARY.getWidth()) {
            this.lcdTextX = -this.VALUE_BOUNDARY.getBounds().width;
        }
        this.lcdTextX += 1.0f;
        this.repaint(this.getInnerBounds());
    }

    @Override
    public String toString() {
        return "DisplaySingle";
    }
}

