/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.gauges;

import eu.hansolo.steelseries.gauges.AbstractGauge;
import eu.hansolo.steelseries.gauges.AbstractLinear;
import eu.hansolo.steelseries.tools.ColorDef;
import eu.hansolo.steelseries.tools.LcdColor;
import eu.hansolo.steelseries.tools.Model;
import eu.hansolo.steelseries.tools.NumberSystem;
import eu.hansolo.steelseries.tools.Orientation;
import eu.hansolo.steelseries.tools.Section;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class Linear
extends AbstractLinear {
    private BufferedImage bImage;
    private BufferedImage fImage;
    private BufferedImage glowImageOff;
    private BufferedImage glowImageOn;
    private BufferedImage thresholdImage;
    private BufferedImage minMeasuredImage;
    private BufferedImage maxMeasuredImage;
    private BufferedImage lcdThresholdImage;
    private BufferedImage disabledImage;
    private final Rectangle2D VALUE_BACKGROUND_TRACK;
    private final Point2D VALUE_BACKGROUND_START;
    private final Point2D VALUE_BACKGROUND_STOP;
    private final float[] VALUE_BACKGROUND_TRACK_FRACTIONS;
    private final Rectangle2D VALUE_LEFT_BORDER;
    private final Rectangle2D VALUE_RIGHT_BORDER;
    private final Point2D VALUE_BORDER_START;
    private final Point2D VALUE_BORDER_STOP;
    private final float[] VALUE_BORDER_FRACTIONS;
    private final Rectangle2D VALUE_BACKGROUND;
    private final Point2D VALUE_START;
    private final Point2D VALUE_STOP;
    private static final int BASE = 10;
    private final Rectangle2D VALUE_FOREGROUND;
    private final Point2D VALUE_FOREGROUND_START;
    private final Point2D VALUE_FOREGROUND_STOP;
    private final float[] VALUE_FOREGROUND_FRACTIONS;
    private final Color[] VALUE_FOREGROUND_COLORS;
    private final Rectangle2D LCD = new Rectangle2D.Double();
    private final FontRenderContext RENDER_CONTEXT = new FontRenderContext(null, true, true);
    private double unitStringWidth;
    private TextLayout unitLayout;
    private final Rectangle2D UNIT_BOUNDARY = new Rectangle2D.Double();
    private TextLayout valueLayout;
    private final Rectangle2D VALUE_BOUNDARY = new Rectangle2D.Double();
    private TextLayout infoLayout;
    private final Rectangle2D INFO_BOUNDARY = new Rectangle2D.Double();

    public Linear() {
        this.VALUE_BACKGROUND_TRACK = new Rectangle2D.Double(0.0, 0.0, 10.0, 10.0);
        this.VALUE_BACKGROUND_START = new Point2D.Double(0.0, 0.0);
        this.VALUE_BACKGROUND_STOP = new Point2D.Double(0.0, 0.0);
        this.VALUE_BACKGROUND_TRACK_FRACTIONS = new float[]{0.0f, 0.48f, 0.49f, 1.0f};
        this.VALUE_LEFT_BORDER = new Rectangle2D.Double(0.0, 0.0, 10.0, 10.0);
        this.VALUE_RIGHT_BORDER = new Rectangle2D.Double(0.0, 0.0, 10.0, 10.0);
        this.VALUE_BORDER_START = new Point2D.Double(0.0, 0.0);
        this.VALUE_BORDER_STOP = new Point2D.Double(0.0, 0.0);
        this.VALUE_BORDER_FRACTIONS = new float[]{0.0f, 0.48f, 0.49f, 1.0f};
        this.VALUE_BACKGROUND = new Rectangle2D.Double(0.0, 0.0, 10.0, 10.0);
        this.VALUE_START = new Point2D.Double(0.0, 0.0);
        this.VALUE_STOP = new Point2D.Double(0.0, 0.0);
        this.VALUE_FOREGROUND = new Rectangle2D.Double(0.0, 0.0, 10.0, 10.0);
        this.VALUE_FOREGROUND_START = new Point2D.Double(0.0, 0.0);
        this.VALUE_FOREGROUND_STOP = new Point2D.Double(0.0, 0.0);
        this.VALUE_FOREGROUND_FRACTIONS = new float[]{0.0f, 1.0f};
        this.VALUE_FOREGROUND_COLORS = new Color[]{new Color(1.0f, 1.0f, 1.0f, 0.7f), new Color(1.0f, 1.0f, 1.0f, 0.05f)};
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    public Linear(Model model) {
        this.setModel(model);
        this.VALUE_BACKGROUND_TRACK = new Rectangle2D.Double(0.0, 0.0, 10.0, 10.0);
        this.VALUE_BACKGROUND_START = new Point2D.Double(0.0, 0.0);
        this.VALUE_BACKGROUND_STOP = new Point2D.Double(0.0, 0.0);
        this.VALUE_BACKGROUND_TRACK_FRACTIONS = new float[]{0.0f, 0.48f, 0.49f, 1.0f};
        this.VALUE_LEFT_BORDER = new Rectangle2D.Double(0.0, 0.0, 10.0, 10.0);
        this.VALUE_RIGHT_BORDER = new Rectangle2D.Double(0.0, 0.0, 10.0, 10.0);
        this.VALUE_BORDER_START = new Point2D.Double(0.0, 0.0);
        this.VALUE_BORDER_STOP = new Point2D.Double(0.0, 0.0);
        this.VALUE_BORDER_FRACTIONS = new float[]{0.0f, 0.48f, 0.49f, 1.0f};
        this.VALUE_BACKGROUND = new Rectangle2D.Double(0.0, 0.0, 10.0, 10.0);
        this.VALUE_START = new Point2D.Double(0.0, 0.0);
        this.VALUE_STOP = new Point2D.Double(0.0, 0.0);
        this.VALUE_FOREGROUND = new Rectangle2D.Double(0.0, 0.0, 10.0, 10.0);
        this.VALUE_FOREGROUND_START = new Point2D.Double(0.0, 0.0);
        this.VALUE_FOREGROUND_STOP = new Point2D.Double(0.0, 0.0);
        this.VALUE_FOREGROUND_FRACTIONS = new float[]{0.0f, 1.0f};
        this.VALUE_FOREGROUND_COLORS = new Color[]{new Color(1.0f, 1.0f, 1.0f, 0.7f), new Color(1.0f, 1.0f, 1.0f, 0.05f)};
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public final AbstractGauge init(int n, int n2) {
        if (n <= 1 || n2 <= 1) {
            return this;
        }
        if (this.bImage != null) {
            this.bImage.flush();
        }
        this.bImage = UTIL.createImage(n, n2, 3);
        if (this.fImage != null) {
            this.fImage.flush();
        }
        this.fImage = UTIL.createImage(n, n2, 3);
        if (this.isLcdVisible()) {
            float f = this.getOrientation() == Orientation.HORIZONTAL ? (float)n2 * 0.15f : (float)n2 * 0.055f;
            if (this.isDigitalFont()) {
                this.setLcdValueFont(LCD_DIGITAL_FONT.deriveFont(0.7f * f));
            } else {
                this.setLcdValueFont(LCD_STANDARD_FONT.deriveFont(0.625f * f));
            }
            if (this.isCustomLcdUnitFontEnabled()) {
                this.setLcdUnitFont(this.getCustomLcdUnitFont().deriveFont(0.25f * f));
            } else {
                this.setLcdUnitFont(LCD_STANDARD_FONT.deriveFont(0.25f * f));
            }
            this.setLcdInfoFont(this.getModel().getStandardInfoFont().deriveFont(0.15f * f));
        }
        if (this.isFrameVisible()) {
            this.create_FRAME_Image(n, n2, this.bImage);
        }
        if (this.isBackgroundVisible()) {
            this.create_BACKGROUND_Image(n, n2, this.bImage);
        }
        if (this.isGlowVisible()) {
            if (this.glowImageOff != null) {
                this.glowImageOff.flush();
            }
            this.glowImageOff = this.create_GLOW_Image(n, n2, this.getGlowColor(), false);
            if (this.glowImageOn != null) {
                this.glowImageOn.flush();
            }
            this.glowImageOn = this.create_GLOW_Image(n, n2, this.getGlowColor(), true);
        } else {
            this.setGlowPulsating(false);
        }
        if (this.isTrackVisible()) {
            this.create_TRACK_Image(n, n2, this.getMinValue(), this.getMaxValue(), this.getTrackStart(), this.getTrackSection(), this.getTrackStop(), this.getTrackStartColor(), this.getTrackSectionColor(), this.getTrackStopColor(), this.bImage);
        }
        TICKMARK_FACTORY.create_LINEAR_TICKMARKS_Image(n, n2, this.getModel().getNiceMinValue(), this.getModel().getNiceMaxValue(), this.getModel().getMaxNoOfMinorTicks(), this.getModel().getMaxNoOfMajorTicks(), this.getModel().getMinorTickSpacing(), this.getModel().getMajorTickSpacing(), this.getMinorTickmarkType(), this.getMajorTickmarkType(), this.isTickmarksVisible(), this.isTicklabelsVisible(), this.getModel().isMinorTickmarksVisible(), this.getModel().isMajorTickmarksVisible(), this.getLabelNumberFormat(), this.isTickmarkSectionsVisible(), this.getBackgroundColor(), this.getTickmarkColor(), this.isTickmarkColorFromThemeEnabled(), this.getTickmarkSections(), new Point2D.Double(0.0, 0.0), this.getOrientation(), this.getModel().isNiceScale(), this.getModel().isLogScale(), this.bImage);
        if (this.isTitleVisible()) {
            this.create_TITLE_Image(n, n2, this.getModel().isUnitVisible(), this.bImage);
        }
        if (this.isLcdVisible()) {
            switch (this.getOrientation()) {
                case HORIZONTAL: {
                    this.create_LCD_Image(new Rectangle2D.Double((double)n * 0.695, (double)n2 * 0.22, (double)n * 0.18, (double)n2 * 0.15), this.getLcdColor(), this.getCustomLcdBackground(), this.bImage);
                    this.LCD.setRect((double)n * 0.695, (double)n2 * 0.22, (double)n * 0.18, (double)n2 * 0.15);
                    break;
                }
                case VERTICAL: {
                    this.create_LCD_Image(new Rectangle2D.Double(((double)n - (double)n * 0.5714285714) / 2.0, (double)n2 * 0.875, (double)n * 0.5714285714, (double)n2 * 0.055), this.getLcdColor(), this.getCustomLcdBackground(), this.bImage);
                    this.LCD.setRect(((double)n - (double)n * 0.5714285714) / 2.0, (double)n2 * 0.875, (double)n * 0.5714285714, (double)n2 * 0.055);
                }
            }
            if (this.lcdThresholdImage != null) {
                this.lcdThresholdImage.flush();
            }
            this.lcdThresholdImage = this.create_LCD_THRESHOLD_Image((int)(this.LCD.getHeight() * 0.2045454545), (int)(this.LCD.getHeight() * 0.2045454545), this.getLcdColor().TEXT_COLOR);
        }
        if (this.thresholdImage != null) {
            this.thresholdImage.flush();
        }
        this.thresholdImage = this.create_THRESHOLD_Image(n, n2);
        if (this.minMeasuredImage != null) {
            this.minMeasuredImage.flush();
        }
        this.minMeasuredImage = this.create_MEASURED_VALUE_Image(n, n2, new Color(0, 23, 252, 255));
        if (this.maxMeasuredImage != null) {
            this.maxMeasuredImage.flush();
        }
        this.maxMeasuredImage = this.create_MEASURED_VALUE_Image(n, n2, new Color(252, 29, 0, 255));
        if (this.isForegroundVisible()) {
            FOREGROUND_FACTORY.createLinearForeground(n, n2, false, this.fImage);
        }
        if (this.disabledImage != null) {
            this.disabledImage.flush();
        }
        this.disabledImage = this.create_DISABLED_Image(n, n2);
        this.setCurrentLedImage(this.getLedImageOff());
        return this;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        double d;
        AffineTransform affineTransform;
        double d2;
        if (!this.isInitialized()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (!this.isFrameVisible()) {
            graphics2D.translate(this.getInnerBounds().x - 17, this.getInnerBounds().y - 17);
        } else {
            graphics2D.translate(this.getInnerBounds().x, this.getInnerBounds().y);
        }
        graphics2D.drawImage((Image)this.bImage, 0, 0, null);
        if (this.getInnerBounds().width < this.getInnerBounds().height) {
            double d3 = (double)this.getInnerBounds().height * 0.8567961165048543 - (double)this.getInnerBounds().height * 0.12864077669902912;
            double d4 = this.getMaxValue() - this.getMinValue();
            d2 = d3 / d4;
        } else {
            double d5 = (double)this.getInnerBounds().width * 0.8567961165048543 - (double)this.getInnerBounds().width * 0.12864077669902912;
            double d6 = this.getMaxValue() - this.getMinValue();
            d2 = d5 / d6;
        }
        if (this.isThresholdVisible()) {
            affineTransform = graphics2D.getTransform();
            if (this.getInnerBounds().width < this.getInnerBounds().height) {
                d = this.getMinValue() < 0.0 ? (double)this.getInnerBounds().height * 0.8567961165048543 + this.getMinValue() * d2 - this.getThreshold() * d2 : (double)this.getInnerBounds().height * 0.8567961165048543 - this.getMinValue() * d2 - this.getThreshold() * d2;
                graphics2D.translate((double)this.getInnerBounds().width * 0.4357142857142857 - (double)this.thresholdImage.getWidth() - 2.0 + (double)this.getInnerBounds().x, d - (double)this.thresholdImage.getHeight() / 2.0 + (double)this.getInnerBounds().y);
            } else {
                d = this.getThreshold() * d2 - this.getMinValue() * d2;
                graphics2D.translate((double)this.getInnerBounds().width * 0.14285714285714285 - (double)this.thresholdImage.getWidth() / 2.0 + d + (double)this.getInnerBounds().x, (double)this.getInnerBounds().height * 0.5714285714 + 2.0 + (double)this.getInnerBounds().y);
            }
            graphics2D.drawImage((Image)this.thresholdImage, 0, 0, null);
            graphics2D.setTransform(affineTransform);
        }
        if (this.isMinMeasuredValueVisible()) {
            affineTransform = graphics2D.getTransform();
            if (this.getInnerBounds().width < this.getInnerBounds().height) {
                d = this.getMinValue() < 0.0 ? (double)this.getInnerBounds().height * 0.8567961165048543 + this.getMinValue() * d2 - this.getMinMeasuredValue() * d2 : (double)this.getInnerBounds().height * 0.8567961165048543 - this.getMinValue() * d2 - this.getMinMeasuredValue() * d2;
                graphics2D.translate((double)this.getInnerBounds().width * 0.37 - (double)this.minMeasuredImage.getWidth() - 2.0 + (double)this.getInnerBounds().x, d - (double)this.minMeasuredImage.getHeight() / 2.0 + (double)this.getInnerBounds().y);
            } else {
                d = this.getMinMeasuredValue() * d2 - this.getMinValue() * d2;
                graphics2D.translate((double)this.getInnerBounds().width * 0.14285714285714285 - (double)this.minMeasuredImage.getWidth() / 2.0 + d + (double)this.getInnerBounds().x, (double)this.getInnerBounds().height * 0.63 + 2.0 + (double)this.getInnerBounds().y);
            }
            graphics2D.drawImage((Image)this.minMeasuredImage, 0, 0, null);
            graphics2D.setTransform(affineTransform);
        }
        if (this.isMaxMeasuredValueVisible()) {
            affineTransform = graphics2D.getTransform();
            if (this.getInnerBounds().width < this.getInnerBounds().height) {
                d = this.getMinValue() < 0.0 ? (double)this.getInnerBounds().height * 0.8567961165048543 + this.getMinValue() * d2 - this.getMaxMeasuredValue() * d2 : (double)this.getInnerBounds().height * 0.8567961165048543 - this.getMinValue() * d2 - this.getMaxMeasuredValue() * d2;
                graphics2D.translate((double)this.getInnerBounds().width * 0.37 - (double)this.maxMeasuredImage.getWidth() - 2.0 + (double)this.getInnerBounds().x, d - (double)this.maxMeasuredImage.getHeight() / 2.0 + (double)this.getInnerBounds().y);
            } else {
                d = this.getMaxMeasuredValue() * d2 - this.getMinValue() * d2;
                graphics2D.translate((double)this.getInnerBounds().width * 0.14285714285714285 - (double)this.maxMeasuredImage.getWidth() / 2.0 + d + (double)this.getInnerBounds().x, (double)this.getInnerBounds().height * 0.63 + 2.0 + (double)this.getInnerBounds().y);
            }
            graphics2D.drawImage((Image)this.maxMeasuredImage, 0, 0, null);
            graphics2D.setTransform(affineTransform);
        }
        if (this.isLedVisible()) {
            graphics2D.drawImage((Image)this.getCurrentLedImage(), (int)((double)this.getInnerBounds().width * this.getLedPosition().getX()), (int)((double)this.getInnerBounds().height * this.getLedPosition().getY()), null);
        }
        if (this.isUserLedVisible()) {
            graphics2D.drawImage((Image)this.getCurrentUserLedImage(), (int)((double)this.getInnerBounds().width * this.getUserLedPosition().getX()), (int)((double)this.getInnerBounds().height * this.getUserLedPosition().getY()), null);
        }
        if (this.isLcdVisible()) {
            if (this.getLcdColor() == LcdColor.CUSTOM) {
                graphics2D.setColor(this.getCustomLcdForeground());
            } else {
                graphics2D.setColor(this.getLcdColor().TEXT_COLOR);
            }
            graphics2D.setFont(this.getLcdUnitFont());
            if (this.isLcdUnitStringVisible()) {
                this.unitLayout = new TextLayout(this.getLcdUnitString(), graphics2D.getFont(), this.RENDER_CONTEXT);
                this.UNIT_BOUNDARY.setFrame(this.unitLayout.getBounds());
                graphics2D.drawString(this.getLcdUnitString(), (float)(this.LCD.getX() + (this.LCD.getWidth() - this.UNIT_BOUNDARY.getWidth()) - this.LCD.getWidth() * 0.03), (float)(this.LCD.getY() + this.LCD.getHeight() * 0.76));
                this.unitStringWidth = this.UNIT_BOUNDARY.getWidth();
            } else {
                this.unitStringWidth = 0.0;
            }
            graphics2D.setFont(this.getLcdValueFont());
            switch (this.getModel().getNumberSystem()) {
                case HEX: {
                    this.valueLayout = new TextLayout(Integer.toHexString((int)this.getLcdValue()).toUpperCase(), graphics2D.getFont(), this.RENDER_CONTEXT);
                    this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                    graphics2D.drawString(Integer.toHexString((int)this.getLcdValue()).toUpperCase(), (float)(this.LCD.getX() + (this.LCD.getWidth() - this.unitStringWidth - this.VALUE_BOUNDARY.getWidth()) - this.LCD.getWidth() * 0.09), (float)(this.LCD.getY() + this.LCD.getHeight() * 0.76));
                    break;
                }
                case OCT: {
                    this.valueLayout = new TextLayout(Integer.toOctalString((int)this.getLcdValue()), graphics2D.getFont(), this.RENDER_CONTEXT);
                    this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                    graphics2D.drawString(Integer.toOctalString((int)this.getLcdValue()), (float)(this.LCD.getX() + (this.LCD.getWidth() - this.unitStringWidth - this.VALUE_BOUNDARY.getWidth()) - this.LCD.getWidth() * 0.09), (float)(this.LCD.getY() + this.LCD.getHeight() * 0.76));
                    break;
                }
                default: {
                    this.valueLayout = new TextLayout(this.formatLcdValue(this.getLcdValue()), graphics2D.getFont(), this.RENDER_CONTEXT);
                    this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                    graphics2D.drawString(this.formatLcdValue(this.getLcdValue()), (float)(this.LCD.getX() + (this.LCD.getWidth() - this.unitStringWidth - this.VALUE_BOUNDARY.getWidth()) - this.LCD.getWidth() * 0.09), (float)(this.LCD.getY() + this.LCD.getHeight() * 0.76));
                }
            }
            if (!this.getLcdInfoString().isEmpty()) {
                graphics2D.setFont(this.getLcdInfoFont());
                this.infoLayout = new TextLayout(this.getLcdInfoString(), graphics2D.getFont(), this.RENDER_CONTEXT);
                this.INFO_BOUNDARY.setFrame(this.infoLayout.getBounds());
                graphics2D.drawString(this.getLcdInfoString(), (float)this.LCD.getBounds().x + 5.0f, (float)this.LCD.getBounds().y + (float)this.INFO_BOUNDARY.getHeight() + 5.0f);
            }
            if (this.getLcdNumberSystem() == NumberSystem.DEC && this.isLcdThresholdVisible() && this.getLcdValue() >= this.getLcdThreshold()) {
                graphics2D.drawImage((Image)this.lcdThresholdImage, (int)(this.LCD.getX() + this.LCD.getHeight() * 0.0568181818), (int)(this.LCD.getY() + this.LCD.getHeight() - (double)this.lcdThresholdImage.getHeight() - this.LCD.getHeight() * 0.0568181818), null);
            }
        }
        this.drawValue(graphics2D, this.getInnerBounds().width, this.getInnerBounds().height, d2);
        if (this.isForegroundVisible()) {
            graphics2D.drawImage((Image)this.fImage, 0, 0, null);
        }
        if (this.isGlowVisible()) {
            if (this.isGlowing()) {
                graphics2D.setComposite(AlphaComposite.getInstance(3, this.getGlowAlpha()));
                graphics2D.drawImage((Image)this.glowImageOn, 0, 0, null);
                graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
            } else {
                graphics2D.drawImage((Image)this.glowImageOff, 0, 0, null);
            }
        }
        if (!this.isEnabled()) {
            graphics2D.drawImage((Image)this.disabledImage, 0, 0, null);
        }
        graphics2D.dispose();
    }

    private void drawValue(Graphics2D graphics2D, int n, int n2, double d) {
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        boolean bl;
        boolean bl2 = bl = n < n2;
        if (bl) {
            d7 = (double)n2 * 0.12864077669902912;
            d6 = (double)n2 * 0.8567961165048543;
            d5 = d6 - d7;
            if (this.isStartingFromZero()) {
                d4 = d5 * Math.abs(this.getValue()) / (this.getMaxValue() - this.getMinValue());
                d3 = this.getValue() < 0.0 ? -this.getMinValue() * d + d6 + this.getValue() * d : -this.getMinValue() * d + d6;
            } else if (this.isLogScale()) {
                d2 = Math.abs(d7 - d6) / UTIL.logOfBase(10.0, this.getMaxValue());
                d4 = d2 * UTIL.logOfBase(10.0, this.getValue());
                d3 = d7 + d5 - d4;
            } else {
                d4 = d5 * (this.getValue() - this.getMinValue()) / (this.getMaxValue() - this.getMinValue());
                d3 = d7 + d5 - d4;
            }
            this.VALUE_BACKGROUND_TRACK.setRect((double)n * 0.4357142857142857, d7, (double)n * 0.14285714285714285, d5);
            this.VALUE_BACKGROUND_START.setLocation(0.0, this.VALUE_BACKGROUND_TRACK.getBounds2D().getMinY());
            this.VALUE_BACKGROUND_STOP.setLocation(0.0, this.VALUE_BACKGROUND_TRACK.getBounds2D().getMaxY());
        } else {
            d7 = (double)n * 0.8567961165048543;
            d6 = (double)n * 0.14285714285714285;
            d5 = d7 - (double)n * 0.12864077669902912;
            if (this.isStartingFromZero()) {
                d4 = d5 * Math.abs(this.getValue()) / (this.getMaxValue() - this.getMinValue());
                d3 = this.getValue() < 0.0 ? -this.getMinValue() * d + d6 + this.getValue() * d : -this.getMinValue() * d + d6;
            } else if (this.isLogScale()) {
                d2 = d5 / UTIL.logOfBase(10.0, this.getMaxValue());
                d4 = d2 * UTIL.logOfBase(10.0, this.getValue());
                d3 = d6;
            } else {
                d4 = d5 * (this.getValue() - this.getMinValue()) / (this.getMaxValue() - this.getMinValue());
                d3 = d6;
            }
            this.VALUE_BACKGROUND_TRACK.setRect((double)n * 0.14285714285714285, (double)n2 * 0.4357142857142857, d5, (double)n2 * 0.14285714285714285);
            this.VALUE_BACKGROUND_START.setLocation(d7, 0.0);
            this.VALUE_BACKGROUND_STOP.setLocation(d6, 0.0);
        }
        Color[] colorArray = new Color[]{UTIL.setAlpha(this.getBackgroundColor().LABEL_COLOR, 0.047058824f), UTIL.setAlpha(this.getBackgroundColor().LABEL_COLOR, 0.14509805f), UTIL.setAlpha(this.getBackgroundColor().LABEL_COLOR, 0.14901961f), UTIL.setAlpha(this.getBackgroundColor().LABEL_COLOR, 0.047058824f)};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(this.VALUE_BACKGROUND_START, this.VALUE_BACKGROUND_STOP, this.VALUE_BACKGROUND_TRACK_FRACTIONS, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(this.VALUE_BACKGROUND_TRACK);
        if (bl) {
            this.VALUE_LEFT_BORDER.setRect((double)n * 0.4357142857142857, d7, (double)n * 0.007142857142857143, d5);
            this.VALUE_RIGHT_BORDER.setRect((double)n * 0.5714285714285714, d7, (double)n * 0.007142857142857143, d5);
            this.VALUE_BORDER_START.setLocation(0.0, this.VALUE_LEFT_BORDER.getBounds2D().getMinY());
            this.VALUE_BORDER_STOP.setLocation(0.0, this.VALUE_LEFT_BORDER.getBounds2D().getMaxY());
        } else {
            this.VALUE_LEFT_BORDER.setRect((double)n * 0.14285714285714285, (double)n2 * 0.4357142857, d5, (double)n2 * 0.007142857142857143);
            this.VALUE_RIGHT_BORDER.setRect((double)n * 0.14285714285714285, (double)n2 * 0.5714285714, d5, (double)n2 * 0.007142857142857143);
            this.VALUE_BORDER_START.setLocation(this.VALUE_LEFT_BORDER.getBounds2D().getMaxX(), 0.0);
            this.VALUE_BORDER_STOP.setLocation(this.VALUE_LEFT_BORDER.getBounds2D().getMinX(), 0.0);
        }
        Color[] colorArray2 = new Color[]{UTIL.setAlpha(this.getBackgroundColor().LABEL_COLOR, 0.29803923f), UTIL.setAlpha(this.getBackgroundColor().LABEL_COLOR, 0.6862745f), UTIL.setAlpha(this.getBackgroundColor().LABEL_COLOR, 0.69803923f), UTIL.setAlpha(this.getBackgroundColor().LABEL_COLOR, 0.4f)};
        LinearGradientPaint linearGradientPaint2 = new LinearGradientPaint(this.VALUE_BORDER_START, this.VALUE_BORDER_STOP, this.VALUE_BORDER_FRACTIONS, colorArray2);
        graphics2D.setPaint(linearGradientPaint2);
        graphics2D.fill(this.VALUE_LEFT_BORDER);
        graphics2D.fill(this.VALUE_RIGHT_BORDER);
        if (bl) {
            this.VALUE_BACKGROUND.setRect((double)n * 0.45, d3, (double)n * 0.1142857143, d4);
            this.VALUE_START.setLocation(this.VALUE_BACKGROUND.getBounds2D().getMinX(), 0.0);
            this.VALUE_STOP.setLocation(this.VALUE_BACKGROUND.getBounds2D().getMaxX(), 0.0);
        } else {
            this.VALUE_BACKGROUND.setRect(d3, (double)n2 * 0.45, d4, (double)n2 * 0.1142857143);
            this.VALUE_START.setLocation(0.0, this.VALUE_BACKGROUND.getBounds2D().getMinY());
            this.VALUE_STOP.setLocation(0.0, this.VALUE_BACKGROUND.getBounds2D().getMaxY());
        }
        float[] fArray = new float[]{0.0f, 0.99f, 1.0f};
        Color[] colorArray3 = this.getValueColor() != ColorDef.CUSTOM ? new Color[]{this.getValueColor().MEDIUM, this.getValueColor().LIGHT, this.getValueColor().LIGHT} : new Color[]{this.getCustomValueColorObject().MEDIUM, this.getCustomValueColorObject().LIGHT, this.getCustomValueColorObject().LIGHT};
        if (this.isSectionsVisible()) {
            for (Section object2 : this.getSections()) {
                if (Double.compare(this.getValue(), object2.getStart()) < 0 || Double.compare(this.getValue(), object2.getStop()) > 0) continue;
                colorArray3 = new Color[]{this.isTransparentSectionsEnabled() ? object2.getTransparentColor() : object2.getColor(), this.isTransparentSectionsEnabled() ? object2.getTransparentColor() : object2.getColor(), this.isTransparentSectionsEnabled() ? object2.getTransparentColor() : object2.getColor()};
                graphics2D.setColor(object2.getColor());
                break;
            }
        }
        LinearGradientPaint linearGradientPaint3 = new LinearGradientPaint(this.VALUE_START, this.VALUE_STOP, fArray, colorArray3);
        graphics2D.setPaint(linearGradientPaint3);
        graphics2D.fill(this.VALUE_BACKGROUND);
        if (bl) {
            this.VALUE_FOREGROUND.setRect((double)n * 0.45, d3, (double)n * 0.05, d4);
            this.VALUE_FOREGROUND_START.setLocation(this.VALUE_FOREGROUND.getBounds2D().getMinX(), 0.0);
            this.VALUE_FOREGROUND_STOP.setLocation(this.VALUE_FOREGROUND.getBounds2D().getMaxX(), 0.0);
        } else {
            this.VALUE_FOREGROUND.setRect(d3, (double)n2 * 0.45, d4, (double)n2 * 0.05);
            this.VALUE_FOREGROUND_START.setLocation(0.0, this.VALUE_FOREGROUND.getBounds2D().getMinY());
            this.VALUE_FOREGROUND_STOP.setLocation(0.0, this.VALUE_FOREGROUND.getBounds2D().getMaxY());
        }
        LinearGradientPaint linearGradientPaint4 = new LinearGradientPaint(this.VALUE_FOREGROUND_START, this.VALUE_FOREGROUND_STOP, this.VALUE_FOREGROUND_FRACTIONS, this.VALUE_FOREGROUND_COLORS);
        graphics2D.setPaint(linearGradientPaint4);
        if (this.VALUE_FOREGROUND.getWidth() > 0.0 && this.VALUE_FOREGROUND.getHeight() > 0.0) {
            graphics2D.fill(this.VALUE_FOREGROUND);
        }
    }

    @Override
    public void setValue(double d) {
        if (this.isValueCoupled()) {
            this.setLcdValue(d);
        }
        super.setValue(d);
    }

    public boolean isTitleVisible() {
        return this.getModel().isTitleVisible();
    }

    public void setTitleVisible(boolean bl) {
        this.getModel().setTitleVisible(bl);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public boolean isTickmarksVisible() {
        return this.getModel().isTickmarksVisible();
    }

    @Override
    public void setTickmarksVisible(boolean bl) {
        this.getModel().setTickmarksVisible(bl);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public boolean isUnitStringVisible() {
        return this.getModel().isUnitVisible();
    }

    public void setUnitStringVisible(boolean bl) {
        this.getModel().setUnitVisible(bl);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Paint createCustomLcdBackgroundPaint(Color[] colorArray) {
        Point2D.Double double_;
        Point2D.Double double_2 = new Point2D.Double(0.0, this.LCD.getMinY() + 1.0);
        if (double_2.equals(double_ = new Point2D.Double(0.0, this.LCD.getMaxY() - 1.0))) {
            ((Point2D)double_).setLocation(0.0, ((Point2D)double_2).getY() + 1.0);
        }
        float[] fArray = new float[]{0.0f, 0.03f, 0.49f, 0.5f, 1.0f};
        Color[] colorArray2 = new Color[]{colorArray[0], colorArray[1], colorArray[2], colorArray[3], colorArray[4]};
        return new LinearGradientPaint(double_2, double_, fArray, colorArray2);
    }

    @Override
    protected Point2D getCenter() {
        return new Point2D.Double((double)this.bImage.getWidth() / 2.0 + (double)this.getInnerBounds().x, (double)this.bImage.getHeight() / 2.0 + (double)this.getInnerBounds().y);
    }

    @Override
    protected Rectangle2D getBounds2D() {
        return new Rectangle2D.Double(this.bImage.getMinX(), this.bImage.getMinY(), this.bImage.getWidth(), this.bImage.getHeight());
    }

    @Override
    public Rectangle getLcdBounds() {
        return this.LCD.getBounds();
    }

    @Override
    public String toString() {
        return "Linear";
    }
}

