/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.gauges;

import eu.hansolo.steelseries.gauges.AbstractGauge;
import eu.hansolo.steelseries.gauges.AbstractRadial;
import eu.hansolo.steelseries.tools.GaugeType;
import eu.hansolo.steelseries.tools.LcdColor;
import eu.hansolo.steelseries.tools.Model;
import eu.hansolo.steelseries.tools.NumberSystem;
import eu.hansolo.steelseries.tools.Orientation;
import eu.hansolo.steelseries.tools.PostPosition;
import eu.hansolo.steelseries.tools.Section;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class Radial
extends AbstractRadial {
    private static final int BASE = 10;
    private BufferedImage bImage;
    private BufferedImage fImage;
    private BufferedImage glowImageOff;
    private BufferedImage glowImageOn;
    private BufferedImage pointerImage;
    private BufferedImage pointerShadowImage;
    private BufferedImage thresholdImage;
    private BufferedImage minMeasuredImage;
    private BufferedImage maxMeasuredImage;
    private BufferedImage lcdThresholdImage;
    private BufferedImage disabledImage;
    private double angle;
    private final Point2D CENTER = new Point2D.Double();
    private final Rectangle2D LCD = new Rectangle2D.Double();
    private boolean section3DEffectVisible;
    private RadialGradientPaint section3DEffect;
    private boolean area3DEffectVisible;
    private RadialGradientPaint area3DEffect;
    private final Point2D TRACK_OFFSET = new Point2D.Double();
    private final FontRenderContext RENDER_CONTEXT = new FontRenderContext(null, true, true);
    private TextLayout unitLayout;
    private final Rectangle2D UNIT_BOUNDARY = new Rectangle2D.Double();
    private double unitStringWidth;
    private TextLayout valueLayout;
    private final Rectangle2D VALUE_BOUNDARY = new Rectangle2D.Double();
    private TextLayout infoLayout;
    private final Rectangle2D INFO_BOUNDARY = new Rectangle2D.Double();
    private Area areaOfMeasuredValues;
    private Area lcdArea;

    public Radial() {
        this.angle = 0.0;
        this.section3DEffectVisible = false;
        this.area3DEffectVisible = false;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    public Radial(Model model) {
        this.setModel(model);
        this.angle = 0.0;
        this.section3DEffectVisible = false;
        this.area3DEffectVisible = false;
        this.areaOfMeasuredValues = new Area();
        this.lcdArea = new Area();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public final AbstractGauge init(int n, int n2) {
        int n3;
        int n4 = this.isFrameVisible() ? n : this.getGaugeBounds().width;
        int n5 = n3 = this.isFrameVisible() ? n2 : this.getGaugeBounds().height;
        if (n4 <= 1 || n3 <= 1) {
            return this;
        }
        if (!this.isFrameVisible()) {
            this.setFramelessOffset((double)(-this.getGaugeBounds().width) * 0.0841121495, (double)(-this.getGaugeBounds().width) * 0.0841121495);
        } else {
            this.setFramelessOffset(this.getGaugeBounds().x, this.getGaugeBounds().y);
        }
        this.CENTER.setLocation(this.getGaugeBounds().getCenterX() - (double)this.getInsets().left, this.getGaugeBounds().getCenterX() - (double)this.getInsets().top);
        if (this.isLcdVisible()) {
            if (this.isDigitalFont()) {
                this.setLcdValueFont(this.getModel().getDigitalBaseFont().deriveFont(0.7f * (float)n4 * 0.15f));
            } else {
                this.setLcdValueFont(this.getModel().getStandardBaseFont().deriveFont(0.625f * (float)n4 * 0.15f));
            }
            if (this.isCustomLcdUnitFontEnabled()) {
                this.setLcdUnitFont(this.getCustomLcdUnitFont().deriveFont(0.25f * (float)n4 * 0.15f));
            } else {
                this.setLcdUnitFont(this.getModel().getStandardBaseFont().deriveFont(0.25f * (float)n4 * 0.15f));
            }
            this.setLcdInfoFont(this.getModel().getStandardInfoFont().deriveFont(0.15f * (float)n4 * 0.15f));
        }
        if (this.bImage != null) {
            this.bImage.flush();
        }
        this.bImage = UTIL.createImage(n4, n4, 3);
        if (this.fImage != null) {
            this.fImage.flush();
        }
        this.fImage = UTIL.createImage(n4, n4, 3);
        if (this.isFrameVisible()) {
            switch (this.getFrameType()) {
                case ROUND: {
                    FRAME_FACTORY.createRadialFrame(n4, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameBaseColor(), this.isFrameBaseColorEnabled(), this.getFrameEffect(), this.bImage);
                    break;
                }
                case SQUARE: {
                    FRAME_FACTORY.createLinearFrame(n4, n4, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameBaseColor(), this.isFrameBaseColorEnabled(), this.getFrameEffect(), this.bImage);
                    break;
                }
                default: {
                    FRAME_FACTORY.createRadialFrame(n4, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameBaseColor(), this.isFrameBaseColorEnabled(), this.getFrameEffect(), this.bImage);
                }
            }
        }
        if (this.isBackgroundVisible()) {
            this.create_BACKGROUND_Image(n4, "", "", this.bImage);
        }
        if (this.isGlowVisible()) {
            if (this.glowImageOff != null) {
                this.glowImageOff.flush();
            }
            this.glowImageOff = this.create_GLOW_Image(n4, this.getGlowColor(), false, this.getGaugeType(), true, this.getOrientation());
            if (this.glowImageOn != null) {
                this.glowImageOn.flush();
            }
            this.glowImageOn = this.create_GLOW_Image(n4, this.getGlowColor(), true, this.getGaugeType(), true, this.getOrientation());
        } else {
            this.setGlowPulsating(false);
        }
        if (this.getPostsVisible()) {
            this.create_POSTS_Image(n4, this.fImage, this.getGaugeType().POST_POSITIONS);
        } else {
            this.create_POSTS_Image(n4, this.fImage, PostPosition.CENTER);
        }
        this.TRACK_OFFSET.setLocation(0.0, 0.0);
        if (this.isTrackVisible()) {
            this.create_TRACK_Image(n4, this.getFreeAreaAngle(), this.getTickmarkOffset(), this.getMinValue(), this.getMaxValue(), this.getAngleStep(), this.getTrackStart(), this.getTrackSection(), this.getTrackStop(), this.getTrackStartColor(), this.getTrackSectionColor(), this.getTrackStopColor(), 0.38f, this.CENTER, this.getTickmarkDirection(), this.TRACK_OFFSET, this.bImage);
        }
        if (!this.getAreas().isEmpty()) {
            if (this.area3DEffectVisible) {
                this.area3DEffect = this.createArea3DEffectGradient(n4, 0.38f);
            }
            this.createAreas(this.bImage);
        }
        if (!this.getSections().isEmpty()) {
            if (this.section3DEffectVisible) {
                this.section3DEffect = this.createSection3DEffectGradient(n4, 0.38f);
            }
            this.createSections(this.bImage);
        }
        TICKMARK_FACTORY.create_RADIAL_TICKMARKS_Image(n4, this.getModel().getNiceMinValue(), this.getModel().getNiceMaxValue(), this.getModel().getMaxNoOfMinorTicks(), this.getModel().getMaxNoOfMajorTicks(), this.getModel().getMinorTickSpacing(), this.getModel().getMajorTickSpacing(), this.getGaugeType(), this.getMinorTickmarkType(), this.getMajorTickmarkType(), this.isTickmarksVisible(), this.isTicklabelsVisible(), this.getModel().isMinorTickmarksVisible(), this.getModel().isMajorTickmarksVisible(), this.getLabelNumberFormat(), this.isTickmarkSectionsVisible(), this.getBackgroundColor(), this.getTickmarkColor(), this.isTickmarkColorFromThemeEnabled(), this.getTickmarkSections(), 0.38f, 0.09f, this.CENTER, new Point2D.Double(0.0, 0.0), Orientation.NORTH, this.getModel().getTicklabelOrientation(), this.getModel().isNiceScale(), this.getModel().isLogScale(), this.bImage);
        this.create_TITLE_Image(n4, this.getTitle(), this.getUnitString(), this.bImage);
        if (this.isLcdVisible()) {
            this.create_LCD_Image(new Rectangle2D.Double(((double)this.getGaugeBounds().width - (double)n4 * this.getGaugeType().LCD_FACTORS.getX()) / 2.0, (double)this.getGaugeBounds().height * this.getGaugeType().LCD_FACTORS.getY(), (double)n4 * this.getGaugeType().LCD_FACTORS.getWidth(), (double)n4 * this.getGaugeType().LCD_FACTORS.getHeight()), this.getLcdColor(), this.getCustomLcdBackground(), this.bImage);
            this.LCD.setRect(((double)this.getGaugeBounds().width - (double)n4 * this.getGaugeType().LCD_FACTORS.getX()) / 2.0, (double)this.getGaugeBounds().height * this.getGaugeType().LCD_FACTORS.getY(), (double)n4 * this.getGaugeType().LCD_FACTORS.getWidth(), (double)n4 * this.getGaugeType().LCD_FACTORS.getHeight());
            this.lcdArea = new Area(this.LCD);
            if (this.lcdThresholdImage != null) {
                this.lcdThresholdImage.flush();
            }
            this.lcdThresholdImage = this.create_LCD_THRESHOLD_Image((int)(this.LCD.getHeight() * 0.2045454545), (int)(this.LCD.getHeight() * 0.2045454545), this.getLcdColor().TEXT_COLOR);
        }
        if (this.pointerImage != null) {
            this.pointerImage.flush();
        }
        this.pointerImage = this.create_POINTER_Image(n4, this.getPointerType());
        if (this.pointerShadowImage != null) {
            this.pointerShadowImage.flush();
        }
        this.pointerShadowImage = this.getModel().isPointerShadowVisible() ? this.create_POINTER_SHADOW_Image(n4, this.getPointerType()) : null;
        if (this.thresholdImage != null) {
            this.thresholdImage.flush();
        }
        this.thresholdImage = this.create_THRESHOLD_Image(n4);
        if (this.minMeasuredImage != null) {
            this.minMeasuredImage.flush();
        }
        this.minMeasuredImage = this.create_MEASURED_VALUE_Image(n4, new Color(0, 23, 252, 255));
        if (this.maxMeasuredImage != null) {
            this.maxMeasuredImage.flush();
        }
        this.maxMeasuredImage = this.create_MEASURED_VALUE_Image(n4, new Color(252, 29, 0, 255));
        if ((this.getGaugeType() == GaugeType.TYPE3 || this.getGaugeType() == GaugeType.TYPE4) && this.isLcdVisible()) {
            this.areaOfMeasuredValues = new Area(this.getModel().getRadialShapeOfMeasuredValues());
            this.areaOfMeasuredValues.subtract(this.lcdArea);
        } else {
            this.areaOfMeasuredValues = new Area(this.getModel().getRadialShapeOfMeasuredValues());
        }
        if (this.isForegroundVisible()) {
            switch (this.getFrameType()) {
                case SQUARE: {
                    FOREGROUND_FACTORY.createLinearForeground(n4, n4, false, this.fImage);
                    break;
                }
                default: {
                    FOREGROUND_FACTORY.createRadialForeground(n4, false, this.getForegroundType(), this.fImage);
                }
            }
        }
        if (this.disabledImage != null) {
            this.disabledImage.flush();
        }
        this.disabledImage = this.create_DISABLED_Image(n4);
        this.setCurrentLedImage(this.getLedImageOff());
        return this;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (!this.isInitialized()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.translate(this.getFramelessOffset().getX(), this.getFramelessOffset().getY());
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.drawImage((Image)this.bImage, 0, 0, null);
        if (this.isRangeOfMeasuredValuesVisible()) {
            graphics2D.setPaint(this.getModel().getRangeOfMeasuredValuesPaint());
            if ((this.getGaugeType() == GaugeType.TYPE3 || this.getGaugeType() == GaugeType.TYPE4) && this.isLcdVisible()) {
                Area area = this.getModel().getRadialAreaOfMeasuredValues();
                area.subtract(this.lcdArea);
                graphics2D.fill(area);
            } else {
                graphics2D.fill(this.getModel().getRadialShapeOfMeasuredValues());
            }
        }
        if (this.isHighlightArea()) {
            for (Section section : this.getAreas()) {
                if (!section.contains(this.getValue())) continue;
                graphics2D.setColor(section.getHighlightColor());
                if ((this.getGaugeType() == GaugeType.TYPE3 || this.getGaugeType() == GaugeType.TYPE4) && this.isLcdVisible()) {
                    Area area = new Area(section.getFilledArea());
                    area.subtract(this.lcdArea);
                    graphics2D.fill(area);
                    break;
                }
                graphics2D.fill(section.getFilledArea());
                break;
            }
        }
        if (this.isHighlightSection()) {
            for (Section section : this.getSections()) {
                if (!section.contains(this.getValue())) continue;
                graphics2D.setColor(section.getHighlightColor());
                graphics2D.fill(section.getSectionArea());
                break;
            }
        }
        if (this.isThresholdVisible()) {
            if (!this.isLogScale()) {
                graphics2D.rotate(this.getRotationOffset() + (this.getThreshold() - this.getMinValue()) * this.getAngleStep(), this.CENTER.getX(), this.CENTER.getY());
            } else {
                graphics2D.rotate(this.getRotationOffset() + UTIL.logOfBase(10.0, this.getThreshold() - this.getMinValue()) * this.getLogAngleStep(), this.CENTER.getX(), this.CENTER.getY());
            }
            graphics2D.drawImage((Image)this.thresholdImage, (int)((double)this.getGaugeBounds().width * 0.4813084112), (int)((double)this.getGaugeBounds().height * 0.0841121495), null);
            graphics2D.setTransform(affineTransform);
        }
        if (this.isMinMeasuredValueVisible()) {
            if (!this.isLogScale()) {
                graphics2D.rotate(this.getRotationOffset() + (this.getMinMeasuredValue() - this.getMinValue()) * this.getAngleStep(), this.CENTER.getX(), this.CENTER.getY());
            } else {
                graphics2D.rotate(this.getRotationOffset() + UTIL.logOfBase(10.0, this.getMinMeasuredValue() - this.getMinValue()) * this.getLogAngleStep(), this.CENTER.getX(), this.CENTER.getY());
            }
            graphics2D.drawImage((Image)this.minMeasuredImage, (int)((double)this.getGaugeBounds().width * 0.4865), (int)((double)this.getGaugeBounds().height * 0.105), null);
            graphics2D.setTransform(affineTransform);
        }
        if (this.isMaxMeasuredValueVisible()) {
            if (!this.isLogScale()) {
                graphics2D.rotate(this.getRotationOffset() + (this.getMaxMeasuredValue() - this.getMinValue()) * this.getAngleStep(), this.CENTER.getX(), this.CENTER.getY());
            } else {
                graphics2D.rotate(this.getRotationOffset() + UTIL.logOfBase(10.0, this.getMaxMeasuredValue() - this.getMinValue()) * this.getLogAngleStep(), this.CENTER.getX(), this.CENTER.getY());
            }
            graphics2D.drawImage((Image)this.maxMeasuredImage, (int)((double)this.getGaugeBounds().width * 0.4865), (int)((double)this.getGaugeBounds().height * 0.105), null);
            graphics2D.setTransform(affineTransform);
        }
        if (this.isLedVisible()) {
            graphics2D.drawImage((Image)this.getCurrentLedImage(), (int)((double)this.getGaugeBounds().width * this.getLedPosition().getX()), (int)((double)this.getGaugeBounds().height * this.getLedPosition().getY()), null);
        }
        if (this.isUserLedVisible()) {
            graphics2D.drawImage((Image)this.getCurrentUserLedImage(), (int)((double)this.getGaugeBounds().width * this.getUserLedPosition().getX()), (int)((double)this.getGaugeBounds().height * this.getUserLedPosition().getY()), null);
        }
        if (this.isLcdVisible()) {
            if (this.getLcdColor() == LcdColor.CUSTOM) {
                graphics2D.setColor(this.getCustomLcdForeground());
            } else {
                graphics2D.setColor(this.getLcdColor().TEXT_COLOR);
            }
            graphics2D.setFont(this.getLcdUnitFont());
            if (this.isLcdUnitStringVisible()) {
                this.unitLayout = new TextLayout(this.getLcdUnitString(), graphics2D.getFont(), this.RENDER_CONTEXT);
                this.UNIT_BOUNDARY.setFrame(this.unitLayout.getBounds());
                graphics2D.drawString(this.getLcdUnitString(), (int)(this.LCD.getX() + (this.LCD.getWidth() - this.UNIT_BOUNDARY.getWidth()) - this.LCD.getWidth() * 0.03), (int)(this.LCD.getY() + this.LCD.getHeight() * 0.76));
                this.unitStringWidth = this.UNIT_BOUNDARY.getWidth();
            } else {
                this.unitStringWidth = 0.0;
            }
            graphics2D.setFont(this.getLcdValueFont());
            switch (this.getModel().getNumberSystem()) {
                case HEX: {
                    this.valueLayout = new TextLayout(Integer.toHexString((int)this.getLcdValue()).toUpperCase(), graphics2D.getFont(), this.RENDER_CONTEXT);
                    this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                    graphics2D.drawString(Integer.toHexString((int)this.getLcdValue()).toUpperCase(), (float)(this.LCD.getX() + (this.LCD.getWidth() - this.unitStringWidth - this.VALUE_BOUNDARY.getWidth()) - this.LCD.getWidth() * 0.09), (float)(this.LCD.getY() + this.LCD.getHeight() * 0.76));
                    break;
                }
                case OCT: {
                    this.valueLayout = new TextLayout(Integer.toOctalString((int)this.getLcdValue()), graphics2D.getFont(), this.RENDER_CONTEXT);
                    this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                    graphics2D.drawString(Integer.toOctalString((int)this.getLcdValue()), (float)(this.LCD.getX() + (this.LCD.getWidth() - this.unitStringWidth - this.VALUE_BOUNDARY.getWidth()) - this.LCD.getWidth() * 0.09), (float)(this.LCD.getY() + this.LCD.getHeight() * 0.76));
                    break;
                }
                default: {
                    this.valueLayout = new TextLayout(this.formatLcdValue(this.getLcdValue()), graphics2D.getFont(), this.RENDER_CONTEXT);
                    this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                    graphics2D.drawString(this.formatLcdValue(this.getLcdValue()), (float)(this.LCD.getX() + (this.LCD.getWidth() - this.unitStringWidth - this.VALUE_BOUNDARY.getWidth()) - this.LCD.getWidth() * 0.09), (float)(this.LCD.getY() + this.LCD.getHeight() * 0.76));
                }
            }
            if (!this.getLcdInfoString().isEmpty()) {
                graphics2D.setFont(this.getLcdInfoFont());
                this.infoLayout = new TextLayout(this.getLcdInfoString(), graphics2D.getFont(), this.RENDER_CONTEXT);
                this.INFO_BOUNDARY.setFrame(this.infoLayout.getBounds());
                graphics2D.drawString(this.getLcdInfoString(), (float)this.LCD.getBounds().x + 5.0f, (float)this.LCD.getBounds().y + (float)this.INFO_BOUNDARY.getHeight() + 5.0f);
            }
            if (this.getLcdNumberSystem() == NumberSystem.DEC && this.isLcdThresholdVisible() && this.getLcdValue() >= this.getLcdThreshold()) {
                graphics2D.drawImage((Image)this.lcdThresholdImage, (int)(this.LCD.getX() + this.LCD.getHeight() * 0.0568181818), (int)(this.LCD.getY() + this.LCD.getHeight() - (double)this.lcdThresholdImage.getHeight() - this.LCD.getHeight() * 0.0568181818), null);
            }
        }
        if (!this.isLogScale()) {
            this.angle = this.getRotationOffset() + (this.getValue() - this.getMinValue()) * this.getAngleStep();
            graphics2D.rotate(this.angle + Math.cos(Math.toRadians(this.angle - this.getRotationOffset() - 91.5)), this.CENTER.getX(), this.CENTER.getY());
        } else {
            this.angle = this.getRotationOffset() + UTIL.logOfBase(10.0, this.getValue() - this.getMinValue()) * this.getLogAngleStep();
            graphics2D.rotate(this.angle, this.CENTER.getX(), this.CENTER.getY() + 2.0);
        }
        graphics2D.drawImage((Image)this.pointerShadowImage, 0, 0, null);
        graphics2D.setTransform(affineTransform);
        graphics2D.rotate(this.angle, this.CENTER.getX(), this.CENTER.getY());
        graphics2D.drawImage((Image)this.pointerImage, 0, 0, null);
        graphics2D.setTransform(affineTransform);
        graphics2D.drawImage((Image)this.fImage, 0, 0, null);
        if (this.isGlowVisible()) {
            if (this.isGlowing()) {
                graphics2D.setComposite(AlphaComposite.getInstance(3, this.getGlowAlpha()));
                graphics2D.drawImage((Image)this.glowImageOn, 0, 0, null);
                graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
            } else {
                graphics2D.drawImage((Image)this.glowImageOff, 0, 0, null);
            }
        }
        if (!this.isEnabled()) {
            graphics2D.drawImage((Image)this.disabledImage, 0, 0, null);
        }
        graphics2D.dispose();
    }

    @Override
    public void setValue(double d) {
        if (this.isValueCoupled()) {
            this.setLcdValue(d);
        }
        super.setValue(d);
    }

    public boolean isSection3DEffectVisible() {
        return this.section3DEffectVisible;
    }

    public void setSection3DEffectVisible(boolean bl) {
        this.section3DEffectVisible = bl;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public boolean isArea3DEffectVisible() {
        return this.area3DEffectVisible;
    }

    public void setArea3DEffectVisible(boolean bl) {
        this.area3DEffectVisible = bl;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Paint createCustomLcdBackgroundPaint(Color[] colorArray) {
        Point2D.Double double_;
        Point2D.Double double_2 = new Point2D.Double(0.0, this.LCD.getMinY() + 1.0);
        if (double_2.equals(double_ = new Point2D.Double(0.0, this.LCD.getMaxY() - 1.0))) {
            ((Point2D)double_).setLocation(0.0, ((Point2D)double_2).getY() + 1.0);
        }
        float[] fArray = new float[]{0.0f, 0.03f, 0.49f, 0.5f, 1.0f};
        Color[] colorArray2 = new Color[]{colorArray[0], colorArray[1], colorArray[2], colorArray[3], colorArray[4]};
        return new LinearGradientPaint(double_2, double_, fArray, colorArray2);
    }

    @Override
    public Point2D getCenter() {
        return new Point2D.Double((double)this.bImage.getWidth() / 2.0 + (double)this.getInnerBounds().x, (double)this.bImage.getHeight() / 2.0 + (double)this.getInnerBounds().y);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return new Rectangle2D.Double(this.bImage.getMinX(), this.bImage.getMinY(), this.bImage.getWidth(), this.bImage.getHeight());
    }

    @Override
    public Rectangle getLcdBounds() {
        return this.LCD.getBounds();
    }

    private void createAreas(BufferedImage bufferedImage) {
        if (this.bImage != null) {
            double d = !this.isLogScale() ? Math.toDegrees(this.getGaugeType().ANGLE_RANGE) / (this.getMaxValue() - this.getMinValue()) : Math.toDegrees(this.getGaugeType().ANGLE_RANGE) / UTIL.logOfBase(10.0, this.getMaxValue() - this.getMinValue());
            if (this.bImage != null && !this.getAreas().isEmpty()) {
                double d2 = (float)this.bImage.getWidth() * 0.38f;
                double d3 = this.isSectionsVisible() ? (this.isExpandedSectionsEnabled() ? d2 - (double)((float)this.bImage.getWidth() * 0.12f) : d2 - (double)((float)this.bImage.getWidth() * 0.04f)) : d2;
                double d4 = (double)this.bImage.getWidth() / 2.0 - d3;
                Rectangle2D.Double double_ = new Rectangle2D.Double((double)this.bImage.getMinX() + d4, (double)this.bImage.getMinY() + d4, 2.0 * d3, 2.0 * d3);
                for (Section section : this.getAreas()) {
                    if (!this.isLogScale()) {
                        section.setFilledArea(new Arc2D.Double(double_, this.getGaugeType().ORIGIN_CORRECTION - section.getStart() * d + this.getMinValue() * d, -(section.getStop() - section.getStart()) * d, 2));
                        continue;
                    }
                    section.setFilledArea(new Arc2D.Double(double_, this.getGaugeType().ORIGIN_CORRECTION - UTIL.logOfBase(10.0, section.getStart()) * d + UTIL.logOfBase(10.0, this.getMinValue()) * d, -UTIL.logOfBase(10.0, section.getStop() - section.getStart()) * d, 2));
                }
            }
            if (this.isAreasVisible() && bufferedImage != null) {
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                for (Section section : this.getAreas()) {
                    graphics2D.setColor(this.isTransparentAreasEnabled() ? section.getTransparentColor() : section.getColor());
                    graphics2D.fill(section.getFilledArea());
                    if (!this.area3DEffectVisible) continue;
                    graphics2D.setPaint(this.area3DEffect);
                    graphics2D.fill(section.getFilledArea());
                }
                graphics2D.dispose();
            }
        }
    }

    private void createSections(BufferedImage bufferedImage) {
        if (this.bImage != null) {
            double d = !this.isLogScale() ? this.getGaugeType().APEX_ANGLE / (this.getMaxValue() - this.getMinValue()) : this.getGaugeType().APEX_ANGLE / UTIL.logOfBase(10.0, this.getMaxValue() - this.getMinValue());
            double d2 = (float)this.bImage.getWidth() * 0.38f;
            double d3 = this.isExpandedSectionsEnabled() ? d2 - (double)((float)this.bImage.getWidth() * 0.12f) : d2 - (double)((float)this.bImage.getWidth() * 0.04f);
            double d4 = (double)this.bImage.getWidth() / 2.0 - d2;
            double d5 = (double)this.bImage.getWidth() / 2.0 - d3;
            Area area = new Area(new Ellipse2D.Double((double)this.bImage.getMinX() + d5, (double)this.bImage.getMinY() + d5, 2.0 * d3, 2.0 * d3));
            for (Section object : this.getSections()) {
                double d6;
                double d7;
                if (!this.isLogScale()) {
                    d7 = this.getGaugeType().ORIGIN_CORRECTION - object.getStart() * d + this.getMinValue() * d;
                    d6 = -(object.getStop() - object.getStart()) * d;
                } else {
                    d7 = this.getGaugeType().ORIGIN_CORRECTION - UTIL.logOfBase(10.0, object.getStart()) * d + UTIL.logOfBase(10.0, this.getMinValue()) * d;
                    d6 = -UTIL.logOfBase(10.0, object.getStop() - object.getStart()) * d;
                }
                Arc2D.Double double_ = new Arc2D.Double(2);
                double_.setFrame((double)this.bImage.getMinX() + d4, (double)this.bImage.getMinY() + d4, 2.0 * d2, 2.0 * d2);
                ((Arc2D)double_).setAngleStart(d7);
                ((Arc2D)double_).setAngleExtent(d6);
                Area area2 = new Area(double_);
                area2.subtract(area);
                object.setSectionArea(area2);
            }
            if (this.isSectionsVisible() && bufferedImage != null) {
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                for (Section section : this.getSections()) {
                    graphics2D.setColor(this.isTransparentSectionsEnabled() ? section.getTransparentColor() : section.getColor());
                    graphics2D.fill(section.getSectionArea());
                    if (!this.section3DEffectVisible) continue;
                    graphics2D.setPaint(this.section3DEffect);
                    graphics2D.fill(section.getSectionArea());
                }
                graphics2D.dispose();
            }
        }
    }

    @Override
    public String toString() {
        return "Radial " + (Object)((Object)this.getGaugeType());
    }
}

