/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.gauges;

import eu.hansolo.steelseries.gauges.AbstractGauge;
import eu.hansolo.steelseries.gauges.AbstractRadial;
import eu.hansolo.steelseries.tools.ColorDef;
import eu.hansolo.steelseries.tools.CustomColorDef;
import eu.hansolo.steelseries.tools.GaugeType;
import eu.hansolo.steelseries.tools.Model;
import eu.hansolo.steelseries.tools.Orientation;
import eu.hansolo.steelseries.tools.PointerType;
import eu.hansolo.steelseries.tools.PostPosition;
import eu.hansolo.steelseries.tools.Section;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Iterator;

public final class Radial1Vertical
extends AbstractRadial {
    private static final int BASE = 10;
    private final Point2D CENTER = new Point2D.Double();
    private final Point2D TRACK_OFFSET = new Point2D.Double();
    private BufferedImage bImage;
    private BufferedImage fImage;
    private BufferedImage glowImageOff;
    private BufferedImage glowImageOn;
    private BufferedImage postsImage;
    private BufferedImage trackImage;
    private BufferedImage tickmarksImage;
    private BufferedImage pointerImage;
    private BufferedImage pointerShadowImage;
    private BufferedImage thresholdImage;
    private BufferedImage minMeasuredImage;
    private BufferedImage maxMeasuredImage;
    private BufferedImage disabledImage;
    private double angle = 0.0;

    public Radial1Vertical() {
        this.setLedPosition(0.455, 0.51);
        this.setUserLedPosition(0.455, 0.58);
        this.setOrientation(Orientation.NORTH);
        this.setGaugeType(GaugeType.TYPE5);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    public Radial1Vertical(Model model) {
        this.setModel(model);
        this.setGaugeType(GaugeType.TYPE5);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public final AbstractGauge init(int n, int n2) {
        int n3;
        int n4 = this.isFrameVisible() ? n : this.getGaugeBounds().width;
        int n5 = n3 = this.isFrameVisible() ? n2 : this.getGaugeBounds().height;
        if (n4 <= 1 || n3 <= 1) {
            return this;
        }
        this.CENTER.setLocation(this.getGaugeBounds().getCenterX() - (double)this.getInsets().left, (double)this.getGaugeBounds().height * 0.73 - (double)this.getInsets().top);
        if (!this.isFrameVisible()) {
            this.setFramelessOffset((double)(-this.getGaugeBounds().width) * 0.0841121495, (double)(-this.getGaugeBounds().width) * 0.0841121495);
        } else {
            this.setFramelessOffset(this.getGaugeBounds().x, this.getGaugeBounds().y);
        }
        if (this.bImage != null) {
            this.bImage.flush();
        }
        this.bImage = UTIL.createImage(n4, n4, 3);
        if (this.fImage != null) {
            this.fImage.flush();
        }
        this.fImage = UTIL.createImage(n4, n4, 3);
        if (this.isFrameVisible()) {
            switch (this.getFrameType()) {
                case ROUND: {
                    FRAME_FACTORY.createRadialFrame(n4, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameBaseColor(), this.isFrameBaseColorEnabled(), this.getFrameEffect(), this.bImage);
                    break;
                }
                case SQUARE: {
                    FRAME_FACTORY.createLinearFrame(n4, n4, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameBaseColor(), this.isFrameBaseColorEnabled(), this.getFrameEffect(), this.bImage);
                    break;
                }
                default: {
                    FRAME_FACTORY.createRadialFrame(n4, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameBaseColor(), this.isFrameBaseColorEnabled(), this.getFrameEffect(), this.bImage);
                }
            }
        }
        if (this.isBackgroundVisible()) {
            this.create_BACKGROUND_Image(n4, "", "", this.bImage);
        }
        if (this.isGlowVisible()) {
            if (this.glowImageOff != null) {
                this.glowImageOff.flush();
            }
            this.glowImageOff = this.create_GLOW_Image(n4, this.getGlowColor(), false, this.getGaugeType(), true, this.getOrientation());
            if (this.glowImageOn != null) {
                this.glowImageOn.flush();
            }
            this.glowImageOn = this.create_GLOW_Image(n4, this.getGlowColor(), true, this.getGaugeType(), true, this.getOrientation());
        } else {
            this.setGlowPulsating(false);
        }
        if (this.postsImage != null) {
            this.postsImage.flush();
        }
        this.postsImage = this.getPostsVisible() ? this.create_POSTS_Image(n4, PostPosition.LOWER_CENTER, PostPosition.SMALL_GAUGE_MIN_LEFT, PostPosition.SMALL_GAUGE_MAX_RIGHT) : this.create_POSTS_Image(n4, PostPosition.LOWER_CENTER);
        if (this.trackImage != null) {
            this.trackImage.flush();
        }
        this.TRACK_OFFSET.setLocation(0.0, 0.0);
        this.trackImage = this.create_TRACK_Image(n4, 1.5707963267948966, this.getTickmarkOffset() - 0.7853981633974483, this.getMinValue(), this.getMaxValue(), this.getAngleStep(), this.getTrackStart(), this.getTrackSection(), this.getTrackStop(), this.getTrackStartColor(), this.getTrackSectionColor(), this.getTrackStopColor(), 0.44f, this.CENTER, this.getTickmarkDirection(), this.TRACK_OFFSET);
        if (this.tickmarksImage != null) {
            this.tickmarksImage.flush();
        }
        this.tickmarksImage = TICKMARK_FACTORY.create_RADIAL_TICKMARKS_Image(n4, this.getModel().getNiceMinValue(), this.getModel().getNiceMaxValue(), this.getModel().getMaxNoOfMinorTicks(), this.getModel().getMaxNoOfMajorTicks(), this.getModel().getMinorTickSpacing(), this.getModel().getMajorTickSpacing(), this.getGaugeType(), this.getMinorTickmarkType(), this.getMajorTickmarkType(), this.isTickmarksVisible(), this.isTicklabelsVisible(), this.getModel().isMinorTickmarksVisible(), this.getModel().isMajorTickmarksVisible(), this.getLabelNumberFormat(), this.isTickmarkSectionsVisible(), this.getBackgroundColor(), this.getTickmarkColor(), this.isTickmarkColorFromThemeEnabled(), this.getTickmarkSections(), 0.44f, -0.04f, this.CENTER, new Point2D.Double(0.0, 0.0), Orientation.NORTH, this.getModel().getTicklabelOrientation(), this.getModel().isNiceScale(), this.getModel().isLogScale(), null);
        if (this.pointerImage != null) {
            this.pointerImage.flush();
        }
        this.pointerImage = this.create_POINTER_Image(n4, this.getPointerType());
        if (this.pointerShadowImage != null) {
            this.pointerShadowImage.flush();
        }
        this.pointerShadowImage = this.getModel().isPointerShadowVisible() ? this.create_POINTER_SHADOW_Image(n4, this.getPointerType()) : null;
        if (this.thresholdImage != null) {
            this.thresholdImage.flush();
        }
        this.thresholdImage = this.create_THRESHOLD_Image(n4);
        if (this.minMeasuredImage != null) {
            this.minMeasuredImage.flush();
        }
        this.minMeasuredImage = this.create_MEASURED_VALUE_Image(n4, new Color(0, 23, 252, 255));
        if (this.maxMeasuredImage != null) {
            this.maxMeasuredImage.flush();
        }
        this.maxMeasuredImage = this.create_MEASURED_VALUE_Image(n4, new Color(252, 29, 0, 255));
        if (this.isForegroundVisible()) {
            switch (this.getFrameType()) {
                case SQUARE: {
                    FOREGROUND_FACTORY.createLinearForeground(n4, n4, false, this.fImage);
                    break;
                }
                default: {
                    FOREGROUND_FACTORY.createRadialForeground(n4, false, this.getForegroundType(), this.fImage);
                }
            }
        }
        if (this.disabledImage != null) {
            this.disabledImage.flush();
        }
        this.disabledImage = this.create_DISABLED_Image(n4);
        this.CENTER.setLocation(this.getGaugeBounds().getCenterX(), this.getGaugeBounds().getCenterY());
        if (!this.getAreas().isEmpty()) {
            this.createAreas(this.bImage);
        }
        if (!this.getSections().isEmpty()) {
            this.createSections(this.bImage);
        }
        this.setCurrentLedImage(this.getLedImageOff());
        return this;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Rectangle2D rectangle2D;
        if (!this.isInitialized()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.translate(this.getFramelessOffset().getX(), this.getFramelessOffset().getY());
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.drawImage((Image)this.bImage, 0, 0, null);
        if (this.isHighlightArea()) {
            switch (this.getOrientation()) {
                case EAST: {
                    break;
                }
                case SOUTH: {
                    break;
                }
                case WEST: {
                    graphics2D.translate(this.CENTER.getX() / 2.2, 0.0);
                    break;
                }
                default: {
                    graphics2D.translate(0.0, this.CENTER.getY() / 2.2);
                }
            }
            for (Section object2 : this.getAreas()) {
                if (!object2.contains(this.getValue())) continue;
                graphics2D.setColor(object2.getHighlightColor());
                graphics2D.fill(object2.getFilledArea());
                break;
            }
            graphics2D.setTransform(affineTransform);
        }
        if (this.isHighlightSection()) {
            switch (this.getOrientation()) {
                case EAST: {
                    break;
                }
                case SOUTH: {
                    break;
                }
                case WEST: {
                    graphics2D.translate(this.CENTER.getX() / 2.2, 0.0);
                    break;
                }
                default: {
                    graphics2D.translate(0.0, this.CENTER.getY() / 2.2);
                }
            }
            for (Section section : this.getSections()) {
                if (!section.contains(this.getValue())) continue;
                graphics2D.setColor(section.getHighlightColor());
                graphics2D.fill(section.getSectionArea());
                break;
            }
            graphics2D.setTransform(affineTransform);
        }
        Iterator<Section> iterator = new FontRenderContext(null, true, true);
        if (!this.getTitle().isEmpty()) {
            if (this.isLabelColorFromThemeEnabled()) {
                graphics2D.setColor(this.getBackgroundColor().LABEL_COLOR);
            } else {
                graphics2D.setColor(this.getLabelColor());
            }
            graphics2D.setFont(new Font("Verdana", 0, (int)(0.04672897196261682 * (double)this.getGaugeBounds().width)));
            TextLayout textLayout = new TextLayout(this.getTitle(), graphics2D.getFont(), (FontRenderContext)((Object)iterator));
            rectangle2D = textLayout.getBounds();
            graphics2D.drawString(this.getTitle(), (float)(((double)this.getGaugeBounds().width - rectangle2D.getWidth()) / 2.0), 0.4f * (float)this.getGaugeBounds().width + textLayout.getAscent() - textLayout.getDescent());
        }
        if (!this.getUnitString().isEmpty()) {
            if (this.isLabelColorFromThemeEnabled()) {
                graphics2D.setColor(this.getBackgroundColor().LABEL_COLOR);
            } else {
                graphics2D.setColor(this.getLabelColor());
            }
            graphics2D.setFont(new Font("Verdana", 0, (int)(0.04672897196261682 * (double)this.getGaugeBounds().width)));
            TextLayout textLayout = new TextLayout(this.getUnitString(), graphics2D.getFont(), (FontRenderContext)((Object)iterator));
            rectangle2D = textLayout.getBounds();
            graphics2D.drawString(this.getUnitString(), (float)(((double)this.getGaugeBounds().width - rectangle2D.getWidth()) / 2.0), 0.47f * (float)this.getGaugeBounds().width + textLayout.getAscent() - textLayout.getDescent());
        }
        switch (this.getOrientation()) {
            case NORTH: {
                break;
            }
            case EAST: {
                break;
            }
            case SOUTH: {
                break;
            }
            case WEST: {
                graphics2D.rotate(-1.5707963267948966, this.CENTER.getX(), this.CENTER.getY());
                break;
            }
        }
        AffineTransform affineTransform2 = graphics2D.getTransform();
        if (this.isTrackVisible()) {
            graphics2D.drawImage((Image)this.trackImage, 0, 0, null);
        }
        graphics2D.drawImage((Image)this.tickmarksImage, 0, 0, null);
        if (this.isThresholdVisible()) {
            if (!this.isLogScale()) {
                graphics2D.rotate(this.getGaugeType().ROTATION_OFFSET + (this.getThreshold() - this.getMinValue()) * this.getAngleStep(), this.CENTER.getX(), (double)this.getGaugeBounds().width * 0.7336448598);
            } else {
                graphics2D.rotate(this.getGaugeType().ROTATION_OFFSET + UTIL.logOfBase(10.0, this.getThreshold() - this.getMinValue()) * this.getLogAngleStep(), this.CENTER.getX(), (double)this.getGaugeBounds().width * 0.7336448598);
            }
            graphics2D.drawImage((Image)this.thresholdImage, 0, 0, null);
            graphics2D.setTransform(affineTransform2);
        }
        if (this.isMinMeasuredValueVisible()) {
            if (!this.isLogScale()) {
                graphics2D.rotate(this.getGaugeType().ROTATION_OFFSET + (this.getMinMeasuredValue() - this.getMinValue()) * this.getAngleStep(), this.CENTER.getX(), (double)this.getGaugeBounds().width * 0.7336448598);
            } else {
                graphics2D.rotate(this.getGaugeType().ROTATION_OFFSET + UTIL.logOfBase(10.0, this.getMinMeasuredValue() - this.getMinValue()) * this.getLogAngleStep(), this.CENTER.getX(), (double)this.getGaugeBounds().width * 0.7336448598);
            }
            graphics2D.drawImage((Image)this.minMeasuredImage, 0, 0, null);
            graphics2D.setTransform(affineTransform2);
        }
        if (this.isMaxMeasuredValueVisible()) {
            if (!this.isLogScale()) {
                graphics2D.rotate(this.getGaugeType().ROTATION_OFFSET + (this.getMaxMeasuredValue() - this.getMinValue()) * this.getAngleStep(), this.CENTER.getX(), (double)this.getGaugeBounds().width * 0.7336448598);
            } else {
                graphics2D.rotate(this.getGaugeType().ROTATION_OFFSET + UTIL.logOfBase(10.0, this.getMaxMeasuredValue() - this.getMinValue()) * this.getLogAngleStep(), this.CENTER.getX(), (double)this.getGaugeBounds().width * 0.7336448598);
            }
            graphics2D.drawImage((Image)this.maxMeasuredImage, 0, 0, null);
            graphics2D.setTransform(affineTransform2);
        }
        if (this.isLedVisible()) {
            graphics2D.setTransform(affineTransform);
            graphics2D.drawImage((Image)this.getCurrentLedImage(), (int)((double)this.getGaugeBounds().width * this.getLedPosition().getX()), (int)((double)this.getGaugeBounds().width * this.getLedPosition().getY()), null);
            graphics2D.setTransform(affineTransform2);
        }
        if (this.isUserLedVisible()) {
            graphics2D.setTransform(affineTransform);
            graphics2D.drawImage((Image)this.getCurrentUserLedImage(), (int)((double)this.getGaugeBounds().width * this.getUserLedPosition().getX()), (int)((double)this.getGaugeBounds().width * this.getUserLedPosition().getY()), null);
            graphics2D.setTransform(affineTransform2);
        }
        this.angle = !this.isLogScale() ? this.getGaugeType().ROTATION_OFFSET + (this.getValue() - this.getMinValue()) * this.getAngleStep() : this.getGaugeType().ROTATION_OFFSET + UTIL.logOfBase(10.0, this.getValue() - this.getMinValue()) * this.getLogAngleStep();
        graphics2D.rotate(this.angle, this.CENTER.getX(), (double)this.getGaugeBounds().height * 0.7336448598 + 2.0);
        graphics2D.drawImage((Image)this.pointerShadowImage, 0, 0, null);
        graphics2D.setTransform(affineTransform2);
        graphics2D.rotate(this.angle, this.CENTER.getX(), (double)this.getGaugeBounds().height * 0.7336448598);
        graphics2D.drawImage((Image)this.pointerImage, 0, 0, null);
        graphics2D.setTransform(affineTransform2);
        graphics2D.drawImage((Image)this.postsImage, 0, 0, null);
        switch (this.getOrientation()) {
            case NORTH: {
                break;
            }
            case EAST: {
                break;
            }
            case SOUTH: {
                break;
            }
            case WEST: {
                graphics2D.setTransform(affineTransform);
                break;
            }
        }
        graphics2D.drawImage((Image)this.fImage, 0, 0, null);
        if (this.isGlowVisible()) {
            if (this.isGlowing()) {
                graphics2D.setComposite(AlphaComposite.getInstance(3, this.getGlowAlpha()));
                graphics2D.drawImage((Image)this.glowImageOn, 0, 0, null);
                graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
            } else {
                graphics2D.drawImage((Image)this.glowImageOff, 0, 0, null);
            }
        }
        if (!this.isEnabled()) {
            graphics2D.drawImage((Image)this.disabledImage, 0, 0, null);
        }
        graphics2D.dispose();
    }

    @Override
    public void setOrientation(Orientation orientation) {
        super.setOrientation(orientation);
        switch (orientation) {
            case NORTH: {
                this.setLedPosition(0.455, 0.51);
                this.setUserLedPosition(0.455, 0.58);
                break;
            }
            case EAST: {
                break;
            }
            case SOUTH: {
                break;
            }
            case WEST: {
                this.setLedPosition(0.455, 0.51);
                this.setUserLedPosition(0.455, 0.58);
                break;
            }
            default: {
                this.setLedPosition(0.455, 0.51);
                this.setUserLedPosition(0.455, 0.58);
            }
        }
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Point2D getCenter() {
        return new Point2D.Double((double)this.bImage.getWidth() / 2.0, (double)this.bImage.getHeight() / 2.0);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return new Rectangle2D.Double(this.bImage.getMinX(), this.bImage.getMinY(), this.bImage.getWidth(), this.bImage.getHeight());
    }

    @Override
    public Rectangle getLcdBounds() {
        return new Rectangle();
    }

    private void createAreas(BufferedImage bufferedImage) {
        double d;
        switch (this.getOrientation()) {
            case NORTH: {
                d = 135.0;
                break;
            }
            case EAST: {
                d = 135.0;
                break;
            }
            case SOUTH: {
                d = 135.0;
                break;
            }
            case WEST: {
                d = 225.0;
                break;
            }
            default: {
                d = 135.0;
            }
        }
        if (this.bImage != null) {
            double d2 = !this.isLogScale() ? Math.toDegrees(this.getGaugeType().ANGLE_RANGE) / (this.getMaxValue() - this.getMinValue()) : Math.toDegrees(this.getGaugeType().ANGLE_RANGE) / UTIL.logOfBase(10.0, this.getMaxValue() - this.getMinValue());
            if (this.bImage != null && !this.getAreas().isEmpty()) {
                double d3 = (float)this.bImage.getWidth() * 0.44f;
                double d4 = this.isSectionsVisible() ? (this.isExpandedSectionsEnabled() ? d3 - (double)((float)this.bImage.getWidth() * 0.12f) : d3 - (double)((float)this.bImage.getWidth() * 0.04f)) : d3;
                double d5 = (double)this.bImage.getWidth() / 2.0 - d4;
                Rectangle2D.Double double_ = new Rectangle2D.Double((double)this.bImage.getMinX() + d5, (double)this.bImage.getMinY() + d5, 2.0 * d4, 2.0 * d4);
                for (Section section : this.getAreas()) {
                    if (!this.isLogScale()) {
                        section.setFilledArea(new Arc2D.Double(double_, d - section.getStart() * d2 + this.getMinValue() * d2, -(section.getStop() - section.getStart()) * d2, 2));
                        continue;
                    }
                    section.setFilledArea(new Arc2D.Double(double_, d - UTIL.logOfBase(10.0, section.getStart()) * d2 + UTIL.logOfBase(10.0, this.getMinValue()) * d2, -UTIL.logOfBase(10.0, section.getStop() - section.getStart()) * d2, 2));
                }
            }
            if (this.isAreasVisible() && bufferedImage != null) {
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                switch (this.getOrientation()) {
                    case EAST: {
                        break;
                    }
                    case SOUTH: {
                        break;
                    }
                    case WEST: {
                        graphics2D.translate(this.CENTER.getX() / 2.2, 0.0);
                        break;
                    }
                    default: {
                        graphics2D.translate(0.0, this.CENTER.getY() / 2.2);
                    }
                }
                for (Section section : this.getAreas()) {
                    graphics2D.setColor(this.isTransparentAreasEnabled() ? section.getTransparentColor() : section.getColor());
                    graphics2D.fill(section.getFilledArea());
                }
                graphics2D.dispose();
            }
        }
    }

    private void createSections(BufferedImage bufferedImage) {
        if (this.bImage != null) {
            double d;
            switch (this.getOrientation()) {
                case NORTH: {
                    d = 135.0;
                    break;
                }
                case EAST: {
                    d = 135.0;
                    break;
                }
                case SOUTH: {
                    d = 135.0;
                    break;
                }
                case WEST: {
                    d = 225.0;
                    break;
                }
                default: {
                    d = 135.0;
                }
            }
            double d2 = !this.isLogScale() ? this.getGaugeType().APEX_ANGLE / (this.getMaxValue() - this.getMinValue()) : this.getGaugeType().APEX_ANGLE / UTIL.logOfBase(10.0, this.getMaxValue() - this.getMinValue());
            double d3 = (float)this.bImage.getWidth() * 0.44f;
            double d4 = this.isExpandedSectionsEnabled() ? d3 - (double)((float)this.bImage.getWidth() * 0.12f) : d3 - (double)((float)this.bImage.getWidth() * 0.04f);
            double d5 = (double)this.bImage.getWidth() / 2.0 - d3;
            double d6 = (double)this.bImage.getWidth() / 2.0 - d4;
            Ellipse2D.Double double_ = new Ellipse2D.Double((double)this.bImage.getMinX() + d6, (double)this.bImage.getMinY() + d6, 2.0 * d4, 2.0 * d4);
            for (Section object : this.getSections()) {
                double d7;
                double d8;
                if (!this.isLogScale()) {
                    d8 = d - object.getStart() * d2 + this.getMinValue() * d2;
                    d7 = -(object.getStop() - object.getStart()) * d2;
                } else {
                    d8 = d - UTIL.logOfBase(10.0, object.getStart()) * d2 + UTIL.logOfBase(10.0, this.getMinValue()) * d2;
                    d7 = -(object.getStop() - object.getStart()) * d2;
                }
                Arc2D.Double double_2 = new Arc2D.Double(2);
                double_2.setFrame((double)this.bImage.getMinX() + d5, (double)this.bImage.getMinY() + d5, 2.0 * d3, 2.0 * d3);
                ((Arc2D)double_2).setAngleStart(d8);
                ((Arc2D)double_2).setAngleExtent(d7);
                Area area = new Area(double_2);
                area.subtract(new Area(double_));
                object.setSectionArea(area);
            }
            if (this.isSectionsVisible() && bufferedImage != null) {
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                switch (this.getOrientation()) {
                    case EAST: {
                        break;
                    }
                    case SOUTH: {
                        break;
                    }
                    case WEST: {
                        graphics2D.translate(this.CENTER.getX() / 2.2, 0.0);
                        break;
                    }
                    default: {
                        graphics2D.translate(0.0, this.CENTER.getY() / 2.2);
                    }
                }
                for (Section section : this.getSections()) {
                    graphics2D.setColor(this.isTransparentAreasEnabled() ? section.getTransparentColor() : section.getColor());
                    graphics2D.fill(section.getSectionArea());
                }
                graphics2D.dispose();
            }
        }
    }

    @Override
    protected BufferedImage create_THRESHOLD_Image(int n) {
        if (n <= 0) {
            return null;
        }
        BufferedImage bufferedImage = UTIL.createImage(n, n, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n2 * 0.5, (double)n3 * 0.3333333333333333);
        generalPath.lineTo((double)n2 * 0.4866666666666667, (double)n3 * 0.37333333333333335);
        generalPath.lineTo((double)n2 * 0.52, (double)n3 * 0.37333333333333335);
        generalPath.lineTo((double)n2 * 0.5, (double)n3 * 0.3333333333333333);
        generalPath.closePath();
        Point2D.Double double_ = new Point2D.Double(0.0, generalPath.getBounds2D().getMinY());
        Point2D.Double double_2 = new Point2D.Double(0.0, generalPath.getBounds2D().getMaxY());
        float[] fArray = new float[]{0.0f, 0.3f, 0.59f, 1.0f};
        Color[] colorArray = new Color[]{new Color(82, 0, 0, 255), new Color(252, 29, 0, 255), new Color(252, 29, 0, 255), new Color(82, 0, 0, 255)};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(generalPath);
        graphics2D.setColor(Color.WHITE);
        graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
        graphics2D.draw(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    protected BufferedImage create_MEASURED_VALUE_Image(int n, Color color) {
        if (n <= 0) {
            return null;
        }
        BufferedImage bufferedImage = UTIL.createImage(n, n, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n2 * 0.5, (double)n3 * 0.3037383177570093);
        generalPath.lineTo((double)n2 * 0.514018691588785, (double)n3 * 0.2803738317757009);
        generalPath.lineTo((double)n2 * 0.48598130841121495, (double)n3 * 0.2803738317757009);
        generalPath.lineTo((double)n2 * 0.5, (double)n3 * 0.3037383177570093);
        generalPath.closePath();
        graphics2D.setColor(color);
        graphics2D.fill(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    protected BufferedImage create_POINTER_Image(int n, PointerType pointerType) {
        if (n <= 0) {
            return null;
        }
        BufferedImage bufferedImage = UTIL.createImage(n, n, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        CustomColorDef customColorDef = this.getPointerColor() == ColorDef.CUSTOM ? new CustomColorDef(this.getCustomPointerColor()) : null;
        switch (pointerType) {
            case TYPE2: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.705607476635514);
                generalPath.lineTo((double)n2 * 0.5093457943925234, (double)n3 * 0.6962616822429907);
                generalPath.lineTo((double)n2 * 0.5093457943925234, (double)n3 * 0.5747663551401869);
                generalPath.lineTo((double)n2 * 0.5046728971962616, (double)n3 * 0.2897196261682243);
                generalPath.lineTo((double)n2 * 0.4953271028037383, (double)n3 * 0.2897196261682243);
                generalPath.lineTo((double)n2 * 0.49065420560747663, (double)n3 * 0.5747663551401869);
                generalPath.lineTo((double)n2 * 0.49065420560747663, (double)n3 * 0.6962616822429907);
                generalPath.lineTo((double)n2 * 0.48130841121495327, (double)n3 * 0.705607476635514);
                generalPath.curveTo((double)n2 * 0.48130841121495327, (double)n3 * 0.705607476635514, (double)n2 * 0.4672897196261682, (double)n3 * 0.7242990654205608, (double)n2 * 0.4672897196261682, (double)n3 * 0.7336448598130841);
                generalPath.curveTo((double)n2 * 0.4672897196261682, (double)n3 * 0.7523364485981309, (double)n2 * 0.48130841121495327, (double)n3 * 0.7663551401869159, (double)n2 * 0.5, (double)n3 * 0.7663551401869159);
                generalPath.curveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.7663551401869159, (double)n2 * 0.5327102803738317, (double)n3 * 0.7523364485981309, (double)n2 * 0.5327102803738317, (double)n3 * 0.7336448598130841);
                generalPath.curveTo((double)n2 * 0.5327102803738317, (double)n3 * 0.7242990654205608, (double)n2 * 0.5186915887850467, (double)n3 * 0.705607476635514, (double)n2 * 0.5186915887850467, (double)n3 * 0.705607476635514);
                generalPath.closePath();
                Point2D.Double double_ = new Point2D.Double(0.0, generalPath.getBounds2D().getMaxY());
                Point2D.Double double_2 = new Point2D.Double(0.0, generalPath.getBounds2D().getMinY());
                float[] fArray = new float[]{0.0f, 0.36f, 0.3601f, 1.0f};
                Color[] colorArray = this.getPointerColor() != ColorDef.CUSTOM ? new Color[]{this.getBackgroundColor().LABEL_COLOR, this.getBackgroundColor().LABEL_COLOR, this.getPointerColor().LIGHT, this.getPointerColor().LIGHT} : new Color[]{this.getBackgroundColor().LABEL_COLOR, this.getBackgroundColor().LABEL_COLOR, customColorDef.LIGHT, customColorDef.LIGHT};
                LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray);
                graphics2D.setPaint(linearGradientPaint);
                graphics2D.fill(generalPath);
                break;
            }
            case TYPE3: {
                GeneralPath generalPath = new GeneralPath(new Rectangle2D.Double((double)n2 * 0.4953271028037383, (double)n3 * 0.2897196261682243, (double)n2 * 0.009345794392523364, (double)n3 * 0.4485981308));
                if (this.getPointerColor() != ColorDef.CUSTOM) {
                    graphics2D.setColor(this.getPointerColor().LIGHT);
                } else {
                    graphics2D.setColor(customColorDef.LIGHT);
                }
                graphics2D.fill(generalPath);
                break;
            }
            case TYPE4: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.5, (double)n3 * 0.29439252336448596);
                generalPath.lineTo((double)n2 * 0.514018691588785, (double)n3 * 0.3037383177570093);
                generalPath.lineTo((double)n2 * 0.5327102803738317, (double)n3 * 0.7336448598130841);
                generalPath.lineTo((double)n2 * 0.5233644859813084, (double)n3 * 0.8364485981308412);
                generalPath.lineTo((double)n2 * 0.4766355140186916, (double)n3 * 0.8364485981308412);
                generalPath.lineTo((double)n2 * 0.4672897196261682, (double)n3 * 0.7336448598130841);
                generalPath.lineTo((double)n2 * 0.49065420560747663, (double)n3 * 0.3037383177570093);
                generalPath.lineTo((double)n2 * 0.5, (double)n3 * 0.29439252336448596);
                generalPath.closePath();
                Point2D.Double double_ = new Point2D.Double(generalPath.getBounds2D().getMinX(), 0.0);
                Point2D.Double double_3 = new Point2D.Double(generalPath.getBounds2D().getMaxX(), 0.0);
                float[] fArray = new float[]{0.0f, 0.51f, 0.52f, 1.0f};
                Color[] colorArray = this.getPointerColor() != ColorDef.CUSTOM ? new Color[]{this.getPointerColor().DARK, this.getPointerColor().DARK, this.getPointerColor().LIGHT, this.getPointerColor().LIGHT} : new Color[]{customColorDef.DARK, customColorDef.DARK, customColorDef.LIGHT, customColorDef.LIGHT};
                LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_3, fArray, colorArray);
                graphics2D.setPaint(linearGradientPaint);
                graphics2D.fill(generalPath);
                break;
            }
            case TYPE5: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.5, (double)n3 * 0.74);
                generalPath.lineTo((double)n2 * 0.5266666666666666, (double)n3 * 0.74);
                generalPath.lineTo((double)n2 * 0.5, (double)n3 * 0.3);
                generalPath.lineTo((double)n2 * 0.47333333333333333, (double)n3 * 0.74);
                generalPath.lineTo((double)n2 * 0.5, (double)n3 * 0.74);
                generalPath.closePath();
                Point2D.Double double_ = new Point2D.Double(generalPath.getBounds2D().getMinX(), 0.0);
                Point2D.Double double_4 = new Point2D.Double(generalPath.getBounds2D().getMaxX(), 0.0);
                float[] fArray = new float[]{0.0f, 0.4999f, 0.5f, 1.0f};
                Color[] colorArray = this.getPointerColor() != ColorDef.CUSTOM ? new Color[]{this.getPointerColor().LIGHT, this.getPointerColor().LIGHT, this.getPointerColor().MEDIUM, this.getPointerColor().MEDIUM} : new Color[]{this.getCustomPointerColorObject().LIGHT, this.getCustomPointerColorObject().LIGHT, this.getCustomPointerColorObject().MEDIUM, this.getCustomPointerColorObject().MEDIUM};
                LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_4, fArray, colorArray);
                graphics2D.setPaint(linearGradientPaint);
                graphics2D.fill(generalPath);
                if (this.getPointerColor() != ColorDef.CUSTOM) {
                    graphics2D.setColor(this.getPointerColor().DARK);
                } else {
                    graphics2D.setColor(this.getCustomPointerColorObject().DARK);
                }
                graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
                graphics2D.draw(generalPath);
                break;
            }
            case TYPE6: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.47333333333333333, (double)n3 * 0.7333333333333333);
                generalPath.lineTo((double)n2 * 0.47333333333333333, (double)n3 * 0.6);
                generalPath.lineTo((double)n2 * 0.48, (double)n3 * 0.49333333333333335);
                generalPath.lineTo((double)n2 * 0.49333333333333335, (double)n3 * 0.30666666666666664);
                generalPath.lineTo((double)n2 * 0.5, (double)n3 * 0.30666666666666664);
                generalPath.lineTo((double)n2 * 0.5066666666666667, (double)n3 * 0.30666666666666664);
                generalPath.lineTo((double)n2 * 0.52, (double)n3 * 0.49333333333333335);
                generalPath.lineTo((double)n2 * 0.5266666666666666, (double)n3 * 0.5933333333333334);
                generalPath.lineTo((double)n2 * 0.5266666666666666, (double)n3 * 0.7333333333333333);
                generalPath.lineTo((double)n2 * 0.5066666666666667, (double)n3 * 0.7333333333333333);
                generalPath.lineTo((double)n2 * 0.5066666666666667, (double)n3 * 0.5933333333333334);
                generalPath.lineTo((double)n2 * 0.5, (double)n3 * 0.49333333333333335);
                generalPath.lineTo((double)n2 * 0.49333333333333335, (double)n3 * 0.6);
                generalPath.lineTo((double)n2 * 0.49333333333333335, (double)n3 * 0.7333333333333333);
                generalPath.lineTo((double)n2 * 0.47333333333333333, (double)n3 * 0.7333333333333333);
                generalPath.closePath();
                Point2D.Double double_ = new Point2D.Double(generalPath.getBounds2D().getMaxY(), 0.0);
                Point2D.Double double_5 = new Point2D.Double(generalPath.getBounds2D().getMinY(), 0.0);
                float[] fArray = new float[]{0.0f, 0.25f, 0.75f, 1.0f};
                Color[] colorArray = this.getPointerColor() != ColorDef.CUSTOM ? new Color[]{this.getPointerColor().LIGHT, this.getPointerColor().MEDIUM, this.getPointerColor().MEDIUM, this.getPointerColor().LIGHT} : new Color[]{this.getCustomPointerColorObject().LIGHT, this.getCustomPointerColorObject().MEDIUM, this.getCustomPointerColorObject().MEDIUM, this.getCustomPointerColorObject().LIGHT};
                LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_5, fArray, colorArray);
                graphics2D.setPaint(linearGradientPaint);
                graphics2D.fill(generalPath);
                if (this.getPointerColor() != ColorDef.CUSTOM) {
                    graphics2D.setColor(this.getPointerColor().DARK);
                } else {
                    graphics2D.setColor(this.getCustomPointerColorObject().DARK);
                }
                graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
                graphics2D.draw(generalPath);
                break;
            }
            case TYPE7: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.4866666666666667, (double)n3 * 0.30666666666666664);
                generalPath.lineTo((double)n2 * 0.47333333333333333, (double)n3 * 0.7333333333333333);
                generalPath.lineTo((double)n2 * 0.5266666666666666, (double)n3 * 0.7333333333333333);
                generalPath.lineTo((double)n2 * 0.5066666666666667, (double)n3 * 0.30666666666666664);
                generalPath.lineTo((double)n2 * 0.4866666666666667, (double)n3 * 0.30666666666666664);
                generalPath.closePath();
                Point2D.Double double_ = new Point2D.Double(generalPath.getBounds2D().getMinX(), 0.0);
                Point2D.Double double_6 = new Point2D.Double(generalPath.getBounds2D().getMaxX(), 0.0);
                float[] fArray = new float[]{0.0f, 1.0f};
                Color[] colorArray = this.getPointerColor() != ColorDef.CUSTOM ? new Color[]{this.getPointerColor().DARK, this.getPointerColor().MEDIUM} : new Color[]{this.getCustomPointerColorObject().DARK, this.getCustomPointerColorObject().MEDIUM};
                LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_6, fArray, colorArray);
                graphics2D.setPaint(linearGradientPaint);
                graphics2D.fill(generalPath);
                break;
            }
            case TYPE8: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.5, (double)n3 * 0.7666666666666667);
                generalPath.lineTo((double)n2 * 0.5333333333333333, (double)n3 * 0.7333333333333333);
                generalPath.curveTo((double)n2 * 0.5333333333333333, (double)n3 * 0.7333333333333333, (double)n2 * 0.5066666666666667, (double)n3 * 0.7066666666666667, (double)n2 * 0.5, (double)n3 * 0.31333333333333335);
                generalPath.curveTo((double)n2 * 0.49333333333333335, (double)n3 * 0.7066666666666667, (double)n2 * 0.4666666666666667, (double)n3 * 0.7333333333333333, (double)n2 * 0.4666666666666667, (double)n3 * 0.7333333333333333);
                generalPath.lineTo((double)n2 * 0.5, (double)n3 * 0.7666666666666667);
                generalPath.closePath();
                Point2D.Double double_ = new Point2D.Double(generalPath.getBounds2D().getMinX(), 0.0);
                Point2D.Double double_7 = new Point2D.Double(generalPath.getBounds2D().getMaxX(), 0.0);
                float[] fArray = new float[]{0.0f, 0.46f, 0.47f, 1.0f};
                Color[] colorArray = this.getPointerColor() != ColorDef.CUSTOM ? new Color[]{this.getPointerColor().LIGHT, this.getPointerColor().LIGHT, this.getPointerColor().MEDIUM, this.getPointerColor().MEDIUM} : new Color[]{this.getCustomPointerColorObject().LIGHT, this.getCustomPointerColorObject().LIGHT, this.getCustomPointerColorObject().MEDIUM, this.getCustomPointerColorObject().MEDIUM};
                LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_7, fArray, colorArray);
                graphics2D.setPaint(linearGradientPaint);
                graphics2D.fill(generalPath);
                if (this.getPointerColor() != ColorDef.CUSTOM) {
                    graphics2D.setColor(this.getPointerColor().DARK);
                } else {
                    graphics2D.setColor(this.getCustomPointerColorObject().DARK);
                }
                graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
                graphics2D.draw(generalPath);
                break;
            }
            case TYPE9: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.49333333333333335, (double)n3 * 0.42);
                generalPath.lineTo((double)n2 * 0.5066666666666667, (double)n3 * 0.42);
                generalPath.lineTo((double)n2 * 0.5133333333333333, (double)n3 * 0.66);
                generalPath.lineTo((double)n2 * 0.4866666666666667, (double)n3 * 0.66);
                generalPath.lineTo((double)n2 * 0.49333333333333335, (double)n3 * 0.42);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.49333333333333335, (double)n3 * 0.3);
                generalPath.lineTo((double)n2 * 0.47333333333333333, (double)n3 * 0.7);
                generalPath.lineTo((double)n2 * 0.47333333333333333, (double)n3 * 0.7666666666666667);
                generalPath.curveTo((double)n2 * 0.47333333333333333, (double)n3 * 0.7666666666666667, (double)n2 * 0.47333333333333333, (double)n3 * 0.8533333333333334, (double)n2 * 0.47333333333333333, (double)n3 * 0.8533333333333334);
                generalPath.curveTo((double)n2 * 0.47333333333333333, (double)n3 * 0.86, (double)n2 * 0.48, (double)n3 * 0.86, (double)n2 * 0.5, (double)n3 * 0.86);
                generalPath.curveTo((double)n2 * 0.52, (double)n3 * 0.86, (double)n2 * 0.5266666666666666, (double)n3 * 0.86, (double)n2 * 0.5266666666666666, (double)n3 * 0.8533333333333334);
                generalPath.curveTo((double)n2 * 0.5266666666666666, (double)n3 * 0.8533333333333334, (double)n2 * 0.5266666666666666, (double)n3 * 0.7666666666666667, (double)n2 * 0.5266666666666666, (double)n3 * 0.7666666666666667);
                generalPath.lineTo((double)n2 * 0.5266666666666666, (double)n3 * 0.7);
                generalPath.lineTo((double)n2 * 0.5066666666666667, (double)n3 * 0.3);
                generalPath.lineTo((double)n2 * 0.49333333333333335, (double)n3 * 0.3);
                generalPath.closePath();
                Point2D.Double double_ = new Point2D.Double(generalPath.getBounds2D().getMinX(), 0.0);
                Point2D.Double double_8 = new Point2D.Double(generalPath.getBounds2D().getMaxX(), 0.0);
                float[] fArray = new float[]{0.0f, 0.48f, 1.0f};
                Color[] colorArray = new Color[]{new Color(50, 50, 50, 255), new Color(102, 102, 102, 255), new Color(50, 50, 50, 255)};
                LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_8, fArray, colorArray);
                graphics2D.setPaint(linearGradientPaint);
                graphics2D.fill(generalPath);
                graphics2D.setColor(new Color(0x2E2E2E));
                graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
                graphics2D.draw(generalPath);
                GeneralPath generalPath2 = new GeneralPath();
                generalPath2.setWindingRule(0);
                generalPath2.moveTo((double)n2 * 0.49333333333333335, (double)n3 * 0.4066666666666667);
                generalPath2.lineTo((double)n2 * 0.5066666666666667, (double)n3 * 0.4066666666666667);
                generalPath2.lineTo((double)n2 * 0.5066666666666667, (double)n3 * 0.30666666666666664);
                generalPath2.lineTo((double)n2 * 0.49333333333333335, (double)n3 * 0.30666666666666664);
                generalPath2.lineTo((double)n2 * 0.49333333333333335, (double)n3 * 0.4066666666666667);
                generalPath2.closePath();
                graphics2D.setColor(this.getPointerColor().MEDIUM);
                graphics2D.fill(generalPath2);
                break;
            }
            case TYPE10: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.5, (double)n3 * 0.3);
                generalPath.curveTo((double)n2 * 0.5, (double)n3 * 0.3, (double)n2 * 0.43333333333333335, (double)n3 * 0.7133333333333334, (double)n2 * 0.43333333333333335, (double)n3 * 0.7266666666666667);
                generalPath.curveTo((double)n2 * 0.43333333333333335, (double)n3 * 0.76, (double)n2 * 0.46, (double)n3 * 0.7933333333333333, (double)n2 * 0.5, (double)n3 * 0.7933333333333333);
                generalPath.curveTo((double)n2 * 0.54, (double)n3 * 0.7933333333333333, (double)n2 * 0.5666666666666667, (double)n3 * 0.76, (double)n2 * 0.5666666666666667, (double)n3 * 0.7266666666666667);
                generalPath.curveTo((double)n2 * 0.5666666666666667, (double)n3 * 0.7133333333333334, (double)n2 * 0.5, (double)n3 * 0.3, (double)n2 * 0.5, (double)n3 * 0.3);
                generalPath.closePath();
                Point2D.Double double_ = new Point2D.Double(generalPath.getBounds2D().getMinX(), 0.0);
                Point2D.Double double_9 = new Point2D.Double(generalPath.getBounds2D().getMaxX(), 0.0);
                float[] fArray = new float[]{0.0f, 0.4999f, 0.5f, 1.0f};
                Color[] colorArray = new Color[]{this.getPointerColor().LIGHT, this.getPointerColor().LIGHT, this.getPointerColor().MEDIUM, this.getPointerColor().MEDIUM};
                LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_9, fArray, colorArray);
                graphics2D.setPaint(linearGradientPaint);
                graphics2D.fill(generalPath);
                graphics2D.setColor(this.getPointerColor().MEDIUM);
                graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
                graphics2D.draw(generalPath);
                break;
            }
            case TYPE11: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo(0.5 * (double)n2, 0.3 * (double)n3);
                generalPath.lineTo(0.4866666666666667 * (double)n2, 0.7333333333333333 * (double)n3);
                generalPath.curveTo(0.4866666666666667 * (double)n2, 0.7333333333333333 * (double)n3, 0.4866666666666667 * (double)n2, 0.8066666666666666 * (double)n3, 0.5 * (double)n2, 0.8066666666666666 * (double)n3);
                generalPath.curveTo(0.5133333333333333 * (double)n2, 0.8066666666666666 * (double)n3, 0.5133333333333333 * (double)n2, 0.7333333333333333 * (double)n3, 0.5133333333333333 * (double)n2, 0.7333333333333333 * (double)n3);
                generalPath.lineTo(0.5 * (double)n2, 0.3 * (double)n3);
                generalPath.closePath();
                graphics2D.setPaint(new LinearGradientPaint(new Point2D.Double(0.5066666666666667 * (double)n2, 0.22666666666666666 * (double)n3), new Point2D.Double(0.5066666666666667 * (double)n2, 0.8666666666666667 * (double)n3), new float[]{0.0f, 1.0f}, new Color[]{this.getPointerColor().LIGHT, this.getPointerColor().MEDIUM}));
                graphics2D.fill(generalPath);
                graphics2D.setColor(this.getPointerColor().DARK);
                graphics2D.setStroke(new BasicStroke(0.006666667f * (float)n2, 0, 1));
                graphics2D.draw(generalPath);
                break;
            }
            case TYPE12: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo(0.5 * (double)n2, 0.3 * (double)n3);
                generalPath.lineTo(0.4866666666666667 * (double)n2, 0.7333333333333333 * (double)n3);
                generalPath.lineTo(0.5 * (double)n2, 0.7466666666666667 * (double)n3);
                generalPath.lineTo(0.5133333333333333 * (double)n2, 0.7333333333333333 * (double)n3);
                generalPath.lineTo(0.5 * (double)n2, 0.3 * (double)n3);
                generalPath.closePath();
                graphics2D.setPaint(new LinearGradientPaint(new Point2D.Double(0.5066666666666667 * (double)n2, 0.22666666666666666 * (double)n3), new Point2D.Double(0.5066666666666667 * (double)n2, 0.7466666666666667 * (double)n3), new float[]{0.0f, 1.0f}, new Color[]{this.getPointerColor().LIGHT, this.getPointerColor().MEDIUM}));
                graphics2D.fill(generalPath);
                graphics2D.setPaint(this.getPointerColor().DARK);
                graphics2D.setStroke(new BasicStroke(0.006666667f * (float)n2, 0, 1));
                graphics2D.draw(generalPath);
                break;
            }
            case TYPE13: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo(0.4866666666666667 * (double)n2, 0.32666666666666666 * (double)n3);
                generalPath.lineTo(0.5 * (double)n2, 0.29333333333333333 * (double)n3);
                generalPath.lineTo(0.5133333333333333 * (double)n2, 0.32666666666666666 * (double)n3);
                generalPath.lineTo(0.5133333333333333 * (double)n2, 0.7466666666666667 * (double)n3);
                generalPath.lineTo(0.4866666666666667 * (double)n2, 0.7466666666666667 * (double)n3);
                generalPath.lineTo(0.4866666666666667 * (double)n2, 0.32666666666666666 * (double)n3);
                generalPath.closePath();
                graphics2D.setPaint(new LinearGradientPaint(new Point2D.Double(0.5 * (double)n2, 0.7333333333333333 * (double)n3), new Point2D.Double(0.5 * (double)n2, 0.29333333333333333 * (double)n3), new float[]{0.0f, 0.849999f, 0.85f, 1.0f}, new Color[]{this.getPointerColor().MEDIUM, this.getPointerColor().MEDIUM, this.getBackgroundColor().LABEL_COLOR, this.getBackgroundColor().LABEL_COLOR}));
                graphics2D.fill(generalPath);
                break;
            }
            case TYPE14: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo(0.4866666666666667 * (double)n2, 0.32666666666666666 * (double)n3);
                generalPath.lineTo(0.5 * (double)n2, 0.29333333333333333 * (double)n3);
                generalPath.lineTo(0.5133333333333333 * (double)n2, 0.32666666666666666 * (double)n3);
                generalPath.lineTo(0.5133333333333333 * (double)n2, 0.7466666666666667 * (double)n3);
                generalPath.lineTo(0.4866666666666667 * (double)n2, 0.7466666666666667 * (double)n3);
                generalPath.lineTo(0.4866666666666667 * (double)n2, 0.32666666666666666 * (double)n3);
                generalPath.closePath();
                graphics2D.setPaint(new LinearGradientPaint(new Point2D.Double(0.4866666666666667 * (double)n2, 0.64 * (double)n3), new Point2D.Double(0.5066666666666667 * (double)n2, 0.64 * (double)n3), new float[]{0.0f, 0.5f, 1.0f}, new Color[]{this.getPointerColor().VERY_DARK, this.getPointerColor().LIGHT, this.getPointerColor().VERY_DARK}));
                graphics2D.fill(generalPath);
                break;
            }
            default: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.705607476635514);
                generalPath.curveTo((double)n2 * 0.514018691588785, (double)n3 * 0.6915887850467289, (double)n2 * 0.5093457943925234, (double)n3 * 0.6261682242990654, (double)n2 * 0.5093457943925234, (double)n3 * 0.6121495327102804);
                generalPath.curveTo((double)n2 * 0.5046728971962616, (double)n3 * 0.5981308411214953, (double)n2 * 0.5, (double)n3 * 0.29906542056074764, (double)n2 * 0.5, (double)n3 * 0.29906542056074764);
                generalPath.curveTo((double)n2 * 0.5, (double)n3 * 0.29906542056074764, (double)n2 * 0.49065420560747663, (double)n3 * 0.5981308411214953, (double)n2 * 0.49065420560747663, (double)n3 * 0.6121495327102804);
                generalPath.curveTo((double)n2 * 0.49065420560747663, (double)n3 * 0.6308411214953271, (double)n2 * 0.48598130841121495, (double)n3 * 0.6915887850467289, (double)n2 * 0.48130841121495327, (double)n3 * 0.705607476635514);
                generalPath.curveTo((double)n2 * 0.4719626168224299, (double)n3 * 0.7149532710280374, (double)n2 * 0.4672897196261682, (double)n3 * 0.7242990654205608, (double)n2 * 0.4672897196261682, (double)n3 * 0.7336448598130841);
                generalPath.curveTo((double)n2 * 0.4672897196261682, (double)n3 * 0.7523364485981309, (double)n2 * 0.48130841121495327, (double)n3 * 0.7663551401869159, (double)n2 * 0.5, (double)n3 * 0.7663551401869159);
                generalPath.curveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.7663551401869159, (double)n2 * 0.5327102803738317, (double)n3 * 0.7523364485981309, (double)n2 * 0.5327102803738317, (double)n3 * 0.7336448598130841);
                generalPath.curveTo((double)n2 * 0.5327102803738317, (double)n3 * 0.7242990654205608, (double)n2 * 0.5280373831775701, (double)n3 * 0.7149532710280374, (double)n2 * 0.5186915887850467, (double)n3 * 0.705607476635514);
                generalPath.closePath();
                Point2D.Double double_ = new Point2D.Double(0.0, generalPath.getBounds2D().getMinY());
                Point2D.Double double_10 = new Point2D.Double(0.0, generalPath.getBounds2D().getMaxY());
                float[] fArray = new float[]{0.0f, 0.3f, 0.59f, 1.0f};
                Color[] colorArray = this.getPointerColor() != ColorDef.CUSTOM ? new Color[]{this.getPointerColor().DARK, this.getPointerColor().LIGHT, this.getPointerColor().LIGHT, this.getPointerColor().DARK} : new Color[]{customColorDef.DARK, customColorDef.LIGHT, customColorDef.LIGHT, customColorDef.DARK};
                LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_10, fArray, colorArray);
                graphics2D.setPaint(linearGradientPaint);
                graphics2D.fill(generalPath);
                Color color = this.getPointerColor().LIGHT;
                graphics2D.setColor(color);
                graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
                graphics2D.draw(generalPath);
            }
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    protected BufferedImage create_POINTER_SHADOW_Image(int n, PointerType pointerType) {
        if (n <= 0) {
            return null;
        }
        Color color = new Color(0.0f, 0.0f, 0.0f, 0.65f);
        BufferedImage bufferedImage = UTIL.createImage(n, n, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        switch (pointerType) {
            case TYPE1: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.705607476635514);
                generalPath.curveTo((double)n2 * 0.514018691588785, (double)n3 * 0.6915887850467289, (double)n2 * 0.5093457943925234, (double)n3 * 0.6261682242990654, (double)n2 * 0.5093457943925234, (double)n3 * 0.6121495327102804);
                generalPath.curveTo((double)n2 * 0.5046728971962616, (double)n3 * 0.5981308411214953, (double)n2 * 0.5, (double)n3 * 0.29906542056074764, (double)n2 * 0.5, (double)n3 * 0.29906542056074764);
                generalPath.curveTo((double)n2 * 0.5, (double)n3 * 0.29906542056074764, (double)n2 * 0.49065420560747663, (double)n3 * 0.5981308411214953, (double)n2 * 0.49065420560747663, (double)n3 * 0.6121495327102804);
                generalPath.curveTo((double)n2 * 0.49065420560747663, (double)n3 * 0.6308411214953271, (double)n2 * 0.48598130841121495, (double)n3 * 0.6915887850467289, (double)n2 * 0.48130841121495327, (double)n3 * 0.705607476635514);
                generalPath.curveTo((double)n2 * 0.4719626168224299, (double)n3 * 0.7149532710280374, (double)n2 * 0.4672897196261682, (double)n3 * 0.7242990654205608, (double)n2 * 0.4672897196261682, (double)n3 * 0.7336448598130841);
                generalPath.curveTo((double)n2 * 0.4672897196261682, (double)n3 * 0.7523364485981309, (double)n2 * 0.48130841121495327, (double)n3 * 0.7663551401869159, (double)n2 * 0.5, (double)n3 * 0.7663551401869159);
                generalPath.curveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.7663551401869159, (double)n2 * 0.5327102803738317, (double)n3 * 0.7523364485981309, (double)n2 * 0.5327102803738317, (double)n3 * 0.7336448598130841);
                generalPath.curveTo((double)n2 * 0.5327102803738317, (double)n3 * 0.7242990654205608, (double)n2 * 0.5280373831775701, (double)n3 * 0.7149532710280374, (double)n2 * 0.5186915887850467, (double)n3 * 0.705607476635514);
                generalPath.closePath();
                graphics2D.setColor(color);
                graphics2D.fill(generalPath);
                break;
            }
            case TYPE2: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.705607476635514);
                generalPath.lineTo((double)n2 * 0.5093457943925234, (double)n3 * 0.6962616822429907);
                generalPath.lineTo((double)n2 * 0.5093457943925234, (double)n3 * 0.5747663551401869);
                generalPath.lineTo((double)n2 * 0.5046728971962616, (double)n3 * 0.2897196261682243);
                generalPath.lineTo((double)n2 * 0.4953271028037383, (double)n3 * 0.2897196261682243);
                generalPath.lineTo((double)n2 * 0.49065420560747663, (double)n3 * 0.5747663551401869);
                generalPath.lineTo((double)n2 * 0.49065420560747663, (double)n3 * 0.6962616822429907);
                generalPath.lineTo((double)n2 * 0.48130841121495327, (double)n3 * 0.705607476635514);
                generalPath.curveTo((double)n2 * 0.48130841121495327, (double)n3 * 0.705607476635514, (double)n2 * 0.4672897196261682, (double)n3 * 0.7242990654205608, (double)n2 * 0.4672897196261682, (double)n3 * 0.7336448598130841);
                generalPath.curveTo((double)n2 * 0.4672897196261682, (double)n3 * 0.7523364485981309, (double)n2 * 0.48130841121495327, (double)n3 * 0.7663551401869159, (double)n2 * 0.5, (double)n3 * 0.7663551401869159);
                generalPath.curveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.7663551401869159, (double)n2 * 0.5327102803738317, (double)n3 * 0.7523364485981309, (double)n2 * 0.5327102803738317, (double)n3 * 0.7336448598130841);
                generalPath.curveTo((double)n2 * 0.5327102803738317, (double)n3 * 0.7242990654205608, (double)n2 * 0.5186915887850467, (double)n3 * 0.705607476635514, (double)n2 * 0.5186915887850467, (double)n3 * 0.705607476635514);
                generalPath.closePath();
                graphics2D.setColor(color);
                graphics2D.fill(generalPath);
                break;
            }
            case TYPE3: {
                break;
            }
            case TYPE4: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.5, (double)n3 * 0.29439252336448596);
                generalPath.lineTo((double)n2 * 0.514018691588785, (double)n3 * 0.3037383177570093);
                generalPath.lineTo((double)n2 * 0.5327102803738317, (double)n3 * 0.7336448598130841);
                generalPath.lineTo((double)n2 * 0.5233644859813084, (double)n3 * 0.8364485981308412);
                generalPath.lineTo((double)n2 * 0.4766355140186916, (double)n3 * 0.8364485981308412);
                generalPath.lineTo((double)n2 * 0.4672897196261682, (double)n3 * 0.7336448598130841);
                generalPath.lineTo((double)n2 * 0.49065420560747663, (double)n3 * 0.3037383177570093);
                generalPath.lineTo((double)n2 * 0.5, (double)n3 * 0.29439252336448596);
                generalPath.closePath();
                graphics2D.setColor(color);
                graphics2D.fill(generalPath);
                break;
            }
            case TYPE5: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.5, (double)n3 * 0.74);
                generalPath.lineTo((double)n2 * 0.5266666666666666, (double)n3 * 0.74);
                generalPath.lineTo((double)n2 * 0.5, (double)n3 * 0.3);
                generalPath.lineTo((double)n2 * 0.47333333333333333, (double)n3 * 0.74);
                generalPath.lineTo((double)n2 * 0.5, (double)n3 * 0.74);
                generalPath.closePath();
                graphics2D.setColor(color);
                graphics2D.fill(generalPath);
                break;
            }
            case TYPE6: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.47333333333333333, (double)n3 * 0.7333333333333333);
                generalPath.lineTo((double)n2 * 0.47333333333333333, (double)n3 * 0.6);
                generalPath.lineTo((double)n2 * 0.48, (double)n3 * 0.49333333333333335);
                generalPath.lineTo((double)n2 * 0.49333333333333335, (double)n3 * 0.30666666666666664);
                generalPath.lineTo((double)n2 * 0.5, (double)n3 * 0.30666666666666664);
                generalPath.lineTo((double)n2 * 0.5066666666666667, (double)n3 * 0.30666666666666664);
                generalPath.lineTo((double)n2 * 0.52, (double)n3 * 0.49333333333333335);
                generalPath.lineTo((double)n2 * 0.5266666666666666, (double)n3 * 0.5933333333333334);
                generalPath.lineTo((double)n2 * 0.5266666666666666, (double)n3 * 0.7333333333333333);
                generalPath.lineTo((double)n2 * 0.5066666666666667, (double)n3 * 0.7333333333333333);
                generalPath.lineTo((double)n2 * 0.5066666666666667, (double)n3 * 0.5933333333333334);
                generalPath.lineTo((double)n2 * 0.5, (double)n3 * 0.49333333333333335);
                generalPath.lineTo((double)n2 * 0.49333333333333335, (double)n3 * 0.6);
                generalPath.lineTo((double)n2 * 0.49333333333333335, (double)n3 * 0.7333333333333333);
                generalPath.lineTo((double)n2 * 0.47333333333333333, (double)n3 * 0.7333333333333333);
                generalPath.closePath();
                graphics2D.setColor(color);
                graphics2D.fill(generalPath);
                break;
            }
            case TYPE7: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.4866666666666667, (double)n3 * 0.30666666666666664);
                generalPath.lineTo((double)n2 * 0.47333333333333333, (double)n3 * 0.7333333333333333);
                generalPath.lineTo((double)n2 * 0.5266666666666666, (double)n3 * 0.7333333333333333);
                generalPath.lineTo((double)n2 * 0.5066666666666667, (double)n3 * 0.30666666666666664);
                generalPath.lineTo((double)n2 * 0.4866666666666667, (double)n3 * 0.30666666666666664);
                generalPath.closePath();
                graphics2D.setColor(color);
                graphics2D.fill(generalPath);
                break;
            }
            case TYPE8: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.5, (double)n3 * 0.7666666666666667);
                generalPath.lineTo((double)n2 * 0.5333333333333333, (double)n3 * 0.7333333333333333);
                generalPath.curveTo((double)n2 * 0.5333333333333333, (double)n3 * 0.7333333333333333, (double)n2 * 0.5066666666666667, (double)n3 * 0.7066666666666667, (double)n2 * 0.5, (double)n3 * 0.31333333333333335);
                generalPath.curveTo((double)n2 * 0.49333333333333335, (double)n3 * 0.7066666666666667, (double)n2 * 0.4666666666666667, (double)n3 * 0.7333333333333333, (double)n2 * 0.4666666666666667, (double)n3 * 0.7333333333333333);
                generalPath.lineTo((double)n2 * 0.5, (double)n3 * 0.7666666666666667);
                generalPath.closePath();
                graphics2D.setColor(color);
                graphics2D.fill(generalPath);
                break;
            }
            case TYPE9: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.49333333333333335, (double)n3 * 0.42);
                generalPath.lineTo((double)n2 * 0.5066666666666667, (double)n3 * 0.42);
                generalPath.lineTo((double)n2 * 0.5133333333333333, (double)n3 * 0.66);
                generalPath.lineTo((double)n2 * 0.4866666666666667, (double)n3 * 0.66);
                generalPath.lineTo((double)n2 * 0.49333333333333335, (double)n3 * 0.42);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.49333333333333335, (double)n3 * 0.3);
                generalPath.lineTo((double)n2 * 0.47333333333333333, (double)n3 * 0.7);
                generalPath.lineTo((double)n2 * 0.47333333333333333, (double)n3 * 0.7666666666666667);
                generalPath.curveTo((double)n2 * 0.47333333333333333, (double)n3 * 0.7666666666666667, (double)n2 * 0.47333333333333333, (double)n3 * 0.8533333333333334, (double)n2 * 0.47333333333333333, (double)n3 * 0.8533333333333334);
                generalPath.curveTo((double)n2 * 0.47333333333333333, (double)n3 * 0.86, (double)n2 * 0.48, (double)n3 * 0.86, (double)n2 * 0.5, (double)n3 * 0.86);
                generalPath.curveTo((double)n2 * 0.52, (double)n3 * 0.86, (double)n2 * 0.5266666666666666, (double)n3 * 0.86, (double)n2 * 0.5266666666666666, (double)n3 * 0.8533333333333334);
                generalPath.curveTo((double)n2 * 0.5266666666666666, (double)n3 * 0.8533333333333334, (double)n2 * 0.5266666666666666, (double)n3 * 0.7666666666666667, (double)n2 * 0.5266666666666666, (double)n3 * 0.7666666666666667);
                generalPath.lineTo((double)n2 * 0.5266666666666666, (double)n3 * 0.7);
                generalPath.lineTo((double)n2 * 0.5066666666666667, (double)n3 * 0.3);
                generalPath.lineTo((double)n2 * 0.49333333333333335, (double)n3 * 0.3);
                generalPath.closePath();
                graphics2D.setColor(color);
                graphics2D.fill(generalPath);
                break;
            }
            case TYPE10: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.5, (double)n3 * 0.3);
                generalPath.curveTo((double)n2 * 0.5, (double)n3 * 0.3, (double)n2 * 0.43333333333333335, (double)n3 * 0.7133333333333334, (double)n2 * 0.43333333333333335, (double)n3 * 0.7266666666666667);
                generalPath.curveTo((double)n2 * 0.43333333333333335, (double)n3 * 0.76, (double)n2 * 0.46, (double)n3 * 0.7933333333333333, (double)n2 * 0.5, (double)n3 * 0.7933333333333333);
                generalPath.curveTo((double)n2 * 0.54, (double)n3 * 0.7933333333333333, (double)n2 * 0.5666666666666667, (double)n3 * 0.76, (double)n2 * 0.5666666666666667, (double)n3 * 0.7266666666666667);
                generalPath.curveTo((double)n2 * 0.5666666666666667, (double)n3 * 0.7133333333333334, (double)n2 * 0.5, (double)n3 * 0.3, (double)n2 * 0.5, (double)n3 * 0.3);
                generalPath.closePath();
                graphics2D.setColor(color);
                graphics2D.fill(generalPath);
                break;
            }
            case TYPE11: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo(0.5 * (double)n2, 0.3 * (double)n3);
                generalPath.lineTo(0.4866666666666667 * (double)n2, 0.7333333333333333 * (double)n3);
                generalPath.curveTo(0.4866666666666667 * (double)n2, 0.7333333333333333 * (double)n3, 0.4866666666666667 * (double)n2, 0.8066666666666666 * (double)n3, 0.5 * (double)n2, 0.8066666666666666 * (double)n3);
                generalPath.curveTo(0.5133333333333333 * (double)n2, 0.8066666666666666 * (double)n3, 0.5133333333333333 * (double)n2, 0.7333333333333333 * (double)n3, 0.5133333333333333 * (double)n2, 0.7333333333333333 * (double)n3);
                generalPath.lineTo(0.5 * (double)n2, 0.3 * (double)n3);
                generalPath.closePath();
                graphics2D.setColor(color);
                graphics2D.fill(generalPath);
                break;
            }
            case TYPE12: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo(0.5 * (double)n2, 0.3 * (double)n3);
                generalPath.lineTo(0.4866666666666667 * (double)n2, 0.7333333333333333 * (double)n3);
                generalPath.lineTo(0.5 * (double)n2, 0.7466666666666667 * (double)n3);
                generalPath.lineTo(0.5133333333333333 * (double)n2, 0.7333333333333333 * (double)n3);
                generalPath.lineTo(0.5 * (double)n2, 0.3 * (double)n3);
                generalPath.closePath();
                graphics2D.setColor(color);
                graphics2D.fill(generalPath);
                break;
            }
            case TYPE13: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo(0.4866666666666667 * (double)n2, 0.32666666666666666 * (double)n3);
                generalPath.lineTo(0.5 * (double)n2, 0.29333333333333333 * (double)n3);
                generalPath.lineTo(0.5133333333333333 * (double)n2, 0.32666666666666666 * (double)n3);
                generalPath.lineTo(0.5133333333333333 * (double)n2, 0.7466666666666667 * (double)n3);
                generalPath.lineTo(0.4866666666666667 * (double)n2, 0.7466666666666667 * (double)n3);
                generalPath.lineTo(0.4866666666666667 * (double)n2, 0.32666666666666666 * (double)n3);
                generalPath.closePath();
                graphics2D.setColor(color);
                graphics2D.fill(generalPath);
                break;
            }
            case TYPE14: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo(0.4866666666666667 * (double)n2, 0.32666666666666666 * (double)n3);
                generalPath.lineTo(0.5 * (double)n2, 0.29333333333333333 * (double)n3);
                generalPath.lineTo(0.5133333333333333 * (double)n2, 0.32666666666666666 * (double)n3);
                generalPath.lineTo(0.5133333333333333 * (double)n2, 0.7466666666666667 * (double)n3);
                generalPath.lineTo(0.4866666666666667 * (double)n2, 0.7466666666666667 * (double)n3);
                generalPath.lineTo(0.4866666666666667 * (double)n2, 0.32666666666666666 * (double)n3);
                generalPath.closePath();
                graphics2D.setColor(color);
                graphics2D.fill(generalPath);
            }
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    public String toString() {
        return "Radial1Vertical";
    }
}

