/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.gauges;

import eu.hansolo.steelseries.gauges.AbstractGauge;
import eu.hansolo.steelseries.gauges.AbstractRadial;
import eu.hansolo.steelseries.tools.BackgroundColor;
import eu.hansolo.steelseries.tools.ConicalGradientPaint;
import eu.hansolo.steelseries.tools.FrameDesign;
import eu.hansolo.steelseries.tools.FrameType;
import eu.hansolo.steelseries.tools.GaugeType;
import eu.hansolo.steelseries.tools.GradientWrapper;
import eu.hansolo.steelseries.tools.Model;
import eu.hansolo.steelseries.tools.Orientation;
import eu.hansolo.steelseries.tools.Scaler;
import eu.hansolo.steelseries.tools.Section;
import eu.hansolo.steelseries.tools.Shadow;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.Random;

public final class Radial2Top
extends AbstractRadial {
    private static final int BASE = 10;
    private final double FREE_AREA_ANGLE = Math.toRadians(0.0);
    private final double ROTATION_OFFSET = 4.71238898038469 + this.FREE_AREA_ANGLE / 2.0;
    private final Point2D CENTER;
    private final Point2D TRACK_OFFSET;
    private BufferedImage bImage;
    private BufferedImage fImage;
    private BufferedImage glowImageOff;
    private BufferedImage glowImageOn;
    private BufferedImage pointerImage;
    private BufferedImage pointerShadowImage;
    private BufferedImage thresholdImage;
    private BufferedImage minMeasuredImage;
    private BufferedImage maxMeasuredImage;
    private BufferedImage disabledImage;
    private boolean section3DEffectVisible;
    private RadialGradientPaint section3DEffect;
    private boolean area3DEffectVisible;
    private RadialGradientPaint area3DEffect;
    private double angle = 0.0;
    private final Color DARK_NOISE;
    private final Color BRIGHT_NOISE;

    public Radial2Top() {
        this.CENTER = new Point2D.Double();
        this.TRACK_OFFSET = new Point2D.Double();
        this.DARK_NOISE = new Color(0.2f, 0.2f, 0.2f);
        this.BRIGHT_NOISE = new Color(0.8f, 0.8f, 0.8f);
        this.section3DEffectVisible = false;
        this.area3DEffectVisible = false;
        this.setGaugeType(GaugeType.TYPE2);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    public Radial2Top(Model model) {
        this.setModel(model);
        this.CENTER = new Point2D.Double();
        this.TRACK_OFFSET = new Point2D.Double();
        this.DARK_NOISE = new Color(0.2f, 0.2f, 0.2f);
        this.BRIGHT_NOISE = new Color(0.8f, 0.8f, 0.8f);
        this.section3DEffectVisible = false;
        this.area3DEffectVisible = false;
        this.setGaugeType(GaugeType.TYPE2);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public final AbstractGauge init(int n, int n2) {
        int n3;
        int n4 = this.isFrameVisible() ? n : this.getGaugeBounds().width;
        int n5 = n3 = this.isFrameVisible() ? n2 : this.getGaugeBounds().height;
        if (n4 <= 1 || n3 <= 1) {
            return this;
        }
        if (!this.isFrameVisible()) {
            this.setFramelessOffset((double)(-this.getGaugeBounds().width) * 0.0841121495, (double)(-this.getGaugeBounds().width) * 0.0841121495);
        } else {
            this.setFramelessOffset(this.getGaugeBounds().x, this.getGaugeBounds().y);
        }
        if (this.bImage != null) {
            this.bImage.flush();
        }
        this.bImage = UTIL.createImage(n4, n4, 3);
        if (this.fImage != null) {
            this.fImage.flush();
        }
        this.fImage = UTIL.createImage(n4, n4, 3);
        if (this.isFrameVisible()) {
            this.create_FRAME_Image(n4, this.bImage);
        }
        if (this.isBackgroundVisible()) {
            this.create_BACKGROUND_Image(n4, "", "", this.bImage);
        }
        if (this.isGlowVisible()) {
            if (this.glowImageOff != null) {
                this.glowImageOff.flush();
            }
            this.glowImageOff = this.create_GLOW_Image(n4, this.getGlowColor(), false);
            if (this.glowImageOn != null) {
                this.glowImageOn.flush();
            }
            this.glowImageOn = this.create_GLOW_Image(n4, this.getGlowColor(), true);
        } else {
            this.setGlowPulsating(false);
        }
        this.create_POSTS_Image(n4, this.fImage);
        this.TRACK_OFFSET.setLocation(0.0, 0.0);
        this.CENTER.setLocation(this.getGaugeBounds().getCenterX() - (double)this.getInsets().left, this.getGaugeBounds().getCenterX() - (double)this.getInsets().top);
        if (this.isTrackVisible()) {
            this.create_TRACK_Image(n4, this.getFreeAreaAngle(), this.getTickmarkOffset(), this.getMinValue(), this.getMaxValue(), this.getAngleStep(), this.getTrackStart(), this.getTrackSection(), this.getTrackStop(), this.getTrackStartColor(), this.getTrackSectionColor(), this.getTrackStopColor(), 0.38f, this.CENTER, this.getTickmarkDirection(), this.TRACK_OFFSET, this.bImage);
        }
        if (!this.getAreas().isEmpty()) {
            if (this.area3DEffectVisible) {
                this.area3DEffect = this.createArea3DEffectGradient(n4, 0.38f);
            }
            this.createAreas(this.bImage);
        }
        if (!this.getSections().isEmpty()) {
            if (this.section3DEffectVisible) {
                this.section3DEffect = this.createSection3DEffectGradient(n4, 0.38f);
            }
            this.createSections(this.bImage);
        }
        TICKMARK_FACTORY.create_RADIAL_TICKMARKS_Image(n4, this.getModel().getNiceMinValue(), this.getModel().getNiceMaxValue(), this.getModel().getMaxNoOfMinorTicks(), this.getModel().getMaxNoOfMajorTicks(), this.getModel().getMinorTickSpacing(), this.getModel().getMajorTickSpacing(), this.getGaugeType(), this.getMinorTickmarkType(), this.getMajorTickmarkType(), this.isTickmarksVisible(), this.isTicklabelsVisible(), this.getModel().isMinorTickmarksVisible(), this.getModel().isMajorTickmarksVisible(), this.getLabelNumberFormat(), this.isTickmarkSectionsVisible(), this.getBackgroundColor(), this.getTickmarkColor(), this.isTickmarkColorFromThemeEnabled(), this.getTickmarkSections(), 0.38f, 0.09f, this.CENTER, new Point2D.Double(0.0, 0.0), Orientation.NORTH, this.getModel().getTicklabelOrientation(), this.getModel().isNiceScale(), this.getModel().isLogScale(), this.bImage);
        this.create_TITLE_Image(n4, this.getTitle(), this.getUnitString(), this.bImage);
        if (this.pointerImage != null) {
            this.pointerImage.flush();
        }
        this.pointerImage = this.create_POINTER_Image(n4, this.getPointerType());
        if (this.pointerShadowImage != null) {
            this.pointerShadowImage.flush();
        }
        this.pointerShadowImage = this.getModel().isPointerShadowVisible() ? this.create_POINTER_SHADOW_Image(n4, this.getPointerType()) : null;
        if (this.isForegroundVisible()) {
            FOREGROUND_FACTORY.createRadialForeground(n4, false, this.getForegroundType(), this.fImage);
        }
        if (this.thresholdImage != null) {
            this.thresholdImage.flush();
        }
        this.thresholdImage = this.create_THRESHOLD_Image(n4);
        if (this.minMeasuredImage != null) {
            this.minMeasuredImage.flush();
        }
        this.minMeasuredImage = this.create_MEASURED_VALUE_Image(n4, new Color(0, 23, 252, 255));
        if (this.maxMeasuredImage != null) {
            this.maxMeasuredImage.flush();
        }
        this.maxMeasuredImage = this.create_MEASURED_VALUE_Image(n4, new Color(252, 29, 0, 255));
        if (this.disabledImage != null) {
            this.disabledImage.flush();
        }
        this.disabledImage = this.create_DISABLED_Image(n4);
        this.setCurrentLedImage(this.getLedImageOff());
        return this;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (!this.isInitialized()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.translate(this.getFramelessOffset().getX(), this.getFramelessOffset().getY());
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.drawImage((Image)this.bImage, 0, 0, null);
        if (this.isHighlightArea()) {
            for (Section section : this.getAreas()) {
                if (!section.contains(this.getValue())) continue;
                graphics2D.setColor(section.getHighlightColor());
                graphics2D.fill(section.getFilledArea());
                break;
            }
        }
        if (this.isHighlightSection()) {
            for (Section section : this.getSections()) {
                if (!section.contains(this.getValue())) continue;
                graphics2D.setColor(section.getHighlightColor());
                graphics2D.fill(section.getSectionArea());
                break;
            }
        }
        if (this.isThresholdVisible()) {
            if (!this.isLogScale()) {
                graphics2D.rotate(this.ROTATION_OFFSET + (this.getThreshold() - this.getMinValue()) * this.getAngleStep(), this.CENTER.getX(), this.CENTER.getY());
            } else {
                graphics2D.rotate(this.ROTATION_OFFSET + UTIL.logOfBase(10.0, this.getThreshold() - this.getMinValue()) * this.getLogAngleStep(), this.CENTER.getX(), this.CENTER.getY());
            }
            graphics2D.drawImage((Image)this.thresholdImage, (int)((double)this.getGaugeBounds().width * 0.480369999), (int)((double)this.getGaugeBounds().height * 0.13), null);
            graphics2D.setTransform(affineTransform);
        }
        if (this.isMinMeasuredValueVisible()) {
            if (!this.isLogScale()) {
                graphics2D.rotate(this.ROTATION_OFFSET + (this.getMinMeasuredValue() - this.getMinValue()) * this.getAngleStep(), this.CENTER.getX(), this.CENTER.getY());
            } else {
                graphics2D.rotate(this.ROTATION_OFFSET + UTIL.logOfBase(10.0, this.getMinMeasuredValue() - this.getMinValue()) * this.getLogAngleStep(), this.CENTER.getX(), this.CENTER.getY());
            }
            graphics2D.drawImage((Image)this.minMeasuredImage, (int)((double)this.getGaugeBounds().width * 0.4865), (int)((double)this.getGaugeBounds().height * 0.105), null);
            graphics2D.setTransform(affineTransform);
        }
        if (this.isMaxMeasuredValueVisible()) {
            if (!this.isLogScale()) {
                graphics2D.rotate(this.ROTATION_OFFSET + (this.getMaxMeasuredValue() - this.getMinValue()) * this.getAngleStep(), this.CENTER.getX(), this.CENTER.getY());
            } else {
                graphics2D.rotate(this.ROTATION_OFFSET + UTIL.logOfBase(10.0, this.getMaxMeasuredValue() - this.getMinValue()) * this.getLogAngleStep(), this.CENTER.getX(), this.CENTER.getY());
            }
            graphics2D.drawImage((Image)this.maxMeasuredImage, (int)((double)this.getGaugeBounds().width * 0.4865), (int)((double)this.getGaugeBounds().height * 0.105), null);
            graphics2D.setTransform(affineTransform);
        }
        if (this.isLedVisible()) {
            graphics2D.drawImage((Image)this.getCurrentLedImage(), (int)((double)this.getGaugeBounds().width * this.getLedPosition().getX()), (int)((double)this.getGaugeBounds().height * this.getLedPosition().getY()), null);
        }
        if (this.isUserLedVisible()) {
            graphics2D.drawImage((Image)this.getCurrentUserLedImage(), (int)((double)this.getGaugeBounds().width * this.getUserLedPosition().getX()), (int)((double)this.getGaugeBounds().height * this.getUserLedPosition().getY()), null);
        }
        this.angle = !this.isLogScale() ? this.ROTATION_OFFSET + (this.getValue() - this.getMinValue()) * this.getAngleStep() : this.ROTATION_OFFSET + UTIL.logOfBase(10.0, this.getValue() - this.getMinValue()) * this.getLogAngleStep();
        graphics2D.rotate(this.angle, this.CENTER.getX(), this.CENTER.getY() + 2.0);
        graphics2D.drawImage((Image)this.pointerShadowImage, 0, 0, null);
        graphics2D.setTransform(affineTransform);
        graphics2D.rotate(this.angle, this.CENTER.getX(), this.CENTER.getY());
        graphics2D.drawImage((Image)this.pointerImage, 0, 0, null);
        graphics2D.setTransform(affineTransform);
        graphics2D.drawImage((Image)this.fImage, 0, 0, null);
        if (this.isGlowVisible()) {
            if (this.isGlowing()) {
                graphics2D.setComposite(AlphaComposite.getInstance(3, this.getGlowAlpha()));
                graphics2D.drawImage((Image)this.glowImageOn, 0, 0, null);
                graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
            } else {
                graphics2D.drawImage((Image)this.glowImageOff, 0, 0, null);
            }
        }
        if (!this.isEnabled()) {
            graphics2D.drawImage((Image)this.disabledImage, 0, 0, null);
        }
        graphics2D.dispose();
    }

    @Override
    public FrameType getFrameType() {
        return FrameType.ROUND;
    }

    @Override
    public GaugeType getGaugeType() {
        return GaugeType.TYPE2;
    }

    @Override
    public void setGaugeType(GaugeType gaugeType) {
        super.setGaugeType(GaugeType.TYPE2);
    }

    @Override
    public Point2D getCenter() {
        return new Point2D.Double((double)this.bImage.getWidth() / 2.0 + (double)this.getInnerBounds().x, (double)this.bImage.getHeight() / 2.0 + (double)this.getInnerBounds().y);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return new Rectangle2D.Double(this.bImage.getMinX(), this.bImage.getMinY(), this.bImage.getWidth(), this.bImage.getHeight());
    }

    @Override
    public Rectangle getLcdBounds() {
        return new Rectangle();
    }

    public boolean isSection3DEffectVisible() {
        return this.section3DEffectVisible;
    }

    public void setSection3DEffectVisible(boolean bl) {
        this.section3DEffectVisible = bl;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public boolean isArea3DEffectVisible() {
        return this.area3DEffectVisible;
    }

    public void setArea3DEffectVisible(boolean bl) {
        this.area3DEffectVisible = bl;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    private void createAreas(BufferedImage bufferedImage) {
        if (!this.getAreas().isEmpty() && this.bImage != null) {
            double d = (float)this.bImage.getWidth() * 0.38f;
            double d2 = this.isSectionsVisible() ? (this.isExpandedSectionsEnabled() ? d - (double)((float)this.bImage.getWidth() * 0.12f) : d - (double)((float)this.bImage.getWidth() * 0.04f)) : d;
            double d3 = (double)this.bImage.getWidth() / 2.0 - d2;
            for (Section object : this.getAreas()) {
                double d4;
                double d5;
                if (!this.isLogScale()) {
                    d5 = 180.0 - object.getStart() * Math.toDegrees(this.getAngleStep());
                    d4 = -(object.getStop() - object.getStart()) * Math.toDegrees(this.getAngleStep());
                } else {
                    d5 = 180.0 - UTIL.logOfBase(10.0, object.getStart()) * Math.toDegrees(this.getLogAngleStep());
                    d4 = -UTIL.logOfBase(10.0, object.getStop() - object.getStart()) * Math.toDegrees(this.getLogAngleStep());
                }
                Arc2D.Double double_ = new Arc2D.Double(2);
                double_.setFrame((double)this.bImage.getMinX() + d3, (double)this.bImage.getMinY() + d3, 2.0 * d2, 2.0 * d2);
                ((Arc2D)double_).setAngleStart(d5);
                ((Arc2D)double_).setAngleExtent(d4);
                object.setFilledArea(double_);
            }
            if (this.isAreasVisible() && bufferedImage != null) {
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                for (Section section : this.getAreas()) {
                    graphics2D.setColor(this.isTransparentAreasEnabled() ? section.getTransparentColor() : section.getColor());
                    graphics2D.fill(section.getFilledArea());
                    if (!this.area3DEffectVisible) continue;
                    graphics2D.setPaint(this.area3DEffect);
                    graphics2D.fill(section.getFilledArea());
                }
                graphics2D.dispose();
            }
        }
    }

    private void createSections(BufferedImage bufferedImage) {
        if (!this.getSections().isEmpty() && this.bImage != null) {
            double d = (float)this.bImage.getWidth() * 0.38f;
            double d2 = this.isExpandedSectionsEnabled() ? d - (double)((float)this.bImage.getWidth() * 0.12f) : d - (double)((float)this.bImage.getWidth() * 0.04f);
            double d3 = (double)this.bImage.getWidth() / 2.0 - d;
            double d4 = (double)this.bImage.getWidth() / 2.0 - d2;
            Ellipse2D.Double double_ = new Ellipse2D.Double((double)this.bImage.getMinX() + d4, (double)this.bImage.getMinY() + d4, 2.0 * d2, 2.0 * d2);
            for (Section object : this.getSections()) {
                double d5;
                double d6;
                if (!this.isLogScale()) {
                    d6 = 180.0 - object.getStart() * Math.toDegrees(this.getAngleStep());
                    d5 = -(object.getStop() - object.getStart()) * Math.toDegrees(this.getAngleStep());
                } else {
                    d6 = 180.0 - UTIL.logOfBase(10.0, object.getStart()) * Math.toDegrees(this.getLogAngleStep());
                    d5 = -UTIL.logOfBase(10.0, object.getStop() - object.getStart()) * Math.toDegrees(this.getLogAngleStep());
                }
                Arc2D.Double double_2 = new Arc2D.Double(2);
                double_2.setFrame((double)this.bImage.getMinX() + d3, (double)this.bImage.getMinY() + d3, 2.0 * d, 2.0 * d);
                ((Arc2D)double_2).setAngleStart(d6);
                ((Arc2D)double_2).setAngleExtent(d5);
                Area area = new Area(double_2);
                area.subtract(new Area(double_));
                object.setSectionArea(area);
            }
            if (this.isSectionsVisible() && bufferedImage != null) {
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                for (Section section : this.getSections()) {
                    graphics2D.setColor(this.isTransparentSectionsEnabled() ? section.getTransparentColor() : section.getColor());
                    graphics2D.fill(section.getSectionArea());
                    if (!this.section3DEffectVisible) continue;
                    graphics2D.setPaint(this.section3DEffect);
                    graphics2D.fill(section.getSectionArea());
                }
                graphics2D.dispose();
            }
        }
    }

    private BufferedImage create_FRAME_Image(int n, BufferedImage bufferedImage) {
        Object object;
        Cloneable cloneable;
        Object object2;
        Object object3;
        Object[] objectArray;
        Object object4;
        Object[] objectArray2;
        Object object5;
        Object object6;
        Object object7;
        double d;
        if (n <= 0) {
            return null;
        }
        if (bufferedImage == null) {
            bufferedImage = UTIL.createImage(n, (int)(0.641860465116279 * (double)n), 3);
            d = 1.0;
        } else {
            d = 0.641860465116279;
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n2 * 0.08372093023255814, (double)n3 * 0.7753623188405797 * d);
        generalPath.curveTo((double)n2 * 0.08372093023255814, (double)n3 * 0.42028985507246375 * d, (double)n2 * 0.26976744186046514, (double)n3 * 0.13043478260869565 * d, (double)n2 * 0.49767441860465117, (double)n3 * 0.13043478260869565 * d);
        generalPath.curveTo((double)n2 * 0.7255813953488373, (double)n3 * 0.13043478260869565 * d, (double)n2 * 0.9116279069767442, (double)n3 * 0.42028985507246375 * d, (double)n2 * 0.9116279069767442, (double)n3 * 0.7753623188405797 * d);
        generalPath.curveTo((double)n2 * 0.9116279069767442, (double)n3 * 0.8188405797101449 * d, (double)n2 * 0.9069767441860465, (double)n3 * 0.8695652173913043 * d, (double)n2 * 0.9069767441860465, (double)n3 * 0.8695652173913043 * d);
        generalPath.lineTo((double)n2 * 0.08837209302325581, (double)n3 * 0.8695652173913043 * d);
        generalPath.curveTo((double)n2 * 0.08837209302325581, (double)n3 * 0.8695652173913043 * d, (double)n2 * 0.08372093023255814, (double)n3 * 0.8115942028985508 * d, (double)n2 * 0.08372093023255814, (double)n3 * 0.7753623188405797 * d);
        generalPath.closePath();
        Area area = new Area(generalPath);
        GeneralPath generalPath2 = new GeneralPath();
        generalPath2.setWindingRule(0);
        generalPath2.moveTo(0.0, (double)n3 * 0.7753623188405797 * d);
        generalPath2.curveTo(0.0, (double)n3 * 0.34782608695652173 * d, (double)n2 * 0.22325581395348837, 0.0, (double)n2 * 0.49767441860465117, 0.0);
        generalPath2.curveTo((double)n2 * 0.772093023255814, 0.0, (double)n2, (double)n3 * 0.34782608695652173 * d, (double)n2, (double)n3 * 0.7753623188405797 * d);
        generalPath2.curveTo((double)n2, (double)n3 * 0.9057971014492754 * d, (double)n2, (double)n3, (double)n2, (double)n3 * d);
        generalPath2.lineTo(0.0, (double)n3 * d);
        generalPath2.curveTo(0.0, (double)n3 * d, 0.0, (double)n3 * 0.8985507246376812 * d, 0.0, (double)n3 * 0.7753623188405797 * d);
        generalPath2.closePath();
        graphics2D.setPaint(this.getOuterFrameColor());
        Area area2 = new Area(generalPath2);
        area2.subtract(area);
        graphics2D.fill(area2);
        GeneralPath generalPath3 = new GeneralPath();
        generalPath3.setWindingRule(0);
        generalPath3.moveTo((double)n2 * 0.004651162790697674, (double)n3 * 0.7753623188405797 * d);
        generalPath3.curveTo((double)n2 * 0.004651162790697674, (double)n3 * 0.34782608695652173 * d, (double)n2 * 0.22325581395348837, (double)n3 * 0.007246376811594203 * d, (double)n2 * 0.49767441860465117, (double)n3 * 0.007246376811594203 * d);
        generalPath3.curveTo((double)n2 * 0.772093023255814, (double)n3 * 0.007246376811594203 * d, (double)n2 * 0.9953488372093023, (double)n3 * 0.35507246376811596 * d, (double)n2 * 0.9953488372093023, (double)n3 * 0.7753623188405797 * d);
        generalPath3.curveTo((double)n2 * 0.9953488372093023, (double)n3 * 0.8840579710144928 * d, (double)n2 * 0.9953488372093023, (double)n3 * 0.9927536231884058 * d, (double)n2 * 0.9953488372093023, (double)n3 * 0.9927536231884058 * d);
        generalPath3.lineTo((double)n2 * 0.004651162790697674, (double)n3 * 0.9927536231884058 * d);
        generalPath3.curveTo((double)n2 * 0.004651162790697674, (double)n3 * 0.9927536231884058 * d, (double)n2 * 0.004651162790697674, (double)n3 * 0.8840579710144928 * d, (double)n2 * 0.004651162790697674, (double)n3 * 0.7753623188405797 * d);
        generalPath3.closePath();
        Point2D.Double double_ = new Point2D.Double(0.0, generalPath3.getBounds2D().getMinY());
        Point2D.Double double_2 = new Point2D.Double(0.0, generalPath3.getBounds2D().getMaxY());
        Point2D.Double double_3 = new Point2D.Double(generalPath3.getBounds2D().getCenterX(), generalPath3.getBounds2D().getHeight() * 0.7753623188 * d);
        Area area3 = new Area(generalPath3);
        if (this.getFrameDesign() == FrameDesign.CUSTOM) {
            graphics2D.setPaint(this.getCustomFrameDesign());
            area3.subtract(area);
            graphics2D.fill(area3);
        } else {
            switch (this.getFrameDesign()) {
                case BLACK_METAL: {
                    object7 = new float[]{0.0f, 45.0f, 85.0f, 180.0f, 275.0f, 315.0f, 360.0f};
                    object6 = new Color[]{new Color(254, 254, 254, 255), new Color(0, 0, 0, 255), new Color(0, 0, 0, 255), new Color(0, 0, 0, 255), new Color(0, 0, 0, 255), new Color(0, 0, 0, 255), new Color(254, 254, 254, 255)};
                    object5 = new ConicalGradientPaint(true, double_3, 0.0f, (float[])object7, (Color[])object6);
                    graphics2D.setPaint((Paint)object5);
                    area3.subtract(area);
                    graphics2D.fill(area3);
                    break;
                }
                case METAL: {
                    objectArray2 = new float[]{0.0f, 0.07f, 0.12f, 1.0f};
                    object4 = new Color[]{new Color(254, 254, 254, 255), new Color(210, 210, 210, 255), new Color(179, 179, 179, 255), new Color(213, 213, 213, 255)};
                    LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, (float[])objectArray2, (Color[])object4);
                    graphics2D.setPaint(linearGradientPaint);
                    area3.subtract(area);
                    graphics2D.fill(area3);
                    break;
                }
                case SHINY_METAL: {
                    if (this.isFrameBaseColorEnabled()) {
                        objectArray = new float[]{0.0f, 45.0f, 90.0f, 135.0f, 180.0f, 225.0f, 270.0f, 315.0f, 360.0f};
                        object3 = new Color[]{new Color(254, 254, 254, 255), new Color(this.getFrameBaseColor().getRed(), this.getFrameBaseColor().getGreen(), this.getFrameBaseColor().getBlue(), 255), new Color(this.getFrameBaseColor().getRed(), this.getFrameBaseColor().getGreen(), this.getFrameBaseColor().getBlue(), 255), new Color(this.getFrameBaseColor().brighter().brighter().getRed(), this.getFrameBaseColor().brighter().brighter().getGreen(), this.getFrameBaseColor().brighter().brighter().getBlue(), 255), new Color(this.getFrameBaseColor().getRed(), this.getFrameBaseColor().getGreen(), this.getFrameBaseColor().getBlue(), 255), new Color(this.getFrameBaseColor().brighter().brighter().getRed(), this.getFrameBaseColor().brighter().brighter().getGreen(), this.getFrameBaseColor().brighter().brighter().getBlue(), 255), new Color(this.getFrameBaseColor().getRed(), this.getFrameBaseColor().getGreen(), this.getFrameBaseColor().getBlue(), 255), new Color(this.getFrameBaseColor().getRed(), this.getFrameBaseColor().getGreen(), this.getFrameBaseColor().getBlue(), 255), new Color(254, 254, 254, 255)};
                    } else {
                        objectArray = new float[]{0.0f, 45.0f, 90.0f, 95.0f, 180.0f, 265.0f, 270.0f, 315.0f, 360.0f};
                        object3 = new Color[]{new Color(254, 254, 254, 255), new Color(210, 210, 210, 255), new Color(179, 179, 179, 255), new Color(160, 160, 160, 255), new Color(160, 160, 160, 255), new Color(160, 160, 160, 255), new Color(179, 179, 179, 255), new Color(210, 210, 210, 255), new Color(254, 254, 254, 255)};
                    }
                    object2 = new ConicalGradientPaint(true, double_3, 0.0f, (float[])objectArray, (Color[])object3);
                    graphics2D.setPaint((Paint)object2);
                    area3.subtract(area);
                    graphics2D.fill(area3);
                    break;
                }
                case GLOSSY_METAL: {
                    cloneable = new GeneralPath();
                    cloneable.setWindingRule(0);
                    cloneable.moveTo(0.004672897196261682 * (double)n2, 0.7737226277372263 * (double)n3 * d);
                    cloneable.curveTo(0.004672897196261682 * (double)n2, 0.35036496350364965 * (double)n3 * d, 0.22429906542056074 * (double)n2, 0.0072992700729927005 * (double)n3 * d, 0.5 * (double)n2, 0.0072992700729927005 * (double)n3 * d);
                    cloneable.curveTo(0.7710280373831776 * (double)n2, 0.0072992700729927005 * (double)n3 * d, 0.9953271028037384 * (double)n2, 0.35036496350364965 * (double)n3 * d, 0.9953271028037384 * (double)n2, 0.7737226277372263 * (double)n3 * d);
                    cloneable.curveTo(0.9953271028037384 * (double)n2, 0.8832116788321168 * (double)n3 * d, 0.9953271028037384 * (double)n2, 0.9927007299270073 * (double)n3 * d, 0.9953271028037384 * (double)n2, 0.9927007299270073 * (double)n3 * d);
                    cloneable.lineTo(0.004672897196261682 * (double)n2, 0.9927007299270073 * (double)n3 * d);
                    cloneable.curveTo(0.004672897196261682 * (double)n2, 0.9927007299270073 * (double)n3 * d, 0.004672897196261682 * (double)n2, 0.8832116788321168 * (double)n3 * d, 0.004672897196261682 * (double)n2, 0.7737226277372263 * (double)n3 * d);
                    cloneable.closePath();
                    object = new Area((Shape)((Object)cloneable));
                    ((Area)object).subtract(area);
                    graphics2D.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)n2, 0.9927007299270073 * (double)n3 * d), (float)(0.4953271028037383 * (double)n2), new float[]{0.0f, 0.01f, 0.95f, 1.0f}, new Color[]{new Color(0.8235294f, 0.8235294f, 0.8235294f, 1.0f), new Color(0.8235294f, 0.8235294f, 0.8235294f, 1.0f), new Color(0.8235294f, 0.8235294f, 0.8235294f, 1.0f), new Color(0.99607843f, 0.99607843f, 0.99607843f, 1.0f)}));
                    graphics2D.fill((Shape)object);
                    GeneralPath generalPath4 = new GeneralPath();
                    generalPath4.setWindingRule(0);
                    generalPath4.moveTo(0.014018691588785047 * (double)n2, 0.7737226277372263 * (double)n3 * d);
                    generalPath4.curveTo(0.014018691588785047 * (double)n2, 0.36496350364963503 * (double)n3 * d, 0.22429906542056074 * (double)n2, 0.021897810218978103 * (double)n3 * d, 0.5 * (double)n2, 0.021897810218978103 * (double)n3 * d);
                    generalPath4.curveTo(0.7710280373831776 * (double)n2, 0.021897810218978103 * (double)n3 * d, 0.985981308411215 * (double)n2, 0.36496350364963503 * (double)n3 * d, 0.985981308411215 * (double)n2, 0.7737226277372263 * (double)n3 * d);
                    generalPath4.curveTo(0.985981308411215 * (double)n2, 0.8832116788321168 * (double)n3 * d, 0.985981308411215 * (double)n2, 0.9781021897810219 * (double)n3 * d, 0.985981308411215 * (double)n2, 0.9781021897810219 * (double)n3 * d);
                    generalPath4.lineTo(0.014018691588785047 * (double)n2, 0.9781021897810219 * (double)n3 * d);
                    generalPath4.curveTo(0.014018691588785047 * (double)n2, 0.9781021897810219 * (double)n3 * d, 0.014018691588785047 * (double)n2, 0.8832116788321168 * (double)n3 * d, 0.014018691588785047 * (double)n2, 0.7737226277372263 * (double)n3 * d);
                    generalPath4.closePath();
                    Area area4 = new Area(generalPath4);
                    area4.subtract(area);
                    graphics2D.setPaint(new LinearGradientPaint(new Point2D.Double(0.5 * (double)n2, 0.0072992700729927005 * (double)n3 * d), new Point2D.Double(0.5000000000000001 * (double)n2, 1.0 * (double)n3 * d), new float[]{0.0f, 0.24f, 0.34f, 0.65f, 0.85f, 1.0f}, new Color[]{new Color(0.9764706f, 0.9764706f, 0.9764706f, 1.0f), new Color(0.78431374f, 0.7647059f, 0.7490196f, 1.0f), new Color(0.9882353f, 0.9882353f, 0.9882353f, 1.0f), new Color(0.12156863f, 0.12156863f, 0.12156863f, 1.0f), new Color(0.78431374f, 0.7607843f, 0.7529412f, 1.0f), new Color(0.8156863f, 0.8156863f, 0.8156863f, 1.0f)}));
                    graphics2D.fill(area4);
                    GeneralPath generalPath5 = new GeneralPath();
                    generalPath5.setWindingRule(0);
                    generalPath5.moveTo(0.07009345794392523 * (double)n2, 0.7737226277372263 * (double)n3 * d);
                    generalPath5.curveTo(0.07009345794392523 * (double)n2, 0.39416058394160586 * (double)n3 * d, 0.26635514018691586 * (double)n2, 0.10948905109489052 * (double)n3 * d, 0.5 * (double)n2, 0.10948905109489052 * (double)n3 * d);
                    generalPath5.curveTo(0.7289719626168224 * (double)n2, 0.10948905109489052 * (double)n3 * d, 0.9252336448598131 * (double)n2, 0.38686131386861317 * (double)n3 * d, 0.9252336448598131 * (double)n2, 0.7737226277372263 * (double)n3 * d);
                    generalPath5.curveTo(0.9252336448598131 * (double)n2, 0.8102189781021898 * (double)n3 * d, 0.9158878504672897 * (double)n2, 0.8905109489051095 * (double)n3 * d, 0.9158878504672897 * (double)n2, 0.8905109489051095 * (double)n3 * d);
                    generalPath5.lineTo(0.07476635514018691 * (double)n2, 0.8905109489051095 * (double)n3 * d);
                    generalPath5.curveTo(0.07476635514018691 * (double)n2, 0.8905109489051095 * (double)n3 * d, 0.07009345794392523 * (double)n2, 0.8102189781021898 * (double)n3 * d, 0.07009345794392523 * (double)n2, 0.7737226277372263 * (double)n3 * d);
                    generalPath5.closePath();
                    Area area5 = new Area(generalPath5);
                    area5.subtract(area);
                    graphics2D.setPaint(new Color(0.9647059f, 0.9647059f, 0.9647059f, 1.0f));
                    graphics2D.fill(area5);
                    GeneralPath generalPath6 = new GeneralPath();
                    generalPath6.setWindingRule(0);
                    generalPath6.moveTo(0.07476635514018691 * (double)n2, 0.7737226277372263 * (double)n3 * d);
                    generalPath6.curveTo(0.07476635514018691 * (double)n2, 0.41605839416058393 * (double)n3 * d, 0.26635514018691586 * (double)n2, 0.11678832116788321 * (double)n3 * d, 0.5 * (double)n2, 0.11678832116788321 * (double)n3 * d);
                    generalPath6.curveTo(0.7289719626168224 * (double)n2, 0.11678832116788321 * (double)n3 * d, 0.9205607476635514 * (double)n2, 0.41605839416058393 * (double)n3 * d, 0.9205607476635514 * (double)n2, 0.7737226277372263 * (double)n3 * d);
                    generalPath6.curveTo(0.9205607476635514 * (double)n2, 0.8102189781021898 * (double)n3 * d, 0.9112149532710281 * (double)n2, 0.8832116788321168 * (double)n3 * d, 0.9112149532710281 * (double)n2, 0.8832116788321168 * (double)n3 * d);
                    generalPath6.lineTo(0.0794392523364486 * (double)n2, 0.8832116788321168 * (double)n3 * d);
                    generalPath6.curveTo(0.0794392523364486 * (double)n2, 0.8832116788321168 * (double)n3 * d, 0.07476635514018691 * (double)n2, 0.8102189781021898 * (double)n3 * d, 0.07476635514018691 * (double)n2, 0.7737226277372263 * (double)n3 * d);
                    generalPath6.closePath();
                    Area area6 = new Area(generalPath6);
                    area6.subtract(area);
                    graphics2D.setPaint(new Color(0.2f, 0.2f, 0.2f, 1.0f));
                    graphics2D.fill(area6);
                    break;
                }
                case BRASS: {
                    float[] fArray = new float[]{0.0f, 0.05f, 0.1f, 0.5f, 0.9f, 0.95f, 1.0f};
                    Color[] colorArray = new Color[]{new Color(249, 243, 155, 255), new Color(246, 226, 101, 255), new Color(240, 225, 132, 255), new Color(90, 57, 22, 255), new Color(249, 237, 139, 255), new Color(243, 226, 108, 255), new Color(202, 182, 113, 255)};
                    LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray);
                    graphics2D.setPaint(linearGradientPaint);
                    area3.subtract(area);
                    graphics2D.fill(area3);
                    break;
                }
                case STEEL: {
                    float[] fArray = new float[]{0.0f, 0.05f, 0.1f, 0.5f, 0.9f, 0.95f, 1.0f};
                    Color[] colorArray = new Color[]{new Color(231, 237, 237, 255), new Color(189, 199, 198, 255), new Color(192, 201, 200, 255), new Color(23, 31, 33, 255), new Color(196, 205, 204, 255), new Color(194, 204, 203, 255), new Color(189, 201, 199, 255)};
                    LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray);
                    graphics2D.setPaint(linearGradientPaint);
                    area3.subtract(area);
                    graphics2D.fill(area3);
                    break;
                }
                case CHROME: {
                    float[] fArray = new float[]{0.0f, 0.09f, 0.12f, 0.16f, 0.25f, 0.29f, 0.33f, 0.38f, 0.48f, 0.52f, 0.63f, 0.68f, 0.8f, 0.83f, 0.87f, 0.97f, 1.0f};
                    Color[] colorArray = new Color[]{new Color(255, 255, 255, 255), new Color(255, 255, 255, 255), new Color(136, 136, 138, 255), new Color(164, 185, 190, 255), new Color(158, 179, 182, 255), new Color(112, 112, 112, 255), new Color(221, 227, 227, 255), new Color(155, 176, 179, 255), new Color(156, 176, 177, 255), new Color(254, 255, 255, 255), new Color(255, 255, 255, 255), new Color(156, 180, 180, 255), new Color(198, 209, 211, 255), new Color(246, 248, 247, 255), new Color(204, 216, 216, 255), new Color(164, 188, 190, 255), new Color(255, 255, 255, 255)};
                    ConicalGradientPaint conicalGradientPaint = new ConicalGradientPaint(false, double_3, 0.0f, fArray, colorArray);
                    graphics2D.setPaint(conicalGradientPaint);
                    area3.subtract(area);
                    graphics2D.fill(area3);
                    break;
                }
                case GOLD: {
                    float[] fArray = new float[]{0.0f, 0.15f, 0.22f, 0.3f, 0.38f, 0.44f, 0.51f, 0.6f, 0.68f, 0.75f, 1.0f};
                    Color[] colorArray = new Color[]{new Color(255, 255, 207, 255), new Color(255, 237, 96, 255), new Color(254, 199, 57, 255), new Color(255, 249, 203, 255), new Color(255, 199, 64, 255), new Color(252, 194, 60, 255), new Color(255, 204, 59, 255), new Color(213, 134, 29, 255), new Color(255, 201, 56, 255), new Color(212, 135, 29, 255), new Color(247, 238, 101, 255)};
                    LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray);
                    graphics2D.setPaint(linearGradientPaint);
                    area3.subtract(area);
                    graphics2D.fill(area3);
                    break;
                }
                case ANTHRACITE: {
                    float[] fArray = new float[]{0.0f, 0.06f, 0.12f, 1.0f};
                    Color[] colorArray = new Color[]{new Color(118, 117, 135, 255), new Color(74, 74, 82, 255), new Color(50, 50, 54, 255), new Color(97, 97, 108, 255)};
                    LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray);
                    graphics2D.setPaint(linearGradientPaint);
                    area3.subtract(area);
                    graphics2D.fill(area3);
                    break;
                }
                case TILTED_GRAY: {
                    ((Point2D)double_).setLocation(0.2336448598130841 * (double)n2, 0.08411214953271028 * (double)n3);
                    ((Point2D)double_2).setLocation(0.8125818236066633 * (double)n2, 0.9109198204038422 * (double)n3);
                    float[] fArray = new float[]{0.0f, 0.07f, 0.16f, 0.33f, 0.55f, 0.79f, 1.0f};
                    Color[] colorArray = new Color[]{new Color(255, 255, 255, 255), new Color(210, 210, 210, 255), new Color(179, 179, 179, 255), new Color(255, 255, 255, 255), new Color(197, 197, 197, 255), new Color(255, 255, 255, 255), new Color(102, 102, 102, 255)};
                    LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray);
                    graphics2D.setPaint(linearGradientPaint);
                    area3.subtract(area);
                    graphics2D.fill(area3);
                    break;
                }
                case TILTED_BLACK: {
                    ((Point2D)double_).setLocation(0.22897196261682243 * (double)n2, 0.0794392523364486 * (double)n3);
                    ((Point2D)double_2).setLocation(0.8025483989678684 * (double)n2, 0.8985912966254403 * (double)n3);
                    float[] fArray = new float[]{0.0f, 0.21f, 0.47f, 0.99f, 1.0f};
                    Color[] colorArray = new Color[]{new Color(102, 102, 102, 255), new Color(0, 0, 0, 255), new Color(102, 102, 102, 255), new Color(0, 0, 0, 255), new Color(0, 0, 0, 255)};
                    LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray);
                    graphics2D.setPaint(linearGradientPaint);
                    area3.subtract(area);
                    graphics2D.fill(area3);
                    break;
                }
                default: {
                    float[] fArray = new float[]{0.0f, 0.07f, 0.12f, 1.0f};
                    Color[] colorArray = new Color[]{new Color(254, 254, 254, 255), new Color(210, 210, 210, 255), new Color(179, 179, 179, 255), new Color(213, 213, 213, 255)};
                    LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray);
                    graphics2D.setPaint(linearGradientPaint);
                    area3.subtract(area);
                    graphics2D.fill(area3);
                }
            }
        }
        object7 = new GeneralPath();
        ((Path2D)object7).setWindingRule(0);
        ((Path2D.Float)object7).moveTo((double)n2 * 0.07906976744186046, (double)n3 * 0.7753623188405797 * d);
        ((Path2D.Float)object7).curveTo((double)n2 * 0.07906976744186046, (double)n3 * 0.41304347826086957 * d, (double)n2 * 0.2651162790697674, (double)n3 * 0.12318840579710146 * d, (double)n2 * 0.49767441860465117, (double)n3 * 0.12318840579710146 * d);
        ((Path2D.Float)object7).curveTo((double)n2 * 0.7302325581395349, (double)n3 * 0.12318840579710146 * d, (double)n2 * 0.9162790697674419, (double)n3 * 0.41304347826086957 * d, (double)n2 * 0.9162790697674419, (double)n3 * 0.7753623188405797 * d);
        ((Path2D.Float)object7).curveTo((double)n2 * 0.9162790697674419, (double)n3 * 0.8115942028985508 * d, (double)n2 * 0.9069767441860465, (double)n3 * 0.8768115942028986 * d, (double)n2 * 0.9069767441860465, (double)n3 * 0.8768115942028986 * d);
        ((Path2D.Float)object7).lineTo((double)n2 * 0.08837209302325581, (double)n3 * 0.8768115942028986 * d);
        ((Path2D.Float)object7).curveTo((double)n2 * 0.08837209302325581, (double)n3 * 0.8768115942028986 * d, (double)n2 * 0.07906976744186046, (double)n3 * 0.8115942028985508 * d, (double)n2 * 0.07906976744186046, (double)n3 * 0.7753623188405797 * d);
        ((Path2D)object7).closePath();
        graphics2D.setPaint(this.getInnerFrameColor());
        object6 = new Area((Shape)object7);
        ((Area)object6).subtract(area);
        graphics2D.fill((Shape)object6);
        float f = 1.0f;
        objectArray = new Shape[100];
        switch (this.getFrameEffect()) {
            case EFFECT_BULGE: {
                int n4;
                object5 = new float[]{0.0f, 0.13f, 0.14f, 0.17f, 0.18f, 1.0f};
                objectArray2 = new Color[]{new Color(0, 0, 0, 102), new Color(255, 255, 255, 151), new Color(219, 219, 219, 153), new Color(0, 0, 0, 95), new Color(0, 0, 0, 76), new Color(0, 0, 0, 0)};
                object4 = new GradientWrapper(new Point2D.Double(100.0, 0.0), new Point2D.Double(0.0, 0.0), (float[])object5, (Color[])objectArray2);
                for (n4 = 0; n4 < 100; ++n4) {
                    objectArray[n4] = (float)Scaler.INSTANCE.scale(area3, f);
                    f -= 0.01f;
                }
                graphics2D.setStroke(new BasicStroke(1.5f));
                for (n4 = 0; n4 < objectArray.length; ++n4) {
                    graphics2D.setPaint(((GradientWrapper)object4).getColorAt((float)n4 / 100.0f));
                    graphics2D.draw((Shape)objectArray[n4]);
                }
                break;
            }
            case EFFECT_CONE: {
                int n5;
                object5 = new float[]{0.0f, 0.0399f, 0.04f, 0.1799f, 0.18f, 1.0f};
                objectArray2 = new Color[]{new Color(0, 0, 0, 76), new Color(223, 223, 223, 127), new Color(255, 255, 255, 124), new Color(9, 9, 9, 51), new Color(0, 0, 0, 50), new Color(0, 0, 0, 0)};
                object4 = new GradientWrapper(new Point2D.Double(100.0, 0.0), new Point2D.Double(0.0, 0.0), (float[])object5, (Color[])objectArray2);
                for (n5 = 0; n5 < 100; ++n5) {
                    objectArray[n5] = (float)Scaler.INSTANCE.scale(area3, f);
                    f -= 0.01f;
                }
                graphics2D.setStroke(new BasicStroke(1.5f));
                for (n5 = 0; n5 < objectArray.length; ++n5) {
                    graphics2D.setPaint(((GradientWrapper)object4).getColorAt((float)n5 / 100.0f));
                    graphics2D.draw((Shape)objectArray[n5]);
                }
                break;
            }
            case EFFECT_TORUS: {
                int n6;
                object5 = new float[]{0.0f, 0.08f, 0.1799f, 0.18f, 1.0f};
                objectArray2 = new Color[]{new Color(0, 0, 0, 76), new Color(255, 255, 255, 64), new Color(13, 13, 13, 51), new Color(0, 0, 0, 50), new Color(0, 0, 0, 0)};
                object4 = new GradientWrapper(new Point2D.Double(100.0, 0.0), new Point2D.Double(0.0, 0.0), (float[])object5, (Color[])objectArray2);
                for (n6 = 0; n6 < 100; ++n6) {
                    objectArray[n6] = (float)Scaler.INSTANCE.scale(area3, f);
                    f -= 0.01f;
                }
                graphics2D.setStroke(new BasicStroke(1.5f));
                for (n6 = 0; n6 < objectArray.length; ++n6) {
                    graphics2D.setPaint(((GradientWrapper)object4).getColorAt((float)n6 / 100.0f));
                    graphics2D.draw((Shape)objectArray[n6]);
                }
                break;
            }
            case EFFECT_INNER_FRAME: {
                object3 = Scaler.INSTANCE.scale(area3, 0.8785046339035034);
                object2 = new Point2D.Double(0.0, object3.getBounds2D().getMinY());
                cloneable = new Point2D.Double(0.0, object3.getBounds2D().getMaxY());
                object5 = new float[]{0.0f, 0.3f, 0.5f, 0.71f, 1.0f};
                objectArray2 = new Color[]{new Color(0, 0, 0, 183), new Color(148, 148, 148, 25), new Color(0, 0, 0, 159), new Color(0, 0, 0, 81), new Color(255, 255, 255, 158)};
                object = new LinearGradientPaint((Point2D)object2, (Point2D)cloneable, (float[])object5, (Color[])objectArray2);
                graphics2D.setPaint((Paint)object);
                graphics2D.fill((Shape)object3);
            }
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    protected BufferedImage create_BACKGROUND_Image(int n) {
        return this.create_BACKGROUND_Image(n, "", "", null);
    }

    @Override
    protected BufferedImage create_BACKGROUND_Image(int n, String string, String string2, BufferedImage bufferedImage) {
        Object object;
        Color[] colorArray;
        Object object2;
        Object object3;
        double d;
        if (n <= 0) {
            return null;
        }
        if (bufferedImage == null) {
            bufferedImage = UTIL.createImage(n, (int)(0.641860465116279 * (double)n), 3);
            d = 1.0;
        } else {
            d = 0.641860465116279;
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        boolean bl = false;
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n2 * 0.08411214953271028, (double)n3 * 0.7737226277372263 * d);
        generalPath.curveTo((double)n2 * 0.08411214953271028, (double)n3 * 0.41605839416058393 * d, (double)n2 * 0.27102803738317754, (double)n3 * 0.13138686131386862 * d, (double)n2 * 0.5, (double)n3 * 0.13138686131386862 * d);
        generalPath.curveTo((double)n2 * 0.7242990654205608, (double)n3 * 0.13138686131386862 * d, (double)n2 * 0.9112149532710281, (double)n3 * 0.41605839416058393 * d, (double)n2 * 0.9112149532710281, (double)n3 * 0.7737226277372263 * d);
        generalPath.curveTo((double)n2 * 0.9112149532710281, (double)n3 * 0.8175182481751825 * d, (double)n2 * 0.9065420560747663, (double)n3 * 0.8686131386861314 * d, (double)n2 * 0.9065420560747663, (double)n3 * 0.8686131386861314 * d);
        generalPath.lineTo((double)n2 * 0.08878504672897196, (double)n3 * 0.8686131386861314 * d);
        generalPath.curveTo((double)n2 * 0.08878504672897196, (double)n3 * 0.8686131386861314 * d, (double)n2 * 0.08411214953271028, (double)n3 * 0.8175182481751825 * d, (double)n2 * 0.08411214953271028, (double)n3 * 0.7737226277372263 * d);
        generalPath.closePath();
        Point2D.Double double_ = new Point2D.Double(0.0, generalPath.getBounds2D().getMinY());
        Point2D.Double double_2 = new Point2D.Double(0.0, generalPath.getBounds2D().getMaxY());
        float[] fArray = new float[]{0.0f, 0.4f, 1.0f};
        Paint paint = null;
        if (this.getCustomBackground() != null && this.getBackgroundColor() == BackgroundColor.CUSTOM) {
            graphics2D.setPaint(this.getCustomBackground());
        } else {
            object3 = new Color[]{this.getBackgroundColor().GRADIENT_START_COLOR, this.getBackgroundColor().GRADIENT_FRACTION_COLOR, this.getBackgroundColor().GRADIENT_STOP_COLOR};
            if (this.getBackgroundColor() == BackgroundColor.BRUSHED_METAL) {
                paint = new TexturePaint(UTIL.createBrushMetalTexture(this.getModel().getTextureColor(), generalPath.getBounds().width, generalPath.getBounds().height), generalPath.getBounds());
            } else if (this.getBackgroundColor() == BackgroundColor.STAINLESS) {
                object2 = new float[]{0.0f, 0.03f, 0.1f, 0.14f, 0.24f, 0.33f, 0.38f, 0.5f, 0.62f, 0.67f, 0.76f, 0.81f, 0.85f, 0.97f, 1.0f};
                colorArray = new Color[]{new Color(0xFDFDFD), new Color(0xFDFDFD), new Color(0xB2B2B4), new Color(0xACACAE), new Color(0xFDFDFD), new Color(7237232), new Color(7237232), new Color(0xFDFDFD), new Color(7237232), new Color(7237232), new Color(0xFDFDFD), new Color(0xACACAE), new Color(0xB2B2B4), new Color(0xFDFDFD), new Color(0xFDFDFD)};
                paint = new ConicalGradientPaint(false, this.getCenter(), -0.45f, (float[])object2, colorArray);
            } else if (this.getBackgroundColor() == BackgroundColor.STAINLESS_GRINDED) {
                paint = new TexturePaint(Radial2Top.BACKGROUND_FACTORY.STAINLESS_GRINDED_TEXTURE, new Rectangle(0, 0, 100, 100));
            } else if (this.getBackgroundColor() == BackgroundColor.CARBON) {
                paint = new TexturePaint(Radial2Top.BACKGROUND_FACTORY.CARBON_FIBRE_TEXTURE, new Rectangle(0, 0, 12, 12));
                bl = true;
            } else if (this.getBackgroundColor() == BackgroundColor.PUNCHED_SHEET) {
                paint = new TexturePaint(BACKGROUND_FACTORY.getPunchedSheetTexture(), new Rectangle(0, 0, 12, 12));
                bl = true;
            } else if (this.getBackgroundColor() == BackgroundColor.LINEN) {
                paint = new TexturePaint(UTIL.createLinenTexture(this.getModel().getTextureColor(), generalPath.getBounds().width, generalPath.getBounds().height), generalPath.getBounds());
            } else if (this.getBackgroundColor() == BackgroundColor.NOISY_PLASTIC) {
                ((Point2D)double_).setLocation(0.0, generalPath.getBounds2D().getMinY());
                ((Point2D)double_2).setLocation(0.0, generalPath.getBounds2D().getMaxY());
                if (double_.equals(double_2)) {
                    ((Point2D)double_2).setLocation(0.0, ((Point2D)double_).getY() + 1.0);
                }
                object2 = new float[]{0.0f, 1.0f};
                colorArray = new Color[]{UTIL.lighter(this.getTextureColor(), 0.15f), UTIL.darker(this.getTextureColor(), 0.15f)};
                paint = new LinearGradientPaint(double_, double_2, (float[])object2, colorArray);
            } else {
                paint = new LinearGradientPaint(double_, double_2, fArray, (Color[])object3);
            }
            graphics2D.setPaint(paint);
        }
        graphics2D.fill(generalPath);
        object3 = this.getCustomBackground() != null && this.getBackgroundColor() == BackgroundColor.CUSTOM ? Shadow.INSTANCE.createInnerShadow(generalPath, this.getCustomBackground(), 0, 0.65f, Color.BLACK, 20, 315) : Shadow.INSTANCE.createInnerShadow(generalPath, paint, 0, 0.65f, Color.BLACK, 20, 315);
        graphics2D.drawImage((Image)object3, generalPath.getBounds().x, generalPath.getBounds().y, null);
        if (this.getBackgroundColor() == BackgroundColor.NOISY_PLASTIC) {
            object2 = new Random();
            colorArray = new Random();
            object = graphics2D.getClip();
            graphics2D.setClip(generalPath);
            int n4 = 0;
            while ((double)n4 < generalPath.getBounds().getHeight()) {
                int n5 = 0;
                while ((double)n5 < generalPath.getBounds().getWidth()) {
                    Color color = ((Random)object2).nextBoolean() ? this.BRIGHT_NOISE : this.DARK_NOISE;
                    int n6 = 10 + colorArray.nextInt(10) - 5;
                    graphics2D.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), n6));
                    graphics2D.drawLine((int)((double)n5 + generalPath.getBounds2D().getMinX()), (int)((double)n4 + generalPath.getBounds2D().getMinY()), (int)((double)n5 + generalPath.getBounds2D().getMinX()), (int)((double)n4 + generalPath.getBounds2D().getMinY()));
                    ++n5;
                }
                ++n4;
            }
            graphics2D.setClip((Shape)object);
        }
        if (bl) {
            object2 = new float[]{0.0f, 0.4f, 0.6f, 1.0f};
            colorArray = new Color[]{new Color(0.0f, 0.0f, 0.0f, 0.6f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.6f)};
            object = new LinearGradientPaint(new Point2D.Double(generalPath.getBounds().getMinX(), 0.0), new Point2D.Double(generalPath.getBounds().getMaxX(), 0.0), (float[])object2, colorArray);
            graphics2D.setPaint((Paint)object);
            graphics2D.fill(generalPath);
        }
        if (this.isCustomLayerVisible()) {
            graphics2D.drawImage((Image)UTIL.getScaledInstance(this.getCustomLayer(), n2, (int)((double)n3 * d), RenderingHints.VALUE_INTERPOLATION_BICUBIC), 0, 0, null);
        }
        object2 = new FontRenderContext(null, true, true);
        if (!string.isEmpty()) {
            if (this.isLabelColorFromThemeEnabled()) {
                graphics2D.setColor(this.getBackgroundColor().LABEL_COLOR);
            } else {
                graphics2D.setColor(this.getLabelColor());
            }
            graphics2D.setFont(new Font("Verdana", 0, (int)(0.04672897196261682 * (double)n2)));
            colorArray = new TextLayout(string, graphics2D.getFont(), (FontRenderContext)object2);
            object = colorArray.getBounds();
            graphics2D.drawString(string, (float)(((double)n2 - ((RectangularShape)object).getWidth()) / 2.0), (float)((double)(0.44f * (float)n3) * d) + colorArray.getAscent() - colorArray.getDescent());
        }
        if (!string2.isEmpty()) {
            if (this.isLabelColorFromThemeEnabled()) {
                graphics2D.setColor(this.getBackgroundColor().LABEL_COLOR);
            } else {
                graphics2D.setColor(this.getLabelColor());
            }
            graphics2D.setFont(new Font("Verdana", 0, (int)(0.04672897196261682 * (double)n2)));
            colorArray = new TextLayout(string2, graphics2D.getFont(), (FontRenderContext)object2);
            object = colorArray.getBounds();
            graphics2D.drawString(string2, (float)(((double)n2 - ((RectangularShape)object).getWidth()) / 2.0), 0.52f * (float)n3 + colorArray.getAscent() - colorArray.getDescent());
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_GLOW_Image(int n, Color color, boolean bl) {
        if (n <= 0) {
            return null;
        }
        BufferedImage bufferedImage = UTIL.createImage(n, (int)(0.641860465116279 * (double)n), 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n2 * 0.11214953271028037, (double)n3 * 0.7737226277372263);
        generalPath.curveTo((double)n2 * 0.11214953271028037, (double)n3 * 0.4233576642335766, (double)n2 * 0.29906542056074764, (double)n3 * 0.1678832116788321, (double)n2 * 0.5, (double)n3 * 0.1678832116788321);
        generalPath.curveTo((double)n2 * 0.705607476635514, (double)n3 * 0.1678832116788321, (double)n2 * 0.8878504672897196, (double)n3 * 0.41605839416058393, (double)n2 * 0.8878504672897196, (double)n3 * 0.7737226277372263);
        generalPath.curveTo((double)n2 * 0.8878504672897196, (double)n3 * 0.8175182481751825, (double)n2 * 0.883177570093458, (double)n3 * 0.8613138686131386, (double)n2 * 0.883177570093458, (double)n3 * 0.8613138686131386);
        generalPath.lineTo((double)n2 * 0.11682242990654206, (double)n3 * 0.8613138686131386);
        generalPath.curveTo((double)n2 * 0.11682242990654206, (double)n3 * 0.8613138686131386, (double)n2 * 0.11214953271028037, (double)n3 * 0.8175182481751825, (double)n2 * 0.11214953271028037, (double)n3 * 0.7737226277372263);
        generalPath.closePath();
        generalPath.moveTo((double)n2 * 0.08411214953271028, (double)n3 * 0.7737226277372263);
        generalPath.curveTo((double)n2 * 0.08411214953271028, (double)n3 * 0.8175182481751825, (double)n2 * 0.08878504672897196, (double)n3 * 0.8686131386861314, (double)n2 * 0.08878504672897196, (double)n3 * 0.8686131386861314);
        generalPath.lineTo((double)n2 * 0.9065420560747663, (double)n3 * 0.8686131386861314);
        generalPath.curveTo((double)n2 * 0.9065420560747663, (double)n3 * 0.8686131386861314, (double)n2 * 0.9112149532710281, (double)n3 * 0.8175182481751825, (double)n2 * 0.9112149532710281, (double)n3 * 0.7737226277372263);
        generalPath.curveTo((double)n2 * 0.9112149532710281, (double)n3 * 0.41605839416058393, (double)n2 * 0.7242990654205608, (double)n3 * 0.13138686131386862, (double)n2 * 0.5, (double)n3 * 0.13138686131386862);
        generalPath.curveTo((double)n2 * 0.27102803738317754, (double)n3 * 0.13138686131386862, (double)n2 * 0.08411214953271028, (double)n3 * 0.41605839416058393, (double)n2 * 0.08411214953271028, (double)n3 * 0.7737226277372263);
        generalPath.closePath();
        if (!bl) {
            Point2D.Double double_ = new Point2D.Double(0.0, generalPath.getBounds2D().getMinY());
            Point2D.Double double_2 = new Point2D.Double(0.0, generalPath.getBounds2D().getMaxY());
            float[] fArray = new float[]{0.0f, 0.19f, 0.2f, 0.39f, 0.4f, 0.64f, 0.65f, 0.82f, 1.0f};
            Color[] colorArray = new Color[]{new Color(204, 204, 204, 102), new Color(255, 255, 255, 102), new Color(250, 250, 250, 102), new Color(158, 158, 158, 102), new Color(153, 153, 153, 102), new Color(202, 202, 202, 102), new Color(204, 204, 204, 102), new Color(255, 255, 255, 102), new Color(153, 153, 153, 102)};
            LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray);
            graphics2D.setPaint(linearGradientPaint);
            graphics2D.fill(generalPath);
        } else {
            graphics2D.translate(-10, -10);
            graphics2D.drawImage((Image)Shadow.INSTANCE.createDropShadow(generalPath, UTIL.setAlpha(color, 0.8f), color, true, null, null, 0, 1.0f, 10, 315, color), generalPath.getBounds().x, generalPath.getBounds().y, null);
            graphics2D.translate(10, 10);
            Point2D.Double double_ = new Point2D.Double(0.0, generalPath.getBounds2D().getMinY());
            Point2D.Double double_3 = new Point2D.Double(0.0, generalPath.getBounds2D().getMaxY());
            float[] fArray = new float[]{0.0f, 0.26f, 0.42f, 0.42009997f, 0.56f, 0.5601f, 0.96f, 0.9601f, 1.0f};
            Color[] colorArray = new Color[]{new Color(255, 255, 255, 0), new Color(255, 255, 255, 63), new Color(255, 255, 255, 102), new Color(255, 255, 255, 98), new Color(255, 255, 255, 3), new Color(255, 255, 255, 0), new Color(255, 255, 255, 0), new Color(255, 255, 255, 0), new Color(255, 255, 255, 102)};
            LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_3, fArray, colorArray);
            graphics2D.setPaint(linearGradientPaint);
            graphics2D.fill(generalPath);
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_POSTS_Image(int n, BufferedImage bufferedImage) {
        Object object;
        Object[] objectArray;
        Object object2;
        Point2D.Double double_;
        Ellipse2D.Double double_2;
        LinearGradientPaint linearGradientPaint;
        Color[] colorArray;
        float[] fArray;
        Point2D.Double double_3;
        Point2D.Double double_4;
        Ellipse2D.Double double_5;
        LinearGradientPaint linearGradientPaint2;
        Color[] colorArray2;
        float[] fArray2;
        Point2D.Double double_6;
        Point2D.Double double_7;
        Ellipse2D.Double double_8;
        RadialGradientPaint radialGradientPaint;
        Color[] colorArray3;
        float[] fArray3;
        Point2D.Double double_9;
        Ellipse2D.Double double_10;
        LinearGradientPaint linearGradientPaint3;
        Color[] colorArray4;
        float[] fArray4;
        Point2D.Double double_11;
        Point2D.Double double_12;
        Ellipse2D.Double double_13;
        LinearGradientPaint linearGradientPaint4;
        Color[] colorArray5;
        float[] fArray5;
        Point2D.Double double_14;
        Point2D.Double double_15;
        Ellipse2D.Double double_16;
        if (n <= 0) {
            return null;
        }
        if (bufferedImage == null) {
            bufferedImage = UTIL.createImage(n, n, 3);
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n2 = bufferedImage.getWidth();
        int n3 = (int)((double)bufferedImage.getHeight() * 0.6418604651);
        switch (this.getKnobType()) {
            case SMALL_STD_KNOB: {
                double_16 = new Ellipse2D.Double((double)n2 * 0.46261683106422424, (double)n3 * 0.7153284549713135, (double)n2 * 0.07943925261497498, (double)n3 * 0.1313868761062622);
                double_15 = new Point2D.Double(0.0, double_16.getBounds2D().getMinY());
                double_14 = new Point2D.Double(0.0, double_16.getBounds2D().getMaxY());
                fArray5 = new float[]{0.0f, 0.46f, 1.0f};
                colorArray5 = new Color[]{new Color(180, 180, 180, 255), new Color(63, 63, 63, 255), new Color(40, 40, 40, 255)};
                linearGradientPaint4 = new LinearGradientPaint(double_15, double_14, fArray5, colorArray5);
                graphics2D.setPaint(linearGradientPaint4);
                graphics2D.fill(double_16);
                double_13 = new Ellipse2D.Double((double)n2 * 0.4719626307487488, (double)n3 * (double)0.729927f, (double)n2 * 0.060747623443603516, (double)n3 * 0.10218977928161621);
                double_12 = new Point2D.Double(0.0, double_13.getBounds2D().getMinY());
                double_11 = new Point2D.Double(0.0, double_13.getBounds2D().getMaxY());
                fArray4 = new float[]{0.0f, 0.5f, 1.0f};
                switch (this.getModel().getKnobStyle()) {
                    case BLACK: {
                        colorArray4 = new Color[]{new Color(0xBFBFBF), new Color(2828847), new Color(8224384)};
                        break;
                    }
                    case BRASS: {
                        colorArray4 = new Color[]{new Color(14667950), new Color(8019518), new Color(13614749)};
                        break;
                    }
                    default: {
                        colorArray4 = new Color[]{new Color(0xD7D7D7), new Color(0x747474), new Color(0xD7D7D7)};
                    }
                }
                linearGradientPaint3 = new LinearGradientPaint(double_12, double_11, fArray4, colorArray4);
                graphics2D.setPaint(linearGradientPaint3);
                graphics2D.fill(double_13);
                double_10 = new Ellipse2D.Double((double)n2 * 0.4719626307487488, (double)n3 * (double)0.729927f, (double)n2 * 0.060747623443603516, (double)n3 * 0.10218977928161621);
                double_9 = new Point2D.Double(0.4930232558139535 * (double)n2, 0.7608695652173914 * (double)n3);
                fArray3 = new float[]{0.0f, 0.75f, 0.76f, 1.0f};
                colorArray3 = new Color[]{new Color(0, 0, 0, 0), new Color(0, 0, 0, 0), new Color(0, 0, 0, 1), new Color(0, 0, 0, 51)};
                radialGradientPaint = new RadialGradientPaint(double_9, (float)(0.03255813953488372 * (double)n2), fArray3, colorArray3);
                graphics2D.setPaint(radialGradientPaint);
                graphics2D.fill(double_10);
                break;
            }
            case BIG_STD_KNOB: {
                Color[] colorArray6;
                double_8 = new Ellipse2D.Double((double)n2 * 0.44859811663627625, (double)n3 * 0.6934306621551514, (double)n2 * 0.1074766218662262, (double)n3 * 0.17518246173858643);
                double_7 = new Point2D.Double(0.0, double_8.getBounds2D().getMinY());
                double_6 = new Point2D.Double(0.0, double_8.getBounds2D().getMaxY());
                fArray2 = new float[]{0.0f, 1.0f};
                switch (this.getModel().getKnobStyle()) {
                    case BLACK: {
                        colorArray2 = new Color[]{new Color(129, 133, 136, 255), new Color(61, 61, 73, 255)};
                        break;
                    }
                    case BRASS: {
                        colorArray2 = new Color[]{new Color(143, 117, 80, 255), new Color(100, 76, 49, 255)};
                        break;
                    }
                    default: {
                        colorArray2 = new Color[]{new Color(152, 152, 152, 255), new Color(118, 121, 126, 255)};
                    }
                }
                linearGradientPaint2 = new LinearGradientPaint(double_7, double_6, fArray2, colorArray2);
                graphics2D.setPaint(linearGradientPaint2);
                graphics2D.fill(double_8);
                double_5 = new Ellipse2D.Double((double)n2 * 0.44859811663627625, (double)n3 * 0.7007299065589905, (double)n2 * 0.1074766218662262, (double)n3 * 0.1605839729309082);
                double_4 = new Point2D.Double(0.0, double_5.getBounds2D().getMinY());
                double_3 = new Point2D.Double(0.0, double_5.getBounds2D().getMaxY());
                fArray = new float[]{0.0f, 1.0f};
                switch (this.getModel().getKnobStyle()) {
                    case BLACK: {
                        colorArray = new Color[]{new Color(26, 27, 32, 255), new Color(96, 97, 102, 255)};
                        break;
                    }
                    case BRASS: {
                        colorArray = new Color[]{new Color(98, 75, 49, 255), new Color(149, 109, 54, 255)};
                        break;
                    }
                    default: {
                        colorArray = new Color[]{new Color(118, 121, 126, 255), new Color(191, 191, 191, 255)};
                    }
                }
                linearGradientPaint = new LinearGradientPaint(double_4, double_3, fArray, colorArray);
                graphics2D.setPaint(linearGradientPaint);
                graphics2D.fill(double_5);
                double_2 = new Ellipse2D.Double((double)n2 * 0.46261683106422424, (double)n3 * 0.7153284549713135, (double)n2 * 0.07943925261497498, (double)n3 * 0.1313868761062622);
                double_ = new Point2D.Double(0.0, double_2.getBounds2D().getMinY());
                object2 = new Point2D.Double(0.0, double_2.getBounds2D().getMaxY());
                objectArray = new float[]{0.0f, 0.47f, 1.0f};
                switch (this.getModel().getKnobStyle()) {
                    case BLACK: {
                        object = new Color[]{new Color(191, 191, 191, 255), new Color(56, 57, 61, 255), new Color(143, 144, 146, 255)};
                        break;
                    }
                    case BRASS: {
                        object = new Color[]{new Color(147, 108, 54, 255), new Color(82, 66, 50, 255), new Color(147, 108, 54, 255)};
                        break;
                    }
                    default: {
                        object = new Color[]{new Color(191, 191, 191, 255), new Color(116, 116, 116, 255), new Color(143, 144, 146, 255)};
                    }
                }
                LinearGradientPaint linearGradientPaint5 = new LinearGradientPaint(double_, (Point2D)object2, (float[])objectArray, (Color[])object);
                graphics2D.setPaint(linearGradientPaint5);
                graphics2D.fill(double_2);
                Ellipse2D.Double double_17 = new Ellipse2D.Double((double)n2 * 0.46261683106422424, (double)n3 * 0.7226277589797974, (double)n2 * 0.07943925261497498, (double)n3 * 0.11678832769393921);
                Point2D.Double double_18 = new Point2D.Double(0.0, double_17.getBounds2D().getMinY());
                Point2D.Double double_19 = new Point2D.Double(0.0, double_17.getBounds2D().getMaxY());
                float[] fArray6 = new float[]{0.0f, 0.21f, 0.5f, 0.78f, 1.0f};
                switch (this.getModel().getKnobStyle()) {
                    case BLACK: {
                        colorArray6 = new Color[]{new Color(191, 191, 191, 255), new Color(94, 93, 99, 255), new Color(43, 42, 47, 255), new Color(78, 79, 81, 255), new Color(143, 144, 146, 255)};
                        break;
                    }
                    case BRASS: {
                        colorArray6 = new Color[]{new Color(223, 208, 174, 255), new Color(159, 136, 104, 255), new Color(122, 94, 62, 255), new Color(159, 136, 104, 255), new Color(223, 208, 174, 255)};
                        break;
                    }
                    default: {
                        colorArray6 = new Color[]{new Color(215, 215, 215, 255), new Color(139, 142, 145, 255), new Color(100, 100, 100, 255), new Color(139, 142, 145, 255), new Color(215, 215, 215, 255)};
                    }
                }
                LinearGradientPaint linearGradientPaint6 = new LinearGradientPaint(double_18, double_19, fArray6, colorArray6);
                graphics2D.setPaint(linearGradientPaint6);
                graphics2D.fill(double_17);
                break;
            }
            case BIG_CHROME_KNOB: {
                Ellipse2D.Double double_20 = new Ellipse2D.Double((double)n2 * 0.44859811663627625, (double)n3 * 0.6934306621551514, (double)n2 * 0.1074766218662262, (double)n3 * 0.17518246173858643);
                Point2D.Double double_21 = new Point2D.Double(0.4697674418604651 * (double)n2, 0.7028985507246377 * (double)n3);
                Point2D.Double double_22 = new Point2D.Double(0.5264564794295986 * (double)n2, 0.844239900084042 * (double)n3);
                float[] fArray7 = new float[]{0.0f, 1.0f};
                Color[] colorArray7 = new Color[]{new Color(129, 139, 140, 255), new Color(166, 171, 175, 255)};
                LinearGradientPaint linearGradientPaint7 = new LinearGradientPaint(double_21, double_22, fArray7, colorArray7);
                graphics2D.setPaint(linearGradientPaint7);
                graphics2D.fill(double_20);
                Ellipse2D.Double double_23 = new Ellipse2D.Double((double)n2 * 0.44859811663627625, (double)n3 * 0.7007299065589905, (double)n2 * 0.1074766218662262, (double)n3 * 0.16788321733474731);
                Point2D.Double double_24 = new Point2D.Double(double_23.getCenterX(), double_23.getCenterY());
                float[] fArray8 = new float[]{0.0f, 0.09f, 0.12f, 0.16f, 0.25f, 0.29f, 0.33f, 0.38f, 0.48f, 0.52f, 0.65f, 0.69f, 0.8f, 0.83f, 0.87f, 0.97f, 1.0f};
                Color[] colorArray8 = new Color[]{new Color(255, 255, 255, 255), new Color(255, 255, 255, 255), new Color(136, 136, 138, 255), new Color(164, 185, 190, 255), new Color(158, 179, 182, 255), new Color(112, 112, 112, 255), new Color(221, 227, 227, 255), new Color(155, 176, 179, 255), new Color(156, 176, 177, 255), new Color(254, 255, 255, 255), new Color(255, 255, 255, 255), new Color(156, 180, 180, 255), new Color(198, 209, 211, 255), new Color(246, 248, 247, 255), new Color(204, 216, 216, 255), new Color(164, 188, 190, 255), new Color(255, 255, 255, 255)};
                ConicalGradientPaint conicalGradientPaint = new ConicalGradientPaint(false, double_24, 0.0f, fArray8, colorArray8);
                graphics2D.setPaint(conicalGradientPaint);
                graphics2D.fill(double_23);
                Ellipse2D.Double double_25 = new Ellipse2D.Double((double)n2 * 0.47663551568984985, (double)n3 * 0.7445255517959595, (double)n2 * 0.05140185356140137, (double)n3 * 0.0802919864654541);
                Point2D.Double double_26 = new Point2D.Double(0.48372093023255813 * (double)n2, 0.7463768115942029 * (double)n3);
                Point2D.Double double_27 = new Point2D.Double(0.5123307997124568 * (double)n2, 0.812459516652938 * (double)n3);
                float[] fArray9 = new float[]{0.0f, 1.0f};
                Color[] colorArray9 = new Color[]{new Color(225, 235, 232, 255), new Color(196, 207, 207, 255)};
                LinearGradientPaint linearGradientPaint8 = new LinearGradientPaint(double_26, double_27, fArray9, colorArray9);
                graphics2D.setPaint(linearGradientPaint8);
                graphics2D.fill(double_25);
                Ellipse2D.Double double_28 = new Ellipse2D.Double((double)n2 * 0.47663551568984985, (double)n3 * 0.7445255517959595, (double)n2 * 0.05140185356140137, (double)n3 * 0.07299268245697021);
                Point2D.Double double_29 = new Point2D.Double(0.48372093023255813 * (double)n2, 0.7463768115942029 * (double)n3);
                Point2D.Double double_30 = new Point2D.Double(0.5071290052615661 * (double)n2, 0.8004444793695317 * (double)n3);
                float[] fArray10 = new float[]{0.0f, 1.0f};
                Color[] colorArray10 = new Color[]{new Color(237, 239, 237, 255), new Color(148, 161, 161, 255)};
                LinearGradientPaint linearGradientPaint9 = new LinearGradientPaint(double_29, double_30, fArray10, colorArray10);
                graphics2D.setPaint(linearGradientPaint9);
                graphics2D.fill(double_28);
                break;
            }
            case METAL_KNOB: {
                Color[] colorArray11;
                Ellipse2D.Double double_31 = new Ellipse2D.Double((double)n2 * 0.4579439163208008, (double)n3 * 0.7153284549713135, (double)n2 * 0.08411216735839844, (double)n3 * 0.1313868761062622);
                Point2D.Double double_32 = new Point2D.Double(0.0, double_31.getBounds2D().getMinY());
                Point2D.Double double_33 = new Point2D.Double(0.0, double_31.getBounds2D().getMaxY());
                float[] fArray11 = new float[]{0.0f, 0.47f, 1.0f};
                Color[] colorArray12 = new Color[]{new Color(92, 95, 101, 255), new Color(46, 49, 53, 255), new Color(22, 23, 26, 255)};
                LinearGradientPaint linearGradientPaint10 = new LinearGradientPaint(double_32, double_33, fArray11, colorArray12);
                graphics2D.setPaint(linearGradientPaint10);
                graphics2D.fill(double_31);
                Ellipse2D.Double double_34 = new Ellipse2D.Double((double)n2 * 0.46261683106422424, (double)n3 * 0.7226277589797974, (double)n2 * 0.0747663676738739, (double)n3 * 0.11678832769393921);
                Point2D.Double double_35 = new Point2D.Double(0.0, double_34.getBounds2D().getMinY());
                Point2D.Double double_36 = new Point2D.Double(0.0, double_34.getBounds2D().getMaxY());
                float[] fArray12 = new float[]{0.0f, 1.0f};
                switch (this.getModel().getKnobStyle()) {
                    case BLACK: {
                        colorArray11 = new Color[]{new Color(2828847), new Color(1710880)};
                        break;
                    }
                    case BRASS: {
                        colorArray11 = new Color[]{new Color(9858614), new Color(8150845)};
                        break;
                    }
                    default: {
                        colorArray11 = new Color[]{new Color(204, 204, 204, 255), new Color(87, 92, 98, 255)};
                    }
                }
                LinearGradientPaint linearGradientPaint11 = new LinearGradientPaint(double_35, double_36, fArray12, colorArray11);
                graphics2D.setPaint(linearGradientPaint11);
                graphics2D.fill(double_34);
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.5233644859813084, (double)n3 * 0.8321167883211679);
                generalPath.curveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.8102189781021898, (double)n2 * 0.5093457943925234, (double)n3 * 0.8029197080291971, (double)n2 * 0.5, (double)n3 * 0.8029197080291971);
                generalPath.curveTo((double)n2 * 0.49065420560747663, (double)n3 * 0.8029197080291971, (double)n2 * 0.48130841121495327, (double)n3 * 0.8102189781021898, (double)n2 * 0.4766355140186916, (double)n3 * 0.8321167883211679);
                generalPath.curveTo((double)n2 * 0.48598130841121495, (double)n3 * 0.8394160583941606, (double)n2 * 0.49065420560747663, (double)n3 * 0.8394160583941606, (double)n2 * 0.5, (double)n3 * 0.8394160583941606);
                generalPath.curveTo((double)n2 * 0.5093457943925234, (double)n3 * 0.8394160583941606, (double)n2 * 0.5186915887850467, (double)n3 * 0.8394160583941606, (double)n2 * 0.5233644859813084, (double)n3 * 0.8321167883211679);
                generalPath.closePath();
                Point2D.Double double_37 = new Point2D.Double(0.49767441860465117 * (double)n2, 0.8333333333333334 * (double)n3);
                float[] fArray13 = new float[]{0.0f, 1.0f};
                Color[] colorArray13 = new Color[]{new Color(255, 255, 255, 153), new Color(255, 255, 255, 0)};
                RadialGradientPaint radialGradientPaint2 = new RadialGradientPaint(double_37, (float)(0.03255813953488372 * (double)n2), fArray13, colorArray13);
                graphics2D.setPaint(radialGradientPaint2);
                graphics2D.fill(generalPath);
                GeneralPath generalPath2 = new GeneralPath();
                generalPath2.setWindingRule(0);
                generalPath2.moveTo((double)n2 * 0.5373831775700935, (double)n3 * 0.7518248175182481);
                generalPath2.curveTo((double)n2 * 0.5280373831775701, (double)n3 * 0.7299270072992701, (double)n2 * 0.514018691588785, (double)n3 * 0.7153284671532847, (double)n2 * 0.5, (double)n3 * 0.7153284671532847);
                generalPath2.curveTo((double)n2 * 0.48598130841121495, (double)n3 * 0.7153284671532847, (double)n2 * 0.4719626168224299, (double)n3 * 0.7299270072992701, (double)n2 * 0.46261682242990654, (double)n3 * 0.7518248175182481);
                generalPath2.curveTo((double)n2 * 0.4719626168224299, (double)n3 * 0.7591240875912408, (double)n2 * 0.48598130841121495, (double)n3 * 0.7664233576642335, (double)n2 * 0.5, (double)n3 * 0.7664233576642335);
                generalPath2.curveTo((double)n2 * 0.514018691588785, (double)n3 * 0.7664233576642335, (double)n2 * 0.5280373831775701, (double)n3 * 0.7591240875912408, (double)n2 * 0.5373831775700935, (double)n3 * 0.7518248175182481);
                generalPath2.closePath();
                Point2D.Double double_38 = new Point2D.Double(0.4930232558139535 * (double)n2, 0.7101449275362319 * (double)n3);
                float[] fArray14 = new float[]{0.0f, 1.0f};
                Color[] colorArray14 = new Color[]{new Color(255, 255, 255, 191), new Color(255, 255, 255, 0)};
                RadialGradientPaint radialGradientPaint3 = new RadialGradientPaint(double_38, (float)(0.04883720930232558 * (double)n2), fArray14, colorArray14);
                graphics2D.setPaint(radialGradientPaint3);
                graphics2D.fill(generalPath2);
                Ellipse2D.Double double_39 = new Ellipse2D.Double((double)n2 * 0.4813084006309509, (double)n3 * 0.7518247961997986, (double)n2 * (double)0.0373832f, (double)n3 * 0.0656934380531311);
                Point2D.Double double_40 = new Point2D.Double(0.0, double_39.getBounds2D().getMinY());
                Point2D.Double double_41 = new Point2D.Double(0.0, double_39.getBounds2D().getMaxY());
                float[] fArray15 = new float[]{0.0f, 1.0f};
                Color[] colorArray15 = new Color[]{new Color(0, 0, 0, 255), new Color(204, 204, 204, 255)};
                LinearGradientPaint linearGradientPaint12 = new LinearGradientPaint(double_40, double_41, fArray15, colorArray15);
                graphics2D.setPaint(linearGradientPaint12);
                graphics2D.fill(double_39);
                Ellipse2D.Double double_42 = new Ellipse2D.Double((double)n2 * 0.4859813153743744, (double)n3 * 0.7591241002082825, (double)n2 * 0.02803739905357361, (double)n3 * (double)0.05109489f);
                Point2D.Double double_43 = new Point2D.Double(0.0, double_42.getBounds2D().getMinY());
                Point2D.Double double_44 = new Point2D.Double(0.0, double_42.getBounds2D().getMaxY());
                float[] fArray16 = new float[]{0.0f, 1.0f};
                Color[] colorArray16 = new Color[]{new Color(1, 6, 11, 255), new Color(50, 52, 56, 255)};
                LinearGradientPaint linearGradientPaint13 = new LinearGradientPaint(double_43, double_44, fArray16, colorArray16);
                graphics2D.setPaint(linearGradientPaint13);
                graphics2D.fill(double_42);
            }
        }
        n3 = bufferedImage.getHeight();
        if (this.getPostsVisible()) {
            double_16 = new Ellipse2D.Double((double)n2 * 0.8317757248878479, (double)n3 * 0.514018714427948, (double)n2 * 0.03738313913345337, (double)n3 * 0.03738313913345337);
            double_15 = new Point2D.Double(0.0, double_16.getBounds2D().getMinY());
            double_14 = new Point2D.Double(0.0, double_16.getBounds2D().getMaxY());
            fArray5 = new float[]{0.0f, 0.46f, 1.0f};
            colorArray5 = new Color[]{new Color(180, 180, 180, 255), new Color(63, 63, 63, 255), new Color(40, 40, 40, 255)};
            linearGradientPaint4 = new LinearGradientPaint(double_15, double_14, fArray5, colorArray5);
            graphics2D.setPaint(linearGradientPaint4);
            graphics2D.fill(double_16);
            double_13 = new Ellipse2D.Double((double)n2 * 0.836448609828949, (double)n3 * 0.5186915993690491, (double)n2 * 0.02803736925125122, (double)n3 * 0.02803736925125122);
            double_12 = new Point2D.Double(0.0, double_13.getBounds2D().getMinY());
            double_11 = new Point2D.Double(0.0, double_13.getBounds2D().getMaxY());
            fArray4 = new float[]{0.0f, 0.5f, 1.0f};
            switch (this.getModel().getKnobStyle()) {
                case BLACK: {
                    colorArray4 = new Color[]{new Color(0xBFBFBF), new Color(2828847), new Color(8224384)};
                    break;
                }
                case BRASS: {
                    colorArray4 = new Color[]{new Color(14667950), new Color(8019518), new Color(13614749)};
                    break;
                }
                default: {
                    colorArray4 = new Color[]{new Color(0xD7D7D7), new Color(0x747474), new Color(0xD7D7D7)};
                }
            }
            linearGradientPaint3 = new LinearGradientPaint(double_12, double_11, fArray4, colorArray4);
            graphics2D.setPaint(linearGradientPaint3);
            graphics2D.fill(double_13);
            double_10 = new Ellipse2D.Double((double)n2 * 0.836448609828949, (double)n3 * 0.5186915993690491, (double)n2 * 0.02803736925125122, (double)n3 * 0.02803736925125122);
            double_9 = new Point2D.Double(0.8504672897196262 * (double)n2, 0.5280373831775701 * (double)n3);
            fArray3 = new float[]{0.0f, 0.75f, 0.76f, 1.0f};
            colorArray3 = new Color[]{new Color(0, 0, 0, 0), new Color(0, 0, 0, 0), new Color(0, 0, 0, 1), new Color(0, 0, 0, 51)};
            radialGradientPaint = new RadialGradientPaint(double_9, (float)(0.014018691588785047 * (double)n2), fArray3, colorArray3);
            graphics2D.setPaint(radialGradientPaint);
            graphics2D.fill(double_10);
            double_8 = new Ellipse2D.Double((double)n2 * 0.13084112107753754, (double)n3 * 0.514018714427948, (double)n2 * 0.03738318383693695, (double)n3 * 0.03738313913345337);
            double_7 = new Point2D.Double(0.0, double_8.getBounds2D().getMinY());
            double_6 = new Point2D.Double(0.0, double_8.getBounds2D().getMaxY());
            fArray2 = new float[]{0.0f, 0.46f, 1.0f};
            colorArray2 = new Color[]{new Color(180, 180, 180, 255), new Color(63, 63, 63, 255), new Color(40, 40, 40, 255)};
            linearGradientPaint2 = new LinearGradientPaint(double_7, double_6, fArray2, colorArray2);
            graphics2D.setPaint(linearGradientPaint2);
            graphics2D.fill(double_8);
            double_5 = new Ellipse2D.Double((double)n2 * 0.1355140209197998, (double)n3 * 0.5186915993690491, (double)n2 * 0.028037384152412415, (double)n3 * 0.02803736925125122);
            double_4 = new Point2D.Double(0.0, double_5.getBounds2D().getMinY());
            double_3 = new Point2D.Double(0.0, double_5.getBounds2D().getMaxY());
            fArray = new float[]{0.0f, 0.5f, 1.0f};
            switch (this.getModel().getKnobStyle()) {
                case BLACK: {
                    colorArray = new Color[]{new Color(0xBFBFBF), new Color(2828847), new Color(8224384)};
                    break;
                }
                case BRASS: {
                    colorArray = new Color[]{new Color(14667950), new Color(8019518), new Color(13614749)};
                    break;
                }
                default: {
                    colorArray = new Color[]{new Color(0xD7D7D7), new Color(0x747474), new Color(0xD7D7D7)};
                }
            }
            linearGradientPaint = new LinearGradientPaint(double_4, double_3, fArray, colorArray);
            graphics2D.setPaint(linearGradientPaint);
            graphics2D.fill(double_5);
            double_2 = new Ellipse2D.Double((double)n2 * 0.1355140209197998, (double)n3 * 0.5186915993690491, (double)n2 * 0.028037384152412415, (double)n3 * 0.02803736925125122);
            double_ = new Point2D.Double(0.14953271028037382 * (double)n2, 0.5280373831775701 * (double)n3);
            object2 = new float[]{0.0f, 0.75f, 0.76f, 1.0f};
            objectArray = new Color[]{new Color(0, 0, 0, 0), new Color(0, 0, 0, 0), new Color(0, 0, 0, 1), new Color(0, 0, 0, 51)};
            object = new RadialGradientPaint(double_, (float)(0.014018691588785047 * (double)n2), (float[])object2, (Color[])objectArray);
            graphics2D.setPaint((Paint)object);
            graphics2D.fill(double_2);
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    protected BufferedImage create_DISABLED_Image(int n) {
        if (n <= 0) {
            return null;
        }
        BufferedImage bufferedImage = UTIL.createImage(n, (int)(0.641860465116279 * (double)n), 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n2 * 0.08372093023255814, (double)n3 * 0.7753623188405797);
        generalPath.curveTo((double)n2 * 0.08372093023255814, (double)n3 * 0.42028985507246375, (double)n2 * 0.26976744186046514, (double)n3 * 0.13043478260869565, (double)n2 * 0.49767441860465117, (double)n3 * 0.13043478260869565);
        generalPath.curveTo((double)n2 * 0.7255813953488373, (double)n3 * 0.13043478260869565, (double)n2 * 0.9116279069767442, (double)n3 * 0.42028985507246375, (double)n2 * 0.9116279069767442, (double)n3 * 0.7753623188405797);
        generalPath.curveTo((double)n2 * 0.9116279069767442, (double)n3 * 0.8188405797101449, (double)n2 * 0.9069767441860465, (double)n3 * 0.8695652173913043, (double)n2 * 0.9069767441860465, (double)n3 * 0.8695652173913043);
        generalPath.lineTo((double)n2 * 0.08837209302325581, (double)n3 * 0.8695652173913043);
        generalPath.curveTo((double)n2 * 0.08837209302325581, (double)n3 * 0.8695652173913043, (double)n2 * 0.08372093023255814, (double)n3 * 0.8115942028985508, (double)n2 * 0.08372093023255814, (double)n3 * 0.7753623188405797);
        generalPath.closePath();
        graphics2D.setColor(new Color(102, 102, 102, 178));
        graphics2D.fill(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    public String toString() {
        return "Radial2Top";
    }
}

