/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.gauges;

import eu.hansolo.steelseries.gauges.AbstractGauge;
import eu.hansolo.steelseries.gauges.AbstractRadialBargraph;
import eu.hansolo.steelseries.tools.ColorDef;
import eu.hansolo.steelseries.tools.GaugeType;
import eu.hansolo.steelseries.tools.LcdColor;
import eu.hansolo.steelseries.tools.Model;
import eu.hansolo.steelseries.tools.NumberSystem;
import eu.hansolo.steelseries.tools.Orientation;
import eu.hansolo.steelseries.tools.Section;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;

public class RadialBargraph
extends AbstractRadialBargraph {
    private static final int BASE = 10;
    private double ledTrackStartAngle;
    private double ledTrackAngleExtend;
    private BufferedImage bImage;
    private BufferedImage fImage;
    private BufferedImage glowImageOff;
    private BufferedImage glowImageOn;
    private BufferedImage lcdThresholdImage;
    private BufferedImage disabledImage;
    private ColorDef barGraphColor;
    private final Point2D CENTER;
    private Rectangle2D led;
    private final Point2D LED_CENTER;
    private Color[] ledColors;
    private final float[] LED_FRACTIONS;
    private RadialGradientPaint ledGradient;
    private HashMap<Section, RadialGradientPaint> sectionGradients;
    private HashMap<Section, Point2D> sectionAngles;
    private final Rectangle2D LCD = new Rectangle2D.Double();
    private final FontRenderContext RENDER_CONTEXT = new FontRenderContext(null, true, true);
    private TextLayout unitLayout;
    private final Rectangle2D UNIT_BOUNDARY = new Rectangle2D.Double();
    private TextLayout valueLayout;
    private final Rectangle2D VALUE_BOUNDARY = new Rectangle2D.Double();
    private TextLayout infoLayout;
    private final Rectangle2D INFO_BOUNDARY = new Rectangle2D.Double();

    public RadialBargraph() {
        this.barGraphColor = ColorDef.RED;
        this.CENTER = new Point2D.Double();
        this.LED_CENTER = new Point2D.Double();
        this.LED_FRACTIONS = new float[]{0.0f, 1.0f};
        this.sectionGradients = new HashMap(4);
        this.sectionAngles = new HashMap(4);
        this.ledTrackStartAngle = this.getGaugeType().ORIGIN_CORRECTION - 0.0 * (this.getGaugeType().APEX_ANGLE / (this.getMaxValue() - this.getMinValue()));
        this.ledTrackAngleExtend = -(this.getMaxValue() - this.getMinValue()) * (this.getGaugeType().APEX_ANGLE / (this.getMaxValue() - this.getMinValue()));
        this.calcBargraphTrack();
        this.prepareBargraph(this.getInnerBounds().width);
        this.setLcdVisible(true);
    }

    public RadialBargraph(Model model) {
        this.setModel(model);
        this.barGraphColor = ColorDef.RED;
        this.CENTER = new Point2D.Double();
        this.LED_CENTER = new Point2D.Double();
        this.LED_FRACTIONS = new float[]{0.0f, 1.0f};
        this.sectionGradients = new HashMap(4);
        this.sectionAngles = new HashMap(4);
        this.ledTrackStartAngle = this.getGaugeType().ORIGIN_CORRECTION - 0.0 * (this.getGaugeType().APEX_ANGLE / (this.getMaxValue() - this.getMinValue()));
        this.ledTrackAngleExtend = -(this.getMaxValue() - this.getMinValue()) * (this.getGaugeType().APEX_ANGLE / (this.getMaxValue() - this.getMinValue()));
        this.calcBargraphTrack();
        this.prepareBargraph(this.getGaugeBounds().width);
    }

    @Override
    public final AbstractGauge init(int n, int n2) {
        int n3;
        int n4 = this.isFrameVisible() ? n : this.getGaugeBounds().width;
        int n5 = n3 = this.isFrameVisible() ? n2 : this.getGaugeBounds().height;
        if (n4 <= 1 || n3 <= 1) {
            return this;
        }
        if (!this.isFrameVisible()) {
            this.setFramelessOffset((double)(-this.getGaugeBounds().width) * 0.0841121495, (double)(-this.getGaugeBounds().width) * 0.0841121495);
        } else {
            this.setFramelessOffset(this.getGaugeBounds().x, this.getGaugeBounds().y);
        }
        this.CENTER.setLocation(this.getGaugeBounds().getCenterX() - (double)this.getInsets().left, this.getGaugeBounds().getCenterX() - (double)this.getInsets().top);
        if (this.isLcdVisible()) {
            if (this.isDigitalFont()) {
                this.setLcdValueFont(this.getModel().getDigitalBaseFont().deriveFont(0.7f * (float)n4 * 0.15f));
            } else {
                this.setLcdValueFont(this.getModel().getStandardBaseFont().deriveFont(0.625f * (float)n4 * 0.15f));
            }
            if (this.isCustomLcdUnitFontEnabled()) {
                this.setLcdUnitFont(this.getCustomLcdUnitFont().deriveFont(0.25f * (float)n4 * 0.15f));
            } else {
                this.setLcdUnitFont(this.getModel().getStandardBaseFont().deriveFont(0.25f * (float)n4 * 0.15f));
            }
            this.setLcdInfoFont(this.getModel().getStandardInfoFont().deriveFont(0.15f * (float)n4 * 0.15f));
        }
        this.ledTrackStartAngle = this.getGaugeType().ORIGIN_CORRECTION - 0.0 * (this.getGaugeType().APEX_ANGLE / (this.getMaxValue() - this.getMinValue()));
        this.ledTrackAngleExtend = -(this.getMaxValue() - this.getMinValue()) * (this.getGaugeType().APEX_ANGLE / (this.getMaxValue() - this.getMinValue()));
        this.calcBargraphTrack();
        this.prepareBargraph(this.getGaugeBounds().width);
        if (this.bImage != null) {
            this.bImage.flush();
        }
        this.bImage = UTIL.createImage(n4, n4, 3);
        if (this.fImage != null) {
            this.fImage.flush();
        }
        this.fImage = UTIL.createImage(n4, n4, 3);
        if (this.isFrameVisible()) {
            switch (this.getFrameType()) {
                case ROUND: {
                    FRAME_FACTORY.createRadialFrame(n4, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameBaseColor(), this.isFrameBaseColorEnabled(), this.getFrameEffect(), this.bImage);
                    break;
                }
                case SQUARE: {
                    FRAME_FACTORY.createLinearFrame(n4, n4, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameBaseColor(), this.isFrameBaseColorEnabled(), this.getFrameEffect(), this.bImage);
                    break;
                }
                default: {
                    FRAME_FACTORY.createRadialFrame(n4, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameBaseColor(), this.isFrameBaseColorEnabled(), this.getFrameEffect(), this.bImage);
                }
            }
        }
        if (this.isBackgroundVisible()) {
            this.create_BACKGROUND_Image(n4, "", "", this.bImage);
        }
        if (this.isGlowVisible()) {
            if (this.glowImageOff != null) {
                this.glowImageOff.flush();
            }
            this.glowImageOff = this.create_GLOW_Image(n4, this.getGlowColor(), false, this.getGaugeType(), false, this.getOrientation());
            if (this.glowImageOn != null) {
                this.glowImageOn.flush();
            }
            this.glowImageOn = this.create_GLOW_Image(n4, this.getGlowColor(), true, this.getGaugeType(), false, this.getOrientation());
        } else {
            this.setGlowPulsating(false);
        }
        this.create_BARGRAPH_TRACK_Image(n4, this.ledTrackStartAngle, this.ledTrackAngleExtend, this.getGaugeType().APEX_ANGLE, this.getGaugeType().BARGRAPH_OFFSET, this.bImage);
        this.create_TITLE_Image(n4, this.getTitle(), this.getUnitString(), this.bImage);
        if (this.isLcdVisible()) {
            this.create_LCD_Image(new Rectangle2D.Double(((double)this.getGaugeBounds().width - (double)n4 * 0.48) / 2.0, (double)this.getGaugeBounds().height * 0.425, (double)n4 * 0.48, (double)n4 * 0.15), this.getLcdColor(), this.getCustomLcdBackground(), this.bImage);
            this.LCD.setRect(((double)this.getGaugeBounds().width - (double)n4 * 0.48) / 2.0, (double)this.getGaugeBounds().height * 0.425, (double)n4 * 0.48, (double)n4 * 0.15);
            if (this.lcdThresholdImage != null) {
                this.lcdThresholdImage.flush();
            }
            this.lcdThresholdImage = this.create_LCD_THRESHOLD_Image((int)(this.LCD.getHeight() * 0.2045454545), (int)(this.LCD.getHeight() * 0.2045454545), this.getLcdColor().TEXT_COLOR);
        }
        TICKMARK_FACTORY.create_RADIAL_TICKMARKS_Image(n4, this.getModel().getNiceMinValue(), this.getModel().getNiceMaxValue(), this.getModel().getMaxNoOfMinorTicks(), this.getModel().getMaxNoOfMajorTicks(), this.getModel().getMinorTickSpacing(), this.getModel().getMajorTickSpacing(), this.getGaugeType(), this.getMinorTickmarkType(), this.getMajorTickmarkType(), false, this.isTicklabelsVisible(), false, false, this.getLabelNumberFormat(), this.isTickmarkSectionsVisible(), this.getBackgroundColor(), this.getTickmarkColor(), this.isTickmarkColorFromThemeEnabled(), this.getTickmarkSections(), 0.38f, 0.105f, new Point2D.Double(this.getGaugeBounds().getCenterX() - (double)this.getInsets().left, this.getGaugeBounds().getCenterX() - (double)this.getInsets().top), new Point2D.Double(0.0, 0.0), Orientation.NORTH, this.getModel().getTicklabelOrientation(), this.getModel().isNiceScale(), this.getModel().isLogScale(), this.bImage);
        if (this.isForegroundVisible()) {
            FOREGROUND_FACTORY.createRadialForeground(n4, false, this.getForegroundType(), this.fImage);
        }
        if (this.disabledImage != null) {
            this.disabledImage.flush();
        }
        this.disabledImage = this.create_DISABLED_Image(n4);
        this.setCurrentLedImage(this.getLedImageOff());
        return this;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Cloneable cloneable;
        if (!this.isInitialized()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.translate(this.getFramelessOffset().getX(), this.getFramelessOffset().getY());
        graphics2D.drawImage((Image)this.bImage, 0, 0, null);
        if (this.isRangeOfMeasuredValuesVisible()) {
            graphics2D.setPaint(this.getModel().getRangeOfMeasuredValuesPaint());
            if (this.getGaugeType() == GaugeType.TYPE3 || this.getGaugeType() == GaugeType.TYPE4) {
                cloneable = new Area(this.getModel().getRadialShapeOfMeasuredValues());
                ((Area)cloneable).subtract(new Area(this.LCD));
                graphics2D.fill((Shape)((Object)cloneable));
            } else {
                graphics2D.fill(this.getModel().getRadialShapeOfMeasuredValues());
            }
        }
        if (this.isLedVisible()) {
            graphics2D.drawImage((Image)this.getCurrentLedImage(), (int)((double)this.getGaugeBounds().width * this.getLedPosition().getX()), (int)((double)this.getGaugeBounds().height * this.getLedPosition().getY()), null);
        }
        if (this.isUserLedVisible()) {
            graphics2D.drawImage((Image)this.getCurrentUserLedImage(), (int)((double)this.getGaugeBounds().width * this.getUserLedPosition().getX()), (int)((double)this.getGaugeBounds().height * this.getUserLedPosition().getY()), null);
        }
        if (this.isLcdVisible()) {
            double d;
            if (this.getLcdColor() == LcdColor.CUSTOM) {
                graphics2D.setColor(this.getCustomLcdForeground());
            } else {
                graphics2D.setColor(this.getLcdColor().TEXT_COLOR);
            }
            graphics2D.setFont(this.getLcdUnitFont());
            if (this.isLcdUnitStringVisible()) {
                this.unitLayout = new TextLayout(this.getLcdUnitString(), graphics2D.getFont(), this.RENDER_CONTEXT);
                this.UNIT_BOUNDARY.setFrame(this.unitLayout.getBounds());
                graphics2D.drawString(this.getLcdUnitString(), (int)(this.LCD.getX() + (this.LCD.getWidth() - this.UNIT_BOUNDARY.getWidth()) - this.LCD.getWidth() * 0.03), (int)(this.LCD.getY() + this.LCD.getHeight() * 0.76));
                d = this.UNIT_BOUNDARY.getWidth();
            } else {
                d = 0.0;
            }
            graphics2D.setFont(this.getLcdValueFont());
            switch (this.getModel().getNumberSystem()) {
                case HEX: {
                    this.valueLayout = new TextLayout(Integer.toHexString((int)this.getLcdValue()).toUpperCase(), graphics2D.getFont(), this.RENDER_CONTEXT);
                    this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                    graphics2D.drawString(Integer.toHexString((int)this.getLcdValue()).toUpperCase(), (int)(this.LCD.getX() + (this.LCD.getWidth() - d - this.VALUE_BOUNDARY.getWidth()) - this.LCD.getWidth() * 0.09), (int)(this.LCD.getY() + this.LCD.getHeight() * 0.76));
                    break;
                }
                case OCT: {
                    this.valueLayout = new TextLayout(Integer.toOctalString((int)this.getLcdValue()), graphics2D.getFont(), this.RENDER_CONTEXT);
                    this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                    graphics2D.drawString(Integer.toOctalString((int)this.getLcdValue()), (int)(this.LCD.getX() + (this.LCD.getWidth() - d - this.VALUE_BOUNDARY.getWidth()) - this.LCD.getWidth() * 0.09), (int)(this.LCD.getY() + this.LCD.getHeight() * 0.76));
                    break;
                }
                default: {
                    this.valueLayout = new TextLayout(this.formatLcdValue(this.getLcdValue()), graphics2D.getFont(), this.RENDER_CONTEXT);
                    this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                    graphics2D.drawString(this.formatLcdValue(this.getLcdValue()), (int)(this.LCD.getX() + (this.LCD.getWidth() - d - this.VALUE_BOUNDARY.getWidth()) - this.LCD.getWidth() * 0.09), (int)(this.LCD.getY() + this.LCD.getHeight() * 0.76));
                }
            }
            if (!this.getLcdInfoString().isEmpty()) {
                graphics2D.setFont(this.getLcdInfoFont());
                this.infoLayout = new TextLayout(this.getLcdInfoString(), graphics2D.getFont(), this.RENDER_CONTEXT);
                this.INFO_BOUNDARY.setFrame(this.infoLayout.getBounds());
                graphics2D.drawString(this.getLcdInfoString(), this.LCD.getBounds().x + 5, this.LCD.getBounds().y + (int)this.INFO_BOUNDARY.getHeight() + 5);
            }
            if (this.getLcdNumberSystem() == NumberSystem.DEC && this.isLcdThresholdVisible() && this.getLcdValue() >= this.getLcdThreshold()) {
                graphics2D.drawImage((Image)this.lcdThresholdImage, (int)(this.LCD.getX() + this.LCD.getHeight() * 0.0568181818), (int)(this.LCD.getY() + this.LCD.getHeight() - (double)this.lcdThresholdImage.getHeight() - this.LCD.getHeight() * 0.0568181818), null);
            }
        }
        cloneable = graphics2D.getTransform();
        double d = !this.isLogScale() ? (this.getValue() + Math.abs(this.getMinValue())) / (this.getMaxValue() - this.getMinValue()) * this.getGaugeType().APEX_ANGLE : Math.toDegrees(UTIL.logOfBase(10.0, this.getValue() - this.getMinValue()) * this.getLogAngleStep());
        if (!this.getModel().isSingleLedBargraphEnabled()) {
            double d2 = 0.0;
            while (Double.compare(d2, d) <= 0) {
                graphics2D.rotate(Math.toRadians(d2 + this.getGaugeType().BARGRAPH_OFFSET), this.CENTER.getX(), this.CENTER.getY());
                graphics2D.setPaint(this.ledGradient);
                if (this.isSectionsVisible()) {
                    for (Section section : this.getSections()) {
                        if (Double.compare(d2, this.sectionAngles.get(section).getX()) < 0 || !(d2 < this.sectionAngles.get(section).getY())) continue;
                        graphics2D.setPaint(this.sectionGradients.get(section));
                        break;
                    }
                } else {
                    graphics2D.setPaint(this.ledGradient);
                }
                graphics2D.fill(this.led);
                graphics2D.setTransform((AffineTransform)cloneable);
                d2 += 5.0;
            }
        } else {
            double d3 = Math.toRadians((this.getValue() + Math.abs(this.getMinValue())) / (this.getMaxValue() - this.getMinValue()) * this.getGaugeType().APEX_ANGLE);
            graphics2D.rotate(d3, this.CENTER.getX(), this.CENTER.getY());
            if (this.isSectionsVisible()) {
                for (Section section : this.getSections()) {
                    if (Double.compare(d3, this.sectionAngles.get(section).getX()) < 0 || !(d3 < this.sectionAngles.get(section).getY())) continue;
                    graphics2D.setPaint(this.sectionGradients.get(section));
                    break;
                }
            } else {
                graphics2D.setPaint(this.ledGradient);
            }
            graphics2D.fill(this.led);
            graphics2D.setTransform((AffineTransform)cloneable);
        }
        if (this.isPeakValueEnabled() && this.isPeakValueVisible()) {
            graphics2D.rotate(Math.toRadians((this.getPeakValue() + Math.abs(this.getMinValue())) / (this.getMaxValue() - this.getMinValue()) * this.getGaugeType().APEX_ANGLE + this.getGaugeType().BARGRAPH_OFFSET), this.CENTER.getX(), this.CENTER.getY());
            graphics2D.fill(this.led);
            graphics2D.setTransform((AffineTransform)cloneable);
        }
        if (this.isForegroundVisible()) {
            graphics2D.drawImage((Image)this.fImage, 0, 0, null);
        }
        if (this.isGlowVisible()) {
            if (this.isGlowing()) {
                graphics2D.setComposite(AlphaComposite.getInstance(3, this.getGlowAlpha()));
                graphics2D.drawImage((Image)this.glowImageOn, 0, 0, null);
                graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
            } else {
                graphics2D.drawImage((Image)this.glowImageOff, 0, 0, null);
            }
        }
        if (!this.isEnabled()) {
            graphics2D.drawImage((Image)this.disabledImage, 0, 0, null);
        }
        graphics2D.dispose();
    }

    @Override
    public ColorDef getBarGraphColor() {
        return this.barGraphColor;
    }

    @Override
    public void setBarGraphColor(ColorDef colorDef) {
        this.barGraphColor = colorDef;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    private void prepareBargraph(int n) {
        this.led = new Rectangle2D.Double((double)n * 0.1168224299, (double)n * 0.4859813084, (double)n * 0.06074766355140187, (double)n * 0.023364486);
        this.LED_CENTER.setLocation(this.led.getCenterX(), this.led.getCenterY());
        if (!this.getSections().isEmpty()) {
            this.sectionGradients.clear();
            this.sectionAngles.clear();
            for (Section section : this.getSections()) {
                this.sectionGradients.put(section, new RadialGradientPaint(this.LED_CENTER, (float)(0.030373831775700934 * (double)n), this.LED_FRACTIONS, new Color[]{section.getColor().brighter(), section.getColor().darker()}));
                this.sectionAngles.put(section, new Point2D.Double((section.getStart() + Math.abs(this.getMinValue())) / (this.getMaxValue() - this.getMinValue()) * this.getGaugeType().APEX_ANGLE, (section.getStop() + Math.abs(this.getMinValue())) / (this.getMaxValue() - this.getMinValue()) * this.getGaugeType().APEX_ANGLE));
            }
        }
        this.ledColors = this.barGraphColor != ColorDef.CUSTOM ? new Color[]{this.barGraphColor.LIGHT, this.barGraphColor.DARK} : new Color[]{this.getCustomBarGraphColorObject().LIGHT, this.getCustomBarGraphColorObject().DARK};
        this.ledGradient = new RadialGradientPaint(this.LED_CENTER, (float)(0.030373831775700934 * (double)n), this.LED_FRACTIONS, this.ledColors);
    }

    private void calcBargraphTrack() {
        this.ledTrackStartAngle = this.getGaugeType().ORIGIN_CORRECTION;
        this.ledTrackAngleExtend = -(this.getMaxValue() - this.getMinValue()) * (this.getGaugeType().APEX_ANGLE / (this.getMaxValue() - this.getMinValue()));
    }

    @Override
    public void setValue(double d) {
        if (this.isValueCoupled()) {
            this.setLcdValue(d);
        }
        super.setValue(d);
    }

    @Override
    public Paint createCustomLcdBackgroundPaint(Color[] colorArray) {
        Point2D.Double double_;
        Point2D.Double double_2 = new Point2D.Double(0.0, this.LCD.getMinY() + 1.0);
        if (double_2.equals(double_ = new Point2D.Double(0.0, this.LCD.getMaxY() - 1.0))) {
            ((Point2D)double_).setLocation(0.0, ((Point2D)double_2).getY() + 1.0);
        }
        float[] fArray = new float[]{0.0f, 0.03f, 0.49f, 0.5f, 1.0f};
        Color[] colorArray2 = new Color[]{colorArray[0], colorArray[1], colorArray[2], colorArray[3], colorArray[4]};
        return new LinearGradientPaint(double_2, double_, fArray, colorArray2);
    }

    @Override
    public Point2D getCenter() {
        return new Point2D.Double(this.getInnerBounds().getCenterX() + (double)this.getInnerBounds().x, this.getInnerBounds().getCenterX() + (double)this.getInnerBounds().y);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.getInnerBounds();
    }

    @Override
    public Rectangle getLcdBounds() {
        return this.LCD.getBounds();
    }

    @Override
    public String toString() {
        return "RadialBargraph " + (Object)((Object)this.getGaugeType());
    }
}

