/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.tools;

import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public final class ConicalGradientPaint
implements Paint {
    private final Point2D CENTER;
    private final float[] FRACTION_ANGLES;
    private final float[] RED_STEP_LOOKUP;
    private final float[] GREEN_STEP_LOOKUP;
    private final float[] BLUE_STEP_LOOKUP;
    private final float[] ALPHA_STEP_LOOKUP;
    private final Color[] COLORS;
    private static final float INT_TO_FLOAT_CONST = 0.003921569f;

    public ConicalGradientPaint(Point2D point2D, float[] fArray, Color[] colorArray) throws IllegalArgumentException {
        this(false, point2D, 0.0f, fArray, colorArray);
    }

    public ConicalGradientPaint(boolean bl, Point2D point2D, float f, float[] fArray, Color[] colorArray) throws IllegalArgumentException {
        int n;
        Object object;
        float f2;
        if (fArray.length != colorArray.length) {
            throw new IllegalArgumentException("Fractions and colors must be equal in size");
        }
        ArrayList<Float> arrayList = new ArrayList<Float>(fArray.length);
        if (bl) {
            f2 = Float.compare(f * 0.0027777778f, -0.5f) == 0 ? -0.5f : (Float.compare(f * 0.0027777778f, 0.5f) == 0 ? 0.5f : f * 0.0027777778f);
            for (float f3 : fArray) {
                arrayList.add(Float.valueOf(f3 * 0.0027777778f));
            }
        } else {
            f2 = f;
            for (float f4 : fArray) {
                arrayList.add(Float.valueOf(f4));
            }
        }
        if (f2 > 0.5f || f2 < -0.5f) {
            throw new IllegalArgumentException("Offset has to be in the range of -0.5 to 0.5");
        }
        Object object2 = new ArrayList(colorArray.length);
        object2.addAll(Arrays.asList(colorArray));
        if (((Float)arrayList.get(0)).floatValue() != 0.0f) {
            arrayList.add(0, Float.valueOf(0.0f));
            object = (Color)object2.get(0);
            object2.add(0, object);
        }
        if (((Float)arrayList.get(arrayList.size() - 1)).floatValue() != 1.0f) {
            arrayList.add(Float.valueOf(1.0f));
            object2.add(colorArray[0]);
        }
        object = this.recalculate(arrayList, (List<Color>)object2, f2);
        arrayList.clear();
        object2.clear();
        TreeSet treeSet = new TreeSet(object.keySet());
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            float f3;
            f3 = ((Float)iterator.next()).floatValue();
            arrayList.add(Float.valueOf(f3));
            object2.add(object.get(Float.valueOf(f3)));
        }
        this.CENTER = point2D;
        this.COLORS = object2.toArray(new Color[0]);
        int n2 = arrayList.size();
        this.FRACTION_ANGLES = new float[n2];
        for (n = 0; n < n2; ++n) {
            this.FRACTION_ANGLES[n] = ((Float)arrayList.get(n)).floatValue() * 360.0f;
        }
        this.RED_STEP_LOOKUP = new float[this.COLORS.length];
        this.GREEN_STEP_LOOKUP = new float[this.COLORS.length];
        this.BLUE_STEP_LOOKUP = new float[this.COLORS.length];
        this.ALPHA_STEP_LOOKUP = new float[this.COLORS.length];
        for (n = 0; n < this.COLORS.length - 1; ++n) {
            this.RED_STEP_LOOKUP[n] = (float)(this.COLORS[n + 1].getRed() - this.COLORS[n].getRed()) * 0.003921569f / (this.FRACTION_ANGLES[n + 1] - this.FRACTION_ANGLES[n]);
            this.GREEN_STEP_LOOKUP[n] = (float)(this.COLORS[n + 1].getGreen() - this.COLORS[n].getGreen()) * 0.003921569f / (this.FRACTION_ANGLES[n + 1] - this.FRACTION_ANGLES[n]);
            this.BLUE_STEP_LOOKUP[n] = (float)(this.COLORS[n + 1].getBlue() - this.COLORS[n].getBlue()) * 0.003921569f / (this.FRACTION_ANGLES[n + 1] - this.FRACTION_ANGLES[n]);
            this.ALPHA_STEP_LOOKUP[n] = (float)(this.COLORS[n + 1].getAlpha() - this.COLORS[n].getAlpha()) * 0.003921569f / (this.FRACTION_ANGLES[n + 1] - this.FRACTION_ANGLES[n]);
        }
    }

    private HashMap<Float, Color> recalculate(List<Float> list, List<Color> list2, float f) {
        int n = list.size();
        HashMap<Float, Color> hashMap = new HashMap<Float, Color>(n);
        for (int i = 0; i < n; ++i) {
            Color color;
            Color color2;
            float f2;
            float f3 = list.get(i).floatValue() + f;
            Color color3 = list2.get(i);
            if (f3 <= 0.0f) {
                hashMap.put(Float.valueOf(1.0f + f3 + 1.0E-4f), color3);
                if (i < n - 1) {
                    f2 = list.get(i + 1).floatValue() + f;
                    color2 = list2.get(i + 1);
                } else {
                    f2 = 1.0f - list.get(0).floatValue() + f;
                    color2 = list2.get(0);
                }
                if (!(f2 > 0.0f)) continue;
                color = this.getColorFromFraction(color3, color2, (int)((f2 - f3) * 10000.0f), (int)(-f3 * 10000.0f));
                hashMap.put(Float.valueOf(0.0f), color);
                hashMap.put(Float.valueOf(1.0f), color);
                continue;
            }
            if (f3 >= 1.0f) {
                hashMap.put(Float.valueOf(f3 - 1.0f - 1.0E-4f), color3);
                if (i > 0) {
                    f2 = list.get(i - 1).floatValue() + f;
                    color2 = list2.get(i - 1);
                } else {
                    f2 = list.get(n - 1).floatValue() + f;
                    color2 = list2.get(n - 1);
                }
                if (!(f2 < 1.0f)) continue;
                color = this.getColorFromFraction(color3, color2, (int)((f3 - f2) * 10000.0f), (int)(f3 - 1.0f) * 10000);
                hashMap.put(Float.valueOf(1.0f), color);
                hashMap.put(Float.valueOf(0.0f), color);
                continue;
            }
            hashMap.put(Float.valueOf(f3), color3);
        }
        list.clear();
        list2.clear();
        return hashMap;
    }

    public Color getColorFromFraction(Color color, Color color2, int n, int n2) {
        float f = (float)color.getRed() * 0.003921569f;
        float f2 = (float)color.getGreen() * 0.003921569f;
        float f3 = (float)color.getBlue() * 0.003921569f;
        float f4 = (float)color.getAlpha() * 0.003921569f;
        float f5 = (float)color2.getRed() * 0.003921569f;
        float f6 = (float)color2.getGreen() * 0.003921569f;
        float f7 = (float)color2.getBlue() * 0.003921569f;
        float f8 = (float)color2.getAlpha() * 0.003921569f;
        float f9 = f5 - f;
        float f10 = f6 - f2;
        float f11 = f7 - f3;
        float f12 = f8 - f4;
        float f13 = f9 / (float)n;
        float f14 = f10 / (float)n;
        float f15 = f11 / (float)n;
        float f16 = f12 / (float)n;
        float f17 = f + f13 * (float)n2;
        float f18 = f2 + f14 * (float)n2;
        float f19 = f3 + f15 * (float)n2;
        float f20 = f4 + f16 * (float)n2;
        float f21 = f17 < 0.0f ? 0.0f : (f17 = f17 > 1.0f ? 1.0f : f17);
        float f22 = f18 < 0.0f ? 0.0f : (f18 = f18 > 1.0f ? 1.0f : f18);
        float f23 = f19 < 0.0f ? 0.0f : (f19 = f19 > 1.0f ? 1.0f : f19);
        f20 = f20 < 0.0f ? 0.0f : (f20 > 1.0f ? 1.0f : f20);
        return new Color(f17, f18, f19, f20);
    }

    @Override
    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        Point2D point2D = affineTransform.transform(this.CENTER, null);
        return new ConicalGradientPaintContext(point2D);
    }

    @Override
    public int getTransparency() {
        return 3;
    }

    private final class ConicalGradientPaintContext
    implements PaintContext {
        private final Point2D CENTER;

        public ConicalGradientPaintContext(Point2D point2D) {
            this.CENTER = new Point2D.Double(point2D.getX(), point2D.getY());
        }

        @Override
        public void dispose() {
        }

        @Override
        public ColorModel getColorModel() {
            return ColorModel.getRGBdefault();
        }

        @Override
        public Raster getRaster(int n, int n2, int n3, int n4) {
            double d = (double)(-n) + this.CENTER.getX();
            double d2 = (double)(-n2) + this.CENTER.getY();
            int n5 = ConicalGradientPaint.this.FRACTION_ANGLES.length - 1;
            WritableRaster writableRaster = this.getColorModel().createCompatibleWritableRaster(n3, n4);
            int[] nArray = new int[n3 * n4 * 4];
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    int n6;
                    double d7 = (double)j - d;
                    double d8 = (double)i - d2;
                    double d9 = Math.sqrt(d7 * d7 + d8 * d8);
                    if (d9 == 0.0) {
                        d9 = 1.0;
                    }
                    double d10 = Math.abs(Math.toDegrees(Math.acos(d7 / d9)));
                    if (d7 >= 0.0 && d8 <= 0.0) {
                        d10 = 90.0 - d10;
                    } else if (d7 >= 0.0 && d8 >= 0.0) {
                        d10 += 90.0;
                    } else if (d7 <= 0.0 && d8 >= 0.0) {
                        d10 += 90.0;
                    } else if (d7 <= 0.0 && d8 <= 0.0) {
                        d10 = 450.0 - d10;
                    }
                    for (n6 = 0; n6 < n5; ++n6) {
                        if (!(d10 >= (double)ConicalGradientPaint.this.FRACTION_ANGLES[n6])) continue;
                        d3 = (double)((float)ConicalGradientPaint.this.COLORS[n6].getRed() * 0.003921569f) + (d10 - (double)ConicalGradientPaint.this.FRACTION_ANGLES[n6]) * (double)ConicalGradientPaint.this.RED_STEP_LOOKUP[n6];
                        d4 = (double)((float)ConicalGradientPaint.this.COLORS[n6].getGreen() * 0.003921569f) + (d10 - (double)ConicalGradientPaint.this.FRACTION_ANGLES[n6]) * (double)ConicalGradientPaint.this.GREEN_STEP_LOOKUP[n6];
                        d5 = (double)((float)ConicalGradientPaint.this.COLORS[n6].getBlue() * 0.003921569f) + (d10 - (double)ConicalGradientPaint.this.FRACTION_ANGLES[n6]) * (double)ConicalGradientPaint.this.BLUE_STEP_LOOKUP[n6];
                        d6 = (double)((float)ConicalGradientPaint.this.COLORS[n6].getAlpha() * 0.003921569f) + (d10 - (double)ConicalGradientPaint.this.FRACTION_ANGLES[n6]) * (double)ConicalGradientPaint.this.ALPHA_STEP_LOOKUP[n6];
                    }
                    n6 = (i * n3 + j) * 4;
                    nArray[n6 + 0] = (int)(d3 * 255.0);
                    nArray[n6 + 1] = (int)(d4 * 255.0);
                    nArray[n6 + 2] = (int)(d5 * 255.0);
                    nArray[n6 + 3] = (int)(d6 * 255.0);
                }
            }
            writableRaster.setPixels(0, 0, n3, n4, nArray);
            return writableRaster;
        }
    }
}

