/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.tools;

import eu.hansolo.steelseries.tools.ConicalGradientPaint;
import eu.hansolo.steelseries.tools.ContourGradientPaint;
import eu.hansolo.steelseries.tools.FrameDesign;
import eu.hansolo.steelseries.tools.FrameEffect;
import eu.hansolo.steelseries.tools.Util;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;

public enum FrameImageFactory {
    INSTANCE;

    private final Util UTIL = Util.INSTANCE;
    private Paint outerFrameColor = new Color(0x848484);
    private Paint innerFrameColor = new Color(0.6f, 0.6f, 0.6f, 0.8f);
    private int radWidth = 0;
    private FrameDesign radFrameDesign = FrameDesign.METAL;
    private BufferedImage radFrameImage = this.UTIL.createImage(1, 1, 3);
    private FrameEffect radFrameEffect = FrameEffect.NONE;
    private Paint radCustomFrame = Color.BLACK;
    private Color radFrameBaseColor = new Color(179, 179, 179, 255);
    private boolean radFrameBaseColorEnabled = false;
    private int linWidth = 0;
    private int linHeight = 0;
    private FrameDesign linFrameDesign = FrameDesign.METAL;
    private BufferedImage linFrameImage = this.UTIL.createImage(1, 1, 3);
    private FrameEffect linFrameEffect = FrameEffect.NONE;
    private Paint linCustomFrame = Color.BLACK;
    private Color linFrameBaseColor = new Color(179, 179, 179, 255);
    private boolean linFrameBaseColorEnabled = false;

    public Paint getOuterFrameColor() {
        return this.outerFrameColor;
    }

    public void setOuterFrameColor(Paint paint) {
        this.outerFrameColor = paint;
    }

    public Paint getInnerFrameColor() {
        return this.innerFrameColor;
    }

    public void setInnerFrameColor(Paint paint) {
        this.innerFrameColor = paint;
    }

    public BufferedImage createRadialFrame(int n, FrameDesign frameDesign, Paint paint, FrameEffect frameEffect) {
        return this.createRadialFrame(n, frameDesign, paint, new Color(179, 179, 179, 255), false, frameEffect, null);
    }

    public BufferedImage createRadialFrame(int n, FrameDesign frameDesign, Paint paint, Color color, boolean bl, FrameEffect frameEffect) {
        return this.createRadialFrame(n, frameDesign, paint, color, bl, frameEffect, null);
    }

    public BufferedImage createRadialFrame(int n, FrameDesign frameDesign, Paint paint, FrameEffect frameEffect, BufferedImage bufferedImage) {
        return this.createRadialFrame(n, frameDesign, paint, new Color(179, 179, 179, 255), false, frameEffect, bufferedImage);
    }

    public BufferedImage createRadialFrame(int n, FrameDesign frameDesign, Paint paint, Color color, boolean bl, FrameEffect frameEffect, BufferedImage bufferedImage) {
        Paint paint2;
        Color[] colorArray;
        Object object;
        Object object2;
        Object object3;
        Object[] objectArray;
        Object object4;
        Color[] colorArray2;
        Object object5;
        if (n <= 0) {
            return this.UTIL.createImage(1, 1, 3);
        }
        if (this.radWidth == n && this.radFrameDesign == frameDesign && this.radFrameEffect == frameEffect && this.radCustomFrame.equals(paint) && this.radFrameBaseColor.equals(color) && this.radFrameBaseColorEnabled == bl) {
            if (bufferedImage != null) {
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.drawImage((Image)this.radFrameImage, 0, 0, null);
                graphics2D.dispose();
            }
            return this.radFrameImage;
        }
        this.radFrameImage.flush();
        this.radFrameImage = this.UTIL.createImage(n, n, 3);
        Graphics2D graphics2D = this.radFrameImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n2 = n;
        int n3 = n;
        Area area = new Area(new Ellipse2D.Double((double)n2 * 0.08411215245723724, (double)n3 * 0.08411215245723724, (double)n2 * 0.8317756652832031, (double)n3 * 0.8317756652832031));
        Area area2 = new Area(new Ellipse2D.Double(0.0, 0.0, n2, n3));
        area2.subtract(area);
        graphics2D.setPaint(this.outerFrameColor);
        graphics2D.fill(area2);
        Area area3 = new Area(new Ellipse2D.Double((double)n2 * 0.004672897048294544, (double)n3 * 0.004672897048294544, (double)n2 * 0.9906542301177979, (double)n3 * 0.9906542301177979));
        area3.subtract(area);
        Point2D.Double double_ = new Point2D.Double(0.0, area3.getBounds2D().getMinY());
        Point2D.Double double_2 = new Point2D.Double(0.0, area3.getBounds2D().getMaxY());
        Point2D.Double double_3 = new Point2D.Double(area3.getBounds2D().getCenterX(), area3.getBounds2D().getCenterY());
        if (paint != null && frameDesign == FrameDesign.CUSTOM) {
            graphics2D.setPaint(paint);
            graphics2D.fill(area3);
        } else {
            switch (frameDesign) {
                case BLACK_METAL: {
                    object5 = new float[]{0.0f, 45.0f, 125.0f, 180.0f, 245.0f, 315.0f, 360.0f};
                    colorArray2 = new Color[]{new Color(254, 254, 254, 255), new Color(0, 0, 0, 255), new Color(153, 153, 153, 255), new Color(0, 0, 0, 255), new Color(153, 153, 153, 255), new Color(0, 0, 0, 255), new Color(254, 254, 254, 255)};
                    object4 = new ConicalGradientPaint(true, double_3, 0.0f, (float[])object5, colorArray2);
                    graphics2D.setPaint((Paint)object4);
                    graphics2D.fill(area3);
                    break;
                }
                case METAL: {
                    objectArray = new float[]{0.0f, 0.07f, 0.12f, 1.0f};
                    object3 = new Color[]{new Color(254, 254, 254, 255), new Color(210, 210, 210, 255), new Color(179, 179, 179, 255), new Color(213, 213, 213, 255)};
                    object2 = new LinearGradientPaint(double_, double_2, (float[])objectArray, (Color[])object3);
                    graphics2D.setPaint((Paint)object2);
                    graphics2D.fill(area3);
                    break;
                }
                case SHINY_METAL: {
                    object = new float[]{0.0f, 45.0f, 90.0f, 125.0f, 180.0f, 235.0f, 270.0f, 315.0f, 360.0f};
                    colorArray = bl ? new Color[]{new Color(254, 254, 254, 255), new Color(color.getRed(), color.getGreen(), color.getBlue(), 255), new Color(color.getRed(), color.getGreen(), color.getBlue(), 255), new Color(color.brighter().brighter().getRed(), color.brighter().brighter().getGreen(), color.brighter().brighter().getBlue(), 255), new Color(color.getRed(), color.getGreen(), color.getBlue(), 255), new Color(color.brighter().brighter().getRed(), color.brighter().brighter().getGreen(), color.brighter().brighter().getBlue(), 255), new Color(color.getRed(), color.getGreen(), color.getBlue(), 255), new Color(color.getRed(), color.getGreen(), color.getBlue(), 255), new Color(254, 254, 254, 255)} : new Color[]{new Color(254, 254, 254, 255), new Color(210, 210, 210, 255), new Color(179, 179, 179, 255), new Color(238, 238, 238, 255), new Color(160, 160, 160, 255), new Color(238, 238, 238, 255), new Color(179, 179, 179, 255), new Color(210, 210, 210, 255), new Color(254, 254, 254, 255)};
                    paint2 = new ConicalGradientPaint(true, double_3, 0.0f, (float[])object, colorArray);
                    graphics2D.setPaint(paint2);
                    graphics2D.fill(area3);
                    break;
                }
                case GLOSSY_METAL: {
                    graphics2D.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)n2, 0.5 * (double)n3), (float)n2 * 0.5f, new float[]{0.0f, 0.96f, 1.0f}, new Color[]{new Color(0.8117647f, 0.8117647f, 0.8117647f, 1.0f), new Color(0.8039216f, 0.8f, 0.8039216f, 1.0f), new Color(0.95686275f, 0.95686275f, 0.95686275f, 1.0f)}));
                    graphics2D.fill(area3);
                    Area area4 = new Area(new Ellipse2D.Double(0.0140186916 * (double)n2, 0.0140186916 * (double)n3, 0.9719626168 * (double)n2, 0.9719626168 * (double)n3));
                    area4.subtract(area);
                    graphics2D.setPaint(new LinearGradientPaint(new Point2D.Double(0.0, area4.getBounds2D().getMinY()), new Point2D.Double(0.0, area4.getBounds2D().getMaxY()), new float[]{0.0f, 0.23f, 0.36f, 0.59f, 0.76f, 1.0f}, new Color[]{new Color(0.9764706f, 0.9764706f, 0.9764706f, 1.0f), new Color(0.78431374f, 0.7647059f, 0.7490196f, 1.0f), Color.WHITE, new Color(0.11372549f, 0.11372549f, 0.11372549f, 1.0f), new Color(0.78431374f, 0.7607843f, 0.7529412f, 1.0f), new Color(0.81960785f, 0.81960785f, 0.81960785f, 1.0f)}));
                    graphics2D.fill(area4);
                    Area area5 = new Area(new Ellipse2D.Double(0.06542056074766354 * (double)n2, 0.06542056074766354 * (double)n3, 0.8691588785046729 * (double)n2, 0.8691588785046729 * (double)n3));
                    area5.subtract(area);
                    graphics2D.setColor(new Color(0xF6F6F6));
                    graphics2D.fill(area5);
                    Area area6 = new Area(new Ellipse2D.Double(area5.getBounds2D().getMinX() + 2.0, area5.getBounds2D().getMinY() + 2.0, area5.getBounds2D().getWidth() - 4.0, area5.getBounds2D().getHeight() - 4.0));
                    area6.subtract(area);
                    graphics2D.setColor(new Color(0x333333));
                    graphics2D.fill(area6);
                    break;
                }
                case BRASS: {
                    float[] fArray = new float[]{0.0f, 0.05f, 0.1f, 0.5f, 0.9f, 0.95f, 1.0f};
                    Color[] colorArray3 = new Color[]{new Color(249, 243, 155, 255), new Color(246, 226, 101, 255), new Color(240, 225, 132, 255), new Color(90, 57, 22, 255), new Color(249, 237, 139, 255), new Color(243, 226, 108, 255), new Color(202, 182, 113, 255)};
                    LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray3);
                    graphics2D.setPaint(linearGradientPaint);
                    graphics2D.fill(area3);
                    break;
                }
                case STEEL: {
                    float[] fArray = new float[]{0.0f, 0.05f, 0.1f, 0.5f, 0.9f, 0.95f, 1.0f};
                    Color[] colorArray4 = new Color[]{new Color(231, 237, 237, 255), new Color(189, 199, 198, 255), new Color(192, 201, 200, 255), new Color(23, 31, 33, 255), new Color(196, 205, 204, 255), new Color(194, 204, 203, 255), new Color(189, 201, 199, 255)};
                    LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray4);
                    graphics2D.setPaint(linearGradientPaint);
                    graphics2D.fill(area3);
                    break;
                }
                case CHROME: {
                    float[] fArray = new float[]{0.0f, 0.09f, 0.12f, 0.16f, 0.25f, 0.29f, 0.33f, 0.38f, 0.48f, 0.52f, 0.63f, 0.68f, 0.8f, 0.83f, 0.87f, 0.97f, 1.0f};
                    Color[] colorArray5 = new Color[]{new Color(255, 255, 255, 255), new Color(255, 255, 255, 255), new Color(136, 136, 138, 255), new Color(164, 185, 190, 255), new Color(158, 179, 182, 255), new Color(112, 112, 112, 255), new Color(221, 227, 227, 255), new Color(155, 176, 179, 255), new Color(156, 176, 177, 255), new Color(254, 255, 255, 255), new Color(255, 255, 255, 255), new Color(156, 180, 180, 255), new Color(198, 209, 211, 255), new Color(246, 248, 247, 255), new Color(204, 216, 216, 255), new Color(164, 188, 190, 255), new Color(255, 255, 255, 255)};
                    ConicalGradientPaint conicalGradientPaint = new ConicalGradientPaint(false, double_3, 0.0f, fArray, colorArray5);
                    graphics2D.setPaint(conicalGradientPaint);
                    graphics2D.fill(area3);
                    break;
                }
                case GOLD: {
                    float[] fArray = new float[]{0.0f, 0.15f, 0.22f, 0.3f, 0.38f, 0.44f, 0.51f, 0.6f, 0.68f, 0.75f, 1.0f};
                    Color[] colorArray6 = new Color[]{new Color(255, 255, 207, 255), new Color(255, 237, 96, 255), new Color(254, 199, 57, 255), new Color(255, 249, 203, 255), new Color(255, 199, 64, 255), new Color(252, 194, 60, 255), new Color(255, 204, 59, 255), new Color(213, 134, 29, 255), new Color(255, 201, 56, 255), new Color(212, 135, 29, 255), new Color(247, 238, 101, 255)};
                    LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray6);
                    graphics2D.setPaint(linearGradientPaint);
                    graphics2D.fill(area3);
                    break;
                }
                case ANTHRACITE: {
                    float[] fArray = new float[]{0.0f, 0.06f, 0.12f, 1.0f};
                    Color[] colorArray7 = new Color[]{new Color(118, 117, 135, 255), new Color(74, 74, 82, 255), new Color(50, 50, 54, 255), new Color(97, 97, 108, 255)};
                    LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray7);
                    graphics2D.setPaint(linearGradientPaint);
                    graphics2D.fill(area3);
                    break;
                }
                case TILTED_GRAY: {
                    ((Point2D)double_).setLocation(0.2336448598130841 * (double)n2, 0.08411214953271028 * (double)n3);
                    ((Point2D)double_2).setLocation(0.8125818236066633 * (double)n2, 0.9109198204038422 * (double)n3);
                    float[] fArray = new float[]{0.0f, 0.07f, 0.16f, 0.33f, 0.55f, 0.79f, 1.0f};
                    Color[] colorArray8 = new Color[]{new Color(255, 255, 255, 255), new Color(210, 210, 210, 255), new Color(179, 179, 179, 255), new Color(255, 255, 255, 255), new Color(197, 197, 197, 255), new Color(255, 255, 255, 255), new Color(102, 102, 102, 255)};
                    LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray8);
                    graphics2D.setPaint(linearGradientPaint);
                    graphics2D.fill(area3);
                    break;
                }
                case TILTED_BLACK: {
                    ((Point2D)double_).setLocation(0.22897196261682243 * (double)n2, 0.0794392523364486 * (double)n3);
                    ((Point2D)double_2).setLocation(0.8025483989678684 * (double)n2, 0.8985912966254403 * (double)n3);
                    float[] fArray = new float[]{0.0f, 0.21f, 0.47f, 0.99f, 1.0f};
                    Color[] colorArray9 = new Color[]{new Color(102, 102, 102, 255), new Color(0, 0, 0, 255), new Color(102, 102, 102, 255), new Color(0, 0, 0, 255), new Color(0, 0, 0, 255)};
                    LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray9);
                    graphics2D.setPaint(linearGradientPaint);
                    graphics2D.fill(area3);
                    break;
                }
                default: {
                    float[] fArray = new float[]{0.0f, 0.07f, 0.12f, 1.0f};
                    Color[] colorArray10 = new Color[]{new Color(254, 254, 254, 255), new Color(210, 210, 210, 255), new Color(179, 179, 179, 255), new Color(213, 213, 213, 255)};
                    LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray10);
                    graphics2D.setPaint(linearGradientPaint);
                    graphics2D.fill(area3);
                }
            }
        }
        object5 = new Area(new Ellipse2D.Double((double)n2 * 0.07943925261497498, (double)n3 * 0.07943925261497498, (double)n2 * 0.8411215543746948, (double)n3 * 0.8411215543746948));
        ((Area)object5).subtract(area);
        graphics2D.setPaint(this.innerFrameColor);
        graphics2D.fill((Shape)object5);
        colorArray2 = new Point2D.Double(0.5 * (double)n2, 0.5 * (double)n3);
        switch (frameEffect) {
            default: {
                break;
            }
            case EFFECT_BULGE: {
                object4 = new float[]{0.0f, 0.82f, 0.83f, 0.86f, 0.87f, 1.0f};
                objectArray = new Color[]{new Color(0, 0, 0, 0), new Color(0, 0, 0, 76), new Color(0, 0, 0, 95), new Color(219, 219, 219, 153), new Color(255, 255, 255, 151), new Color(0, 0, 0, 102)};
                object3 = new RadialGradientPaint((Point2D)colorArray2, 0.5f * (float)n2, (float[])object4, (Color[])objectArray);
                graphics2D.setPaint((Paint)object3);
                graphics2D.fill(area2);
                break;
            }
            case EFFECT_CONE: {
                object4 = new float[]{0.0f, 0.82f, 0.8201f, 0.96f, 0.9601f, 1.0f};
                objectArray = new Color[]{new Color(0, 0, 0, 0), new Color(0, 0, 0, 50), new Color(9, 9, 9, 51), new Color(255, 255, 255, 124), new Color(223, 223, 223, 127), new Color(0, 0, 0, 76)};
                object3 = new RadialGradientPaint((Point2D)colorArray2, (float)(0.5 * (double)n2), (float[])object4, (Color[])objectArray);
                graphics2D.setPaint((Paint)object3);
                graphics2D.fill(area2);
                break;
            }
            case EFFECT_TORUS: {
                object4 = new float[]{0.0f, 0.82f, 0.8201f, 0.92f, 1.0f};
                objectArray = new Color[]{new Color(0, 0, 0, 0), new Color(0, 0, 0, 50), new Color(13, 13, 13, 51), new Color(255, 255, 255, 64), new Color(0, 0, 0, 76)};
                object3 = new RadialGradientPaint((Point2D)colorArray2, (float)(0.5 * (double)n2), (float[])object4, (Color[])objectArray);
                graphics2D.setPaint((Paint)object3);
                graphics2D.fill(area2);
                break;
            }
            case EFFECT_INNER_FRAME: {
                object2 = new Ellipse2D.Double((double)n2 * 0.0607476644217968, (double)n3 * 0.0607476644217968, (double)n2 * 0.8785046339035034, (double)n3 * 0.8785046339035034);
                object = new Point2D.Double(0.0, object2.getBounds2D().getMinY());
                colorArray = new Point2D.Double(0.0, object2.getBounds2D().getMaxY());
                object4 = new float[]{0.0f, 0.3f, 0.5f, 0.71f, 1.0f};
                objectArray = new Color[]{new Color(0, 0, 0, 183), new Color(148, 148, 148, 25), new Color(0, 0, 0, 159), new Color(0, 0, 0, 81), new Color(255, 255, 255, 158)};
                paint2 = new LinearGradientPaint((Point2D)object, (Point2D)colorArray, (float[])object4, (Color[])objectArray);
                graphics2D.setPaint(paint2);
                graphics2D.fill((Shape)object2);
            }
        }
        graphics2D.dispose();
        if (bufferedImage != null) {
            object2 = bufferedImage.createGraphics();
            ((Graphics)object2).drawImage(this.radFrameImage, 0, 0, null);
            ((Graphics)object2).dispose();
        }
        this.radWidth = n;
        this.radFrameDesign = frameDesign;
        this.radFrameEffect = frameEffect;
        this.radCustomFrame = paint;
        this.radFrameBaseColor = color;
        this.radFrameBaseColorEnabled = bl;
        return this.radFrameImage;
    }

    public BufferedImage createLinearFrame(int n, FrameDesign frameDesign, Paint paint, FrameEffect frameEffect) {
        return this.createLinearFrame(n, n, frameDesign, paint, frameEffect);
    }

    public BufferedImage createLinearFrame(int n, FrameDesign frameDesign, Paint paint, Color color, boolean bl, FrameEffect frameEffect) {
        return this.createLinearFrame(n, n, frameDesign, paint, color, bl, frameEffect, null);
    }

    public BufferedImage createLinearFrame(int n, int n2, FrameDesign frameDesign, Paint paint, FrameEffect frameEffect) {
        return this.createLinearFrame(n, n2, frameDesign, paint, frameEffect, null);
    }

    public BufferedImage createLinearFrame(int n, int n2, FrameDesign frameDesign, Paint paint, FrameEffect frameEffect, BufferedImage bufferedImage) {
        return this.createLinearFrame(n, n2, frameDesign, paint, new Color(179, 179, 179, 255), false, frameEffect, bufferedImage);
    }

    public BufferedImage createLinearFrame(int n, int n2, FrameDesign frameDesign, Paint paint, Color color, boolean bl, FrameEffect frameEffect, BufferedImage bufferedImage) {
        Object object;
        Object[] objectArray;
        Object object2;
        Object object3;
        Color[] colorArray;
        Paint paint2;
        Color[] colorArray2;
        float[] fArray;
        if (n <= 2 || n2 <= 2) {
            return this.UTIL.createImage(1, 1, 3);
        }
        if (this.linWidth == n && this.linHeight == n2 && this.linFrameDesign == frameDesign && this.linFrameEffect == frameEffect && this.linCustomFrame.equals(paint) && this.linFrameBaseColor.equals(color) && this.linFrameBaseColorEnabled == bl) {
            if (bufferedImage != null) {
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.drawImage((Image)this.linFrameImage, 0, 0, null);
                graphics2D.dispose();
            }
            return this.linFrameImage;
        }
        this.linFrameImage.flush();
        this.linFrameImage = this.UTIL.createImage(n, n2, 3);
        Graphics2D graphics2D = this.linFrameImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int n3 = n;
        int n4 = n2;
        double d = n3 >= n4 ? (double)n4 * 0.05 : (double)n3 * 0.05;
        Area area = new Area(new RoundRectangle2D.Double(0.0, 0.0, n3, n4, d, d));
        graphics2D.setPaint(this.outerFrameColor);
        double d2 = n3 >= n4 ? d - (area.getBounds2D().getHeight() - (double)n4 - 2.0) / 2.0 : d - (area.getBounds2D().getWidth() - (double)n3 - 2.0) / 2.0;
        Area area2 = new Area(new RoundRectangle2D.Double(1.0, 1.0, n3 - 2, n4 - 2, d2, d2));
        Point2D.Double double_ = new Point2D.Double(0.0, area2.getBounds2D().getMinY());
        Point2D.Double double_2 = new Point2D.Double(0.0, area2.getBounds2D().getMaxY());
        Point2D.Double double_3 = new Point2D.Double(area2.getBounds2D().getCenterX(), area2.getBounds2D().getCenterY());
        double d3 = n3 >= n4 ? (double)n4 * 0.02857143 : (double)n3 * 0.02857143;
        Area area3 = new Area(new RoundRectangle2D.Double(area2.getBounds2D().getX() + 16.0, area2.getBounds2D().getY() + 16.0, area2.getBounds2D().getWidth() - 32.0, area2.getBounds2D().getHeight() - 32.0, d3, d3));
        area.subtract(area3);
        graphics2D.fill(area);
        float f = (float)Math.toDegrees(Math.atan((float)n4 / 8.0f / ((float)n3 / 2.0f)));
        if (paint != null && frameDesign == FrameDesign.CUSTOM) {
            graphics2D.setPaint(paint);
            area2.subtract(area3);
            graphics2D.fill(area2);
        } else {
            switch (frameDesign) {
                case BLACK_METAL: {
                    fArray = new float[]{0.0f, 90.0f - 2.0f * f, 90.0f, 90.0f + 3.0f * f, 180.0f, 270.0f - 3.0f * f, 270.0f, 270.0f + 2.0f * f, 1.0f};
                    colorArray2 = new Color[]{new Color(254, 254, 254, 255), new Color(0, 0, 0, 255), new Color(153, 153, 153, 255), new Color(0, 0, 0, 255), new Color(0, 0, 0, 255), new Color(0, 0, 0, 255), new Color(153, 153, 153, 255), new Color(0, 0, 0, 255), new Color(254, 254, 254, 255)};
                    paint2 = new ConicalGradientPaint(true, double_3, 0.0f, fArray, colorArray2);
                    graphics2D.setPaint(paint2);
                    area2.subtract(area3);
                    graphics2D.fill(area2);
                    break;
                }
                case METAL: {
                    float[] fArray2 = new float[]{0.0f, 0.07f, 0.12f, 1.0f};
                    colorArray = new Color[]{new Color(254, 254, 254, 255), new Color(210, 210, 210, 255), new Color(179, 179, 179, 255), new Color(213, 213, 213, 255)};
                    object3 = new LinearGradientPaint(double_, double_2, fArray2, colorArray);
                    graphics2D.setPaint((Paint)object3);
                    area2.subtract(area3);
                    graphics2D.fill(area2);
                    break;
                }
                case SHINY_METAL: {
                    object2 = new float[]{0.0f, 90.0f - 2.0f * f, 90.0f, 90.0f + 3.0f * f, 180.0f, 270.0f - 3.0f * f, 270.0f, 270.0f + 2.0f * f, 1.0f};
                    objectArray = bl ? (Object[])new Color[]{new Color(254, 254, 254, 255), new Color(color.getRed(), color.getGreen(), color.getBlue(), 255), new Color(color.brighter().brighter().getRed(), color.brighter().brighter().getGreen(), color.brighter().brighter().getBlue(), 255), new Color(color.getRed(), color.getGreen(), color.getBlue(), 255), new Color(color.getRed(), color.getGreen(), color.getBlue(), 255), new Color(color.getRed(), color.getGreen(), color.getBlue(), 255), new Color(color.brighter().brighter().getRed(), color.brighter().brighter().getGreen(), color.brighter().brighter().getBlue(), 255), new Color(color.getRed(), color.getGreen(), color.getBlue(), 255), new Color(254, 254, 254, 255)} : (Object[])new Color[]{new Color(254, 254, 254, 255), new Color(179, 179, 179, 255), new Color(238, 238, 238, 255), new Color(179, 179, 179, 255), new Color(179, 179, 179, 255), new Color(179, 179, 179, 255), new Color(238, 238, 238, 255), new Color(179, 179, 179, 255), new Color(254, 254, 254, 255)};
                    object = new ConicalGradientPaint(true, double_3, 0.0f, (float[])object2, (Color[])objectArray);
                    graphics2D.setPaint((Paint)object);
                    area2.subtract(area3);
                    graphics2D.fill(area2);
                    break;
                }
                case GLOSSY_METAL: {
                    float f2 = n >= n2 ? 32.0f / (float)n2 : 32.0f / (float)n;
                    float[] fArray3 = new float[]{0.0f, f2 * 0.04f, 1.0f};
                    Color[] colorArray3 = new Color[]{new Color(0.95686275f, 0.95686275f, 0.95686275f, 1.0f), new Color(0.8117647f, 0.8117647f, 0.8117647f, 1.0f), new Color(0.8117647f, 0.8117647f, 0.8117647f, 1.0f)};
                    ContourGradientPaint contourGradientPaint = new ContourGradientPaint(area.getBounds2D(), fArray3, colorArray3);
                    graphics2D.setPaint(contourGradientPaint);
                    graphics2D.fill(area2);
                    Area area4 = new Area(new RoundRectangle2D.Double(2.0, 2.0, n3 - 4, n4 - 4, d2, d2));
                    area4.subtract(area3);
                    graphics2D.setPaint(new LinearGradientPaint(new Point2D.Double(0.0, area4.getBounds2D().getMinY()), new Point2D.Double(0.0, area4.getBounds2D().getMaxY()), new float[]{0.0f, 0.1f, 0.26f, 0.73f, 1.0f}, new Color[]{new Color(0.9764706f, 0.9764706f, 0.9764706f, 1.0f), new Color(0.78431374f, 0.7647059f, 0.7490196f, 1.0f), new Color(1.0f, 1.0f, 1.0f, 1.0f), new Color(0.11372549f, 0.11372549f, 0.11372549f, 1.0f), new Color(0.81960785f, 0.81960785f, 0.81960785f, 1.0f)}));
                    graphics2D.fill(area4);
                    Area area5 = new Area(new RoundRectangle2D.Double(15.0, 15.0, n3 - 30, n4 - 30, d3, d3));
                    area5.subtract(area3);
                    graphics2D.setPaint(new Color(0xF6F6F6));
                    graphics2D.fill(area5);
                    Area area6 = new Area(new RoundRectangle2D.Double(16.0, 16.0, n3 - 32, n4 - 32, d3, d3));
                    area6.subtract(area3);
                    graphics2D.setPaint(new Color(0x333333));
                    graphics2D.fill(area6);
                    break;
                }
                case BRASS: {
                    float[] fArray4 = new float[]{0.0f, 0.05f, 0.1f, 0.5f, 0.9f, 0.95f, 1.0f};
                    Color[] colorArray4 = new Color[]{new Color(249, 243, 155, 255), new Color(246, 226, 101, 255), new Color(240, 225, 132, 255), new Color(90, 57, 22, 255), new Color(249, 237, 139, 255), new Color(243, 226, 108, 255), new Color(202, 182, 113, 255)};
                    LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray4, colorArray4);
                    graphics2D.setPaint(linearGradientPaint);
                    area2.subtract(area3);
                    graphics2D.fill(area2);
                    break;
                }
                case STEEL: {
                    float[] fArray5 = new float[]{0.0f, 0.05f, 0.1f, 0.5f, 0.9f, 0.95f, 1.0f};
                    Color[] colorArray5 = new Color[]{new Color(231, 237, 237, 255), new Color(189, 199, 198, 255), new Color(192, 201, 200, 255), new Color(23, 31, 33, 255), new Color(196, 205, 204, 255), new Color(194, 204, 203, 255), new Color(189, 201, 199, 255)};
                    LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray5, colorArray5);
                    graphics2D.setPaint(linearGradientPaint);
                    area2.subtract(area3);
                    graphics2D.fill(area2);
                    break;
                }
                case CHROME: {
                    float[] fArray6 = new float[]{0.0f, 0.09f, 0.12f, 0.16f, 0.25f, 0.29f, 0.33f, 0.38f, 0.48f, 0.52f, 0.63f, 0.68f, 0.8f, 0.83f, 0.87f, 0.97f, 1.0f};
                    Color[] colorArray6 = new Color[]{new Color(255, 255, 255, 255), new Color(255, 255, 255, 255), new Color(136, 136, 138, 255), new Color(164, 185, 190, 255), new Color(158, 179, 182, 255), new Color(112, 112, 112, 255), new Color(221, 227, 227, 255), new Color(155, 176, 179, 255), new Color(156, 176, 177, 255), new Color(254, 255, 255, 255), new Color(255, 255, 255, 255), new Color(156, 180, 180, 255), new Color(198, 209, 211, 255), new Color(246, 248, 247, 255), new Color(204, 216, 216, 255), new Color(164, 188, 190, 255), new Color(255, 255, 255, 255)};
                    ConicalGradientPaint conicalGradientPaint = new ConicalGradientPaint(false, double_3, 0.0f, fArray6, colorArray6);
                    graphics2D.setPaint(conicalGradientPaint);
                    area2.subtract(area3);
                    graphics2D.fill(area2);
                    break;
                }
                case GOLD: {
                    float[] fArray7 = new float[]{0.0f, 0.15f, 0.22f, 0.3f, 0.38f, 0.44f, 0.51f, 0.6f, 0.68f, 0.75f, 1.0f};
                    Color[] colorArray7 = new Color[]{new Color(255, 255, 207, 255), new Color(255, 237, 96, 255), new Color(254, 199, 57, 255), new Color(255, 249, 203, 255), new Color(255, 199, 64, 255), new Color(252, 194, 60, 255), new Color(255, 204, 59, 255), new Color(213, 134, 29, 255), new Color(255, 201, 56, 255), new Color(212, 135, 29, 255), new Color(247, 238, 101, 255)};
                    LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray7, colorArray7);
                    graphics2D.setPaint(linearGradientPaint);
                    area2.subtract(area3);
                    graphics2D.fill(area2);
                    break;
                }
                case ANTHRACITE: {
                    float[] fArray8 = new float[]{0.0f, 0.06f, 0.12f, 1.0f};
                    Color[] colorArray8 = new Color[]{new Color(118, 117, 135, 255), new Color(74, 74, 82, 255), new Color(50, 50, 54, 255), new Color(97, 97, 108, 255)};
                    LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray8, colorArray8);
                    graphics2D.setPaint(linearGradientPaint);
                    area2.subtract(area3);
                    graphics2D.fill(area2);
                    break;
                }
                case TILTED_GRAY: {
                    ((Point2D)double_).setLocation(0.08571428571428572 * (double)n3, 0.0 * (double)n4);
                    ((Point2D)double_2).setLocation(0.8293857071807453 * (double)n3, 0.9868853088441548 * (double)n4);
                    float[] fArray9 = new float[]{0.0f, 0.07f, 0.16f, 0.33f, 0.55f, 0.79f, 1.0f};
                    Color[] colorArray9 = new Color[]{new Color(255, 255, 255, 255), new Color(210, 210, 210, 255), new Color(179, 179, 179, 255), new Color(255, 255, 255, 255), new Color(197, 197, 197, 255), new Color(255, 255, 255, 255), new Color(102, 102, 102, 255)};
                    LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray9, colorArray9);
                    graphics2D.setPaint(linearGradientPaint);
                    area2.subtract(area3);
                    graphics2D.fill(area2);
                    break;
                }
                case TILTED_BLACK: {
                    ((Point2D)double_).setLocation(0.08571428571428572 * (double)n3, 0.014285714285714285 * (double)n4);
                    ((Point2D)double_2).setLocation(0.7353908489107824 * (double)n3, 1.01469989176347 * (double)n4);
                    float[] fArray10 = new float[]{0.0f, 0.21f, 0.47f, 1.0f};
                    Color[] colorArray10 = new Color[]{new Color(102, 102, 102, 255), new Color(0, 0, 0, 255), new Color(102, 102, 102, 255), new Color(0, 0, 0, 255)};
                    LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray10, colorArray10);
                    graphics2D.setPaint(linearGradientPaint);
                    area2.subtract(area3);
                    graphics2D.fill(area2);
                    break;
                }
                default: {
                    float[] fArray11 = new float[]{0.0f, 0.07f, 0.12f, 1.0f};
                    Color[] colorArray11 = new Color[]{new Color(254, 254, 254, 255), new Color(210, 210, 210, 255), new Color(179, 179, 179, 255), new Color(213, 213, 213, 255)};
                    LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray11, colorArray11);
                    graphics2D.setPaint(linearGradientPaint);
                    area2.subtract(area3);
                    graphics2D.fill(area2);
                }
            }
        }
        switch (frameEffect) {
            default: {
                break;
            }
            case EFFECT_BULGE: {
                float f3 = n >= n2 ? 32.0f / (float)n2 : 32.0f / (float)n;
                fArray = new float[]{0.0f, f3 * 0.87f, f3 * 0.86f, f3 * 0.83f, f3, f3 * 1.01f, 1.0f};
                colorArray2 = new Color[]{new Color(0, 0, 0, 102), new Color(255, 255, 255, 151), new Color(219, 219, 219, 153), new Color(219, 219, 219, 153), new Color(36, 36, 36, 76), new Color(0, 0, 0, 95), new Color(0, 0, 0, 0)};
                paint2 = new ContourGradientPaint(area.getBounds2D(), fArray, colorArray2);
                graphics2D.setPaint(paint2);
                graphics2D.fill(area);
                break;
            }
            case EFFECT_CONE: {
                float f4 = n >= n2 ? 32.0f / (float)n2 : 32.0f / (float)n;
                fArray = new float[]{0.0f, f4 * 0.1f, f4 * 0.3f, f4, 1.0f};
                colorArray2 = new Color[]{new Color(0.0f, 0.0f, 0.0f, 0.3f), new Color(0.0f, 0.0f, 0.0f, 0.3f), new Color(1.0f, 1.0f, 1.0f, 0.5f), new Color(0.0f, 0.0f, 0.0f, 0.2f), new Color(0.0f, 0.0f, 0.0f, 0.0f)};
                paint2 = new ContourGradientPaint(area.getBounds2D(), fArray, colorArray2);
                graphics2D.setPaint(paint2);
                graphics2D.fill(area);
                break;
            }
            case EFFECT_TORUS: {
                float f5 = n >= n2 ? 32.0f / (float)n2 : 32.0f / (float)n;
                fArray = new float[]{0.0f, f5 * 0.1f, f5 * 0.5f, f5, 1.0f};
                colorArray2 = new Color[]{new Color(0.0f, 0.0f, 0.0f, 0.3f), new Color(0.0f, 0.0f, 0.0f, 0.3f), new Color(1.0f, 1.0f, 1.0f, 0.5f), new Color(0.0f, 0.0f, 0.0f, 0.2f), new Color(0.0f, 0.0f, 0.0f, 0.0f)};
                paint2 = new ContourGradientPaint(area.getBounds2D(), fArray, colorArray2);
                graphics2D.setPaint(paint2);
                graphics2D.fill(area);
                break;
            }
            case EFFECT_INNER_FRAME: {
                colorArray = new RoundRectangle2D.Double(10.0, 10.0, n3 - 20, n4 - 20, 10.0, 10.0);
                object3 = new Point2D.Double(0.0, colorArray.getBounds2D().getMinY());
                object2 = new Point2D.Double(0.0, colorArray.getBounds2D().getMaxY());
                objectArray = new float[]{0.0f, 0.13f, 0.45f, 0.92f, 1.0f};
                object = new Color[]{new Color(0, 0, 0, 183), new Color(0, 0, 0, 25), new Color(0, 0, 0, 160), new Color(0, 0, 0, 80), new Color(255, 255, 255, 158)};
                LinearGradientPaint linearGradientPaint = new LinearGradientPaint((Point2D)object3, (Point2D)object2, (float[])objectArray, (Color[])object);
                graphics2D.setPaint(linearGradientPaint);
                graphics2D.fill((Shape)colorArray);
            }
        }
        double d4 = n3 >= n4 ? (double)n4 * 0.02857143 : (double)n3 * 0.02857143;
        object3 = new Area(new RoundRectangle2D.Double(area2.getBounds2D().getX() + 16.0, area2.getBounds2D().getY() + 16.0, area2.getBounds2D().getWidth() - 32.0, area2.getBounds2D().getHeight() - 32.0, d4, d4));
        graphics2D.setPaint(this.innerFrameColor);
        ((Area)object3).subtract(area3);
        graphics2D.fill((Shape)object3);
        graphics2D.dispose();
        if (bufferedImage != null) {
            object2 = bufferedImage.createGraphics();
            ((Graphics)object2).drawImage(this.linFrameImage, 0, 0, null);
            ((Graphics)object2).dispose();
        }
        this.linWidth = n;
        this.linHeight = n2;
        this.linFrameDesign = frameDesign;
        this.linFrameEffect = frameEffect;
        this.linCustomFrame = paint;
        this.linFrameBaseColor = color;
        this.linFrameBaseColorEnabled = bl;
        return this.linFrameImage;
    }

    public String toString() {
        return "FrameImageFactory";
    }
}

