/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.tools;

import java.awt.Color;

public class HsbColor {
    private final float mHue;
    private final float mSaturation;
    private final float mBrightness;
    private final Color mColor;

    private HsbColor(Builder builder) {
        this.mHue = builder.getHue();
        this.mSaturation = builder.getSaturation();
        this.mBrightness = builder.getBrightness();
        Color color = new Color(Color.HSBtoRGB(this.mHue, this.mSaturation, this.mBrightness));
        this.mColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), builder.getAlpha());
    }

    public float getHue() {
        return this.mHue;
    }

    public float getSaturation() {
        return this.mSaturation;
    }

    public float getBrightness() {
        return this.mBrightness;
    }

    public Color getColor() {
        return this.mColor;
    }

    public static class Builder {
        private float hue = 0.0f;
        private float saturation = 0.0f;
        private float brightness = 0.0f;
        private int alpha = 255;

        public Builder(Color color) {
            float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
            this.hue = fArray[0];
            this.saturation = fArray[1];
            this.brightness = fArray[2];
            this.alpha = color.getAlpha();
        }

        public Builder hue(float f) {
            this.hue = f < 0.0f ? 0.0f : (f > 1.0f ? 1.0f : f);
            return this;
        }

        public Builder relHue(float f) {
            this.hue = this.hue + f < 0.0f ? 0.0f : (this.hue + f > 360.0f ? 360.0f : this.hue + f);
            return this;
        }

        public float getHue() {
            return this.hue;
        }

        public Builder saturation(float f) {
            this.saturation = f < 0.0f ? 0.0f : (f > 1.0f ? 1.0f : f);
            return this;
        }

        public Builder relSaturation(float f) {
            this.saturation = this.saturation + f < 0.0f ? 0.0f : (this.saturation + f > 1.0f ? 1.0f : this.saturation + f);
            return this;
        }

        public float getSaturation() {
            return this.saturation;
        }

        public Builder brightness(float f) {
            this.brightness = f < 0.0f ? 0.0f : (f > 1.0f ? 1.0f : f);
            return this;
        }

        public Builder relBrightness(float f) {
            this.brightness = this.brightness + f < 0.0f ? 0.0f : (this.brightness + f > 1.0f ? 1.0f : this.brightness + f);
            return this;
        }

        public float getBrightness() {
            return this.brightness;
        }

        public Builder alpha(int n) {
            this.alpha = n < 0 ? 0 : (n > 255 ? 255 : n);
            return this;
        }

        public int getAlpha() {
            return this.alpha;
        }

        public HsbColor build() {
            return new HsbColor(this);
        }
    }
}

