/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.tools;

import eu.hansolo.steelseries.tools.Orientation;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.util.Random;

public class LinenFilter
implements BufferedImageOp {
    private int radius = 65;
    private float amount = 0.6f;
    private float shine = 0.3f;
    private Orientation orientation = Orientation.HORIZONTAL;
    private int color = -9934744;
    private Random randomNumbers;

    @Override
    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        if (bufferedImage2 == null) {
            bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
        }
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        this.randomNumbers = new Random(0L);
        int n3 = this.color & 0xFF000000;
        int n4 = this.color >> 16 & 0xFF;
        int n5 = this.color >> 8 & 0xFF;
        int n6 = this.color & 0xFF;
        switch (this.orientation) {
            case VERTICAL: {
                int[] nArray3 = new int[n2];
                int[] nArray4 = new int[n2];
                this.randomNumbers = new Random(0L);
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        int n7;
                        int n8 = n4;
                        int n9 = n5;
                        int n10 = n6;
                        if (this.shine != 0.0f) {
                            n7 = (int)((double)(255.0f * this.shine) * Math.sin((double)i / (double)n * Math.PI));
                            n8 += n7;
                            n9 += n7;
                            n10 += n7;
                        }
                        n7 = (int)(255.0f * (2.0f * this.randomNumbers.nextFloat() - 1.0f) * this.amount);
                        nArray3[j] = n3 | LinenFilter.clamp(n8 + n7) << 16 | LinenFilter.clamp(n9 + n7) << 8 | LinenFilter.clamp(n10 + n7);
                    }
                    if (this.radius != 0) {
                        this.blurVertical(nArray3, nArray4, n2, this.radius);
                        this.setRGB(bufferedImage2, i, 0, 1, n2, nArray4);
                        continue;
                    }
                    this.setRGB(bufferedImage2, i, 0, 1, n2, nArray3);
                }
                break;
            }
            default: {
                for (int i = 0; i < n2; ++i) {
                    for (int j = 0; j < n; ++j) {
                        int n11;
                        int n12 = n4;
                        int n13 = n5;
                        int n14 = n6;
                        if (this.shine != 0.0f) {
                            n11 = (int)((double)(255.0f * this.shine) * Math.sin((double)j / (double)n * Math.PI));
                            n12 += n11;
                            n13 += n11;
                            n14 += n11;
                        }
                        n11 = (int)(255.0f * (2.0f * this.randomNumbers.nextFloat() - 1.0f) * this.amount);
                        nArray[j] = n3 | LinenFilter.clamp(n12 + n11) << 16 | LinenFilter.clamp(n13 + n11) << 8 | LinenFilter.clamp(n14 + n11);
                    }
                    if (this.radius != 0) {
                        this.blurHorizontal(nArray, nArray2, n, this.radius);
                        this.setRGB(bufferedImage2, 0, i, n, 1, nArray2);
                        continue;
                    }
                    this.setRGB(bufferedImage2, 0, i, n, 1, nArray);
                }
            }
        }
        return bufferedImage2;
    }

    private int random(int n) {
        if ((n += (int)(255.0f * (2.0f * this.randomNumbers.nextFloat() - 1.0f) * this.amount)) < 0) {
            n = 0;
        } else if (n > 255) {
            n = 255;
        }
        return n;
    }

    private static int clamp(int n) {
        int n2 = n < 0 ? 0 : (n > 255 ? 255 : n);
        return n2;
    }

    private static int mod(int n, int n2) {
        int n3;
        if ((n -= (n3 = n / n2) * n2) < 0) {
            return n + n2;
        }
        return n;
    }

    public void blurHorizontal(int[] nArray, int[] nArray2, int n, int n2) {
        int n3;
        int n4;
        int n5 = n - 1;
        int n6 = 2 * n2 + 1;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        for (n4 = -n2; n4 <= n2; ++n4) {
            n3 = nArray[LinenFilter.mod(n4, n)];
            n7 += n3 >> 16 & 0xFF;
            n8 += n3 >> 8 & 0xFF;
            n9 += n3 & 0xFF;
        }
        for (n4 = 0; n4 < n; ++n4) {
            int n10;
            nArray2[n4] = 0xFF000000 | n7 / n6 << 16 | n8 / n6 << 8 | n9 / n6;
            n3 = n4 + n2 + 1;
            if (n3 > n5) {
                n3 = LinenFilter.mod(n3, n);
            }
            if ((n10 = n4 - n2) < 0) {
                n10 = LinenFilter.mod(n10, n);
            }
            int n11 = nArray[n3];
            int n12 = nArray[n10];
            n7 += (n11 & 0xFF0000) - (n12 & 0xFF0000) >> 16;
            n8 += (n11 & 0xFF00) - (n12 & 0xFF00) >> 8;
            n9 += (n11 & 0xFF) - (n12 & 0xFF);
        }
    }

    public void blurVertical(int[] nArray, int[] nArray2, int n, int n2) {
        int n3;
        int n4;
        int n5 = n - 1;
        int n6 = 2 * n2 + 1;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        for (n4 = -n2; n4 <= n2; ++n4) {
            n3 = nArray[LinenFilter.mod(n4, n)];
            n7 += n3 >> 16 & 0xFF;
            n8 += n3 >> 8 & 0xFF;
            n9 += n3 & 0xFF;
        }
        for (n4 = 0; n4 < n; ++n4) {
            int n10;
            nArray2[n4] = 0xFF000000 | n7 / n6 << 16 | n8 / n6 << 8 | n9 / n6;
            n3 = n4 + n2 + 1;
            if (n3 > n5) {
                n3 = LinenFilter.mod(n3, n);
            }
            if ((n10 = n4 - n2) < 0) {
                n10 = LinenFilter.mod(n10, n);
            }
            int n11 = nArray[n3];
            int n12 = nArray[n10];
            n7 += (n11 & 0xFF0000) - (n12 & 0xFF0000) >> 16;
            n8 += (n11 & 0xFF00) - (n12 & 0xFF00) >> 8;
            n9 += (n11 & 0xFF) - (n12 & 0xFF);
        }
    }

    public void setRadius(int n) {
        this.radius = n;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setAmount(float f) {
        this.amount = f;
    }

    public float getAmount() {
        return this.amount;
    }

    public void setColor(int n) {
        this.color = n;
    }

    public int getColor() {
        return this.color;
    }

    public void setShine(float f) {
        this.shine = f;
    }

    public float getShine() {
        return this.shine;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    @Override
    public BufferedImage createCompatibleDestImage(BufferedImage bufferedImage, ColorModel colorModel) {
        if (colorModel == null) {
            colorModel = bufferedImage.getColorModel();
        }
        return new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(bufferedImage.getWidth(), bufferedImage.getHeight()), colorModel.isAlphaPremultiplied(), null);
    }

    @Override
    public Rectangle2D getBounds2D(BufferedImage bufferedImage) {
        return new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
    }

    @Override
    public Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            point2D2 = new Point2D.Double();
        }
        point2D2.setLocation(point2D.getX(), point2D.getY());
        return point2D2;
    }

    @Override
    public RenderingHints getRenderingHints() {
        return null;
    }

    public void setRGB(BufferedImage bufferedImage, int n, int n2, int n3, int n4, int[] nArray) {
        int n5 = bufferedImage.getType();
        if (n5 == 2 || n5 == 1) {
            bufferedImage.getRaster().setDataElements(n, n2, n3, n4, nArray);
        } else {
            bufferedImage.setRGB(n, n2, n3, n4, nArray, 0, n3);
        }
    }

    public String toString() {
        return "Texture/Brushed Metal...";
    }
}

