/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.tools;

import eu.hansolo.steelseries.tools.BackgroundColor;
import eu.hansolo.steelseries.tools.ColorDef;
import eu.hansolo.steelseries.tools.CustomColorDef;
import eu.hansolo.steelseries.tools.CustomLedColor;
import eu.hansolo.steelseries.tools.ForegroundType;
import eu.hansolo.steelseries.tools.FrameDesign;
import eu.hansolo.steelseries.tools.FrameEffect;
import eu.hansolo.steelseries.tools.FrameType;
import eu.hansolo.steelseries.tools.GaugeType;
import eu.hansolo.steelseries.tools.KnobStyle;
import eu.hansolo.steelseries.tools.KnobType;
import eu.hansolo.steelseries.tools.LcdColor;
import eu.hansolo.steelseries.tools.LedColor;
import eu.hansolo.steelseries.tools.NumberFormat;
import eu.hansolo.steelseries.tools.NumberSystem;
import eu.hansolo.steelseries.tools.PointerType;
import eu.hansolo.steelseries.tools.Section;
import eu.hansolo.steelseries.tools.ThresholdType;
import eu.hansolo.steelseries.tools.TicklabelOrientation;
import eu.hansolo.steelseries.tools.TickmarkType;
import eu.hansolo.steelseries.tools.Util;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class Model
implements Cloneable {
    private ChangeEvent changeEvent;
    private final EventListenerList LISTENER_LIST = new EventListenerList();
    private Rectangle bounds;
    private static final int BASE = 10;
    private double minValue;
    private double maxValue;
    private double range;
    private double value;
    private double oldValue;
    private double peakValue;
    private boolean peakValueVisible;
    private double lcdValue;
    private double lcdThreshold;
    private boolean lcdThresholdVisible;
    private boolean lcdThresholdBehaviourInverted;
    private boolean singleLedBargraphEnabled;
    private boolean autoResetToZero;
    private boolean frameVisible;
    private FrameEffect frameEffect;
    private Color frameBaseColor;
    private boolean frameBaseColorEnabled;
    private boolean backgroundVisible;
    private boolean titleVisible;
    private boolean unitVisible;
    private boolean customTitleAndUnitFontEnabled;
    private boolean customLayerVisible;
    private boolean ledVisible;
    private boolean userLedVisible;
    private boolean lcdVisible;
    private boolean lcdUnitStringVisible;
    private boolean lcdScientificFormatEnabled;
    private boolean valueCoupled;
    private boolean digitalFontEnabled;
    private boolean customLcdUnitFontEnabled;
    private NumberSystem numberSystem;
    private boolean foregroundVisible;
    private boolean tickmarksVisible;
    private boolean ticklabelsVisible;
    private boolean minorTickmarksVisible;
    private boolean majorTickmarksVisible;
    private boolean tickmarkColorFromThemeEnabled;
    private boolean labelColorFromThemeEnabled;
    private TicklabelOrientation ticklabelOrientation;
    private double threshold;
    private boolean thresholdVisible;
    private ColorDef thresholdColor;
    private CustomColorDef customThresholdColor;
    private ThresholdType thresholdType;
    private boolean thresholdBehaviourInverted;
    private double minMeasuredValue;
    private boolean minMeasuredValueVisible;
    private double maxMeasuredValue;
    private boolean maxMeasuredValueVisible;
    private boolean rangeOfMeasuredValuesVisible;
    private Shape radialShapeOfMeasuredValues;
    private boolean collectingData;
    private double trackStart;
    private double trackSection;
    private double trackStop;
    private boolean trackVisible;
    private ArrayList<Section> sections;
    private boolean sectionsVisible;
    private boolean highlightSection;
    private ArrayList<Section> areas;
    private boolean areasVisible;
    private boolean highlightArea;
    private ArrayList<Section> tickmarkSections;
    private boolean tickmarkSectionsVisible;
    private GaugeType gaugeType;
    private double angleStep;
    private double logAngleStep;
    private boolean niceScale;
    private boolean logScale;
    private double niceRange;
    private int maxNoOfMajorTicks;
    private int maxNoOfMinorTicks;
    private double majorTickSpacing;
    private double minorTickSpacing;
    private double niceMinValue;
    private double niceMaxValue;
    private BackgroundColor backgroundColor;
    private Paint customBackground;
    private Color textureColor;
    private BufferedImage customLayer;
    private boolean glowVisible;
    private Color glowColor;
    private boolean glowing;
    private FrameType frameType;
    private FrameDesign frameDesign;
    private Paint customFrameDesign;
    private Paint outerFrameColor;
    private Paint innerFrameColor;
    private LedColor ledColor;
    private CustomLedColor customLedColor;
    private LedColor userLedColor;
    private CustomLedColor customUserLedColor;
    private LcdColor lcdColor;
    private Paint customLcdColor;
    private Color customLcdForegroundColor;
    private TickmarkType minorTickmarkType;
    private TickmarkType majorTickmarkType;
    private NumberFormat labelNumberFormat;
    private Color tickmarkColor;
    private Color customTickmarkColor;
    private Color labelColor;
    private Color trackStartColor;
    private Color trackSectionColor;
    private Color trackStopColor;
    private PointerType pointerType;
    private ColorDef pointerColor;
    private boolean pointerShadowVisible;
    private CustomColorDef customPointerColorObject;
    private ColorDef valueColor;
    private CustomColorDef customValueColorObject;
    private KnobType knobType;
    private KnobStyle knobStyle;
    private boolean postsVisible;
    private ForegroundType foregroundType;
    private Font lcdValueFont;
    private Font lcdUnitFont;
    private Font customLcdUnitFont;
    private Font lcdInfoFont;
    private int lcdDecimals;
    private Paint rangeOfMeasuredValuesPaint;
    private final Font STANDARD_BASE_FONT = new Font("Verdana", 0, 24);
    private final Font STANDARD_INFO_FONT = new Font("Verdana", 0, 24);
    private final Font DIGITAL_BASE_FONT = Util.INSTANCE.getDigitalFont().deriveFont(24);

    public Model() {
        this.sections = new ArrayList(10);
        this.areas = new ArrayList(10);
        this.tickmarkSections = new ArrayList(10);
        this.init();
    }

    private void init() {
        this.bounds = new Rectangle();
        this.minValue = 0.0;
        this.maxValue = 100.0;
        this.range = this.maxValue - this.minValue;
        this.value = this.minValue;
        this.oldValue = this.minValue;
        this.peakValue = this.minValue;
        this.peakValueVisible = false;
        this.lcdValue = 0.0;
        this.lcdThreshold = 0.0;
        this.lcdThresholdVisible = false;
        this.lcdThresholdBehaviourInverted = false;
        this.autoResetToZero = false;
        this.frameVisible = true;
        this.frameEffect = FrameEffect.NONE;
        this.frameBaseColor = new Color(179, 179, 179, 255);
        this.frameBaseColorEnabled = false;
        this.backgroundVisible = true;
        this.titleVisible = true;
        this.unitVisible = true;
        this.customTitleAndUnitFontEnabled = false;
        this.customLayerVisible = false;
        this.ledVisible = true;
        this.lcdVisible = true;
        this.lcdUnitStringVisible = false;
        this.lcdScientificFormatEnabled = false;
        this.valueCoupled = true;
        this.digitalFontEnabled = false;
        this.customLcdUnitFontEnabled = false;
        this.numberSystem = NumberSystem.DEC;
        this.foregroundVisible = true;
        this.tickmarksVisible = true;
        this.ticklabelsVisible = true;
        this.minorTickmarksVisible = true;
        this.majorTickmarksVisible = true;
        this.tickmarkColorFromThemeEnabled = true;
        this.labelColorFromThemeEnabled = true;
        this.ticklabelOrientation = TicklabelOrientation.TANGENT;
        this.threshold = this.range / 2.0;
        this.thresholdVisible = false;
        this.thresholdColor = ColorDef.RED;
        this.customThresholdColor = new CustomColorDef(Color.RED);
        this.thresholdType = ThresholdType.TRIANGLE;
        this.thresholdBehaviourInverted = false;
        this.minMeasuredValue = this.maxValue;
        this.minMeasuredValueVisible = false;
        this.maxMeasuredValue = this.minValue;
        this.maxMeasuredValueVisible = false;
        this.rangeOfMeasuredValuesVisible = false;
        this.radialShapeOfMeasuredValues = new Arc2D.Double();
        this.collectingData = false;
        this.trackStart = this.minValue;
        this.trackSection = this.range / 2.0;
        this.trackStop = this.maxValue;
        this.trackVisible = false;
        this.sections.clear();
        this.sectionsVisible = false;
        this.highlightSection = false;
        this.areas.clear();
        this.areasVisible = false;
        this.highlightArea = false;
        this.tickmarkSections.clear();
        this.tickmarkSectionsVisible = false;
        this.gaugeType = GaugeType.TYPE4;
        this.angleStep = this.gaugeType.ANGLE_RANGE / this.range;
        this.logAngleStep = this.gaugeType.ANGLE_RANGE / (Util.INSTANCE.logOfBase(10.0, this.range) - 1.0) * 9.0 + 10.0;
        this.niceScale = true;
        this.logScale = false;
        this.maxNoOfMajorTicks = 10;
        this.maxNoOfMinorTicks = 10;
        this.backgroundColor = BackgroundColor.DARK_GRAY;
        this.customBackground = Color.RED;
        this.textureColor = new Color(0x686868);
        this.customLayer = null;
        this.glowVisible = false;
        this.glowColor = new Color(51, 255, 255);
        this.glowing = false;
        this.frameType = FrameType.ROUND;
        this.frameDesign = FrameDesign.METAL;
        this.outerFrameColor = new Color(0x848484);
        this.innerFrameColor = new Color(0.6f, 0.6f, 0.6f, 0.8f);
        this.customFrameDesign = Color.RED;
        this.ledColor = LedColor.RED_LED;
        this.customLedColor = new CustomLedColor(Color.RED);
        this.userLedColor = LedColor.RED_LED;
        this.customUserLedColor = new CustomLedColor(Color.RED);
        this.lcdColor = LcdColor.WHITE_LCD;
        this.customLcdColor = Color.RED;
        this.customLcdForegroundColor = Color.BLACK;
        this.minorTickmarkType = TickmarkType.LINE;
        this.majorTickmarkType = TickmarkType.LINE;
        this.labelNumberFormat = NumberFormat.AUTO;
        this.tickmarkColor = this.backgroundColor.LABEL_COLOR;
        this.customTickmarkColor = Color.BLACK;
        this.labelColor = this.backgroundColor.LABEL_COLOR;
        this.trackStartColor = new Color(0.0f, 1.0f, 0.0f, 0.35f);
        this.trackSectionColor = new Color(1.0f, 1.0f, 0.0f, 0.35f);
        this.trackStopColor = new Color(1.0f, 0.0f, 0.0f, 0.35f);
        this.pointerType = PointerType.TYPE1;
        this.pointerColor = ColorDef.RED;
        this.pointerShadowVisible = true;
        this.customPointerColorObject = new CustomColorDef(Color.RED);
        this.valueColor = ColorDef.RED;
        this.customValueColorObject = new CustomColorDef(Color.RED);
        this.knobType = KnobType.SMALL_STD_KNOB;
        this.knobStyle = KnobStyle.SILVER;
        this.postsVisible = true;
        this.foregroundType = ForegroundType.FG_TYPE1;
        this.customLcdUnitFont = new Font("Verdana", 1, 24);
        this.lcdInfoFont = new Font("Verdana", 0, 24);
        this.rangeOfMeasuredValuesPaint = new Color(1.0f, 0.0f, 0.0f, 0.1f);
        this.calculate();
    }

    public Rectangle getSize() {
        return this.bounds;
    }

    public void setSize(int n, int n2, int n3, int n4) {
        this.bounds.setBounds(n, n2, n3, n4);
        this.fireStateChanged();
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMinValue(double d) {
        if (Double.compare(d, this.maxValue) == 0) {
            throw new IllegalArgumentException("Min value cannot be equal to max value");
        }
        if (Double.compare(d, this.maxValue) > 0) {
            this.minValue = this.maxValue;
            this.maxValue = d;
        } else {
            this.minValue = d;
        }
        this.calculate();
        this.validate();
        this.calcAngleStep();
        this.fireStateChanged();
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(double d) {
        if (Double.compare(d, this.minValue) == 0) {
            throw new IllegalArgumentException("Max value cannot be equal to min value");
        }
        if (Double.compare(d, this.minValue) < 0) {
            this.maxValue = this.minValue;
            this.minValue = d;
        } else {
            this.maxValue = d;
        }
        this.calculate();
        this.validate();
        this.calcAngleStep();
        this.fireStateChanged();
    }

    public double getRange() {
        return this.maxValue - this.minValue;
    }

    public void setRange(double d, double d2) {
        this.maxValue = d2;
        this.minValue = d;
        this.calculate();
        this.validate();
        this.calcAngleStep();
        this.fireStateChanged();
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double d) {
        this.oldValue = this.value;
        this.value = d < this.niceMinValue ? this.niceMinValue : (d > this.niceMaxValue ? this.niceMaxValue : d);
        this.fireStateChanged();
    }

    public double getOldValue() {
        return this.oldValue;
    }

    public double getPeakValue() {
        return this.peakValue;
    }

    public void setPeakValue(double d) {
        this.peakValue = d;
        this.fireStateChanged();
    }

    public boolean isPeakValueVisible() {
        return this.peakValueVisible;
    }

    public void setPeakValueVisible(boolean bl) {
        this.peakValueVisible = bl;
        this.fireStateChanged();
    }

    public double getLcdValue() {
        return this.lcdValue;
    }

    public void setLcdValue(double d) {
        this.lcdValue = d;
        this.fireStateChanged();
    }

    public double getLcdThreshold() {
        return this.lcdThreshold;
    }

    public void setLcdThreshold(double d) {
        this.lcdThreshold = d;
        this.fireStateChanged();
    }

    public boolean isLcdThresholdVisible() {
        return this.lcdThresholdVisible;
    }

    public void setLcdThresholdVisible(boolean bl) {
        this.lcdThresholdVisible = bl;
        this.fireStateChanged();
    }

    public boolean isLcdThresholdBehaviourInverted() {
        return this.lcdThresholdBehaviourInverted;
    }

    public void setLcdThresholdBehaviourInverted(boolean bl) {
        this.lcdThresholdBehaviourInverted = bl;
        this.fireStateChanged();
    }

    public boolean isSingleLedBargraphEnabled() {
        return this.singleLedBargraphEnabled;
    }

    public void setSingleLedBargraphEnabled(boolean bl) {
        this.singleLedBargraphEnabled = bl;
        this.fireStateChanged();
    }

    public boolean isAutoResetToZero() {
        return this.autoResetToZero;
    }

    public void setAutoResetToZero(boolean bl) {
        this.autoResetToZero = this.niceMinValue > 0.0 || this.niceMaxValue < 0.0 ? false : bl;
        this.fireStateChanged();
    }

    public boolean isFrameVisible() {
        return this.frameVisible;
    }

    public void setFrameVisible(boolean bl) {
        this.frameVisible = bl;
        this.fireStateChanged();
    }

    public FrameEffect getFrameEffect() {
        return this.frameEffect;
    }

    public void setFrameEffect(FrameEffect frameEffect) {
        this.frameEffect = frameEffect;
        this.fireStateChanged();
    }

    public Color getFrameBaseColor() {
        return this.frameBaseColor;
    }

    public void setFrameBaseColor(Color color) {
        this.frameBaseColor = color;
        this.fireStateChanged();
    }

    public boolean isFrameBaseColorEnabled() {
        return this.frameBaseColorEnabled;
    }

    public void setFrameBaseColorEnabled(boolean bl) {
        this.frameBaseColorEnabled = bl;
        this.fireStateChanged();
    }

    public boolean isBackgroundVisible() {
        return this.backgroundVisible;
    }

    public void setBackgroundVisible(boolean bl) {
        this.backgroundVisible = bl;
        this.fireStateChanged();
    }

    public boolean isTitleVisible() {
        return this.titleVisible;
    }

    public void setTitleVisible(boolean bl) {
        this.titleVisible = bl;
        this.fireStateChanged();
    }

    public boolean isUnitVisible() {
        return this.unitVisible;
    }

    public void setUnitVisible(boolean bl) {
        this.unitVisible = bl;
        this.fireStateChanged();
    }

    public boolean isCustomTitleAndUnitFontEnabled() {
        return this.customTitleAndUnitFontEnabled;
    }

    public void setCustomTitleAndUnitFontEnabled(boolean bl) {
        this.customTitleAndUnitFontEnabled = bl;
        this.fireStateChanged();
    }

    public boolean isCustomLayerVisible() {
        return this.customLayerVisible;
    }

    public void setCustomLayerVisible(boolean bl) {
        this.customLayerVisible = bl;
        this.fireStateChanged();
    }

    public boolean isLedVisible() {
        return this.ledVisible;
    }

    public void setLedVisible(boolean bl) {
        this.ledVisible = bl;
        this.fireStateChanged();
    }

    public boolean isUserLedVisible() {
        return this.userLedVisible;
    }

    public void setUserLedVisible(boolean bl) {
        this.userLedVisible = bl;
        this.fireStateChanged();
    }

    public boolean isLcdVisible() {
        return this.lcdVisible;
    }

    public void setLcdVisible(boolean bl) {
        this.lcdVisible = bl;
        this.fireStateChanged();
    }

    public boolean isLcdUnitStringVisible() {
        return this.lcdUnitStringVisible;
    }

    public void setLcdUnitStringVisible(boolean bl) {
        this.lcdUnitStringVisible = bl;
        this.fireStateChanged();
    }

    public boolean isLcdScientificFormatEnabled() {
        return this.lcdScientificFormatEnabled;
    }

    public void setLcdScientificFormatEnabled(boolean bl) {
        this.lcdScientificFormatEnabled = bl;
        this.fireStateChanged();
    }

    public boolean isValueCoupled() {
        return this.valueCoupled;
    }

    public void setValueCoupled(boolean bl) {
        this.valueCoupled = bl;
        this.fireStateChanged();
    }

    public boolean isDigitalFontEnabled() {
        return this.digitalFontEnabled;
    }

    public void setDigitalFontEnabled(boolean bl) {
        this.digitalFontEnabled = bl;
        this.fireStateChanged();
    }

    public boolean isCustomLcdUnitFontEnabled() {
        return this.customLcdUnitFontEnabled;
    }

    public void setCustomLcdUnitFontEnabled(boolean bl) {
        this.customLcdUnitFontEnabled = bl;
        this.fireStateChanged();
    }

    public NumberSystem getNumberSystem() {
        return this.numberSystem;
    }

    public void setNumberSystem(NumberSystem numberSystem) {
        this.numberSystem = numberSystem;
        this.fireStateChanged();
    }

    public boolean isForegroundVisible() {
        return this.foregroundVisible;
    }

    public void setForegroundVisible(boolean bl) {
        this.foregroundVisible = bl;
        this.fireStateChanged();
    }

    public boolean isMinorTickmarksVisible() {
        return this.minorTickmarksVisible;
    }

    public void setMinorTickmarksVisible(boolean bl) {
        this.minorTickmarksVisible = bl;
        this.fireStateChanged();
    }

    public boolean isMajorTickmarksVisible() {
        return this.majorTickmarksVisible;
    }

    public void setMajorTickmarksVisible(boolean bl) {
        this.majorTickmarksVisible = bl;
        this.fireStateChanged();
    }

    public boolean isTickmarkColorFromThemeEnabled() {
        return this.tickmarkColorFromThemeEnabled;
    }

    public void setTickmarkColorFromThemeEnabled(boolean bl) {
        this.tickmarkColorFromThemeEnabled = bl;
        this.fireStateChanged();
    }

    public boolean isLabelColorFromThemeEnabled() {
        return this.labelColorFromThemeEnabled;
    }

    public void setLabelColorFromThemeEnabled(boolean bl) {
        this.labelColorFromThemeEnabled = bl;
        this.fireStateChanged();
    }

    public TicklabelOrientation getTicklabelOrientation() {
        return this.ticklabelOrientation;
    }

    public void setTicklabelOrienatation(TicklabelOrientation ticklabelOrientation) {
        this.ticklabelOrientation = ticklabelOrientation;
        this.fireStateChanged();
    }

    public boolean isTickmarksVisible() {
        return this.tickmarksVisible;
    }

    public void setTickmarksVisible(boolean bl) {
        this.tickmarksVisible = bl;
        this.fireStateChanged();
    }

    public boolean isTicklabelsVisible() {
        return this.ticklabelsVisible;
    }

    public void setTicklabelsVisible(boolean bl) {
        this.ticklabelsVisible = bl;
        this.fireStateChanged();
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(double d) {
        if (Double.compare(d, this.minValue) >= 0 && Double.compare(d, this.maxValue) <= 0) {
            this.threshold = d;
        } else {
            if (d < this.niceMinValue) {
                this.threshold = this.niceMinValue;
            }
            if (d > this.niceMaxValue) {
                this.threshold = this.niceMaxValue;
            }
        }
        this.fireStateChanged();
    }

    public boolean isThresholdVisible() {
        return this.thresholdVisible;
    }

    public void setThresholdVisible(boolean bl) {
        this.thresholdVisible = bl;
        this.fireStateChanged();
    }

    public boolean isThresholdBehaviourInverted() {
        return this.thresholdBehaviourInverted;
    }

    public void setThresholdBehaviourInverted(boolean bl) {
        this.thresholdBehaviourInverted = bl;
        this.fireStateChanged();
    }

    public ColorDef getThresholdColor() {
        return this.thresholdColor;
    }

    public void setThresholdColor(ColorDef colorDef) {
        this.thresholdColor = colorDef;
        this.fireStateChanged();
    }

    public CustomColorDef getCustomThresholdColor() {
        return this.customThresholdColor;
    }

    public void setCustomThresholdColor(CustomColorDef customColorDef) {
        this.customThresholdColor = customColorDef;
        this.fireStateChanged();
    }

    public ThresholdType getThresholdType() {
        return this.thresholdType;
    }

    public void setThresholdType(ThresholdType thresholdType) {
        this.thresholdType = thresholdType;
        this.fireStateChanged();
    }

    public double getMinMeasuredValue() {
        return this.minMeasuredValue;
    }

    public void setMinMeasuredValue(double d) {
        if (Double.compare(d, this.niceMinValue) >= 0 && Double.compare(d, this.niceMaxValue) <= 0) {
            this.minMeasuredValue = d;
        } else {
            if (d < this.niceMinValue) {
                this.minMeasuredValue = this.niceMinValue;
            }
            if (d > this.niceMaxValue) {
                this.minMeasuredValue = this.niceMaxValue;
            }
        }
        this.createRadialShapeOfMeasureValuesArea();
        this.fireStateChanged();
    }

    public void resetMinMeasuredValue() {
        this.minMeasuredValue = this.value;
        this.createRadialShapeOfMeasureValuesArea();
        this.fireStateChanged();
    }

    public void resetMinMeasuredValue(double d) {
        this.minMeasuredValue = d < this.niceMinValue ? this.niceMinValue : (d > this.niceMaxValue ? this.niceMaxValue : d);
        this.createRadialShapeOfMeasureValuesArea();
        this.fireStateChanged();
    }

    public boolean isMinMeasuredValueVisible() {
        return this.minMeasuredValueVisible;
    }

    public void setMinMeasuredValueVisible(boolean bl) {
        this.minMeasuredValueVisible = bl;
        this.fireStateChanged();
    }

    public double getMaxMeasuredValue() {
        return this.maxMeasuredValue;
    }

    public void setMaxMeasuredValue(double d) {
        if (Double.compare(d, this.niceMinValue) >= 0 && Double.compare(d, this.niceMaxValue) <= 0) {
            this.maxMeasuredValue = d;
        } else {
            if (d < this.niceMinValue) {
                this.maxMeasuredValue = this.niceMinValue;
            }
            if (d > this.niceMaxValue) {
                this.maxMeasuredValue = this.niceMaxValue;
            }
        }
        this.createRadialShapeOfMeasureValuesArea();
        this.fireStateChanged();
    }

    public void resetMaxMeasuredValue() {
        this.maxMeasuredValue = this.value;
        this.createRadialShapeOfMeasureValuesArea();
        this.fireStateChanged();
    }

    public void resetMaxMeasuredValue(double d) {
        this.maxMeasuredValue = d < this.niceMinValue ? this.niceMinValue : (d > this.niceMaxValue ? this.niceMaxValue : d);
        this.createRadialShapeOfMeasureValuesArea();
        this.fireStateChanged();
    }

    public boolean isMaxMeasuredValueVisible() {
        return this.maxMeasuredValueVisible;
    }

    public void setMaxMeasuredValueVisible(boolean bl) {
        this.maxMeasuredValueVisible = bl;
        this.fireStateChanged();
    }

    public boolean isRangeOfMeasuredValuesVisible() {
        return this.rangeOfMeasuredValuesVisible;
    }

    public void setRangeOfMeasuredValuesVisible(boolean bl) {
        this.rangeOfMeasuredValuesVisible = bl;
        this.fireStateChanged();
    }

    public Paint getRangeOfMeasuredValuesPaint() {
        return this.rangeOfMeasuredValuesPaint;
    }

    public Shape getRadialShapeOfMeasuredValues() {
        return this.radialShapeOfMeasuredValues;
    }

    public Area getRadialAreaOfMeasuredValues() {
        return new Area(this.radialShapeOfMeasuredValues);
    }

    public void setRangeOfMeasuredValuesPaint(Paint paint) {
        this.rangeOfMeasuredValuesPaint = paint;
        this.fireStateChanged();
    }

    public boolean isCollectingData() {
        return this.collectingData;
    }

    public void setCollectingData(boolean bl) {
        this.collectingData = bl;
    }

    public double getTrackStart() {
        return this.trackStart;
    }

    public void setTrackStart(double d) {
        if (Double.compare(d, this.trackStop) == 0) {
            throw new IllegalArgumentException("Track start value cannot equal track stop value");
        }
        this.trackStart = d;
        this.validate();
        this.fireStateChanged();
    }

    public double getTrackSection() {
        return this.trackSection;
    }

    public void setTrackSection(double d) {
        this.trackSection = d;
        this.validate();
        this.fireStateChanged();
    }

    public double getTrackStop() {
        return this.trackStop;
    }

    public void setTrackStop(double d) {
        if (Double.compare(this.trackStart, d) == 0) {
            throw new IllegalArgumentException("Track stop value cannot equal track start value");
        }
        this.trackStop = d;
        this.validate();
        this.fireStateChanged();
    }

    public boolean isTrackVisible() {
        return this.trackVisible;
    }

    public void setTrackVisible(boolean bl) {
        this.trackVisible = bl;
        this.fireStateChanged();
    }

    public List<Section> getSections() {
        ArrayList<Section> arrayList = new ArrayList<Section>(10);
        arrayList.addAll(this.sections);
        return arrayList;
    }

    public void setSections(Section ... sectionArray) {
        this.sections.clear();
        for (Section section : sectionArray) {
            this.sections.add(new Section(section.getStart(), section.getStop(), section.getColor()));
        }
        this.validate();
        this.fireStateChanged();
    }

    public void addSection(Section section) {
        this.sections.add(section);
        this.fireStateChanged();
    }

    public void resetSections() {
        this.sections.clear();
        this.fireStateChanged();
    }

    public boolean isSectionsVisible() {
        return this.sectionsVisible;
    }

    public void setSectionsVisible(boolean bl) {
        this.sectionsVisible = bl;
        this.fireStateChanged();
    }

    public boolean isHighlightSection() {
        return this.highlightSection;
    }

    public void setHighlightSection(boolean bl) {
        this.highlightSection = bl;
        this.fireStateChanged();
    }

    public List<Section> getAreas() {
        ArrayList<Section> arrayList = new ArrayList<Section>(10);
        arrayList.addAll(this.areas);
        return arrayList;
    }

    public void setAreas(Section ... sectionArray) {
        this.areas.clear();
        for (Section section : sectionArray) {
            this.areas.add(new Section(section.getStart(), section.getStop(), section.getColor()));
        }
        this.validate();
        this.fireStateChanged();
    }

    public void addArea(Section section) {
        this.areas.add(section);
    }

    public void resetAreas() {
        this.areas.clear();
    }

    public boolean isAreasVisible() {
        return this.areasVisible;
    }

    public void setAreasVisible(boolean bl) {
        this.areasVisible = bl;
        this.fireStateChanged();
    }

    public boolean isHighlightArea() {
        return this.highlightArea;
    }

    public void setHighlightArea(boolean bl) {
        this.highlightArea = bl;
        this.fireStateChanged();
    }

    public List<Section> getTickmarkSections() {
        ArrayList<Section> arrayList = new ArrayList<Section>(10);
        arrayList.addAll(this.tickmarkSections);
        return arrayList;
    }

    public void setTickmarkSections(Section ... sectionArray) {
        this.tickmarkSections.clear();
        for (Section section : sectionArray) {
            this.tickmarkSections.add(new Section(section.getStart(), section.getStop(), section.getColor()));
        }
        this.validate();
        this.fireStateChanged();
    }

    public void addTickmarkSection(Section section) {
        this.tickmarkSections.add(section);
        this.fireStateChanged();
    }

    public void resetTickmarkSections() {
        this.tickmarkSections.clear();
        this.fireStateChanged();
    }

    public boolean isTickmarkSectionsVisible() {
        return this.tickmarkSectionsVisible;
    }

    public void setTickmarkSectionsVisible(boolean bl) {
        this.tickmarkSectionsVisible = bl;
        this.fireStateChanged();
    }

    public GaugeType getGaugeType() {
        return this.gaugeType;
    }

    public void setGaugeType(GaugeType gaugeType) {
        this.gaugeType = gaugeType;
        this.calcAngleStep();
        this.fireStateChanged();
    }

    public double getFreeAreaAngle() {
        return this.gaugeType.FREE_AREA_ANGLE;
    }

    public double getAngleStep() {
        return this.angleStep;
    }

    public double getLogAngleStep() {
        return this.logAngleStep;
    }

    public double getRotationOffset() {
        return this.gaugeType.ROTATION_OFFSET;
    }

    public double getTickmarkOffset() {
        return this.gaugeType.TICKMARK_OFFSET;
    }

    public void setMinMaxValues(double d, double d2) {
        this.minValue = d;
        this.maxValue = d2;
        this.calculate();
    }

    public void setMinMaxAndNoOfTicks(double d, double d2, int n, int n2) {
        this.maxNoOfMinorTicks = n;
        this.maxNoOfMajorTicks = n2;
        this.minValue = d;
        this.maxValue = d2;
        this.calculate();
    }

    public int getMaxNoOfMajorTicks() {
        return this.maxNoOfMajorTicks;
    }

    public void setMaxNoOfMajorTicks(int n) {
        this.maxNoOfMajorTicks = n > 20 ? 20 : (n < 2 ? 2 : n);
        this.calculate();
        this.fireStateChanged();
    }

    public int getMaxNoOfMinorTicks() {
        return this.maxNoOfMinorTicks;
    }

    public void setMaxNoOfMinorTicks(int n) {
        this.maxNoOfMinorTicks = n > 10 ? 10 : (n < 1 ? 1 : n);
        this.calculate();
        this.fireStateChanged();
    }

    public double getMajorTickSpacing() {
        return this.majorTickSpacing;
    }

    public void setMajorTickSpacing(double d) {
        if (!this.niceScale) {
            this.majorTickSpacing = d;
            this.calculate();
            this.validate();
            this.fireStateChanged();
        }
    }

    public double getMinorTickSpacing() {
        return this.minorTickSpacing;
    }

    public void setMinorTickSpacing(double d) {
        if (!this.niceScale) {
            this.minorTickSpacing = d;
            this.calculate();
            this.validate();
            this.fireStateChanged();
        }
    }

    public double getNiceMinValue() {
        return this.niceMinValue;
    }

    public double getNiceMaxValue() {
        return this.niceMaxValue;
    }

    public double getNiceRange() {
        return this.niceRange;
    }

    public BackgroundColor getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(BackgroundColor backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.fireStateChanged();
    }

    public Paint getCustomBackground() {
        return this.customBackground;
    }

    public void setCustomBackground(Paint paint) {
        this.customBackground = paint;
        this.fireStateChanged();
    }

    public Color getTextureColor() {
        return this.textureColor;
    }

    public void setTextureColor(Color color) {
        this.textureColor = color;
        this.fireStateChanged();
    }

    public BufferedImage getCustomLayer() {
        return this.customLayer;
    }

    public void setCustomLayer(BufferedImage bufferedImage) {
        if (this.customLayer != null) {
            this.customLayer.flush();
        }
        this.customLayer = bufferedImage;
        this.fireStateChanged();
    }

    public boolean isGlowVisible() {
        return this.glowVisible;
    }

    public void setGlowVisible(boolean bl) {
        this.glowVisible = bl;
        this.fireStateChanged();
    }

    public Color getGlowColor() {
        return this.glowColor;
    }

    public void setGlowColor(Color color) {
        this.glowColor = color;
        this.fireStateChanged();
    }

    public boolean isGlowing() {
        return this.glowing;
    }

    public void setGlowing(boolean bl) {
        this.glowing = bl;
        this.fireStateChanged();
    }

    public FrameType getFrameType() {
        return this.frameType;
    }

    public void setFrameType(FrameType frameType) {
        this.frameType = frameType;
        this.fireStateChanged();
    }

    public FrameDesign getFrameDesign() {
        return this.frameDesign;
    }

    public void setFrameDesign(FrameDesign frameDesign) {
        this.frameDesign = frameDesign;
        this.fireStateChanged();
    }

    public Paint getCustomFrameDesign() {
        return this.customFrameDesign;
    }

    public void setCustomFrameDesign(Paint paint) {
        this.customFrameDesign = paint;
        this.fireStateChanged();
    }

    public Paint getOuterFrameColor() {
        return this.outerFrameColor;
    }

    public void setOuterFrameColor(Paint paint) {
        this.outerFrameColor = paint;
        this.fireStateChanged();
    }

    public Paint getInnerFrameColor() {
        return this.innerFrameColor;
    }

    public void setInnerFrameColor(Paint paint) {
        this.innerFrameColor = paint;
        this.fireStateChanged();
    }

    public LedColor getLedColor() {
        return this.ledColor;
    }

    public void setLedColor(LedColor ledColor) {
        this.ledColor = ledColor;
        this.fireStateChanged();
    }

    public CustomLedColor getCustomLedColor() {
        return this.customLedColor;
    }

    public void setCustomLedColor(CustomLedColor customLedColor) {
        this.customLedColor = customLedColor;
        this.fireStateChanged();
    }

    public LedColor getUserLedColor() {
        return this.userLedColor;
    }

    public void setUserLedColor(LedColor ledColor) {
        this.userLedColor = ledColor;
        this.fireStateChanged();
    }

    public CustomLedColor getCustomUserLedColor() {
        return this.customUserLedColor;
    }

    public void setCustomUserLedColor(CustomLedColor customLedColor) {
        this.customUserLedColor = customLedColor;
        this.fireStateChanged();
    }

    public LcdColor getLcdColor() {
        return this.lcdColor;
    }

    public void setLcdColor(LcdColor lcdColor) {
        this.lcdColor = lcdColor;
        this.fireStateChanged();
    }

    public Paint getCustomLcdBackground() {
        return this.customLcdColor;
    }

    public void setCustomLcdBackground(Paint paint) {
        this.customLcdColor = paint;
        this.fireStateChanged();
    }

    public Color getCustomLcdForeground() {
        return this.customLcdForegroundColor;
    }

    public void setCustomLcdForeground(Color color) {
        this.customLcdForegroundColor = color;
        this.fireStateChanged();
    }

    public TickmarkType getMinorTickmarkType() {
        return this.minorTickmarkType;
    }

    public void setMinorTickmarkType(TickmarkType tickmarkType) {
        this.minorTickmarkType = tickmarkType;
        this.fireStateChanged();
    }

    public TickmarkType getMajorTickmarkType() {
        return this.majorTickmarkType;
    }

    public void setMajorTickmarkType(TickmarkType tickmarkType) {
        this.majorTickmarkType = tickmarkType;
        this.fireStateChanged();
    }

    public NumberFormat getLabelNumberFormat() {
        return this.labelNumberFormat;
    }

    public void setLabelNumberFormat(NumberFormat numberFormat) {
        this.labelNumberFormat = numberFormat;
        this.fireStateChanged();
    }

    public Color getTickmarkColor() {
        return this.tickmarkColor;
    }

    public void setTickmarkColor(Color color) {
        this.tickmarkColor = color;
        this.fireStateChanged();
    }

    public Color getCustomTickmarkColor() {
        return this.customTickmarkColor;
    }

    public void setCustomTickmarkColor(Color color) {
        this.customTickmarkColor = color;
        this.fireStateChanged();
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelColor(Color color) {
        this.labelColor = color;
        this.fireStateChanged();
    }

    public Color getTrackStartColor() {
        return this.trackStartColor;
    }

    public void setTrackStartColor(Color color) {
        this.trackStartColor = color;
        this.fireStateChanged();
    }

    public Color getTrackSectionColor() {
        return this.trackSectionColor;
    }

    public void setTrackSectionColor(Color color) {
        this.trackSectionColor = color;
        this.fireStateChanged();
    }

    public Color getTrackStopColor() {
        return this.trackStopColor;
    }

    public void setTrackStopColor(Color color) {
        this.trackStopColor = color;
        this.fireStateChanged();
    }

    public PointerType getPointerType() {
        return this.pointerType;
    }

    public void setPointerType(PointerType pointerType) {
        this.pointerType = pointerType;
        this.fireStateChanged();
    }

    public ColorDef getPointerColor() {
        return this.pointerColor;
    }

    public void setPointerColor(ColorDef colorDef) {
        this.pointerColor = colorDef;
        this.fireStateChanged();
    }

    public boolean isPointerShadowVisible() {
        return this.pointerShadowVisible;
    }

    public void setPointerShadowVisible(boolean bl) {
        this.pointerShadowVisible = bl;
        this.fireStateChanged();
    }

    public CustomColorDef getCustomPointerColorObject() {
        return this.customPointerColorObject;
    }

    public void setCustomPointerColorObject(CustomColorDef customColorDef) {
        this.customPointerColorObject = customColorDef;
        this.fireStateChanged();
    }

    public Color getCustomPointerColor() {
        return this.customPointerColorObject.COLOR;
    }

    public ColorDef getValueColor() {
        return this.valueColor;
    }

    public void setValueColor(ColorDef colorDef) {
        this.valueColor = colorDef;
        this.fireStateChanged();
    }

    public CustomColorDef getCustomValueColorObject() {
        return this.customValueColorObject;
    }

    public void setCustomValueColorObject(CustomColorDef customColorDef) {
        this.customValueColorObject = customColorDef;
        this.fireStateChanged();
    }

    public Color getCustomValueColor() {
        return this.customValueColorObject.COLOR;
    }

    public KnobType getKnobType() {
        return this.knobType;
    }

    public void setKnobType(KnobType knobType) {
        this.knobType = knobType;
        this.fireStateChanged();
    }

    public KnobStyle getKnobStyle() {
        return this.knobStyle;
    }

    public void setKnobStyle(KnobStyle knobStyle) {
        this.knobStyle = knobStyle;
        this.fireStateChanged();
    }

    public boolean getPostsVisible() {
        return this.postsVisible;
    }

    public void setPostsVisible(boolean bl) {
        this.postsVisible = bl;
        this.fireStateChanged();
    }

    public ForegroundType getForegroundType() {
        return this.foregroundType;
    }

    public void setForegroundType(ForegroundType foregroundType) {
        this.foregroundType = foregroundType;
        this.fireStateChanged();
    }

    public Font getStandardBaseFont() {
        return this.STANDARD_BASE_FONT;
    }

    public Font getStandardInfoFont() {
        return this.STANDARD_INFO_FONT;
    }

    public Font getDigitalBaseFont() {
        return this.DIGITAL_BASE_FONT;
    }

    public Font getLcdValueFont() {
        return this.lcdValueFont;
    }

    public void setLcdValueFont(Font font) {
        this.lcdValueFont = font;
        this.fireStateChanged();
    }

    public Font getLcdUnitFont() {
        return this.lcdUnitFont;
    }

    public void setLcdUnitFont(Font font) {
        this.lcdUnitFont = font;
        this.fireStateChanged();
    }

    public Font getCustomLcdUnitFont() {
        return this.customLcdUnitFont;
    }

    public void setCustomLcdUnitFont(Font font) {
        this.customLcdUnitFont = font;
        this.fireStateChanged();
    }

    public Font getLcdInfoFont() {
        return this.lcdInfoFont;
    }

    public void setLcdInfoFont(Font font) {
        this.lcdInfoFont = font;
        this.fireStateChanged();
    }

    public int getLcdDecimals() {
        return this.lcdDecimals;
    }

    public void setLcdDecimals(int n) {
        this.lcdDecimals = n;
        this.fireStateChanged();
    }

    public boolean isNiceScale() {
        return this.niceScale;
    }

    public void setNiceScale(boolean bl) {
        this.niceScale = bl;
        if (!this.niceScale) {
            this.minorTickSpacing = 1.0;
            this.majorTickSpacing = 10.0;
        }
        this.calculate();
        this.validate();
        this.calcAngleStep();
        this.fireStateChanged();
    }

    public boolean isLogScale() {
        return this.logScale;
    }

    public void setLogScale(boolean bl) {
        this.logScale = bl;
        this.fireStateChanged();
    }

    public void validate() {
        if (this.niceMinValue > 0.0 || this.niceMaxValue < 0.0) {
            this.autoResetToZero = false;
        }
        if (this.threshold < this.niceMinValue || this.threshold > this.niceMaxValue) {
            this.threshold = this.niceMaxValue;
        }
        if (this.minMeasuredValue < this.niceMinValue || this.minMeasuredValue > this.niceMaxValue) {
            this.minMeasuredValue = this.value;
        }
        if (this.maxMeasuredValue > this.niceMaxValue || this.maxMeasuredValue < this.niceMinValue) {
            this.maxMeasuredValue = this.value;
        }
        if (this.peakValue < this.niceMinValue || this.peakValue > this.niceMaxValue) {
            this.peakValue = this.value;
        }
        if (Double.compare(this.trackStart, this.niceMinValue) <= 0 || Double.compare(this.trackStart, this.niceMaxValue) >= 0 || Double.compare(this.trackStart, this.trackStop) >= 0) {
            this.trackStart = this.niceMinValue;
        }
        if (Double.compare(this.trackStop, this.niceMinValue) <= 0 || Double.compare(this.trackStop, this.niceMaxValue) >= 0 || Double.compare(this.trackStop, this.trackStart) <= 0) {
            this.trackStop = this.niceMaxValue;
        }
        if (Double.compare(this.trackSection, this.niceMinValue) <= 0 || Double.compare(this.trackSection, this.niceMaxValue) >= 0 || Double.compare(this.trackSection, this.trackStart) <= 0 || Double.compare(this.trackSection, this.trackStop) >= 0) {
            this.trackSection = this.trackStart + (this.trackStop - this.trackStart) / 2.0;
        }
        for (Section section : this.areas) {
            if (section.getStart() < this.niceMinValue || Double.compare(section.getStart(), this.niceMaxValue) >= 0 || Double.compare(section.getStart(), section.getStop()) >= 0) {
                section.setStart(this.niceMinValue);
            }
            if (section.getStop() < this.niceMinValue || section.getStop() > this.niceMaxValue || Double.compare(section.getStop(), section.getStart()) <= 0) {
                section.setStop(this.niceMaxValue);
            }
            if (Double.compare(section.getStart(), this.minValue) == 0) {
                section.setStart(this.niceMinValue);
            }
            if (Double.compare(section.getStop(), this.maxValue) != 0) continue;
            section.setStop(this.niceMaxValue);
        }
        for (Section section : this.sections) {
            if (section.getStart() < this.niceMinValue || Double.compare(section.getStart(), this.niceMaxValue) >= 0 || Double.compare(section.getStart(), section.getStop()) >= 0) {
                section.setStart(this.niceMinValue);
            }
            if (section.getStop() < this.niceMinValue || section.getStop() > this.niceMaxValue || Double.compare(section.getStop(), section.getStart()) <= 0) {
                section.setStop(this.niceMaxValue);
            }
            if (Double.compare(section.getStart(), this.minValue) == 0) {
                section.setStart(this.niceMinValue);
            }
            if (Double.compare(section.getStop(), this.maxValue) != 0) continue;
            section.setStop(this.niceMaxValue);
        }
        for (Section section : this.tickmarkSections) {
            if (section.getStart() < this.niceMinValue || Double.compare(section.getStart(), this.niceMaxValue) >= 0 || Double.compare(section.getStart(), section.getStop()) >= 0) {
                section.setStart(this.niceMinValue);
            }
            if (section.getStop() < this.niceMinValue || section.getStop() > this.niceMaxValue || Double.compare(section.getStop(), section.getStart()) <= 0) {
                section.setStop(this.niceMaxValue);
            }
            if (Double.compare(section.getStart(), this.minValue) == 0) {
                section.setStart(this.niceMinValue);
            }
            if (Double.compare(section.getStop(), this.maxValue) != 0) continue;
            section.setStop(this.niceMaxValue);
        }
        this.value = this.value < this.niceMinValue ? this.niceMinValue : (this.value > this.niceMaxValue ? this.niceMaxValue : this.value);
    }

    private void calcAngleStep() {
        this.angleStep = this.gaugeType.ANGLE_RANGE / this.range;
        this.logAngleStep = this.gaugeType.ANGLE_RANGE / Util.INSTANCE.logOfBase(10.0, this.range);
    }

    private void calculate() {
        if (this.niceScale) {
            this.niceRange = this.calcNiceNumber(this.maxValue - this.minValue, false);
            this.majorTickSpacing = this.calcNiceNumber(this.niceRange / (double)(this.maxNoOfMajorTicks - 1), true);
            this.niceMinValue = Math.floor(this.minValue / this.majorTickSpacing) * this.majorTickSpacing;
            this.niceMaxValue = Math.ceil(this.maxValue / this.majorTickSpacing) * this.majorTickSpacing;
            this.minorTickSpacing = this.calcNiceNumber(this.majorTickSpacing / (double)(this.maxNoOfMinorTicks - 1), true);
            this.range = this.niceMaxValue - this.niceMinValue;
        } else {
            this.niceRange = this.maxValue - this.minValue;
            this.niceMinValue = this.minValue;
            this.niceMaxValue = this.maxValue;
            this.range = this.niceRange;
        }
    }

    private double calcNiceNumber(double d, boolean bl) {
        double d2 = Math.floor(Math.log10(d));
        double d3 = d / Math.pow(10.0, d2);
        double d4 = bl ? (d3 < 1.5 ? 1.0 : (d3 < 3.0 ? 2.0 : (d3 < 7.0 ? 5.0 : 10.0))) : (d3 <= 1.0 ? 1.0 : (d3 <= 2.0 ? 2.0 : (d3 <= 5.0 ? 5.0 : 10.0)));
        return d4 * Math.pow(10.0, d2);
    }

    private void createRadialShapeOfMeasureValuesArea() {
        if (this.bounds.width > 1 && this.bounds.height > 1 && Double.compare(this.getMinMeasuredValue(), this.getMaxMeasuredValue()) != 0) {
            double d = Math.toDegrees(this.getGaugeType().ANGLE_RANGE) / (this.getMaxValue() - this.getMinValue());
            double d2 = (float)this.bounds.width * 0.35f - (float)this.bounds.height * 0.04f;
            double d3 = (double)this.bounds.width / 2.0 - d2;
            ((Arc2D)this.radialShapeOfMeasuredValues).setFrame(new Rectangle2D.Double((double)this.bounds.x + d3, (double)this.bounds.y + d3, 2.0 * d2, 2.0 * d2));
            ((Arc2D)this.radialShapeOfMeasuredValues).setAngleStart(this.getGaugeType().ORIGIN_CORRECTION - this.getMinMeasuredValue() * d + this.getMinValue() * d);
            ((Arc2D)this.radialShapeOfMeasuredValues).setAngleExtent(-(this.getMaxMeasuredValue() - this.getMinMeasuredValue()) * d);
            ((Arc2D)this.radialShapeOfMeasuredValues).setArcType(2);
        }
    }

    public void reset() {
        this.init();
    }

    public Model clone() {
        try {
            return (Model)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return new Model();
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.LISTENER_LIST.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.LISTENER_LIST.remove(ChangeListener.class, changeListener);
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.LISTENER_LIST.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i + 1]).stateChanged(this.changeEvent);
        }
    }

    public String toString() {
        return "Model";
    }
}

