/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.tools;

import eu.hansolo.steelseries.tools.BrushedMetalFilter;
import eu.hansolo.steelseries.tools.ConicalGradientPaint;
import eu.hansolo.steelseries.tools.HsbColor;
import eu.hansolo.steelseries.tools.LinenFilter;
import eu.hansolo.steelseries.tools.Orientation;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;

public final class Util
extends Enum<Util> {
    public static final /* enum */ Util INSTANCE = new Util();
    private final float INT_TO_FLOAT_CONST = 0.003921569f;
    private final Pattern NUMBERS_ONLY = Pattern.compile("^[-+]?[0-9]+[.]?[0-9]*([eE][-+]?[0-9]+)?$");
    private final Matcher MATCHES_NUMBERS = this.NUMBERS_ONLY.matcher("");
    private Font digitalFont = null;
    private final Font STANDARD_FONT = new Font("Verdana", 1, 24);
    private final Rectangle2D TEXT_BOUNDARY = new Rectangle2D.Double(0.0, 0.0, 10.0, 10.0);
    private static final /* synthetic */ Util[] $VALUES;

    public static Util[] values() {
        return (Util[])$VALUES.clone();
    }

    public static Util valueOf(String string) {
        return Enum.valueOf(Util.class, string);
    }

    private Util() {
        try {
            this.digitalFont = Font.createFont(0, ((Object)((Object)this)).getClass().getResourceAsStream("/eu/hansolo/steelseries/resources/lcd.ttf"));
            GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(this.digitalFont);
        }
        catch (FontFormatException fontFormatException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Shape rotateTextAroundCenter(Graphics2D graphics2D, String string, int n, int n2, double d) {
        FontRenderContext fontRenderContext = new FontRenderContext(null, true, true);
        TextLayout textLayout = new TextLayout(string, graphics2D.getFont(), fontRenderContext);
        this.MATCHES_NUMBERS.reset(string);
        float f = this.MATCHES_NUMBERS.matches() ? textLayout.getDescent() : 0.0f;
        Rectangle2D rectangle2D = textLayout.getBounds();
        this.TEXT_BOUNDARY.setRect(rectangle2D.getMinX(), rectangle2D.getMinY(), rectangle2D.getWidth(), rectangle2D.getHeight() + (double)(f / 2.0f));
        GlyphVector glyphVector = graphics2D.getFont().createGlyphVector(fontRenderContext, string);
        Shape shape = glyphVector.getOutline((int)(-this.TEXT_BOUNDARY.getCenterX()), 2 * (int)this.TEXT_BOUNDARY.getCenterY());
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.translate((double)n, (double)n2 + this.TEXT_BOUNDARY.getHeight());
        graphics2D.rotate(d, -this.TEXT_BOUNDARY.getCenterX() + this.TEXT_BOUNDARY.getWidth() / 2.0, this.TEXT_BOUNDARY.getCenterY() - (this.TEXT_BOUNDARY.getHeight() + (double)f) / 2.0);
        graphics2D.fill(shape);
        graphics2D.setTransform(affineTransform);
        return shape;
    }

    public Point2D getCenteredTextPosition(Graphics2D graphics2D, Rectangle2D rectangle2D, String string) {
        return this.getCenteredTextPosition(graphics2D, rectangle2D, graphics2D.getFont(), string);
    }

    public Point2D getCenteredTextPosition(Graphics2D graphics2D, Rectangle2D rectangle2D, Font font, String string) {
        double d = rectangle2D.getWidth() / 2.0;
        double d2 = rectangle2D.getHeight() / 2.0;
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        TextLayout textLayout = new TextLayout(string, font, fontRenderContext);
        Rectangle2D rectangle2D2 = textLayout.getBounds();
        double d3 = d - rectangle2D2.getWidth() / 2.0;
        double d4 = d2 - rectangle2D2.getHeight() / 2.0 + rectangle2D2.getHeight();
        return new Point2D.Double(d3, d4);
    }

    public BufferedImage getScaledInstance(BufferedImage bufferedImage, int n, int n2, Object object) {
        int n3 = bufferedImage.getTransparency() == 1 ? 1 : 2;
        BufferedImage bufferedImage2 = bufferedImage;
        BufferedImage bufferedImage3 = null;
        Graphics2D graphics2D = null;
        int n4 = n;
        int n5 = n2;
        int n6 = bufferedImage2.getWidth();
        int n7 = bufferedImage2.getHeight();
        if (bufferedImage3 == null) {
            bufferedImage3 = new BufferedImage(n4, n5, n3);
            graphics2D = bufferedImage3.createGraphics();
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object);
        graphics2D.drawImage(bufferedImage2, 0, 0, n4, n5, 0, 0, n6, n7, null);
        bufferedImage2 = bufferedImage3;
        graphics2D.dispose();
        if (n != bufferedImage2.getWidth() || n2 != bufferedImage2.getHeight()) {
            bufferedImage3 = new BufferedImage(n, n2, n3);
            graphics2D = bufferedImage3.createGraphics();
            graphics2D.drawImage((Image)bufferedImage2, 0, 0, null);
            graphics2D.dispose();
            bufferedImage2 = bufferedImage3;
        }
        return bufferedImage2;
    }

    public BufferedImage createReflectionImage(BufferedImage bufferedImage) {
        return this.createReflectionImage(bufferedImage, 0.5f, 0.7f);
    }

    public BufferedImage createReflectionImage(BufferedImage bufferedImage, float f, float f2) {
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
        BufferedImage bufferedImage3 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.translate(0, bufferedImage.getHeight());
        graphics2D.scale(1.0, -1.0);
        graphics2D.drawRenderedImage(bufferedImage, null);
        graphics2D.setComposite(AlphaComposite.getInstance(6));
        graphics2D.setPaint(new GradientPaint(0.0f, (float)bufferedImage.getHeight() * f2, new Color(0.0f, 0.0f, 0.0f, 0.0f), 0.0f, bufferedImage.getHeight(), new Color(0.0f, 0.0f, 0.0f, f)));
        graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.dispose();
        float[] fArray = new float[]{0.0625f, 0.125f, 0.0625f, 0.125f, 0.25f, 0.125f, 0.0625f, 0.125f, 0.0625f};
        Kernel kernel = new Kernel(3, 3, fArray);
        ConvolveOp convolveOp = new ConvolveOp(kernel, 1, null);
        convolveOp.filter(bufferedImage2, bufferedImage3);
        return bufferedImage3;
    }

    public BufferedImage createBrushMetalTexture(Color color, int n, int n2) {
        return this.createBrushMetalTexture(color, n, n2, 5, 0.1f, true, 0.3f);
    }

    public BufferedImage createBrushMetalTexture(Color color, int n, int n2, int n3, float f, boolean bl, float f2) {
        if (n <= 0 || n2 <= 0) {
            return new BufferedImage(1, 1, 2);
        }
        BufferedImage bufferedImage = this.createImage(n, n2, 3);
        BrushedMetalFilter brushedMetalFilter = new BrushedMetalFilter();
        if (color != null) {
            brushedMetalFilter.setColor(color.getRGB());
        }
        brushedMetalFilter.setAmount(f);
        brushedMetalFilter.setMonochrome(bl);
        brushedMetalFilter.setShine(f2);
        brushedMetalFilter.setRadius(n3);
        return brushedMetalFilter.filter(bufferedImage, bufferedImage);
    }

    public BufferedImage createLinenTexture(Color color, int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            return new BufferedImage(1, 1, 2);
        }
        BufferedImage bufferedImage = this.createImage(n, n2, 3);
        BufferedImage bufferedImage2 = this.createImage(n, n2, 3);
        LinenFilter linenFilter = new LinenFilter();
        if (color != null) {
            linenFilter.setColor(color.getRGB());
        }
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.5f);
        BufferedImage bufferedImage3 = this.createImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage3.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        linenFilter.setShine(0.25f);
        linenFilter.setAmount(0.65f);
        linenFilter.setRadius(60);
        graphics2D.drawImage((Image)linenFilter.filter(bufferedImage, bufferedImage), 0, 0, null);
        graphics2D.setComposite(alphaComposite);
        linenFilter.setOrientation(Orientation.VERTICAL);
        linenFilter.setAmount(0.7f);
        linenFilter.setRadius(55);
        graphics2D.drawImage((Image)linenFilter.filter(bufferedImage2, bufferedImage2), 0, 0, null);
        graphics2D.dispose();
        return bufferedImage3;
    }

    public BufferedImage create_STAINLESS_STEEL_PLATE_Texture(int n) {
        if (n <= 0) {
            return this.createImage(1, 1, 3);
        }
        BufferedImage bufferedImage = this.createImage(n, n, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Ellipse2D.Double double_ = new Ellipse2D.Double(0.0, 0.0, (double)n / 2.0, (double)n / 2.0);
        Point2D.Double double_2 = new Point2D.Double(double_.getCenterX(), double_.getCenterY());
        float[] fArray = new float[]{0.0f, 0.03f, 0.1f, 0.14f, 0.24f, 0.33f, 0.38f, 0.5f, 0.62f, 0.67f, 0.76f, 0.81f, 0.85f, 0.97f, 1.0f};
        Color[] colorArray = new Color[]{new Color(0xFDFDFD), new Color(0xFDFDFD), new Color(0xB2B2B4), new Color(0xACACAE), new Color(0xFDFDFD), new Color(7237232), new Color(7237232), new Color(0xFDFDFD), new Color(7237232), new Color(7237232), new Color(0xFDFDFD), new Color(0xACACAE), new Color(0xB2B2B4), new Color(0xFDFDFD), new Color(0xFDFDFD)};
        ConicalGradientPaint conicalGradientPaint = new ConicalGradientPaint(false, double_2, -0.45f, fArray, colorArray);
        double d = (double)n / 4.0;
        graphics2D.translate(-d, -d);
        AffineTransform affineTransform = graphics2D.getTransform();
        for (int i = 0; i < 5; ++i) {
            int n2;
            if (i % 2 == 0) {
                n2 = 3;
                graphics2D.translate(0.0, d * (double)i);
            } else {
                n2 = 2;
                graphics2D.translate(d, d * (double)i);
            }
            for (int j = 0; j < n2; ++j) {
                graphics2D.setPaint(conicalGradientPaint);
                graphics2D.fill(double_);
                graphics2D.translate((double)n / 2.0, 0.0);
            }
            graphics2D.setTransform(affineTransform);
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    public BufferedImage create_CARBON_Texture(int n) {
        if (n <= 0) {
            return this.createImage(1, 1, 3);
        }
        BufferedImage bufferedImage = this.createImage(n, n, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        Rectangle2D.Double double_ = new Rectangle2D.Double((double)n2 * 0.0, (double)n3 * 0.0, (double)n2 * 0.5, (double)n3 * 0.5);
        Point2D.Double double_2 = new Point2D.Double(0.0, ((Rectangle2D)double_).getBounds2D().getMinY());
        Point2D.Double double_3 = new Point2D.Double(0.0, ((Rectangle2D)double_).getBounds2D().getMaxY());
        float[] fArray = new float[]{0.0f, 1.0f};
        Color[] colorArray = new Color[]{new Color(35, 35, 35, 255), new Color(23, 23, 23, 255)};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_2, double_3, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(double_);
        Rectangle2D.Double double_4 = new Rectangle2D.Double((double)n2 * 0.08333333333333333, (double)n3 * 0.0, (double)n2 * 0.3333333333333333, (double)n3 * 0.4166666666666667);
        Point2D.Double double_5 = new Point2D.Double(0.0, ((Rectangle2D)double_4).getBounds2D().getMinY());
        Point2D.Double double_6 = new Point2D.Double(0.0, ((Rectangle2D)double_4).getBounds2D().getMaxY());
        float[] fArray2 = new float[]{0.0f, 1.0f};
        Color[] colorArray2 = new Color[]{new Color(38, 38, 38, 255), new Color(30, 30, 30, 255)};
        LinearGradientPaint linearGradientPaint2 = new LinearGradientPaint(double_5, double_6, fArray2, colorArray2);
        graphics2D.setPaint(linearGradientPaint2);
        graphics2D.fill(double_4);
        Rectangle2D.Double double_7 = new Rectangle2D.Double((double)n2 * 0.5, (double)n3 * 0.5, (double)n2 * 0.5, (double)n3 * 0.5);
        Point2D.Double double_8 = new Point2D.Double(0.0, ((Rectangle2D)double_7).getBounds2D().getMinY());
        Point2D.Double double_9 = new Point2D.Double(0.0, ((Rectangle2D)double_7).getBounds2D().getMaxY());
        float[] fArray3 = new float[]{0.0f, 1.0f};
        Color[] colorArray3 = new Color[]{new Color(35, 35, 35, 255), new Color(23, 23, 23, 255)};
        LinearGradientPaint linearGradientPaint3 = new LinearGradientPaint(double_8, double_9, fArray3, colorArray3);
        graphics2D.setPaint(linearGradientPaint3);
        graphics2D.fill(double_7);
        Rectangle2D.Double double_10 = new Rectangle2D.Double((double)n2 * 0.5833333333333334, (double)n3 * 0.5, (double)n2 * 0.3333333333333333, (double)n3 * 0.4166666666666667);
        Point2D.Double double_11 = new Point2D.Double(0.0, ((Rectangle2D)double_10).getBounds2D().getMinY());
        Point2D.Double double_12 = new Point2D.Double(0.0, ((Rectangle2D)double_10).getBounds2D().getMaxY());
        float[] fArray4 = new float[]{0.0f, 1.0f};
        Color[] colorArray4 = new Color[]{new Color(38, 38, 38, 255), new Color(30, 30, 30, 255)};
        LinearGradientPaint linearGradientPaint4 = new LinearGradientPaint(double_11, double_12, fArray4, colorArray4);
        graphics2D.setPaint(linearGradientPaint4);
        graphics2D.fill(double_10);
        Rectangle2D.Double double_13 = new Rectangle2D.Double((double)n2 * 0.5, (double)n3 * 0.0, (double)n2 * 0.5, (double)n3 * 0.5);
        Point2D.Double double_14 = new Point2D.Double(0.0, ((Rectangle2D)double_13).getBounds2D().getMinY());
        Point2D.Double double_15 = new Point2D.Double(0.0, ((Rectangle2D)double_13).getBounds2D().getMaxY());
        float[] fArray5 = new float[]{0.0f, 1.0f};
        Color[] colorArray5 = new Color[]{new Color(48, 48, 48, 255), new Color(40, 40, 40, 255)};
        LinearGradientPaint linearGradientPaint5 = new LinearGradientPaint(double_14, double_15, fArray5, colorArray5);
        graphics2D.setPaint(linearGradientPaint5);
        graphics2D.fill(double_13);
        Rectangle2D.Double double_16 = new Rectangle2D.Double((double)n2 * 0.5833333333333334, (double)n3 * 0.08333333333333333, (double)n2 * 0.3333333333333333, (double)n3 * 0.4166666666666667);
        Point2D.Double double_17 = new Point2D.Double(0.0, ((Rectangle2D)double_16).getBounds2D().getMinY());
        Point2D.Double double_18 = new Point2D.Double(0.0, ((Rectangle2D)double_16).getBounds2D().getMaxY());
        float[] fArray6 = new float[]{0.0f, 1.0f};
        Color[] colorArray6 = new Color[]{new Color(53, 53, 53, 255), new Color(45, 45, 45, 255)};
        LinearGradientPaint linearGradientPaint6 = new LinearGradientPaint(double_17, double_18, fArray6, colorArray6);
        graphics2D.setPaint(linearGradientPaint6);
        graphics2D.fill(double_16);
        Rectangle2D.Double double_19 = new Rectangle2D.Double((double)n2 * 0.0, (double)n3 * 0.5, (double)n2 * 0.5, (double)n3 * 0.5);
        Point2D.Double double_20 = new Point2D.Double(0.0, ((Rectangle2D)double_19).getBounds2D().getMinY());
        Point2D.Double double_21 = new Point2D.Double(0.0, ((Rectangle2D)double_19).getBounds2D().getMaxY());
        float[] fArray7 = new float[]{0.0f, 1.0f};
        Color[] colorArray7 = new Color[]{new Color(48, 48, 48, 255), new Color(40, 40, 40, 255)};
        LinearGradientPaint linearGradientPaint7 = new LinearGradientPaint(double_20, double_21, fArray7, colorArray7);
        graphics2D.setPaint(linearGradientPaint7);
        graphics2D.fill(double_19);
        Rectangle2D.Double double_22 = new Rectangle2D.Double((double)n2 * 0.08333333333333333, (double)n3 * 0.5833333333333334, (double)n2 * 0.3333333333333333, (double)n3 * 0.4166666666666667);
        Point2D.Double double_23 = new Point2D.Double(0.0, ((Rectangle2D)double_22).getBounds2D().getMinY());
        Point2D.Double double_24 = new Point2D.Double(0.0, ((Rectangle2D)double_22).getBounds2D().getMaxY());
        float[] fArray8 = new float[]{0.0f, 1.0f};
        Color[] colorArray8 = new Color[]{new Color(53, 53, 53, 255), new Color(45, 45, 45, 255)};
        LinearGradientPaint linearGradientPaint8 = new LinearGradientPaint(double_23, double_24, fArray8, colorArray8);
        graphics2D.setPaint(linearGradientPaint8);
        graphics2D.fill(double_22);
        graphics2D.dispose();
        return bufferedImage;
    }

    public BufferedImage create_PUNCHED_SHEET_Image(int n, Color color) {
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (n <= 0) {
            return graphicsConfiguration.createCompatibleImage(1, 1, 3);
        }
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, n2, n3);
        graphics2D.setColor(color);
        graphics2D.fill(double_);
        Color color2 = color.darker().darker();
        float[] fArray = new float[]{0.0f, 1.0f};
        Color[] colorArray = new Color[]{new Color(0, 0, 0, 255), new Color(68, 68, 68, 255)};
        Ellipse2D.Double double_2 = new Ellipse2D.Double((double)n2 * 0.0, (double)n3 * 0.06666667014360428, (double)n2 * (double)0.4f, (double)n3 * (double)0.4f);
        Point2D.Double double_3 = new Point2D.Double(0.0, double_2.getBounds2D().getMinY());
        Point2D.Double double_4 = new Point2D.Double(0.0, double_2.getBounds2D().getMaxY());
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_3, double_4, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(double_2);
        Ellipse2D.Double double_5 = new Ellipse2D.Double((double)n2 * 0.0, (double)n3 * 0.0, (double)n2 * (double)0.4f, (double)n3 * (double)0.4f);
        graphics2D.setColor(color2);
        graphics2D.fill(double_5);
        Ellipse2D.Double double_6 = new Ellipse2D.Double((double)n2 * 0.46666666865348816, (double)n3 * 0.5333333611488342, (double)n2 * (double)0.4f, (double)n3 * 0.3999999761581421);
        Point2D.Double double_7 = new Point2D.Double(0.0, double_6.getBounds2D().getMinY());
        Point2D.Double double_8 = new Point2D.Double(0.0, double_6.getBounds2D().getMaxY());
        LinearGradientPaint linearGradientPaint2 = new LinearGradientPaint(double_7, double_8, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint2);
        graphics2D.fill(double_6);
        Ellipse2D.Double double_9 = new Ellipse2D.Double((double)n2 * 0.46666666865348816, (double)n3 * 0.46666666865348816, (double)n2 * (double)0.4f, (double)n3 * (double)0.4f);
        graphics2D.setColor(color2);
        graphics2D.fill(double_9);
        graphics2D.dispose();
        return bufferedImage;
    }

    public BufferedImage create_NOISE_Image(int n, int n2, Color color) {
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (n <= 0 || n2 <= 0) {
            return graphicsConfiguration.createCompatibleImage(1, 1, 3);
        }
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        Color color2 = color.darker();
        Color color3 = color.brighter();
        Random random = new Random();
        Random random2 = new Random();
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                Color color4 = random.nextBoolean() ? color3 : color2;
                int n5 = 90 + random2.nextInt(90) - 45;
                graphics2D.setColor(new Color(color4.getRed(), color4.getGreen(), color4.getBlue(), n5));
                graphics2D.drawLine(j, i, j, i);
            }
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    public BufferedImage createImage(int n, int n2, int n3) {
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (n <= 0 || n2 <= 0) {
            return graphicsConfiguration.createCompatibleImage(1, 1, n3);
        }
        return graphicsConfiguration.createCompatibleImage(n, n2, n3);
    }

    public Color setAlpha(Color color, float f) {
        if (f > 1.0f) {
            return this.setAlpha(color, 255);
        }
        if (f < 0.0f) {
            return this.setAlpha(color, 0);
        }
        return this.setAlpha(color, (int)Math.ceil(255.0f * f));
    }

    public Color setAlpha(Color color, int n) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), n);
    }

    public Color getColorFromFraction(Color color, Color color2, int n, int n2) {
        float f = (float)color.getRed() * 0.003921569f;
        float f2 = (float)color.getGreen() * 0.003921569f;
        float f3 = (float)color.getBlue() * 0.003921569f;
        float f4 = (float)color.getAlpha() * 0.003921569f;
        float f5 = (float)color2.getRed() * 0.003921569f;
        float f6 = (float)color2.getGreen() * 0.003921569f;
        float f7 = (float)color2.getBlue() * 0.003921569f;
        float f8 = (float)color2.getAlpha() * 0.003921569f;
        float f9 = f5 - f;
        float f10 = f6 - f2;
        float f11 = f7 - f3;
        float f12 = f8 - f4;
        float f13 = f9 / (float)n;
        float f14 = f10 / (float)n;
        float f15 = f11 / (float)n;
        float f16 = f12 / (float)n;
        return new Color(f + f13 * (float)n2, f2 + f14 * (float)n2, f3 + f15 * (float)n2, f4 + f16 * (float)n2);
    }

    public Color interpolateColor(Color color, Color color2, float f) {
        assert (Float.compare(f, 0.0f) >= 0 && Float.compare(f, 1.0f) <= 0);
        float f2 = (float)color.getRed() * 0.003921569f;
        float f3 = (float)color.getGreen() * 0.003921569f;
        float f4 = (float)color.getBlue() * 0.003921569f;
        float f5 = (float)color.getAlpha() * 0.003921569f;
        float f6 = (float)color2.getRed() * 0.003921569f;
        float f7 = (float)color2.getGreen() * 0.003921569f;
        float f8 = (float)color2.getBlue() * 0.003921569f;
        float f9 = (float)color2.getAlpha() * 0.003921569f;
        float f10 = f6 - f2;
        float f11 = f7 - f3;
        float f12 = f8 - f4;
        float f13 = f9 - f5;
        float f14 = f2 + f10 * f;
        float f15 = f3 + f11 * f;
        float f16 = f4 + f12 * f;
        float f17 = f5 + f13 * f;
        float f18 = f14 < 0.0f ? 0.0f : (f14 = f14 > 1.0f ? 1.0f : f14);
        float f19 = f15 < 0.0f ? 0.0f : (f15 = f15 > 1.0f ? 1.0f : f15);
        float f20 = f16 < 0.0f ? 0.0f : (f16 = f16 > 1.0f ? 1.0f : f16);
        f17 = f17 < 0.0f ? 0.0f : (f17 > 1.0f ? 1.0f : f17);
        return new Color(f14, f15, f16, f17);
    }

    public Color bilinearInterpolateColor(Color color, Color color2, Color color3, Color color4, float f, float f2) {
        Color color5 = this.interpolateColor(color, color2, f);
        Color color6 = this.interpolateColor(color3, color4, f);
        return this.interpolateColor(color5, color6, f2);
    }

    public Color setHue(Color color, float f) {
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        return Color.getHSBColor(f, fArray[1], fArray[2]);
    }

    public Color setSaturation(Color color, float f) {
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        return Color.getHSBColor(fArray[0], f, fArray[2]);
    }

    public Color setBrightness(Color color, float f) {
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        return Color.getHSBColor(fArray[0], fArray[1], f);
    }

    public Color setHueSaturation(Color color, float f, float f2) {
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        return Color.getHSBColor(f, f2, fArray[2]);
    }

    public Color setSaturationBrightness(Color color, float f, float f2) {
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        return Color.getHSBColor(fArray[0], f, f2);
    }

    public Color darker(Color color, double d) {
        int n = (int)Math.round((double)color.getRed() * (1.0 - d));
        int n2 = (int)Math.round((double)color.getGreen() * (1.0 - d));
        int n3 = (int)Math.round((double)color.getBlue() * (1.0 - d));
        int n4 = n < 0 ? 0 : (n = n > 255 ? 255 : n);
        int n5 = n2 < 0 ? 0 : (n2 = n > 255 ? 255 : n2);
        n3 = n3 < 0 ? 0 : (n3 > 255 ? 255 : n3);
        return new Color(n, n2, n3, color.getAlpha());
    }

    public Color lighter(Color color, double d) {
        int n = (int)Math.round((double)color.getRed() * (1.0 + d));
        int n2 = (int)Math.round((double)color.getGreen() * (1.0 + d));
        int n3 = (int)Math.round((double)color.getBlue() * (1.0 + d));
        int n4 = n < 0 ? 0 : (n = n > 255 ? 255 : n);
        int n5 = n2 < 0 ? 0 : (n2 = n > 255 ? 255 : n2);
        n3 = n3 < 0 ? 0 : (n3 > 255 ? 255 : n3);
        return new Color(n, n2, n3, color.getAlpha());
    }

    public double colorDistance(Color color, Color color2) {
        double d = (double)(color2.getRed() - color.getRed()) * 0.00392156862745098;
        double d2 = (double)(color2.getGreen() - color.getGreen()) * 0.00392156862745098;
        double d3 = (double)(color2.getBlue() - color.getBlue()) * 0.00392156862745098;
        return Math.sqrt(d * d + d2 * d2 + d3 * d3);
    }

    public boolean isDark(Color color) {
        double d = this.colorDistance(color, Color.WHITE);
        double d2 = this.colorDistance(color, Color.BLACK);
        return d2 < d;
    }

    public boolean isMonochrome(Color color) {
        return color.getRed() == color.getGreen() && color.getGreen() == color.getBlue();
    }

    public Font getDigitalFont() {
        if (this.digitalFont == null) {
            this.digitalFont = this.STANDARD_FONT;
        }
        return this.digitalFont.deriveFont(24).deriveFont(0);
    }

    public Font getStandardFont() {
        return this.STANDARD_FONT;
    }

    public void savePngImage(BufferedImage bufferedImage, String string) {
        try {
            ImageIO.write((RenderedImage)bufferedImage, "png", new File(string));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public double logOfBase(double d, double d2) {
        return Math.log(d2) / Math.log(d);
    }

    public LinkedList<Color> createShades(float f, Color color) {
        int n;
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        float f2 = fArray[1] / f;
        float f3 = fArray[2] / f;
        LinkedList<Color> linkedList = new LinkedList<Color>();
        for (n = 4; n > 0; --n) {
            linkedList.add(new HsbColor.Builder(color).saturation(fArray[1] - (float)n * f2).build().getColor());
        }
        linkedList.add(color);
        for (n = 4; n > 0; --n) {
            linkedList.add(new HsbColor.Builder(color).brightness(fArray[2] - (float)n * f3).build().getColor());
        }
        return linkedList;
    }

    static {
        $VALUES = new Util[]{INSTANCE};
    }
}

