package eu.hansolo.steelseries.tools;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.awt.Transparency;
import java.awt.geom.Path2D;


/**
 * @author Gerrit Grunwald <han.solo at muenster.de>
 */
public enum SymbolImageFactory {

    INSTANCE;
    private final Util UTIL = Util.INSTANCE;
    private final Shadow SHADOW = Shadow.INSTANCE;
    private int widthBuffer = 0;
    private SymbolType symbolTypeBuffer = SymbolType.HORN;
    private ColorDef symbolColorBuffer = null;
    private CustomColorDef customSymbolColorBuffer = new CustomColorDef(Color.RED);
    private BufferedImage symbolImageBuffer = UTIL.createImage(1, 1, Transparency.TRANSLUCENT);
    private BufferedImage clipImageSymbol = UTIL.createImage(1, 1, Transparency.TRANSLUCENT);

    /**
     * Creates the symbol image for an indicator gauge.
     * The image parameters and the image will be cached. If the
     * current request has the same parameters as the last request
     * it will return the already created image instead of creating
     * a new image.
     * @param WIDTH
     * @param SYMBOL_TYPE
     * @param SYMBOL_COLOR
     * @param CUSTOM_SYMBOL_COLOR
     * @param GLOW
     * @return a buffered image that contains the symbol image for an indicator gauge
     */
    public BufferedImage createSymbol(final int WIDTH, final SymbolType SYMBOL_TYPE, final ColorDef SYMBOL_COLOR, final CustomColorDef CUSTOM_SYMBOL_COLOR, final boolean GLOW) {
        if (WIDTH <= 0) {
            return UTIL.createImage(1, 1, Transparency.TRANSLUCENT);
        }

        if (widthBuffer == WIDTH && symbolTypeBuffer == SYMBOL_TYPE && symbolColorBuffer == SYMBOL_COLOR && customSymbolColorBuffer == CUSTOM_SYMBOL_COLOR) {
            return symbolImageBuffer;
        }

        symbolImageBuffer.flush();
        symbolImageBuffer = UTIL.createImage(WIDTH, WIDTH, Transparency.TRANSLUCENT);
        final Graphics2D G2 = symbolImageBuffer.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        //G2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        //G2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        //G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        final int IMAGE_WIDTH = symbolImageBuffer.getWidth();
        final int IMAGE_HEIGHT = symbolImageBuffer.getHeight();

        final GeneralPath SYMBOL;

        switch (SYMBOL_TYPE) {
            case FUEL:
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(Path2D.WIND_EVEN_ODD);
                SYMBOL.moveTo(IMAGE_WIDTH * 0.37383177570093457, IMAGE_HEIGHT * 0.32242990654205606);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.37383177570093457, IMAGE_HEIGHT * 0.3130841121495327, IMAGE_WIDTH * 0.37850467289719625, IMAGE_HEIGHT * 0.3037383177570093, IMAGE_WIDTH * 0.3925233644859813, IMAGE_HEIGHT * 0.3037383177570093);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.3925233644859813, IMAGE_HEIGHT * 0.3037383177570093, IMAGE_WIDTH * 0.5327102803738317, IMAGE_HEIGHT * 0.3037383177570093, IMAGE_WIDTH * 0.5327102803738317, IMAGE_HEIGHT * 0.3037383177570093);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5467289719626168, IMAGE_HEIGHT * 0.3037383177570093, IMAGE_WIDTH * 0.5514018691588785, IMAGE_HEIGHT * 0.3130841121495327, IMAGE_WIDTH * 0.5514018691588785, IMAGE_HEIGHT * 0.32242990654205606);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5514018691588785, IMAGE_HEIGHT * 0.32242990654205606, IMAGE_WIDTH * 0.5514018691588785, IMAGE_HEIGHT * 0.4392523364485981, IMAGE_WIDTH * 0.5514018691588785, IMAGE_HEIGHT * 0.4392523364485981);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5514018691588785, IMAGE_HEIGHT * 0.4532710280373832, IMAGE_WIDTH * 0.5467289719626168, IMAGE_HEIGHT * 0.46261682242990654, IMAGE_WIDTH * 0.5327102803738317, IMAGE_HEIGHT * 0.46261682242990654);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5327102803738317, IMAGE_HEIGHT * 0.46261682242990654, IMAGE_WIDTH * 0.3925233644859813, IMAGE_HEIGHT * 0.46261682242990654, IMAGE_WIDTH * 0.3925233644859813, IMAGE_HEIGHT * 0.46261682242990654);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.37850467289719625, IMAGE_HEIGHT * 0.46261682242990654, IMAGE_WIDTH * 0.37383177570093457, IMAGE_HEIGHT * 0.4532710280373832, IMAGE_WIDTH * 0.37383177570093457, IMAGE_HEIGHT * 0.4392523364485981);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.37383177570093457, IMAGE_HEIGHT * 0.4392523364485981, IMAGE_WIDTH * 0.37383177570093457, IMAGE_HEIGHT * 0.32242990654205606, IMAGE_WIDTH * 0.37383177570093457, IMAGE_HEIGHT * 0.32242990654205606);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.3364485981308411, IMAGE_HEIGHT * 0.3037383177570093);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.3364485981308411, IMAGE_HEIGHT * 0.3037383177570093, IMAGE_WIDTH * 0.3364485981308411, IMAGE_HEIGHT * 0.6869158878504673, IMAGE_WIDTH * 0.3364485981308411, IMAGE_HEIGHT * 0.6869158878504673);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.3364485981308411, IMAGE_HEIGHT * 0.6869158878504673, IMAGE_WIDTH * 0.32710280373831774, IMAGE_HEIGHT * 0.6869158878504673, IMAGE_WIDTH * 0.32710280373831774, IMAGE_HEIGHT * 0.6869158878504673);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.3130841121495327, IMAGE_HEIGHT * 0.6869158878504673, IMAGE_WIDTH * 0.3037383177570093, IMAGE_HEIGHT * 0.7009345794392523, IMAGE_WIDTH * 0.3037383177570093, IMAGE_HEIGHT * 0.7102803738317757);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.3037383177570093, IMAGE_HEIGHT * 0.7102803738317757, IMAGE_WIDTH * 0.3037383177570093, IMAGE_HEIGHT * 0.7383177570093458, IMAGE_WIDTH * 0.3037383177570093, IMAGE_HEIGHT * 0.7383177570093458);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.3364485981308411, IMAGE_HEIGHT * 0.7383177570093458);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.7383177570093458);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.6214953271028038, IMAGE_HEIGHT * 0.7383177570093458);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6214953271028038, IMAGE_HEIGHT * 0.7383177570093458, IMAGE_WIDTH * 0.6214953271028038, IMAGE_HEIGHT * 0.7102803738317757, IMAGE_WIDTH * 0.6214953271028038, IMAGE_HEIGHT * 0.7102803738317757);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6214953271028038, IMAGE_HEIGHT * 0.7009345794392523, IMAGE_WIDTH * 0.6121495327102804, IMAGE_HEIGHT * 0.6869158878504673, IMAGE_WIDTH * 0.5981308411214953, IMAGE_HEIGHT * 0.6869158878504673);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5981308411214953, IMAGE_HEIGHT * 0.6869158878504673, IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.6869158878504673, IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.6869158878504673);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.6869158878504673, IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.5420560747663551, IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5934579439252337, IMAGE_HEIGHT * 0.5467289719626168, IMAGE_WIDTH * 0.602803738317757, IMAGE_HEIGHT * 0.5467289719626168, IMAGE_WIDTH * 0.6121495327102804, IMAGE_HEIGHT * 0.5514018691588785);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.616822429906542, IMAGE_HEIGHT * 0.5560747663551402, IMAGE_WIDTH * 0.6308411214953271, IMAGE_HEIGHT * 0.5654205607476636, IMAGE_WIDTH * 0.6355140186915887, IMAGE_HEIGHT * 0.602803738317757);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6355140186915887, IMAGE_HEIGHT * 0.6261682242990654, IMAGE_WIDTH * 0.6308411214953271, IMAGE_HEIGHT * 0.6588785046728972, IMAGE_WIDTH * 0.6401869158878505, IMAGE_HEIGHT * 0.6822429906542056);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6495327102803738, IMAGE_HEIGHT * 0.6962616822429907, IMAGE_WIDTH * 0.6728971962616822, IMAGE_HEIGHT * 0.7102803738317757, IMAGE_WIDTH * 0.6915887850467289, IMAGE_HEIGHT * 0.7102803738317757);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.7242990654205608, IMAGE_HEIGHT * 0.7102803738317757, IMAGE_WIDTH * 0.7383177570093458, IMAGE_HEIGHT * 0.6915887850467289, IMAGE_WIDTH * 0.7476635514018691, IMAGE_HEIGHT * 0.6822429906542056);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.7523364485981309, IMAGE_HEIGHT * 0.6635514018691588, IMAGE_WIDTH * 0.7523364485981309, IMAGE_HEIGHT * 0.6495327102803738, IMAGE_WIDTH * 0.7523364485981309, IMAGE_HEIGHT * 0.6401869158878505);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.7476635514018691, IMAGE_HEIGHT * 0.6214953271028038, IMAGE_WIDTH * 0.7429906542056075, IMAGE_HEIGHT * 0.5981308411214953, IMAGE_WIDTH * 0.7336448598130841, IMAGE_HEIGHT * 0.5747663551401869);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.7289719626168224, IMAGE_HEIGHT * 0.5607476635514018, IMAGE_WIDTH * 0.719626168224299, IMAGE_HEIGHT * 0.5327102803738317, IMAGE_WIDTH * 0.7149532710280374, IMAGE_HEIGHT * 0.5233644859813084);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.7102803738317757, IMAGE_HEIGHT * 0.514018691588785, IMAGE_WIDTH * 0.705607476635514, IMAGE_HEIGHT * 0.4953271028037383, IMAGE_WIDTH * 0.705607476635514, IMAGE_HEIGHT * 0.48130841121495327);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.705607476635514, IMAGE_HEIGHT * 0.4532710280373832, IMAGE_WIDTH * 0.7149532710280374, IMAGE_HEIGHT * 0.4205607476635514, IMAGE_WIDTH * 0.7149532710280374, IMAGE_HEIGHT * 0.4205607476635514);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.7289719626168224, IMAGE_HEIGHT * 0.3878504672897196);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.7289719626168224, IMAGE_HEIGHT * 0.3878504672897196, IMAGE_WIDTH * 0.7429906542056075, IMAGE_HEIGHT * 0.3878504672897196, IMAGE_WIDTH * 0.7476635514018691, IMAGE_HEIGHT * 0.38317757009345793);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.7570093457943925, IMAGE_HEIGHT * 0.3691588785046729, IMAGE_WIDTH * 0.7523364485981309, IMAGE_HEIGHT * 0.3598130841121495, IMAGE_WIDTH * 0.7523364485981309, IMAGE_HEIGHT * 0.35046728971962615);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.7476635514018691, IMAGE_HEIGHT * 0.3364485981308411, IMAGE_WIDTH * 0.7242990654205608, IMAGE_HEIGHT * 0.308411214953271, IMAGE_WIDTH * 0.7149532710280374, IMAGE_HEIGHT * 0.3037383177570093);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6962616822429907, IMAGE_HEIGHT * 0.2850467289719626, IMAGE_WIDTH * 0.6448598130841121, IMAGE_HEIGHT * 0.27102803738317754, IMAGE_WIDTH * 0.6448598130841121, IMAGE_HEIGHT * 0.27102803738317754);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.6401869158878505, IMAGE_HEIGHT * 0.2897196261682243);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6401869158878505, IMAGE_HEIGHT * 0.2897196261682243, IMAGE_WIDTH * 0.6542056074766355, IMAGE_HEIGHT * 0.29439252336448596, IMAGE_WIDTH * 0.6682242990654206, IMAGE_HEIGHT * 0.3037383177570093);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6915887850467289, IMAGE_HEIGHT * 0.3177570093457944, IMAGE_WIDTH * 0.705607476635514, IMAGE_HEIGHT * 0.3364485981308411, IMAGE_WIDTH * 0.705607476635514, IMAGE_HEIGHT * 0.3411214953271028);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.7102803738317757, IMAGE_HEIGHT * 0.35046728971962615, IMAGE_WIDTH * 0.7102803738317757, IMAGE_HEIGHT * 0.3598130841121495, IMAGE_WIDTH * 0.705607476635514, IMAGE_HEIGHT * 0.3691588785046729);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.7009345794392523, IMAGE_HEIGHT * 0.38317757009345793, IMAGE_WIDTH * 0.6915887850467289, IMAGE_HEIGHT * 0.40186915887850466, IMAGE_WIDTH * 0.6915887850467289, IMAGE_HEIGHT * 0.40186915887850466);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6915887850467289, IMAGE_HEIGHT * 0.40186915887850466, IMAGE_WIDTH * 0.6822429906542056, IMAGE_HEIGHT * 0.4252336448598131, IMAGE_WIDTH * 0.6822429906542056, IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6822429906542056, IMAGE_HEIGHT * 0.48598130841121495, IMAGE_WIDTH * 0.6822429906542056, IMAGE_HEIGHT * 0.514018691588785, IMAGE_WIDTH * 0.705607476635514, IMAGE_HEIGHT * 0.5654205607476636);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.7149532710280374, IMAGE_HEIGHT * 0.5887850467289719, IMAGE_WIDTH * 0.719626168224299, IMAGE_HEIGHT * 0.602803738317757, IMAGE_WIDTH * 0.7289719626168224, IMAGE_HEIGHT * 0.6542056074766355);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.7289719626168224, IMAGE_HEIGHT * 0.6635514018691588, IMAGE_WIDTH * 0.7289719626168224, IMAGE_HEIGHT * 0.6869158878504673, IMAGE_WIDTH * 0.6915887850467289, IMAGE_HEIGHT * 0.6869158878504673);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6682242990654206, IMAGE_HEIGHT * 0.6869158878504673, IMAGE_WIDTH * 0.6635514018691588, IMAGE_HEIGHT * 0.6495327102803738, IMAGE_WIDTH * 0.6635514018691588, IMAGE_HEIGHT * 0.6495327102803738);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6635514018691588, IMAGE_HEIGHT * 0.6495327102803738, IMAGE_WIDTH * 0.6542056074766355, IMAGE_HEIGHT * 0.6308411214953271, IMAGE_WIDTH * 0.6588785046728972, IMAGE_HEIGHT * 0.5934579439252337);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6542056074766355, IMAGE_HEIGHT * 0.5747663551401869, IMAGE_WIDTH * 0.6495327102803738, IMAGE_HEIGHT * 0.5607476635514018, IMAGE_WIDTH * 0.6355140186915887, IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6308411214953271, IMAGE_HEIGHT * 0.5327102803738317, IMAGE_WIDTH * 0.6121495327102804, IMAGE_HEIGHT * 0.5233644859813084, IMAGE_WIDTH * 0.5981308411214953, IMAGE_HEIGHT * 0.5186915887850467);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5934579439252337, IMAGE_HEIGHT * 0.5186915887850467, IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.5186915887850467, IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.5186915887850467);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.5186915887850467, IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.3037383177570093, IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.3037383177570093);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.2850467289719626, IMAGE_WIDTH * 0.5700934579439252, IMAGE_HEIGHT * 0.27102803738317754, IMAGE_WIDTH * 0.5514018691588785, IMAGE_HEIGHT * 0.27102803738317754);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5514018691588785, IMAGE_HEIGHT * 0.27102803738317754, IMAGE_WIDTH * 0.37383177570093457, IMAGE_HEIGHT * 0.27102803738317754, IMAGE_WIDTH * 0.37383177570093457, IMAGE_HEIGHT * 0.27102803738317754);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.35514018691588783, IMAGE_HEIGHT * 0.27102803738317754, IMAGE_WIDTH * 0.3364485981308411, IMAGE_HEIGHT * 0.2850467289719626, IMAGE_WIDTH * 0.3364485981308411, IMAGE_HEIGHT * 0.3037383177570093);
                SYMBOL.closePath();
                break;

            case ENGINE:
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(Path2D.WIND_EVEN_ODD);
                SYMBOL.moveTo(IMAGE_WIDTH * 0.32710280373831774, IMAGE_HEIGHT * 0.397196261682243);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.38317757009345793, IMAGE_HEIGHT * 0.3691588785046729);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.5, IMAGE_HEIGHT * 0.3691588785046729);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.5, IMAGE_HEIGHT * 0.35514018691588783);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.4252336448598131, IMAGE_HEIGHT * 0.35514018691588783);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.4252336448598131, IMAGE_HEIGHT * 0.32710280373831774);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.602803738317757, IMAGE_HEIGHT * 0.32710280373831774);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.602803738317757, IMAGE_HEIGHT * 0.35514018691588783);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.5280373831775701, IMAGE_HEIGHT * 0.35514018691588783);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.5280373831775701, IMAGE_HEIGHT * 0.3691588785046729);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.616822429906542, IMAGE_HEIGHT * 0.3691588785046729);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.6308411214953271, IMAGE_HEIGHT * 0.397196261682243);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.6588785046728972, IMAGE_HEIGHT * 0.397196261682243);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.6588785046728972, IMAGE_HEIGHT * 0.4439252336448598);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.705607476635514, IMAGE_HEIGHT * 0.4439252336448598);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.705607476635514, IMAGE_HEIGHT * 0.397196261682243);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.7336448598130841, IMAGE_HEIGHT * 0.397196261682243);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.7336448598130841, IMAGE_HEIGHT * 0.6308411214953271);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.705607476635514, IMAGE_HEIGHT * 0.6308411214953271);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.705607476635514, IMAGE_HEIGHT * 0.5887850467289719);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.6588785046728972, IMAGE_HEIGHT * 0.5887850467289719);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.6588785046728972, IMAGE_HEIGHT * 0.677570093457944);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.4252336448598131, IMAGE_HEIGHT * 0.677570093457944);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.3691588785046729, IMAGE_HEIGHT * 0.6308411214953271);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.32710280373831774, IMAGE_HEIGHT * 0.6308411214953271);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.32710280373831774, IMAGE_HEIGHT * 0.5280373831775701);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.29439252336448596, IMAGE_HEIGHT * 0.5280373831775701);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.29439252336448596, IMAGE_HEIGHT * 0.602803738317757);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.26635514018691586, IMAGE_HEIGHT * 0.5841121495327103);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.26635514018691586, IMAGE_HEIGHT * 0.4439252336448598);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.29439252336448596, IMAGE_HEIGHT * 0.4252336448598131);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.29439252336448596, IMAGE_HEIGHT * 0.514018691588785);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.32710280373831774, IMAGE_HEIGHT * 0.514018691588785);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.32710280373831774, IMAGE_HEIGHT * 0.397196261682243);
                SYMBOL.closePath();
                break;

            case OIL:
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(Path2D.WIND_EVEN_ODD);
                SYMBOL.moveTo(IMAGE_WIDTH * 0.7149532710280374, IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.7149532710280374, IMAGE_HEIGHT * 0.5046728971962616, IMAGE_WIDTH * 0.7009345794392523, IMAGE_HEIGHT * 0.5280373831775701, IMAGE_WIDTH * 0.6962616822429907, IMAGE_HEIGHT * 0.5514018691588785);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6962616822429907, IMAGE_HEIGHT * 0.5607476635514018, IMAGE_WIDTH * 0.7009345794392523, IMAGE_HEIGHT * 0.5747663551401869, IMAGE_WIDTH * 0.7149532710280374, IMAGE_HEIGHT * 0.5747663551401869);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.7336448598130841, IMAGE_HEIGHT * 0.5747663551401869, IMAGE_WIDTH * 0.7383177570093458, IMAGE_HEIGHT * 0.5607476635514018, IMAGE_WIDTH * 0.7336448598130841, IMAGE_HEIGHT * 0.5467289719626168);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.7289719626168224, IMAGE_HEIGHT * 0.5233644859813084, IMAGE_WIDTH * 0.7149532710280374, IMAGE_HEIGHT * 0.5046728971962616, IMAGE_WIDTH * 0.7149532710280374, IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.3130841121495327, IMAGE_HEIGHT * 0.4439252336448598);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.32710280373831774, IMAGE_HEIGHT * 0.42990654205607476);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.3130841121495327, IMAGE_HEIGHT * 0.4205607476635514);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.26635514018691586, IMAGE_HEIGHT * 0.4672897196261682);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.2803738317757009, IMAGE_HEIGHT * 0.48130841121495327);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.29906542056074764, IMAGE_HEIGHT * 0.45794392523364486);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.32242990654205606, IMAGE_HEIGHT * 0.48130841121495327);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.32242990654205606, IMAGE_HEIGHT * 0.5887850467289719);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.3317757009345794, IMAGE_HEIGHT * 0.5981308411214953);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.5654205607476636, IMAGE_HEIGHT * 0.5981308411214953);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5654205607476636, IMAGE_HEIGHT * 0.5981308411214953, IMAGE_WIDTH * 0.6261682242990654, IMAGE_HEIGHT * 0.46261682242990654, IMAGE_WIDTH * 0.6682242990654206, IMAGE_HEIGHT * 0.45794392523364486);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6915887850467289, IMAGE_HEIGHT * 0.45794392523364486, IMAGE_WIDTH * 0.705607476635514, IMAGE_HEIGHT * 0.48130841121495327, IMAGE_WIDTH * 0.705607476635514, IMAGE_HEIGHT * 0.48130841121495327);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.705607476635514, IMAGE_HEIGHT * 0.48130841121495327, IMAGE_WIDTH * 0.7149532710280374, IMAGE_HEIGHT * 0.48130841121495327, IMAGE_WIDTH * 0.719626168224299, IMAGE_HEIGHT * 0.4766355140186916);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.7289719626168224, IMAGE_HEIGHT * 0.4719626168224299, IMAGE_WIDTH * 0.7242990654205608, IMAGE_HEIGHT * 0.46261682242990654, IMAGE_WIDTH * 0.7242990654205608, IMAGE_HEIGHT * 0.46261682242990654);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.7242990654205608, IMAGE_HEIGHT * 0.46261682242990654, IMAGE_WIDTH * 0.7009345794392523, IMAGE_HEIGHT * 0.4205607476635514, IMAGE_WIDTH * 0.6728971962616822, IMAGE_HEIGHT * 0.4205607476635514);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5934579439252337, IMAGE_HEIGHT * 0.4205607476635514, IMAGE_WIDTH * 0.5560747663551402, IMAGE_HEIGHT * 0.4953271028037383, IMAGE_WIDTH * 0.5233644859813084, IMAGE_HEIGHT * 0.5);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5093457943925234, IMAGE_HEIGHT * 0.5, IMAGE_WIDTH * 0.48598130841121495, IMAGE_HEIGHT * 0.46261682242990654, IMAGE_WIDTH * 0.48598130841121495, IMAGE_HEIGHT * 0.46261682242990654);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.411214953271028, IMAGE_HEIGHT * 0.46261682242990654);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.411214953271028, IMAGE_HEIGHT * 0.4205607476635514);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.4392523364485981, IMAGE_HEIGHT * 0.4205607476635514);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.42990654205607476, IMAGE_HEIGHT * 0.411214953271028);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.37850467289719625, IMAGE_HEIGHT * 0.411214953271028);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.3644859813084112, IMAGE_HEIGHT * 0.4205607476635514);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.397196261682243, IMAGE_HEIGHT * 0.4205607476635514);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.397196261682243, IMAGE_HEIGHT * 0.46261682242990654);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.3317757009345794, IMAGE_HEIGHT * 0.46261682242990654);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.3130841121495327, IMAGE_HEIGHT * 0.4439252336448598);
                SYMBOL.closePath();
                break;

            case FULL_BEAM:
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(Path2D.WIND_EVEN_ODD);
                SYMBOL.moveTo(IMAGE_WIDTH * 0.26635514018691586, IMAGE_HEIGHT * 0.4392523364485981);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.26635514018691586, IMAGE_HEIGHT * 0.4532710280373832, IMAGE_WIDTH * 0.2850467289719626, IMAGE_HEIGHT * 0.4532710280373832, IMAGE_WIDTH * 0.2850467289719626, IMAGE_HEIGHT * 0.4532710280373832);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.2850467289719626, IMAGE_HEIGHT * 0.4532710280373832, IMAGE_WIDTH * 0.40654205607476634, IMAGE_HEIGHT * 0.4532710280373832, IMAGE_WIDTH * 0.40654205607476634, IMAGE_HEIGHT * 0.4532710280373832);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.40654205607476634, IMAGE_HEIGHT * 0.43457943925233644, IMAGE_WIDTH * 0.411214953271028, IMAGE_HEIGHT * 0.4252336448598131, IMAGE_WIDTH * 0.411214953271028, IMAGE_HEIGHT * 0.4252336448598131);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.2850467289719626, IMAGE_HEIGHT * 0.4252336448598131);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.2850467289719626, IMAGE_HEIGHT * 0.4252336448598131, IMAGE_WIDTH * 0.27102803738317754, IMAGE_HEIGHT * 0.4252336448598131, IMAGE_WIDTH * 0.26635514018691586, IMAGE_HEIGHT * 0.4392523364485981);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.26635514018691586, IMAGE_HEIGHT * 0.5560747663551402);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.27102803738317754, IMAGE_HEIGHT * 0.5700934579439252, IMAGE_WIDTH * 0.2850467289719626, IMAGE_HEIGHT * 0.5700934579439252, IMAGE_WIDTH * 0.2850467289719626, IMAGE_HEIGHT * 0.5700934579439252);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.411214953271028, IMAGE_HEIGHT * 0.5700934579439252);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.411214953271028, IMAGE_HEIGHT * 0.5700934579439252, IMAGE_WIDTH * 0.40654205607476634, IMAGE_HEIGHT * 0.5607476635514018, IMAGE_WIDTH * 0.40654205607476634, IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.40654205607476634, IMAGE_HEIGHT * 0.5420560747663551, IMAGE_WIDTH * 0.2850467289719626, IMAGE_HEIGHT * 0.5420560747663551, IMAGE_WIDTH * 0.2850467289719626, IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.2850467289719626, IMAGE_HEIGHT * 0.5420560747663551, IMAGE_WIDTH * 0.26635514018691586, IMAGE_HEIGHT * 0.5420560747663551, IMAGE_WIDTH * 0.26635514018691586, IMAGE_HEIGHT * 0.5560747663551402);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.26635514018691586, IMAGE_HEIGHT * 0.4953271028037383);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.26635514018691586, IMAGE_HEIGHT * 0.514018691588785, IMAGE_WIDTH * 0.2850467289719626, IMAGE_HEIGHT * 0.514018691588785, IMAGE_WIDTH * 0.2850467289719626, IMAGE_HEIGHT * 0.514018691588785);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.40654205607476634, IMAGE_HEIGHT * 0.514018691588785);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.40654205607476634, IMAGE_HEIGHT * 0.48130841121495327);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.2850467289719626, IMAGE_HEIGHT * 0.48130841121495327);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.2850467289719626, IMAGE_HEIGHT * 0.48130841121495327, IMAGE_WIDTH * 0.27102803738317754, IMAGE_HEIGHT * 0.48130841121495327, IMAGE_WIDTH * 0.26635514018691586, IMAGE_HEIGHT * 0.4953271028037383);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.27102803738317754, IMAGE_HEIGHT * 0.3691588785046729);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.27102803738317754, IMAGE_HEIGHT * 0.38317757009345793, IMAGE_WIDTH * 0.2850467289719626, IMAGE_HEIGHT * 0.38317757009345793, IMAGE_WIDTH * 0.2850467289719626, IMAGE_HEIGHT * 0.38317757009345793);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.2850467289719626, IMAGE_HEIGHT * 0.38317757009345793, IMAGE_WIDTH * 0.42990654205607476, IMAGE_HEIGHT * 0.38317757009345793, IMAGE_WIDTH * 0.42990654205607476, IMAGE_HEIGHT * 0.38317757009345793);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4485981308411215, IMAGE_HEIGHT * 0.3598130841121495, IMAGE_WIDTH * 0.4672897196261682, IMAGE_HEIGHT * 0.35514018691588783, IMAGE_WIDTH * 0.4672897196261682, IMAGE_HEIGHT * 0.35514018691588783);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.2850467289719626, IMAGE_HEIGHT * 0.35514018691588783);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.2850467289719626, IMAGE_HEIGHT * 0.35514018691588783, IMAGE_WIDTH * 0.27102803738317754, IMAGE_HEIGHT * 0.35514018691588783, IMAGE_WIDTH * 0.27102803738317754, IMAGE_HEIGHT * 0.3691588785046729);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.27102803738317754, IMAGE_HEIGHT * 0.6261682242990654);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.27102803738317754, IMAGE_HEIGHT * 0.6401869158878505, IMAGE_WIDTH * 0.2850467289719626, IMAGE_HEIGHT * 0.6401869158878505, IMAGE_WIDTH * 0.2850467289719626, IMAGE_HEIGHT * 0.6401869158878505);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.4672897196261682, IMAGE_HEIGHT * 0.6401869158878505);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4672897196261682, IMAGE_HEIGHT * 0.6401869158878505, IMAGE_WIDTH * 0.4485981308411215, IMAGE_HEIGHT * 0.6355140186915887, IMAGE_WIDTH * 0.42990654205607476, IMAGE_HEIGHT * 0.6121495327102804);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.42990654205607476, IMAGE_HEIGHT * 0.6121495327102804, IMAGE_WIDTH * 0.2850467289719626, IMAGE_HEIGHT * 0.6121495327102804, IMAGE_WIDTH * 0.2850467289719626, IMAGE_HEIGHT * 0.6121495327102804);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.2850467289719626, IMAGE_HEIGHT * 0.6121495327102804, IMAGE_WIDTH * 0.27102803738317754, IMAGE_HEIGHT * 0.6121495327102804, IMAGE_WIDTH * 0.27102803738317754, IMAGE_HEIGHT * 0.6261682242990654);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.5467289719626168, IMAGE_HEIGHT * 0.38317757009345793);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5934579439252337, IMAGE_HEIGHT * 0.38317757009345793, IMAGE_WIDTH * 0.705607476635514, IMAGE_HEIGHT * 0.4252336448598131, IMAGE_WIDTH * 0.705607476635514, IMAGE_HEIGHT * 0.4953271028037383);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.705607476635514, IMAGE_HEIGHT * 0.5747663551401869, IMAGE_WIDTH * 0.5934579439252337, IMAGE_HEIGHT * 0.6121495327102804, IMAGE_WIDTH * 0.5467289719626168, IMAGE_HEIGHT * 0.6121495327102804);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5327102803738317, IMAGE_HEIGHT * 0.6121495327102804, IMAGE_WIDTH * 0.4766355140186916, IMAGE_HEIGHT * 0.6121495327102804, IMAGE_WIDTH * 0.4766355140186916, IMAGE_HEIGHT * 0.5);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4766355140186916, IMAGE_HEIGHT * 0.3878504672897196, IMAGE_WIDTH * 0.5327102803738317, IMAGE_HEIGHT * 0.38317757009345793, IMAGE_WIDTH * 0.5467289719626168, IMAGE_HEIGHT * 0.38317757009345793);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.5373831775700935, IMAGE_HEIGHT * 0.35514018691588783);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5186915887850467, IMAGE_HEIGHT * 0.35514018691588783, IMAGE_WIDTH * 0.4439252336448598, IMAGE_HEIGHT * 0.3598130841121495, IMAGE_WIDTH * 0.4439252336448598, IMAGE_HEIGHT * 0.5);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4439252336448598, IMAGE_HEIGHT * 0.6448598130841121, IMAGE_WIDTH * 0.5186915887850467, IMAGE_HEIGHT * 0.6401869158878505, IMAGE_WIDTH * 0.5373831775700935, IMAGE_HEIGHT * 0.6401869158878505);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5981308411214953, IMAGE_HEIGHT * 0.6401869158878505, IMAGE_WIDTH * 0.7336448598130841, IMAGE_HEIGHT * 0.5934579439252337, IMAGE_WIDTH * 0.7336448598130841, IMAGE_HEIGHT * 0.4953271028037383);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.7336448598130841, IMAGE_HEIGHT * 0.40654205607476634, IMAGE_WIDTH * 0.5981308411214953, IMAGE_HEIGHT * 0.35514018691588783, IMAGE_WIDTH * 0.5373831775700935, IMAGE_HEIGHT * 0.35514018691588783);
                SYMBOL.closePath();
                break;

            case LOW_BEAM:
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(Path2D.WIND_EVEN_ODD);
                SYMBOL.moveTo(IMAGE_WIDTH * 0.26635514018691586, IMAGE_HEIGHT * 0.4953271028037383);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.26635514018691586, IMAGE_HEIGHT * 0.514018691588785, IMAGE_WIDTH * 0.2850467289719626, IMAGE_HEIGHT * 0.5093457943925234, IMAGE_WIDTH * 0.2850467289719626, IMAGE_HEIGHT * 0.5093457943925234);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.2850467289719626, IMAGE_HEIGHT * 0.5093457943925234, IMAGE_WIDTH * 0.40654205607476634, IMAGE_HEIGHT * 0.4719626168224299, IMAGE_WIDTH * 0.40654205607476634, IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.40654205607476634, IMAGE_HEIGHT * 0.4532710280373832, IMAGE_WIDTH * 0.411214953271028, IMAGE_HEIGHT * 0.4392523364485981, IMAGE_WIDTH * 0.411214953271028, IMAGE_HEIGHT * 0.4392523364485981);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.2850467289719626, IMAGE_HEIGHT * 0.4766355140186916);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.2850467289719626, IMAGE_HEIGHT * 0.4766355140186916, IMAGE_WIDTH * 0.27102803738317754, IMAGE_HEIGHT * 0.48130841121495327, IMAGE_WIDTH * 0.26635514018691586, IMAGE_HEIGHT * 0.4953271028037383);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.26635514018691586, IMAGE_HEIGHT * 0.616822429906542);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.27102803738317754, IMAGE_HEIGHT * 0.6308411214953271, IMAGE_WIDTH * 0.2850467289719626, IMAGE_HEIGHT * 0.6261682242990654, IMAGE_WIDTH * 0.2850467289719626, IMAGE_HEIGHT * 0.6261682242990654);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.411214953271028, IMAGE_HEIGHT * 0.5887850467289719);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.411214953271028, IMAGE_HEIGHT * 0.5887850467289719, IMAGE_WIDTH * 0.40654205607476634, IMAGE_HEIGHT * 0.5794392523364486, IMAGE_WIDTH * 0.40654205607476634, IMAGE_HEIGHT * 0.5607476635514018);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.40654205607476634, IMAGE_HEIGHT * 0.5607476635514018, IMAGE_WIDTH * 0.2850467289719626, IMAGE_HEIGHT * 0.5981308411214953, IMAGE_WIDTH * 0.2850467289719626, IMAGE_HEIGHT * 0.5981308411214953);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.2850467289719626, IMAGE_HEIGHT * 0.5981308411214953, IMAGE_WIDTH * 0.26635514018691586, IMAGE_HEIGHT * 0.602803738317757, IMAGE_WIDTH * 0.26635514018691586, IMAGE_HEIGHT * 0.616822429906542);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.26635514018691586, IMAGE_HEIGHT * 0.5560747663551402);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.26635514018691586, IMAGE_HEIGHT * 0.5700934579439252, IMAGE_WIDTH * 0.2850467289719626, IMAGE_HEIGHT * 0.5654205607476636, IMAGE_WIDTH * 0.2850467289719626, IMAGE_HEIGHT * 0.5654205607476636);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.40654205607476634, IMAGE_HEIGHT * 0.5280373831775701);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.40654205607476634, IMAGE_HEIGHT * 0.5);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.2850467289719626, IMAGE_HEIGHT * 0.5373831775700935);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.2850467289719626, IMAGE_HEIGHT * 0.5373831775700935, IMAGE_WIDTH * 0.27102803738317754, IMAGE_HEIGHT * 0.5420560747663551, IMAGE_WIDTH * 0.26635514018691586, IMAGE_HEIGHT * 0.5560747663551402);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.27102803738317754, IMAGE_HEIGHT * 0.42990654205607476);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.27102803738317754, IMAGE_HEIGHT * 0.4439252336448598, IMAGE_WIDTH * 0.2850467289719626, IMAGE_HEIGHT * 0.4392523364485981, IMAGE_WIDTH * 0.2850467289719626, IMAGE_HEIGHT * 0.4392523364485981);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.2850467289719626, IMAGE_HEIGHT * 0.4392523364485981, IMAGE_WIDTH * 0.42990654205607476, IMAGE_HEIGHT * 0.3925233644859813, IMAGE_WIDTH * 0.42990654205607476, IMAGE_HEIGHT * 0.3925233644859813);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4485981308411215, IMAGE_HEIGHT * 0.3644859813084112, IMAGE_WIDTH * 0.4672897196261682, IMAGE_HEIGHT * 0.35514018691588783, IMAGE_WIDTH * 0.4672897196261682, IMAGE_HEIGHT * 0.35514018691588783);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.2850467289719626, IMAGE_HEIGHT * 0.40654205607476634);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.2850467289719626, IMAGE_HEIGHT * 0.40654205607476634, IMAGE_WIDTH * 0.27102803738317754, IMAGE_HEIGHT * 0.411214953271028, IMAGE_WIDTH * 0.27102803738317754, IMAGE_HEIGHT * 0.42990654205607476);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.27102803738317754, IMAGE_HEIGHT * 0.6822429906542056);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.27102803738317754, IMAGE_HEIGHT * 0.7009345794392523, IMAGE_WIDTH * 0.2850467289719626, IMAGE_HEIGHT * 0.6962616822429907, IMAGE_WIDTH * 0.2850467289719626, IMAGE_HEIGHT * 0.6962616822429907);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.4672897196261682, IMAGE_HEIGHT * 0.6401869158878505);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4672897196261682, IMAGE_HEIGHT * 0.6401869158878505, IMAGE_WIDTH * 0.4485981308411215, IMAGE_HEIGHT * 0.6401869158878505, IMAGE_WIDTH * 0.42990654205607476, IMAGE_HEIGHT * 0.6214953271028038);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.42990654205607476, IMAGE_HEIGHT * 0.6214953271028038, IMAGE_WIDTH * 0.2850467289719626, IMAGE_HEIGHT * 0.6682242990654206, IMAGE_WIDTH * 0.2850467289719626, IMAGE_HEIGHT * 0.6682242990654206);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.2850467289719626, IMAGE_HEIGHT * 0.6682242990654206, IMAGE_WIDTH * 0.27102803738317754, IMAGE_HEIGHT * 0.6682242990654206, IMAGE_WIDTH * 0.27102803738317754, IMAGE_HEIGHT * 0.6822429906542056);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.5467289719626168, IMAGE_HEIGHT * 0.38317757009345793);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5934579439252337, IMAGE_HEIGHT * 0.38317757009345793, IMAGE_WIDTH * 0.705607476635514, IMAGE_HEIGHT * 0.4252336448598131, IMAGE_WIDTH * 0.705607476635514, IMAGE_HEIGHT * 0.4953271028037383);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.705607476635514, IMAGE_HEIGHT * 0.5747663551401869, IMAGE_WIDTH * 0.5934579439252337, IMAGE_HEIGHT * 0.6121495327102804, IMAGE_WIDTH * 0.5467289719626168, IMAGE_HEIGHT * 0.6121495327102804);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5327102803738317, IMAGE_HEIGHT * 0.6121495327102804, IMAGE_WIDTH * 0.4766355140186916, IMAGE_HEIGHT * 0.6121495327102804, IMAGE_WIDTH * 0.4766355140186916, IMAGE_HEIGHT * 0.5);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4766355140186916, IMAGE_HEIGHT * 0.3878504672897196, IMAGE_WIDTH * 0.5327102803738317, IMAGE_HEIGHT * 0.38317757009345793, IMAGE_WIDTH * 0.5467289719626168, IMAGE_HEIGHT * 0.38317757009345793);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.5373831775700935, IMAGE_HEIGHT * 0.35514018691588783);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5186915887850467, IMAGE_HEIGHT * 0.35514018691588783, IMAGE_WIDTH * 0.4439252336448598, IMAGE_HEIGHT * 0.3598130841121495, IMAGE_WIDTH * 0.4439252336448598, IMAGE_HEIGHT * 0.5);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4439252336448598, IMAGE_HEIGHT * 0.6448598130841121, IMAGE_WIDTH * 0.5186915887850467, IMAGE_HEIGHT * 0.6401869158878505, IMAGE_WIDTH * 0.5373831775700935, IMAGE_HEIGHT * 0.6401869158878505);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5981308411214953, IMAGE_HEIGHT * 0.6401869158878505, IMAGE_WIDTH * 0.7336448598130841, IMAGE_HEIGHT * 0.5934579439252337, IMAGE_WIDTH * 0.7336448598130841, IMAGE_HEIGHT * 0.4953271028037383);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.7336448598130841, IMAGE_HEIGHT * 0.40654205607476634, IMAGE_WIDTH * 0.5981308411214953, IMAGE_HEIGHT * 0.35514018691588783, IMAGE_WIDTH * 0.5373831775700935, IMAGE_HEIGHT * 0.35514018691588783);
                SYMBOL.closePath();
                break;

            case FOG_LIGHT:
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(Path2D.WIND_EVEN_ODD);
                SYMBOL.moveTo(IMAGE_WIDTH * 0.5607476635514018, IMAGE_HEIGHT * 0.5794392523364486);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5607476635514018, IMAGE_HEIGHT * 0.5887850467289719, IMAGE_WIDTH * 0.5700934579439252, IMAGE_HEIGHT * 0.5934579439252337, IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.5934579439252337);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.5934579439252337, IMAGE_WIDTH * 0.5934579439252337, IMAGE_HEIGHT * 0.5934579439252337, IMAGE_WIDTH * 0.5934579439252337, IMAGE_HEIGHT * 0.5934579439252337);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5981308411214953, IMAGE_HEIGHT * 0.6121495327102804, IMAGE_WIDTH * 0.6121495327102804, IMAGE_HEIGHT * 0.6214953271028038, IMAGE_WIDTH * 0.6121495327102804, IMAGE_HEIGHT * 0.6214953271028038);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.6355140186915887, IMAGE_HEIGHT * 0.6074766355140186);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6355140186915887, IMAGE_HEIGHT * 0.6074766355140186, IMAGE_WIDTH * 0.6214953271028038, IMAGE_HEIGHT * 0.602803738317757, IMAGE_WIDTH * 0.616822429906542, IMAGE_HEIGHT * 0.5934579439252337);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.616822429906542, IMAGE_HEIGHT * 0.5934579439252337, IMAGE_WIDTH * 0.6682242990654206, IMAGE_HEIGHT * 0.5934579439252337, IMAGE_WIDTH * 0.6682242990654206, IMAGE_HEIGHT * 0.5934579439252337);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.677570093457944, IMAGE_HEIGHT * 0.5934579439252337, IMAGE_WIDTH * 0.6822429906542056, IMAGE_HEIGHT * 0.5887850467289719, IMAGE_WIDTH * 0.6822429906542056, IMAGE_HEIGHT * 0.5794392523364486);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6822429906542056, IMAGE_HEIGHT * 0.5747663551401869, IMAGE_WIDTH * 0.677570093457944, IMAGE_HEIGHT * 0.5654205607476636, IMAGE_WIDTH * 0.6682242990654206, IMAGE_HEIGHT * 0.5654205607476636);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6682242990654206, IMAGE_HEIGHT * 0.5654205607476636, IMAGE_WIDTH * 0.6121495327102804, IMAGE_HEIGHT * 0.5654205607476636, IMAGE_WIDTH * 0.6121495327102804, IMAGE_HEIGHT * 0.5654205607476636);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6214953271028038, IMAGE_HEIGHT * 0.5514018691588785, IMAGE_WIDTH * 0.6448598130841121, IMAGE_HEIGHT * 0.5280373831775701, IMAGE_WIDTH * 0.6495327102803738, IMAGE_HEIGHT * 0.5093457943925234);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6495327102803738, IMAGE_HEIGHT * 0.5093457943925234, IMAGE_WIDTH * 0.6682242990654206, IMAGE_HEIGHT * 0.5093457943925234, IMAGE_WIDTH * 0.6682242990654206, IMAGE_HEIGHT * 0.5093457943925234);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.677570093457944, IMAGE_HEIGHT * 0.5093457943925234, IMAGE_WIDTH * 0.6822429906542056, IMAGE_HEIGHT * 0.5046728971962616, IMAGE_WIDTH * 0.6822429906542056, IMAGE_HEIGHT * 0.5);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6822429906542056, IMAGE_HEIGHT * 0.49065420560747663, IMAGE_WIDTH * 0.677570093457944, IMAGE_HEIGHT * 0.48598130841121495, IMAGE_WIDTH * 0.6682242990654206, IMAGE_HEIGHT * 0.48598130841121495);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6682242990654206, IMAGE_HEIGHT * 0.48598130841121495, IMAGE_WIDTH * 0.6542056074766355, IMAGE_HEIGHT * 0.48598130841121495, IMAGE_WIDTH * 0.6542056074766355, IMAGE_HEIGHT * 0.48598130841121495);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6448598130841121, IMAGE_HEIGHT * 0.4672897196261682, IMAGE_WIDTH * 0.6261682242990654, IMAGE_HEIGHT * 0.4532710280373832, IMAGE_WIDTH * 0.616822429906542, IMAGE_HEIGHT * 0.4392523364485981);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.616822429906542, IMAGE_HEIGHT * 0.4392523364485981, IMAGE_WIDTH * 0.6682242990654206, IMAGE_HEIGHT * 0.4392523364485981, IMAGE_WIDTH * 0.6682242990654206, IMAGE_HEIGHT * 0.4392523364485981);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.677570093457944, IMAGE_HEIGHT * 0.4392523364485981, IMAGE_WIDTH * 0.6822429906542056, IMAGE_HEIGHT * 0.42990654205607476, IMAGE_WIDTH * 0.6822429906542056, IMAGE_HEIGHT * 0.4252336448598131);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6822429906542056, IMAGE_HEIGHT * 0.4158878504672897, IMAGE_WIDTH * 0.677570093457944, IMAGE_HEIGHT * 0.411214953271028, IMAGE_WIDTH * 0.6682242990654206, IMAGE_HEIGHT * 0.411214953271028);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6682242990654206, IMAGE_HEIGHT * 0.411214953271028, IMAGE_WIDTH * 0.6121495327102804, IMAGE_HEIGHT * 0.411214953271028, IMAGE_WIDTH * 0.6121495327102804, IMAGE_HEIGHT * 0.411214953271028);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6214953271028038, IMAGE_HEIGHT * 0.397196261682243, IMAGE_WIDTH * 0.6308411214953271, IMAGE_HEIGHT * 0.3925233644859813, IMAGE_WIDTH * 0.6308411214953271, IMAGE_HEIGHT * 0.3925233644859813);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.616822429906542, IMAGE_HEIGHT * 0.37850467289719625);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.616822429906542, IMAGE_HEIGHT * 0.37850467289719625, IMAGE_WIDTH * 0.5981308411214953, IMAGE_HEIGHT * 0.3925233644859813, IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.411214953271028);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.411214953271028, IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.411214953271028, IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.411214953271028);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5700934579439252, IMAGE_HEIGHT * 0.411214953271028, IMAGE_WIDTH * 0.5607476635514018, IMAGE_HEIGHT * 0.4158878504672897, IMAGE_WIDTH * 0.5607476635514018, IMAGE_HEIGHT * 0.4252336448598131);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5607476635514018, IMAGE_HEIGHT * 0.42990654205607476, IMAGE_WIDTH * 0.5700934579439252, IMAGE_HEIGHT * 0.4392523364485981, IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.4392523364485981);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.4392523364485981, IMAGE_WIDTH * 0.5934579439252337, IMAGE_HEIGHT * 0.4392523364485981, IMAGE_WIDTH * 0.5934579439252337, IMAGE_HEIGHT * 0.4392523364485981);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5981308411214953, IMAGE_HEIGHT * 0.4532710280373832, IMAGE_WIDTH * 0.616822429906542, IMAGE_HEIGHT * 0.4672897196261682, IMAGE_WIDTH * 0.6261682242990654, IMAGE_HEIGHT * 0.48598130841121495);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6261682242990654, IMAGE_HEIGHT * 0.48598130841121495, IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.48598130841121495, IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.48598130841121495);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5700934579439252, IMAGE_HEIGHT * 0.48598130841121495, IMAGE_WIDTH * 0.5607476635514018, IMAGE_HEIGHT * 0.49065420560747663, IMAGE_WIDTH * 0.5607476635514018, IMAGE_HEIGHT * 0.5);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5607476635514018, IMAGE_HEIGHT * 0.5046728971962616, IMAGE_WIDTH * 0.5700934579439252, IMAGE_HEIGHT * 0.5093457943925234, IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.5093457943925234);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.5093457943925234, IMAGE_WIDTH * 0.6261682242990654, IMAGE_HEIGHT * 0.5093457943925234, IMAGE_WIDTH * 0.6261682242990654, IMAGE_HEIGHT * 0.5093457943925234);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.616822429906542, IMAGE_HEIGHT * 0.5280373831775701, IMAGE_WIDTH * 0.5981308411214953, IMAGE_HEIGHT * 0.5467289719626168, IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.5654205607476636);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.5654205607476636, IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.5654205607476636, IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.5654205607476636);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5700934579439252, IMAGE_HEIGHT * 0.5654205607476636, IMAGE_WIDTH * 0.5607476635514018, IMAGE_HEIGHT * 0.5747663551401869, IMAGE_WIDTH * 0.5607476635514018, IMAGE_HEIGHT * 0.5794392523364486);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.4719626168224299, IMAGE_HEIGHT * 0.38317757009345793);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.48598130841121495, IMAGE_HEIGHT * 0.38317757009345793, IMAGE_WIDTH * 0.5280373831775701, IMAGE_HEIGHT * 0.3878504672897196, IMAGE_WIDTH * 0.5280373831775701, IMAGE_HEIGHT * 0.5);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5280373831775701, IMAGE_HEIGHT * 0.6121495327102804, IMAGE_WIDTH * 0.48598130841121495, IMAGE_HEIGHT * 0.6121495327102804, IMAGE_WIDTH * 0.4719626168224299, IMAGE_HEIGHT * 0.6121495327102804);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.43457943925233644, IMAGE_HEIGHT * 0.6121495327102804, IMAGE_WIDTH * 0.34579439252336447, IMAGE_HEIGHT * 0.5747663551401869, IMAGE_WIDTH * 0.34579439252336447, IMAGE_HEIGHT * 0.4953271028037383);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.34579439252336447, IMAGE_HEIGHT * 0.4252336448598131, IMAGE_WIDTH * 0.43457943925233644, IMAGE_HEIGHT * 0.38317757009345793, IMAGE_WIDTH * 0.4719626168224299, IMAGE_HEIGHT * 0.38317757009345793);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.48130841121495327, IMAGE_HEIGHT * 0.35514018691588783);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.43457943925233644, IMAGE_HEIGHT * 0.35514018691588783, IMAGE_WIDTH * 0.32242990654205606, IMAGE_HEIGHT * 0.40654205607476634, IMAGE_WIDTH * 0.32242990654205606, IMAGE_HEIGHT * 0.4953271028037383);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.32242990654205606, IMAGE_HEIGHT * 0.5934579439252337, IMAGE_WIDTH * 0.43457943925233644, IMAGE_HEIGHT * 0.6401869158878505, IMAGE_WIDTH * 0.48130841121495327, IMAGE_HEIGHT * 0.6401869158878505);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4953271028037383, IMAGE_HEIGHT * 0.6401869158878505, IMAGE_WIDTH * 0.5514018691588785, IMAGE_HEIGHT * 0.6448598130841121, IMAGE_WIDTH * 0.5514018691588785, IMAGE_HEIGHT * 0.5);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5514018691588785, IMAGE_HEIGHT * 0.3598130841121495, IMAGE_WIDTH * 0.4953271028037383, IMAGE_HEIGHT * 0.35514018691588783, IMAGE_WIDTH * 0.48130841121495327, IMAGE_HEIGHT * 0.35514018691588783);
                SYMBOL.closePath();
                break;

            case BATTERY:
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(Path2D.WIND_EVEN_ODD);
                SYMBOL.moveTo(IMAGE_WIDTH * 0.3037383177570093, IMAGE_HEIGHT * 0.4252336448598131);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.3037383177570093, IMAGE_HEIGHT * 0.4205607476635514, IMAGE_WIDTH * 0.308411214953271, IMAGE_HEIGHT * 0.4158878504672897, IMAGE_WIDTH * 0.3177570093457944, IMAGE_HEIGHT * 0.4158878504672897);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.3177570093457944, IMAGE_HEIGHT * 0.4158878504672897, IMAGE_WIDTH * 0.6822429906542056, IMAGE_HEIGHT * 0.4158878504672897, IMAGE_WIDTH * 0.6822429906542056, IMAGE_HEIGHT * 0.4158878504672897);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6915887850467289, IMAGE_HEIGHT * 0.4158878504672897, IMAGE_WIDTH * 0.6962616822429907, IMAGE_HEIGHT * 0.4205607476635514, IMAGE_WIDTH * 0.6962616822429907, IMAGE_HEIGHT * 0.4252336448598131);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6962616822429907, IMAGE_HEIGHT * 0.4252336448598131, IMAGE_WIDTH * 0.6962616822429907, IMAGE_HEIGHT * 0.6214953271028038, IMAGE_WIDTH * 0.6962616822429907, IMAGE_HEIGHT * 0.6214953271028038);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6962616822429907, IMAGE_HEIGHT * 0.6308411214953271, IMAGE_WIDTH * 0.6915887850467289, IMAGE_HEIGHT * 0.6355140186915887, IMAGE_WIDTH * 0.6822429906542056, IMAGE_HEIGHT * 0.6355140186915887);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6822429906542056, IMAGE_HEIGHT * 0.6355140186915887, IMAGE_WIDTH * 0.3177570093457944, IMAGE_HEIGHT * 0.6355140186915887, IMAGE_WIDTH * 0.3177570093457944, IMAGE_HEIGHT * 0.6355140186915887);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.308411214953271, IMAGE_HEIGHT * 0.6355140186915887, IMAGE_WIDTH * 0.3037383177570093, IMAGE_HEIGHT * 0.6308411214953271, IMAGE_WIDTH * 0.3037383177570093, IMAGE_HEIGHT * 0.6214953271028038);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.3037383177570093, IMAGE_HEIGHT * 0.6214953271028038, IMAGE_WIDTH * 0.3037383177570093, IMAGE_HEIGHT * 0.4252336448598131, IMAGE_WIDTH * 0.3037383177570093, IMAGE_HEIGHT * 0.4252336448598131);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.32710280373831774, IMAGE_HEIGHT * 0.35514018691588783);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.32710280373831774, IMAGE_HEIGHT * 0.35514018691588783, IMAGE_WIDTH * 0.32710280373831774, IMAGE_HEIGHT * 0.37850467289719625, IMAGE_WIDTH * 0.32710280373831774, IMAGE_HEIGHT * 0.37850467289719625);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.32710280373831774, IMAGE_HEIGHT * 0.37850467289719625, IMAGE_WIDTH * 0.2897196261682243, IMAGE_HEIGHT * 0.37850467289719625, IMAGE_WIDTH * 0.2897196261682243, IMAGE_HEIGHT * 0.37850467289719625);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.2757009345794392, IMAGE_HEIGHT * 0.37850467289719625, IMAGE_WIDTH * 0.26635514018691586, IMAGE_HEIGHT * 0.3878504672897196, IMAGE_WIDTH * 0.26635514018691586, IMAGE_HEIGHT * 0.40186915887850466);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.26635514018691586, IMAGE_HEIGHT * 0.40186915887850466, IMAGE_WIDTH * 0.26635514018691586, IMAGE_HEIGHT * 0.6448598130841121, IMAGE_WIDTH * 0.26635514018691586, IMAGE_HEIGHT * 0.6448598130841121);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.26635514018691586, IMAGE_HEIGHT * 0.6588785046728972, IMAGE_WIDTH * 0.2757009345794392, IMAGE_HEIGHT * 0.6728971962616822, IMAGE_WIDTH * 0.2897196261682243, IMAGE_HEIGHT * 0.6728971962616822);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.2897196261682243, IMAGE_HEIGHT * 0.6728971962616822, IMAGE_WIDTH * 0.7102803738317757, IMAGE_HEIGHT * 0.6728971962616822, IMAGE_WIDTH * 0.7102803738317757, IMAGE_HEIGHT * 0.6728971962616822);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.7242990654205608, IMAGE_HEIGHT * 0.6728971962616822, IMAGE_WIDTH * 0.7336448598130841, IMAGE_HEIGHT * 0.6588785046728972, IMAGE_WIDTH * 0.7336448598130841, IMAGE_HEIGHT * 0.6448598130841121);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.7336448598130841, IMAGE_HEIGHT * 0.6448598130841121, IMAGE_WIDTH * 0.7336448598130841, IMAGE_HEIGHT * 0.40186915887850466, IMAGE_WIDTH * 0.7336448598130841, IMAGE_HEIGHT * 0.40186915887850466);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.7336448598130841, IMAGE_HEIGHT * 0.3878504672897196, IMAGE_WIDTH * 0.7242990654205608, IMAGE_HEIGHT * 0.37850467289719625, IMAGE_WIDTH * 0.7102803738317757, IMAGE_HEIGHT * 0.37850467289719625);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.7102803738317757, IMAGE_HEIGHT * 0.37850467289719625, IMAGE_WIDTH * 0.6728971962616822, IMAGE_HEIGHT * 0.37850467289719625, IMAGE_WIDTH * 0.6728971962616822, IMAGE_HEIGHT * 0.37850467289719625);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6728971962616822, IMAGE_HEIGHT * 0.37850467289719625, IMAGE_WIDTH * 0.6728971962616822, IMAGE_HEIGHT * 0.35514018691588783, IMAGE_WIDTH * 0.6728971962616822, IMAGE_HEIGHT * 0.35514018691588783);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6728971962616822, IMAGE_HEIGHT * 0.3411214953271028, IMAGE_WIDTH * 0.6588785046728972, IMAGE_HEIGHT * 0.3317757009345794, IMAGE_WIDTH * 0.6448598130841121, IMAGE_HEIGHT * 0.3317757009345794);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6448598130841121, IMAGE_HEIGHT * 0.3317757009345794, IMAGE_WIDTH * 0.6121495327102804, IMAGE_HEIGHT * 0.3317757009345794, IMAGE_WIDTH * 0.6121495327102804, IMAGE_HEIGHT * 0.3317757009345794);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5981308411214953, IMAGE_HEIGHT * 0.3317757009345794, IMAGE_WIDTH * 0.5841121495327103, IMAGE_HEIGHT * 0.3411214953271028, IMAGE_WIDTH * 0.5841121495327103, IMAGE_HEIGHT * 0.35514018691588783);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5841121495327103, IMAGE_HEIGHT * 0.35514018691588783, IMAGE_WIDTH * 0.5841121495327103, IMAGE_HEIGHT * 0.37850467289719625, IMAGE_WIDTH * 0.5841121495327103, IMAGE_HEIGHT * 0.37850467289719625);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.4158878504672897, IMAGE_HEIGHT * 0.37850467289719625);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4158878504672897, IMAGE_HEIGHT * 0.37850467289719625, IMAGE_WIDTH * 0.4158878504672897, IMAGE_HEIGHT * 0.35514018691588783, IMAGE_WIDTH * 0.4158878504672897, IMAGE_HEIGHT * 0.35514018691588783);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4158878504672897, IMAGE_HEIGHT * 0.3411214953271028, IMAGE_WIDTH * 0.40186915887850466, IMAGE_HEIGHT * 0.3317757009345794, IMAGE_WIDTH * 0.3878504672897196, IMAGE_HEIGHT * 0.3317757009345794);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.3878504672897196, IMAGE_HEIGHT * 0.3317757009345794, IMAGE_WIDTH * 0.35514018691588783, IMAGE_HEIGHT * 0.3317757009345794, IMAGE_WIDTH * 0.35514018691588783, IMAGE_HEIGHT * 0.3317757009345794);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.3411214953271028, IMAGE_HEIGHT * 0.3317757009345794, IMAGE_WIDTH * 0.32710280373831774, IMAGE_HEIGHT * 0.3411214953271028, IMAGE_WIDTH * 0.32710280373831774, IMAGE_HEIGHT * 0.35514018691588783);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.5);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.514018691588785);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.6121495327102804, IMAGE_HEIGHT * 0.514018691588785);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.6121495327102804, IMAGE_HEIGHT * 0.5467289719626168);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.6214953271028038, IMAGE_HEIGHT * 0.5467289719626168);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.6214953271028038, IMAGE_HEIGHT * 0.514018691588785);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.6588785046728972, IMAGE_HEIGHT * 0.514018691588785);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.6588785046728972, IMAGE_HEIGHT * 0.5);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.6214953271028038, IMAGE_HEIGHT * 0.5);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.6214953271028038, IMAGE_HEIGHT * 0.46261682242990654);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.6121495327102804, IMAGE_HEIGHT * 0.46261682242990654);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.6121495327102804, IMAGE_HEIGHT * 0.5);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.5);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.32710280373831774, IMAGE_HEIGHT * 0.5);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.32710280373831774, IMAGE_HEIGHT * 0.514018691588785);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.4158878504672897, IMAGE_HEIGHT * 0.514018691588785);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.4158878504672897, IMAGE_HEIGHT * 0.5);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.32710280373831774, IMAGE_HEIGHT * 0.5);
                SYMBOL.closePath();
                break;

            case TEMPERATURE:
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(Path2D.WIND_EVEN_ODD);
                SYMBOL.moveTo(IMAGE_WIDTH * 0.616822429906542, IMAGE_HEIGHT * 0.6121495327102804);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6074766355140186, IMAGE_HEIGHT * 0.6121495327102804, IMAGE_WIDTH * 0.6121495327102804, IMAGE_HEIGHT * 0.602803738317757, IMAGE_WIDTH * 0.5841121495327103, IMAGE_HEIGHT * 0.602803738317757);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5794392523364486, IMAGE_HEIGHT * 0.6074766355140186, IMAGE_WIDTH * 0.5794392523364486, IMAGE_HEIGHT * 0.6214953271028038, IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.6261682242990654);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5981308411214953, IMAGE_HEIGHT * 0.6261682242990654, IMAGE_WIDTH * 0.6121495327102804, IMAGE_HEIGHT * 0.6355140186915887, IMAGE_WIDTH * 0.6214953271028038, IMAGE_HEIGHT * 0.6355140186915887);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6495327102803738, IMAGE_HEIGHT * 0.6355140186915887, IMAGE_WIDTH * 0.6588785046728972, IMAGE_HEIGHT * 0.602803738317757, IMAGE_WIDTH * 0.677570093457944, IMAGE_HEIGHT * 0.602803738317757);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.7009345794392523, IMAGE_HEIGHT * 0.602803738317757, IMAGE_WIDTH * 0.6962616822429907, IMAGE_HEIGHT * 0.6355140186915887, IMAGE_WIDTH * 0.719626168224299, IMAGE_HEIGHT * 0.6355140186915887);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.7336448598130841, IMAGE_HEIGHT * 0.6355140186915887, IMAGE_WIDTH * 0.7336448598130841, IMAGE_HEIGHT * 0.6121495327102804, IMAGE_WIDTH * 0.7242990654205608, IMAGE_HEIGHT * 0.6121495327102804);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.705607476635514, IMAGE_HEIGHT * 0.6121495327102804, IMAGE_WIDTH * 0.6962616822429907, IMAGE_HEIGHT * 0.5794392523364486, IMAGE_WIDTH * 0.677570093457944, IMAGE_HEIGHT * 0.5794392523364486);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6542056074766355, IMAGE_HEIGHT * 0.5794392523364486, IMAGE_WIDTH * 0.6448598130841121, IMAGE_HEIGHT * 0.6121495327102804, IMAGE_WIDTH * 0.616822429906542, IMAGE_HEIGHT * 0.6121495327102804);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.27102803738317754, IMAGE_HEIGHT * 0.602803738317757);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.2616822429906542, IMAGE_HEIGHT * 0.6074766355140186, IMAGE_WIDTH * 0.2616822429906542, IMAGE_HEIGHT * 0.6261682242990654, IMAGE_WIDTH * 0.27102803738317754, IMAGE_HEIGHT * 0.6261682242990654);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.3037383177570093, IMAGE_HEIGHT * 0.6261682242990654, IMAGE_WIDTH * 0.3037383177570093, IMAGE_HEIGHT * 0.602803738317757, IMAGE_WIDTH * 0.32242990654205606, IMAGE_HEIGHT * 0.602803738317757);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.35046728971962615, IMAGE_HEIGHT * 0.602803738317757, IMAGE_WIDTH * 0.35046728971962615, IMAGE_HEIGHT * 0.6261682242990654, IMAGE_WIDTH * 0.38317757009345793, IMAGE_HEIGHT * 0.6261682242990654);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.411214953271028, IMAGE_HEIGHT * 0.6261682242990654, IMAGE_WIDTH * 0.411214953271028, IMAGE_HEIGHT * 0.6214953271028038, IMAGE_WIDTH * 0.4158878504672897, IMAGE_HEIGHT * 0.6121495327102804);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4205607476635514, IMAGE_HEIGHT * 0.602803738317757, IMAGE_WIDTH * 0.40186915887850466, IMAGE_HEIGHT * 0.5981308411214953, IMAGE_WIDTH * 0.37850467289719625, IMAGE_HEIGHT * 0.602803738317757);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.35514018691588783, IMAGE_HEIGHT * 0.602803738317757, IMAGE_WIDTH * 0.35046728971962615, IMAGE_HEIGHT * 0.5747663551401869, IMAGE_WIDTH * 0.32242990654205606, IMAGE_HEIGHT * 0.5747663551401869);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.29906542056074764, IMAGE_HEIGHT * 0.5747663551401869, IMAGE_WIDTH * 0.2850467289719626, IMAGE_HEIGHT * 0.602803738317757, IMAGE_WIDTH * 0.27102803738317754, IMAGE_HEIGHT * 0.602803738317757);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.32242990654205606, IMAGE_HEIGHT * 0.6728971962616822);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.32242990654205606, IMAGE_HEIGHT * 0.6728971962616822, IMAGE_WIDTH * 0.3130841121495327, IMAGE_HEIGHT * 0.6822429906542056, IMAGE_WIDTH * 0.3130841121495327, IMAGE_HEIGHT * 0.6915887850467289);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.3411214953271028, IMAGE_HEIGHT * 0.6915887850467289, IMAGE_WIDTH * 0.35514018691588783, IMAGE_HEIGHT * 0.7242990654205608, IMAGE_WIDTH * 0.38317757009345793, IMAGE_HEIGHT * 0.7242990654205608);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.411214953271028, IMAGE_HEIGHT * 0.7242990654205608, IMAGE_WIDTH * 0.4205607476635514, IMAGE_HEIGHT * 0.6869158878504673, IMAGE_WIDTH * 0.4439252336448598, IMAGE_HEIGHT * 0.6869158878504673);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4719626168224299, IMAGE_HEIGHT * 0.6869158878504673, IMAGE_WIDTH * 0.4719626168224299, IMAGE_HEIGHT * 0.7242990654205608, IMAGE_WIDTH * 0.5046728971962616, IMAGE_HEIGHT * 0.7242990654205608);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5327102803738317, IMAGE_HEIGHT * 0.7242990654205608, IMAGE_WIDTH * 0.5420560747663551, IMAGE_HEIGHT * 0.6869158878504673, IMAGE_WIDTH * 0.5607476635514018, IMAGE_HEIGHT * 0.6869158878504673);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5841121495327103, IMAGE_HEIGHT * 0.6869158878504673, IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.7242990654205608, IMAGE_WIDTH * 0.6121495327102804, IMAGE_HEIGHT * 0.7242990654205608);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6401869158878505, IMAGE_HEIGHT * 0.7242990654205608, IMAGE_WIDTH * 0.6588785046728972, IMAGE_HEIGHT * 0.6822429906542056, IMAGE_WIDTH * 0.6915887850467289, IMAGE_HEIGHT * 0.6822429906542056);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6915887850467289, IMAGE_HEIGHT * 0.6822429906542056, IMAGE_WIDTH * 0.6915887850467289, IMAGE_HEIGHT * 0.6728971962616822, IMAGE_WIDTH * 0.6822429906542056, IMAGE_HEIGHT * 0.6635514018691588);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6542056074766355, IMAGE_HEIGHT * 0.6635514018691588, IMAGE_WIDTH * 0.6355140186915887, IMAGE_HEIGHT * 0.7009345794392523, IMAGE_WIDTH * 0.6121495327102804, IMAGE_HEIGHT * 0.7009345794392523);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.7009345794392523, IMAGE_WIDTH * 0.5841121495327103, IMAGE_HEIGHT * 0.6635514018691588, IMAGE_WIDTH * 0.5607476635514018, IMAGE_HEIGHT * 0.6635514018691588);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5420560747663551, IMAGE_HEIGHT * 0.6635514018691588, IMAGE_WIDTH * 0.5280373831775701, IMAGE_HEIGHT * 0.7009345794392523, IMAGE_WIDTH * 0.5046728971962616, IMAGE_HEIGHT * 0.7009345794392523);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4766355140186916, IMAGE_HEIGHT * 0.7009345794392523, IMAGE_WIDTH * 0.4719626168224299, IMAGE_HEIGHT * 0.6635514018691588, IMAGE_WIDTH * 0.4439252336448598, IMAGE_HEIGHT * 0.6635514018691588);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4205607476635514, IMAGE_HEIGHT * 0.6635514018691588, IMAGE_WIDTH * 0.397196261682243, IMAGE_HEIGHT * 0.7009345794392523, IMAGE_WIDTH * 0.38317757009345793, IMAGE_HEIGHT * 0.7009345794392523);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.35514018691588783, IMAGE_HEIGHT * 0.7009345794392523, IMAGE_WIDTH * 0.35514018691588783, IMAGE_HEIGHT * 0.6728971962616822, IMAGE_WIDTH * 0.32242990654205606, IMAGE_HEIGHT * 0.6728971962616822);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.514018691588785, IMAGE_HEIGHT * 0.37850467289719625);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.514018691588785, IMAGE_HEIGHT * 0.37850467289719625, IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.37850467289719625, IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.37850467289719625);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5794392523364486, IMAGE_HEIGHT * 0.37850467289719625, IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.3691588785046729, IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.3644859813084112);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.3598130841121495, IMAGE_WIDTH * 0.5794392523364486, IMAGE_HEIGHT * 0.35046728971962615, IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.35046728971962615);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.35046728971962615, IMAGE_WIDTH * 0.514018691588785, IMAGE_HEIGHT * 0.35046728971962615, IMAGE_WIDTH * 0.514018691588785, IMAGE_HEIGHT * 0.35046728971962615);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.514018691588785, IMAGE_HEIGHT * 0.35046728971962615, IMAGE_WIDTH * 0.514018691588785, IMAGE_HEIGHT * 0.29906542056074764, IMAGE_WIDTH * 0.514018691588785, IMAGE_HEIGHT * 0.29906542056074764);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.514018691588785, IMAGE_HEIGHT * 0.2897196261682243, IMAGE_WIDTH * 0.5046728971962616, IMAGE_HEIGHT * 0.2803738317757009, IMAGE_WIDTH * 0.4953271028037383, IMAGE_HEIGHT * 0.2803738317757009);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.48598130841121495, IMAGE_HEIGHT * 0.2803738317757009, IMAGE_WIDTH * 0.4766355140186916, IMAGE_HEIGHT * 0.2897196261682243, IMAGE_WIDTH * 0.4766355140186916, IMAGE_HEIGHT * 0.29906542056074764);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4766355140186916, IMAGE_HEIGHT * 0.29906542056074764, IMAGE_WIDTH * 0.4766355140186916, IMAGE_HEIGHT * 0.5700934579439252, IMAGE_WIDTH * 0.4766355140186916, IMAGE_HEIGHT * 0.5700934579439252);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.46261682242990654, IMAGE_HEIGHT * 0.5794392523364486, IMAGE_WIDTH * 0.4532710280373832, IMAGE_HEIGHT * 0.5934579439252337, IMAGE_WIDTH * 0.4532710280373832, IMAGE_HEIGHT * 0.6121495327102804);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4532710280373832, IMAGE_HEIGHT * 0.6355140186915887, IMAGE_WIDTH * 0.4719626168224299, IMAGE_HEIGHT * 0.6542056074766355, IMAGE_WIDTH * 0.4953271028037383, IMAGE_HEIGHT * 0.6542056074766355);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5186915887850467, IMAGE_HEIGHT * 0.6542056074766355, IMAGE_WIDTH * 0.5373831775700935, IMAGE_HEIGHT * 0.6355140186915887, IMAGE_WIDTH * 0.5373831775700935, IMAGE_HEIGHT * 0.6121495327102804);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5373831775700935, IMAGE_HEIGHT * 0.5934579439252337, IMAGE_WIDTH * 0.5280373831775701, IMAGE_HEIGHT * 0.5794392523364486, IMAGE_WIDTH * 0.514018691588785, IMAGE_HEIGHT * 0.5700934579439252);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.514018691588785, IMAGE_HEIGHT * 0.5700934579439252, IMAGE_WIDTH * 0.514018691588785, IMAGE_HEIGHT * 0.5186915887850467, IMAGE_WIDTH * 0.514018691588785, IMAGE_HEIGHT * 0.5186915887850467);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.514018691588785, IMAGE_HEIGHT * 0.5186915887850467, IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.5186915887850467, IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.5186915887850467);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5794392523364486, IMAGE_HEIGHT * 0.5186915887850467, IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.514018691588785, IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.5093457943925234);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.5, IMAGE_WIDTH * 0.5794392523364486, IMAGE_HEIGHT * 0.4953271028037383, IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.4953271028037383);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.4953271028037383, IMAGE_WIDTH * 0.514018691588785, IMAGE_HEIGHT * 0.4953271028037383, IMAGE_WIDTH * 0.514018691588785, IMAGE_HEIGHT * 0.4953271028037383);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.514018691588785, IMAGE_HEIGHT * 0.4485981308411215);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.514018691588785, IMAGE_HEIGHT * 0.4485981308411215, IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.4485981308411215, IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.4485981308411215);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5794392523364486, IMAGE_HEIGHT * 0.4485981308411215, IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.4439252336448598, IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.43457943925233644);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.42990654205607476, IMAGE_WIDTH * 0.5794392523364486, IMAGE_HEIGHT * 0.4252336448598131, IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.4252336448598131);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.4252336448598131, IMAGE_WIDTH * 0.514018691588785, IMAGE_HEIGHT * 0.4252336448598131, IMAGE_WIDTH * 0.514018691588785, IMAGE_HEIGHT * 0.4252336448598131);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.514018691588785, IMAGE_HEIGHT * 0.37850467289719625);
                SYMBOL.closePath();
                break;

            case TURN_LIGHT:
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(Path2D.WIND_EVEN_ODD);
                SYMBOL.moveTo(IMAGE_WIDTH * 0.48598130841121495, IMAGE_HEIGHT * 0.5700934579439252);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.48598130841121495, IMAGE_HEIGHT * 0.42990654205607476);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.411214953271028, IMAGE_HEIGHT * 0.42990654205607476);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.411214953271028, IMAGE_HEIGHT * 0.35514018691588783);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.24299065420560748, IMAGE_HEIGHT * 0.5);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.411214953271028, IMAGE_HEIGHT * 0.6495327102803738);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.411214953271028, IMAGE_HEIGHT * 0.5700934579439252);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.48598130841121495, IMAGE_HEIGHT * 0.5700934579439252);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.5093457943925234, IMAGE_HEIGHT * 0.5700934579439252);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.5841121495327103, IMAGE_HEIGHT * 0.5700934579439252);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.5841121495327103, IMAGE_HEIGHT * 0.6495327102803738);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.7523364485981309, IMAGE_HEIGHT * 0.5);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.5841121495327103, IMAGE_HEIGHT * 0.35514018691588783);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.5841121495327103, IMAGE_HEIGHT * 0.42990654205607476);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.5093457943925234, IMAGE_HEIGHT * 0.42990654205607476);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.5093457943925234, IMAGE_HEIGHT * 0.5700934579439252);
                SYMBOL.closePath();
                break;

            case GLAZE:
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(Path2D.WIND_EVEN_ODD);
                SYMBOL.moveTo(IMAGE_WIDTH * 0.4766355140186916, IMAGE_HEIGHT * 0.2897196261682243);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4766355140186916, IMAGE_HEIGHT * 0.2897196261682243, IMAGE_WIDTH * 0.4766355140186916, IMAGE_HEIGHT * 0.34579439252336447, IMAGE_WIDTH * 0.4766355140186916, IMAGE_HEIGHT * 0.34579439252336447);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4766355140186916, IMAGE_HEIGHT * 0.34579439252336447, IMAGE_WIDTH * 0.4532710280373832, IMAGE_HEIGHT * 0.32242990654205606, IMAGE_WIDTH * 0.4532710280373832, IMAGE_HEIGHT * 0.32242990654205606);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4485981308411215, IMAGE_HEIGHT * 0.3177570093457944, IMAGE_WIDTH * 0.4392523364485981, IMAGE_HEIGHT * 0.3177570093457944, IMAGE_WIDTH * 0.43457943925233644, IMAGE_HEIGHT * 0.32242990654205606);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4252336448598131, IMAGE_HEIGHT * 0.32710280373831774, IMAGE_WIDTH * 0.4252336448598131, IMAGE_HEIGHT * 0.3364485981308411, IMAGE_WIDTH * 0.43457943925233644, IMAGE_HEIGHT * 0.34579439252336447);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.43457943925233644, IMAGE_HEIGHT * 0.34579439252336447, IMAGE_WIDTH * 0.4719626168224299, IMAGE_HEIGHT * 0.38317757009345793, IMAGE_WIDTH * 0.4719626168224299, IMAGE_HEIGHT * 0.38317757009345793);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4719626168224299, IMAGE_HEIGHT * 0.38317757009345793, IMAGE_WIDTH * 0.4766355140186916, IMAGE_HEIGHT * 0.3878504672897196, IMAGE_WIDTH * 0.4766355140186916, IMAGE_HEIGHT * 0.3878504672897196);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4766355140186916, IMAGE_HEIGHT * 0.3878504672897196, IMAGE_WIDTH * 0.4766355140186916, IMAGE_HEIGHT * 0.46261682242990654, IMAGE_WIDTH * 0.4766355140186916, IMAGE_HEIGHT * 0.46261682242990654);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4766355140186916, IMAGE_HEIGHT * 0.46261682242990654, IMAGE_WIDTH * 0.4158878504672897, IMAGE_HEIGHT * 0.4205607476635514, IMAGE_WIDTH * 0.4158878504672897, IMAGE_HEIGHT * 0.4205607476635514);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4158878504672897, IMAGE_HEIGHT * 0.4158878504672897, IMAGE_WIDTH * 0.4158878504672897, IMAGE_HEIGHT * 0.4158878504672897, IMAGE_WIDTH * 0.4158878504672897, IMAGE_HEIGHT * 0.411214953271028);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4158878504672897, IMAGE_HEIGHT * 0.411214953271028, IMAGE_WIDTH * 0.40654205607476634, IMAGE_HEIGHT * 0.3598130841121495, IMAGE_WIDTH * 0.40654205607476634, IMAGE_HEIGHT * 0.3598130841121495);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.40654205607476634, IMAGE_HEIGHT * 0.35046728971962615, IMAGE_WIDTH * 0.397196261682243, IMAGE_HEIGHT * 0.34579439252336447, IMAGE_WIDTH * 0.3878504672897196, IMAGE_HEIGHT * 0.34579439252336447);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.38317757009345793, IMAGE_HEIGHT * 0.34579439252336447, IMAGE_WIDTH * 0.37850467289719625, IMAGE_HEIGHT * 0.35514018691588783, IMAGE_WIDTH * 0.37850467289719625, IMAGE_HEIGHT * 0.3644859813084112);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.37850467289719625, IMAGE_HEIGHT * 0.3644859813084112, IMAGE_WIDTH * 0.38317757009345793, IMAGE_HEIGHT * 0.397196261682243, IMAGE_WIDTH * 0.38317757009345793, IMAGE_HEIGHT * 0.397196261682243);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.38317757009345793, IMAGE_HEIGHT * 0.397196261682243, IMAGE_WIDTH * 0.3364485981308411, IMAGE_HEIGHT * 0.3644859813084112, IMAGE_WIDTH * 0.3364485981308411, IMAGE_HEIGHT * 0.3644859813084112);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.32710280373831774, IMAGE_HEIGHT * 0.35514018691588783, IMAGE_WIDTH * 0.3130841121495327, IMAGE_HEIGHT * 0.3598130841121495, IMAGE_WIDTH * 0.308411214953271, IMAGE_HEIGHT * 0.3691588785046729);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.29906542056074764, IMAGE_HEIGHT * 0.37850467289719625, IMAGE_WIDTH * 0.3037383177570093, IMAGE_HEIGHT * 0.3925233644859813, IMAGE_WIDTH * 0.3130841121495327, IMAGE_HEIGHT * 0.397196261682243);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.3130841121495327, IMAGE_HEIGHT * 0.397196261682243, IMAGE_WIDTH * 0.3598130841121495, IMAGE_HEIGHT * 0.42990654205607476, IMAGE_WIDTH * 0.3598130841121495, IMAGE_HEIGHT * 0.42990654205607476);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.3598130841121495, IMAGE_HEIGHT * 0.42990654205607476, IMAGE_WIDTH * 0.32710280373831774, IMAGE_HEIGHT * 0.4392523364485981, IMAGE_WIDTH * 0.32710280373831774, IMAGE_HEIGHT * 0.4392523364485981);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.3177570093457944, IMAGE_HEIGHT * 0.4392523364485981, IMAGE_WIDTH * 0.3130841121495327, IMAGE_HEIGHT * 0.4439252336448598, IMAGE_WIDTH * 0.3130841121495327, IMAGE_HEIGHT * 0.4532710280373832);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.3177570093457944, IMAGE_HEIGHT * 0.46261682242990654, IMAGE_WIDTH * 0.32242990654205606, IMAGE_HEIGHT * 0.4672897196261682, IMAGE_WIDTH * 0.3317757009345794, IMAGE_HEIGHT * 0.46261682242990654);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.3317757009345794, IMAGE_HEIGHT * 0.46261682242990654, IMAGE_WIDTH * 0.3878504672897196, IMAGE_HEIGHT * 0.4532710280373832, IMAGE_WIDTH * 0.3878504672897196, IMAGE_HEIGHT * 0.4532710280373832);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.3878504672897196, IMAGE_HEIGHT * 0.4532710280373832, IMAGE_WIDTH * 0.3878504672897196, IMAGE_HEIGHT * 0.4532710280373832, IMAGE_WIDTH * 0.3925233644859813, IMAGE_HEIGHT * 0.4532710280373832);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.3925233644859813, IMAGE_HEIGHT * 0.4532710280373832, IMAGE_WIDTH * 0.46261682242990654, IMAGE_HEIGHT * 0.5046728971962616, IMAGE_WIDTH * 0.46261682242990654, IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.46261682242990654, IMAGE_HEIGHT * 0.5046728971962616, IMAGE_WIDTH * 0.3925233644859813, IMAGE_HEIGHT * 0.5514018691588785, IMAGE_WIDTH * 0.3925233644859813, IMAGE_HEIGHT * 0.5514018691588785);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.3878504672897196, IMAGE_HEIGHT * 0.5514018691588785, IMAGE_WIDTH * 0.3878504672897196, IMAGE_HEIGHT * 0.5514018691588785, IMAGE_WIDTH * 0.3878504672897196, IMAGE_HEIGHT * 0.5514018691588785);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.3878504672897196, IMAGE_HEIGHT * 0.5514018691588785, IMAGE_WIDTH * 0.3317757009345794, IMAGE_HEIGHT * 0.5420560747663551, IMAGE_WIDTH * 0.3317757009345794, IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.32242990654205606, IMAGE_HEIGHT * 0.5373831775700935, IMAGE_WIDTH * 0.3177570093457944, IMAGE_HEIGHT * 0.5420560747663551, IMAGE_WIDTH * 0.3130841121495327, IMAGE_HEIGHT * 0.5514018691588785);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.3130841121495327, IMAGE_HEIGHT * 0.5607476635514018, IMAGE_WIDTH * 0.3177570093457944, IMAGE_HEIGHT * 0.5654205607476636, IMAGE_WIDTH * 0.32710280373831774, IMAGE_HEIGHT * 0.5654205607476636);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.32710280373831774, IMAGE_HEIGHT * 0.5654205607476636, IMAGE_WIDTH * 0.3598130841121495, IMAGE_HEIGHT * 0.5747663551401869, IMAGE_WIDTH * 0.3598130841121495, IMAGE_HEIGHT * 0.5747663551401869);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.3598130841121495, IMAGE_HEIGHT * 0.5747663551401869, IMAGE_WIDTH * 0.3130841121495327, IMAGE_HEIGHT * 0.6074766355140186, IMAGE_WIDTH * 0.3130841121495327, IMAGE_HEIGHT * 0.6074766355140186);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.3037383177570093, IMAGE_HEIGHT * 0.6121495327102804, IMAGE_WIDTH * 0.29906542056074764, IMAGE_HEIGHT * 0.6261682242990654, IMAGE_WIDTH * 0.308411214953271, IMAGE_HEIGHT * 0.6355140186915887);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.3130841121495327, IMAGE_HEIGHT * 0.6448598130841121, IMAGE_WIDTH * 0.32710280373831774, IMAGE_HEIGHT * 0.6495327102803738, IMAGE_WIDTH * 0.3364485981308411, IMAGE_HEIGHT * 0.6401869158878505);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.3364485981308411, IMAGE_HEIGHT * 0.6401869158878505, IMAGE_WIDTH * 0.38317757009345793, IMAGE_HEIGHT * 0.6074766355140186, IMAGE_WIDTH * 0.38317757009345793, IMAGE_HEIGHT * 0.6074766355140186);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.38317757009345793, IMAGE_HEIGHT * 0.6074766355140186, IMAGE_WIDTH * 0.37850467289719625, IMAGE_HEIGHT * 0.6401869158878505, IMAGE_WIDTH * 0.37850467289719625, IMAGE_HEIGHT * 0.6401869158878505);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.37850467289719625, IMAGE_HEIGHT * 0.6495327102803738, IMAGE_WIDTH * 0.38317757009345793, IMAGE_HEIGHT * 0.6588785046728972, IMAGE_WIDTH * 0.3878504672897196, IMAGE_HEIGHT * 0.6588785046728972);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.397196261682243, IMAGE_HEIGHT * 0.6588785046728972, IMAGE_WIDTH * 0.40654205607476634, IMAGE_HEIGHT * 0.6542056074766355, IMAGE_WIDTH * 0.40654205607476634, IMAGE_HEIGHT * 0.6448598130841121);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.40654205607476634, IMAGE_HEIGHT * 0.6448598130841121, IMAGE_WIDTH * 0.4158878504672897, IMAGE_HEIGHT * 0.5934579439252337, IMAGE_WIDTH * 0.4158878504672897, IMAGE_HEIGHT * 0.5934579439252337);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4158878504672897, IMAGE_HEIGHT * 0.5887850467289719, IMAGE_WIDTH * 0.4158878504672897, IMAGE_HEIGHT * 0.5887850467289719, IMAGE_WIDTH * 0.4158878504672897, IMAGE_HEIGHT * 0.5841121495327103);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4158878504672897, IMAGE_HEIGHT * 0.5841121495327103, IMAGE_WIDTH * 0.4766355140186916, IMAGE_HEIGHT * 0.5420560747663551, IMAGE_WIDTH * 0.4766355140186916, IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4766355140186916, IMAGE_HEIGHT * 0.5420560747663551, IMAGE_WIDTH * 0.4766355140186916, IMAGE_HEIGHT * 0.616822429906542, IMAGE_WIDTH * 0.4766355140186916, IMAGE_HEIGHT * 0.616822429906542);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4766355140186916, IMAGE_HEIGHT * 0.616822429906542, IMAGE_WIDTH * 0.4719626168224299, IMAGE_HEIGHT * 0.6214953271028038, IMAGE_WIDTH * 0.4719626168224299, IMAGE_HEIGHT * 0.6214953271028038);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4719626168224299, IMAGE_HEIGHT * 0.6214953271028038, IMAGE_WIDTH * 0.43457943925233644, IMAGE_HEIGHT * 0.6588785046728972, IMAGE_WIDTH * 0.43457943925233644, IMAGE_HEIGHT * 0.6588785046728972);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4252336448598131, IMAGE_HEIGHT * 0.6682242990654206, IMAGE_WIDTH * 0.4252336448598131, IMAGE_HEIGHT * 0.677570093457944, IMAGE_WIDTH * 0.43457943925233644, IMAGE_HEIGHT * 0.6822429906542056);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4392523364485981, IMAGE_HEIGHT * 0.6869158878504673, IMAGE_WIDTH * 0.4485981308411215, IMAGE_HEIGHT * 0.6869158878504673, IMAGE_WIDTH * 0.4532710280373832, IMAGE_HEIGHT * 0.6822429906542056);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4532710280373832, IMAGE_HEIGHT * 0.6822429906542056, IMAGE_WIDTH * 0.4766355140186916, IMAGE_HEIGHT * 0.6588785046728972, IMAGE_WIDTH * 0.4766355140186916, IMAGE_HEIGHT * 0.6588785046728972);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4766355140186916, IMAGE_HEIGHT * 0.6588785046728972, IMAGE_WIDTH * 0.4766355140186916, IMAGE_HEIGHT * 0.7149532710280374, IMAGE_WIDTH * 0.4766355140186916, IMAGE_HEIGHT * 0.7149532710280374);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4766355140186916, IMAGE_HEIGHT * 0.7242990654205608, IMAGE_WIDTH * 0.48598130841121495, IMAGE_HEIGHT * 0.7383177570093458, IMAGE_WIDTH * 0.5, IMAGE_HEIGHT * 0.7383177570093458);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5093457943925234, IMAGE_HEIGHT * 0.7383177570093458, IMAGE_WIDTH * 0.5186915887850467, IMAGE_HEIGHT * 0.7242990654205608, IMAGE_WIDTH * 0.5186915887850467, IMAGE_HEIGHT * 0.7149532710280374);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5186915887850467, IMAGE_HEIGHT * 0.7149532710280374, IMAGE_WIDTH * 0.5186915887850467, IMAGE_HEIGHT * 0.6588785046728972, IMAGE_WIDTH * 0.5186915887850467, IMAGE_HEIGHT * 0.6588785046728972);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5186915887850467, IMAGE_HEIGHT * 0.6588785046728972, IMAGE_WIDTH * 0.5420560747663551, IMAGE_HEIGHT * 0.6822429906542056, IMAGE_WIDTH * 0.5420560747663551, IMAGE_HEIGHT * 0.6822429906542056);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5467289719626168, IMAGE_HEIGHT * 0.6869158878504673, IMAGE_WIDTH * 0.5560747663551402, IMAGE_HEIGHT * 0.6869158878504673, IMAGE_WIDTH * 0.5607476635514018, IMAGE_HEIGHT * 0.6822429906542056);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5700934579439252, IMAGE_HEIGHT * 0.677570093457944, IMAGE_WIDTH * 0.5700934579439252, IMAGE_HEIGHT * 0.6682242990654206, IMAGE_WIDTH * 0.5607476635514018, IMAGE_HEIGHT * 0.6588785046728972);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5607476635514018, IMAGE_HEIGHT * 0.6588785046728972, IMAGE_WIDTH * 0.5233644859813084, IMAGE_HEIGHT * 0.6214953271028038, IMAGE_WIDTH * 0.5233644859813084, IMAGE_HEIGHT * 0.6214953271028038);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5233644859813084, IMAGE_HEIGHT * 0.6214953271028038, IMAGE_WIDTH * 0.5186915887850467, IMAGE_HEIGHT * 0.616822429906542, IMAGE_WIDTH * 0.5186915887850467, IMAGE_HEIGHT * 0.616822429906542);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5186915887850467, IMAGE_HEIGHT * 0.616822429906542, IMAGE_WIDTH * 0.5186915887850467, IMAGE_HEIGHT * 0.5420560747663551, IMAGE_WIDTH * 0.5186915887850467, IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5186915887850467, IMAGE_HEIGHT * 0.5420560747663551, IMAGE_WIDTH * 0.5794392523364486, IMAGE_HEIGHT * 0.5841121495327103, IMAGE_WIDTH * 0.5794392523364486, IMAGE_HEIGHT * 0.5841121495327103);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5794392523364486, IMAGE_HEIGHT * 0.5887850467289719, IMAGE_WIDTH * 0.5794392523364486, IMAGE_HEIGHT * 0.5887850467289719, IMAGE_WIDTH * 0.5794392523364486, IMAGE_HEIGHT * 0.5934579439252337);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5794392523364486, IMAGE_HEIGHT * 0.5934579439252337, IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.6448598130841121, IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.6448598130841121);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.6542056074766355, IMAGE_WIDTH * 0.5981308411214953, IMAGE_HEIGHT * 0.6588785046728972, IMAGE_WIDTH * 0.6074766355140186, IMAGE_HEIGHT * 0.6588785046728972);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6121495327102804, IMAGE_HEIGHT * 0.6588785046728972, IMAGE_WIDTH * 0.616822429906542, IMAGE_HEIGHT * 0.6495327102803738, IMAGE_WIDTH * 0.616822429906542, IMAGE_HEIGHT * 0.6401869158878505);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.616822429906542, IMAGE_HEIGHT * 0.6401869158878505, IMAGE_WIDTH * 0.6121495327102804, IMAGE_HEIGHT * 0.6074766355140186, IMAGE_WIDTH * 0.6121495327102804, IMAGE_HEIGHT * 0.6074766355140186);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6121495327102804, IMAGE_HEIGHT * 0.6074766355140186, IMAGE_WIDTH * 0.6588785046728972, IMAGE_HEIGHT * 0.6401869158878505, IMAGE_WIDTH * 0.6588785046728972, IMAGE_HEIGHT * 0.6401869158878505);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6682242990654206, IMAGE_HEIGHT * 0.6495327102803738, IMAGE_WIDTH * 0.6822429906542056, IMAGE_HEIGHT * 0.6448598130841121, IMAGE_WIDTH * 0.6869158878504673, IMAGE_HEIGHT * 0.6355140186915887);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6962616822429907, IMAGE_HEIGHT * 0.6261682242990654, IMAGE_WIDTH * 0.6915887850467289, IMAGE_HEIGHT * 0.6121495327102804, IMAGE_WIDTH * 0.6822429906542056, IMAGE_HEIGHT * 0.6074766355140186);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6822429906542056, IMAGE_HEIGHT * 0.6074766355140186, IMAGE_WIDTH * 0.6355140186915887, IMAGE_HEIGHT * 0.5747663551401869, IMAGE_WIDTH * 0.6355140186915887, IMAGE_HEIGHT * 0.5747663551401869);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6355140186915887, IMAGE_HEIGHT * 0.5747663551401869, IMAGE_WIDTH * 0.6682242990654206, IMAGE_HEIGHT * 0.5654205607476636, IMAGE_WIDTH * 0.6682242990654206, IMAGE_HEIGHT * 0.5654205607476636);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.677570093457944, IMAGE_HEIGHT * 0.5654205607476636, IMAGE_WIDTH * 0.6822429906542056, IMAGE_HEIGHT * 0.5607476635514018, IMAGE_WIDTH * 0.6822429906542056, IMAGE_HEIGHT * 0.5514018691588785);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.677570093457944, IMAGE_HEIGHT * 0.5420560747663551, IMAGE_WIDTH * 0.6728971962616822, IMAGE_HEIGHT * 0.5373831775700935, IMAGE_WIDTH * 0.6635514018691588, IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6635514018691588, IMAGE_HEIGHT * 0.5420560747663551, IMAGE_WIDTH * 0.6074766355140186, IMAGE_HEIGHT * 0.5514018691588785, IMAGE_WIDTH * 0.6074766355140186, IMAGE_HEIGHT * 0.5514018691588785);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6074766355140186, IMAGE_HEIGHT * 0.5514018691588785, IMAGE_WIDTH * 0.6074766355140186, IMAGE_HEIGHT * 0.5514018691588785, IMAGE_WIDTH * 0.602803738317757, IMAGE_HEIGHT * 0.5514018691588785);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.602803738317757, IMAGE_HEIGHT * 0.5514018691588785, IMAGE_WIDTH * 0.5327102803738317, IMAGE_HEIGHT * 0.5046728971962616, IMAGE_WIDTH * 0.5327102803738317, IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5327102803738317, IMAGE_HEIGHT * 0.5046728971962616, IMAGE_WIDTH * 0.602803738317757, IMAGE_HEIGHT * 0.4532710280373832, IMAGE_WIDTH * 0.602803738317757, IMAGE_HEIGHT * 0.4532710280373832);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6074766355140186, IMAGE_HEIGHT * 0.4532710280373832, IMAGE_WIDTH * 0.6074766355140186, IMAGE_HEIGHT * 0.4532710280373832, IMAGE_WIDTH * 0.6074766355140186, IMAGE_HEIGHT * 0.4532710280373832);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6074766355140186, IMAGE_HEIGHT * 0.4532710280373832, IMAGE_WIDTH * 0.6635514018691588, IMAGE_HEIGHT * 0.46261682242990654, IMAGE_WIDTH * 0.6635514018691588, IMAGE_HEIGHT * 0.46261682242990654);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6728971962616822, IMAGE_HEIGHT * 0.4672897196261682, IMAGE_WIDTH * 0.677570093457944, IMAGE_HEIGHT * 0.46261682242990654, IMAGE_WIDTH * 0.6822429906542056, IMAGE_HEIGHT * 0.4532710280373832);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6822429906542056, IMAGE_HEIGHT * 0.4439252336448598, IMAGE_WIDTH * 0.677570093457944, IMAGE_HEIGHT * 0.4392523364485981, IMAGE_WIDTH * 0.6682242990654206, IMAGE_HEIGHT * 0.4392523364485981);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6682242990654206, IMAGE_HEIGHT * 0.4392523364485981, IMAGE_WIDTH * 0.6355140186915887, IMAGE_HEIGHT * 0.42990654205607476, IMAGE_WIDTH * 0.6355140186915887, IMAGE_HEIGHT * 0.42990654205607476);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6355140186915887, IMAGE_HEIGHT * 0.42990654205607476, IMAGE_WIDTH * 0.6822429906542056, IMAGE_HEIGHT * 0.397196261682243, IMAGE_WIDTH * 0.6822429906542056, IMAGE_HEIGHT * 0.397196261682243);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6915887850467289, IMAGE_HEIGHT * 0.3925233644859813, IMAGE_WIDTH * 0.6962616822429907, IMAGE_HEIGHT * 0.37850467289719625, IMAGE_WIDTH * 0.6869158878504673, IMAGE_HEIGHT * 0.3691588785046729);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6822429906542056, IMAGE_HEIGHT * 0.3598130841121495, IMAGE_WIDTH * 0.6682242990654206, IMAGE_HEIGHT * 0.35514018691588783, IMAGE_WIDTH * 0.6588785046728972, IMAGE_HEIGHT * 0.3644859813084112);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6588785046728972, IMAGE_HEIGHT * 0.3644859813084112, IMAGE_WIDTH * 0.6121495327102804, IMAGE_HEIGHT * 0.397196261682243, IMAGE_WIDTH * 0.6121495327102804, IMAGE_HEIGHT * 0.397196261682243);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6121495327102804, IMAGE_HEIGHT * 0.397196261682243, IMAGE_WIDTH * 0.616822429906542, IMAGE_HEIGHT * 0.3644859813084112, IMAGE_WIDTH * 0.616822429906542, IMAGE_HEIGHT * 0.3644859813084112);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.616822429906542, IMAGE_HEIGHT * 0.35514018691588783, IMAGE_WIDTH * 0.6121495327102804, IMAGE_HEIGHT * 0.34579439252336447, IMAGE_WIDTH * 0.6074766355140186, IMAGE_HEIGHT * 0.34579439252336447);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5981308411214953, IMAGE_HEIGHT * 0.34579439252336447, IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.35046728971962615, IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.3598130841121495);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.3598130841121495, IMAGE_WIDTH * 0.5794392523364486, IMAGE_HEIGHT * 0.411214953271028, IMAGE_WIDTH * 0.5794392523364486, IMAGE_HEIGHT * 0.411214953271028);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5794392523364486, IMAGE_HEIGHT * 0.4158878504672897, IMAGE_WIDTH * 0.5794392523364486, IMAGE_HEIGHT * 0.4158878504672897, IMAGE_WIDTH * 0.5794392523364486, IMAGE_HEIGHT * 0.4205607476635514);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5794392523364486, IMAGE_HEIGHT * 0.4205607476635514, IMAGE_WIDTH * 0.5186915887850467, IMAGE_HEIGHT * 0.46261682242990654, IMAGE_WIDTH * 0.5186915887850467, IMAGE_HEIGHT * 0.46261682242990654);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5186915887850467, IMAGE_HEIGHT * 0.46261682242990654, IMAGE_WIDTH * 0.5186915887850467, IMAGE_HEIGHT * 0.3878504672897196, IMAGE_WIDTH * 0.5186915887850467, IMAGE_HEIGHT * 0.3878504672897196);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5186915887850467, IMAGE_HEIGHT * 0.3878504672897196, IMAGE_WIDTH * 0.5233644859813084, IMAGE_HEIGHT * 0.38317757009345793, IMAGE_WIDTH * 0.5233644859813084, IMAGE_HEIGHT * 0.38317757009345793);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5233644859813084, IMAGE_HEIGHT * 0.38317757009345793, IMAGE_WIDTH * 0.5607476635514018, IMAGE_HEIGHT * 0.34579439252336447, IMAGE_WIDTH * 0.5607476635514018, IMAGE_HEIGHT * 0.34579439252336447);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5700934579439252, IMAGE_HEIGHT * 0.3364485981308411, IMAGE_WIDTH * 0.5700934579439252, IMAGE_HEIGHT * 0.32710280373831774, IMAGE_WIDTH * 0.5607476635514018, IMAGE_HEIGHT * 0.32242990654205606);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5560747663551402, IMAGE_HEIGHT * 0.3177570093457944, IMAGE_WIDTH * 0.5467289719626168, IMAGE_HEIGHT * 0.3177570093457944, IMAGE_WIDTH * 0.5420560747663551, IMAGE_HEIGHT * 0.32242990654205606);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5420560747663551, IMAGE_HEIGHT * 0.32242990654205606, IMAGE_WIDTH * 0.5186915887850467, IMAGE_HEIGHT * 0.34579439252336447, IMAGE_WIDTH * 0.5186915887850467, IMAGE_HEIGHT * 0.34579439252336447);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5186915887850467, IMAGE_HEIGHT * 0.34579439252336447, IMAGE_WIDTH * 0.5186915887850467, IMAGE_HEIGHT * 0.2897196261682243, IMAGE_WIDTH * 0.5186915887850467, IMAGE_HEIGHT * 0.2897196261682243);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5186915887850467, IMAGE_HEIGHT * 0.2803738317757009, IMAGE_WIDTH * 0.5093457943925234, IMAGE_HEIGHT * 0.27102803738317754, IMAGE_WIDTH * 0.5, IMAGE_HEIGHT * 0.27102803738317754);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.48598130841121495, IMAGE_HEIGHT * 0.27102803738317754, IMAGE_WIDTH * 0.4766355140186916, IMAGE_HEIGHT * 0.2803738317757009, IMAGE_WIDTH * 0.4766355140186916, IMAGE_HEIGHT * 0.2897196261682243);
                SYMBOL.closePath();
                break;

            case BREAK:
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(Path2D.WIND_EVEN_ODD);
                SYMBOL.moveTo(IMAGE_WIDTH * 0.35046728971962615, IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.35046728971962615, IMAGE_HEIGHT * 0.4205607476635514, IMAGE_WIDTH * 0.4205607476635514, IMAGE_HEIGHT * 0.35046728971962615, IMAGE_WIDTH * 0.5046728971962616, IMAGE_HEIGHT * 0.35046728971962615);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.35046728971962615, IMAGE_WIDTH * 0.6542056074766355, IMAGE_HEIGHT * 0.4205607476635514, IMAGE_WIDTH * 0.6542056074766355, IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6542056074766355, IMAGE_HEIGHT * 0.5841121495327103, IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.6542056074766355, IMAGE_WIDTH * 0.5046728971962616, IMAGE_HEIGHT * 0.6542056074766355);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4205607476635514, IMAGE_HEIGHT * 0.6542056074766355, IMAGE_WIDTH * 0.35046728971962615, IMAGE_HEIGHT * 0.5841121495327103, IMAGE_WIDTH * 0.35046728971962615, IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.32242990654205606, IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.32242990654205606, IMAGE_HEIGHT * 0.602803738317757, IMAGE_WIDTH * 0.40186915887850466, IMAGE_HEIGHT * 0.6822429906542056, IMAGE_WIDTH * 0.5046728971962616, IMAGE_HEIGHT * 0.6822429906542056);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.602803738317757, IMAGE_HEIGHT * 0.6822429906542056, IMAGE_WIDTH * 0.6822429906542056, IMAGE_HEIGHT * 0.602803738317757, IMAGE_WIDTH * 0.6822429906542056, IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6822429906542056, IMAGE_HEIGHT * 0.40186915887850466, IMAGE_WIDTH * 0.602803738317757, IMAGE_HEIGHT * 0.32242990654205606, IMAGE_WIDTH * 0.5046728971962616, IMAGE_HEIGHT * 0.32242990654205606);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.40186915887850466, IMAGE_HEIGHT * 0.32242990654205606, IMAGE_WIDTH * 0.32242990654205606, IMAGE_HEIGHT * 0.40186915887850466, IMAGE_WIDTH * 0.32242990654205606, IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.4719626168224299, IMAGE_HEIGHT * 0.5747663551401869);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4719626168224299, IMAGE_HEIGHT * 0.5934579439252337, IMAGE_WIDTH * 0.48598130841121495, IMAGE_HEIGHT * 0.6074766355140186, IMAGE_WIDTH * 0.5046728971962616, IMAGE_HEIGHT * 0.6074766355140186);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5233644859813084, IMAGE_HEIGHT * 0.6074766355140186, IMAGE_WIDTH * 0.5373831775700935, IMAGE_HEIGHT * 0.5934579439252337, IMAGE_WIDTH * 0.5373831775700935, IMAGE_HEIGHT * 0.5747663551401869);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5373831775700935, IMAGE_HEIGHT * 0.5560747663551402, IMAGE_WIDTH * 0.5233644859813084, IMAGE_HEIGHT * 0.5420560747663551, IMAGE_WIDTH * 0.5046728971962616, IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.48598130841121495, IMAGE_HEIGHT * 0.5420560747663551, IMAGE_WIDTH * 0.4719626168224299, IMAGE_HEIGHT * 0.5560747663551402, IMAGE_WIDTH * 0.4719626168224299, IMAGE_HEIGHT * 0.5747663551401869);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.48130841121495327, IMAGE_HEIGHT * 0.37850467289719625);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.49065420560747663, IMAGE_HEIGHT * 0.5233644859813084);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.5186915887850467, IMAGE_HEIGHT * 0.5233644859813084);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.5280373831775701, IMAGE_HEIGHT * 0.37850467289719625);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.48130841121495327, IMAGE_HEIGHT * 0.37850467289719625);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.6588785046728972, IMAGE_HEIGHT * 0.3364485981308411);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6401869158878505, IMAGE_HEIGHT * 0.3317757009345794, IMAGE_WIDTH * 0.6355140186915887, IMAGE_HEIGHT * 0.3411214953271028, IMAGE_WIDTH * 0.6355140186915887, IMAGE_HEIGHT * 0.35514018691588783);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6822429906542056, IMAGE_HEIGHT * 0.3925233644859813, IMAGE_WIDTH * 0.705607476635514, IMAGE_HEIGHT * 0.4439252336448598, IMAGE_WIDTH * 0.705607476635514, IMAGE_HEIGHT * 0.5);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.705607476635514, IMAGE_HEIGHT * 0.5514018691588785, IMAGE_WIDTH * 0.6822429906542056, IMAGE_HEIGHT * 0.602803738317757, IMAGE_WIDTH * 0.6448598130841121, IMAGE_HEIGHT * 0.6448598130841121);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6355140186915887, IMAGE_HEIGHT * 0.6635514018691588, IMAGE_WIDTH * 0.6495327102803738, IMAGE_HEIGHT * 0.6682242990654206, IMAGE_WIDTH * 0.6588785046728972, IMAGE_HEIGHT * 0.6635514018691588);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6915887850467289, IMAGE_HEIGHT * 0.6448598130841121, IMAGE_WIDTH * 0.7336448598130841, IMAGE_HEIGHT * 0.5700934579439252, IMAGE_WIDTH * 0.7336448598130841, IMAGE_HEIGHT * 0.5);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.7336448598130841, IMAGE_HEIGHT * 0.4252336448598131, IMAGE_WIDTH * 0.6962616822429907, IMAGE_HEIGHT * 0.3691588785046729, IMAGE_WIDTH * 0.6588785046728972, IMAGE_HEIGHT * 0.3364485981308411);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.34579439252336447, IMAGE_HEIGHT * 0.3364485981308411);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.308411214953271, IMAGE_HEIGHT * 0.3691588785046729, IMAGE_WIDTH * 0.26635514018691586, IMAGE_HEIGHT * 0.4252336448598131, IMAGE_WIDTH * 0.26635514018691586, IMAGE_HEIGHT * 0.5);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.26635514018691586, IMAGE_HEIGHT * 0.5700934579439252, IMAGE_WIDTH * 0.3130841121495327, IMAGE_HEIGHT * 0.6448598130841121, IMAGE_WIDTH * 0.3411214953271028, IMAGE_HEIGHT * 0.6635514018691588);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.35514018691588783, IMAGE_HEIGHT * 0.6682242990654206, IMAGE_WIDTH * 0.3644859813084112, IMAGE_HEIGHT * 0.6635514018691588, IMAGE_WIDTH * 0.3598130841121495, IMAGE_HEIGHT * 0.6448598130841121);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.3177570093457944, IMAGE_HEIGHT * 0.602803738317757, IMAGE_WIDTH * 0.29906542056074764, IMAGE_HEIGHT * 0.5514018691588785, IMAGE_WIDTH * 0.29906542056074764, IMAGE_HEIGHT * 0.5);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.29906542056074764, IMAGE_HEIGHT * 0.4439252336448598, IMAGE_WIDTH * 0.32242990654205606, IMAGE_HEIGHT * 0.3925233644859813, IMAGE_WIDTH * 0.3644859813084112, IMAGE_HEIGHT * 0.35514018691588783);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.3691588785046729, IMAGE_HEIGHT * 0.3411214953271028, IMAGE_WIDTH * 0.3598130841121495, IMAGE_HEIGHT * 0.3317757009345794, IMAGE_WIDTH * 0.34579439252336447, IMAGE_HEIGHT * 0.3364485981308411);
                SYMBOL.closePath();
                break;

            case ABS:
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(Path2D.WIND_EVEN_ODD);
                SYMBOL.moveTo(IMAGE_WIDTH * 0.35046728971962615, IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.35046728971962615, IMAGE_HEIGHT * 0.4205607476635514, IMAGE_WIDTH * 0.4205607476635514, IMAGE_HEIGHT * 0.35046728971962615, IMAGE_WIDTH * 0.5046728971962616, IMAGE_HEIGHT * 0.35046728971962615);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.35046728971962615, IMAGE_WIDTH * 0.6542056074766355, IMAGE_HEIGHT * 0.4205607476635514, IMAGE_WIDTH * 0.6542056074766355, IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6542056074766355, IMAGE_HEIGHT * 0.5841121495327103, IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.6542056074766355, IMAGE_WIDTH * 0.5046728971962616, IMAGE_HEIGHT * 0.6542056074766355);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4205607476635514, IMAGE_HEIGHT * 0.6542056074766355, IMAGE_WIDTH * 0.35046728971962615, IMAGE_HEIGHT * 0.5841121495327103, IMAGE_WIDTH * 0.35046728971962615, IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.32242990654205606, IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.32242990654205606, IMAGE_HEIGHT * 0.602803738317757, IMAGE_WIDTH * 0.40186915887850466, IMAGE_HEIGHT * 0.6822429906542056, IMAGE_WIDTH * 0.5046728971962616, IMAGE_HEIGHT * 0.6822429906542056);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.602803738317757, IMAGE_HEIGHT * 0.6822429906542056, IMAGE_WIDTH * 0.6822429906542056, IMAGE_HEIGHT * 0.602803738317757, IMAGE_WIDTH * 0.6822429906542056, IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6822429906542056, IMAGE_HEIGHT * 0.40186915887850466, IMAGE_WIDTH * 0.602803738317757, IMAGE_HEIGHT * 0.32242990654205606, IMAGE_WIDTH * 0.5046728971962616, IMAGE_HEIGHT * 0.32242990654205606);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.40186915887850466, IMAGE_HEIGHT * 0.32242990654205606, IMAGE_WIDTH * 0.32242990654205606, IMAGE_HEIGHT * 0.40186915887850466, IMAGE_WIDTH * 0.32242990654205606, IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.5841121495327103, IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5981308411214953, IMAGE_HEIGHT * 0.5420560747663551, IMAGE_WIDTH * 0.602803738317757, IMAGE_HEIGHT * 0.5420560747663551, IMAGE_WIDTH * 0.6121495327102804, IMAGE_HEIGHT * 0.5373831775700935);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.616822429906542, IMAGE_HEIGHT * 0.5327102803738317, IMAGE_WIDTH * 0.616822429906542, IMAGE_HEIGHT * 0.5233644859813084, IMAGE_WIDTH * 0.616822429906542, IMAGE_HEIGHT * 0.5186915887850467);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.616822429906542, IMAGE_HEIGHT * 0.514018691588785, IMAGE_WIDTH * 0.616822429906542, IMAGE_HEIGHT * 0.5093457943925234, IMAGE_WIDTH * 0.616822429906542, IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6121495327102804, IMAGE_HEIGHT * 0.5, IMAGE_WIDTH * 0.6121495327102804, IMAGE_HEIGHT * 0.5, IMAGE_WIDTH * 0.6074766355140186, IMAGE_HEIGHT * 0.4953271028037383);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.602803738317757, IMAGE_HEIGHT * 0.4953271028037383, IMAGE_WIDTH * 0.5981308411214953, IMAGE_HEIGHT * 0.49065420560747663, IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.49065420560747663);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5794392523364486, IMAGE_HEIGHT * 0.48598130841121495, IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.48598130841121495, IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.48130841121495327);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.48130841121495327, IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.48130841121495327, IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.4766355140186916);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.4766355140186916, IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.4719626168224299, IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5794392523364486, IMAGE_HEIGHT * 0.4719626168224299, IMAGE_WIDTH * 0.5794392523364486, IMAGE_HEIGHT * 0.4719626168224299, IMAGE_WIDTH * 0.5841121495327103, IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.4719626168224299, IMAGE_WIDTH * 0.5934579439252337, IMAGE_HEIGHT * 0.4719626168224299, IMAGE_WIDTH * 0.5934579439252337, IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5981308411214953, IMAGE_HEIGHT * 0.4719626168224299, IMAGE_WIDTH * 0.5981308411214953, IMAGE_HEIGHT * 0.4766355140186916, IMAGE_WIDTH * 0.5981308411214953, IMAGE_HEIGHT * 0.48130841121495327);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5981308411214953, IMAGE_HEIGHT * 0.48130841121495327, IMAGE_WIDTH * 0.616822429906542, IMAGE_HEIGHT * 0.48130841121495327, IMAGE_WIDTH * 0.616822429906542, IMAGE_HEIGHT * 0.48130841121495327);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.616822429906542, IMAGE_HEIGHT * 0.4719626168224299, IMAGE_WIDTH * 0.616822429906542, IMAGE_HEIGHT * 0.46261682242990654, IMAGE_WIDTH * 0.6074766355140186, IMAGE_HEIGHT * 0.45794392523364486);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.602803738317757, IMAGE_HEIGHT * 0.4532710280373832, IMAGE_WIDTH * 0.5981308411214953, IMAGE_HEIGHT * 0.4532710280373832, IMAGE_WIDTH * 0.5841121495327103, IMAGE_HEIGHT * 0.4532710280373832);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5794392523364486, IMAGE_HEIGHT * 0.4532710280373832, IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.4532710280373832, IMAGE_WIDTH * 0.5700934579439252, IMAGE_HEIGHT * 0.4532710280373832);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5654205607476636, IMAGE_HEIGHT * 0.45794392523364486, IMAGE_WIDTH * 0.5607476635514018, IMAGE_HEIGHT * 0.45794392523364486, IMAGE_WIDTH * 0.5560747663551402, IMAGE_HEIGHT * 0.46261682242990654);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5560747663551402, IMAGE_HEIGHT * 0.4672897196261682, IMAGE_WIDTH * 0.5560747663551402, IMAGE_HEIGHT * 0.4719626168224299, IMAGE_WIDTH * 0.5560747663551402, IMAGE_HEIGHT * 0.4766355140186916);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5560747663551402, IMAGE_HEIGHT * 0.48130841121495327, IMAGE_WIDTH * 0.5560747663551402, IMAGE_HEIGHT * 0.48598130841121495, IMAGE_WIDTH * 0.5560747663551402, IMAGE_HEIGHT * 0.49065420560747663);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5607476635514018, IMAGE_HEIGHT * 0.4953271028037383, IMAGE_WIDTH * 0.5607476635514018, IMAGE_HEIGHT * 0.4953271028037383, IMAGE_WIDTH * 0.5654205607476636, IMAGE_HEIGHT * 0.5);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5700934579439252, IMAGE_HEIGHT * 0.5, IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.5046728971962616, IMAGE_WIDTH * 0.5794392523364486, IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.5093457943925234, IMAGE_WIDTH * 0.5934579439252337, IMAGE_HEIGHT * 0.5093457943925234, IMAGE_WIDTH * 0.5934579439252337, IMAGE_HEIGHT * 0.5093457943925234);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5981308411214953, IMAGE_HEIGHT * 0.5093457943925234, IMAGE_WIDTH * 0.5981308411214953, IMAGE_HEIGHT * 0.514018691588785, IMAGE_WIDTH * 0.5981308411214953, IMAGE_HEIGHT * 0.514018691588785);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5981308411214953, IMAGE_HEIGHT * 0.514018691588785, IMAGE_WIDTH * 0.5981308411214953, IMAGE_HEIGHT * 0.514018691588785, IMAGE_WIDTH * 0.5981308411214953, IMAGE_HEIGHT * 0.5186915887850467);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5981308411214953, IMAGE_HEIGHT * 0.5186915887850467, IMAGE_WIDTH * 0.5981308411214953, IMAGE_HEIGHT * 0.5233644859813084, IMAGE_WIDTH * 0.5981308411214953, IMAGE_HEIGHT * 0.5233644859813084);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5934579439252337, IMAGE_HEIGHT * 0.5233644859813084, IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.5233644859813084, IMAGE_WIDTH * 0.5841121495327103, IMAGE_HEIGHT * 0.5233644859813084);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.5233644859813084, IMAGE_WIDTH * 0.5700934579439252, IMAGE_HEIGHT * 0.5233644859813084, IMAGE_WIDTH * 0.5700934579439252, IMAGE_HEIGHT * 0.514018691588785);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5700934579439252, IMAGE_HEIGHT * 0.514018691588785, IMAGE_WIDTH * 0.5514018691588785, IMAGE_HEIGHT * 0.514018691588785, IMAGE_WIDTH * 0.5514018691588785, IMAGE_HEIGHT * 0.514018691588785);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5560747663551402, IMAGE_HEIGHT * 0.5327102803738317, IMAGE_WIDTH * 0.5654205607476636, IMAGE_HEIGHT * 0.5420560747663551, IMAGE_WIDTH * 0.5841121495327103, IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.4719626168224299, IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4719626168224299, IMAGE_HEIGHT * 0.5420560747663551, IMAGE_WIDTH * 0.4953271028037383, IMAGE_HEIGHT * 0.5420560747663551, IMAGE_WIDTH * 0.4953271028037383, IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5093457943925234, IMAGE_HEIGHT * 0.5420560747663551, IMAGE_WIDTH * 0.514018691588785, IMAGE_HEIGHT * 0.5420560747663551, IMAGE_WIDTH * 0.5186915887850467, IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5233644859813084, IMAGE_HEIGHT * 0.5420560747663551, IMAGE_WIDTH * 0.5280373831775701, IMAGE_HEIGHT * 0.5373831775700935, IMAGE_WIDTH * 0.5327102803738317, IMAGE_HEIGHT * 0.5327102803738317);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5327102803738317, IMAGE_HEIGHT * 0.5280373831775701, IMAGE_WIDTH * 0.5373831775700935, IMAGE_HEIGHT * 0.5233644859813084, IMAGE_WIDTH * 0.5373831775700935, IMAGE_HEIGHT * 0.5186915887850467);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5373831775700935, IMAGE_HEIGHT * 0.514018691588785, IMAGE_WIDTH * 0.5327102803738317, IMAGE_HEIGHT * 0.5093457943925234, IMAGE_WIDTH * 0.5327102803738317, IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5280373831775701, IMAGE_HEIGHT * 0.5, IMAGE_WIDTH * 0.5280373831775701, IMAGE_HEIGHT * 0.5, IMAGE_WIDTH * 0.5233644859813084, IMAGE_HEIGHT * 0.4953271028037383);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5280373831775701, IMAGE_HEIGHT * 0.4953271028037383, IMAGE_WIDTH * 0.5280373831775701, IMAGE_HEIGHT * 0.49065420560747663, IMAGE_WIDTH * 0.5327102803738317, IMAGE_HEIGHT * 0.48598130841121495);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5327102803738317, IMAGE_HEIGHT * 0.48598130841121495, IMAGE_WIDTH * 0.5373831775700935, IMAGE_HEIGHT * 0.48130841121495327, IMAGE_WIDTH * 0.5373831775700935, IMAGE_HEIGHT * 0.4766355140186916);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5373831775700935, IMAGE_HEIGHT * 0.4719626168224299, IMAGE_WIDTH * 0.5327102803738317, IMAGE_HEIGHT * 0.4672897196261682, IMAGE_WIDTH * 0.5327102803738317, IMAGE_HEIGHT * 0.46261682242990654);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5280373831775701, IMAGE_HEIGHT * 0.45794392523364486, IMAGE_WIDTH * 0.5280373831775701, IMAGE_HEIGHT * 0.45794392523364486, IMAGE_WIDTH * 0.5233644859813084, IMAGE_HEIGHT * 0.4532710280373832);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5186915887850467, IMAGE_HEIGHT * 0.4532710280373832, IMAGE_WIDTH * 0.514018691588785, IMAGE_HEIGHT * 0.4532710280373832, IMAGE_WIDTH * 0.5046728971962616, IMAGE_HEIGHT * 0.4532710280373832);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5046728971962616, IMAGE_HEIGHT * 0.4532710280373832, IMAGE_WIDTH * 0.4719626168224299, IMAGE_HEIGHT * 0.4532710280373832, IMAGE_WIDTH * 0.4719626168224299, IMAGE_HEIGHT * 0.4532710280373832);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.4719626168224299, IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.4953271028037383, IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5046728971962616, IMAGE_HEIGHT * 0.4719626168224299, IMAGE_WIDTH * 0.5093457943925234, IMAGE_HEIGHT * 0.4719626168224299, IMAGE_WIDTH * 0.5093457943925234, IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.514018691588785, IMAGE_HEIGHT * 0.4719626168224299, IMAGE_WIDTH * 0.514018691588785, IMAGE_HEIGHT * 0.4719626168224299, IMAGE_WIDTH * 0.514018691588785, IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5186915887850467, IMAGE_HEIGHT * 0.4766355140186916, IMAGE_WIDTH * 0.5186915887850467, IMAGE_HEIGHT * 0.4766355140186916, IMAGE_WIDTH * 0.5186915887850467, IMAGE_HEIGHT * 0.48130841121495327);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5186915887850467, IMAGE_HEIGHT * 0.48130841121495327, IMAGE_WIDTH * 0.514018691588785, IMAGE_HEIGHT * 0.48598130841121495, IMAGE_WIDTH * 0.514018691588785, IMAGE_HEIGHT * 0.48598130841121495);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.514018691588785, IMAGE_HEIGHT * 0.48598130841121495, IMAGE_WIDTH * 0.5093457943925234, IMAGE_HEIGHT * 0.48598130841121495, IMAGE_WIDTH * 0.5093457943925234, IMAGE_HEIGHT * 0.48598130841121495);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5093457943925234, IMAGE_HEIGHT * 0.49065420560747663, IMAGE_WIDTH * 0.5046728971962616, IMAGE_HEIGHT * 0.49065420560747663, IMAGE_WIDTH * 0.5, IMAGE_HEIGHT * 0.49065420560747663);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5, IMAGE_HEIGHT * 0.49065420560747663, IMAGE_WIDTH * 0.49065420560747663, IMAGE_HEIGHT * 0.49065420560747663, IMAGE_WIDTH * 0.49065420560747663, IMAGE_HEIGHT * 0.49065420560747663);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.49065420560747663, IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.49065420560747663, IMAGE_HEIGHT * 0.4719626168224299, IMAGE_WIDTH * 0.4953271028037383, IMAGE_HEIGHT * 0.4719626168224299, IMAGE_WIDTH * 0.4953271028037383, IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.5, IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5046728971962616, IMAGE_HEIGHT * 0.5046728971962616, IMAGE_WIDTH * 0.5093457943925234, IMAGE_HEIGHT * 0.5093457943925234, IMAGE_WIDTH * 0.5093457943925234, IMAGE_HEIGHT * 0.5093457943925234);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.514018691588785, IMAGE_HEIGHT * 0.5093457943925234, IMAGE_WIDTH * 0.514018691588785, IMAGE_HEIGHT * 0.5093457943925234, IMAGE_WIDTH * 0.514018691588785, IMAGE_HEIGHT * 0.5093457943925234);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5186915887850467, IMAGE_HEIGHT * 0.514018691588785, IMAGE_WIDTH * 0.5186915887850467, IMAGE_HEIGHT * 0.514018691588785, IMAGE_WIDTH * 0.5186915887850467, IMAGE_HEIGHT * 0.514018691588785);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5186915887850467, IMAGE_HEIGHT * 0.5186915887850467, IMAGE_WIDTH * 0.5186915887850467, IMAGE_HEIGHT * 0.5186915887850467, IMAGE_WIDTH * 0.514018691588785, IMAGE_HEIGHT * 0.5233644859813084);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.514018691588785, IMAGE_HEIGHT * 0.5233644859813084, IMAGE_WIDTH * 0.514018691588785, IMAGE_HEIGHT * 0.5233644859813084, IMAGE_WIDTH * 0.514018691588785, IMAGE_HEIGHT * 0.5233644859813084);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5093457943925234, IMAGE_HEIGHT * 0.5233644859813084, IMAGE_WIDTH * 0.5046728971962616, IMAGE_HEIGHT * 0.5233644859813084, IMAGE_WIDTH * 0.5, IMAGE_HEIGHT * 0.5233644859813084);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5, IMAGE_HEIGHT * 0.5233644859813084, IMAGE_WIDTH * 0.49065420560747663, IMAGE_HEIGHT * 0.5233644859813084, IMAGE_WIDTH * 0.49065420560747663, IMAGE_HEIGHT * 0.5233644859813084);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.49065420560747663, IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.49065420560747663, IMAGE_HEIGHT * 0.5046728971962616, IMAGE_WIDTH * 0.5, IMAGE_HEIGHT * 0.5046728971962616, IMAGE_WIDTH * 0.5, IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.43457943925233644, IMAGE_HEIGHT * 0.4532710280373832);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.4158878504672897, IMAGE_HEIGHT * 0.4532710280373832);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.3878504672897196, IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.40654205607476634, IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.411214953271028, IMAGE_HEIGHT * 0.5233644859813084);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.4392523364485981, IMAGE_HEIGHT * 0.5233644859813084);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.4439252336448598, IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.46261682242990654, IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.43457943925233644, IMAGE_HEIGHT * 0.4532710280373832);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.4158878504672897, IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.4252336448598131, IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.43457943925233644, IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.4158878504672897, IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.6588785046728972, IMAGE_HEIGHT * 0.3364485981308411);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6401869158878505, IMAGE_HEIGHT * 0.3317757009345794, IMAGE_WIDTH * 0.6355140186915887, IMAGE_HEIGHT * 0.3411214953271028, IMAGE_WIDTH * 0.6355140186915887, IMAGE_HEIGHT * 0.35514018691588783);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6822429906542056, IMAGE_HEIGHT * 0.3925233644859813, IMAGE_WIDTH * 0.705607476635514, IMAGE_HEIGHT * 0.4439252336448598, IMAGE_WIDTH * 0.705607476635514, IMAGE_HEIGHT * 0.5);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.705607476635514, IMAGE_HEIGHT * 0.5514018691588785, IMAGE_WIDTH * 0.6822429906542056, IMAGE_HEIGHT * 0.602803738317757, IMAGE_WIDTH * 0.6448598130841121, IMAGE_HEIGHT * 0.6448598130841121);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6355140186915887, IMAGE_HEIGHT * 0.6635514018691588, IMAGE_WIDTH * 0.6495327102803738, IMAGE_HEIGHT * 0.6682242990654206, IMAGE_WIDTH * 0.6588785046728972, IMAGE_HEIGHT * 0.6635514018691588);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6915887850467289, IMAGE_HEIGHT * 0.6448598130841121, IMAGE_WIDTH * 0.7336448598130841, IMAGE_HEIGHT * 0.5700934579439252, IMAGE_WIDTH * 0.7336448598130841, IMAGE_HEIGHT * 0.5);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.7336448598130841, IMAGE_HEIGHT * 0.4252336448598131, IMAGE_WIDTH * 0.6962616822429907, IMAGE_HEIGHT * 0.3691588785046729, IMAGE_WIDTH * 0.6588785046728972, IMAGE_HEIGHT * 0.3364485981308411);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.34579439252336447, IMAGE_HEIGHT * 0.3364485981308411);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.308411214953271, IMAGE_HEIGHT * 0.3691588785046729, IMAGE_WIDTH * 0.26635514018691586, IMAGE_HEIGHT * 0.4252336448598131, IMAGE_WIDTH * 0.26635514018691586, IMAGE_HEIGHT * 0.5);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.26635514018691586, IMAGE_HEIGHT * 0.5700934579439252, IMAGE_WIDTH * 0.3130841121495327, IMAGE_HEIGHT * 0.6448598130841121, IMAGE_WIDTH * 0.3411214953271028, IMAGE_HEIGHT * 0.6635514018691588);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.35514018691588783, IMAGE_HEIGHT * 0.6682242990654206, IMAGE_WIDTH * 0.3644859813084112, IMAGE_HEIGHT * 0.6635514018691588, IMAGE_WIDTH * 0.3598130841121495, IMAGE_HEIGHT * 0.6448598130841121);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.3177570093457944, IMAGE_HEIGHT * 0.602803738317757, IMAGE_WIDTH * 0.29906542056074764, IMAGE_HEIGHT * 0.5514018691588785, IMAGE_WIDTH * 0.29906542056074764, IMAGE_HEIGHT * 0.5);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.29906542056074764, IMAGE_HEIGHT * 0.4439252336448598, IMAGE_WIDTH * 0.32242990654205606, IMAGE_HEIGHT * 0.3925233644859813, IMAGE_WIDTH * 0.3644859813084112, IMAGE_HEIGHT * 0.35514018691588783);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.3691588785046729, IMAGE_HEIGHT * 0.3411214953271028, IMAGE_WIDTH * 0.3598130841121495, IMAGE_HEIGHT * 0.3317757009345794, IMAGE_WIDTH * 0.34579439252336447, IMAGE_HEIGHT * 0.3364485981308411);
                SYMBOL.closePath();
                break;

            case ESP:
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(Path2D.WIND_EVEN_ODD);
                SYMBOL.moveTo(IMAGE_WIDTH * 0.35046728971962615, IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.35046728971962615, IMAGE_HEIGHT * 0.4205607476635514, IMAGE_WIDTH * 0.4205607476635514, IMAGE_HEIGHT * 0.35046728971962615, IMAGE_WIDTH * 0.5046728971962616, IMAGE_HEIGHT * 0.35046728971962615);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.35046728971962615, IMAGE_WIDTH * 0.6542056074766355, IMAGE_HEIGHT * 0.4205607476635514, IMAGE_WIDTH * 0.6542056074766355, IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6542056074766355, IMAGE_HEIGHT * 0.5841121495327103, IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.6542056074766355, IMAGE_WIDTH * 0.5046728971962616, IMAGE_HEIGHT * 0.6542056074766355);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4205607476635514, IMAGE_HEIGHT * 0.6542056074766355, IMAGE_WIDTH * 0.35046728971962615, IMAGE_HEIGHT * 0.5841121495327103, IMAGE_WIDTH * 0.35046728971962615, IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.32242990654205606, IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.32242990654205606, IMAGE_HEIGHT * 0.602803738317757, IMAGE_WIDTH * 0.40186915887850466, IMAGE_HEIGHT * 0.6822429906542056, IMAGE_WIDTH * 0.5046728971962616, IMAGE_HEIGHT * 0.6822429906542056);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.602803738317757, IMAGE_HEIGHT * 0.6822429906542056, IMAGE_WIDTH * 0.6822429906542056, IMAGE_HEIGHT * 0.602803738317757, IMAGE_WIDTH * 0.6822429906542056, IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6822429906542056, IMAGE_HEIGHT * 0.40186915887850466, IMAGE_WIDTH * 0.602803738317757, IMAGE_HEIGHT * 0.32242990654205606, IMAGE_WIDTH * 0.5046728971962616, IMAGE_HEIGHT * 0.32242990654205606);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.40186915887850466, IMAGE_HEIGHT * 0.32242990654205606, IMAGE_WIDTH * 0.32242990654205606, IMAGE_HEIGHT * 0.40186915887850466, IMAGE_WIDTH * 0.32242990654205606, IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.5046728971962616, IMAGE_WIDTH * 0.5794392523364486, IMAGE_HEIGHT * 0.5046728971962616, IMAGE_WIDTH * 0.5794392523364486, IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.5046728971962616, IMAGE_WIDTH * 0.5934579439252337, IMAGE_HEIGHT * 0.5046728971962616, IMAGE_WIDTH * 0.5981308411214953, IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.602803738317757, IMAGE_HEIGHT * 0.5046728971962616, IMAGE_WIDTH * 0.602803738317757, IMAGE_HEIGHT * 0.5, IMAGE_WIDTH * 0.6074766355140186, IMAGE_HEIGHT * 0.4953271028037383);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6074766355140186, IMAGE_HEIGHT * 0.49065420560747663, IMAGE_WIDTH * 0.6074766355140186, IMAGE_HEIGHT * 0.48598130841121495, IMAGE_WIDTH * 0.6074766355140186, IMAGE_HEIGHT * 0.48130841121495327);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6074766355140186, IMAGE_HEIGHT * 0.4719626168224299, IMAGE_WIDTH * 0.6074766355140186, IMAGE_HEIGHT * 0.4672897196261682, IMAGE_WIDTH * 0.6074766355140186, IMAGE_HEIGHT * 0.46261682242990654);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.602803738317757, IMAGE_HEIGHT * 0.45794392523364486, IMAGE_WIDTH * 0.5981308411214953, IMAGE_HEIGHT * 0.4532710280373832, IMAGE_WIDTH * 0.5934579439252337, IMAGE_HEIGHT * 0.4532710280373832);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5934579439252337, IMAGE_HEIGHT * 0.4532710280373832, IMAGE_WIDTH * 0.5841121495327103, IMAGE_HEIGHT * 0.4532710280373832, IMAGE_WIDTH * 0.5794392523364486, IMAGE_HEIGHT * 0.4532710280373832);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5794392523364486, IMAGE_HEIGHT * 0.4532710280373832, IMAGE_WIDTH * 0.5560747663551402, IMAGE_HEIGHT * 0.4532710280373832, IMAGE_WIDTH * 0.5560747663551402, IMAGE_HEIGHT * 0.4532710280373832);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.5560747663551402, IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.5794392523364486, IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5841121495327103, IMAGE_HEIGHT * 0.4719626168224299, IMAGE_WIDTH * 0.5841121495327103, IMAGE_HEIGHT * 0.4719626168224299, IMAGE_WIDTH * 0.5841121495327103, IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.4719626168224299, IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.4719626168224299, IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.4766355140186916, IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.4766355140186916, IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.48130841121495327);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.48130841121495327, IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.48130841121495327, IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.48598130841121495);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.48598130841121495, IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.48598130841121495, IMAGE_WIDTH * 0.5841121495327103, IMAGE_HEIGHT * 0.48598130841121495);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5841121495327103, IMAGE_HEIGHT * 0.48598130841121495, IMAGE_WIDTH * 0.5841121495327103, IMAGE_HEIGHT * 0.49065420560747663, IMAGE_WIDTH * 0.5794392523364486, IMAGE_HEIGHT * 0.49065420560747663);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5794392523364486, IMAGE_HEIGHT * 0.49065420560747663, IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.49065420560747663, IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.49065420560747663);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.4719626168224299, IMAGE_WIDTH * 0.5794392523364486, IMAGE_HEIGHT * 0.4719626168224299, IMAGE_WIDTH * 0.5794392523364486, IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.5093457943925234, IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5233644859813084, IMAGE_HEIGHT * 0.5420560747663551, IMAGE_WIDTH * 0.5327102803738317, IMAGE_HEIGHT * 0.5420560747663551, IMAGE_WIDTH * 0.5373831775700935, IMAGE_HEIGHT * 0.5373831775700935);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5420560747663551, IMAGE_HEIGHT * 0.5327102803738317, IMAGE_WIDTH * 0.5467289719626168, IMAGE_HEIGHT * 0.5233644859813084, IMAGE_WIDTH * 0.5467289719626168, IMAGE_HEIGHT * 0.5186915887850467);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5467289719626168, IMAGE_HEIGHT * 0.514018691588785, IMAGE_WIDTH * 0.5420560747663551, IMAGE_HEIGHT * 0.5093457943925234, IMAGE_WIDTH * 0.5420560747663551, IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5373831775700935, IMAGE_HEIGHT * 0.5, IMAGE_WIDTH * 0.5373831775700935, IMAGE_HEIGHT * 0.5, IMAGE_WIDTH * 0.5327102803738317, IMAGE_HEIGHT * 0.4953271028037383);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5280373831775701, IMAGE_HEIGHT * 0.4953271028037383, IMAGE_WIDTH * 0.5233644859813084, IMAGE_HEIGHT * 0.49065420560747663, IMAGE_WIDTH * 0.514018691588785, IMAGE_HEIGHT * 0.49065420560747663);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5046728971962616, IMAGE_HEIGHT * 0.48598130841121495, IMAGE_WIDTH * 0.5, IMAGE_HEIGHT * 0.48598130841121495, IMAGE_WIDTH * 0.5, IMAGE_HEIGHT * 0.48130841121495327);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5, IMAGE_HEIGHT * 0.48130841121495327, IMAGE_WIDTH * 0.5, IMAGE_HEIGHT * 0.48130841121495327, IMAGE_WIDTH * 0.5, IMAGE_HEIGHT * 0.4766355140186916);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5, IMAGE_HEIGHT * 0.4766355140186916, IMAGE_WIDTH * 0.5, IMAGE_HEIGHT * 0.4719626168224299, IMAGE_WIDTH * 0.5, IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5046728971962616, IMAGE_HEIGHT * 0.4719626168224299, IMAGE_WIDTH * 0.5093457943925234, IMAGE_HEIGHT * 0.4719626168224299, IMAGE_WIDTH * 0.514018691588785, IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.514018691588785, IMAGE_HEIGHT * 0.4719626168224299, IMAGE_WIDTH * 0.5186915887850467, IMAGE_HEIGHT * 0.4719626168224299, IMAGE_WIDTH * 0.5233644859813084, IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5233644859813084, IMAGE_HEIGHT * 0.4719626168224299, IMAGE_WIDTH * 0.5233644859813084, IMAGE_HEIGHT * 0.4766355140186916, IMAGE_WIDTH * 0.5280373831775701, IMAGE_HEIGHT * 0.48130841121495327);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5280373831775701, IMAGE_HEIGHT * 0.48130841121495327, IMAGE_WIDTH * 0.5467289719626168, IMAGE_HEIGHT * 0.48130841121495327, IMAGE_WIDTH * 0.5467289719626168, IMAGE_HEIGHT * 0.48130841121495327);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5467289719626168, IMAGE_HEIGHT * 0.4719626168224299, IMAGE_WIDTH * 0.5420560747663551, IMAGE_HEIGHT * 0.46261682242990654, IMAGE_WIDTH * 0.5373831775700935, IMAGE_HEIGHT * 0.45794392523364486);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5280373831775701, IMAGE_HEIGHT * 0.4532710280373832, IMAGE_WIDTH * 0.5233644859813084, IMAGE_HEIGHT * 0.4532710280373832, IMAGE_WIDTH * 0.514018691588785, IMAGE_HEIGHT * 0.4532710280373832);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5046728971962616, IMAGE_HEIGHT * 0.4532710280373832, IMAGE_WIDTH * 0.5, IMAGE_HEIGHT * 0.4532710280373832, IMAGE_WIDTH * 0.4953271028037383, IMAGE_HEIGHT * 0.4532710280373832);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.49065420560747663, IMAGE_HEIGHT * 0.45794392523364486, IMAGE_WIDTH * 0.48598130841121495, IMAGE_HEIGHT * 0.45794392523364486, IMAGE_WIDTH * 0.48598130841121495, IMAGE_HEIGHT * 0.46261682242990654);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.48130841121495327, IMAGE_HEIGHT * 0.4672897196261682, IMAGE_WIDTH * 0.48130841121495327, IMAGE_HEIGHT * 0.4719626168224299, IMAGE_WIDTH * 0.48130841121495327, IMAGE_HEIGHT * 0.4766355140186916);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.48130841121495327, IMAGE_HEIGHT * 0.48130841121495327, IMAGE_WIDTH * 0.48130841121495327, IMAGE_HEIGHT * 0.48598130841121495, IMAGE_WIDTH * 0.48130841121495327, IMAGE_HEIGHT * 0.49065420560747663);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.48598130841121495, IMAGE_HEIGHT * 0.4953271028037383, IMAGE_WIDTH * 0.48598130841121495, IMAGE_HEIGHT * 0.4953271028037383, IMAGE_WIDTH * 0.49065420560747663, IMAGE_HEIGHT * 0.5);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4953271028037383, IMAGE_HEIGHT * 0.5, IMAGE_WIDTH * 0.5, IMAGE_HEIGHT * 0.5046728971962616, IMAGE_WIDTH * 0.5046728971962616, IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.514018691588785, IMAGE_HEIGHT * 0.5093457943925234, IMAGE_WIDTH * 0.5186915887850467, IMAGE_HEIGHT * 0.5093457943925234, IMAGE_WIDTH * 0.5233644859813084, IMAGE_HEIGHT * 0.5093457943925234);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5233644859813084, IMAGE_HEIGHT * 0.5093457943925234, IMAGE_WIDTH * 0.5233644859813084, IMAGE_HEIGHT * 0.514018691588785, IMAGE_WIDTH * 0.5233644859813084, IMAGE_HEIGHT * 0.514018691588785);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5280373831775701, IMAGE_HEIGHT * 0.514018691588785, IMAGE_WIDTH * 0.5280373831775701, IMAGE_HEIGHT * 0.514018691588785, IMAGE_WIDTH * 0.5280373831775701, IMAGE_HEIGHT * 0.5186915887850467);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5280373831775701, IMAGE_HEIGHT * 0.5186915887850467, IMAGE_WIDTH * 0.5233644859813084, IMAGE_HEIGHT * 0.5233644859813084, IMAGE_WIDTH * 0.5233644859813084, IMAGE_HEIGHT * 0.5233644859813084);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5186915887850467, IMAGE_HEIGHT * 0.5233644859813084, IMAGE_WIDTH * 0.514018691588785, IMAGE_HEIGHT * 0.5233644859813084, IMAGE_WIDTH * 0.514018691588785, IMAGE_HEIGHT * 0.5233644859813084);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5046728971962616, IMAGE_HEIGHT * 0.5233644859813084, IMAGE_WIDTH * 0.5, IMAGE_HEIGHT * 0.5233644859813084, IMAGE_WIDTH * 0.4953271028037383, IMAGE_HEIGHT * 0.514018691588785);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4953271028037383, IMAGE_HEIGHT * 0.514018691588785, IMAGE_WIDTH * 0.4766355140186916, IMAGE_HEIGHT * 0.514018691588785, IMAGE_WIDTH * 0.4766355140186916, IMAGE_HEIGHT * 0.514018691588785);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.48130841121495327, IMAGE_HEIGHT * 0.5327102803738317, IMAGE_WIDTH * 0.49065420560747663, IMAGE_HEIGHT * 0.5420560747663551, IMAGE_WIDTH * 0.5093457943925234, IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.46261682242990654, IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.46261682242990654, IMAGE_HEIGHT * 0.5233644859813084);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.4252336448598131, IMAGE_HEIGHT * 0.5233644859813084);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.4252336448598131, IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.46261682242990654, IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.46261682242990654, IMAGE_HEIGHT * 0.49065420560747663);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.4252336448598131, IMAGE_HEIGHT * 0.49065420560747663);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.4252336448598131, IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.46261682242990654, IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.46261682242990654, IMAGE_HEIGHT * 0.4532710280373832);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.40654205607476634, IMAGE_HEIGHT * 0.4532710280373832);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.40654205607476634, IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.46261682242990654, IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.6588785046728972, IMAGE_HEIGHT * 0.3364485981308411);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6401869158878505, IMAGE_HEIGHT * 0.3317757009345794, IMAGE_WIDTH * 0.6355140186915887, IMAGE_HEIGHT * 0.3411214953271028, IMAGE_WIDTH * 0.6355140186915887, IMAGE_HEIGHT * 0.35514018691588783);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6822429906542056, IMAGE_HEIGHT * 0.3925233644859813, IMAGE_WIDTH * 0.705607476635514, IMAGE_HEIGHT * 0.4439252336448598, IMAGE_WIDTH * 0.705607476635514, IMAGE_HEIGHT * 0.5);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.705607476635514, IMAGE_HEIGHT * 0.5514018691588785, IMAGE_WIDTH * 0.6822429906542056, IMAGE_HEIGHT * 0.602803738317757, IMAGE_WIDTH * 0.6448598130841121, IMAGE_HEIGHT * 0.6448598130841121);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6355140186915887, IMAGE_HEIGHT * 0.6635514018691588, IMAGE_WIDTH * 0.6495327102803738, IMAGE_HEIGHT * 0.6682242990654206, IMAGE_WIDTH * 0.6588785046728972, IMAGE_HEIGHT * 0.6635514018691588);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6915887850467289, IMAGE_HEIGHT * 0.6448598130841121, IMAGE_WIDTH * 0.7336448598130841, IMAGE_HEIGHT * 0.5700934579439252, IMAGE_WIDTH * 0.7336448598130841, IMAGE_HEIGHT * 0.5);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.7336448598130841, IMAGE_HEIGHT * 0.4252336448598131, IMAGE_WIDTH * 0.6962616822429907, IMAGE_HEIGHT * 0.3691588785046729, IMAGE_WIDTH * 0.6588785046728972, IMAGE_HEIGHT * 0.3364485981308411);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.34579439252336447, IMAGE_HEIGHT * 0.3364485981308411);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.308411214953271, IMAGE_HEIGHT * 0.3691588785046729, IMAGE_WIDTH * 0.26635514018691586, IMAGE_HEIGHT * 0.4252336448598131, IMAGE_WIDTH * 0.26635514018691586, IMAGE_HEIGHT * 0.5);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.26635514018691586, IMAGE_HEIGHT * 0.5700934579439252, IMAGE_WIDTH * 0.3130841121495327, IMAGE_HEIGHT * 0.6448598130841121, IMAGE_WIDTH * 0.3411214953271028, IMAGE_HEIGHT * 0.6635514018691588);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.35514018691588783, IMAGE_HEIGHT * 0.6682242990654206, IMAGE_WIDTH * 0.3644859813084112, IMAGE_HEIGHT * 0.6635514018691588, IMAGE_WIDTH * 0.3598130841121495, IMAGE_HEIGHT * 0.6448598130841121);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.3177570093457944, IMAGE_HEIGHT * 0.602803738317757, IMAGE_WIDTH * 0.29906542056074764, IMAGE_HEIGHT * 0.5514018691588785, IMAGE_WIDTH * 0.29906542056074764, IMAGE_HEIGHT * 0.5);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.29906542056074764, IMAGE_HEIGHT * 0.4439252336448598, IMAGE_WIDTH * 0.32242990654205606, IMAGE_HEIGHT * 0.3925233644859813, IMAGE_WIDTH * 0.3644859813084112, IMAGE_HEIGHT * 0.35514018691588783);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.3691588785046729, IMAGE_HEIGHT * 0.3411214953271028, IMAGE_WIDTH * 0.3598130841121495, IMAGE_HEIGHT * 0.3317757009345794, IMAGE_WIDTH * 0.34579439252336447, IMAGE_HEIGHT * 0.3364485981308411);
                SYMBOL.closePath();
                break;

            case ATTENTION:
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(Path2D.WIND_EVEN_ODD);
                SYMBOL.moveTo(IMAGE_WIDTH * 0.6962616822429907, IMAGE_HEIGHT * 0.6401869158878505);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.3037383177570093, IMAGE_HEIGHT * 0.6401869158878505);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.5, IMAGE_HEIGHT * 0.2850467289719626);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.6962616822429907, IMAGE_HEIGHT * 0.6401869158878505);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.7336448598130841, IMAGE_HEIGHT * 0.6635514018691588);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.5, IMAGE_HEIGHT * 0.24299065420560748);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.26635514018691586, IMAGE_HEIGHT * 0.6635514018691588);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.7336448598130841, IMAGE_HEIGHT * 0.6635514018691588);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.5841121495327103);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.411214953271028, IMAGE_HEIGHT * 0.5841121495327103);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.5, IMAGE_HEIGHT * 0.411214953271028);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.5841121495327103);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.6355140186915887, IMAGE_HEIGHT * 0.6074766355140186);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.5, IMAGE_HEIGHT * 0.3644859813084112);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.3644859813084112, IMAGE_HEIGHT * 0.6074766355140186);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.6355140186915887, IMAGE_HEIGHT * 0.6074766355140186);
                SYMBOL.closePath();
                break;

            case WIPER:
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(Path2D.WIND_EVEN_ODD);
                SYMBOL.moveTo(IMAGE_WIDTH * 0.42990654205607476, IMAGE_HEIGHT * 0.5794392523364486);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.42990654205607476, IMAGE_HEIGHT * 0.5794392523364486, IMAGE_WIDTH * 0.29906542056074764, IMAGE_HEIGHT * 0.43457943925233644, IMAGE_WIDTH * 0.29906542056074764, IMAGE_HEIGHT * 0.43457943925233644);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.40654205607476634, IMAGE_HEIGHT * 0.3364485981308411, IMAGE_WIDTH * 0.5934579439252337, IMAGE_HEIGHT * 0.3364485981308411, IMAGE_WIDTH * 0.705607476635514, IMAGE_HEIGHT * 0.43457943925233644);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.705607476635514, IMAGE_HEIGHT * 0.43457943925233644, IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.5794392523364486, IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.5794392523364486);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5514018691588785, IMAGE_HEIGHT * 0.5560747663551402, IMAGE_WIDTH * 0.514018691588785, IMAGE_HEIGHT * 0.5514018691588785, IMAGE_WIDTH * 0.4766355140186916, IMAGE_HEIGHT * 0.5560747663551402);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4766355140186916, IMAGE_HEIGHT * 0.5560747663551402, IMAGE_WIDTH * 0.40186915887850466, IMAGE_HEIGHT * 0.4158878504672897, IMAGE_WIDTH * 0.40186915887850466, IMAGE_HEIGHT * 0.4158878504672897);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.40186915887850466, IMAGE_HEIGHT * 0.411214953271028, IMAGE_WIDTH * 0.3925233644859813, IMAGE_HEIGHT * 0.40654205607476634, IMAGE_WIDTH * 0.3878504672897196, IMAGE_HEIGHT * 0.411214953271028);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.37850467289719625, IMAGE_HEIGHT * 0.4158878504672897, IMAGE_WIDTH * 0.37850467289719625, IMAGE_HEIGHT * 0.4252336448598131, IMAGE_WIDTH * 0.38317757009345793, IMAGE_HEIGHT * 0.42990654205607476);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.38317757009345793, IMAGE_HEIGHT * 0.42990654205607476, IMAGE_WIDTH * 0.4532710280373832, IMAGE_HEIGHT * 0.5654205607476636, IMAGE_WIDTH * 0.4532710280373832, IMAGE_HEIGHT * 0.5654205607476636);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4439252336448598, IMAGE_HEIGHT * 0.5700934579439252, IMAGE_WIDTH * 0.43457943925233644, IMAGE_HEIGHT * 0.5747663551401869, IMAGE_WIDTH * 0.42990654205607476, IMAGE_HEIGHT * 0.5794392523364486);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.4205607476635514, IMAGE_HEIGHT * 0.602803738317757);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.43457943925233644, IMAGE_HEIGHT * 0.5934579439252337, IMAGE_WIDTH * 0.4485981308411215, IMAGE_HEIGHT * 0.5841121495327103, IMAGE_WIDTH * 0.46261682242990654, IMAGE_HEIGHT * 0.5794392523364486);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.46261682242990654, IMAGE_HEIGHT * 0.5794392523364486, IMAGE_WIDTH * 0.48130841121495327, IMAGE_HEIGHT * 0.616822429906542, IMAGE_WIDTH * 0.48130841121495327, IMAGE_HEIGHT * 0.616822429906542);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4719626168224299, IMAGE_HEIGHT * 0.6261682242990654, IMAGE_WIDTH * 0.4719626168224299, IMAGE_HEIGHT * 0.6355140186915887, IMAGE_WIDTH * 0.4766355140186916, IMAGE_HEIGHT * 0.6495327102803738);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.48598130841121495, IMAGE_HEIGHT * 0.6635514018691588, IMAGE_WIDTH * 0.5046728971962616, IMAGE_HEIGHT * 0.6682242990654206, IMAGE_WIDTH * 0.5186915887850467, IMAGE_HEIGHT * 0.6588785046728972);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5327102803738317, IMAGE_HEIGHT * 0.6542056074766355, IMAGE_WIDTH * 0.5373831775700935, IMAGE_HEIGHT * 0.6355140186915887, IMAGE_WIDTH * 0.5327102803738317, IMAGE_HEIGHT * 0.6214953271028038);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5233644859813084, IMAGE_HEIGHT * 0.6121495327102804, IMAGE_WIDTH * 0.514018691588785, IMAGE_HEIGHT * 0.602803738317757, IMAGE_WIDTH * 0.5046728971962616, IMAGE_HEIGHT * 0.602803738317757);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5046728971962616, IMAGE_HEIGHT * 0.602803738317757, IMAGE_WIDTH * 0.48598130841121495, IMAGE_HEIGHT * 0.5747663551401869, IMAGE_WIDTH * 0.48598130841121495, IMAGE_HEIGHT * 0.5747663551401869);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5186915887850467, IMAGE_HEIGHT * 0.5700934579439252, IMAGE_WIDTH * 0.5514018691588785, IMAGE_HEIGHT * 0.5794392523364486, IMAGE_WIDTH * 0.5794392523364486, IMAGE_HEIGHT * 0.602803738317757);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5794392523364486, IMAGE_HEIGHT * 0.602803738317757, IMAGE_WIDTH * 0.7336448598130841, IMAGE_HEIGHT * 0.42990654205607476, IMAGE_WIDTH * 0.7336448598130841, IMAGE_HEIGHT * 0.42990654205607476);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5981308411214953, IMAGE_HEIGHT * 0.308411214953271, IMAGE_WIDTH * 0.40186915887850466, IMAGE_HEIGHT * 0.3130841121495327, IMAGE_WIDTH * 0.26635514018691586, IMAGE_HEIGHT * 0.42990654205607476);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.26635514018691586, IMAGE_HEIGHT * 0.42990654205607476, IMAGE_WIDTH * 0.4205607476635514, IMAGE_HEIGHT * 0.602803738317757, IMAGE_WIDTH * 0.4205607476635514, IMAGE_HEIGHT * 0.602803738317757);
                SYMBOL.closePath();
                break;

            case AIRBAG:
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(Path2D.WIND_EVEN_ODD);
                SYMBOL.moveTo(IMAGE_WIDTH * 0.5467289719626168, IMAGE_HEIGHT * 0.4953271028037383);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5420560747663551, IMAGE_HEIGHT * 0.5, IMAGE_WIDTH * 0.5420560747663551, IMAGE_HEIGHT * 0.5046728971962616, IMAGE_WIDTH * 0.5420560747663551, IMAGE_HEIGHT * 0.514018691588785);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5420560747663551, IMAGE_HEIGHT * 0.5186915887850467, IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.5607476635514018, IMAGE_WIDTH * 0.5794392523364486, IMAGE_HEIGHT * 0.5607476635514018);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.5560747663551402, IMAGE_WIDTH * 0.602803738317757, IMAGE_HEIGHT * 0.5280373831775701, IMAGE_WIDTH * 0.6214953271028038, IMAGE_HEIGHT * 0.49065420560747663);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6261682242990654, IMAGE_HEIGHT * 0.4719626168224299, IMAGE_WIDTH * 0.6308411214953271, IMAGE_HEIGHT * 0.4392523364485981, IMAGE_WIDTH * 0.6074766355140186, IMAGE_HEIGHT * 0.43457943925233644);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5794392523364486, IMAGE_HEIGHT * 0.43457943925233644, IMAGE_WIDTH * 0.5467289719626168, IMAGE_HEIGHT * 0.49065420560747663, IMAGE_WIDTH * 0.5467289719626168, IMAGE_HEIGHT * 0.4953271028037383);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.6355140186915887, IMAGE_HEIGHT * 0.4485981308411215);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6401869158878505, IMAGE_HEIGHT * 0.4672897196261682, IMAGE_WIDTH * 0.6355140186915887, IMAGE_HEIGHT * 0.4766355140186916, IMAGE_WIDTH * 0.6355140186915887, IMAGE_HEIGHT * 0.48130841121495327);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6355140186915887, IMAGE_HEIGHT * 0.48598130841121495, IMAGE_WIDTH * 0.6308411214953271, IMAGE_HEIGHT * 0.49065420560747663, IMAGE_WIDTH * 0.6308411214953271, IMAGE_HEIGHT * 0.49065420560747663);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6355140186915887, IMAGE_HEIGHT * 0.5, IMAGE_WIDTH * 0.6542056074766355, IMAGE_HEIGHT * 0.49065420560747663, IMAGE_WIDTH * 0.6542056074766355, IMAGE_HEIGHT * 0.49065420560747663);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6869158878504673, IMAGE_HEIGHT * 0.4672897196261682, IMAGE_WIDTH * 0.7289719626168224, IMAGE_HEIGHT * 0.4439252336448598, IMAGE_WIDTH * 0.7289719626168224, IMAGE_HEIGHT * 0.4439252336448598);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.7336448598130841, IMAGE_HEIGHT * 0.4439252336448598, IMAGE_WIDTH * 0.7383177570093458, IMAGE_HEIGHT * 0.4205607476635514, IMAGE_WIDTH * 0.7242990654205608, IMAGE_HEIGHT * 0.411214953271028);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.719626168224299, IMAGE_HEIGHT * 0.40186915887850466, IMAGE_WIDTH * 0.6962616822429907, IMAGE_HEIGHT * 0.4158878504672897, IMAGE_WIDTH * 0.6869158878504673, IMAGE_HEIGHT * 0.4205607476635514);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6635514018691588, IMAGE_HEIGHT * 0.42990654205607476, IMAGE_WIDTH * 0.6355140186915887, IMAGE_HEIGHT * 0.4485981308411215, IMAGE_WIDTH * 0.6355140186915887, IMAGE_HEIGHT * 0.4485981308411215);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.48598130841121495, IMAGE_HEIGHT * 0.514018691588785);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4766355140186916, IMAGE_HEIGHT * 0.5233644859813084, IMAGE_WIDTH * 0.4719626168224299, IMAGE_HEIGHT * 0.5373831775700935, IMAGE_WIDTH * 0.48130841121495327, IMAGE_HEIGHT * 0.5514018691588785);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.48130841121495327, IMAGE_HEIGHT * 0.5514018691588785, IMAGE_WIDTH * 0.5046728971962616, IMAGE_HEIGHT * 0.616822429906542, IMAGE_WIDTH * 0.5420560747663551, IMAGE_HEIGHT * 0.677570093457944);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5420560747663551, IMAGE_HEIGHT * 0.677570093457944, IMAGE_WIDTH * 0.5700934579439252, IMAGE_HEIGHT * 0.7102803738317757, IMAGE_WIDTH * 0.5981308411214953, IMAGE_HEIGHT * 0.6962616822429907);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6308411214953271, IMAGE_HEIGHT * 0.6728971962616822, IMAGE_WIDTH * 0.616822429906542, IMAGE_HEIGHT * 0.6448598130841121, IMAGE_WIDTH * 0.6121495327102804, IMAGE_HEIGHT * 0.6308411214953271);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5981308411214953, IMAGE_HEIGHT * 0.602803738317757, IMAGE_WIDTH * 0.5233644859813084, IMAGE_HEIGHT * 0.5186915887850467, IMAGE_WIDTH * 0.514018691588785, IMAGE_HEIGHT * 0.514018691588785);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.514018691588785, IMAGE_HEIGHT * 0.514018691588785, IMAGE_WIDTH * 0.5, IMAGE_HEIGHT * 0.5093457943925234, IMAGE_WIDTH * 0.48598130841121495, IMAGE_HEIGHT * 0.514018691588785);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.45794392523364486, IMAGE_HEIGHT * 0.5467289719626168);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4532710280373832, IMAGE_HEIGHT * 0.5467289719626168, IMAGE_WIDTH * 0.4392523364485981, IMAGE_HEIGHT * 0.5420560747663551, IMAGE_WIDTH * 0.411214953271028, IMAGE_HEIGHT * 0.5560747663551402);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.40186915887850466, IMAGE_HEIGHT * 0.5607476635514018, IMAGE_WIDTH * 0.38317757009345793, IMAGE_HEIGHT * 0.5841121495327103, IMAGE_WIDTH * 0.35514018691588783, IMAGE_HEIGHT * 0.6214953271028038);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.3364485981308411, IMAGE_HEIGHT * 0.6448598130841121, IMAGE_WIDTH * 0.3130841121495327, IMAGE_HEIGHT * 0.6822429906542056, IMAGE_WIDTH * 0.3130841121495327, IMAGE_HEIGHT * 0.6869158878504673);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.308411214953271, IMAGE_HEIGHT * 0.7009345794392523, IMAGE_WIDTH * 0.3177570093457944, IMAGE_HEIGHT * 0.7149532710280374, IMAGE_WIDTH * 0.3364485981308411, IMAGE_HEIGHT * 0.7149532710280374);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.35046728971962615, IMAGE_HEIGHT * 0.7149532710280374, IMAGE_WIDTH * 0.397196261682243, IMAGE_HEIGHT * 0.6588785046728972, IMAGE_WIDTH * 0.397196261682243, IMAGE_HEIGHT * 0.6588785046728972);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.397196261682243, IMAGE_HEIGHT * 0.6588785046728972, IMAGE_WIDTH * 0.4158878504672897, IMAGE_HEIGHT * 0.6261682242990654, IMAGE_WIDTH * 0.4485981308411215, IMAGE_HEIGHT * 0.6074766355140186);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4672897196261682, IMAGE_HEIGHT * 0.5981308411214953, IMAGE_WIDTH * 0.48598130841121495, IMAGE_HEIGHT * 0.5981308411214953, IMAGE_WIDTH * 0.48598130841121495, IMAGE_HEIGHT * 0.5981308411214953);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.48598130841121495, IMAGE_HEIGHT * 0.5981308411214953, IMAGE_WIDTH * 0.4766355140186916, IMAGE_HEIGHT * 0.5654205607476636, IMAGE_WIDTH * 0.45794392523364486, IMAGE_HEIGHT * 0.5467289719626168);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.5654205607476636, IMAGE_HEIGHT * 0.3598130841121495);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5654205607476636, IMAGE_HEIGHT * 0.3878504672897196, IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.411214953271028, IMAGE_WIDTH * 0.6214953271028038, IMAGE_HEIGHT * 0.411214953271028);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6495327102803738, IMAGE_HEIGHT * 0.411214953271028, IMAGE_WIDTH * 0.6728971962616822, IMAGE_HEIGHT * 0.3878504672897196, IMAGE_WIDTH * 0.6728971962616822, IMAGE_HEIGHT * 0.3598130841121495);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6728971962616822, IMAGE_HEIGHT * 0.32710280373831774, IMAGE_WIDTH * 0.6495327102803738, IMAGE_HEIGHT * 0.3037383177570093, IMAGE_WIDTH * 0.6214953271028038, IMAGE_HEIGHT * 0.3037383177570093);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5887850467289719, IMAGE_HEIGHT * 0.3037383177570093, IMAGE_WIDTH * 0.5654205607476636, IMAGE_HEIGHT * 0.32710280373831774, IMAGE_WIDTH * 0.5654205607476636, IMAGE_HEIGHT * 0.3598130841121495);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.26635514018691586, IMAGE_HEIGHT * 0.40654205607476634);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.26635514018691586, IMAGE_HEIGHT * 0.4766355140186916, IMAGE_WIDTH * 0.32242990654205606, IMAGE_HEIGHT * 0.5327102803738317, IMAGE_WIDTH * 0.3925233644859813, IMAGE_HEIGHT * 0.5327102803738317);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.46261682242990654, IMAGE_HEIGHT * 0.5327102803738317, IMAGE_WIDTH * 0.5186915887850467, IMAGE_HEIGHT * 0.4766355140186916, IMAGE_WIDTH * 0.5186915887850467, IMAGE_HEIGHT * 0.40654205607476634);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5186915887850467, IMAGE_HEIGHT * 0.3364485981308411, IMAGE_WIDTH * 0.46261682242990654, IMAGE_HEIGHT * 0.2803738317757009, IMAGE_WIDTH * 0.3925233644859813, IMAGE_HEIGHT * 0.2803738317757009);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.32242990654205606, IMAGE_HEIGHT * 0.2803738317757009, IMAGE_WIDTH * 0.26635514018691586, IMAGE_HEIGHT * 0.3364485981308411, IMAGE_WIDTH * 0.26635514018691586, IMAGE_HEIGHT * 0.40654205607476634);
                SYMBOL.closePath();
                break;

            case SEATBELT:
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(Path2D.WIND_EVEN_ODD);
                SYMBOL.moveTo(IMAGE_WIDTH * 0.2897196261682243, IMAGE_HEIGHT * 0.719626168224299);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.29439252336448596, IMAGE_HEIGHT * 0.7242990654205608, IMAGE_WIDTH * 0.3037383177570093, IMAGE_HEIGHT * 0.7242990654205608, IMAGE_WIDTH * 0.3130841121495327, IMAGE_HEIGHT * 0.719626168224299);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.3130841121495327, IMAGE_HEIGHT * 0.719626168224299, IMAGE_WIDTH * 0.3644859813084112, IMAGE_HEIGHT * 0.6682242990654206, IMAGE_WIDTH * 0.3644859813084112, IMAGE_HEIGHT * 0.6682242990654206);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.3644859813084112, IMAGE_HEIGHT * 0.6682242990654206, IMAGE_WIDTH * 0.3644859813084112, IMAGE_HEIGHT * 0.6635514018691588, IMAGE_WIDTH * 0.3691588785046729, IMAGE_HEIGHT * 0.6635514018691588);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.3691588785046729, IMAGE_HEIGHT * 0.6635514018691588, IMAGE_WIDTH * 0.3691588785046729, IMAGE_HEIGHT * 0.6635514018691588, IMAGE_WIDTH * 0.3691588785046729, IMAGE_HEIGHT * 0.6635514018691588);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.3644859813084112, IMAGE_HEIGHT * 0.6635514018691588);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.3644859813084112, IMAGE_HEIGHT * 0.6495327102803738);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.3644859813084112, IMAGE_HEIGHT * 0.6261682242990654);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.3644859813084112, IMAGE_HEIGHT * 0.616822429906542);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.3644859813084112, IMAGE_HEIGHT * 0.616822429906542, IMAGE_WIDTH * 0.2897196261682243, IMAGE_HEIGHT * 0.6915887850467289, IMAGE_WIDTH * 0.2897196261682243, IMAGE_HEIGHT * 0.6915887850467289);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.2803738317757009, IMAGE_HEIGHT * 0.7009345794392523, IMAGE_WIDTH * 0.2803738317757009, IMAGE_HEIGHT * 0.7102803738317757, IMAGE_WIDTH * 0.2897196261682243, IMAGE_HEIGHT * 0.719626168224299);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.616822429906542, IMAGE_HEIGHT * 0.6869158878504673);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6261682242990654, IMAGE_HEIGHT * 0.6962616822429907, IMAGE_WIDTH * 0.6355140186915887, IMAGE_HEIGHT * 0.7102803738317757, IMAGE_WIDTH * 0.6401869158878505, IMAGE_HEIGHT * 0.719626168224299);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6401869158878505, IMAGE_HEIGHT * 0.719626168224299, IMAGE_WIDTH * 0.6682242990654206, IMAGE_HEIGHT * 0.705607476635514, IMAGE_WIDTH * 0.6682242990654206, IMAGE_HEIGHT * 0.705607476635514);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6588785046728972, IMAGE_HEIGHT * 0.6869158878504673, IMAGE_WIDTH * 0.6495327102803738, IMAGE_HEIGHT * 0.6682242990654206, IMAGE_WIDTH * 0.6355140186915887, IMAGE_HEIGHT * 0.6542056074766355);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6308411214953271, IMAGE_HEIGHT * 0.6682242990654206, IMAGE_WIDTH * 0.6261682242990654, IMAGE_HEIGHT * 0.677570093457944, IMAGE_WIDTH * 0.616822429906542, IMAGE_HEIGHT * 0.6869158878504673);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.5607476635514018, IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.5607476635514018, IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.5420560747663551, IMAGE_HEIGHT * 0.45794392523364486);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5467289719626168, IMAGE_HEIGHT * 0.46261682242990654, IMAGE_WIDTH * 0.5514018691588785, IMAGE_HEIGHT * 0.4672897196261682, IMAGE_WIDTH * 0.5607476635514018, IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5607476635514018, IMAGE_HEIGHT * 0.4719626168224299, IMAGE_WIDTH * 0.6214953271028038, IMAGE_HEIGHT * 0.411214953271028, IMAGE_WIDTH * 0.6214953271028038, IMAGE_HEIGHT * 0.411214953271028);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6261682242990654, IMAGE_HEIGHT * 0.40186915887850466, IMAGE_WIDTH * 0.6261682242990654, IMAGE_HEIGHT * 0.3925233644859813, IMAGE_WIDTH * 0.6214953271028038, IMAGE_HEIGHT * 0.38317757009345793);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6121495327102804, IMAGE_HEIGHT * 0.37850467289719625, IMAGE_WIDTH * 0.602803738317757, IMAGE_HEIGHT * 0.37850467289719625, IMAGE_WIDTH * 0.5934579439252337, IMAGE_HEIGHT * 0.38317757009345793);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5934579439252337, IMAGE_HEIGHT * 0.38317757009345793, IMAGE_WIDTH * 0.5327102803738317, IMAGE_HEIGHT * 0.4439252336448598, IMAGE_WIDTH * 0.5327102803738317, IMAGE_HEIGHT * 0.4439252336448598);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5373831775700935, IMAGE_HEIGHT * 0.4485981308411215, IMAGE_WIDTH * 0.5373831775700935, IMAGE_HEIGHT * 0.4532710280373832, IMAGE_WIDTH * 0.5420560747663551, IMAGE_HEIGHT * 0.45794392523364486);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.3691588785046729, IMAGE_HEIGHT * 0.6635514018691588);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.37383177570093457, IMAGE_HEIGHT * 0.6869158878504673, IMAGE_WIDTH * 0.397196261682243, IMAGE_HEIGHT * 0.705607476635514, IMAGE_WIDTH * 0.4252336448598131, IMAGE_HEIGHT * 0.705607476635514);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4252336448598131, IMAGE_HEIGHT * 0.705607476635514, IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.705607476635514, IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.705607476635514);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5934579439252337, IMAGE_HEIGHT * 0.705607476635514, IMAGE_WIDTH * 0.6074766355140186, IMAGE_HEIGHT * 0.6962616822429907, IMAGE_WIDTH * 0.616822429906542, IMAGE_HEIGHT * 0.6869158878504673);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5841121495327103, IMAGE_HEIGHT * 0.6495327102803738, IMAGE_WIDTH * 0.5327102803738317, IMAGE_HEIGHT * 0.6261682242990654, IMAGE_WIDTH * 0.48130841121495327, IMAGE_HEIGHT * 0.6261682242990654);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4392523364485981, IMAGE_HEIGHT * 0.6261682242990654, IMAGE_WIDTH * 0.397196261682243, IMAGE_HEIGHT * 0.6401869158878505, IMAGE_WIDTH * 0.3691588785046729, IMAGE_HEIGHT * 0.6635514018691588);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.6355140186915887, IMAGE_HEIGHT * 0.6542056074766355);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6355140186915887, IMAGE_HEIGHT * 0.6542056074766355, IMAGE_WIDTH * 0.6355140186915887, IMAGE_HEIGHT * 0.6495327102803738, IMAGE_WIDTH * 0.6355140186915887, IMAGE_HEIGHT * 0.6495327102803738);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6355140186915887, IMAGE_HEIGHT * 0.6495327102803738, IMAGE_WIDTH * 0.6355140186915887, IMAGE_HEIGHT * 0.5327102803738317, IMAGE_WIDTH * 0.6355140186915887, IMAGE_HEIGHT * 0.5327102803738317);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6355140186915887, IMAGE_HEIGHT * 0.5, IMAGE_WIDTH * 0.6074766355140186, IMAGE_HEIGHT * 0.4719626168224299, IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.4719626168224299, IMAGE_WIDTH * 0.5700934579439252, IMAGE_HEIGHT * 0.4719626168224299, IMAGE_WIDTH * 0.5607476635514018, IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5607476635514018, IMAGE_HEIGHT * 0.4719626168224299, IMAGE_WIDTH * 0.42990654205607476, IMAGE_HEIGHT * 0.5981308411214953, IMAGE_WIDTH * 0.42990654205607476, IMAGE_HEIGHT * 0.5981308411214953);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4439252336448598, IMAGE_HEIGHT * 0.5934579439252337, IMAGE_WIDTH * 0.46261682242990654, IMAGE_HEIGHT * 0.5934579439252337, IMAGE_WIDTH * 0.48130841121495327, IMAGE_HEIGHT * 0.5934579439252337);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5373831775700935, IMAGE_HEIGHT * 0.5934579439252337, IMAGE_WIDTH * 0.5934579439252337, IMAGE_HEIGHT * 0.616822429906542, IMAGE_WIDTH * 0.6355140186915887, IMAGE_HEIGHT * 0.6542056074766355);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.3644859813084112, IMAGE_HEIGHT * 0.616822429906542);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.3644859813084112, IMAGE_HEIGHT * 0.616822429906542, IMAGE_WIDTH * 0.5327102803738317, IMAGE_HEIGHT * 0.4439252336448598, IMAGE_WIDTH * 0.5327102803738317, IMAGE_HEIGHT * 0.4439252336448598);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5280373831775701, IMAGE_HEIGHT * 0.42990654205607476, IMAGE_WIDTH * 0.5327102803738317, IMAGE_HEIGHT * 0.411214953271028, IMAGE_WIDTH * 0.5327102803738317, IMAGE_HEIGHT * 0.411214953271028);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5420560747663551, IMAGE_HEIGHT * 0.40186915887850466, IMAGE_WIDTH * 0.5514018691588785, IMAGE_HEIGHT * 0.38317757009345793, IMAGE_WIDTH * 0.5560747663551402, IMAGE_HEIGHT * 0.3691588785046729);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5560747663551402, IMAGE_HEIGHT * 0.3691588785046729, IMAGE_WIDTH * 0.5560747663551402, IMAGE_HEIGHT * 0.3691588785046729, IMAGE_WIDTH * 0.5560747663551402, IMAGE_HEIGHT * 0.3691588785046729);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5607476635514018, IMAGE_HEIGHT * 0.3691588785046729, IMAGE_WIDTH * 0.5654205607476636, IMAGE_HEIGHT * 0.34579439252336447, IMAGE_WIDTH * 0.5654205607476636, IMAGE_HEIGHT * 0.34579439252336447);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5654205607476636, IMAGE_HEIGHT * 0.3411214953271028, IMAGE_WIDTH * 0.5654205607476636, IMAGE_HEIGHT * 0.3364485981308411, IMAGE_WIDTH * 0.5607476635514018, IMAGE_HEIGHT * 0.3317757009345794);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5560747663551402, IMAGE_HEIGHT * 0.2897196261682243, IMAGE_WIDTH * 0.5280373831775701, IMAGE_HEIGHT * 0.2570093457943925, IMAGE_WIDTH * 0.4953271028037383, IMAGE_HEIGHT * 0.2570093457943925);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.46261682242990654, IMAGE_HEIGHT * 0.2570093457943925, IMAGE_WIDTH * 0.43457943925233644, IMAGE_HEIGHT * 0.2897196261682243, IMAGE_WIDTH * 0.42990654205607476, IMAGE_HEIGHT * 0.3317757009345794);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4252336448598131, IMAGE_HEIGHT * 0.3364485981308411, IMAGE_WIDTH * 0.4252336448598131, IMAGE_HEIGHT * 0.3411214953271028, IMAGE_WIDTH * 0.4252336448598131, IMAGE_HEIGHT * 0.34579439252336447);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4252336448598131, IMAGE_HEIGHT * 0.34579439252336447, IMAGE_WIDTH * 0.4252336448598131, IMAGE_HEIGHT * 0.3691588785046729, IMAGE_WIDTH * 0.43457943925233644, IMAGE_HEIGHT * 0.3691588785046729);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.43457943925233644, IMAGE_HEIGHT * 0.3691588785046729, IMAGE_WIDTH * 0.43457943925233644, IMAGE_HEIGHT * 0.3691588785046729, IMAGE_WIDTH * 0.43457943925233644, IMAGE_HEIGHT * 0.3691588785046729);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4392523364485981, IMAGE_HEIGHT * 0.38317757009345793, IMAGE_WIDTH * 0.4485981308411215, IMAGE_HEIGHT * 0.40186915887850466, IMAGE_WIDTH * 0.45794392523364486, IMAGE_HEIGHT * 0.411214953271028);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.45794392523364486, IMAGE_HEIGHT * 0.411214953271028, IMAGE_WIDTH * 0.4672897196261682, IMAGE_HEIGHT * 0.4439252336448598, IMAGE_WIDTH * 0.4485981308411215, IMAGE_HEIGHT * 0.46261682242990654);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4392523364485981, IMAGE_HEIGHT * 0.4719626168224299, IMAGE_WIDTH * 0.4252336448598131, IMAGE_HEIGHT * 0.4719626168224299, IMAGE_WIDTH * 0.4252336448598131, IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.3925233644859813, IMAGE_HEIGHT * 0.4719626168224299, IMAGE_WIDTH * 0.3644859813084112, IMAGE_HEIGHT * 0.5, IMAGE_WIDTH * 0.3644859813084112, IMAGE_HEIGHT * 0.5327102803738317);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.3644859813084112, IMAGE_HEIGHT * 0.5327102803738317, IMAGE_WIDTH * 0.3644859813084112, IMAGE_HEIGHT * 0.616822429906542, IMAGE_WIDTH * 0.3644859813084112, IMAGE_HEIGHT * 0.616822429906542);
                SYMBOL.closePath();
                break;

            case AIR_CONDITION:
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(Path2D.WIND_EVEN_ODD);
                SYMBOL.moveTo(IMAGE_WIDTH * 0.4953271028037383, IMAGE_HEIGHT * 0.4766355140186916);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5186915887850467, IMAGE_HEIGHT * 0.4766355140186916, IMAGE_WIDTH * 0.5327102803738317, IMAGE_HEIGHT * 0.49065420560747663, IMAGE_WIDTH * 0.5327102803738317, IMAGE_HEIGHT * 0.514018691588785);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5327102803738317, IMAGE_HEIGHT * 0.5327102803738317, IMAGE_WIDTH * 0.5186915887850467, IMAGE_HEIGHT * 0.5514018691588785, IMAGE_WIDTH * 0.4953271028037383, IMAGE_HEIGHT * 0.5514018691588785);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4766355140186916, IMAGE_HEIGHT * 0.5514018691588785, IMAGE_WIDTH * 0.45794392523364486, IMAGE_HEIGHT * 0.5327102803738317, IMAGE_WIDTH * 0.45794392523364486, IMAGE_HEIGHT * 0.514018691588785);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.45794392523364486, IMAGE_HEIGHT * 0.49065420560747663, IMAGE_WIDTH * 0.4766355140186916, IMAGE_HEIGHT * 0.4766355140186916, IMAGE_WIDTH * 0.4953271028037383, IMAGE_HEIGHT * 0.4766355140186916);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.42990654205607476, IMAGE_HEIGHT * 0.5233644859813084);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.42990654205607476, IMAGE_HEIGHT * 0.5233644859813084, IMAGE_WIDTH * 0.411214953271028, IMAGE_HEIGHT * 0.5280373831775701, IMAGE_WIDTH * 0.411214953271028, IMAGE_HEIGHT * 0.5280373831775701);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.38317757009345793, IMAGE_HEIGHT * 0.5280373831775701, IMAGE_WIDTH * 0.37850467289719625, IMAGE_HEIGHT * 0.5, IMAGE_WIDTH * 0.3317757009345794, IMAGE_HEIGHT * 0.5);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.3130841121495327, IMAGE_HEIGHT * 0.5046728971962616, IMAGE_WIDTH * 0.29439252336448596, IMAGE_HEIGHT * 0.514018691588785, IMAGE_WIDTH * 0.27102803738317754, IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.2570093457943925, IMAGE_HEIGHT * 0.5700934579439252, IMAGE_WIDTH * 0.27102803738317754, IMAGE_HEIGHT * 0.6869158878504673, IMAGE_WIDTH * 0.38317757009345793, IMAGE_HEIGHT * 0.6869158878504673);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.38317757009345793, IMAGE_HEIGHT * 0.6869158878504673, IMAGE_WIDTH * 0.4532710280373832, IMAGE_HEIGHT * 0.6915887850467289, IMAGE_WIDTH * 0.4766355140186916, IMAGE_HEIGHT * 0.6214953271028038);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4766355140186916, IMAGE_HEIGHT * 0.6214953271028038, IMAGE_WIDTH * 0.48598130841121495, IMAGE_HEIGHT * 0.602803738317757, IMAGE_WIDTH * 0.48598130841121495, IMAGE_HEIGHT * 0.5794392523364486);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.48598130841121495, IMAGE_HEIGHT * 0.5794392523364486, IMAGE_WIDTH * 0.49065420560747663, IMAGE_HEIGHT * 0.5794392523364486, IMAGE_WIDTH * 0.4953271028037383, IMAGE_HEIGHT * 0.5794392523364486);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5093457943925234, IMAGE_HEIGHT * 0.5794392523364486, IMAGE_WIDTH * 0.5186915887850467, IMAGE_HEIGHT * 0.5794392523364486, IMAGE_WIDTH * 0.5233644859813084, IMAGE_HEIGHT * 0.5747663551401869);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5233644859813084, IMAGE_HEIGHT * 0.5747663551401869, IMAGE_WIDTH * 0.5280373831775701, IMAGE_HEIGHT * 0.5887850467289719, IMAGE_WIDTH * 0.5280373831775701, IMAGE_HEIGHT * 0.5887850467289719);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5280373831775701, IMAGE_HEIGHT * 0.616822429906542, IMAGE_WIDTH * 0.5, IMAGE_HEIGHT * 0.6214953271028038, IMAGE_WIDTH * 0.5, IMAGE_HEIGHT * 0.6728971962616822);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5046728971962616, IMAGE_HEIGHT * 0.6915887850467289, IMAGE_WIDTH * 0.514018691588785, IMAGE_HEIGHT * 0.705607476635514, IMAGE_WIDTH * 0.5420560747663551, IMAGE_HEIGHT * 0.7289719626168224);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.7429906542056075, IMAGE_WIDTH * 0.6915887850467289, IMAGE_HEIGHT * 0.7289719626168224, IMAGE_WIDTH * 0.6915887850467289, IMAGE_HEIGHT * 0.616822429906542);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6915887850467289, IMAGE_HEIGHT * 0.616822429906542, IMAGE_WIDTH * 0.6915887850467289, IMAGE_HEIGHT * 0.5467289719626168, IMAGE_WIDTH * 0.6214953271028038, IMAGE_HEIGHT * 0.5233644859813084);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6214953271028038, IMAGE_HEIGHT * 0.5233644859813084, IMAGE_WIDTH * 0.5981308411214953, IMAGE_HEIGHT * 0.5046728971962616, IMAGE_WIDTH * 0.5654205607476636, IMAGE_HEIGHT * 0.5093457943925234);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5654205607476636, IMAGE_HEIGHT * 0.5, IMAGE_WIDTH * 0.5607476635514018, IMAGE_HEIGHT * 0.49065420560747663, IMAGE_WIDTH * 0.5560747663551402, IMAGE_HEIGHT * 0.48598130841121495);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5654205607476636, IMAGE_HEIGHT * 0.48130841121495327, IMAGE_WIDTH * 0.5794392523364486, IMAGE_HEIGHT * 0.4766355140186916, IMAGE_WIDTH * 0.5934579439252337, IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.616822429906542, IMAGE_HEIGHT * 0.4719626168224299, IMAGE_WIDTH * 0.6214953271028038, IMAGE_HEIGHT * 0.5, IMAGE_WIDTH * 0.6728971962616822, IMAGE_HEIGHT * 0.5);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6915887850467289, IMAGE_HEIGHT * 0.4953271028037383, IMAGE_WIDTH * 0.7102803738317757, IMAGE_HEIGHT * 0.48598130841121495, IMAGE_WIDTH * 0.7289719626168224, IMAGE_HEIGHT * 0.45794392523364486);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.7429906542056075, IMAGE_HEIGHT * 0.42990654205607476, IMAGE_WIDTH * 0.7289719626168224, IMAGE_HEIGHT * 0.3130841121495327, IMAGE_WIDTH * 0.616822429906542, IMAGE_HEIGHT * 0.3130841121495327);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.616822429906542, IMAGE_HEIGHT * 0.3130841121495327, IMAGE_WIDTH * 0.5514018691588785, IMAGE_HEIGHT * 0.308411214953271, IMAGE_WIDTH * 0.5233644859813084, IMAGE_HEIGHT * 0.37850467289719625);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5233644859813084, IMAGE_HEIGHT * 0.37850467289719625, IMAGE_WIDTH * 0.5046728971962616, IMAGE_HEIGHT * 0.411214953271028, IMAGE_WIDTH * 0.5093457943925234, IMAGE_HEIGHT * 0.4485981308411215);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5046728971962616, IMAGE_HEIGHT * 0.4485981308411215, IMAGE_WIDTH * 0.5, IMAGE_HEIGHT * 0.4485981308411215, IMAGE_WIDTH * 0.4953271028037383, IMAGE_HEIGHT * 0.4485981308411215);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4953271028037383, IMAGE_HEIGHT * 0.4485981308411215, IMAGE_WIDTH * 0.49065420560747663, IMAGE_HEIGHT * 0.4485981308411215, IMAGE_WIDTH * 0.48598130841121495, IMAGE_HEIGHT * 0.4485981308411215);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.48598130841121495, IMAGE_HEIGHT * 0.4392523364485981, IMAGE_WIDTH * 0.4766355140186916, IMAGE_HEIGHT * 0.4252336448598131, IMAGE_WIDTH * 0.4766355140186916, IMAGE_HEIGHT * 0.411214953271028);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4766355140186916, IMAGE_HEIGHT * 0.38317757009345793, IMAGE_WIDTH * 0.5, IMAGE_HEIGHT * 0.37850467289719625, IMAGE_WIDTH * 0.5, IMAGE_HEIGHT * 0.32710280373831774);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5, IMAGE_HEIGHT * 0.308411214953271, IMAGE_WIDTH * 0.48598130841121495, IMAGE_HEIGHT * 0.29439252336448596, IMAGE_WIDTH * 0.45794392523364486, IMAGE_HEIGHT * 0.27102803738317754);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.42990654205607476, IMAGE_HEIGHT * 0.2570093457943925, IMAGE_WIDTH * 0.3130841121495327, IMAGE_HEIGHT * 0.27102803738317754, IMAGE_WIDTH * 0.3130841121495327, IMAGE_HEIGHT * 0.38317757009345793);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.3130841121495327, IMAGE_HEIGHT * 0.38317757009345793, IMAGE_WIDTH * 0.3130841121495327, IMAGE_HEIGHT * 0.4532710280373832, IMAGE_WIDTH * 0.37850467289719625, IMAGE_HEIGHT * 0.4766355140186916);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.37850467289719625, IMAGE_HEIGHT * 0.4766355140186916, IMAGE_WIDTH * 0.40186915887850466, IMAGE_HEIGHT * 0.49065420560747663, IMAGE_WIDTH * 0.43457943925233644, IMAGE_HEIGHT * 0.49065420560747663);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.42990654205607476, IMAGE_HEIGHT * 0.5, IMAGE_WIDTH * 0.42990654205607476, IMAGE_HEIGHT * 0.5046728971962616, IMAGE_WIDTH * 0.42990654205607476, IMAGE_HEIGHT * 0.514018691588785);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.42990654205607476, IMAGE_HEIGHT * 0.5186915887850467, IMAGE_WIDTH * 0.42990654205607476, IMAGE_HEIGHT * 0.5186915887850467, IMAGE_WIDTH * 0.42990654205607476, IMAGE_HEIGHT * 0.5233644859813084);
                SYMBOL.closePath();
                break;
            case SLICKNESS:
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(Path2D.WIND_EVEN_ODD);
                SYMBOL.moveTo(IMAGE_WIDTH * 0.677570093457944, IMAGE_HEIGHT * 0.5467289719626168);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.6355140186915887, IMAGE_HEIGHT * 0.5467289719626168);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6355140186915887, IMAGE_HEIGHT * 0.5467289719626168, IMAGE_WIDTH * 0.6822429906542056, IMAGE_HEIGHT * 0.5700934579439252, IMAGE_WIDTH * 0.677570093457944, IMAGE_HEIGHT * 0.5981308411214953);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.677570093457944, IMAGE_HEIGHT * 0.6261682242990654, IMAGE_WIDTH * 0.5233644859813084, IMAGE_HEIGHT * 0.6355140186915887, IMAGE_WIDTH * 0.5233644859813084, IMAGE_HEIGHT * 0.6728971962616822);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5233644859813084, IMAGE_HEIGHT * 0.705607476635514, IMAGE_WIDTH * 0.5841121495327103, IMAGE_HEIGHT * 0.7242990654205608, IMAGE_WIDTH * 0.5841121495327103, IMAGE_HEIGHT * 0.7242990654205608);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.6355140186915887, IMAGE_HEIGHT * 0.7242990654205608);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6355140186915887, IMAGE_HEIGHT * 0.7242990654205608, IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.6962616822429907, IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.6728971962616822);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5700934579439252, IMAGE_HEIGHT * 0.6495327102803738, IMAGE_WIDTH * 0.7336448598130841, IMAGE_HEIGHT * 0.6308411214953271, IMAGE_WIDTH * 0.7289719626168224, IMAGE_HEIGHT * 0.5981308411214953);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.7289719626168224, IMAGE_HEIGHT * 0.5700934579439252, IMAGE_WIDTH * 0.677570093457944, IMAGE_HEIGHT * 0.5467289719626168, IMAGE_WIDTH * 0.677570093457944, IMAGE_HEIGHT * 0.5467289719626168);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.4205607476635514, IMAGE_HEIGHT * 0.5467289719626168);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.37850467289719625, IMAGE_HEIGHT * 0.5467289719626168);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.37850467289719625, IMAGE_HEIGHT * 0.5467289719626168, IMAGE_WIDTH * 0.4205607476635514, IMAGE_HEIGHT * 0.5700934579439252, IMAGE_WIDTH * 0.4205607476635514, IMAGE_HEIGHT * 0.5981308411214953);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4205607476635514, IMAGE_HEIGHT * 0.6261682242990654, IMAGE_WIDTH * 0.26635514018691586, IMAGE_HEIGHT * 0.6355140186915887, IMAGE_WIDTH * 0.26635514018691586, IMAGE_HEIGHT * 0.6728971962616822);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.26635514018691586, IMAGE_HEIGHT * 0.705607476635514, IMAGE_WIDTH * 0.32710280373831774, IMAGE_HEIGHT * 0.7242990654205608, IMAGE_WIDTH * 0.32710280373831774, IMAGE_HEIGHT * 0.7242990654205608);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.37850467289719625, IMAGE_HEIGHT * 0.7242990654205608);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.37850467289719625, IMAGE_HEIGHT * 0.7242990654205608, IMAGE_WIDTH * 0.3177570093457944, IMAGE_HEIGHT * 0.6962616822429907, IMAGE_WIDTH * 0.3130841121495327, IMAGE_HEIGHT * 0.6728971962616822);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.3130841121495327, IMAGE_HEIGHT * 0.6495327102803738, IMAGE_WIDTH * 0.4719626168224299, IMAGE_HEIGHT * 0.6308411214953271, IMAGE_WIDTH * 0.4719626168224299, IMAGE_HEIGHT * 0.5981308411214953);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4719626168224299, IMAGE_HEIGHT * 0.5700934579439252, IMAGE_WIDTH * 0.4205607476635514, IMAGE_HEIGHT * 0.5467289719626168, IMAGE_WIDTH * 0.4205607476635514, IMAGE_HEIGHT * 0.5467289719626168);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.42990654205607476, IMAGE_HEIGHT * 0.3411214953271028);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.42990654205607476, IMAGE_HEIGHT * 0.3317757009345794);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.46261682242990654, IMAGE_HEIGHT * 0.3130841121495327);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.3130841121495327);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.6074766355140186, IMAGE_HEIGHT * 0.3317757009345794);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.6074766355140186, IMAGE_HEIGHT * 0.3411214953271028);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.42990654205607476, IMAGE_HEIGHT * 0.3411214953271028);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.397196261682243, IMAGE_HEIGHT * 0.37383177570093457);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.6448598130841121, IMAGE_HEIGHT * 0.37383177570093457);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.6448598130841121, IMAGE_HEIGHT * 0.3925233644859813);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.6074766355140186, IMAGE_HEIGHT * 0.3925233644859813);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.6074766355140186, IMAGE_HEIGHT * 0.4158878504672897);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.6588785046728972, IMAGE_HEIGHT * 0.4158878504672897);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.6588785046728972, IMAGE_HEIGHT * 0.4532710280373832);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.3878504672897196, IMAGE_HEIGHT * 0.4532710280373832);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.3878504672897196, IMAGE_HEIGHT * 0.4158878504672897);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.4392523364485981, IMAGE_HEIGHT * 0.4158878504672897);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.4392523364485981, IMAGE_HEIGHT * 0.3925233644859813);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.397196261682243, IMAGE_HEIGHT * 0.3925233644859813);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.397196261682243, IMAGE_HEIGHT * 0.37383177570093457);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.3598130841121495, IMAGE_HEIGHT * 0.5280373831775701);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.40186915887850466, IMAGE_HEIGHT * 0.5280373831775701);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.40186915887850466, IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.4252336448598131, IMAGE_HEIGHT * 0.49065420560747663);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.6261682242990654, IMAGE_HEIGHT * 0.49065420560747663);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.6495327102803738, IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.6495327102803738, IMAGE_HEIGHT * 0.5280373831775701);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.6869158878504673, IMAGE_HEIGHT * 0.5280373831775701);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.6869158878504673, IMAGE_HEIGHT * 0.37850467289719625);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.719626168224299, IMAGE_HEIGHT * 0.3691588785046729);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.7102803738317757, IMAGE_HEIGHT * 0.35046728971962615);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.6682242990654206, IMAGE_HEIGHT * 0.35046728971962615);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.602803738317757, IMAGE_HEIGHT * 0.2803738317757009);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.4392523364485981, IMAGE_HEIGHT * 0.2803738317757009);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.38317757009345793, IMAGE_HEIGHT * 0.35046728971962615);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.3364485981308411, IMAGE_HEIGHT * 0.35046728971962615);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.32710280373831774, IMAGE_HEIGHT * 0.3691588785046729);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.3598130841121495, IMAGE_HEIGHT * 0.37383177570093457);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.3598130841121495, IMAGE_HEIGHT * 0.5280373831775701);
                SYMBOL.closePath();
                break;

            case ARROW_NORTH:
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(Path2D.WIND_EVEN_ODD);
                SYMBOL.moveTo(0.616822429906542 * IMAGE_WIDTH, 0.6962616822429907 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.3878504672897196 * IMAGE_WIDTH, 0.6962616822429907 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.3878504672897196 * IMAGE_WIDTH, 0.5794392523364486 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.26635514018691586 * IMAGE_WIDTH, 0.5794392523364486 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.5046728971962616 * IMAGE_WIDTH, 0.3130841121495327 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.7336448598130841 * IMAGE_WIDTH, 0.5794392523364486 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.616822429906542 * IMAGE_WIDTH, 0.5794392523364486 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.616822429906542 * IMAGE_WIDTH, 0.6962616822429907 * IMAGE_HEIGHT);
                SYMBOL.closePath();
                break;

            case ARROW_NORTH_EAST:
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(Path2D.WIND_EVEN_ODD);
                SYMBOL.moveTo(0.49065420560747663 * IMAGE_WIDTH, 0.6822429906542056 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.32710280373831774 * IMAGE_WIDTH, 0.5186915887850467 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.411214953271028 * IMAGE_WIDTH, 0.43457943925233644 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.32710280373831774 * IMAGE_WIDTH, 0.35046728971962615 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.6728971962616822 * IMAGE_WIDTH, 0.32242990654205606 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.6542056074766355 * IMAGE_WIDTH, 0.6822429906542056 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.5747663551401869 * IMAGE_WIDTH, 0.5981308411214953 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.49065420560747663 * IMAGE_WIDTH, 0.6822429906542056 * IMAGE_HEIGHT);
                SYMBOL.closePath();
                break;

            case ARROW_EAST:
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(Path2D.WIND_EVEN_ODD);
                SYMBOL.moveTo(0.308411214953271 * IMAGE_WIDTH, 0.616822429906542 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.308411214953271 * IMAGE_WIDTH, 0.3878504672897196 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.4252336448598131 * IMAGE_WIDTH, 0.3878504672897196 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.4252336448598131 * IMAGE_WIDTH, 0.26635514018691586 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.6915887850467289 * IMAGE_WIDTH, 0.4953271028037383 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.4252336448598131 * IMAGE_WIDTH, 0.7336448598130841 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.4252336448598131 * IMAGE_WIDTH, 0.616822429906542 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.308411214953271 * IMAGE_WIDTH, 0.616822429906542 * IMAGE_HEIGHT);
                SYMBOL.closePath();
                break;

            case ARROW_SOUTH_EAST:
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(Path2D.WIND_EVEN_ODD);
                SYMBOL.moveTo(0.32242990654205606 * IMAGE_WIDTH, 0.49065420560747663 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.48598130841121495 * IMAGE_WIDTH, 0.3317757009345794 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.5654205607476636 * IMAGE_WIDTH, 0.411214953271028 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.6495327102803738 * IMAGE_WIDTH, 0.32710280373831774 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.677570093457944 * IMAGE_WIDTH, 0.677570093457944 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.32242990654205606 * IMAGE_WIDTH, 0.6588785046728972 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.40654205607476634 * IMAGE_WIDTH, 0.5747663551401869 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.32242990654205606 * IMAGE_WIDTH, 0.49065420560747663 * IMAGE_HEIGHT);
                SYMBOL.closePath();
                break;

            case ARROW_SOUTH:
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(Path2D.WIND_EVEN_ODD);
                SYMBOL.moveTo(0.616822429906542 * IMAGE_WIDTH, 0.3130841121495327 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.3878504672897196 * IMAGE_WIDTH, 0.3130841121495327 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.3878504672897196 * IMAGE_WIDTH, 0.42990654205607476 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.26635514018691586 * IMAGE_WIDTH, 0.42990654205607476 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.5046728971962616 * IMAGE_WIDTH, 0.6962616822429907 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.7336448598130841 * IMAGE_WIDTH, 0.42990654205607476 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.616822429906542 * IMAGE_WIDTH, 0.42990654205607476 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.616822429906542 * IMAGE_WIDTH, 0.3130841121495327 * IMAGE_HEIGHT);
                SYMBOL.closePath();
                break;

            case ARROW_SOUTH_WEST:
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(Path2D.WIND_EVEN_ODD);
                SYMBOL.moveTo(0.677570093457944 * IMAGE_WIDTH, 0.49065420560747663 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.514018691588785 * IMAGE_WIDTH, 0.3317757009345794 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.43457943925233644 * IMAGE_WIDTH, 0.411214953271028 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.35046728971962615 * IMAGE_WIDTH, 0.32710280373831774 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.32242990654205606 * IMAGE_WIDTH, 0.677570093457944 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.677570093457944 * IMAGE_WIDTH, 0.6588785046728972 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.5934579439252337 * IMAGE_WIDTH, 0.5747663551401869 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.677570093457944 * IMAGE_WIDTH, 0.49065420560747663 * IMAGE_HEIGHT);
                SYMBOL.closePath();
                break;

            case ARROW_WEST:
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(Path2D.WIND_EVEN_ODD);
                SYMBOL.moveTo(0.6915887850467289 * IMAGE_WIDTH, 0.616822429906542 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.6915887850467289 * IMAGE_WIDTH, 0.3878504672897196 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.5747663551401869 * IMAGE_WIDTH, 0.3878504672897196 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.5747663551401869 * IMAGE_WIDTH, 0.26635514018691586 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.3130841121495327 * IMAGE_WIDTH, 0.4953271028037383 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.5747663551401869 * IMAGE_WIDTH, 0.7336448598130841 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.5747663551401869 * IMAGE_WIDTH, 0.616822429906542 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.6915887850467289 * IMAGE_WIDTH, 0.616822429906542 * IMAGE_HEIGHT);
                SYMBOL.closePath();
                break;

            case ARROW_NORTH_WEST:
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(Path2D.WIND_EVEN_ODD);
                SYMBOL.moveTo(0.5093457943925234 * IMAGE_WIDTH, 0.6822429906542056 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.6728971962616822 * IMAGE_WIDTH, 0.5186915887850467 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.5887850467289719 * IMAGE_WIDTH, 0.43457943925233644 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.6728971962616822 * IMAGE_WIDTH, 0.35046728971962615 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.32710280373831774 * IMAGE_WIDTH, 0.32710280373831774 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.34579439252336447 * IMAGE_WIDTH, 0.6822429906542056 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.4252336448598131 * IMAGE_WIDTH, 0.5981308411214953 * IMAGE_HEIGHT);
                SYMBOL.lineTo(0.5093457943925234 * IMAGE_WIDTH, 0.6822429906542056 * IMAGE_HEIGHT);
                SYMBOL.closePath();
                break;

            case HORN:

            default:
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(Path2D.WIND_EVEN_ODD);
                SYMBOL.moveTo(IMAGE_WIDTH * 0.40654205607476634, IMAGE_HEIGHT * 0.5654205607476636);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.40654205607476634, IMAGE_HEIGHT * 0.5514018691588785, IMAGE_WIDTH * 0.4205607476635514, IMAGE_HEIGHT * 0.5420560747663551, IMAGE_WIDTH * 0.4485981308411215, IMAGE_HEIGHT * 0.5327102803738317);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.4719626168224299, IMAGE_HEIGHT * 0.5233644859813084, IMAGE_WIDTH * 0.5, IMAGE_HEIGHT * 0.5186915887850467, IMAGE_WIDTH * 0.5327102803738317, IMAGE_HEIGHT * 0.5186915887850467);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.5607476635514018, IMAGE_HEIGHT * 0.5186915887850467, IMAGE_WIDTH * 0.5934579439252337, IMAGE_HEIGHT * 0.5233644859813084, IMAGE_WIDTH * 0.6121495327102804, IMAGE_HEIGHT * 0.5327102803738317);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6401869158878505, IMAGE_HEIGHT * 0.5420560747663551, IMAGE_WIDTH * 0.6542056074766355, IMAGE_HEIGHT * 0.5514018691588785, IMAGE_WIDTH * 0.6542056074766355, IMAGE_HEIGHT * 0.5654205607476636);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6542056074766355, IMAGE_HEIGHT * 0.5887850467289719, IMAGE_WIDTH * 0.5981308411214953, IMAGE_HEIGHT * 0.6121495327102804, IMAGE_WIDTH * 0.5327102803738317, IMAGE_HEIGHT * 0.6121495327102804);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.46261682242990654, IMAGE_HEIGHT * 0.6121495327102804, IMAGE_WIDTH * 0.40654205607476634, IMAGE_HEIGHT * 0.5887850467289719, IMAGE_WIDTH * 0.40654205607476634, IMAGE_HEIGHT * 0.5654205607476636);
                SYMBOL.closePath();
                SYMBOL.moveTo(IMAGE_WIDTH * 0.677570093457944, IMAGE_HEIGHT * 0.5654205607476636);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.677570093457944, IMAGE_HEIGHT * 0.5514018691588785, IMAGE_WIDTH * 0.6728971962616822, IMAGE_HEIGHT * 0.5420560747663551, IMAGE_WIDTH * 0.6588785046728972, IMAGE_HEIGHT * 0.5327102803738317);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6915887850467289, IMAGE_HEIGHT * 0.5046728971962616, IMAGE_WIDTH * 0.7242990654205608, IMAGE_HEIGHT * 0.5327102803738317, IMAGE_WIDTH * 0.7242990654205608, IMAGE_HEIGHT * 0.5327102803738317);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.7383177570093458, IMAGE_HEIGHT * 0.5327102803738317);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.7383177570093458, IMAGE_HEIGHT * 0.46261682242990654);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.7242990654205608, IMAGE_HEIGHT * 0.46261682242990654);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.7242990654205608, IMAGE_HEIGHT * 0.46261682242990654, IMAGE_WIDTH * 0.705607476635514, IMAGE_HEIGHT * 0.48598130841121495, IMAGE_WIDTH * 0.6542056074766355, IMAGE_HEIGHT * 0.48598130841121495);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6214953271028038, IMAGE_HEIGHT * 0.48598130841121495, IMAGE_WIDTH * 0.5981308411214953, IMAGE_HEIGHT * 0.48598130841121495, IMAGE_WIDTH * 0.5981308411214953, IMAGE_HEIGHT * 0.48598130841121495);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.5981308411214953, IMAGE_HEIGHT * 0.4439252336448598);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.4439252336448598);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.5747663551401869, IMAGE_HEIGHT * 0.48598130841121495);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.5420560747663551, IMAGE_HEIGHT * 0.48598130841121495);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.5420560747663551, IMAGE_HEIGHT * 0.4439252336448598);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.5186915887850467, IMAGE_HEIGHT * 0.4439252336448598);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.5186915887850467, IMAGE_HEIGHT * 0.48598130841121495);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.48598130841121495, IMAGE_HEIGHT * 0.48598130841121495);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.48598130841121495, IMAGE_HEIGHT * 0.4439252336448598);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.46261682242990654, IMAGE_HEIGHT * 0.4439252336448598);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.46261682242990654, IMAGE_HEIGHT * 0.4439252336448598, IMAGE_WIDTH * 0.46261682242990654, IMAGE_HEIGHT * 0.48130841121495327, IMAGE_WIDTH * 0.46261682242990654, IMAGE_HEIGHT * 0.48598130841121495);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.3037383177570093, IMAGE_HEIGHT * 0.48598130841121495, IMAGE_WIDTH * 0.2803738317757009, IMAGE_HEIGHT * 0.3644859813084112, IMAGE_WIDTH * 0.2803738317757009, IMAGE_HEIGHT * 0.3644859813084112);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.27102803738317754, IMAGE_HEIGHT * 0.3644859813084112);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.27102803738317754, IMAGE_HEIGHT * 0.6401869158878505);
                SYMBOL.lineTo(IMAGE_WIDTH * 0.2850467289719626, IMAGE_HEIGHT * 0.6401869158878505);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.2850467289719626, IMAGE_HEIGHT * 0.6401869158878505, IMAGE_WIDTH * 0.29439252336448596, IMAGE_HEIGHT * 0.5327102803738317, IMAGE_WIDTH * 0.3925233644859813, IMAGE_HEIGHT * 0.5327102803738317);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.3925233644859813, IMAGE_HEIGHT * 0.5327102803738317, IMAGE_WIDTH * 0.40186915887850466, IMAGE_HEIGHT * 0.5327102803738317, IMAGE_WIDTH * 0.40186915887850466, IMAGE_HEIGHT * 0.5327102803738317);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.3878504672897196, IMAGE_HEIGHT * 0.5420560747663551, IMAGE_WIDTH * 0.38317757009345793, IMAGE_HEIGHT * 0.5514018691588785, IMAGE_WIDTH * 0.38317757009345793, IMAGE_HEIGHT * 0.5654205607476636);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.38317757009345793, IMAGE_HEIGHT * 0.602803738317757, IMAGE_WIDTH * 0.4485981308411215, IMAGE_HEIGHT * 0.6355140186915887, IMAGE_WIDTH * 0.5327102803738317, IMAGE_HEIGHT * 0.6355140186915887);
                SYMBOL.curveTo(IMAGE_WIDTH * 0.6121495327102804, IMAGE_HEIGHT * 0.6355140186915887, IMAGE_WIDTH * 0.677570093457944, IMAGE_HEIGHT * 0.602803738317757, IMAGE_WIDTH * 0.677570093457944, IMAGE_HEIGHT * 0.5654205607476636);
                SYMBOL.closePath();
                break;
        }

        final Color STROKE_COLOR;
        final Color FILL_COLOR;
        final Color GLOW_COLOR;
        if (SYMBOL_COLOR == ColorDef.CUSTOM && CUSTOM_SYMBOL_COLOR != null) {
            FILL_COLOR = CUSTOM_SYMBOL_COLOR.LIGHT;
            STROKE_COLOR = UTIL.setAlpha(CUSTOM_SYMBOL_COLOR.DARK, 0.5f);
            GLOW_COLOR = CUSTOM_SYMBOL_COLOR.LIGHT;
        } else {
            FILL_COLOR = SYMBOL_COLOR.LIGHT;
            STROKE_COLOR = UTIL.setAlpha(SYMBOL_COLOR.DARK, 0.5f);
            GLOW_COLOR = SYMBOL_COLOR.LIGHT;
        }

        if (GLOW) {
            if (clipImageSymbol != null) {
                clipImageSymbol.flush();
            }
            clipImageSymbol = SHADOW.createSoftClipImage((java.awt.Shape) SYMBOL, FILL_COLOR);
            final double OFFSET = 0.12 * IMAGE_WIDTH;
            G2.translate(-OFFSET, -OFFSET);
            G2.drawImage(Shadow.INSTANCE.createDropShadow(clipImageSymbol, 0, 0.65f, (int) OFFSET, 315, GLOW_COLOR), SYMBOL.getBounds().x, SYMBOL.getBounds().y, null);
            G2.translate(OFFSET, OFFSET);
        } else {
            G2.setPaint(FILL_COLOR);
            G2.fill(SYMBOL);
            G2.setStroke(new BasicStroke(0.5f));
            G2.setColor(STROKE_COLOR);
            G2.draw(SYMBOL);
        }

        G2.dispose();

        // Cache current parameters
        widthBuffer = WIDTH;
        symbolTypeBuffer = SYMBOL_TYPE;
        symbolColorBuffer = SYMBOL_COLOR;
        customSymbolColorBuffer = CUSTOM_SYMBOL_COLOR;

        return symbolImageBuffer;
    }
}
