/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.extras;

import eu.hansolo.steelseries.tools.CustomLedColor;
import eu.hansolo.steelseries.tools.LedColor;
import eu.hansolo.steelseries.tools.LedType;
import eu.hansolo.steelseries.tools.Shadow;
import eu.hansolo.steelseries.tools.Util;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.Timer;
import javax.swing.border.Border;

public class Led
extends JComponent
implements ActionListener {
    private static final Util UTIL = Util.INSTANCE;
    private final Rectangle INNER_BOUNDS = new Rectangle(16, 16);
    private LedColor ledColor = LedColor.RED_LED;
    private CustomLedColor customLedColor = new CustomLedColor(Color.RED);
    private BufferedImage ledImageOff = this.create_LED_Image(16, 0, this.ledColor, LedType.ROUND);
    private BufferedImage ledImageOn = this.create_LED_Image(16, 1, this.ledColor, LedType.ROUND);
    private BufferedImage currentLedImage = this.ledImageOff;
    private final Timer LED_BLINKING_TIMER = new Timer(500, this);
    private boolean ledBlinking = false;
    private boolean ledOn = false;
    private LedType ledType = LedType.ROUND;
    private boolean initialized = false;
    private final transient ComponentListener COMPONENT_LISTENER = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            int n = Led.this.getWidth() <= Led.this.getHeight() ? Led.this.getWidth() : Led.this.getHeight();
            Container container = Led.this.getParent();
            if (container != null && container.getLayout() == null) {
                if (n < Led.this.getMinimumSize().width || n < Led.this.getMinimumSize().height) {
                    Led.this.setSize(Led.this.getMinimumSize().width, Led.this.getMinimumSize().height);
                } else {
                    Led.this.setSize(n, n);
                }
            } else if (n < Led.this.getMinimumSize().width || n < Led.this.getMinimumSize().height) {
                Led.this.setPreferredSize(Led.this.getMinimumSize());
            } else {
                Led.this.setPreferredSize(new Dimension(n, n));
            }
            Led.this.calcInnerBounds();
            Led.this.init(((Led)Led.this).INNER_BOUNDS.width);
        }
    };
    private static final Map<String, BufferedImage> CACHE = new HashMap<String, BufferedImage>();
    private int horizontalAlignment = 0;
    private int verticalAlignment = 0;

    public Led() {
        this.init(this.INNER_BOUNDS.width);
        this.addComponentListener(this.COMPONENT_LISTENER);
    }

    private void init(int n) {
        if (n <= 1) {
            return;
        }
        if (this.ledImageOff != null) {
            this.ledImageOff.flush();
        }
        this.ledImageOff = this.create_LED_Image(n, 0, this.ledColor, this.ledType);
        if (this.ledImageOn != null) {
            this.ledImageOn.flush();
        }
        this.ledImageOn = this.create_LED_Image(n, 1, this.ledColor, this.ledType);
        if (this.ledOn) {
            this.setCurrentLedImage(this.ledImageOn);
        } else {
            this.setCurrentLedImage(this.ledImageOff);
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (!this.initialized) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.translate(this.INNER_BOUNDS.x, this.INNER_BOUNDS.y);
        graphics2D.drawImage((Image)this.getCurrentLedImage(), 0, 0, null);
        graphics2D.translate(-this.INNER_BOUNDS.x, -this.INNER_BOUNDS.y);
        graphics2D.dispose();
    }

    public LedType getLedType() {
        return this.ledType;
    }

    public void setLedType(LedType ledType) {
        this.ledType = ledType;
        boolean bl = this.currentLedImage.equals(this.ledImageOn);
        this.ledImageOff = this.create_LED_Image(this.getWidth(), 0, this.ledColor, this.ledType);
        this.ledImageOn = this.create_LED_Image(this.getWidth(), 1, this.ledColor, this.ledType);
        this.currentLedImage = bl ? this.ledImageOn : this.ledImageOff;
        this.repaint();
    }

    public LedColor getLedColor() {
        return this.ledColor;
    }

    public void setLedColor(LedColor ledColor) {
        this.ledColor = ledColor == null ? LedColor.RED_LED : ledColor;
        boolean bl = this.currentLedImage.equals(this.ledImageOn);
        this.ledImageOff = this.create_LED_Image(this.getWidth(), 0, ledColor, this.ledType);
        this.ledImageOn = this.create_LED_Image(this.getWidth(), 1, ledColor, this.ledType);
        this.currentLedImage = bl ? this.ledImageOn : this.ledImageOff;
        this.repaint();
    }

    public Color getCustomLedColor() {
        return this.customLedColor.COLOR;
    }

    public void setCustomLedColor(Color color) {
        this.customLedColor = new CustomLedColor(color);
        boolean bl = this.currentLedImage.equals(this.ledImageOn);
        this.ledImageOff = this.create_LED_Image(this.getWidth(), 0, this.ledColor, this.ledType);
        this.ledImageOn = this.create_LED_Image(this.getWidth(), 1, this.ledColor, this.ledType);
        this.currentLedImage = bl ? this.ledImageOn : this.ledImageOff;
        this.repaint();
    }

    public CustomLedColor getCustomLedColorObject() {
        return this.customLedColor;
    }

    public boolean isLedOn() {
        return this.ledOn;
    }

    public void setLedOn(boolean bl) {
        this.ledOn = bl;
        this.init(this.getWidth());
        this.repaint();
    }

    public boolean isLedBlinking() {
        return this.ledBlinking;
    }

    public void setLedBlinking(boolean bl) {
        this.ledBlinking = bl;
        if (bl) {
            this.LED_BLINKING_TIMER.start();
        } else {
            this.setCurrentLedImage(this.getLedImageOff());
            this.LED_BLINKING_TIMER.stop();
        }
    }

    public BufferedImage getAsImage() {
        BufferedImage bufferedImage = UTIL.createImage(this.getWidth(), this.getHeight(), 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        this.paintAll(graphics2D);
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage getLedImageOn() {
        return this.ledImageOn;
    }

    private BufferedImage getLedImageOff() {
        return this.ledImageOff;
    }

    private BufferedImage getCurrentLedImage() {
        return this.currentLedImage;
    }

    private void setCurrentLedImage(BufferedImage bufferedImage) {
        this.currentLedImage = bufferedImage;
        this.repaint(this.INNER_BOUNDS);
    }

    public BufferedImage create_LED_Image(int n, int n2, LedColor ledColor, LedType ledType) {
        Color[] colorArray;
        Point2D.Double double_;
        Point2D.Double double_2;
        Color[] colorArray2;
        Object object;
        Color[] colorArray3;
        Color[] colorArray4;
        Color[] colorArray5;
        Object object2;
        Object object3;
        Object object4;
        if (n <= 0) {
            return UTIL.createImage(1, 1, 3);
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(Integer.toString(n));
        stringBuilder.append("_");
        stringBuilder.append(Integer.toString(n2));
        stringBuilder.append("_");
        stringBuilder.append((Object)ledColor);
        stringBuilder.append("_");
        stringBuilder.append((Object)ledType);
        if (ledColor == LedColor.CUSTOM) {
            object4 = new StringBuilder();
            ((StringBuilder)object4).append("#");
            object3 = Integer.toHexString(this.customLedColor.COLOR.getRed());
            String string = Integer.toHexString(this.customLedColor.COLOR.getBlue());
            String string2 = Integer.toHexString(this.customLedColor.COLOR.getGreen());
            if (((String)object3).length() == 1) {
                ((StringBuilder)object4).append("0");
            }
            ((StringBuilder)object4).append((String)object3);
            if (string2.length() == 1) {
                ((StringBuilder)object4).append("0");
            }
            ((StringBuilder)object4).append(string2);
            if (string.length() == 1) {
                ((StringBuilder)object4).append("0");
            }
            ((StringBuilder)object4).append(string);
            if (this.customLedColor.COLOR.getAlpha() != 255) {
                object2 = Integer.toHexString(this.customLedColor.COLOR.getAlpha());
                if (((String)object2).length() == 1) {
                    ((StringBuilder)object4).append("0");
                }
                ((StringBuilder)object4).append((String)object2);
            }
            stringBuilder.append("_").append(((StringBuilder)object4).toString());
        }
        if (CACHE.containsKey(stringBuilder.toString())) {
            return CACHE.get(stringBuilder.toString());
        }
        object4 = UTIL.createImage(n, n, 3);
        object3 = ((BufferedImage)object4).createGraphics();
        ((Graphics2D)object3).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n3 = ((BufferedImage)object4).getWidth();
        int n4 = ((BufferedImage)object4).getHeight();
        switch (ledType) {
            case RECT_VERTICAL: {
                object2 = new Rectangle2D.Double((double)n3 * 0.3421052632, (double)n4 * 0.1052631579, (double)n3 * 0.3157894737, (double)n4 * 0.7894736842);
                break;
            }
            case RECT_HORIZONTAL: {
                object2 = new Rectangle2D.Double((double)n3 * 0.1052631579, (double)n4 * 0.3421052632, (double)n3 * 0.7894736842, (double)n4 * 0.3157894737);
                break;
            }
            default: {
                object2 = new Ellipse2D.Double(0.25 * (double)n3, 0.25 * (double)n4, 0.5 * (double)n3, 0.5 * (double)n4);
            }
        }
        Ellipse2D.Double double_3 = new Ellipse2D.Double(0.0, 0.0, n3, n4);
        Point2D.Double double_4 = new Point2D.Double(object2.getBounds2D().getCenterX(), object2.getBounds2D().getCenterY());
        float[] fArray = new float[]{0.0f, 0.2f, 1.0f};
        if (ledColor != LedColor.CUSTOM) {
            colorArray5 = new Color[]{ledColor.INNER_COLOR1_OFF, ledColor.INNER_COLOR2_OFF, ledColor.OUTER_COLOR_OFF};
            colorArray4 = new Color[]{ledColor.INNER_COLOR1_ON, ledColor.INNER_COLOR2_ON, ledColor.OUTER_COLOR_ON};
            colorArray3 = new Color[]{UTIL.setAlpha(ledColor.CORONA_COLOR, 0.4f), UTIL.setAlpha(ledColor.CORONA_COLOR, 0.4f), UTIL.setAlpha(ledColor.CORONA_COLOR, 0.25f), UTIL.setAlpha(ledColor.CORONA_COLOR, 0.15f), UTIL.setAlpha(ledColor.CORONA_COLOR, 0.05f), UTIL.setAlpha(ledColor.CORONA_COLOR, 0.0f)};
        } else {
            colorArray5 = new Color[]{this.customLedColor.INNER_COLOR1_OFF, this.customLedColor.INNER_COLOR2_OFF, this.customLedColor.OUTER_COLOR_OFF};
            colorArray4 = new Color[]{this.customLedColor.INNER_COLOR1_ON, this.customLedColor.INNER_COLOR2_ON, this.customLedColor.OUTER_COLOR_ON};
            colorArray3 = new Color[]{UTIL.setAlpha(this.customLedColor.CORONA_COLOR, 0.4f), UTIL.setAlpha(this.customLedColor.CORONA_COLOR, 0.4f), UTIL.setAlpha(this.customLedColor.CORONA_COLOR, 0.25f), UTIL.setAlpha(this.customLedColor.CORONA_COLOR, 0.15f), UTIL.setAlpha(this.customLedColor.CORONA_COLOR, 0.05f), UTIL.setAlpha(this.customLedColor.CORONA_COLOR, 0.0f)};
        }
        float[] fArray2 = new float[]{0.0f, 0.8f, 1.0f};
        Color[] colorArray6 = new Color[]{new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.4f)};
        float[] fArray3 = new float[]{0.0f, 0.6f, 0.7f, 0.8f, 0.85f, 1.0f};
        RadialGradientPaint radialGradientPaint = new RadialGradientPaint(double_4, 0.25f * (float)n3, fArray, colorArray5);
        RadialGradientPaint radialGradientPaint2 = new RadialGradientPaint(double_4, 0.25f * (float)n3, fArray, colorArray4);
        RadialGradientPaint radialGradientPaint3 = new RadialGradientPaint(double_4, 0.25f * (float)n3, fArray2, colorArray6);
        RadialGradientPaint radialGradientPaint4 = new RadialGradientPaint(double_4, 0.5f * (float)n3, fArray3, colorArray3);
        switch (ledType) {
            case RECT_VERTICAL: {
                object = new GeneralPath();
                ((Path2D)object).setWindingRule(0);
                ((Path2D.Float)object).moveTo((double)n3 * 0.34210526315789475, (double)n4 * 0.10526315789473684);
                ((Path2D.Float)object).lineTo((double)n3 * 0.6578947368421053, (double)n4 * 0.10526315789473684);
                ((Path2D.Float)object).lineTo((double)n3 * 0.6578947368421053, (double)n4 * 0.3684210526315789);
                ((Path2D.Float)object).curveTo((double)n3 * 0.6578947368421053, (double)n4 * 0.3684210526315789, (double)n3 * 0.631578947368421, (double)n4 * 0.42105263157894735, (double)n3 * 0.5, (double)n4 * 0.42105263157894735);
                ((Path2D.Float)object).curveTo((double)n3 * 0.3684210526315789, (double)n4 * 0.42105263157894735, (double)n3 * 0.34210526315789475, (double)n4 * 0.3684210526315789, (double)n3 * 0.34210526315789475, (double)n4 * 0.3684210526315789);
                ((Path2D.Float)object).lineTo((double)n3 * 0.34210526315789475, (double)n4 * 0.10526315789473684);
                ((Path2D)object).closePath();
                colorArray2 = object;
                double_2 = new Point2D.Double(0.0, ((Path2D.Float)object).getBounds2D().getMinY());
                double_ = new Point2D.Double(0.0, ((Path2D.Float)object).getBounds2D().getMaxY());
                break;
            }
            case RECT_HORIZONTAL: {
                colorArray = new GeneralPath();
                colorArray.setWindingRule(0);
                colorArray.moveTo((double)n3 * 0.10526315789473684, (double)n4 * 0.34210526315789475);
                colorArray.lineTo((double)n3 * 0.8947368421052632, (double)n4 * 0.34210526315789475);
                colorArray.lineTo((double)n3 * 0.8947368421052632, (double)n4 * 0.42105263157894735);
                colorArray.curveTo((double)n3 * 0.8947368421052632, (double)n4 * 0.42105263157894735, (double)n3 * 0.7894736842105263, (double)n4 * 0.5, (double)n3 * 0.5, (double)n4 * 0.5);
                colorArray.curveTo((double)n3 * 0.21052631578947367, (double)n4 * 0.5, (double)n3 * 0.10526315789473684, (double)n4 * 0.42105263157894735, (double)n3 * 0.10526315789473684, (double)n4 * 0.42105263157894735);
                colorArray.lineTo((double)n3 * 0.10526315789473684, (double)n4 * 0.34210526315789475);
                colorArray.closePath();
                colorArray2 = colorArray;
                double_2 = new Point2D.Double(0.0, colorArray2.getBounds2D().getMinY());
                double_ = new Point2D.Double(0.0, colorArray2.getBounds2D().getMaxY());
                break;
            }
            default: {
                colorArray2 = new Ellipse2D.Double(0.4 * (double)n3, 0.35 * (double)n3, 0.2 * (double)n3, 0.15 * (double)n3);
                double_2 = new Point2D.Double(0.0, colorArray2.getBounds2D().getMinY());
                double_ = new Point2D.Double(0.0, colorArray2.getBounds2D().getMaxY());
            }
        }
        object = new float[]{0.0f, 1.0f};
        colorArray = new Color[]{new Color(1.0f, 1.0f, 1.0f, 0.4f), new Color(1.0f, 1.0f, 1.0f, 0.0f)};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_2, double_, (float[])object, colorArray);
        switch (n2) {
            case 1: {
                ((Graphics2D)object3).setPaint(radialGradientPaint4);
                ((Graphics2D)object3).fill(double_3);
                switch (ledType) {
                    case ROUND: {
                        ((Graphics2D)object3).setPaint(radialGradientPaint2);
                        ((Graphics2D)object3).fill((Shape)object2);
                        ((Graphics2D)object3).setPaint(radialGradientPaint3);
                        ((Graphics2D)object3).fill((Shape)object2);
                        break;
                    }
                    case RECT_VERTICAL: {
                        ((Graphics)object3).drawImage(Shadow.INSTANCE.createInnerShadow((Shape)object2, radialGradientPaint2, 0, 0.65f, Color.BLACK, 20, 315), (int)((double)n3 * 0.3421052632), (int)((double)n4 * 0.1052631579), null);
                        break;
                    }
                    case RECT_HORIZONTAL: {
                        ((Graphics)object3).drawImage(Shadow.INSTANCE.createInnerShadow((Shape)object2, radialGradientPaint2, 0, 0.65f, Color.BLACK, 20, 315), (int)((double)n3 * 0.1052631579), (int)((double)n4 * 0.3421052632), null);
                    }
                }
                ((Graphics2D)object3).setPaint(linearGradientPaint);
                ((Graphics2D)object3).fill((Shape)colorArray2);
                break;
            }
            default: {
                switch (ledType) {
                    case ROUND: {
                        ((Graphics2D)object3).setPaint(radialGradientPaint);
                        ((Graphics2D)object3).fill((Shape)object2);
                        ((Graphics2D)object3).setPaint(radialGradientPaint3);
                        ((Graphics2D)object3).fill((Shape)object2);
                        break;
                    }
                    case RECT_VERTICAL: {
                        ((Graphics)object3).drawImage(Shadow.INSTANCE.createInnerShadow((Shape)object2, radialGradientPaint, 0, 0.65f, Color.BLACK, 20, 315), (int)((double)n3 * 0.3421052632), (int)((double)n4 * 0.1052631579), null);
                        break;
                    }
                    case RECT_HORIZONTAL: {
                        ((Graphics)object3).drawImage(Shadow.INSTANCE.createInnerShadow((Shape)object2, radialGradientPaint, 0, 0.65f, Color.BLACK, 20, 315), (int)((double)n3 * 0.1052631579), (int)((double)n4 * 0.3421052632), null);
                    }
                }
                ((Graphics2D)object3).setPaint(linearGradientPaint);
                ((Graphics2D)object3).fill((Shape)colorArray2);
            }
        }
        ((Graphics)object3).dispose();
        CACHE.put(stringBuilder.toString(), (BufferedImage)object4);
        return object4;
    }

    private void calcInnerBounds() {
        Insets insets = this.getInsets();
        int n = this.getWidth() - insets.left - insets.right <= this.getHeight() - insets.top - insets.bottom ? this.getWidth() - insets.left - insets.right : this.getHeight() - insets.top - insets.bottom;
        this.INNER_BOUNDS.setBounds(insets.left, insets.top, n, n);
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        if (dimension.width < 16 || dimension.height < 16) {
            dimension = new Dimension(16, 16);
        }
        return dimension;
    }

    @Override
    public void setMinimumSize(Dimension dimension) {
        int n = dimension.width < 16 ? 16 : dimension.width;
        int n2 = dimension.height < 16 ? 16 : dimension.height;
        int n3 = n <= n2 ? n : n2;
        super.setMinimumSize(new Dimension(n3, n3));
        this.calcInnerBounds();
        this.init(this.INNER_BOUNDS.width);
        this.initialized = true;
        this.invalidate();
        this.repaint();
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension dimension = super.getMaximumSize();
        if (dimension.width > 1080 || dimension.height > 1080) {
            dimension = new Dimension(1080, 1080);
        }
        return dimension;
    }

    @Override
    public void setMaximumSize(Dimension dimension) {
        int n = dimension.width > 1080 ? 1080 : dimension.width;
        int n2 = dimension.height > 1080 ? 1080 : dimension.height;
        int n3 = n <= n2 ? n : n2;
        super.setMaximumSize(new Dimension(n3, n3));
        this.calcInnerBounds();
        this.init(this.INNER_BOUNDS.width);
        this.initialized = true;
        this.invalidate();
        this.repaint();
    }

    @Override
    public void setPreferredSize(Dimension dimension) {
        int n = dimension.width <= dimension.height ? dimension.width : dimension.height;
        super.setPreferredSize(new Dimension(n, n));
        this.calcInnerBounds();
        this.init(this.INNER_BOUNDS.width);
        this.initialized = true;
        this.invalidate();
        this.repaint();
    }

    @Override
    public void setSize(int n, int n2) {
        int n3 = n <= n2 ? n : n2;
        super.setSize(n3, n3);
        this.calcInnerBounds();
        this.init(this.INNER_BOUNDS.width);
        this.initialized = true;
    }

    @Override
    public void setSize(Dimension dimension) {
        int n = dimension.width <= dimension.height ? dimension.width : dimension.height;
        super.setSize(new Dimension(n, n));
        this.calcInnerBounds();
        this.init(this.INNER_BOUNDS.width);
        this.initialized = true;
    }

    @Override
    public void setBounds(Rectangle rectangle) {
        if (rectangle.width <= rectangle.height) {
            int n;
            switch (this.verticalAlignment) {
                case 1: {
                    n = rectangle.y;
                    break;
                }
                case 3: {
                    n = rectangle.y + (rectangle.height - rectangle.width);
                    break;
                }
                default: {
                    n = rectangle.y + (rectangle.height - rectangle.width) / 2;
                }
            }
            super.setBounds(rectangle.x, n, rectangle.width, rectangle.width);
        } else {
            int n;
            switch (this.horizontalAlignment) {
                case 2: {
                    n = rectangle.x;
                    break;
                }
                case 4: {
                    n = rectangle.x + (rectangle.width - rectangle.height);
                    break;
                }
                default: {
                    n = rectangle.x + (rectangle.width - rectangle.height) / 2;
                }
            }
            super.setBounds(n, rectangle.y, rectangle.height, rectangle.height);
        }
        this.calcInnerBounds();
        this.init(this.INNER_BOUNDS.width);
        this.initialized = true;
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        if (n3 <= n4) {
            int n5;
            switch (this.verticalAlignment) {
                case 1: {
                    n5 = n2;
                    break;
                }
                case 3: {
                    n5 = n2 + (n4 - n3);
                    break;
                }
                default: {
                    n5 = n2 + (n4 - n3) / 2;
                }
            }
            super.setBounds(n, n5, n3, n3);
        } else {
            int n6;
            switch (this.horizontalAlignment) {
                case 2: {
                    n6 = n;
                    break;
                }
                case 4: {
                    n6 = n + (n3 - n4);
                    break;
                }
                default: {
                    n6 = n + (n3 - n4) / 2;
                }
            }
            super.setBounds(n6, n2, n4, n4);
        }
        this.calcInnerBounds();
        this.init(this.INNER_BOUNDS.width);
        this.initialized = true;
    }

    @Override
    public void setBorder(Border border) {
        super.setBorder(border);
        this.calcInnerBounds();
        this.init(this.INNER_BOUNDS.width);
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int n) {
        this.horizontalAlignment = n;
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int n) {
        this.verticalAlignment = n;
    }

    public void dispose() {
        this.LED_BLINKING_TIMER.removeActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.LED_BLINKING_TIMER)) {
            this.currentLedImage = this.ledOn ? this.getLedImageOn() : this.getLedImageOff();
            this.ledOn ^= true;
            this.repaint();
        }
    }

    @Override
    public String toString() {
        return "LED";
    }
}

