/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.extras;

import eu.hansolo.steelseries.gauges.AbstractGauge;
import eu.hansolo.steelseries.gauges.AbstractRadial;
import eu.hansolo.steelseries.tools.Section;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.util.ArrayList;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.ease.Spline;
import org.pushingpixels.trident.ease.TimelineEase;

public final class Level
extends AbstractRadial {
    private double visibleValue = 90.0;
    private int stepValue = 0;
    private boolean textOrientationFixed = false;
    private boolean decimalVisible = true;
    private final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.0");
    private double angleStep;
    private Font font = new Font("Verdana", 0, 30);
    private final Point2D CENTER = new Point2D.Double();
    private BufferedImage bImage;
    private BufferedImage fImage;
    private BufferedImage pointerImage;
    private BufferedImage stepPointerImage;
    private BufferedImage disabledImage;
    private Timeline timeline = new Timeline((Object)this);
    private final Spline EASE = new Spline(0.5f);
    private long easingDuration = 250L;
    private final FontRenderContext RENDER_CONTEXT = new FontRenderContext(null, true, true);
    private TextLayout textLayout;
    private final Rectangle2D TEXT_BOUNDARY = new Rectangle2D.Double();

    public Level() {
        this.setMinValue(-360.0);
        this.setMaxValue(360.0);
        this.calcAngleStep();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public AbstractGauge init(int n, int n2) {
        int n3;
        int n4 = this.isFrameVisible() ? n : this.getGaugeBounds().width;
        int n5 = n3 = this.isFrameVisible() ? n2 : this.getGaugeBounds().height;
        if (this.isFrameVisible()) {
            this.setFramelessOffset(0.0, 0.0);
        } else {
            this.setFramelessOffset((double)this.getGaugeBounds().width * 0.0841121495, (double)this.getGaugeBounds().width * 0.0841121495);
        }
        if (n4 <= 1 || n3 <= 1) {
            return this;
        }
        if (this.bImage != null) {
            this.bImage.flush();
        }
        this.bImage = UTIL.createImage(n4, n4, 3);
        if (this.fImage != null) {
            this.fImage.flush();
        }
        this.fImage = UTIL.createImage(n4, n4, 3);
        if (this.isFrameVisible()) {
            switch (this.getFrameType()) {
                case ROUND: {
                    FRAME_FACTORY.createRadialFrame(n4, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect(), this.bImage);
                    break;
                }
                case SQUARE: {
                    FRAME_FACTORY.createLinearFrame(n4, n4, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect(), this.bImage);
                    break;
                }
                default: {
                    FRAME_FACTORY.createRadialFrame(n4, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect(), this.bImage);
                }
            }
        }
        if (this.isBackgroundVisible()) {
            this.create_BACKGROUND_Image(n4, "", "", this.bImage);
        }
        this.create_TICKMARKS_Image(n4, 0.0, 0.0, 0.0, 0.0, 0.0, 0, 0, true, true, null, this.bImage);
        if (this.pointerImage != null) {
            this.pointerImage.flush();
        }
        this.pointerImage = this.create_POINTER_Image(n4);
        if (this.stepPointerImage != null) {
            this.stepPointerImage.flush();
        }
        this.stepPointerImage = this.create_STEPPOINTER_Image(n4);
        if (this.isForegroundVisible()) {
            switch (this.getFrameType()) {
                case SQUARE: {
                    FOREGROUND_FACTORY.createLinearForeground(n4, n4, false, this.bImage);
                    break;
                }
                default: {
                    FOREGROUND_FACTORY.createRadialForeground(n4, false, this.getForegroundType(), this.fImage);
                }
            }
        }
        if (this.disabledImage != null) {
            this.disabledImage.flush();
        }
        this.disabledImage = this.create_DISABLED_Image(n4);
        this.font = new Font("Verdana", 0, (int)(0.15 * (double)this.getWidth()));
        return this;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (!this.isInitialized()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.translate(-this.getFramelessOffset().getX(), -this.getFramelessOffset().getY());
        this.CENTER.setLocation(this.getGaugeBounds().getCenterX(), this.getGaugeBounds().getCenterX());
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.drawImage((Image)this.bImage, 0, 0, null);
        if (this.textOrientationFixed) {
            graphics2D.translate(this.getFramelessOffset().getX(), this.getFramelessOffset().getY());
            graphics2D.setColor(super.getBackgroundColor().LABEL_COLOR);
            if (this.decimalVisible) {
                graphics2D.setFont(this.font.deriveFont(0.1f * (float)this.getInnerBounds().width));
            } else {
                graphics2D.setFont(this.font.deriveFont(0.15f * (float)this.getInnerBounds().width));
            }
            this.textLayout = new TextLayout(this.DECIMAL_FORMAT.format(this.visibleValue) + "\u00b0", graphics2D.getFont(), this.RENDER_CONTEXT);
            this.TEXT_BOUNDARY.setFrame(this.textLayout.getBounds());
            graphics2D.drawString(this.DECIMAL_FORMAT.format(this.visibleValue) + "\u00b0", (float)((int)(((double)this.getInnerBounds().width - this.TEXT_BOUNDARY.getWidth()) / 2.0)), (float)((int)(((double)this.getInnerBounds().width - this.TEXT_BOUNDARY.getHeight()) / 2.0)) + this.textLayout.getAscent() - this.textLayout.getDescent());
            graphics2D.translate(-this.getFramelessOffset().getX(), -this.getFramelessOffset().getY());
        }
        graphics2D.rotate(this.getValue() * this.angleStep, this.CENTER.getX(), this.CENTER.getY());
        graphics2D.drawImage((Image)this.pointerImage, 0, 0, null);
        if (!this.textOrientationFixed) {
            if (!this.isFrameVisible()) {
                graphics2D.translate(this.getFramelessOffset().getX(), this.getFramelessOffset().getY());
            }
            graphics2D.setColor(super.getBackgroundColor().LABEL_COLOR);
            if (this.decimalVisible) {
                graphics2D.setFont(this.font.deriveFont(0.15f * (float)this.getInnerBounds().width));
            } else {
                graphics2D.setFont(this.font.deriveFont(0.2f * (float)this.getInnerBounds().width));
            }
            this.textLayout = new TextLayout(this.DECIMAL_FORMAT.format(this.visibleValue) + "\u00b0", graphics2D.getFont(), this.RENDER_CONTEXT);
            this.TEXT_BOUNDARY.setFrame(this.textLayout.getBounds());
            graphics2D.drawString(this.DECIMAL_FORMAT.format(this.visibleValue) + "\u00b0", (float)((int)(((double)this.getInnerBounds().width - this.TEXT_BOUNDARY.getWidth()) / 2.0)), (float)((int)(((double)this.getInnerBounds().width - this.TEXT_BOUNDARY.getHeight()) / 2.0)) + this.textLayout.getAscent() - this.textLayout.getDescent());
            graphics2D.translate(-this.getFramelessOffset().getX(), -this.getFramelessOffset().getY());
        }
        graphics2D.rotate(Math.toRadians(this.stepValue), this.CENTER.getX(), this.CENTER.getY());
        graphics2D.drawImage((Image)this.stepPointerImage, 0, 0, null);
        graphics2D.setTransform(affineTransform);
        graphics2D.drawImage((Image)this.fImage, 0, 0, null);
        if (!this.isEnabled()) {
            graphics2D.drawImage((Image)this.disabledImage, 0, 0, null);
        }
        graphics2D.translate(-this.getInnerBounds().x, -this.getInnerBounds().y);
        graphics2D.dispose();
    }

    @Override
    public void setValue(double d) {
        if (this.isEnabled()) {
            super.setValue(d);
            this.stepValue = 2 * ((int)(Math.abs(d) * 10.0) % 10);
            if (this.stepValue > 10) {
                this.stepValue -= 20;
            }
            if (d == 0.0) {
                this.visibleValue = 90.0;
            }
            if (d > 0.0 && d <= 90.0) {
                this.visibleValue = 90.0 - d % 360.0;
            }
            if (d > 90.0 && d <= 180.0) {
                this.visibleValue = d - 90.0;
            }
            if (d > 180.0 && d <= 270.0) {
                this.visibleValue = 270.0 - d;
            }
            if (d > 270.0 && d <= 360.0) {
                this.visibleValue = d - 270.0;
            }
            if (d < 0.0 && d >= -90.0) {
                this.visibleValue = 90.0 - Math.abs(d);
            }
            if (d < -90.0 && d >= -180.0) {
                this.visibleValue = Math.abs(d) - 90.0;
            }
            if (d < -180.0 && d >= -270.0) {
                this.visibleValue = 270.0 - Math.abs(d);
            }
            if (d < -270.0 && d >= -360.0) {
                this.visibleValue = Math.abs(d) - 270.0;
            }
            this.fireStateChanged();
            this.repaint();
        }
    }

    @Override
    public void setValueAnimated(double d) {
        if (this.isEnabled()) {
            if (360.0 - d + this.getValue() < d - this.getValue()) {
                d = 360.0 - d;
            }
            if (this.timeline.getState() == Timeline.TimelineState.PLAYING_FORWARD || this.timeline.getState() == Timeline.TimelineState.PLAYING_REVERSE) {
                this.timeline.abort();
            }
            this.timeline = new Timeline((Object)this);
            this.timeline.addPropertyToInterpolate("value", (Object)this.getValue(), (Object)d);
            this.timeline.setEase((TimelineEase)this.EASE);
            this.timeline.setDuration(this.easingDuration);
            this.timeline.play();
        }
    }

    @Override
    public double getMinValue() {
        return -360.0;
    }

    @Override
    public double getMaxValue() {
        return 360.0;
    }

    public boolean isTextOrientationFixed() {
        return this.textOrientationFixed;
    }

    public void setTextOrientationFixed(boolean bl) {
        this.textOrientationFixed = bl;
        this.repaint();
    }

    public boolean isDecimalVisible() {
        return this.decimalVisible;
    }

    public void setDecimalVisible(boolean bl) {
        if (bl) {
            this.DECIMAL_FORMAT.applyPattern("0.0");
        } else {
            this.DECIMAL_FORMAT.applyPattern("0");
        }
        this.decimalVisible = bl;
        this.repaint();
    }

    public long getEasingDuration() {
        return this.easingDuration;
    }

    public void setEasingDuration(long l) {
        this.easingDuration = l;
    }

    private void calcAngleStep() {
        this.angleStep = Math.PI * 4 / (this.getMaxValue() - this.getMinValue());
    }

    @Override
    public Point2D getCenter() {
        return new Point2D.Double((double)this.bImage.getWidth() / 2.0 + (double)this.getInnerBounds().x, (double)this.bImage.getHeight() / 2.0 + (double)this.getInnerBounds().y);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return new Rectangle2D.Double(this.bImage.getMinX(), this.bImage.getMinY(), this.bImage.getWidth(), this.bImage.getHeight());
    }

    @Override
    public Rectangle getLcdBounds() {
        return new Rectangle();
    }

    private BufferedImage create_TICKMARKS_Image(int n, double d, double d2, double d3, double d4, double d5, int n2, int n3, boolean bl, boolean bl2, ArrayList<Section> arrayList, BufferedImage bufferedImage) {
        if (n <= 0) {
            return null;
        }
        if (bufferedImage == null) {
            bufferedImage = UTIL.createImage(n, (int)(1.0 * (double)n), 3);
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int n4 = bufferedImage.getWidth();
        int n5 = bufferedImage.getHeight();
        Font font = new Font("Verdana", 0, (int)(0.04 * (double)n));
        Font font2 = new Font("Verdana", 0, (int)(0.03 * (double)n));
        BasicStroke basicStroke = new BasicStroke(1.0f, 1, 2);
        BasicStroke basicStroke2 = new BasicStroke(0.5f, 1, 2);
        BasicStroke basicStroke3 = new BasicStroke(0.1f, 1, 2);
        int n6 = (int)(0.08 * (double)n);
        int n7 = (int)(0.0133333333 * (double)n);
        int n8 = (int)(0.02 * (double)n);
        int n9 = (int)(0.04 * (double)n);
        float f = (float)n4 * 0.38f;
        Point2D.Double double_ = new Point2D.Double((float)n4 / 2.0f, (float)n5 / 2.0f);
        Point2D.Double double_2 = null;
        int n10 = 0;
        int n11 = 0;
        float f2 = 90.0f;
        boolean bl3 = false;
        float f3 = 1.0f;
        graphics2D.setFont(font);
        boolean bl4 = false;
        double d6 = 0.0;
        double d7 = 0.0;
        for (double d8 = Math.PI * 2; d8 >= Math.PI / 180; d8 -= Math.PI / 180) {
            Line2D.Double double_3;
            graphics2D.setStroke(basicStroke2);
            d6 = Math.sin(d8);
            d7 = Math.cos(d8);
            double_2 = new Point2D.Double(((Point2D)double_).getX() + (double)(f - (float)n6) * d6, ((Point2D)double_).getY() + (double)(f - (float)n6) * d7);
            Point2D.Double double_4 = new Point2D.Double(((Point2D)double_).getX() + (double)(f - (float)n7) * d6, ((Point2D)double_).getY() + (double)(f - (float)n7) * d7);
            Point2D.Double double_5 = new Point2D.Double(((Point2D)double_).getX() + (double)f * d6, ((Point2D)double_).getY() + (double)f * d7);
            graphics2D.setColor(super.getBackgroundColor().LABEL_COLOR);
            if (n10 % 5 == 0) {
                graphics2D.setColor(super.getBackgroundColor().LABEL_COLOR);
                graphics2D.setStroke(basicStroke2);
                double_4 = new Point2D.Double(((Point2D)double_).getX() + (double)(f - (float)n8) * d6, ((Point2D)double_).getY() + (double)(f - (float)n8) * d7);
                double_5 = new Point2D.Double(((Point2D)double_).getX() + (double)f * d6, ((Point2D)double_).getY() + (double)f * d7);
                double_3 = new Line2D.Double(((Point2D)double_4).getX(), ((Point2D)double_4).getY(), ((Point2D)double_5).getX(), ((Point2D)double_5).getY());
                graphics2D.draw(double_3);
            }
            if (n10 == 45 || n10 == 0) {
                graphics2D.setColor(super.getBackgroundColor().LABEL_COLOR);
                graphics2D.setStroke(basicStroke);
                double_4 = new Point2D.Double(((Point2D)double_).getX() + (double)(f - (float)n9) * d6, ((Point2D)double_).getY() + (double)(f - (float)n9) * d7);
                double_5 = new Point2D.Double(((Point2D)double_).getX() + (double)f * d6, ((Point2D)double_).getY() + (double)f * d7);
                double_2 = new Point2D.Double(((Point2D)double_).getX() + (double)(f - (float)n6) * d6, ((Point2D)double_).getY() + (double)(f - (float)n6) * d7);
                graphics2D.setFont(font);
                graphics2D.fill(UTIL.rotateTextAroundCenter(graphics2D, String.valueOf((int)f2) + "\u00b0", (int)((Point2D)double_2).getX(), (int)((Point2D)double_2).getY(), Math.PI - d8));
                if (bl4) {
                    double_2 = new Point2D.Double(((Point2D)double_).getX() + (double)(f - (float)(n6 * 2)) * d6, ((Point2D)double_).getY() + (double)(f - (float)(n6 * 2)) * d7);
                    graphics2D.setFont(font2);
                    graphics2D.fill(UTIL.rotateTextAroundCenter(graphics2D, "100%", (int)((Point2D)double_2).getX(), (int)((Point2D)double_2).getY(), Math.PI - d8));
                } else if (f2 == 0.0f) {
                    double_2 = new Point2D.Double(((Point2D)double_).getX() + (double)(f - (float)(n6 * 2)) * d6, ((Point2D)double_).getY() + (double)(f - (float)(n6 * 2)) * d7);
                    graphics2D.setFont(font2);
                    graphics2D.fill(UTIL.rotateTextAroundCenter(graphics2D, "0%", (int)((Point2D)double_2).getX(), (int)((Point2D)double_2).getY(), Math.PI - d8));
                } else {
                    double_2 = new Point2D.Double(((Point2D)double_).getX() + (double)(f - (float)(n6 * 2)) * d6, ((Point2D)double_).getY() + (double)(f - (float)(n6 * 2)) * d7);
                    graphics2D.setFont(font2);
                    graphics2D.fill(UTIL.rotateTextAroundCenter(graphics2D, "\u221e", (int)((Point2D)double_2).getX(), (int)((Point2D)double_2).getY(), Math.PI - d8));
                }
                bl4 ^= true;
                n10 = 0;
                ++n11;
                double_3 = new Line2D.Double(((Point2D)double_4).getX(), ((Point2D)double_4).getY(), ((Point2D)double_5).getX(), ((Point2D)double_5).getY());
                graphics2D.draw(double_3);
            }
            graphics2D.setStroke(basicStroke3);
            double_3 = new Line2D.Double(((Point2D)double_4).getX(), ((Point2D)double_4).getY(), ((Point2D)double_5).getX(), ((Point2D)double_5).getY());
            graphics2D.draw(double_3);
            ++n10;
            if (f2 == 0.0f) {
                bl3 = true;
            }
            if (f2 == 90.0f) {
                bl3 = false;
            }
            if (bl3) {
                f2 += f3;
                continue;
            }
            f2 -= f3;
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    protected BufferedImage create_POINTER_Image(int n) {
        if (n <= 0) {
            return null;
        }
        BufferedImage bufferedImage = UTIL.createImage(n, n, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n2 * 0.5233644859813084, (double)n3 * 0.35046728971962615);
        generalPath.lineTo((double)n2 * 0.5, (double)n3 * 0.1308411214953271);
        generalPath.lineTo((double)n2 * 0.4766355140186916, (double)n3 * 0.35046728971962615);
        generalPath.curveTo((double)n2 * 0.4766355140186916, (double)n3 * 0.35046728971962615, (double)n2 * 0.49065420560747663, (double)n3 * 0.34579439252336447, (double)n2 * 0.5, (double)n3 * 0.34579439252336447);
        generalPath.curveTo((double)n2 * 0.5093457943925234, (double)n3 * 0.34579439252336447, (double)n2 * 0.5233644859813084, (double)n3 * 0.35046728971962615, (double)n2 * 0.5233644859813084, (double)n3 * 0.35046728971962615);
        generalPath.closePath();
        Point2D.Double double_ = new Point2D.Double(0.0, generalPath.getBounds2D().getMinY());
        Point2D.Double double_2 = new Point2D.Double(0.0, generalPath.getBounds2D().getMaxY());
        float[] fArray = new float[]{0.0f, 0.3f, 0.59f, 1.0f};
        Color[] colorArray = new Color[]{UTIL.setAlpha(this.getPointerColor().DARK, 180), UTIL.setAlpha(this.getPointerColor().LIGHT, 180), UTIL.setAlpha(this.getPointerColor().LIGHT, 180), UTIL.setAlpha(this.getPointerColor().DARK, 180)};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(generalPath);
        Color color = this.getPointerColor().LIGHT;
        graphics2D.setColor(color);
        graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
        graphics2D.draw(generalPath);
        GeneralPath generalPath2 = new GeneralPath();
        generalPath2.setWindingRule(0);
        generalPath2.moveTo((double)n2 * 0.20093457943925233, (double)n3 * 0.43457943925233644);
        generalPath2.lineTo((double)n2 * 0.16355140186915887, (double)n3 * 0.43457943925233644);
        generalPath2.lineTo((double)n2 * 0.16355140186915887, (double)n3 * 0.5607476635514018);
        generalPath2.lineTo((double)n2 * 0.20093457943925233, (double)n3 * 0.5607476635514018);
        graphics2D.setColor(super.getBackgroundColor().LABEL_COLOR);
        graphics2D.draw(generalPath2);
        GeneralPath generalPath3 = new GeneralPath();
        generalPath3.setWindingRule(0);
        generalPath3.moveTo((double)n2 * 0.16355140186915887, (double)n3 * 0.4719626168224299);
        generalPath3.lineTo((double)n2 * 0.205607476635514, (double)n3 * 0.5);
        generalPath3.lineTo((double)n2 * 0.16355140186915887, (double)n3 * 0.5233644859813084);
        generalPath3.lineTo((double)n2 * 0.16355140186915887, (double)n3 * 0.4719626168224299);
        generalPath3.closePath();
        graphics2D.setColor(super.getBackgroundColor().LABEL_COLOR);
        graphics2D.fill(generalPath3);
        GeneralPath generalPath4 = new GeneralPath();
        generalPath4.setWindingRule(0);
        generalPath4.moveTo((double)n2 * 0.7990654205607477, (double)n3 * 0.43457943925233644);
        generalPath4.lineTo((double)n2 * 0.8364485981308412, (double)n3 * 0.43457943925233644);
        generalPath4.lineTo((double)n2 * 0.8364485981308412, (double)n3 * 0.5607476635514018);
        generalPath4.lineTo((double)n2 * 0.7990654205607477, (double)n3 * 0.5607476635514018);
        graphics2D.setColor(super.getBackgroundColor().LABEL_COLOR);
        graphics2D.draw(generalPath4);
        GeneralPath generalPath5 = new GeneralPath();
        generalPath5.setWindingRule(0);
        generalPath5.moveTo((double)n2 * 0.8364485981308412, (double)n3 * 0.4719626168224299);
        generalPath5.lineTo((double)n2 * 0.794392523364486, (double)n3 * 0.5);
        generalPath5.lineTo((double)n2 * 0.8364485981308412, (double)n3 * 0.5233644859813084);
        generalPath5.lineTo((double)n2 * 0.8364485981308412, (double)n3 * 0.4719626168224299);
        generalPath5.closePath();
        graphics2D.setColor(super.getBackgroundColor().LABEL_COLOR);
        graphics2D.fill(generalPath5);
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_STEPPOINTER_Image(int n) {
        if (n <= 0) {
            return null;
        }
        BufferedImage bufferedImage = UTIL.createImage(n, n, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n2 * 0.2850467289719626, (double)n3 * 0.514018691588785);
        generalPath.lineTo((double)n2 * 0.2102803738317757, (double)n3 * 0.5);
        generalPath.lineTo((double)n2 * 0.2850467289719626, (double)n3 * 0.48130841121495327);
        generalPath.curveTo((double)n2 * 0.2850467289719626, (double)n3 * 0.48130841121495327, (double)n2 * 0.2803738317757009, (double)n3 * 0.49065420560747663, (double)n2 * 0.2803738317757009, (double)n3 * 0.4953271028037383);
        generalPath.curveTo((double)n2 * 0.2803738317757009, (double)n3 * 0.5046728971962616, (double)n2 * 0.2850467289719626, (double)n3 * 0.514018691588785, (double)n2 * 0.2850467289719626, (double)n3 * 0.514018691588785);
        generalPath.closePath();
        Point2D.Double double_ = new Point2D.Double(generalPath.getBounds2D().getMinX(), 0.0);
        Point2D.Double double_2 = new Point2D.Double(generalPath.getBounds2D().getMaxX(), 0.0);
        float[] fArray = new float[]{0.0f, 0.3f, 0.59f, 1.0f};
        Color[] colorArray = new Color[]{UTIL.setAlpha(this.getPointerColor().DARK, 180), UTIL.setAlpha(this.getPointerColor().LIGHT, 180), UTIL.setAlpha(this.getPointerColor().LIGHT, 180), UTIL.setAlpha(this.getPointerColor().DARK, 180)};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(generalPath);
        Color color = UTIL.setAlpha(this.getPointerColor().LIGHT, 128);
        graphics2D.setColor(color);
        graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
        graphics2D.draw(generalPath);
        GeneralPath generalPath2 = new GeneralPath();
        generalPath2.setWindingRule(0);
        generalPath2.moveTo((double)n2 * 0.7149532710280374, (double)n3 * 0.514018691588785);
        generalPath2.lineTo((double)n2 * 0.7897196261682243, (double)n3 * 0.5);
        generalPath2.lineTo((double)n2 * 0.7149532710280374, (double)n3 * 0.48130841121495327);
        generalPath2.curveTo((double)n2 * 0.7149532710280374, (double)n3 * 0.48130841121495327, (double)n2 * 0.719626168224299, (double)n3 * 0.49065420560747663, (double)n2 * 0.719626168224299, (double)n3 * 0.4953271028037383);
        generalPath2.curveTo((double)n2 * 0.719626168224299, (double)n3 * 0.5046728971962616, (double)n2 * 0.7149532710280374, (double)n3 * 0.514018691588785, (double)n2 * 0.7149532710280374, (double)n3 * 0.514018691588785);
        generalPath2.closePath();
        Point2D.Double double_3 = new Point2D.Double(generalPath2.getBounds2D().getMaxX(), 0.0);
        Point2D.Double double_4 = new Point2D.Double(generalPath2.getBounds2D().getMinX(), 0.0);
        LinearGradientPaint linearGradientPaint2 = new LinearGradientPaint(double_3, double_4, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint2);
        graphics2D.fill(generalPath2);
        graphics2D.setColor(color);
        graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
        graphics2D.draw(generalPath2);
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    public String toString() {
        return "Level";
    }
}

