/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.gauges;

import eu.hansolo.steelseries.gauges.AbstractRadial;
import eu.hansolo.steelseries.tools.ColorDef;
import eu.hansolo.steelseries.tools.CustomColorDef;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public abstract class AbstractRadialBargraph
extends AbstractRadial {
    private final float[] LED_FRACTIONS = new float[]{0.0f, 1.0f};

    public AbstractRadialBargraph() {
        this.setLedPosition(0.453271028, 0.65);
        this.setUserLedPosition(0.453271028, 0.59);
    }

    public ColorDef getBarGraphColor() {
        return this.getModel().getValueColor();
    }

    public void setBarGraphColor(ColorDef colorDef) {
        this.getModel().setValueColor(colorDef);
        this.init(this.getInnerBounds().width, this.getInnerBounds().width);
        this.repaint(this.getInnerBounds());
    }

    public Color getCustomBargraphColor() {
        return this.getModel().getCustomValueColor();
    }

    public void setCustomBarGraphColor(Color color) {
        this.getModel().setCustomValueColorObject(new CustomColorDef(color));
        this.init(this.getInnerBounds().width, this.getInnerBounds().width);
        this.repaint(this.getInnerBounds());
    }

    public CustomColorDef getCustomBarGraphColorObject() {
        return this.getModel().getCustomValueColorObject();
    }

    public boolean isPeakValueEnabled() {
        return this.getModel().isPeakValueVisible();
    }

    public void setPeakValueEnabled(boolean bl) {
        this.getModel().setPeakValueVisible(bl);
    }

    protected BufferedImage create_BARGRAPH_TRACK_Image(int n, double d, double d2, double d3, double d4) {
        return this.create_BARGRAPH_TRACK_Image(n, d, d2, d3, d4, null);
    }

    protected BufferedImage create_BARGRAPH_TRACK_Image(int n, double d, double d2, double d3, double d4, BufferedImage bufferedImage) {
        if (n <= 0) {
            return null;
        }
        if (bufferedImage == null) {
            bufferedImage = UTIL.createImage(n, n, 3);
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        Arc2D.Double double_ = new Arc2D.Double(2);
        double_.setFrame((double)n2 * 0.1074766355, (double)n3 * 0.1074766355, (double)n2 * 0.785046729, (double)n3 * 0.785046729);
        ((Arc2D)double_).setAngleStart(d + 2.0);
        ((Arc2D)double_).setAngleExtent(d2 - 5.0);
        Ellipse2D.Double double_2 = new Ellipse2D.Double((double)n2 * 0.1822429907, (double)n3 * 0.1822429907, (double)n2 * 0.6355140187, (double)n3 * 0.6355140187);
        Area area = new Area(double_);
        area.subtract(new Area(double_2));
        Point2D.Double double_3 = new Point2D.Double(0.0, area.getBounds2D().getMinY());
        Point2D.Double double_4 = new Point2D.Double(0.0, area.getBounds2D().getMaxY());
        float[] fArray = new float[]{0.0f, 0.22f, 0.76f, 1.0f};
        Color[] colorArray = new Color[]{new Color(0, 0, 0, 255), new Color(51, 51, 51, 255), new Color(51, 51, 51, 255), new Color(100, 100, 100, 255)};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_3, double_4, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(area);
        Arc2D.Double double_5 = new Arc2D.Double(2);
        double_5.setFrame((double)n2 * 0.1121495327, (double)n3 * 0.1121495327, (double)n2 * 0.7803738318, (double)n3 * 0.7803738318);
        ((Arc2D)double_5).setAngleStart(d);
        ((Arc2D)double_5).setAngleExtent(d2);
        Ellipse2D.Double double_6 = new Ellipse2D.Double((double)n2 * 0.1822429907, (double)n3 * 0.1822429907, (double)n2 * 0.6448598131, (double)n3 * 0.6448598131);
        Area area2 = new Area(double_);
        area2.subtract(new Area(double_6));
        Point2D.Double double_7 = new Point2D.Double(0.0, area2.getBounds2D().getMinY());
        Point2D.Double double_8 = new Point2D.Double(0.0, area2.getBounds2D().getMaxY());
        float[] fArray2 = new float[]{0.0f, 1.0f};
        Color[] colorArray2 = new Color[]{new Color(17, 17, 17, 255), new Color(51, 51, 51, 255)};
        LinearGradientPaint linearGradientPaint2 = new LinearGradientPaint(double_7, double_8, fArray2, colorArray2);
        graphics2D.setPaint(linearGradientPaint2);
        graphics2D.fill(area2);
        Point2D.Double double_9 = new Point2D.Double((double)n / 2.0, (double)n / 2.0);
        Rectangle2D.Double double_10 = new Rectangle2D.Double((double)n * 0.1168224299, (double)n * 0.4859813084, (double)n * 0.06074766355140187, (double)n * 0.023364486);
        Point2D.Double double_11 = new Point2D.Double(double_10.getCenterX(), double_10.getCenterY());
        Color[] colorArray3 = new Color[]{new Color(60, 60, 60, 255), new Color(50, 50, 50, 255)};
        RadialGradientPaint radialGradientPaint = new RadialGradientPaint(double_11, (float)(0.030373831775700934 * (double)n2), this.LED_FRACTIONS, colorArray3);
        graphics2D.setPaint(radialGradientPaint);
        AffineTransform affineTransform = graphics2D.getTransform();
        for (double d5 = 0.0; d5 <= d3; d5 += 5.0) {
            graphics2D.rotate(Math.toRadians(d5 + d4), ((Point2D)double_9).getX(), ((Point2D)double_9).getY());
            graphics2D.fill(double_10);
            graphics2D.setTransform(affineTransform);
        }
        graphics2D.dispose();
        return bufferedImage;
    }
}

