/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.gauges;

import eu.hansolo.steelseries.gauges.Lcd;
import eu.hansolo.steelseries.tools.GlowImageFactory;
import eu.hansolo.steelseries.tools.LcdColor;
import eu.hansolo.steelseries.tools.NumberSystem;
import eu.hansolo.steelseries.tools.Util;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.Timer;
import javax.swing.border.Border;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.ease.Linear;
import org.pushingpixels.trident.ease.TimelineEase;

public final class DisplayMulti
extends JComponent
implements Lcd,
ActionListener {
    private final Util UTIL = Util.INSTANCE;
    private LcdColor lcdColor = LcdColor.WHITE_LCD;
    private Paint customLcdBackground = Color.BLACK;
    private Color customLcdForeground = Color.WHITE;
    private final Rectangle INNER_BOUNDS = new Rectangle(0, 0, 128, 64);
    private double lcdValue = 0.0;
    private double oldValue = 0.0;
    private static final String LCD_VALUE_PROPERTY = "lcdValue";
    private double lcdThreshold = 0.0;
    private boolean lcdThresholdVisible = false;
    private boolean lcdThresholdBehaviourInverted = false;
    private boolean lcdBackgroundVisible = true;
    private boolean lcdTextVisible = true;
    private boolean lcdBlinking = false;
    private final Timer LCD_BLINKING_TIMER;
    private BufferedImage lcdThresholdImage;
    private int lcdDecimals = 1;
    private String lcdUnitString = "unit";
    private boolean lcdUnitStringVisible = true;
    private boolean lcdScientificFormat = false;
    private boolean digitalFont = false;
    private boolean useCustomLcdUnitFont = false;
    private Font customLcdUnitFont;
    private Font lcdValueFont;
    private Font lcdFormerValueFont;
    private Font lcdUnitFont;
    private Font lcdInfoFont;
    private String lcdInfoString = "";
    private final Font LCD_STANDARD_FONT;
    private final Font LCD_DIGITAL_FONT;
    private BufferedImage lcdImage;
    private NumberSystem numberSystem;
    private Shape disabledShape;
    private final Color DISABLED_COLOR;
    private Timeline timeline;
    private final transient TimelineEase EASING;
    private final FontRenderContext RENDER_CONTEXT = new FontRenderContext(null, true, true);
    private TextLayout unitLayout;
    private final Rectangle2D UNIT_BOUNDARY = new Rectangle2D.Double();
    private TextLayout valueLayout;
    private final Rectangle2D VALUE_BOUNDARY = new Rectangle2D.Double();
    private TextLayout oldValueLayout;
    private final Rectangle2D OLD_VALUE_BOUNDARY = new Rectangle2D.Double();
    private TextLayout infoLayout;
    private final Rectangle2D INFO_BOUNDARY = new Rectangle2D.Double();
    private boolean glowVisible = false;
    private Color glowColor;
    private boolean glowing = false;
    private BufferedImage glowImageOn;
    private final transient ComponentListener COMPONENT_LISTENER = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            Container container = DisplayMulti.this.getParent();
            if (DisplayMulti.this.getWidth() < DisplayMulti.this.getMinimumSize().width && DisplayMulti.this.getHeight() < DisplayMulti.this.getMinimumSize().height) {
                if (container != null && DisplayMulti.this.getParent().getLayout() == null) {
                    DisplayMulti.this.setSize(DisplayMulti.this.getMinimumSize());
                } else {
                    DisplayMulti.this.setPreferredSize(DisplayMulti.this.getMinimumSize());
                }
            }
            if (container != null && DisplayMulti.this.getParent().getLayout() == null) {
                DisplayMulti.this.setSize(DisplayMulti.this.getWidth(), DisplayMulti.this.getHeight());
            } else {
                DisplayMulti.this.setPreferredSize(new Dimension(DisplayMulti.this.getWidth(), DisplayMulti.this.getHeight()));
            }
            DisplayMulti.this.calcInnerBounds();
            DisplayMulti.this.init(((DisplayMulti)DisplayMulti.this).getInnerBounds().width, ((DisplayMulti)DisplayMulti.this).getInnerBounds().height);
        }
    };

    public DisplayMulti() {
        this.LCD_BLINKING_TIMER = new Timer(500, this);
        this.customLcdUnitFont = new Font("Verdana", 0, 24);
        this.LCD_STANDARD_FONT = new Font("Verdana", 0, 30);
        this.LCD_DIGITAL_FONT = Util.INSTANCE.getDigitalFont().deriveFont(24).deriveFont(0);
        this.lcdInfoFont = new Font("Verdana", 0, 24);
        this.numberSystem = NumberSystem.DEC;
        this.DISABLED_COLOR = new Color(102, 102, 102, 178);
        this.timeline = new Timeline((Object)this);
        this.EASING = new Linear();
        this.glowColor = new Color(51, 255, 255);
        this.init(128, 64);
        this.addComponentListener(this.COMPONENT_LISTENER);
    }

    public final void init(int n, int n2) {
        if (n <= 1 || n2 <= 1) {
            return;
        }
        if (this.lcdImage != null) {
            this.lcdImage.flush();
        }
        this.lcdImage = this.create_LCD_Image(n, n2);
        if (this.glowImageOn != null) {
            this.glowImageOn.flush();
        }
        this.glowImageOn = GlowImageFactory.INSTANCE.createLcdGlow(n, n2, this.glowColor, true);
        double d = n > n2 ? (double)n2 * 0.095 : (double)n * 0.095;
        this.disabledShape = new RoundRectangle2D.Double(0.0, 0.0, n, n2, d, d);
        if (this.isDigitalFont()) {
            this.lcdValueFont = this.LCD_DIGITAL_FONT.deriveFont(0.5f * (float)this.getInnerBounds().height);
            this.lcdFormerValueFont = this.LCD_DIGITAL_FONT.deriveFont(0.2f * (float)this.getInnerBounds().height);
            this.lcdUnitFont = this.useCustomLcdUnitFont ? this.customLcdUnitFont.deriveFont(0.1875f * (float)this.getInnerBounds().height) : this.LCD_STANDARD_FONT.deriveFont(0.1875f * (float)this.getInnerBounds().height);
        } else {
            this.lcdValueFont = this.LCD_STANDARD_FONT.deriveFont(0.46875f * (float)this.getInnerBounds().height);
            this.lcdFormerValueFont = this.LCD_STANDARD_FONT.deriveFont(0.1875f * (float)this.getInnerBounds().height);
            this.lcdUnitFont = this.useCustomLcdUnitFont ? this.customLcdUnitFont.deriveFont(0.1875f * (float)this.getInnerBounds().height) : this.LCD_STANDARD_FONT.deriveFont(0.1875f * (float)this.getInnerBounds().height);
        }
        this.lcdInfoFont = this.LCD_STANDARD_FONT.deriveFont(0.15f * (float)this.getInnerBounds().height);
        if (this.lcdThresholdImage != null) {
            this.lcdThresholdImage.flush();
        }
        this.lcdThresholdImage = this.create_LCD_THRESHOLD_Image((int)((double)n2 * 0.2045454545), (int)((double)n2 * 0.2045454545), this.lcdColor.TEXT_COLOR);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        double d;
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.translate(this.getInnerBounds().x, this.getInnerBounds().y);
        if (this.lcdBackgroundVisible) {
            graphics2D.drawImage((Image)this.lcdImage, 0, 0, null);
        }
        if (this.lcdColor == LcdColor.CUSTOM) {
            graphics2D.setColor(this.customLcdForeground);
        } else {
            graphics2D.setColor(this.lcdColor.TEXT_COLOR);
        }
        graphics2D.setFont(this.lcdUnitFont);
        if (this.lcdUnitStringVisible && !this.lcdUnitString.isEmpty()) {
            this.unitLayout = new TextLayout(this.lcdUnitString, graphics2D.getFont(), this.RENDER_CONTEXT);
            this.UNIT_BOUNDARY.setFrame(this.unitLayout.getBounds());
            if (this.lcdTextVisible) {
                graphics2D.drawString(this.lcdUnitString, (float)((double)this.lcdImage.getWidth() - this.UNIT_BOUNDARY.getWidth() - (double)((float)this.lcdImage.getHeight() * 0.15f)), (float)this.lcdImage.getHeight() * 0.6f);
            }
            d = this.UNIT_BOUNDARY.getWidth();
        } else {
            d = 0.0;
        }
        switch (this.numberSystem) {
            default: {
                graphics2D.setFont(this.lcdValueFont);
                this.valueLayout = new TextLayout(this.formatLcdValue(this.lcdValue), graphics2D.getFont(), this.RENDER_CONTEXT);
                this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                if (this.lcdTextVisible) {
                    graphics2D.drawString(this.formatLcdValue(this.lcdValue), (float)((double)this.lcdImage.getMinX() + ((double)this.lcdImage.getWidth() - d - this.VALUE_BOUNDARY.getWidth()) - (double)this.lcdImage.getHeight() * 0.3), (float)this.lcdImage.getHeight() * 0.6f);
                }
                graphics2D.setFont(this.lcdFormerValueFont);
                this.oldValueLayout = new TextLayout(this.formatLcdValue(this.oldValue), graphics2D.getFont(), this.RENDER_CONTEXT);
                this.OLD_VALUE_BOUNDARY.setFrame(this.oldValueLayout.getBounds());
                if (!this.lcdTextVisible) break;
                graphics2D.drawString(this.formatLcdValue(this.oldValue), (float)(((double)this.lcdImage.getWidth() - this.OLD_VALUE_BOUNDARY.getWidth()) / 2.0), (float)this.lcdImage.getHeight() * 0.9f);
                break;
            }
            case HEX: {
                graphics2D.setFont(this.lcdValueFont);
                this.valueLayout = new TextLayout(Integer.toHexString((int)this.lcdValue).toUpperCase(), graphics2D.getFont(), this.RENDER_CONTEXT);
                this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                if (this.lcdTextVisible) {
                    graphics2D.drawString(Integer.toHexString((int)this.lcdValue).toUpperCase(), (float)((double)this.lcdImage.getMinX() + ((double)this.lcdImage.getWidth() - d - this.VALUE_BOUNDARY.getWidth()) - (double)this.lcdImage.getHeight() * 0.3), (float)this.lcdImage.getHeight() * 0.6f);
                }
                graphics2D.setFont(this.lcdFormerValueFont);
                this.oldValueLayout = new TextLayout(Integer.toHexString((int)this.oldValue).toUpperCase(), graphics2D.getFont(), this.RENDER_CONTEXT);
                this.OLD_VALUE_BOUNDARY.setFrame(this.oldValueLayout.getBounds());
                if (!this.lcdTextVisible) break;
                graphics2D.drawString(Integer.toHexString((int)this.oldValue).toUpperCase(), (float)(((double)this.lcdImage.getWidth() - this.OLD_VALUE_BOUNDARY.getWidth()) / 2.0), (float)this.lcdImage.getHeight() * 0.9f);
                break;
            }
            case OCT: {
                graphics2D.setFont(this.lcdValueFont);
                this.valueLayout = new TextLayout(Integer.toOctalString((int)this.lcdValue), graphics2D.getFont(), this.RENDER_CONTEXT);
                this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                if (this.lcdTextVisible) {
                    graphics2D.drawString(Integer.toOctalString((int)this.lcdValue), (float)((double)this.lcdImage.getMinX() + ((double)this.lcdImage.getWidth() - d - this.VALUE_BOUNDARY.getWidth()) - (double)this.lcdImage.getHeight() * 0.3), (float)this.lcdImage.getHeight() * 0.6f);
                }
                graphics2D.setFont(this.lcdFormerValueFont);
                this.oldValueLayout = new TextLayout(Integer.toOctalString((int)this.oldValue), graphics2D.getFont(), this.RENDER_CONTEXT);
                this.OLD_VALUE_BOUNDARY.setFrame(this.oldValueLayout.getBounds());
                if (!this.lcdTextVisible) break;
                graphics2D.drawString(Integer.toOctalString((int)this.oldValue), (float)(((double)this.lcdImage.getWidth() - this.OLD_VALUE_BOUNDARY.getWidth()) / 2.0), (float)this.lcdImage.getHeight() * 0.9f);
            }
        }
        if (!this.lcdInfoString.isEmpty()) {
            graphics2D.setFont(this.lcdInfoFont);
            this.infoLayout = new TextLayout(this.lcdInfoString, graphics2D.getFont(), this.RENDER_CONTEXT);
            this.INFO_BOUNDARY.setFrame(this.infoLayout.getBounds());
            graphics2D.drawString(this.lcdInfoString, 5.0f, (float)this.INFO_BOUNDARY.getHeight() + 5.0f);
        }
        if (this.numberSystem == NumberSystem.DEC && this.lcdThresholdVisible && this.lcdValue >= this.lcdThreshold) {
            if (!this.lcdThresholdBehaviourInverted) {
                if (this.lcdValue >= this.lcdThreshold) {
                    graphics2D.drawImage((Image)this.lcdThresholdImage, 5, this.getHeight() - this.lcdThresholdImage.getHeight() - 5, null);
                }
            } else if (this.lcdValue <= this.lcdThreshold) {
                graphics2D.drawImage((Image)this.lcdThresholdImage, 5, this.getHeight() - this.lcdThresholdImage.getHeight() - 5, null);
            }
        }
        if (this.glowVisible && this.glowing) {
            graphics2D.drawImage((Image)this.glowImageOn, 0, 0, null);
        }
        if (!this.isEnabled()) {
            graphics2D.setColor(this.DISABLED_COLOR);
            graphics2D.fill(this.disabledShape);
        }
        graphics2D.translate(-this.getInnerBounds().x, -this.getInnerBounds().y);
        graphics2D.dispose();
    }

    public BufferedImage getAsImage() {
        BufferedImage bufferedImage = this.UTIL.createImage(this.getWidth(), this.getHeight(), 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        this.paintAll(graphics2D);
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    public double getLcdValue() {
        return this.lcdValue;
    }

    @Override
    public void setLcdValue(double d) {
        this.oldValue = this.lcdValue;
        this.lcdValue = d;
        if (this.numberSystem != NumberSystem.DEC && this.lcdValue < 0.0) {
            this.setLcdNumberSystem(NumberSystem.DEC);
        }
        this.firePropertyChange(LCD_VALUE_PROPERTY, this.oldValue, d);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public void setLcdValueAnimated(double d) {
        if (this.isEnabled()) {
            if (this.timeline.getState() != Timeline.TimelineState.IDLE) {
                this.timeline.abort();
            }
            this.timeline = new Timeline((Object)this);
            this.timeline.addPropertyToInterpolate(LCD_VALUE_PROPERTY, (Object)this.lcdValue, (Object)d);
            this.timeline.setEase(this.EASING);
            this.timeline.setDuration(2000L);
            this.timeline.play();
        }
    }

    @Override
    public double getLcdThreshold() {
        return this.lcdThreshold;
    }

    @Override
    public void setLcdThreshold(double d) {
        this.lcdThreshold = d;
        if (this.lcdThresholdVisible) {
            this.repaint(this.getInnerBounds());
        }
    }

    @Override
    public boolean isLcdThresholdVisible() {
        return this.lcdThresholdVisible;
    }

    @Override
    public void setLcdThresholdVisible(boolean bl) {
        this.lcdThresholdVisible = bl;
        this.repaint(this.getInnerBounds());
    }

    @Override
    public boolean isLcdThresholdBehaviourInverted() {
        return this.lcdThresholdBehaviourInverted;
    }

    @Override
    public void setLcdThresholdBehaviourInverted(boolean bl) {
        this.lcdThresholdBehaviourInverted = bl;
        this.repaint(this.getInnerBounds());
    }

    @Override
    public boolean isLcdBlinking() {
        return this.lcdBlinking;
    }

    @Override
    public void setLcdBlinking(boolean bl) {
        this.lcdBlinking = bl;
        if (bl) {
            this.LCD_BLINKING_TIMER.start();
        } else {
            this.LCD_BLINKING_TIMER.stop();
        }
        this.repaint(this.getInnerBounds());
    }

    @Override
    public int getLcdDecimals() {
        return this.lcdDecimals;
    }

    @Override
    public void setLcdDecimals(int n) {
        this.lcdDecimals = n;
        this.repaint(this.getInnerBounds());
    }

    @Override
    public String getLcdUnitString() {
        return this.lcdUnitString;
    }

    @Override
    public void setLcdUnitString(String string) {
        this.lcdUnitString = string;
        this.repaint(this.getInnerBounds());
    }

    @Override
    public boolean isLcdUnitStringVisible() {
        return this.lcdUnitStringVisible;
    }

    @Override
    public void setLcdUnitStringVisible(boolean bl) {
        this.lcdUnitStringVisible = bl;
        this.repaint(this.getInnerBounds());
    }

    @Override
    public boolean isCustomLcdUnitFontEnabled() {
        return this.useCustomLcdUnitFont;
    }

    @Override
    public void setCustomLcdUnitFontEnabled(boolean bl) {
        this.useCustomLcdUnitFont = bl;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Font getCustomLcdUnitFont() {
        return this.customLcdUnitFont;
    }

    @Override
    public void setCustomLcdUnitFont(Font font) {
        this.customLcdUnitFont = font;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public void setLcdScientificFormat(boolean bl) {
        this.lcdScientificFormat = bl;
    }

    @Override
    public boolean isLcdScientificFormat() {
        return this.lcdScientificFormat;
    }

    @Override
    public boolean isDigitalFont() {
        return this.digitalFont;
    }

    @Override
    public void setDigitalFont(boolean bl) {
        this.digitalFont = bl;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public LcdColor getLcdColor() {
        return this.lcdColor;
    }

    @Override
    public void setLcdColor(LcdColor lcdColor) {
        this.lcdColor = lcdColor;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Paint getCustomLcdBackground() {
        return this.customLcdBackground;
    }

    @Override
    public void setCustomLcdBackground(Paint paint) {
        this.customLcdBackground = paint;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Color getCustomLcdForeground() {
        return this.customLcdForeground;
    }

    @Override
    public Paint createCustomLcdBackgroundPaint(Color[] colorArray) {
        Point2D.Double double_ = new Point2D.Double(0.0, 1.0);
        Point2D.Double double_2 = new Point2D.Double(0.0, this.getHeight() - 1);
        if (double_.equals(double_2)) {
            ((Point2D)double_2).setLocation(0.0, ((Point2D)double_).getY() + 1.0);
        }
        float[] fArray = new float[]{0.0f, 0.03f, 0.49f, 0.5f, 1.0f};
        Color[] colorArray2 = new Color[]{colorArray[0], colorArray[1], colorArray[2], colorArray[3], colorArray[4]};
        return new LinearGradientPaint(double_, double_2, fArray, colorArray2);
    }

    @Override
    public boolean isLcdBackgroundVisible() {
        return this.lcdBackgroundVisible;
    }

    @Override
    public void setLcdBackgroundVisible(boolean bl) {
        this.lcdBackgroundVisible = bl;
        this.repaint(this.getInnerBounds());
    }

    @Override
    public void setCustomLcdForeground(Color color) {
        this.customLcdForeground = color;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public String formatLcdValue(double d) {
        StringBuilder stringBuilder = new StringBuilder(16);
        stringBuilder.append("0");
        if (this.lcdDecimals > 0) {
            stringBuilder.append(".");
        }
        for (int i = 0; i < this.lcdDecimals; ++i) {
            stringBuilder.append("0");
        }
        if (this.lcdScientificFormat) {
            stringBuilder.append("E0");
        }
        stringBuilder.trimToSize();
        DecimalFormat decimalFormat = new DecimalFormat(stringBuilder.toString(), new DecimalFormatSymbols(Locale.US));
        return decimalFormat.format(d);
    }

    @Override
    public boolean isValueCoupled() {
        return false;
    }

    @Override
    public void setValueCoupled(boolean bl) {
    }

    @Override
    public Font getLcdValueFont() {
        return this.lcdValueFont;
    }

    @Override
    public void setLcdValueFont(Font font) {
        this.lcdValueFont = font;
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Font getLcdUnitFont() {
        return this.lcdUnitFont;
    }

    @Override
    public void setLcdUnitFont(Font font) {
        this.lcdUnitFont = font;
        this.repaint(this.getInnerBounds());
    }

    @Override
    public String getLcdInfoString() {
        return this.lcdInfoString;
    }

    @Override
    public void setLcdInfoString(String string) {
        this.lcdInfoString = string;
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Font getLcdInfoFont() {
        return this.lcdInfoFont;
    }

    @Override
    public void setLcdInfoFont(Font font) {
        this.lcdInfoFont = font;
        this.repaint(this.getInnerBounds());
    }

    @Override
    public NumberSystem getLcdNumberSystem() {
        return this.numberSystem;
    }

    @Override
    public void setLcdNumberSystem(NumberSystem numberSystem) {
        this.numberSystem = numberSystem;
        switch (numberSystem) {
            case HEX: {
                this.lcdInfoString = "hex";
                break;
            }
            case OCT: {
                this.lcdInfoString = "oct";
                break;
            }
            default: {
                this.lcdInfoString = "";
            }
        }
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Rectangle getLcdBounds() {
        return this.getInnerBounds();
    }

    public boolean isGlowVisible() {
        return this.glowVisible;
    }

    public void setGlowVisible(boolean bl) {
        this.glowVisible = bl;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint();
    }

    public Color getGlowColor() {
        return this.glowColor;
    }

    public void setGlowColor(Color color) {
        this.glowColor = color;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint();
    }

    public boolean isGlowing() {
        return this.glowing;
    }

    public void setGlowing(boolean bl) {
        this.glowing = bl;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint();
    }

    private BufferedImage create_LCD_Image(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            return null;
        }
        BufferedImage bufferedImage = this.UTIL.createImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
        Point2D.Double double_2 = new Point2D.Double(0.0, n4);
        if (double_.equals(double_2)) {
            ((Point2D)double_2).setLocation(0.0, ((Point2D)double_).getY() + 1.0);
        }
        float[] fArray = new float[]{0.0f, 0.08f, 0.92f, 1.0f};
        Color[] colorArray = new Color[]{new Color(0.4f, 0.4f, 0.4f, 1.0f), new Color(0.5f, 0.5f, 0.5f, 1.0f), new Color(0.5f, 0.5f, 0.5f, 1.0f), new Color(0.9f, 0.9f, 0.9f, 1.0f)};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray);
        double d = n > n2 ? (double)n2 * 0.095 : (double)n * 0.095;
        RoundRectangle2D.Double double_3 = new RoundRectangle2D.Double(0.0, 0.0, n3, n4, d, d);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(double_3);
        Point2D.Double double_4 = new Point2D.Double(0.0, 1.0);
        Point2D.Double double_5 = new Point2D.Double(0.0, n4 - 1);
        if (double_4.equals(double_5)) {
            ((Point2D)double_5).setLocation(0.0, ((Point2D)double_4).getY() + 1.0);
        }
        float[] fArray2 = new float[]{0.0f, 0.03f, 0.49f, 0.5f, 1.0f};
        Color[] colorArray2 = new Color[]{this.lcdColor.GRADIENT_START_COLOR, this.lcdColor.GRADIENT_FRACTION1_COLOR, this.lcdColor.GRADIENT_FRACTION2_COLOR, this.lcdColor.GRADIENT_FRACTION3_COLOR, this.lcdColor.GRADIENT_STOP_COLOR};
        if (this.lcdColor == LcdColor.CUSTOM) {
            graphics2D.setPaint(this.customLcdBackground);
        } else {
            LinearGradientPaint linearGradientPaint2 = new LinearGradientPaint(double_4, double_5, fArray2, colorArray2);
            graphics2D.setPaint(linearGradientPaint2);
        }
        double d2 = ((RoundRectangle2D)double_3).getArcWidth() - 1.0;
        RoundRectangle2D.Double double_6 = new RoundRectangle2D.Double(1.0, 1.0, n3 - 2, n4 - 2, d2, d2);
        graphics2D.fill(double_6);
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_LCD_THRESHOLD_Image(int n, int n2, Color color) {
        if (n <= 0 || n2 <= 0) {
            return null;
        }
        BufferedImage bufferedImage = this.UTIL.createImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n3 * 0.4444444444444444, (double)n4 * 0.7777777777777778);
        generalPath.lineTo((double)n3 * 0.5555555555555556, (double)n4 * 0.7777777777777778);
        generalPath.lineTo((double)n3 * 0.5555555555555556, (double)n4 * 0.8888888888888888);
        generalPath.lineTo((double)n3 * 0.4444444444444444, (double)n4 * 0.8888888888888888);
        generalPath.lineTo((double)n3 * 0.4444444444444444, (double)n4 * 0.7777777777777778);
        generalPath.closePath();
        generalPath.moveTo((double)n3 * 0.4444444444444444, (double)n4 * 0.3333333333333333);
        generalPath.lineTo((double)n3 * 0.5555555555555556, (double)n4 * 0.3333333333333333);
        generalPath.lineTo((double)n3 * 0.5555555555555556, (double)n4 * 0.7222222222222222);
        generalPath.lineTo((double)n3 * 0.4444444444444444, (double)n4 * 0.7222222222222222);
        generalPath.lineTo((double)n3 * 0.4444444444444444, (double)n4 * 0.3333333333333333);
        generalPath.closePath();
        generalPath.moveTo(0.0, (double)n4);
        generalPath.lineTo(n3, n4);
        generalPath.lineTo((double)n3 * 0.5, 0.0);
        generalPath.lineTo(0.0, (double)n4);
        generalPath.closePath();
        graphics2D.setColor(color);
        graphics2D.fill(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    private void calcInnerBounds() {
        Insets insets = this.getInsets();
        this.INNER_BOUNDS.setBounds(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
    }

    private Rectangle getInnerBounds() {
        return this.INNER_BOUNDS;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        if (dimension.width < 64 || dimension.height < 32) {
            dimension = new Dimension(64, 32);
        }
        return dimension;
    }

    @Override
    public void setMinimumSize(Dimension dimension) {
        int n = dimension.width < 64 ? 64 : dimension.width;
        int n2 = dimension.height < 32 ? 32 : dimension.height;
        super.setMinimumSize(new Dimension(n, n2));
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.invalidate();
        this.repaint();
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension dimension = super.getMaximumSize();
        if (dimension.width > 1920 || dimension.height > 960) {
            dimension = new Dimension(1920, 960);
        }
        return dimension;
    }

    @Override
    public void setMaximumSize(Dimension dimension) {
        int n = dimension.width > 1920 ? 1920 : dimension.width;
        int n2 = dimension.height > 960 ? 960 : dimension.height;
        super.setMaximumSize(new Dimension(n, n2));
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.invalidate();
        this.repaint();
    }

    @Override
    public void setPreferredSize(Dimension dimension) {
        super.setPreferredSize(dimension);
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.invalidate();
        this.repaint();
    }

    @Override
    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public void setSize(Dimension dimension) {
        super.setSize(dimension);
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public void setBounds(Rectangle rectangle) {
        super.setBounds(rectangle);
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public void setBorder(Border border) {
        super.setBorder(border);
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.LCD_BLINKING_TIMER)) {
            this.lcdTextVisible ^= true;
        }
        this.repaint(this.getInnerBounds());
    }

    @Override
    public String toString() {
        return "DisplayMulti";
    }
}

