/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.tools;

public class Histogram {
    private final float MIN_VALUE;
    private final float MINOR_TICKMARK_SPACING;
    private final double[] FREQUENCE;
    private double max;
    private int n;

    public Histogram(double d, double d2, double d3) {
        this.MIN_VALUE = (float)d;
        this.MINOR_TICKMARK_SPACING = (float)d3;
        this.n = (int)((d2 - d) / d3);
        this.FREQUENCE = new double[this.n];
    }

    public void addDataPoint(int n) {
        int n2 = n > this.n - 1 ? this.n - 1 : n;
        this.FREQUENCE[n2] = this.FREQUENCE[n2] + 1.0;
        this.max = this.FREQUENCE[n] > this.max ? this.FREQUENCE[n] : this.max;
    }

    public void addDataPoint(double d) {
        int n = Math.round((float)d / this.MINOR_TICKMARK_SPACING) - Math.round(this.MIN_VALUE / this.MINOR_TICKMARK_SPACING);
        this.addDataPoint(n);
    }

    public double[] getData() {
        return (double[])this.FREQUENCE.clone();
    }
}

