/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.tools;

import eu.hansolo.steelseries.tools.ConicalGradientPaint;
import eu.hansolo.steelseries.tools.KnobStyle;
import eu.hansolo.steelseries.tools.KnobType;
import eu.hansolo.steelseries.tools.Util;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;

public enum KnobImageFactory {
    INSTANCE;

    private final Util UTIL = Util.INSTANCE;
    private int sizeBuffer = 0;
    private KnobType knobTypeBuffer = KnobType.SMALL_STD_KNOB;
    private KnobStyle knobStyleBuffer = KnobStyle.SILVER;
    private BufferedImage knobImageBuffer = this.UTIL.createImage(1, 1, 3);

    public BufferedImage create_KNOB_Image(int n, KnobType knobType, KnobStyle knobStyle) {
        if (n <= 0) {
            return this.UTIL.createImage(1, 1, 3);
        }
        if (this.sizeBuffer == n && this.knobTypeBuffer == knobType && this.knobStyleBuffer == knobStyle) {
            return this.knobImageBuffer;
        }
        this.knobImageBuffer.flush();
        this.knobImageBuffer = this.UTIL.createImage(n, n, 3);
        Graphics2D graphics2D = this.knobImageBuffer.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n2 = this.knobImageBuffer.getWidth();
        int n3 = this.knobImageBuffer.getHeight();
        switch (knobType) {
            case SMALL_STD_KNOB: {
                Color[] colorArray;
                Ellipse2D.Double double_ = new Ellipse2D.Double(0.0, 0.0, n2, n3);
                Point2D.Double double_2 = new Point2D.Double(0.0, double_.getBounds2D().getMinY());
                Point2D.Double double_3 = new Point2D.Double(0.0, double_.getBounds2D().getMaxY());
                float[] fArray = new float[]{0.0f, 0.46f, 1.0f};
                Color[] colorArray2 = new Color[]{new Color(180, 180, 180, 255), new Color(63, 63, 63, 255), new Color(40, 40, 40, 255)};
                LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_2, double_3, fArray, colorArray2);
                graphics2D.setPaint(linearGradientPaint);
                graphics2D.fill(double_);
                Ellipse2D.Double double_4 = new Ellipse2D.Double(((double)n2 - (double)n2 * 0.77) / 2.0, ((double)n2 - (double)n2 * 0.77) / 2.0, (double)n2 * 0.77, (double)n2 * 0.77);
                Point2D.Double double_5 = new Point2D.Double(0.0, double_4.getBounds2D().getMinY());
                Point2D.Double double_6 = new Point2D.Double(0.0, double_4.getBounds2D().getMaxY());
                float[] fArray2 = new float[]{0.0f, 0.5f, 1.0f};
                switch (knobStyle) {
                    case BLACK: {
                        colorArray = new Color[]{new Color(0xBFBFBF), new Color(2828847), new Color(8224384)};
                        break;
                    }
                    case BRASS: {
                        colorArray = new Color[]{new Color(14667950), new Color(8019518), new Color(13614749)};
                        break;
                    }
                    default: {
                        colorArray = new Color[]{new Color(0xD7D7D7), new Color(0x747474), new Color(0xD7D7D7)};
                    }
                }
                LinearGradientPaint linearGradientPaint2 = new LinearGradientPaint(double_5, double_6, fArray2, colorArray);
                graphics2D.setPaint(linearGradientPaint2);
                graphics2D.fill(double_4);
                Ellipse2D.Double double_7 = new Ellipse2D.Double(((double)n2 - (double)n2 * 0.77) / 2.0, ((double)n2 - (double)n2 * 0.77) / 2.0, (double)n2 * 0.77, (double)n2 * 0.77);
                Point2D.Double double_8 = new Point2D.Double(double_7.getCenterX(), double_7.getCenterY());
                float[] fArray3 = new float[]{0.0f, 0.75f, 0.76f, 1.0f};
                Color[] colorArray3 = new Color[]{new Color(0, 0, 0, 0), new Color(0, 0, 0, 0), new Color(0, 0, 0, 1), new Color(0, 0, 0, 51)};
                RadialGradientPaint radialGradientPaint = new RadialGradientPaint(double_8, (float)(((RectangularShape)double_7).getWidth() / 2.0), fArray3, colorArray3);
                graphics2D.setPaint(radialGradientPaint);
                graphics2D.fill(double_7);
                break;
            }
            case BIG_STD_KNOB: {
                Color[] colorArray;
                Color[] colorArray4;
                Color[] colorArray5;
                Color[] colorArray6;
                Ellipse2D.Double double_ = new Ellipse2D.Double((double)n2 * 0.4392523467540741, (double)n3 * 0.4392523467540741, (double)n2 * 0.1214953362941742, (double)n3 * 0.1214953362941742);
                Point2D.Double double_9 = new Point2D.Double(0.0, double_.getBounds2D().getMinY());
                Point2D.Double double_10 = new Point2D.Double(0.0, double_.getBounds2D().getMaxY());
                float[] fArray = new float[]{0.0f, 1.0f};
                switch (knobStyle) {
                    case BLACK: {
                        colorArray6 = new Color[]{new Color(129, 133, 136, 255), new Color(61, 61, 73, 255)};
                        break;
                    }
                    case BRASS: {
                        colorArray6 = new Color[]{new Color(143, 117, 80, 255), new Color(100, 76, 49, 255)};
                        break;
                    }
                    default: {
                        colorArray6 = new Color[]{new Color(152, 152, 152, 255), new Color(118, 121, 126, 255)};
                    }
                }
                LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_9, double_10, fArray, colorArray6);
                graphics2D.setPaint(linearGradientPaint);
                graphics2D.fill(double_);
                Ellipse2D.Double double_11 = new Ellipse2D.Double((double)n2 * 0.44392523169517517, (double)n3 * 0.44392523169517517, (double)n2 * 0.11214950680732727, (double)n3 * 0.11214950680732727);
                Point2D.Double double_12 = new Point2D.Double(0.0, double_11.getBounds2D().getMinY());
                Point2D.Double double_13 = new Point2D.Double(0.0, double_11.getBounds2D().getMaxY());
                float[] fArray4 = new float[]{0.0f, 1.0f};
                switch (knobStyle) {
                    case BLACK: {
                        colorArray5 = new Color[]{new Color(26, 27, 32, 255), new Color(96, 97, 102, 255)};
                        break;
                    }
                    case BRASS: {
                        colorArray5 = new Color[]{new Color(98, 75, 49, 255), new Color(149, 109, 54, 255)};
                        break;
                    }
                    default: {
                        colorArray5 = new Color[]{new Color(118, 121, 126, 255), new Color(191, 191, 191, 255)};
                    }
                }
                LinearGradientPaint linearGradientPaint3 = new LinearGradientPaint(double_12, double_13, fArray4, colorArray5);
                graphics2D.setPaint(linearGradientPaint3);
                graphics2D.fill(double_11);
                Ellipse2D.Double double_14 = new Ellipse2D.Double((double)n2 * 0.4532710313796997, (double)n3 * 0.4532710313796997, (double)n2 * 0.09345793724060059, (double)n3 * 0.09345793724060059);
                Point2D.Double double_15 = new Point2D.Double(0.0, double_14.getBounds2D().getMinY());
                Point2D.Double double_16 = new Point2D.Double(0.0, double_14.getBounds2D().getMaxY());
                float[] fArray5 = new float[]{0.0f, 0.47f, 1.0f};
                switch (knobStyle) {
                    case BLACK: {
                        colorArray4 = new Color[]{new Color(191, 191, 191, 255), new Color(56, 57, 61, 255), new Color(143, 144, 146, 255)};
                        break;
                    }
                    case BRASS: {
                        colorArray4 = new Color[]{new Color(147, 108, 54, 255), new Color(82, 66, 50, 255), new Color(147, 108, 54, 255)};
                        break;
                    }
                    default: {
                        colorArray4 = new Color[]{new Color(191, 191, 191, 255), new Color(116, 116, 116, 255), new Color(143, 144, 146, 255)};
                    }
                }
                LinearGradientPaint linearGradientPaint4 = new LinearGradientPaint(double_15, double_16, fArray5, colorArray4);
                graphics2D.setPaint(linearGradientPaint4);
                graphics2D.fill(double_14);
                Ellipse2D.Double double_17 = new Ellipse2D.Double((double)n2 * 0.4579439163208008, (double)n3 * 0.4579439163208008, (double)n2 * 0.08411216735839844, (double)n3 * 0.08411216735839844);
                Point2D.Double double_18 = new Point2D.Double(0.0, double_17.getBounds2D().getMinY());
                Point2D.Double double_19 = new Point2D.Double(0.0, double_17.getBounds2D().getMaxY());
                float[] fArray6 = new float[]{0.0f, 0.21f, 0.5f, 0.78f, 1.0f};
                switch (knobStyle) {
                    case BLACK: {
                        colorArray = new Color[]{new Color(191, 191, 191, 255), new Color(94, 93, 99, 255), new Color(43, 42, 47, 255), new Color(78, 79, 81, 255), new Color(143, 144, 146, 255)};
                        break;
                    }
                    case BRASS: {
                        colorArray = new Color[]{new Color(223, 208, 174, 255), new Color(159, 136, 104, 255), new Color(122, 94, 62, 255), new Color(159, 136, 104, 255), new Color(223, 208, 174, 255)};
                        break;
                    }
                    default: {
                        colorArray = new Color[]{new Color(215, 215, 215, 255), new Color(139, 142, 145, 255), new Color(100, 100, 100, 255), new Color(139, 142, 145, 255), new Color(215, 215, 215, 255)};
                    }
                }
                LinearGradientPaint linearGradientPaint5 = new LinearGradientPaint(double_18, double_19, fArray6, colorArray);
                graphics2D.setPaint(linearGradientPaint5);
                graphics2D.fill(double_17);
                break;
            }
            case BIG_CHROME_KNOB: {
                Ellipse2D.Double double_ = new Ellipse2D.Double((double)n2 * 0.42990654706954956, (double)n3 * 0.42990654706954956, (double)n2 * (double)0.1401869f, (double)n3 * (double)0.1401869f);
                Point2D.Double double_20 = new Point2D.Double(0.46261682242990654 * (double)n2, 0.4392523364485981 * (double)n3);
                Point2D.Double double_21 = new Point2D.Double(0.534428311508238 * (double)n2, 0.5541747420025063 * (double)n3);
                float[] fArray = new float[]{0.0f, 1.0f};
                Color[] colorArray = new Color[]{new Color(129, 139, 140, 255), new Color(166, 171, 175, 255)};
                LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_20, double_21, fArray, colorArray);
                graphics2D.setPaint(linearGradientPaint);
                graphics2D.fill(double_);
                Ellipse2D.Double double_22 = new Ellipse2D.Double((double)n2 * 0.43457943201065063, (double)n3 * 0.43457943201065063, (double)n2 * 0.13084113597869873, (double)n3 * 0.13084113597869873);
                Point2D.Double double_23 = new Point2D.Double(double_22.getCenterX(), double_22.getCenterY());
                float[] fArray7 = new float[]{0.0f, 0.09f, 0.12f, 0.16f, 0.25f, 0.29f, 0.33f, 0.38f, 0.48f, 0.52f, 0.65f, 0.69f, 0.8f, 0.83f, 0.87f, 0.97f, 1.0f};
                Color[] colorArray7 = new Color[]{new Color(255, 255, 255, 255), new Color(255, 255, 255, 255), new Color(136, 136, 138, 255), new Color(164, 185, 190, 255), new Color(158, 179, 182, 255), new Color(112, 112, 112, 255), new Color(221, 227, 227, 255), new Color(155, 176, 179, 255), new Color(156, 176, 177, 255), new Color(254, 255, 255, 255), new Color(255, 255, 255, 255), new Color(156, 180, 180, 255), new Color(198, 209, 211, 255), new Color(246, 248, 247, 255), new Color(204, 216, 216, 255), new Color(164, 188, 190, 255), new Color(255, 255, 255, 255)};
                ConicalGradientPaint conicalGradientPaint = new ConicalGradientPaint(false, double_23, 0.0f, fArray7, colorArray7);
                graphics2D.setPaint(conicalGradientPaint);
                graphics2D.fill(double_22);
                Ellipse2D.Double double_24 = new Ellipse2D.Double((double)n2 * 0.4672897160053253, (double)n3 * 0.4672897160053253, (double)n2 * 0.06542053818702698, (double)n3 * 0.06542053818702698);
                Point2D.Double double_25 = new Point2D.Double(0.48130841121495327 * (double)n2, 0.4719626168224299 * (double)n3);
                Point2D.Double double_26 = new Point2D.Double(0.5152780735753257 * (double)n2, 0.5223247123514745 * (double)n3);
                float[] fArray8 = new float[]{0.0f, 1.0f};
                Color[] colorArray8 = new Color[]{new Color(225, 235, 232, 255), new Color(196, 207, 207, 255)};
                LinearGradientPaint linearGradientPaint6 = new LinearGradientPaint(double_25, double_26, fArray8, colorArray8);
                graphics2D.setPaint(linearGradientPaint6);
                graphics2D.fill(double_24);
                Ellipse2D.Double double_27 = new Ellipse2D.Double((double)n2 * 0.4719626307487488, (double)n3 * 0.4719626307487488, (double)n2 * 0.05607473850250244, (double)n3 * 0.05607473850250244);
                Point2D.Double double_28 = new Point2D.Double(0.48130841121495327 * (double)n2, 0.4766355140186916 * (double)n3);
                Point2D.Double double_29 = new Point2D.Double(0.5126650226245278 * (double)n2, 0.5231236021993482 * (double)n3);
                float[] fArray9 = new float[]{0.0f, 1.0f};
                Color[] colorArray9 = new Color[]{new Color(237, 239, 237, 255), new Color(148, 161, 161, 255)};
                LinearGradientPaint linearGradientPaint7 = new LinearGradientPaint(double_28, double_29, fArray9, colorArray9);
                graphics2D.setPaint(linearGradientPaint7);
                graphics2D.fill(double_27);
                break;
            }
            case METAL_KNOB: {
                Color[] colorArray;
                Ellipse2D.Double double_ = new Ellipse2D.Double((double)n2 * 0.4579439163208008, (double)n3 * 0.4579439163208008, (double)n2 * 0.08411216735839844, (double)n3 * 0.08411216735839844);
                Point2D.Double double_30 = new Point2D.Double(0.0, double_.getBounds2D().getMinY());
                Point2D.Double double_31 = new Point2D.Double(0.0, double_.getBounds2D().getMaxY());
                float[] fArray = new float[]{0.0f, 0.47f, 1.0f};
                Color[] colorArray10 = new Color[]{new Color(92, 95, 101, 255), new Color(46, 49, 53, 255), new Color(22, 23, 26, 255)};
                LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_30, double_31, fArray, colorArray10);
                graphics2D.setPaint(linearGradientPaint);
                graphics2D.fill(double_);
                Ellipse2D.Double double_32 = new Ellipse2D.Double((double)n2 * 0.46261683106422424, (double)n3 * 0.46261683106422424, (double)n2 * 0.0747663676738739, (double)n3 * 0.0747663676738739);
                Point2D.Double double_33 = new Point2D.Double(0.0, double_32.getBounds2D().getMinY());
                Point2D.Double double_34 = new Point2D.Double(0.0, double_32.getBounds2D().getMaxY());
                float[] fArray10 = new float[]{0.0f, 1.0f};
                switch (knobStyle) {
                    case BLACK: {
                        colorArray = new Color[]{new Color(2828847), new Color(1710880)};
                        break;
                    }
                    case BRASS: {
                        colorArray = new Color[]{new Color(9858614), new Color(8150845)};
                        break;
                    }
                    default: {
                        colorArray = new Color[]{new Color(204, 204, 204, 255), new Color(87, 92, 98, 255)};
                    }
                }
                LinearGradientPaint linearGradientPaint8 = new LinearGradientPaint(double_33, double_34, fArray10, colorArray);
                graphics2D.setPaint(linearGradientPaint8);
                graphics2D.fill(double_32);
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.5280373831775701);
                generalPath.curveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.5186915887850467, (double)n2 * 0.5093457943925234, (double)n3 * 0.514018691588785, (double)n2 * 0.5, (double)n3 * 0.514018691588785);
                generalPath.curveTo((double)n2 * 0.48598130841121495, (double)n3 * 0.514018691588785, (double)n2 * 0.4766355140186916, (double)n3 * 0.5186915887850467, (double)n2 * 0.4766355140186916, (double)n3 * 0.5280373831775701);
                generalPath.curveTo((double)n2 * 0.48130841121495327, (double)n3 * 0.5327102803738317, (double)n2 * 0.49065420560747663, (double)n3 * 0.5373831775700935, (double)n2 * 0.5, (double)n3 * 0.5373831775700935);
                generalPath.curveTo((double)n2 * 0.5046728971962616, (double)n3 * 0.5373831775700935, (double)n2 * 0.514018691588785, (double)n3 * 0.5327102803738317, (double)n2 * 0.5186915887850467, (double)n3 * 0.5280373831775701);
                generalPath.closePath();
                Point2D.Double double_35 = new Point2D.Double(0.5 * (double)n2, 0.5373831775700935 * (double)n3);
                float[] fArray11 = new float[]{0.0f, 1.0f};
                Color[] colorArray11 = new Color[]{new Color(255, 255, 255, 153), new Color(255, 255, 255, 0)};
                RadialGradientPaint radialGradientPaint = new RadialGradientPaint(double_35, (float)(0.03271028037383177 * (double)n2), fArray11, colorArray11);
                graphics2D.setPaint(radialGradientPaint);
                graphics2D.fill(generalPath);
                GeneralPath generalPath2 = new GeneralPath();
                generalPath2.setWindingRule(0);
                generalPath2.moveTo((double)n2 * 0.5327102803738317, (double)n3 * 0.48130841121495327);
                generalPath2.curveTo((double)n2 * 0.5280373831775701, (double)n3 * 0.4672897196261682, (double)n2 * 0.514018691588785, (double)n3 * 0.45794392523364486, (double)n2 * 0.5, (double)n3 * 0.45794392523364486);
                generalPath2.curveTo((double)n2 * 0.48130841121495327, (double)n3 * 0.45794392523364486, (double)n2 * 0.4672897196261682, (double)n3 * 0.4672897196261682, (double)n2 * 0.46261682242990654, (double)n3 * 0.48130841121495327);
                generalPath2.curveTo((double)n2 * 0.4672897196261682, (double)n3 * 0.48598130841121495, (double)n2 * 0.48130841121495327, (double)n3 * 0.49065420560747663, (double)n2 * 0.5, (double)n3 * 0.49065420560747663);
                generalPath2.curveTo((double)n2 * 0.514018691588785, (double)n3 * 0.49065420560747663, (double)n2 * 0.5280373831775701, (double)n3 * 0.48598130841121495, (double)n2 * 0.5327102803738317, (double)n3 * 0.48130841121495327);
                generalPath2.closePath();
                Point2D.Double double_36 = new Point2D.Double(0.4953271028037383 * (double)n2, 0.45794392523364486 * (double)n3);
                float[] fArray12 = new float[]{0.0f, 1.0f};
                Color[] colorArray12 = new Color[]{new Color(255, 255, 255, 191), new Color(255, 255, 255, 0)};
                RadialGradientPaint radialGradientPaint2 = new RadialGradientPaint(double_36, (float)(0.04906542056074766 * (double)n2), fArray12, colorArray12);
                graphics2D.setPaint(radialGradientPaint2);
                graphics2D.fill(generalPath2);
                Ellipse2D.Double double_37 = new Ellipse2D.Double((double)n2 * 0.47663551568984985, (double)n3 * 0.4813084006309509, (double)n2 * 0.04205608367919922, (double)n3 * 0.04205608367919922);
                Point2D.Double double_38 = new Point2D.Double(0.0, double_37.getBounds2D().getMinY());
                Point2D.Double double_39 = new Point2D.Double(0.0, double_37.getBounds2D().getMaxY());
                float[] fArray13 = new float[]{0.0f, 1.0f};
                Color[] colorArray13 = new Color[]{new Color(0, 0, 0, 255), new Color(204, 204, 204, 255)};
                LinearGradientPaint linearGradientPaint9 = new LinearGradientPaint(double_38, double_39, fArray13, colorArray13);
                graphics2D.setPaint(linearGradientPaint9);
                graphics2D.fill(double_37);
                Ellipse2D.Double double_40 = new Ellipse2D.Double((double)n2 * 0.4813084006309509, (double)n3 * 0.4859813153743744, (double)n2 * 0.03271031379699707, (double)n3 * 0.03271028399467468);
                Point2D.Double double_41 = new Point2D.Double(0.0, double_40.getBounds2D().getMinY());
                Point2D.Double double_42 = new Point2D.Double(0.0, double_40.getBounds2D().getMaxY());
                float[] fArray14 = new float[]{0.0f, 1.0f};
                Color[] colorArray14 = new Color[]{new Color(1, 6, 11, 255), new Color(50, 52, 56, 255)};
                LinearGradientPaint linearGradientPaint10 = new LinearGradientPaint(double_41, double_42, fArray14, colorArray14);
                graphics2D.setPaint(linearGradientPaint10);
                graphics2D.fill(double_40);
            }
        }
        graphics2D.dispose();
        this.sizeBuffer = n;
        this.knobTypeBuffer = knobType;
        this.knobStyleBuffer = knobStyle;
        return this.knobImageBuffer;
    }
}

