/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.tools;

import eu.hansolo.steelseries.tools.LcdColor;
import eu.hansolo.steelseries.tools.Util;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;

public enum LcdImageFactory {
    INSTANCE;

    private final Util UTIL = Util.INSTANCE;
    private Rectangle2D boundsBuffer = new Rectangle2D.Double();
    private LcdColor lcdColorBuffer = LcdColor.WHITE_LCD;
    private Paint customLcdBackgroundBuffer = Color.RED;
    private BufferedImage lcdImageBuffer = this.UTIL.createImage(1, 1, 3);

    public BufferedImage create_LCD_Image(Rectangle2D rectangle2D, LcdColor lcdColor, Paint paint, BufferedImage bufferedImage) {
        if (rectangle2D.getWidth() <= 0.0 || rectangle2D.getHeight() <= 0.0) {
            return this.UTIL.createImage(1, 1, 3);
        }
        if (rectangle2D.equals(this.boundsBuffer) && lcdColor == this.lcdColorBuffer && paint == this.customLcdBackgroundBuffer) {
            if (bufferedImage != null && this.lcdImageBuffer.getWidth() == bufferedImage.getWidth()) {
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.drawImage((Image)this.lcdImageBuffer, 0, 0, null);
                graphics2D.dispose();
            }
            return this.lcdImageBuffer;
        }
        this.lcdImageBuffer.flush();
        this.lcdImageBuffer = bufferedImage != null ? this.UTIL.createImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 3) : this.UTIL.createImage((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight(), 3);
        Graphics2D graphics2D = this.lcdImageBuffer.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        Point2D.Double double_ = new Point2D.Double(0.0, rectangle2D.getMinY());
        Point2D.Double double_2 = new Point2D.Double(0.0, rectangle2D.getMaxY());
        if (double_.equals(double_2)) {
            ((Point2D)double_2).setLocation(0.0, ((Point2D)double_).getY() + 1.0);
        }
        float[] fArray = new float[]{0.0f, 0.08f, 0.92f, 1.0f};
        Color[] colorArray = new Color[]{new Color(0.3f, 0.3f, 0.3f, 1.0f), new Color(0.4f, 0.4f, 0.4f, 1.0f), new Color(0.4f, 0.4f, 0.4f, 1.0f), new Color(0.9f, 0.9f, 0.9f, 1.0f)};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray);
        double d = rectangle2D.getWidth() > rectangle2D.getHeight() ? rectangle2D.getHeight() * 0.12 : rectangle2D.getWidth() * 0.12;
        RoundRectangle2D.Double double_3 = new RoundRectangle2D.Double(rectangle2D.getMinX(), rectangle2D.getMinY(), rectangle2D.getWidth(), rectangle2D.getHeight(), d, d);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(double_3);
        Point2D.Double double_4 = new Point2D.Double(0.0, rectangle2D.getMinY() + 1.0);
        Point2D.Double double_5 = new Point2D.Double(0.0, rectangle2D.getMaxY() - 1.0);
        if (double_4.equals(double_5)) {
            ((Point2D)double_5).setLocation(0.0, ((Point2D)double_4).getY() + 1.0);
        }
        float[] fArray2 = new float[]{0.0f, 0.03f, 0.49f, 0.5f, 1.0f};
        Color[] colorArray2 = new Color[]{lcdColor.GRADIENT_START_COLOR, lcdColor.GRADIENT_FRACTION1_COLOR, lcdColor.GRADIENT_FRACTION2_COLOR, lcdColor.GRADIENT_FRACTION3_COLOR, lcdColor.GRADIENT_STOP_COLOR};
        if (lcdColor == LcdColor.CUSTOM) {
            graphics2D.setPaint(paint);
        } else {
            LinearGradientPaint linearGradientPaint2 = new LinearGradientPaint(double_4, double_5, fArray2, colorArray2);
            graphics2D.setPaint(linearGradientPaint2);
        }
        double d2 = ((RoundRectangle2D)double_3).getArcWidth() - 1.0;
        RoundRectangle2D.Double double_6 = new RoundRectangle2D.Double(rectangle2D.getMinX() + 1.0, rectangle2D.getMinY() + 1.0, rectangle2D.getWidth() - 2.0, rectangle2D.getHeight() - 2.0, d2, d2);
        graphics2D.fill(double_6);
        graphics2D.dispose();
        if (bufferedImage != null) {
            Graphics2D graphics2D2 = bufferedImage.createGraphics();
            graphics2D2.drawImage((Image)this.lcdImageBuffer, 0, 0, null);
            graphics2D2.dispose();
        }
        this.boundsBuffer.setRect(rectangle2D);
        this.lcdColorBuffer = lcdColor;
        this.customLcdBackgroundBuffer = paint;
        return this.lcdImageBuffer;
    }
}

