/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.tools;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public enum Scaler {
    INSTANCE;


    private double calcSignedPolygonArea(Point2D[] point2DArray) {
        int n = point2DArray.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            int n2 = (i + 1) % n;
            d += point2DArray[i].getX() * point2DArray[n2].getY();
            d -= point2DArray[i].getY() * point2DArray[n2].getX();
        }
        return d /= 2.0;
    }

    public Point2D calcCenterOfMass(Point2D[] point2DArray) {
        int n = point2DArray.length;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = this.calcSignedPolygonArea(point2DArray);
        Point2D.Double double_ = new Point2D.Double();
        double d4 = 0.0;
        for (int i = 0; i < n; ++i) {
            int n2 = (i + 1) % n;
            d4 = point2DArray[i].getX() * point2DArray[n2].getY() - point2DArray[n2].getX() * point2DArray[i].getY();
            d += (point2DArray[i].getX() + point2DArray[n2].getX()) * d4;
            d2 += (point2DArray[i].getY() + point2DArray[n2].getY()) * d4;
        }
        d4 = 1.0 / (d3 *= 6.0);
        ((Point2D)double_).setLocation(d *= d4, d2 *= d4);
        return double_;
    }

    public Point2D[] getPointArrayOfShape(Shape shape) {
        Object[] objectArray;
        ArrayList<Point2D.Double> arrayList = new ArrayList<Point2D.Double>(32);
        PathIterator pathIterator = shape.getPathIterator(null);
        int n = -1;
        while (!pathIterator.isDone()) {
            objectArray = new double[6];
            switch (pathIterator.currentSegment((double[])objectArray)) {
                case 0: {
                    arrayList.add(new Point2D.Double(objectArray[0], objectArray[1]));
                    ++n;
                    break;
                }
                case 1: {
                    arrayList.add(new Point2D.Double(objectArray[0], objectArray[1]));
                    break;
                }
                case 2: {
                    arrayList.add(new Point2D.Double(objectArray[0], objectArray[1]));
                    arrayList.add(new Point2D.Double(objectArray[2], objectArray[3]));
                    break;
                }
                case 3: {
                    arrayList.add(new Point2D.Double(objectArray[0], objectArray[1]));
                    arrayList.add(new Point2D.Double(objectArray[2], objectArray[3]));
                    arrayList.add(new Point2D.Double(objectArray[4], objectArray[5]));
                    break;
                }
                case 4: {
                    if (n < 0) break;
                    arrayList.add((Point2D.Double)arrayList.get(n));
                }
            }
            pathIterator.next();
        }
        objectArray = new Point2D[arrayList.size()];
        return objectArray;
    }

    public Point2D getCentroid(Shape shape) {
        Object[] objectArray;
        ArrayList<Point2D.Double> arrayList = new ArrayList<Point2D.Double>(32);
        PathIterator pathIterator = shape.getPathIterator(null);
        int n = -1;
        while (!pathIterator.isDone()) {
            objectArray = new double[6];
            switch (pathIterator.currentSegment((double[])objectArray)) {
                case 0: {
                    arrayList.add(new Point2D.Double(objectArray[0], objectArray[1]));
                    ++n;
                    break;
                }
                case 1: {
                    arrayList.add(new Point2D.Double(objectArray[0], objectArray[1]));
                    break;
                }
                case 2: {
                    arrayList.add(new Point2D.Double(objectArray[0], objectArray[1]));
                    arrayList.add(new Point2D.Double(objectArray[2], objectArray[3]));
                    break;
                }
                case 3: {
                    arrayList.add(new Point2D.Double(objectArray[0], objectArray[1]));
                    arrayList.add(new Point2D.Double(objectArray[2], objectArray[3]));
                    arrayList.add(new Point2D.Double(objectArray[4], objectArray[5]));
                    break;
                }
                case 4: {
                    if (n < 0) break;
                    arrayList.add((Point2D.Double)arrayList.get(n));
                }
            }
            pathIterator.next();
        }
        objectArray = new Point2D[arrayList.size()];
        arrayList.toArray(objectArray);
        return this.calcCenterOfMass((Point2D[])objectArray);
    }

    public Point2D getCentroid(Point2D[] point2DArray) {
        return this.calcCenterOfMass(point2DArray);
    }

    public Shape scale(Shape shape, double d) {
        Point2D point2D = this.getCentroid(shape);
        AffineTransform affineTransform = AffineTransform.getTranslateInstance((1.0 - d) * point2D.getX(), (1.0 - d) * point2D.getY());
        affineTransform.scale(d, d);
        return affineTransform.createTransformedShape(shape);
    }

    public Shape scale(Shape shape, double d, Point2D point2D) {
        AffineTransform affineTransform = AffineTransform.getTranslateInstance((1.0 - d) * point2D.getX(), (1.0 - d) * point2D.getY());
        affineTransform.scale(d, d);
        return affineTransform.createTransformedShape(shape);
    }
}

