/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.tools;

import eu.hansolo.steelseries.tools.Util;
import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;

public class Section {
    private double start;
    private double stop;
    private Color color;
    private Color transparentColor;
    private Color highlightColor;
    private Color transparentHighlightColor;
    private Paint paint;
    private Area sectionArea;
    private Arc2D filledArea;

    public Section() {
        this(-1.0, -1.0, Color.RED, null, null);
    }

    public Section(double d, double d2, Color color) {
        this(d, d2, color, null, null);
    }

    public Section(double d, double d2, Color color, Color color2) {
        this(d, d2, color, color2, null, null);
    }

    public Section(double d, double d2, Color color, Arc2D arc2D) {
        this(d, d2, color, null, arc2D);
    }

    public Section(double d, double d2, Color color, Area area, Arc2D arc2D) {
        this(d, d2, color, color.brighter().brighter(), area, arc2D);
    }

    public Section(double d, double d2, Color color, Color color2, Area area, Arc2D arc2D) {
        this.start = d;
        this.stop = d2;
        this.color = color;
        this.transparentColor = Util.INSTANCE.setAlpha(color, 0.25f);
        this.highlightColor = color2;
        this.transparentHighlightColor = Util.INSTANCE.setAlpha(color2, 0.5f);
        this.sectionArea = area;
        this.filledArea = arc2D;
        this.paint = color;
    }

    public double getStart() {
        return this.start;
    }

    public void setStart(double d) {
        this.start = d;
    }

    public double getStop() {
        return this.stop;
    }

    public void setStop(double d) {
        this.stop = d;
    }

    public Color getColor() {
        return this.color;
    }

    public Color getTransparentColor() {
        return this.transparentColor;
    }

    public void setColor(Color color) {
        this.color = color;
        this.transparentColor = Util.INSTANCE.setAlpha(color, 0.25f);
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public Color getTransparentHighlightColor() {
        return this.transparentHighlightColor;
    }

    public void setHighlightColor(Color color) {
        this.highlightColor = color;
        this.transparentHighlightColor = Util.INSTANCE.setAlpha(color, 0.5f);
    }

    public Area getSectionArea() {
        return this.sectionArea;
    }

    public void setSectionArea(Area area) {
        this.sectionArea = area;
    }

    public Arc2D getFilledArea() {
        return this.filledArea;
    }

    public void setFilledArea(Arc2D arc2D) {
        this.filledArea = arc2D;
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        this.paint = paint;
    }

    public boolean contains(double d) {
        return Double.compare(d, this.start) >= 0 && Double.compare(d, this.stop) <= 0;
    }

    public String toString() {
        return "Section";
    }
}

