/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.data.ChartItem;
import eu.hansolo.fx.charts.event.ItemEventListener;
import eu.hansolo.fx.charts.tools.CtxBounds;
import eu.hansolo.fx.charts.tools.Helper;
import eu.hansolo.fx.charts.tools.Point;
import eu.hansolo.fx.geometry.Path;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.IntegerPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;

@DefaultProperty(value="children")
public class StreamChart
extends Region {
    private static final double PREFERRED_WIDTH = 600.0;
    private static final double PREFERRED_HEIGHT = 400.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 2048.0;
    private static final double MAXIMUM_HEIGHT = 2048.0;
    private static final Color DEFAULT_ITEM_COLOR = Color.rgb((int)164, (int)164, (int)164);
    private static final int DEFAULT_ITEM_WIDTH = 80;
    private static final int DEFAULT_NODE_GAP = 20;
    private static final double DEFAULT_OPACITY = 0.55;
    private double size;
    private double width;
    private double height;
    private double reducedHeight;
    private Canvas canvas;
    private GraphicsContext ctx;
    private Category _category;
    private ObjectProperty<Category> category;
    private ObservableList<ChartItem> items = FXCollections.observableArrayList();
    private Map<LocalDate, List<ChartItem>> chartItems = new LinkedHashMap<LocalDate, List<ChartItem>>();
    private Map<Integer, List<ChartItemData>> itemsPerCategory = new LinkedHashMap<Integer, List<ChartItemData>>();
    private ItemEventListener itemListener = e -> this.redraw();
    private ListChangeListener<ChartItem> itemListListener = c -> {
        while (c.next()) {
            if (c.wasAdded()) {
                c.getAddedSubList().forEach(addedItem -> addedItem.setOnItemEvent(this.itemListener));
                continue;
            }
            if (!c.wasRemoved()) continue;
            c.getRemoved().forEach(removedItem -> removedItem.removeItemEventListener(this.itemListener));
        }
        this.groupBy(this.getCategory());
    };
    private double scaleY;
    private Color _textColor;
    private ObjectProperty<Color> textColor;
    private int _itemWidth;
    private IntegerProperty itemWidth;
    private boolean _autoItemWidth;
    private BooleanProperty autoItemWidth;
    private int _itemGap;
    private IntegerProperty itemGap;
    private boolean _autoItemGap;
    private BooleanProperty autoItemGap;
    private int _decimals;
    private IntegerProperty decimals;
    private Locale _locale;
    private ObjectProperty<Locale> locale;
    private String formatString;
    private Map<Path, String> paths;
    private Tooltip tooltip;

    public StreamChart() {
        this(Category.DAY, new ArrayList<ChartItem>());
    }

    public StreamChart(Category CATEGORY, ChartItem ... ITEMS) {
        this(CATEGORY, Arrays.asList(ITEMS));
    }

    public StreamChart(Category CATEGORY, List<ChartItem> ITEMS) {
        this._category = CATEGORY;
        this._textColor = Color.BLACK;
        this._itemWidth = 80;
        this._autoItemWidth = true;
        this._itemGap = 20;
        this._autoItemGap = true;
        this._decimals = 0;
        this._locale = Locale.getDefault();
        this.formatString = "%." + this._decimals + "f";
        this.paths = new LinkedHashMap<Path, String>();
        this.items.setAll(ITEMS);
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(600.0, 400.0);
            }
        }
        this.canvas = new Canvas(600.0, 400.0);
        this.ctx = this.canvas.getGraphicsContext2D();
        this.tooltip = new Tooltip();
        this.tooltip.setAutoHide(true);
        this.getChildren().setAll((Object[])new Node[]{this.canvas});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
        this.items.addListener(this.itemListListener);
        this.canvas.setOnMouseClicked(e -> this.paths.forEach((path, tooltipText) -> {
            double eventY;
            double eventX = e.getX();
            if (path.contains(eventX, eventY = e.getY())) {
                double tooltipX = eventX + this.canvas.getScene().getX() + this.canvas.getScene().getWindow().getX();
                double tooltipY = eventY + this.canvas.getScene().getY() + this.canvas.getScene().getWindow().getY() - 25.0;
                this.tooltip.setText(tooltipText);
                this.tooltip.setX(tooltipX);
                this.tooltip.setY(tooltipY);
                this.tooltip.show(this.getScene().getWindow());
            }
        }));
    }

    public void layoutChildren() {
        super.layoutChildren();
    }

    protected double computeMinWidth(double HEIGHT) {
        return 50.0;
    }

    protected double computeMinHeight(double WIDTH) {
        return 50.0;
    }

    protected double computePrefWidth(double HEIGHT) {
        return super.computePrefWidth(HEIGHT);
    }

    protected double computePrefHeight(double WIDTH) {
        return super.computePrefHeight(WIDTH);
    }

    protected double computeMaxWidth(double HEIGHT) {
        return 2048.0;
    }

    protected double computeMaxHeight(double WIDTH) {
        return 2048.0;
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public void dispose() {
        this.items.removeListener(this.itemListListener);
    }

    public Category getCategory() {
        return null == this.category ? this._category : (Category)((Object)this.category.get());
    }

    public void setCategory(Category CATEGORY) {
        if (null == this.category) {
            this._category = CATEGORY;
            this.redraw();
        } else {
            this.category.set((Object)CATEGORY);
        }
    }

    public ObjectProperty<Category> categoryProperty() {
        if (null == this.category) {
            this.category = new ObjectPropertyBase<Category>(this._category){

                protected void invalidated() {
                    StreamChart.this.redraw();
                }

                public Object getBean() {
                    return StreamChart.this;
                }

                public String getName() {
                    return "category";
                }
            };
            this._category = null;
        }
        return this.category;
    }

    public List<ChartItem> getItems() {
        return this.items;
    }

    public void setItems(ChartItem ... ITEMS) {
        this.setItems(Arrays.asList(ITEMS));
    }

    public void setItems(List<ChartItem> ITEMS) {
        this.items.setAll(ITEMS);
        this.prepareData();
    }

    public void addItem(ChartItem ITEM) {
        if (!this.items.contains((Object)ITEM)) {
            this.items.add((Object)ITEM);
        }
        this.prepareData();
    }

    public void removeItem(ChartItem ITEM) {
        if (this.items.contains((Object)ITEM)) {
            this.items.remove((Object)ITEM);
        }
        this.prepareData();
    }

    public Color getTextColor() {
        return null == this.textColor ? this._textColor : (Color)this.textColor.get();
    }

    public void setTextColor(Color COLOR) {
        if (null == this.textColor) {
            this._textColor = COLOR;
            this.redraw();
        } else {
            this.textColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> textColorProperty() {
        if (null == this.textColor) {
            this.textColor = new ObjectPropertyBase<Color>(this._textColor){

                protected void invalidated() {
                    StreamChart.this.prepareData();
                }

                public Object getBean() {
                    return StreamChart.this;
                }

                public String getName() {
                    return "textColor";
                }
            };
            this._textColor = null;
        }
        return this.textColor;
    }

    public int getItemWidth() {
        return null == this.itemWidth ? this._itemWidth : this.itemWidth.get();
    }

    public void setItemWidth(int WIDTH) {
        if (null == this.itemWidth) {
            this._itemWidth = Helper.clamp(2, 50, WIDTH);
            this.prepareData();
        } else {
            this.itemWidth.set(WIDTH);
        }
    }

    public IntegerProperty itemWidthProperty() {
        if (null == this.itemWidth) {
            this.itemWidth = new IntegerPropertyBase(this._itemWidth){

                protected void invalidated() {
                    this.set(Helper.clamp(2, 50, this.get()));
                    StreamChart.this.prepareData();
                }

                public Object getBean() {
                    return StreamChart.this;
                }

                public String getName() {
                    return "itemWidth";
                }
            };
        }
        return this.itemWidth;
    }

    public boolean isAutoItemWidth() {
        return null == this.autoItemWidth ? this._autoItemWidth : this.autoItemWidth.get();
    }

    public void setAutoItemWidth(boolean AUTO) {
        if (null == this.autoItemWidth) {
            this._autoItemWidth = AUTO;
            this.prepareData();
        } else {
            this.autoItemWidth.set(AUTO);
        }
    }

    public BooleanProperty autoItemWidthProperty() {
        if (null == this.autoItemWidth) {
            this.autoItemWidth = new BooleanPropertyBase(this._autoItemWidth){

                protected void invalidated() {
                    StreamChart.this.prepareData();
                }

                public Object getBean() {
                    return StreamChart.this;
                }

                public String getName() {
                    return "autoItemWidth";
                }
            };
        }
        return this.autoItemWidth;
    }

    public int getItemGap() {
        return null == this.itemGap ? this._itemGap : this.itemGap.get();
    }

    public void setItemGap(int GAP) {
        if (null == this.itemGap) {
            this._itemGap = Helper.clamp(0, 100, GAP);
            this.prepareData();
        } else {
            this.itemGap.set(GAP);
        }
    }

    public IntegerProperty itemGapProperty() {
        if (null == this.itemGap) {
            this.itemGap = new IntegerPropertyBase(this._itemGap){

                protected void invalidated() {
                    this.set(Helper.clamp(0, 100, this.get()));
                    StreamChart.this.prepareData();
                }

                public Object getBean() {
                    return StreamChart.this;
                }

                public String getName() {
                    return "itemGap";
                }
            };
        }
        return this.itemGap;
    }

    public boolean isAutoItemGap() {
        return null == this.autoItemGap ? this._autoItemGap : this.autoItemGap.get();
    }

    public void setAutoItemGap(boolean AUTO) {
        if (null == this.autoItemGap) {
            this._autoItemGap = AUTO;
            this.prepareData();
        } else {
            this.autoItemGap.set(AUTO);
        }
    }

    public BooleanProperty autoItemGapProperty() {
        if (null == this.autoItemGap) {
            this.autoItemGap = new BooleanPropertyBase(this._autoItemGap){

                protected void invalidated() {
                    StreamChart.this.prepareData();
                }

                public Object getBean() {
                    return StreamChart.this;
                }

                public String getName() {
                    return "autoItemGap";
                }
            };
        }
        return this.autoItemGap;
    }

    public int getDecimals() {
        return null == this.decimals ? this._decimals : this.decimals.get();
    }

    public void setDecimals(int DECIMALS) {
        if (null == this.decimals) {
            this._decimals = Helper.clamp(0, 6, DECIMALS);
            this.formatString = "%." + this.getDecimals() + "f";
            this.redraw();
        } else {
            this.decimals.set(DECIMALS);
        }
    }

    public IntegerProperty decimalsProperty() {
        if (null == this.decimals) {
            this.decimals = new IntegerPropertyBase(this._decimals){

                protected void invalidated() {
                    this.set(Helper.clamp(0, 6, this.get()));
                    StreamChart.this.formatString = "%." + this.get() + "f";
                    StreamChart.this.redraw();
                }

                public Object getBean() {
                    return StreamChart.this;
                }

                public String getName() {
                    return "decimals";
                }
            };
        }
        return this.decimals;
    }

    public Locale getLocale() {
        return null == this.locale ? this._locale : (Locale)this.locale.get();
    }

    public void setLocale(Locale LOCALE) {
        if (null == this.locale) {
            this._locale = LOCALE;
            this.prepareData();
        } else {
            this.locale.set((Object)LOCALE);
        }
    }

    public ObjectProperty<Locale> localeProperty() {
        if (null == this.locale) {
            this.locale = new ObjectPropertyBase<Locale>(this._locale){

                protected void invalidated() {
                    StreamChart.this.prepareData();
                }

                public Object getBean() {
                    return StreamChart.this;
                }

                public String getName() {
                    return "locale";
                }
            };
        }
        this._locale = null;
        return this.locale;
    }

    public void groupBy(Category CATEGORY) {
        this.chartItems.clear();
        Map<LocalDate, List<ChartItem>> groupedItems = this.items.stream().collect(Collectors.groupingBy(item -> item.getTimestampAsLocalDate().with(CATEGORY.adjuster())));
        Map sorted = groupedItems.entrySet().stream().sorted(Collections.reverseOrder(Map.Entry.comparingByKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
        sorted.entrySet().stream().forEach(entry -> {
            LinkedHashMap<String, ChartItem> compactedItems = new LinkedHashMap<String, ChartItem>();
            for (ChartItem item : (List)entry.getValue()) {
                if (compactedItems.keySet().contains(item.getName())) {
                    ((ChartItem)compactedItems.get(item.getName())).setValue(((ChartItem)compactedItems.get(item.getName())).getValue() + item.getValue());
                    continue;
                }
                compactedItems.put(item.getName(), item);
            }
            ArrayList<ChartItem> compacted = new ArrayList<ChartItem>(compactedItems.values());
            this.sortItemsAscending(compacted);
            this.chartItems.put((LocalDate)entry.getKey(), (List<ChartItem>)compacted);
        });
        this.prepareData();
    }

    private void sortItemsAscending(List<ChartItem> ITEMS) {
        Collections.sort(ITEMS);
    }

    private void sortItemsDescending(List<ChartItem> ITEMS) {
        Collections.sort(ITEMS, Collections.reverseOrder());
    }

    private double getSumOfItems(List<ChartItem> ITEMS) {
        return ITEMS.stream().mapToDouble(ChartItem::getValue).sum();
    }

    private void prepareData() {
        this.itemsPerCategory.clear();
        int cat = this.chartItems.size() - 1;
        for (LocalDate key : this.chartItems.keySet()) {
            ArrayList itemDataList = new ArrayList();
            this.chartItems.get(key).forEach(item -> itemDataList.add(new ChartItemData((ChartItem)item)));
            this.itemsPerCategory.put(cat, itemDataList);
            --cat;
        }
        int noOfCategories = this.chartItems.size();
        this.chartItems.forEach((localDate, items) -> Collections.reverse(items));
        double maxSum = this.chartItems.entrySet().stream().mapToDouble(entry -> ((List)entry.getValue()).stream().mapToDouble(ChartItem::getValue).sum()).max().getAsDouble();
        int maxItems = this.chartItems.entrySet().stream().mapToInt(entry -> ((List)entry.getValue()).size()).reduce(0, Integer::max);
        double itemWidth = this.isAutoItemWidth() ? this.size * 0.1 : (double)this.getItemWidth();
        double verticalGap = this.isAutoItemGap() ? this.size * 0.005 : (double)this.getItemGap();
        double horizontalGap = (this.width - itemWidth) / (double)(this.chartItems.keySet().size() - 1);
        this.scaleY = (this.reducedHeight - (double)(maxItems - 1) * verticalGap) / maxSum;
        for (int category = 0; category < noOfCategories; ++category) {
            double spacerY = 0.0;
            double spacerX = horizontalGap * (double)category;
            for (ChartItemData itemData : this.itemsPerCategory.get(category)) {
                ChartItem item2 = itemData.getChartItem();
                double itemHeight = item2.getValue() * this.scaleY;
                double textOffsetX = 2.0;
                itemData.setBounds(spacerX, this.reducedHeight - itemHeight - spacerY, itemWidth, itemHeight);
                itemData.setTextPoint(spacerX + textOffsetX, this.reducedHeight - itemHeight - spacerY + this.ctx.getFont().getSize());
                spacerY += itemHeight + verticalGap;
            }
        }
        this.createPaths();
        this.redraw();
    }

    private <K, V> K getKeyByValue(Map<K, V> MAP, V VALUE) {
        return (K)MAP.keySet().stream().filter(key -> VALUE.equals(MAP.get(key))).findFirst().get();
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        this.reducedHeight = this.height - this.height * 0.05;
        double d = this.size = this.width < this.height ? this.width : this.height;
        if (this.width > 0.0 && this.height > 0.0) {
            this.canvas.setWidth(this.width);
            this.canvas.setHeight(this.height);
            this.canvas.relocate((this.getWidth() - this.width) * 0.5, (this.getHeight() - this.height) * 0.5);
            this.ctx.setTextBaseline(VPos.CENTER);
            this.ctx.setFont(Font.font((double)Helper.clamp(8.0, 24.0, this.size * 0.025)));
            this.groupBy(this.getCategory());
        }
    }

    private void createPaths() {
        this.paths.clear();
        int noOfCategories = this.chartItems.size();
        for (int category = 0; category < noOfCategories; ++category) {
            List<ChartItemData> itemDataInCategory = this.itemsPerCategory.get(category);
            int nextCategory = category + 1;
            for (ChartItemData itemData : itemDataInCategory) {
                Optional<ChartItemData> targetItemDataOptional;
                List<ChartItemData> nextCategoryItemDataList;
                ChartItem item = itemData.getChartItem();
                CtxBounds bounds = itemData.getBounds();
                if (category >= noOfCategories || null == (nextCategoryItemDataList = this.itemsPerCategory.get(nextCategory)) || !(targetItemDataOptional = nextCategoryItemDataList.stream().filter(id -> {
                    if (null == id.getChartItem().getName() || null == item.getName()) {
                        return false;
                    }
                    return id.getChartItem().getName().equals(item.getName());
                }).findFirst()).isPresent()) continue;
                ChartItemData targetItemData = targetItemDataOptional.get();
                CtxBounds targetItemBounds = targetItemData.getBounds();
                ChartItem targetItem = targetItemData.getChartItem();
                double ctrlPointOffsetX = (targetItemBounds.getMinX() - bounds.getMaxX()) * 0.5;
                double value = item.getValue();
                Path path = new Path();
                path.setFill((Paint)item.getFill());
                path.setStroke((Paint)item.getFill());
                path.moveTo(bounds.getMaxX(), bounds.getMinY());
                path.bezierCurveTo(bounds.getMaxX() + ctrlPointOffsetX, bounds.getMinY(), targetItemBounds.getMinX() - ctrlPointOffsetX, targetItemBounds.getMinY(), targetItemBounds.getMinX(), targetItemBounds.getMinY());
                path.lineTo(targetItemBounds.getMinX(), targetItemBounds.getMaxY());
                path.bezierCurveTo(targetItemBounds.getMinX() - ctrlPointOffsetX, targetItemBounds.getMaxY(), bounds.getMaxX() + ctrlPointOffsetX, bounds.getMaxY(), bounds.getMaxX(), bounds.getMaxY());
                path.lineTo(bounds.getMaxX(), bounds.getMinY());
                path.closePath();
                String tooltipText = item.getName() + ": " + String.format(this.getLocale(), this.formatString, value) + " -> " + " " + String.format(this.getLocale(), this.formatString, targetItem.getValue());
                this.paths.put(path, tooltipText);
            }
        }
    }

    private void redraw() {
        this.ctx.clearRect(0.0, 0.0, this.width, this.height);
        this.paths.forEach((path, plotItem) -> path.draw(this.ctx, true, true));
        Color textColor = this.getTextColor();
        int noOfCategories = this.chartItems.size();
        DateTimeFormatter formatter = this.getCategory().formatter();
        for (int category = 0; category < noOfCategories; ++category) {
            List<ChartItemData> itemDataInCategory = this.itemsPerCategory.get(category);
            for (ChartItemData itemData : itemDataInCategory) {
                ChartItem item = itemData.getChartItem();
                CtxBounds bounds = itemData.getBounds();
                Color itemColor = item.getFill();
                this.ctx.setFill((Paint)itemColor);
                this.ctx.fillRect(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
                this.ctx.setLineWidth(0.0);
                this.ctx.setStroke((Paint)itemColor);
                this.ctx.strokeRect(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
                if (!(item.getValue() > 1.0)) continue;
                this.ctx.setFill((Paint)textColor);
                this.ctx.setTextAlign(category == noOfCategories ? TextAlignment.RIGHT : TextAlignment.LEFT);
                this.ctx.fillText(item.getName(), itemData.getTextPoint().getX(), itemData.getTextPoint().getY(), bounds.getWidth());
            }
            ChartItemData firstItem = itemDataInCategory.get(0);
            this.ctx.fillText(formatter.format(firstItem.getLocalDate()), firstItem.getTextPoint().getX(), this.reducedHeight + this.size * 0.02, firstItem.bounds.getWidth());
        }
    }

    private class ChartItemData {
        private ChartItem chartItem;
        private CtxBounds bounds;
        private Point textPoint;
        private double value;

        public ChartItemData(ChartItem ITEM) {
            this.chartItem = ITEM;
            this.bounds = new CtxBounds();
            this.textPoint = new Point();
            this.value = 0.0;
        }

        public ChartItem getChartItem() {
            return this.chartItem;
        }

        public LocalDate getLocalDate() {
            return this.chartItem.getTimestampAsLocalDate(ZoneId.systemDefault());
        }

        public CtxBounds getBounds() {
            return this.bounds;
        }

        public void setBounds(double X, double Y, double WIDTH, double HEIGHT) {
            this.bounds.set(X, Y, WIDTH, HEIGHT);
        }

        public Point getTextPoint() {
            return this.textPoint;
        }

        public void setTextPoint(double X, double Y) {
            this.textPoint.set(X, Y);
        }

        public double getValue() {
            return this.value;
        }

        public void setValue(double VALUE) {
            this.value = VALUE;
        }
    }

    public static enum Category {
        DAY(TemporalAdjusters.ofDateAdjuster(d -> d), DateTimeFormatter.ofPattern("dd MMM YYYY")),
        WEEK(TemporalAdjusters.previousOrSame(DayOfWeek.of(1)), DateTimeFormatter.ofPattern("w")),
        MONTH(TemporalAdjusters.firstDayOfMonth(), DateTimeFormatter.ofPattern("MMM")),
        YEAR(TemporalAdjusters.firstDayOfYear(), DateTimeFormatter.ofPattern("YYYY"));

        private TemporalAdjuster adjuster;
        private DateTimeFormatter formatter;

        private Category(TemporalAdjuster ADJUSTER, DateTimeFormatter FORMATTER) {
            this.adjuster = ADJUSTER;
            this.formatter = FORMATTER;
        }

        public TemporalAdjuster adjuster() {
            return this.adjuster;
        }

        public DateTimeFormatter formatter() {
            return this.formatter;
        }
    }
}

