/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.areaheatmap;

import eu.hansolo.fx.charts.areaheatmap.AreaHeatMap;
import eu.hansolo.fx.charts.data.DataPoint;
import eu.hansolo.fx.charts.tools.ColorMapping;
import java.util.HashMap;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Dimension2D;

public class AreaHeatMapBuilder<B extends AreaHeatMapBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected AreaHeatMapBuilder() {
    }

    public static final AreaHeatMapBuilder create() {
        return new AreaHeatMapBuilder();
    }

    public final B prefSize(double WIDTH, double HEIGHT) {
        return this.prefSize(new Dimension2D(WIDTH, HEIGHT));
    }

    public final B prefSize(Dimension2D PREF_SIZE) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)PREF_SIZE));
        return (B)this;
    }

    public final B dataPoints(DataPoint ... POINTS) {
        this.properties.put("dataPointsArray", (Property)new SimpleObjectProperty((Object)POINTS));
        return (B)this;
    }

    public final B dataPoints(List<DataPoint> POINTS) {
        this.properties.put("dataPointsList", (Property)new SimpleObjectProperty(POINTS));
        return (B)this;
    }

    public final B colorMapping(ColorMapping COLOR_MAPPING) {
        this.properties.put("colorMapping", (Property)new SimpleObjectProperty((Object)COLOR_MAPPING));
        return (B)this;
    }

    public final B useColorMapping(boolean USE) {
        this.properties.put("useColorMapping", (Property)new SimpleBooleanProperty(USE));
        return (B)this;
    }

    public final B quality(AreaHeatMap.Quality QUALITY) {
        return this.quality(QUALITY.getFactor());
    }

    public final B quality(int QUALITY) {
        this.properties.put("quality", (Property)new SimpleIntegerProperty(QUALITY));
        return (B)this;
    }

    public final B dataPointsVisible(boolean VISIBLE) {
        this.properties.put("dataPointsVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B smoothedHull(boolean SMOOTHED) {
        this.properties.put("smoothedHull", (Property)new SimpleBooleanProperty(SMOOTHED));
        return (B)this;
    }

    public final B discreteColors(boolean DISCRETE_COLORS) {
        this.properties.put("discreteColors", (Property)new SimpleBooleanProperty(DISCRETE_COLORS));
        return (B)this;
    }

    public final B heatMapOpacity(double HEAT_MAP_OPACITY) {
        this.properties.put("heatMapOpacity", (Property)new SimpleDoubleProperty(HEAT_MAP_OPACITY));
        return (B)this;
    }

    public final B noOfCloserInfluentPoints(int NO_OF_POINTS) {
        this.properties.put("noOfCloserInfluentPoints", (Property)new SimpleIntegerProperty(NO_OF_POINTS));
        return (B)this;
    }

    public final AreaHeatMap build() {
        AreaHeatMap CONTROL = new AreaHeatMap();
        for (String key : this.properties.keySet()) {
            if ("prefSize".equals(key)) {
                Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                CONTROL.setPrefSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("colorMapping".equals(key)) {
                CONTROL.setColorMapping((ColorMapping)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("useColorMapping".equals(key)) {
                CONTROL.setUseColorMapping(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("quality".equals(key)) {
                CONTROL.setQuality(((IntegerProperty)this.properties.get(key)).get());
                continue;
            }
            if ("heatMapOpacity".equals(key)) {
                CONTROL.setHeatMapOpacity(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("dataPointsVisible".equals(key)) {
                CONTROL.setDataPointsVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("smoothedHull".equals(key)) {
                CONTROL.setSmoothedHull(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("discreteColors".equals(key)) {
                CONTROL.setDiscreteColors(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if (!"noOfCloserInfluentPoints".equals(key)) continue;
            CONTROL.setNoOfCloserInfluentPoints(((IntegerProperty)this.properties.get(key)).get());
        }
        if (this.properties.keySet().contains("dataPointsArray")) {
            CONTROL.setDataPoints((DataPoint[])((ObjectProperty)this.properties.get("dataPointsArray")).get());
        }
        if (this.properties.keySet().contains("dataPointsList")) {
            CONTROL.setDataPoints((List)((ObjectProperty)this.properties.get("dataPointsList")).get());
        }
        return CONTROL;
    }
}

