/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.data;

import eu.hansolo.fx.charts.Symbol;
import eu.hansolo.fx.charts.data.ChartItem;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.HashMap;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.paint.Color;

public class ChartItemBuilder<B extends ChartItemBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected ChartItemBuilder() {
    }

    public static final ChartItemBuilder create() {
        return new ChartItemBuilder();
    }

    public final B name(String NAME) {
        this.properties.put("name", (Property)new SimpleStringProperty(NAME));
        return (B)this;
    }

    public final B unit(String UNIT) {
        this.properties.put("unit", (Property)new SimpleStringProperty(UNIT));
        return (B)this;
    }

    public final B value(double VALUE) {
        this.properties.put("value", (Property)new SimpleDoubleProperty(VALUE));
        return (B)this;
    }

    public final B fill(Color COLOR) {
        this.properties.put("fill", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B stroke(Color COLOR) {
        this.properties.put("stroke", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B textFill(Color COLOR) {
        this.properties.put("textFill", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B timestamp(ZonedDateTime DATE_TIME) {
        this.properties.put("timestampDateTime", (Property)new SimpleObjectProperty((Object)DATE_TIME));
        return (B)this;
    }

    public final B timestamp(Instant TIMESTAMP) {
        this.properties.put("timestamp", (Property)new SimpleObjectProperty((Object)TIMESTAMP));
        return (B)this;
    }

    public final B symbol(Symbol SYMBOL) {
        this.properties.put("symbol", (Property)new SimpleObjectProperty((Object)SYMBOL));
        return (B)this;
    }

    public final B animated(boolean AUTO) {
        this.properties.put("animated", (Property)new SimpleBooleanProperty(AUTO));
        return (B)this;
    }

    public final B x(double X) {
        this.properties.put("x", (Property)new SimpleDoubleProperty(X));
        return (B)this;
    }

    public final B y(double Y) {
        this.properties.put("y", (Property)new SimpleDoubleProperty(Y));
        return (B)this;
    }

    public final B animationDuration(long DURATION) {
        this.properties.put("animationDuration", (Property)new SimpleLongProperty(DURATION));
        return (B)this;
    }

    public final ChartItem build() {
        ChartItem ITEM = new ChartItem();
        for (String key : this.properties.keySet()) {
            if ("name".equals(key)) {
                ITEM.setName((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if ("value".equals(key)) {
                ITEM.setValue(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("unit".equals(key)) {
                ITEM.setUnit((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if ("fill".equals(key)) {
                ITEM.setFill((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("stroke".equals(key)) {
                ITEM.setStroke((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("textFill".equals(key)) {
                ITEM.setTextFill((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("timestamp".equals(key)) {
                ITEM.setTimestamp((Instant)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("timestampDateTime".equals(key)) {
                ITEM.setTimestamp((ZonedDateTime)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("symbol".equals(key)) {
                ITEM.setSymbol((Symbol)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("animated".equals(key)) {
                ITEM.setAnimated(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("animationDuration".equals(key)) {
                ITEM.setAnimationDuration(((LongProperty)this.properties.get(key)).get());
                continue;
            }
            if ("x".equals(key)) {
                ITEM.setX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if (!"y".equals(key)) continue;
            ITEM.setY(((DoubleProperty)this.properties.get(key)).get());
        }
        return ITEM;
    }
}

