/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.data;

import eu.hansolo.fx.charts.Symbol;
import eu.hansolo.fx.charts.data.Item;
import eu.hansolo.fx.charts.event.EventType;
import eu.hansolo.fx.charts.event.ItemEvent;
import eu.hansolo.fx.charts.event.ItemEventListener;
import eu.hansolo.fx.charts.tools.Helper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.scene.paint.Color;

public class PlotItem
implements Item,
Comparable<PlotItem> {
    private final ItemEvent ITEM_EVENT = new ItemEvent<PlotItem>(this, EventType.UPDATE);
    private String _name;
    private StringProperty name;
    private double _value;
    private DoubleProperty value;
    private String _description;
    private StringProperty description;
    private Color _fill;
    private ObjectProperty<Color> fill;
    private Color _stroke;
    private ObjectProperty<Color> stroke;
    private Symbol _symbol;
    private ObjectProperty<Symbol> symbol;
    private Map<PlotItem, Double> outgoing;
    private Map<PlotItem, Double> incoming;
    private List<ItemEventListener> listeners;
    private int level;

    public PlotItem() {
        this("", 0.0, "", Color.RED);
    }

    public PlotItem(String NAME, double VALUE) {
        this(NAME, VALUE, "", Color.RED);
    }

    public PlotItem(String NAME, Color COLOR) {
        this(NAME, 0.0, COLOR);
    }

    public PlotItem(String NAME, double VALUE, Color COLOR) {
        this(NAME, VALUE, "", COLOR);
    }

    public PlotItem(String NAME, double VALUE, String DESCRIPTION, Color FILL) {
        this._name = NAME;
        this._value = VALUE;
        this._description = DESCRIPTION;
        this._fill = FILL;
        this._stroke = Color.TRANSPARENT;
        this._symbol = Symbol.NONE;
        this.level = -1;
        this.outgoing = new LinkedHashMap<PlotItem, Double>();
        this.incoming = new LinkedHashMap<PlotItem, Double>();
        this.listeners = new CopyOnWriteArrayList<ItemEventListener>();
    }

    @Override
    public String getName() {
        return null == this.name ? this._name : (String)this.name.get();
    }

    public void setName(String NAME) {
        if (null == this.name) {
            this._name = NAME;
            this.fireItemEvent(this.ITEM_EVENT);
        } else {
            this.name.set((Object)NAME);
        }
    }

    public StringProperty nameProperty() {
        if (null == this.name) {
            this.name = new StringPropertyBase(this._name){

                protected void invalidated() {
                    PlotItem.this.fireItemEvent(PlotItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return PlotItem.this;
                }

                public String getName() {
                    return "name";
                }
            };
            this._name = null;
        }
        return this.name;
    }

    public double getValue() {
        return null == this.value ? this._value : this.value.get();
    }

    public void setValue(double VALUE) {
        if (null == this.value) {
            this._value = VALUE;
            this.fireItemEvent(this.ITEM_EVENT);
        } else {
            this.value.set(VALUE);
        }
    }

    public DoubleProperty valueProperty() {
        if (null == this.value) {
            this.value = new DoublePropertyBase(this._value){

                protected void invalidated() {
                    PlotItem.this.fireItemEvent(PlotItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return PlotItem.this;
                }

                public String getName() {
                    return "value";
                }
            };
        }
        return this.value;
    }

    public String getDescription() {
        return null == this.description ? this._description : (String)this.description.get();
    }

    public void setDescription(String DESCRIPTION) {
        if (null == this.description) {
            this._description = DESCRIPTION;
            this.fireItemEvent(this.ITEM_EVENT);
        } else {
            this.description.set((Object)DESCRIPTION);
        }
    }

    public StringProperty descriptionProperty() {
        if (null == this.description) {
            this.description = new StringPropertyBase(this._description){

                protected void invalidated() {
                    PlotItem.this.fireItemEvent(PlotItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return PlotItem.this;
                }

                public String getName() {
                    return "description";
                }
            };
            this._description = null;
        }
        return this.description;
    }

    @Override
    public Color getFill() {
        return null == this.fill ? this._fill : (Color)this.fill.get();
    }

    public void setFill(Color FILL) {
        if (null == this.fill) {
            this._fill = FILL;
            this.fireItemEvent(this.ITEM_EVENT);
        } else {
            this.fill.set((Object)FILL);
        }
    }

    public ObjectProperty<Color> fillProperty() {
        if (null == this.fill) {
            this.fill = new ObjectPropertyBase<Color>(this._fill){

                protected void invalidated() {
                    PlotItem.this.fireItemEvent(PlotItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return PlotItem.this;
                }

                public String getName() {
                    return "fill";
                }
            };
            this._fill = null;
        }
        return this.fill;
    }

    @Override
    public Color getStroke() {
        return null == this.stroke ? this._stroke : (Color)this.stroke.get();
    }

    public void setStroke(Color STROKE) {
        if (null == this.stroke) {
            this._stroke = STROKE;
            this.fireItemEvent(this.ITEM_EVENT);
        } else {
            this.stroke.set((Object)STROKE);
        }
    }

    public ObjectProperty<Color> strokeProperty() {
        if (null == this.stroke) {
            this.stroke = new ObjectPropertyBase<Color>(this._stroke){

                protected void invalidated() {
                    PlotItem.this.fireItemEvent(PlotItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return PlotItem.this;
                }

                public String getName() {
                    return "stroke";
                }
            };
            this._stroke = null;
        }
        return this.stroke;
    }

    @Override
    public Symbol getSymbol() {
        return null == this.symbol ? this._symbol : (Symbol)((Object)this.symbol.get());
    }

    @Override
    public void setSymbol(Symbol SYMBOL) {
        if (null == this.symbol) {
            this._symbol = SYMBOL;
            this.fireItemEvent(this.ITEM_EVENT);
        } else {
            this.symbol.set((Object)SYMBOL);
        }
    }

    public ObjectProperty<Symbol> symbolProperty() {
        if (null == this.symbol) {
            this.symbol = new ObjectPropertyBase<Symbol>(this._symbol){

                protected void invalidated() {
                    PlotItem.this.fireItemEvent(PlotItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return PlotItem.this;
                }

                public String getName() {
                    return "symbol";
                }
            };
            this._symbol = null;
        }
        return this.symbol;
    }

    public double getSumOfIncoming() {
        return this.getIncoming().values().stream().mapToDouble(Double::doubleValue).sum();
    }

    public double getSumOfOutgoing() {
        return this.getOutgoing().values().stream().mapToDouble(Double::doubleValue).sum();
    }

    public double getMaxSum() {
        return Math.max(this.getSumOfIncoming(), this.getSumOfOutgoing());
    }

    public Map<PlotItem, Double> getOutgoing() {
        return this.outgoing;
    }

    public void setOutgoing(Map<PlotItem, Double> OUTGOING) {
        this.outgoing.forEach((item, value) -> item.removeFromIncoming(this));
        this.outgoing.clear();
        this.outgoing.putAll(OUTGOING);
        this.establishConnections();
        this.fireItemEvent(this.ITEM_EVENT);
    }

    public void addToOutgoing(PlotItem ITEM, double VALUE) {
        if (!this.outgoing.containsKey(ITEM)) {
            this.outgoing.put(ITEM, Helper.clamp(0.0, Double.MAX_VALUE, VALUE));
            this.establishConnections();
            this.fireItemEvent(this.ITEM_EVENT);
        }
    }

    public void removeFromOutgoing(PlotItem ITEM) {
        if (this.outgoing.containsKey(ITEM)) {
            ITEM.removeFromIncoming(this);
            this.outgoing.remove(ITEM);
            this.fireItemEvent(this.ITEM_EVENT);
        }
    }

    public void clearOutgoing() {
        this.outgoing.forEach((item, value) -> item.removeFromIncoming(this));
        this.outgoing.clear();
        this.fireItemEvent(this.ITEM_EVENT);
    }

    public boolean hasOutgoing() {
        return this.outgoing.size() > 0;
    }

    public Map<PlotItem, Double> getIncoming() {
        return this.incoming;
    }

    protected void setIncoming(Map<PlotItem, Double> INCOMING) {
        this.incoming.clear();
        this.incoming.putAll(INCOMING);
        this.fireItemEvent(this.ITEM_EVENT);
    }

    protected void addToIncoming(PlotItem ITEM, double VALUE) {
        if (!this.incoming.containsKey(ITEM)) {
            this.incoming.put(ITEM, Helper.clamp(0.0, Double.MAX_VALUE, VALUE));
            this.fireItemEvent(this.ITEM_EVENT);
        }
    }

    protected void removeFromIncoming(PlotItem ITEM) {
        if (this.incoming.containsKey(ITEM)) {
            this.incoming.remove(ITEM);
            this.fireItemEvent(this.ITEM_EVENT);
        }
    }

    protected void clearIncoming() {
        this.incoming.clear();
        this.fireItemEvent(this.ITEM_EVENT);
    }

    public boolean hasIncoming() {
        return this.incoming.size() > 0;
    }

    public boolean isRoot() {
        return this.hasOutgoing() && !this.hasIncoming();
    }

    public int getLevel() {
        if (this.level == -1) {
            if (this.isRoot()) {
                this.level = 0;
            } else {
                for (PlotItem item : this.getIncoming().keySet()) {
                    this.level = this.getLevel(item, 0);
                }
            }
        }
        return this.level;
    }

    private int getLevel(PlotItem ITEM, int level) {
        ++level;
        if (ITEM.isRoot()) {
            return level;
        }
        level = this.getLevel(ITEM.getIncoming().keySet().iterator().next(), level);
        return level;
    }

    public void sortOutgoingByGivenList(List<PlotItem> LIST_WITH_SORTED_ITEMS) {
        ArrayList<PlotItem> outgoingKeys = new ArrayList<PlotItem>(this.getOutgoing().keySet());
        this.sortAndReverse(outgoingKeys, LIST_WITH_SORTED_ITEMS);
        LinkedHashMap<PlotItem, Double> sortedOutgoingItems = new LinkedHashMap<PlotItem, Double>(outgoingKeys.size());
        for (PlotItem plotItem : outgoingKeys) {
            sortedOutgoingItems.put(plotItem, this.getOutgoing().get(plotItem));
        }
        this.outgoing.clear();
        this.outgoing.putAll(sortedOutgoingItems);
    }

    public void sortIncomingByGivenList(List<PlotItem> LIST_WITH_SORTED_ITEMS) {
        ArrayList<PlotItem> incomingKeys = new ArrayList<PlotItem>(this.getIncoming().keySet());
        Collections.reverse(incomingKeys);
        this.sortAndReverse(incomingKeys, LIST_WITH_SORTED_ITEMS);
        LinkedHashMap<PlotItem, Double> sortedIncomingItems = new LinkedHashMap<PlotItem, Double>(incomingKeys.size());
        for (PlotItem plotItem : incomingKeys) {
            sortedIncomingItems.put(plotItem, this.getIncoming().get(plotItem));
        }
        this.incoming.clear();
        this.incoming.putAll(sortedIncomingItems);
    }

    private void sortAndReverse(List<PlotItem> LIST_TO_SORT, List<PlotItem> SORTED_LIST) {
        Collections.sort(LIST_TO_SORT, Comparator.comparing(item -> SORTED_LIST.indexOf(item)));
        Collections.reverse(LIST_TO_SORT);
    }

    private void establishConnections() {
        this.outgoing.forEach((item, value) -> item.addToIncoming(this, (double)value));
    }

    @Override
    public int compareTo(PlotItem ITEM) {
        return Double.compare(this.getValue(), ITEM.getValue());
    }

    public void setOnItemEvent(ItemEventListener LISTENER) {
        this.addItemEventListener(LISTENER);
    }

    public void addItemEventListener(ItemEventListener LISTENER) {
        if (!this.listeners.contains(LISTENER)) {
            this.listeners.add(LISTENER);
        }
    }

    public void removeItemEventListener(ItemEventListener LISTENER) {
        if (this.listeners.contains(LISTENER)) {
            this.listeners.remove(LISTENER);
        }
    }

    public void fireItemEvent(ItemEvent EVENT) {
        this.listeners.forEach(listener -> listener.onItemEvent(EVENT));
    }
}

