/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.series;

import eu.hansolo.fx.charts.ChartType;
import eu.hansolo.fx.charts.Symbol;
import eu.hansolo.fx.charts.data.Item;
import eu.hansolo.fx.charts.data.XYItem;
import eu.hansolo.fx.charts.series.XYSeries;
import java.util.HashMap;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class XYSeriesBuilder<B extends XYSeriesBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected XYSeriesBuilder() {
    }

    public static final XYSeriesBuilder create() {
        return new XYSeriesBuilder();
    }

    public final B items(XYItem ... ITEMS) {
        this.properties.put("itemsArray", (Property)new SimpleObjectProperty((Object)ITEMS));
        return (B)this;
    }

    public final B items(List<XYItem> ITEMS) {
        this.properties.put("itemsList", (Property)new SimpleObjectProperty(ITEMS));
        return (B)this;
    }

    public final B name(String NAME) {
        this.properties.put("name", (Property)new SimpleStringProperty(NAME));
        return (B)this;
    }

    public final B fill(Paint FILL) {
        this.properties.put("fill", (Property)new SimpleObjectProperty((Object)FILL));
        return (B)this;
    }

    public final B stroke(Paint STROKE) {
        this.properties.put("stroke", (Property)new SimpleObjectProperty((Object)STROKE));
        return (B)this;
    }

    public final B textFill(Color FILL) {
        this.properties.put("textFill", (Property)new SimpleObjectProperty((Object)FILL));
        return (B)this;
    }

    public final B symbolFill(Color FILL) {
        this.properties.put("symbolFill", (Property)new SimpleObjectProperty((Object)FILL));
        return (B)this;
    }

    public final B symbolStroke(Color STROKE) {
        this.properties.put("symbolStroke", (Property)new SimpleObjectProperty((Object)STROKE));
        return (B)this;
    }

    public final B symbol(Symbol SYMBOL) {
        this.properties.put("symbol", (Property)new SimpleObjectProperty((Object)SYMBOL));
        return (B)this;
    }

    public final B chartType(ChartType TYPE) {
        this.properties.put("chartType", (Property)new SimpleObjectProperty((Object)TYPE));
        return (B)this;
    }

    public final B symbolsVisible(boolean VISIBLE) {
        this.properties.put("symbolsVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B symbolSize(double SIZE) {
        this.properties.put("symbolSize", (Property)new SimpleDoubleProperty(SIZE));
        return (B)this;
    }

    public final B strokeWidth(double WIDTH) {
        this.properties.put("strokeWidth", (Property)new SimpleDoubleProperty(WIDTH));
        return (B)this;
    }

    public final B animated(boolean AUTO) {
        this.properties.put("animated", (Property)new SimpleBooleanProperty(AUTO));
        return (B)this;
    }

    public final B animationDuration(long DURATION) {
        this.properties.put("animationDuration", (Property)new SimpleLongProperty(DURATION));
        return (B)this;
    }

    public final XYSeries build() {
        XYSeries SERIES = new XYSeries();
        if (this.properties.keySet().contains("itemsArray")) {
            SERIES.setItems((Item[])((ObjectProperty)this.properties.get("itemsArray")).get());
        }
        if (this.properties.keySet().contains("itemsList")) {
            SERIES.setItems((List)((ObjectProperty)this.properties.get("itemsList")).get());
        }
        for (String key : this.properties.keySet()) {
            if ("name".equals(key)) {
                SERIES.setName((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if ("fill".equals(key)) {
                SERIES.setFill((Paint)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("stroke".equals(key)) {
                SERIES.setStroke((Paint)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("textFill".equals(key)) {
                SERIES.setTextFill((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("symbolFill".equals(key)) {
                SERIES.setSymbolFill((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("symbolStroke".equals(key)) {
                SERIES.setSymbolStroke((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("symbol".equals(key)) {
                SERIES.setSymbol((Symbol)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("chartType".equals(key)) {
                SERIES.setChartType((ChartType)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("symbolsVisible".equals(key)) {
                SERIES.setSymbolsVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("symbolSize".equals(key)) {
                SERIES.setSymbolSize(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("strokeWidth".equals(key)) {
                SERIES.setStrokeWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("animated".equals(key)) {
                SERIES.setAnimated(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if (!"animationDuration".equals(key)) continue;
            SERIES.setAnimationDuration(((LongProperty)this.properties.get(key)).get());
        }
        return SERIES;
    }
}

