/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.world;

import eu.hansolo.fx.charts.heatmap.HeatMap;
import eu.hansolo.fx.charts.heatmap.HeatMapBuilder;
import eu.hansolo.fx.charts.heatmap.OpacityDistribution;
import eu.hansolo.fx.charts.tools.ColorMapping;
import eu.hansolo.fx.charts.tools.Location;
import eu.hansolo.fx.charts.tools.Point;
import eu.hansolo.fx.charts.world.CRegion;
import eu.hansolo.fx.charts.world.Country;
import eu.hansolo.fx.charts.world.CountryPath;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import javafx.application.Platform;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.StyleablePropertyFactory;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.event.WeakEventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.CacheHint;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.SVGPath;
import javafx.scene.shape.Shape;
import javafx.scene.text.Font;

@DefaultProperty(value="children")
public class World
extends Region {
    private static final StyleablePropertyFactory<World> FACTORY = new StyleablePropertyFactory(Region.getClassCssMetaData());
    private static final String HIRES_PROPERTIES = "eu/hansolo/fx/charts/world/hires.properties";
    private static final String LORES_PROPERTIES = "eu/hansolo/fx/chaworld/lores.properties";
    private static final double PREFERRED_WIDTH = 1009.0;
    private static final double PREFERRED_HEIGHT = 665.0;
    private static final double MINIMUM_WIDTH = 100.0;
    private static final double MINIMUM_HEIGHT = 66.0;
    private static final double MAXIMUM_WIDTH = 2018.0;
    private static final double MAXIMUM_HEIGHT = 1330.0;
    private static double MAP_OFFSET_X = -28.756500000000003;
    private static double MAP_OFFSET_Y = 129.675;
    private static final double ASPECT_RATIO = 0.6590683845391476;
    private static final CssMetaData<World, Color> BACKGROUND_COLOR = FACTORY.createColorCssMetaData("-background-color", s -> s.backgroundColor, Color.web((String)"#3f3f4f"), false);
    private final StyleableProperty<Color> backgroundColor;
    private static final CssMetaData<World, Color> FILL_COLOR = FACTORY.createColorCssMetaData("-fill-color", s -> s.fillColor, Color.web((String)"#d9d9dc"), false);
    private final StyleableProperty<Color> fillColor;
    private static final CssMetaData<World, Color> STROKE_COLOR = FACTORY.createColorCssMetaData("-stroke-color", s -> s.strokeColor, Color.BLACK, false);
    private final StyleableProperty<Color> strokeColor;
    private static final CssMetaData<World, Color> HOVER_COLOR = FACTORY.createColorCssMetaData("-hover-color", s -> s.hoverColor, Color.web((String)"#456acf"), false);
    private final StyleableProperty<Color> hoverColor;
    private static final CssMetaData<World, Color> PRESSED_COLOR = FACTORY.createColorCssMetaData("-pressed-color", s -> s.pressedColor, Color.web((String)"#789dff"), false);
    private final StyleableProperty<Color> pressedColor;
    private static final CssMetaData<World, Color> SELECTED_COLOR = FACTORY.createColorCssMetaData("-selected-color", s -> s.selectedColor, Color.web((String)"#9dff78"), false);
    private final StyleableProperty<Color> selectedColor;
    private static final CssMetaData<World, Color> LOCATION_COLOR = FACTORY.createColorCssMetaData("-location-color", s -> s.locationColor, Color.web((String)"#ff0000"), false);
    private final StyleableProperty<Color> locationColor;
    private BooleanProperty hoverEnabled;
    private BooleanProperty selectionEnabled;
    private ObjectProperty<Country> selectedCountry;
    private BooleanProperty zoomEnabled;
    private DoubleProperty scaleFactor;
    private Properties resolutionProperties;
    private Country formerSelectedCountry;
    private double zoomSceneX;
    private double zoomSceneY;
    private double width;
    private double height;
    private double size;
    private Pane pane;
    private Group group;
    private HeatMap heatMap;
    private Map<String, List<CountryPath>> countryPaths;
    private ObservableMap<Location, Shape> locations;
    private ColorMapping colorMapping;
    private double spotRadius;
    private boolean fadeColors;
    private OpacityDistribution opacityDistribution;
    private double heatMapOpacity;
    private BooleanProperty heatMapVisible;
    protected EventHandler<MouseEvent> _mouseEnterHandler;
    protected EventHandler<MouseEvent> _mousePressHandler;
    protected EventHandler<MouseEvent> _mouseReleaseHandler;
    protected EventHandler<MouseEvent> _mouseExitHandler;
    private EventHandler<ScrollEvent> _scrollEventHandler;
    private EventHandler<MouseEvent> mouseEnterHandler;
    private EventHandler<MouseEvent> mousePressHandler;
    private EventHandler<MouseEvent> mouseReleaseHandler;
    private EventHandler<MouseEvent> mouseExitHandler;

    public World() {
        this(Resolution.HI_RES, ColorMapping.INFRARED_3, 5.0, false, OpacityDistribution.EXPONENTIAL, 0.75);
    }

    public World(Resolution RESOLUTION) {
        this(RESOLUTION, ColorMapping.INFRARED_3, 5.0, false, OpacityDistribution.EXPONENTIAL, 0.75);
    }

    public World(Resolution RESOLUTION, ColorMapping COLOR_MAPPING, double EVENT_RADIUS, boolean FADE_COLORS, OpacityDistribution OPACITY_DISTRIBUTION, double HEAT_MAP_OPACITY) {
        this.resolutionProperties = this.readProperties(Resolution.HI_RES == RESOLUTION ? HIRES_PROPERTIES : LORES_PROPERTIES);
        this.backgroundColor = new StyleableObjectProperty<Color>((Color)BACKGROUND_COLOR.getInitialValue((Styleable)this)){

            protected void invalidated() {
                World.this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)this.get(), CornerRadii.EMPTY, Insets.EMPTY)}));
            }

            public Object getBean() {
                return World.this;
            }

            public String getName() {
                return "backgroundColor";
            }

            public CssMetaData<? extends Styleable, Color> getCssMetaData() {
                return BACKGROUND_COLOR;
            }
        };
        this.fillColor = new StyleableObjectProperty<Color>((Color)FILL_COLOR.getInitialValue((Styleable)this)){

            protected void invalidated() {
                World.this.setFillAndStroke();
            }

            public Object getBean() {
                return World.this;
            }

            public String getName() {
                return "fillColor";
            }

            public CssMetaData<? extends Styleable, Color> getCssMetaData() {
                return FILL_COLOR;
            }
        };
        this.strokeColor = new StyleableObjectProperty<Color>((Color)STROKE_COLOR.getInitialValue((Styleable)this)){

            protected void invalidated() {
                World.this.setFillAndStroke();
            }

            public Object getBean() {
                return World.this;
            }

            public String getName() {
                return "strokeColor";
            }

            public CssMetaData<? extends Styleable, Color> getCssMetaData() {
                return STROKE_COLOR;
            }
        };
        this.hoverColor = new StyleableObjectProperty<Color>((Color)HOVER_COLOR.getInitialValue((Styleable)this)){

            protected void invalidated() {
            }

            public Object getBean() {
                return World.this;
            }

            public String getName() {
                return "hoverColor";
            }

            public CssMetaData<? extends Styleable, Color> getCssMetaData() {
                return HOVER_COLOR;
            }
        };
        this.pressedColor = new StyleableObjectProperty<Color>((Color)PRESSED_COLOR.getInitialValue((Styleable)this)){

            protected void invalidated() {
            }

            public Object getBean() {
                return World.this;
            }

            public String getName() {
                return "pressedColor";
            }

            public CssMetaData<? extends Styleable, Color> getCssMetaData() {
                return PRESSED_COLOR;
            }
        };
        this.selectedColor = new StyleableObjectProperty<Color>((Color)SELECTED_COLOR.getInitialValue((Styleable)this)){

            protected void invalidated() {
            }

            public Object getBean() {
                return World.this;
            }

            public String getName() {
                return "selectedColor";
            }

            public CssMetaData<? extends Styleable, Color> getCssMetaData() {
                return SELECTED_COLOR;
            }
        };
        this.locationColor = new StyleableObjectProperty<Color>((Color)LOCATION_COLOR.getInitialValue((Styleable)this)){

            protected void invalidated() {
                World.this.locations.forEach((location, shape) -> shape.setFill((Paint)(null == location.getColor() ? (Paint)this.get() : location.getColor())));
            }

            public Object getBean() {
                return World.this;
            }

            public String getName() {
                return "locationColor";
            }

            public CssMetaData<? extends Styleable, Color> getCssMetaData() {
                return LOCATION_COLOR;
            }
        };
        this.hoverEnabled = new BooleanPropertyBase(true){

            protected void invalidated() {
            }

            public Object getBean() {
                return World.this;
            }

            public String getName() {
                return "hoverEnabled";
            }
        };
        this.selectionEnabled = new BooleanPropertyBase(false){

            protected void invalidated() {
            }

            public Object getBean() {
                return World.this;
            }

            public String getName() {
                return "selectionEnabled";
            }
        };
        this.selectedCountry = new ObjectPropertyBase<Country>(){

            protected void invalidated() {
            }

            public Object getBean() {
                return World.this;
            }

            public String getName() {
                return "selectedCountry";
            }
        };
        this.zoomEnabled = new BooleanPropertyBase(false){

            protected void invalidated() {
                if (null == World.this.getScene()) {
                    return;
                }
                if (this.get()) {
                    World.this.getScene().addEventFilter(ScrollEvent.ANY, World.this._scrollEventHandler);
                } else {
                    World.this.getScene().removeEventFilter(ScrollEvent.ANY, World.this._scrollEventHandler);
                }
            }

            public Object getBean() {
                return World.this;
            }

            public String getName() {
                return "zoomEnabled";
            }
        };
        this.scaleFactor = new DoublePropertyBase(1.0){

            protected void invalidated() {
                if (World.this.isZoomEnabled()) {
                    World.this.setScaleX(this.get());
                    World.this.setScaleY(this.get());
                }
            }

            public Object getBean() {
                return World.this;
            }

            public String getName() {
                return "scaleFactor";
            }
        };
        this.countryPaths = this.createCountryPaths();
        this.locations = FXCollections.observableHashMap();
        this.colorMapping = COLOR_MAPPING;
        this.spotRadius = EVENT_RADIUS;
        this.fadeColors = FADE_COLORS;
        this.opacityDistribution = OPACITY_DISTRIBUTION;
        this.heatMapOpacity = HEAT_MAP_OPACITY;
        this.heatMapVisible = new BooleanPropertyBase(true){

            protected void invalidated() {
                World.this.heatMap.setVisible(this.get());
                World.this.heatMap.setManaged(this.get());
            }

            public Object getBean() {
                return World.this;
            }

            public String getName() {
                return "heatMapVisible";
            }
        };
        this.pane = new Pane();
        this.group = new Group();
        this._mouseEnterHandler = evt -> this.handleMouseEvent((MouseEvent)evt, this.mouseEnterHandler);
        this._mousePressHandler = evt -> this.handleMouseEvent((MouseEvent)evt, this.mousePressHandler);
        this._mouseReleaseHandler = evt -> this.handleMouseEvent((MouseEvent)evt, this.mouseReleaseHandler);
        this._mouseExitHandler = evt -> this.handleMouseEvent((MouseEvent)evt, this.mouseExitHandler);
        this._scrollEventHandler = evt -> {
            double scale;
            if (this.group.getTranslateX() != 0.0 || this.group.getTranslateY() != 0.0) {
                this.resetZoom();
            }
            double delta = 1.2;
            double oldScale = scale = this.getScaleFactor();
            scale = evt.getDeltaY() < 0.0 ? scale / delta : scale * delta;
            scale = this.clamp(1.0, 10.0, scale);
            double factor = scale / oldScale - 1.0;
            if (Double.compare(1.0, this.getScaleFactor()) == 0) {
                this.zoomSceneX = evt.getSceneX();
                this.zoomSceneY = evt.getSceneY();
                this.resetZoom();
            }
            double deltaX = this.zoomSceneX - (this.getBoundsInParent().getWidth() / 2.0 + this.getBoundsInParent().getMinX());
            double deltaY = this.zoomSceneY - (this.getBoundsInParent().getHeight() / 2.0 + this.getBoundsInParent().getMinY());
            this.setScaleFactor(scale);
            this.setPivot(deltaX * factor, deltaY * factor);
            evt.consume();
        };
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(1009.0, 665.0);
            }
        }
        this.getStyleClass().add((Object)"world");
        Color fill = this.getFillColor();
        Color stroke = this.getStrokeColor();
        this.countryPaths.forEach((name, pathList) -> {
            Country country = Country.valueOf(name);
            pathList.forEach(path -> {
                path.setFill((Paint)(null == country.getColor() ? fill : country.getColor()));
                path.setStroke((Paint)stroke);
                path.setStrokeWidth(0.2);
                path.setOnMouseEntered((EventHandler)new WeakEventHandler(this._mouseEnterHandler));
                path.setOnMousePressed((EventHandler)new WeakEventHandler(this._mousePressHandler));
                path.setOnMouseReleased((EventHandler)new WeakEventHandler(this._mouseReleaseHandler));
                path.setOnMouseExited((EventHandler)new WeakEventHandler(this._mouseExitHandler));
            });
            this.pane.getChildren().addAll((Collection)pathList);
        });
        this.group.getChildren().add((Object)this.pane);
        this.heatMap = ((HeatMapBuilder)((HeatMapBuilder)((HeatMapBuilder)((HeatMapBuilder)((HeatMapBuilder)((HeatMapBuilder)HeatMapBuilder.create().prefSize(1009.0, 665.0)).colorMapping(this.colorMapping)).spotRadius(this.spotRadius)).fadeColors(this.fadeColors)).opacityDistribution(this.opacityDistribution)).heatMapOpacity(this.heatMapOpacity)).build();
        this.getChildren().setAll((Object[])new Node[]{this.group, this.heatMap});
        this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)this.getBackgroundColor(), CornerRadii.EMPTY, Insets.EMPTY)}));
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
        this.sceneProperty().addListener(o -> {
            if (!this.locations.isEmpty()) {
                this.addShapesToScene(this.locations.values());
            }
            if (this.isZoomEnabled()) {
                this.getScene().addEventFilter(ScrollEvent.ANY, (EventHandler)new WeakEventHandler(this._scrollEventHandler));
            }
            this.locations.addListener(CHANGE -> {
                if (CHANGE.wasAdded()) {
                    this.addShapesToScene((Shape)CHANGE.getValueAdded());
                } else if (CHANGE.wasRemoved()) {
                    Platform.runLater(() -> this.pane.getChildren().remove(CHANGE.getValueRemoved()));
                }
            });
        });
    }

    protected double computeMinWidth(double HEIGHT) {
        return 100.0;
    }

    protected double computeMinHeight(double WIDTH) {
        return 66.0;
    }

    protected double computePrefWidth(double HEIGHT) {
        return super.computePrefWidth(HEIGHT);
    }

    protected double computePrefHeight(double WIDTH) {
        return super.computePrefHeight(WIDTH);
    }

    protected double computeMaxWidth(double HEIGHT) {
        return 2018.0;
    }

    protected double computeMaxHeight(double WIDTH) {
        return 1330.0;
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public Map<String, List<CountryPath>> getCountryPaths() {
        return this.countryPaths;
    }

    public void setMouseEnterHandler(EventHandler<MouseEvent> HANDLER) {
        this.mouseEnterHandler = HANDLER;
    }

    public void setMousePressHandler(EventHandler<MouseEvent> HANDLER) {
        this.mousePressHandler = HANDLER;
    }

    public void setMouseReleaseHandler(EventHandler<MouseEvent> HANDLER) {
        this.mouseReleaseHandler = HANDLER;
    }

    public void setMouseExitHandler(EventHandler<MouseEvent> HANDLER) {
        this.mouseExitHandler = HANDLER;
    }

    public Color getBackgroundColor() {
        return (Color)this.backgroundColor.getValue();
    }

    public void setBackgroundColor(Color COLOR) {
        this.backgroundColor.setValue((Object)COLOR);
    }

    public ObjectProperty<Color> backgroundColorProperty() {
        return (ObjectProperty)this.backgroundColor;
    }

    public Color getFillColor() {
        return (Color)this.fillColor.getValue();
    }

    public void setFillColor(Color COLOR) {
        this.fillColor.setValue((Object)COLOR);
    }

    public ObjectProperty<Color> fillColorProperty() {
        return (ObjectProperty)this.fillColor;
    }

    public Color getStrokeColor() {
        return (Color)this.strokeColor.getValue();
    }

    public void setStrokeColor(Color COLOR) {
        this.strokeColor.setValue((Object)COLOR);
    }

    public ObjectProperty<Color> strokeColorProperty() {
        return (ObjectProperty)this.strokeColor;
    }

    public Color getHoverColor() {
        return (Color)this.hoverColor.getValue();
    }

    public void setHoverColor(Color COLOR) {
        this.hoverColor.setValue((Object)COLOR);
    }

    public ObjectProperty<Color> hoverColorProperty() {
        return (ObjectProperty)this.hoverColor;
    }

    public Color getPressedColor() {
        return (Color)this.pressedColor.getValue();
    }

    public void setPressedColor(Color COLOR) {
        this.pressedColor.setValue((Object)COLOR);
    }

    public ObjectProperty<Color> pressedColorProperty() {
        return (ObjectProperty)this.pressedColor;
    }

    public Color getSelectedColor() {
        return (Color)this.selectedColor.getValue();
    }

    public void setSelectedColor(Color COLOR) {
        this.selectedColor.setValue((Object)COLOR);
    }

    public ObjectProperty<Color> selectedColorProperty() {
        return (ObjectProperty)this.selectedColor;
    }

    public Color getLocationColor() {
        return (Color)this.locationColor.getValue();
    }

    public void setLocationColor(Color COLOR) {
        this.locationColor.setValue((Object)COLOR);
    }

    public ObjectProperty<Color> locationColorProperty() {
        return (ObjectProperty)this.locationColor;
    }

    public boolean isHoverEnabled() {
        return this.hoverEnabled.get();
    }

    public void setHoverEnabled(boolean ENABLED) {
        this.hoverEnabled.set(ENABLED);
    }

    public BooleanProperty hoverEnabledProperty() {
        return this.hoverEnabled;
    }

    public boolean isSelectionEnabled() {
        return this.selectionEnabled.get();
    }

    public void setSelectionEnabled(boolean ENABLED) {
        this.selectionEnabled.set(ENABLED);
    }

    public BooleanProperty selectionEnabledProperty() {
        return this.selectionEnabled;
    }

    public Country getSelectedCountry() {
        return (Country)((Object)this.selectedCountry.get());
    }

    public void setSelectedCountry(Country COUNTRY) {
        this.selectedCountry.set((Object)COUNTRY);
    }

    public ObjectProperty<Country> selectedCountryProperty() {
        return this.selectedCountry;
    }

    public boolean isZoomEnabled() {
        return this.zoomEnabled.get();
    }

    public void setZoomEnabled(boolean ENABLED) {
        this.zoomEnabled.set(ENABLED);
    }

    public BooleanProperty zoomEnabledProperty() {
        return this.zoomEnabled;
    }

    public double getScaleFactor() {
        return this.scaleFactor.get();
    }

    public void setScaleFactor(double FACTOR) {
        this.scaleFactor.set(FACTOR);
    }

    public DoubleProperty scaleFactorProperty() {
        return this.scaleFactor;
    }

    public boolean isHeatMapVisible() {
        return this.heatMapVisible.get();
    }

    public void setHeatMapVisible(boolean VISIBLE) {
        this.heatMapVisible.set(VISIBLE);
    }

    public BooleanProperty heatMapVisibleProperty() {
        return this.heatMapVisible;
    }

    public void resetZoom() {
        this.setScaleFactor(1.0);
        this.setTranslateX(0.0);
        this.setTranslateY(0.0);
        this.group.setTranslateX(0.0);
        this.group.setTranslateY(0.0);
    }

    public void addLocation(Location LOCATION) {
        String tooltipText;
        double x = (LOCATION.getLongitude() + 180.0) * 2.8027777777777776 + MAP_OFFSET_X;
        double y = 332.5 - 1009.0 * Math.log(Math.tan(0.7853981633974483 + Math.toRadians(LOCATION.getLatitude()) / 2.0)) / (Math.PI * 2) + MAP_OFFSET_Y;
        Circle locationIcon = new Circle(x, y, this.size * 0.01);
        locationIcon.setFill((Paint)(null == LOCATION.getColor() ? this.getLocationColor() : LOCATION.getColor()));
        StringBuilder tooltipBuilder = new StringBuilder();
        if (!LOCATION.getName().isEmpty()) {
            tooltipBuilder.append(LOCATION.getName());
        }
        if (!LOCATION.getInfo().isEmpty()) {
            tooltipBuilder.append("\n").append(LOCATION.getInfo());
        }
        if (!(tooltipText = tooltipBuilder.toString()).isEmpty()) {
            Tooltip tooltip = new Tooltip(tooltipText);
            tooltip.setFont(Font.font((double)10.0));
            Tooltip.install((Node)locationIcon, (Tooltip)tooltip);
        }
        if (null != LOCATION.getMouseEnterHandler()) {
            locationIcon.setOnMouseEntered((EventHandler)new WeakEventHandler(LOCATION.getMouseEnterHandler()));
        }
        if (null != LOCATION.getMousePressHandler()) {
            locationIcon.setOnMousePressed((EventHandler)new WeakEventHandler(LOCATION.getMousePressHandler()));
        }
        if (null != LOCATION.getMouseReleaseHandler()) {
            locationIcon.setOnMouseReleased((EventHandler)new WeakEventHandler(LOCATION.getMouseReleaseHandler()));
        }
        if (null != LOCATION.getMouseExitHandler()) {
            locationIcon.setOnMouseExited((EventHandler)new WeakEventHandler(LOCATION.getMouseExitHandler()));
        }
        this.locations.put((Object)LOCATION, (Object)locationIcon);
    }

    public void removeLocation(Location LOCATION) {
        this.locations.remove((Object)LOCATION);
    }

    public void addLocations(Location ... LOCATIONS) {
        for (Location location : LOCATIONS) {
            this.addLocation(location);
        }
    }

    public void clearLocations() {
        this.locations.clear();
    }

    public void showLocations(boolean SHOW) {
        for (Shape shape : this.locations.values()) {
            shape.setManaged(SHOW);
            shape.setVisible(SHOW);
        }
    }

    public void zoomToCountry(Country COUNTRY) {
        if (!this.isZoomEnabled()) {
            return;
        }
        if (null != this.getSelectedCountry()) {
            this.setCountryFillAndStroke(this.getSelectedCountry(), this.getFillColor(), this.getStrokeColor());
        }
        this.zoomToArea(this.getBounds(COUNTRY));
    }

    public void zoomToRegion(CRegion REGION) {
        if (!this.isZoomEnabled()) {
            return;
        }
        if (null != this.getSelectedCountry()) {
            this.setCountryFillAndStroke(this.getSelectedCountry(), this.getFillColor(), this.getStrokeColor());
        }
        this.zoomToArea(this.getBounds(REGION.getCountries()));
    }

    public HeatMap getHeatMap() {
        return this.heatMap;
    }

    public void addSpots(Point ... SPOTS) {
        this.heatMap.addSpots(SPOTS);
    }

    public void addSpots(List<Point> SPOTS) {
        this.heatMap.addSpots(SPOTS);
    }

    public void addSpot(double X, double Y, double OFFSET_X, double OFFSET_Y, double RADIUS, OpacityDistribution OPACITY_GRADIENT) {
        this.heatMap.addSpot(X, Y, OFFSET_X, OFFSET_Y, RADIUS, OPACITY_GRADIENT);
    }

    public void addSpot(double X, double Y, Image EVENT_IMAGE, double OFFSET_X, double OFFSET_Y) {
        this.heatMap.addSpot(X, Y, EVENT_IMAGE, OFFSET_X, OFFSET_Y);
    }

    public void addSpot(double X, double Y) {
        this.heatMap.addSpot(X, Y);
    }

    public void clearHeatMap() {
        this.heatMap.clearHeatMap();
    }

    public ColorMapping getColorMapping() {
        return this.heatMap.getColorMapping();
    }

    public void setColorMapping(ColorMapping COLOR_MAPPING) {
        this.heatMap.setColorMapping(COLOR_MAPPING);
    }

    public boolean isFadeColors() {
        return this.heatMap.isFadeColors();
    }

    public void setFadeColors(boolean FADE_COLORS) {
        this.heatMap.setFadeColors(FADE_COLORS);
    }

    public double getSpotRadius() {
        return this.heatMap.getSpotRadius();
    }

    public void setSpotRadius(double RADIUS) {
        this.heatMap.setSpotRadius(RADIUS);
    }

    public double getHeatMapOpacity() {
        return this.heatMap.getOpacity();
    }

    public void setHeatMapOpacity(double OPACITY) {
        this.heatMap.setOpacity(this.clamp(0.0, 1.0, OPACITY));
    }

    public OpacityDistribution getOpacityDistribution() {
        return this.heatMap.getOpacityDistribution();
    }

    public void setOpacityDistribution(OpacityDistribution OPACITY_DISTRIBUTION) {
        this.heatMap.setOpacityDistribution(OPACITY_DISTRIBUTION);
    }

    public static double[] latLonToXY(double LATITUDE, double LONGITUDE) {
        double x = (LONGITUDE + 180.0) * 2.8027777777777776 + MAP_OFFSET_X;
        double y = 332.5 - 1009.0 * Math.log(Math.tan(0.7853981633974483 + Math.toRadians(LATITUDE) / 2.0)) / (Math.PI * 2) + MAP_OFFSET_Y;
        return new double[]{x, y};
    }

    private double[] getBounds(Country ... COUNTRIES) {
        return this.getBounds(Arrays.asList(COUNTRIES));
    }

    private double[] getBounds(List<Country> COUNTRIES) {
        double upperLeftX = 1009.0;
        double upperLeftY = 665.0;
        double lowerRightX = 0.0;
        double lowerRightY = 0.0;
        for (Country country : COUNTRIES) {
            List<CountryPath> paths = this.countryPaths.get(country.getName());
            for (int i = 0; i < paths.size(); ++i) {
                CountryPath path = paths.get(i);
                Bounds bounds = path.getLayoutBounds();
                upperLeftX = Math.min(bounds.getMinX(), upperLeftX);
                upperLeftY = Math.min(bounds.getMinY(), upperLeftY);
                lowerRightX = Math.max(bounds.getMaxX(), lowerRightX);
                lowerRightY = Math.max(bounds.getMaxY(), lowerRightY);
            }
        }
        return new double[]{upperLeftX, upperLeftY, lowerRightX, lowerRightY};
    }

    private void zoomToArea(double[] BOUNDS) {
        this.group.setTranslateX(0.0);
        this.group.setTranslateY(0.0);
        double areaWidth = BOUNDS[2] - BOUNDS[0];
        double areaHeight = BOUNDS[3] - BOUNDS[1];
        double areaCenterX = BOUNDS[0] + areaWidth * 0.5;
        double areaCenterY = BOUNDS[1] + areaHeight * 0.5;
        Orientation orientation = areaWidth < areaHeight ? Orientation.VERTICAL : Orientation.HORIZONTAL;
        double sf = 1.0;
        switch (orientation) {
            case VERTICAL: {
                sf = this.clamp(1.0, 10.0, 1.0 / (areaHeight / this.height));
                break;
            }
            case HORIZONTAL: {
                sf = this.clamp(1.0, 10.0, 1.0 / (areaWidth / this.width));
            }
        }
        this.setScaleFactor(sf);
        this.group.setTranslateX(this.width * 0.5 - areaCenterX);
        this.group.setTranslateY(this.height * 0.5 - areaCenterY);
    }

    private void setPivot(double X, double Y) {
        this.setTranslateX(this.getTranslateX() - X);
        this.setTranslateY(this.getTranslateY() - Y);
    }

    private void handleMouseEvent(MouseEvent EVENT, EventHandler<MouseEvent> HANDLER) {
        CountryPath COUNTRY_PATH = (CountryPath)((Object)EVENT.getSource());
        String COUNTRY_NAME = COUNTRY_PATH.getName();
        Country COUNTRY = Country.valueOf(COUNTRY_NAME);
        List<CountryPath> PATHS = this.countryPaths.get(COUNTRY_NAME);
        EventType TYPE = EVENT.getEventType();
        if (MouseEvent.MOUSE_ENTERED == TYPE) {
            if (this.isHoverEnabled()) {
                Color color = this.isSelectionEnabled() && COUNTRY.equals((Object)this.getSelectedCountry()) ? this.getSelectedColor() : this.getHoverColor();
                for (SVGPath sVGPath : PATHS) {
                    sVGPath.setFill((Paint)color);
                }
            }
        } else if (MouseEvent.MOUSE_PRESSED == TYPE) {
            if (this.isSelectionEnabled()) {
                Color color;
                if (null == this.getSelectedCountry()) {
                    this.setSelectedCountry(COUNTRY);
                    color = this.getSelectedColor();
                } else {
                    color = null == this.getSelectedCountry().getColor() ? this.getFillColor() : this.getSelectedCountry().getColor();
                }
                for (SVGPath sVGPath : this.countryPaths.get(this.getSelectedCountry().getName())) {
                    sVGPath.setFill((Paint)color);
                }
            } else if (this.isHoverEnabled()) {
                for (SVGPath sVGPath : PATHS) {
                    sVGPath.setFill((Paint)this.getPressedColor());
                }
            }
        } else if (MouseEvent.MOUSE_RELEASED == TYPE) {
            Color color;
            if (this.isSelectionEnabled()) {
                if (this.formerSelectedCountry == COUNTRY) {
                    this.setSelectedCountry(null);
                    color = null == COUNTRY.getColor() ? this.getFillColor() : COUNTRY.getColor();
                } else {
                    this.setSelectedCountry(COUNTRY);
                    color = this.getSelectedColor();
                }
                this.formerSelectedCountry = this.getSelectedCountry();
            } else {
                color = this.getHoverColor();
            }
            if (this.isHoverEnabled()) {
                for (SVGPath sVGPath : PATHS) {
                    sVGPath.setFill((Paint)color);
                }
            }
        } else if (MouseEvent.MOUSE_EXITED == TYPE && this.isHoverEnabled()) {
            Color color = this.isSelectionEnabled() && COUNTRY.equals((Object)this.getSelectedCountry()) ? this.getSelectedColor() : this.getFillColor();
            for (SVGPath sVGPath : PATHS) {
                sVGPath.setFill((Paint)(null == COUNTRY.getColor() || COUNTRY == this.getSelectedCountry() ? color : COUNTRY.getColor()));
            }
        }
        if (null != HANDLER) {
            HANDLER.handle((Event)EVENT);
        }
    }

    private void setFillAndStroke() {
        this.countryPaths.keySet().forEach(name -> {
            Country country;
            this.setCountryFillAndStroke(country, null == (country = Country.valueOf(name)).getColor() ? this.getFillColor() : country.getColor(), this.getStrokeColor());
        });
    }

    private void setCountryFillAndStroke(Country COUNTRY, Color FILL, Color STROKE) {
        List<CountryPath> paths = this.countryPaths.get(COUNTRY.getName());
        for (CountryPath path : paths) {
            path.setFill((Paint)FILL);
            path.setStroke((Paint)STROKE);
        }
    }

    private void addShapesToScene(Shape ... SHAPES) {
        this.addShapesToScene(Arrays.asList(SHAPES));
    }

    private void addShapesToScene(Collection<Shape> SHAPES) {
        if (null == this.getScene()) {
            return;
        }
        Platform.runLater(() -> this.pane.getChildren().addAll(SHAPES));
    }

    private double clamp(double MIN, double MAX, double VALUE) {
        if (VALUE < MIN) {
            return MIN;
        }
        if (VALUE > MAX) {
            return MAX;
        }
        return VALUE;
    }

    private Properties readProperties(String FILE_NAME) {
        ClassLoader LOADER = Thread.currentThread().getContextClassLoader();
        Properties PROPERTIES = new Properties();
        try (InputStream resourceStream = LOADER.getResourceAsStream(FILE_NAME);){
            PROPERTIES.load(resourceStream);
        }
        catch (IOException exception) {
            System.out.println(exception);
        }
        return PROPERTIES;
    }

    private Map<String, List<CountryPath>> createCountryPaths() {
        HashMap<String, List<CountryPath>> countryPaths = new HashMap<String, List<CountryPath>>();
        this.resolutionProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            String name = key.toString();
            ArrayList<CountryPath> pathList = new ArrayList<CountryPath>();
            for (String path : value.toString().split(";")) {
                pathList.add(new CountryPath(name, path));
            }
            countryPaths.put(name, pathList);
        }));
        return countryPaths;
    }

    public String getUserAgentStylesheet() {
        return World.class.getResource("world.css").toExternalForm();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return FACTORY.getCssMetaData();
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return FACTORY.getCssMetaData();
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        double d = this.size = this.width < this.height ? this.width : this.height;
        if (0.6590683845391476 * this.width > this.height) {
            this.width = 1.0 / (0.6590683845391476 / this.height);
        } else if (1.0 / (0.6590683845391476 / this.height) > this.width) {
            this.height = 0.6590683845391476 * this.width;
        }
        if (this.width > 0.0 && this.height > 0.0) {
            if (this.isZoomEnabled()) {
                this.resetZoom();
            }
            this.pane.setCache(true);
            this.pane.setCacheHint(CacheHint.SCALE);
            this.pane.setScaleX(this.width / 1009.0);
            this.pane.setScaleY(this.height / 665.0);
            this.group.resize(this.width, this.height);
            this.group.relocate((this.getWidth() - this.width) * 0.5, (this.getHeight() - this.height) * 0.5);
            this.heatMap.setScaleX(this.pane.getScaleX());
            this.heatMap.setScaleY(this.pane.getScaleY());
            this.heatMap.setTranslateX(this.group.getBoundsInParent().getMinX() - this.group.getLayoutBounds().getMinX());
            this.heatMap.setTranslateY(this.group.getBoundsInParent().getMinY() - this.group.getLayoutBounds().getMinY());
            this.pane.setCache(false);
        }
    }

    public static enum Resolution {
        HI_RES,
        LO_RES;

    }
}

