/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.geometry;

import eu.hansolo.fx.geometry.FlatteningPathIterator;
import eu.hansolo.fx.geometry.PathIterator;
import eu.hansolo.fx.geometry.RectBounds;
import eu.hansolo.fx.geometry.Shape;
import eu.hansolo.fx.geometry.tools.Point;
import eu.hansolo.fx.geometry.transform.BaseTransform;

public abstract class RectangularShape
extends Shape {
    protected RectangularShape() {
    }

    public abstract double getX();

    public abstract double getY();

    public abstract double getWidth();

    public abstract double getHeight();

    public double getMinX() {
        return this.getX();
    }

    public double getMinY() {
        return this.getY();
    }

    public double getMaxX() {
        return this.getX() + this.getWidth();
    }

    public double getMaxY() {
        return this.getY() + this.getHeight();
    }

    public double getCenterX() {
        return this.getX() + this.getWidth() / 2.0;
    }

    public double getCenterY() {
        return this.getY() + this.getHeight() / 2.0;
    }

    public abstract boolean isEmpty();

    public abstract void set(double var1, double var3, double var5, double var7);

    public void set(Point POINT, double WIDTH, double HEIGHT) {
        this.set(POINT.getX(), POINT.getY(), WIDTH, HEIGHT);
    }

    public void setFromDiagonal(Point p1, Point p2) {
        this.setFromDiagonal(p1.x, p1.y, p2.x, p2.y);
    }

    public void setFromDiagonal(double x1, double y1, double x2, double y2) {
        double t;
        if (x2 < x1) {
            t = x1;
            x1 = x2;
            x2 = t;
        }
        if (y2 < y1) {
            t = y1;
            y1 = y2;
            y2 = t;
        }
        this.set(x1, y1, x2 - x1, y2 - y1);
    }

    public void setFromCenter(Point CENTER, Point CORNER) {
        this.setFromCenter(CENTER.x, CENTER.y, CORNER.x, CORNER.y);
    }

    public void setFromCenter(double CENTER_X, double CENTER_Y, double CORNER_X, double CORNER_Y) {
        double halfW = Math.abs(CORNER_X - CENTER_X);
        double halfH = Math.abs(CORNER_Y - CENTER_Y);
        this.set(CENTER_X - halfW, CENTER_Y - halfH, halfW * 2.0, halfH * 2.0);
    }

    @Override
    public boolean contains(Point POINT) {
        return this.contains(POINT.x, POINT.y);
    }

    @Override
    public RectBounds getBounds() {
        double width = this.getWidth();
        double height = this.getHeight();
        if (width < 0.0 || height < 0.0) {
            return new RectBounds();
        }
        double x = this.getX();
        double y = this.getY();
        double x1 = Math.floor(x);
        double y1 = Math.floor(y);
        double x2 = Math.ceil(x + width);
        double y2 = Math.ceil(y + height);
        return new RectBounds(x1, y1, x2, y2);
    }

    @Override
    public PathIterator getPathIterator(BaseTransform TRANSFORM, double FLATNESS) {
        return new FlatteningPathIterator(this.getPathIterator(TRANSFORM), FLATNESS);
    }
}

