/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.geometry.tools;

public class Point
implements Comparable<Point> {
    public double x;
    public double y;

    public Point() {
        this(0.0, 0.0);
    }

    public Point(Point P) {
        this(P.getX(), P.getY());
    }

    public Point(double X, double Y) {
        this.x = X;
        this.y = Y;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double X) {
        this.x = X;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double Y) {
        this.y = Y;
    }

    public void set(Point POINT) {
        this.set(POINT.x, POINT.y);
    }

    public void set(double X, double Y) {
        this.x = X;
        this.y = Y;
    }

    public double distanceSquareTo(Point P) {
        return Point.distanceSquare(P.getX(), P.getY(), this.x, this.y);
    }

    public double distanceTo(Point P) {
        return Point.distance(P.getX(), P.getY(), this.x, this.y);
    }

    public double distanceTo(double X, double Y) {
        return Point.distance(X, Y, this.x, this.y);
    }

    public static double distance(Point P1, Point P2) {
        return Point.distance(P1.getX(), P1.getY(), P2.getX(), P2.getY());
    }

    public static double distance(double X1, double Y1, double X2, double Y2) {
        double deltaX = X2 - X1;
        double deltaY = Y2 - Y1;
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY);
    }

    public static double distanceSquare(Point P1, Point P2) {
        return Point.distanceSquare(P1.getX(), P1.getY(), P2.getX(), P2.getY());
    }

    public static double distanceSquare(double X1, double Y1, double X2, double Y2) {
        double deltaX = X2 - X1;
        double deltaY = Y2 - Y1;
        return deltaX * deltaX + deltaY * deltaY;
    }

    @Override
    public int compareTo(Point POINT) {
        return this.x != POINT.getX() ? Double.compare(this.x, POINT.x) : Double.compare(this.y, POINT.y);
    }

    public boolean equals(Object OBJECT) {
        if (OBJECT == this) {
            return true;
        }
        if (OBJECT instanceof Point) {
            Point p = (Point)OBJECT;
            return Double.compare(this.x, p.getX()) == 0 && Double.compare(this.y, p.getY()) == 0;
        }
        return false;
    }

    public String toString() {
        return "x: " + this.x + ", y: " + this.y;
    }
}

