/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.Axis;
import eu.hansolo.fx.charts.AxisType;
import eu.hansolo.fx.charts.Position;
import eu.hansolo.fx.charts.TickLabelOrientation;
import eu.hansolo.fx.charts.tools.TickLabelFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.layout.AnchorPane;
import javafx.scene.paint.Color;
import javafx.util.StringConverter;

public class AxisBuilder<B extends AxisBuilder<B>> {
    private HashMap<String, Property> properties = new LinkedHashMap<String, Property>();
    private Orientation orientation;
    private Position position;

    protected AxisBuilder(Orientation ORIENTATION, Position POSITION) {
        this.orientation = ORIENTATION;
        this.position = POSITION;
    }

    public static final AxisBuilder create(Orientation ORIENTATION, Position POSITION) {
        return new AxisBuilder(ORIENTATION, POSITION);
    }

    public final B minValue(double MIN_VALUE) {
        this.properties.put("minValue", (Property)new SimpleDoubleProperty(MIN_VALUE));
        return (B)this;
    }

    public final B maxValue(double MAX_VALUE) {
        this.properties.put("maxValue", (Property)new SimpleDoubleProperty(MAX_VALUE));
        return (B)this;
    }

    public final B setStart(long EPOCH_SECONDS) {
        if (0L > EPOCH_SECONDS) {
            throw new IllegalArgumentException("Epoch seconds cannot be smaller than 0");
        }
        this.properties.put("start", (Property)new SimpleObjectProperty((Object)LocalDateTime.ofInstant(Instant.ofEpochSecond(EPOCH_SECONDS), ZoneId.systemDefault())));
        return (B)this;
    }

    public final B setStart(long EPOCH_SECONDS, ZoneId ZONE_ID) {
        if (0L > EPOCH_SECONDS || null == ZONE_ID) {
            throw new IllegalArgumentException("Epoch seconds cannot be smaller than 0 and zone id cannot be null");
        }
        this.properties.put("start", (Property)new SimpleObjectProperty((Object)LocalDateTime.ofInstant(Instant.ofEpochSecond(EPOCH_SECONDS), ZONE_ID)));
        return (B)this;
    }

    public final B setStart(Instant INSTANT) {
        if (null == INSTANT) {
            throw new IllegalArgumentException("Instant cannot be null");
        }
        this.properties.put("start", (Property)new SimpleObjectProperty((Object)LocalDateTime.ofInstant(INSTANT, ZoneId.systemDefault())));
        return (B)this;
    }

    public final B setStart(Instant INSTANT, ZoneId ZONE_ID) {
        if (null == INSTANT || null == ZONE_ID) {
            throw new IllegalArgumentException("Instant or zone id cannot be null");
        }
        this.properties.put("start", (Property)new SimpleObjectProperty((Object)LocalDateTime.ofInstant(INSTANT, ZONE_ID)));
        return (B)this;
    }

    public final B start(LocalDateTime DATE_TIME) {
        this.properties.put("start", (Property)new SimpleObjectProperty((Object)DATE_TIME));
        return (B)this;
    }

    public final B setEnd(long EPOCH_SECONDS) {
        if (0L > EPOCH_SECONDS) {
            throw new IllegalArgumentException("Epoch seconds cannot be smaller than 0");
        }
        this.properties.put("end", (Property)new SimpleObjectProperty((Object)LocalDateTime.ofInstant(Instant.ofEpochSecond(EPOCH_SECONDS), ZoneId.systemDefault())));
        return (B)this;
    }

    public final B setEnd(long EPOCH_SECONDS, ZoneId ZONE_ID) {
        if (0L > EPOCH_SECONDS || null == ZONE_ID) {
            throw new IllegalArgumentException("Epoch seconds cannot be smaller than 0 and zone id cannot be null");
        }
        this.properties.put("end", (Property)new SimpleObjectProperty((Object)LocalDateTime.ofInstant(Instant.ofEpochSecond(EPOCH_SECONDS), ZONE_ID)));
        return (B)this;
    }

    public final B setEnd(Instant INSTANT) {
        if (null == INSTANT) {
            throw new IllegalArgumentException("Instant cannot be null");
        }
        this.properties.put("end", (Property)new SimpleObjectProperty((Object)LocalDateTime.ofInstant(INSTANT, ZoneId.systemDefault())));
        return (B)this;
    }

    public final B setEnd(Instant INSTANT, ZoneId ZONE_ID) {
        if (null == INSTANT || null == ZONE_ID) {
            throw new IllegalArgumentException("Instant or zone id cannot be null");
        }
        this.properties.put("end", (Property)new SimpleObjectProperty((Object)LocalDateTime.ofInstant(INSTANT, ZONE_ID)));
        return (B)this;
    }

    public final B end(LocalDateTime DATE_TIME) {
        this.properties.put("end", (Property)new SimpleObjectProperty((Object)DATE_TIME));
        return (B)this;
    }

    public final B autoScale(boolean AUTO) {
        this.properties.put("autoScale", (Property)new SimpleBooleanProperty(AUTO));
        return (B)this;
    }

    public final B title(String TITLE) {
        this.properties.put("title", (Property)new SimpleStringProperty(TITLE));
        return (B)this;
    }

    public final B unit(String UNIT) {
        this.properties.put("unit", (Property)new SimpleStringProperty(UNIT));
        return (B)this;
    }

    public final B type(AxisType TYPE) {
        this.properties.put("axisType", (Property)new SimpleObjectProperty((Object)TYPE));
        return (B)this;
    }

    public final B axisBackgroundColor(Color COLOR) {
        this.properties.put("axisBackgroundColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B axisColor(Color COLOR) {
        this.properties.put("axisColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B tickLabelColor(Color COLOR) {
        this.properties.put("tickLabelColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B titleColor(Color COLOR) {
        this.properties.put("titleColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B tickMarkColor(Color COLOR) {
        this.properties.put("tickMarkColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B minorTickMarkColor(Color COLOR) {
        this.properties.put("minorTickMarkColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B mediumTickMarkColor(Color COLOR) {
        this.properties.put("mediumTickMarkColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B majorTickMarkColor(Color COLOR) {
        this.properties.put("majorTickMarkColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B tickMarksVisible(boolean VISIBLE) {
        this.properties.put("tickMarksVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B minorTickMarksVisible(boolean VISIBLE) {
        this.properties.put("minorTickMarksVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B mediumTickMarksVisible(boolean VISIBLE) {
        this.properties.put("mediumTickMarksVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B majorTickMarksVisible(boolean VISIBLE) {
        this.properties.put("majorTickMarksVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B sameTickMarkLength(boolean SAME_LENGTH) {
        this.properties.put("sameTickMarkLength", (Property)new SimpleBooleanProperty(SAME_LENGTH));
        return (B)this;
    }

    public final B zeroColor(Color COLOR) {
        this.properties.put("zeroColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B minorTickSpace(double SPACE) {
        this.properties.put("minorTickSpace", (Property)new SimpleDoubleProperty(SPACE));
        return (B)this;
    }

    public final B majorTickSpace(double SPACE) {
        this.properties.put("majorTickSpace", (Property)new SimpleDoubleProperty(SPACE));
        return (B)this;
    }

    public final B tickLabelsVisible(boolean VISIBLE) {
        this.properties.put("tickLabelsVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B mediumTimeAxisTickLabelsVisible(boolean VISIBLE) {
        this.properties.put("mediumTimeAxisTickLabelsVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B onlyFirstAndLastTickLabelVisible(boolean VISIBLE) {
        this.properties.put("onlyFirstAndLastTickLabelVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B locale(Locale LOCALE) {
        this.properties.put("locale", (Property)new SimpleObjectProperty((Object)LOCALE));
        return (B)this;
    }

    public final B decimals(int DECIMALS) {
        this.properties.put("decimals", (Property)new SimpleIntegerProperty(DECIMALS));
        return (B)this;
    }

    public final B tickLabelOrientation(TickLabelOrientation ORIENTATION) {
        this.properties.put("tickLabelOrientation", (Property)new SimpleObjectProperty((Object)ORIENTATION));
        return (B)this;
    }

    public final B tickLabelFormat(TickLabelFormat FORMAT) {
        this.properties.put("tickLabelFormat", (Property)new SimpleObjectProperty((Object)FORMAT));
        return (B)this;
    }

    public final B autoTitleFontSize(boolean AUTO) {
        this.properties.put("autoTitleFontSize", (Property)new SimpleBooleanProperty(AUTO));
        return (B)this;
    }

    public final B autoFontSize(boolean AUTO) {
        this.properties.put("autoFontSize", (Property)new SimpleBooleanProperty(AUTO));
        return (B)this;
    }

    public final B tickLabelFontSize(double SIZE) {
        this.properties.put("tickLabelFontSize", (Property)new SimpleDoubleProperty(SIZE));
        return (B)this;
    }

    public final B titleFontSize(double SIZE) {
        this.properties.put("titleFontSize", (Property)new SimpleDoubleProperty(SIZE));
        return (B)this;
    }

    public final B zoneId(ZoneId ID) {
        this.properties.put("zoneId", (Property)new SimpleObjectProperty((Object)ID));
        return (B)this;
    }

    public final B dateTimeFormatPattern(String PATTERN) {
        this.properties.put("dateTimeFormatPattern", (Property)new SimpleStringProperty(PATTERN));
        return (B)this;
    }

    public final B numberFormatter(StringConverter<Number> FORMATTER) {
        this.properties.put("numberFormatter", (Property)new SimpleObjectProperty(FORMATTER));
        return (B)this;
    }

    public final B categories(String ... CATEGORIES) {
        this.properties.put("categoriesArray", (Property)new SimpleObjectProperty((Object)CATEGORIES));
        return (B)this;
    }

    public final B categories(List<String> CATEGORIES) {
        this.properties.put("categoriesList", (Property)new SimpleObjectProperty(CATEGORIES));
        return (B)this;
    }

    public final B prefSize(double WIDTH, double HEIGHT) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B minSize(double WIDTH, double HEIGHT) {
        this.properties.put("minSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B maxSize(double WIDTH, double HEIGHT) {
        this.properties.put("maxSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B prefWidth(double PREF_WIDTH) {
        this.properties.put("prefWidth", (Property)new SimpleDoubleProperty(PREF_WIDTH));
        return (B)this;
    }

    public final B prefHeight(double PREF_HEIGHT) {
        this.properties.put("prefHeight", (Property)new SimpleDoubleProperty(PREF_HEIGHT));
        return (B)this;
    }

    public final B minWidth(double MIN_WIDTH) {
        this.properties.put("minWidth", (Property)new SimpleDoubleProperty(MIN_WIDTH));
        return (B)this;
    }

    public final B minHeight(double MIN_HEIGHT) {
        this.properties.put("minHeight", (Property)new SimpleDoubleProperty(MIN_HEIGHT));
        return (B)this;
    }

    public final B maxWidth(double MAX_WIDTH) {
        this.properties.put("maxWidth", (Property)new SimpleDoubleProperty(MAX_WIDTH));
        return (B)this;
    }

    public final B maxHeight(double MAX_HEIGHT) {
        this.properties.put("maxHeight", (Property)new SimpleDoubleProperty(MAX_HEIGHT));
        return (B)this;
    }

    public final B scaleX(double SCALE_X) {
        this.properties.put("scaleX", (Property)new SimpleDoubleProperty(SCALE_X));
        return (B)this;
    }

    public final B scaleY(double SCALE_Y) {
        this.properties.put("scaleY", (Property)new SimpleDoubleProperty(SCALE_Y));
        return (B)this;
    }

    public final B layoutX(double LAYOUT_X) {
        this.properties.put("layoutX", (Property)new SimpleDoubleProperty(LAYOUT_X));
        return (B)this;
    }

    public final B layoutY(double LAYOUT_Y) {
        this.properties.put("layoutY", (Property)new SimpleDoubleProperty(LAYOUT_Y));
        return (B)this;
    }

    public final B translateX(double TRANSLATE_X) {
        this.properties.put("translateX", (Property)new SimpleDoubleProperty(TRANSLATE_X));
        return (B)this;
    }

    public final B translateY(double TRANSLATE_Y) {
        this.properties.put("translateY", (Property)new SimpleDoubleProperty(TRANSLATE_Y));
        return (B)this;
    }

    public final B padding(Insets INSETS) {
        this.properties.put("padding", (Property)new SimpleObjectProperty((Object)INSETS));
        return (B)this;
    }

    public final B topAnchor(double VALUE) {
        this.properties.put("topAnchor", (Property)new SimpleDoubleProperty(VALUE));
        return (B)this;
    }

    public final B rightAnchor(double VALUE) {
        this.properties.put("rightAnchor", (Property)new SimpleDoubleProperty(VALUE));
        return (B)this;
    }

    public final B bottomAnchor(double VALUE) {
        this.properties.put("bottomAnchor", (Property)new SimpleDoubleProperty(VALUE));
        return (B)this;
    }

    public final B leftAnchor(double VALUE) {
        this.properties.put("leftAnchor", (Property)new SimpleDoubleProperty(VALUE));
        return (B)this;
    }

    public final Axis build() {
        Axis axis = new Axis(this.orientation, this.position);
        if (this.properties.keySet().contains("categoriesArray")) {
            axis.setCategories((String[])((ObjectProperty)this.properties.get("categoriesArray")).get());
        }
        if (this.properties.keySet().contains("categoriesList")) {
            axis.setCategories((List)((ObjectProperty)this.properties.get("categoriesList")).get());
        }
        if (this.properties.keySet().contains("axisType")) {
            AxisType type = (AxisType)((Object)((ObjectProperty)this.properties.get("axisType")).get());
            axis.setType(type);
            if (AxisType.TIME == type) {
                LocalDateTime start = null;
                LocalDateTime end = null;
                if (this.properties.keySet().contains("start")) {
                    start = (LocalDateTime)((ObjectProperty)this.properties.get("start")).get();
                }
                if (this.properties.keySet().contains("end")) {
                    end = (LocalDateTime)((ObjectProperty)this.properties.get("end")).get();
                }
                if (null == start || null == end) {
                    throw new IllegalArgumentException("Start and end have to be defined for axis type TIME");
                }
                if (end.isBefore(start)) {
                    throw new IllegalArgumentException("End cannot be before start");
                }
                if (start.isAfter(end)) {
                    throw new IllegalArgumentException("Start cannot be after end");
                }
                axis.setStart(start);
                axis.setEnd(end);
            }
        }
        Iterator<String> iterator = this.properties.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = iterator.next()) {
                case "prefSize": {
                    Dimension2D dimPrefSize = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    axis.setPrefSize(dimPrefSize.getWidth(), dimPrefSize.getHeight());
                    break;
                }
                case "minSize": {
                    Dimension2D dimMinSize = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    axis.setMinSize(dimMinSize.getWidth(), dimMinSize.getHeight());
                    break;
                }
                case "maxSize": {
                    Dimension2D dimMaxSize = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    axis.setMaxSize(dimMaxSize.getWidth(), dimMaxSize.getHeight());
                    break;
                }
                case "prefWidth": {
                    axis.setPrefWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "prefHeight": {
                    axis.setPrefHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "minWidth": {
                    axis.setMinWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "minHeight": {
                    axis.setMinHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "maxWidth": {
                    axis.setMaxWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "maxHeight": {
                    axis.setMaxHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "scaleX": {
                    axis.setScaleX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "scaleY": {
                    axis.setScaleY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "layoutX": {
                    axis.setLayoutX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "layoutY": {
                    axis.setLayoutY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "translateX": {
                    axis.setTranslateX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "translateY": {
                    axis.setTranslateY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "padding": {
                    axis.setPadding((Insets)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "minValue": {
                    axis.setMinValue(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "maxValue": {
                    axis.setMaxValue(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "autoScale": {
                    axis.setAutoScale(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "title": {
                    axis.setTitle((String)((StringProperty)this.properties.get(key)).get());
                    break;
                }
                case "unit": {
                    axis.setUnit((String)((StringProperty)this.properties.get(key)).get());
                    break;
                }
                case "axisBackgroundColor": {
                    axis.setAxisBackgroundColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "axisColor": {
                    axis.setAxisColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "tickLabelColor": {
                    axis.setTickLabelColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "titleColor": {
                    axis.setTitleColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "tickMarkColor": {
                    axis.setTickMarkColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "minorTickMarkColor": {
                    axis.setMinorTickMarkColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "mediumTickMarkColor": {
                    axis.setMediumTickMarkColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "majorTickMarkColor": {
                    axis.setMajorTickMarkColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "tickMarksVisible": {
                    axis.setTickMarksVisible(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "minorTickMarksVisible": {
                    axis.setMinorTickMarksVisible(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "mediumTickMarksVisible": {
                    axis.setMediumTickMarksVisible(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "majorTickMarksVisible": {
                    axis.setMajorTickMarksVisible(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "sameTickMarkLength": {
                    axis.setSameTickMarkLength(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "zeroColor": {
                    axis.setZeroColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "minorTickSpace": {
                    axis.setMinorTickSpace(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "majorTickSpace": {
                    axis.setMajorTickSpace(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "tickLabelsVisible": {
                    axis.setTickLabelsVisible(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "mediumTimeAxisTickLabelsVisible": {
                    axis.setMediumTimeAxisTickLabelsVisible(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "onlyFirstAndLastTickLabel": {
                    axis.setOnlyFirstAndLastTickLabelVisible(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "local": {
                    axis.setLocale((Locale)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "decimals": {
                    axis.setDecimals(((IntegerProperty)this.properties.get(key)).get());
                    break;
                }
                case "tickLabelOrientation": {
                    axis.setTickLabelOrientation((TickLabelOrientation)((Object)((ObjectProperty)this.properties.get(key)).get()));
                    break;
                }
                case "tickLabelFormat": {
                    axis.setTickLabelFormat((TickLabelFormat)((Object)((ObjectProperty)this.properties.get(key)).get()));
                    break;
                }
                case "autoTitleFontSize": {
                    axis.setAutoTitleFontSize(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "autoFontSize": {
                    axis.setAutoFontSize(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "tickLabelFontSize": {
                    axis.setTickLabelFontSize(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "titleFontSize": {
                    axis.setTitleFontSize(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "zoneId": {
                    axis.setZoneId((ZoneId)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "dateTimeFormatPattern": {
                    axis.setDateTimeFormatPattern((String)((StringProperty)this.properties.get(key)).get());
                    break;
                }
                case "numberFormatter": {
                    axis.setNumberFormatter((StringConverter<Number>)((StringConverter)((ObjectProperty)this.properties.get(key)).get()));
                    break;
                }
                case "topAnchor": {
                    AnchorPane.setTopAnchor((Node)axis, (Double)((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "rightAnchor": {
                    AnchorPane.setRightAnchor((Node)axis, (Double)((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "bottomAnchor": {
                    AnchorPane.setBottomAnchor((Node)axis, (Double)((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "leftAnchor": {
                    AnchorPane.setLeftAnchor((Node)axis, (Double)((DoubleProperty)this.properties.get(key)).get());
                }
            }
        }
        return axis;
    }
}

