/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.BoxPlot;
import eu.hansolo.fx.charts.data.ChartItem;
import eu.hansolo.fx.charts.series.ChartItemSeries;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.scene.paint.Color;

public class BoxPlotBuilder<B extends BoxPlotBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected BoxPlotBuilder() {
    }

    public static final BoxPlotBuilder create() {
        return new BoxPlotBuilder();
    }

    public final B name(String NAME) {
        this.properties.put("name", (Property)new SimpleStringProperty(NAME));
        return (B)this;
    }

    public final B items(ChartItemSeries<? extends ChartItem> SERIES) {
        this.properties.put("series", (Property)new SimpleObjectProperty(SERIES));
        return (B)this;
    }

    public final B items(ChartItem ... ITEMS) {
        this.properties.put("itemsArray", (Property)new SimpleObjectProperty((Object)ITEMS));
        return (B)this;
    }

    public final B items(List<ChartItem> ITEMS) {
        this.properties.put("itemsList", (Property)new SimpleObjectProperty(ITEMS));
        return (B)this;
    }

    public final B decimals(int DECIMALS) {
        this.properties.put("decimals", (Property)new SimpleIntegerProperty(DECIMALS));
        return (B)this;
    }

    public final B locale(Locale LOCALE) {
        this.properties.put("locale", (Property)new SimpleObjectProperty((Object)LOCALE));
        return (B)this;
    }

    public final B backgroundColor(Color BACKGROUND_COLOR) {
        this.properties.put("backgroundColor", (Property)new SimpleObjectProperty((Object)BACKGROUND_COLOR));
        return (B)this;
    }

    public final B whiskerStrokeColor(Color WHISKER_STROKE_COLOR) {
        this.properties.put("whiskerStrokeColor", (Property)new SimpleObjectProperty((Object)WHISKER_STROKE_COLOR));
        return (B)this;
    }

    public final B iqrFillColor(Color IQR_FILL_COLOR) {
        this.properties.put("iqrFillColor", (Property)new SimpleObjectProperty((Object)IQR_FILL_COLOR));
        return (B)this;
    }

    public final B iqrStrokeColor(Color IQR_STROKE_COLOR) {
        this.properties.put("iqrStrokeColor", (Property)new SimpleObjectProperty((Object)IQR_STROKE_COLOR));
        return (B)this;
    }

    public final B medianStrokeColor(Color MEDIAN_STROKE_COLOR) {
        this.properties.put("medianStrokeColor", (Property)new SimpleObjectProperty((Object)MEDIAN_STROKE_COLOR));
        return (B)this;
    }

    public final B outlierFillColor(Color OUTLIER_FILL_COLOR) {
        this.properties.put("outlierFillColor", (Property)new SimpleObjectProperty((Object)OUTLIER_FILL_COLOR));
        return (B)this;
    }

    public final B outlierStrokeColor(Color OUTLIER_STROKE_COLOR) {
        this.properties.put("outlierStrokeColor", (Property)new SimpleObjectProperty((Object)OUTLIER_STROKE_COLOR));
        return (B)this;
    }

    public final B nameVisible(boolean NAME_VISIBLE) {
        this.properties.put("nameVisible", (Property)new SimpleBooleanProperty(NAME_VISIBLE));
        return (B)this;
    }

    public final B textFillColor(Color TEXT_FILL_COLOR) {
        this.properties.put("textFillColor", (Property)new SimpleObjectProperty((Object)TEXT_FILL_COLOR));
        return (B)this;
    }

    public final B popupTimeout(long POPUP_TIMEOUT) {
        this.properties.put("popupTimeout", (Property)new SimpleLongProperty(POPUP_TIMEOUT));
        return (B)this;
    }

    public final B prefSize(double WIDTH, double HEIGHT) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B minSize(double WIDTH, double HEIGHT) {
        this.properties.put("minSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B maxSize(double WIDTH, double HEIGHT) {
        this.properties.put("maxSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B prefWidth(double PREF_WIDTH) {
        this.properties.put("prefWidth", (Property)new SimpleDoubleProperty(PREF_WIDTH));
        return (B)this;
    }

    public final B prefHeight(double PREF_HEIGHT) {
        this.properties.put("prefHeight", (Property)new SimpleDoubleProperty(PREF_HEIGHT));
        return (B)this;
    }

    public final B minWidth(double MIN_WIDTH) {
        this.properties.put("minWidth", (Property)new SimpleDoubleProperty(MIN_WIDTH));
        return (B)this;
    }

    public final B minHeight(double MIN_HEIGHT) {
        this.properties.put("minHeight", (Property)new SimpleDoubleProperty(MIN_HEIGHT));
        return (B)this;
    }

    public final B maxWidth(double MAX_WIDTH) {
        this.properties.put("maxWidth", (Property)new SimpleDoubleProperty(MAX_WIDTH));
        return (B)this;
    }

    public final B maxHeight(double MAX_HEIGHT) {
        this.properties.put("maxHeight", (Property)new SimpleDoubleProperty(MAX_HEIGHT));
        return (B)this;
    }

    public final B scaleX(double SCALE_X) {
        this.properties.put("scaleX", (Property)new SimpleDoubleProperty(SCALE_X));
        return (B)this;
    }

    public final B scaleY(double SCALE_Y) {
        this.properties.put("scaleY", (Property)new SimpleDoubleProperty(SCALE_Y));
        return (B)this;
    }

    public final B layoutX(double LAYOUT_X) {
        this.properties.put("layoutX", (Property)new SimpleDoubleProperty(LAYOUT_X));
        return (B)this;
    }

    public final B layoutY(double LAYOUT_Y) {
        this.properties.put("layoutY", (Property)new SimpleDoubleProperty(LAYOUT_Y));
        return (B)this;
    }

    public final B translateX(double TRANSLATE_X) {
        this.properties.put("translateX", (Property)new SimpleDoubleProperty(TRANSLATE_X));
        return (B)this;
    }

    public final B translateY(double TRANSLATE_Y) {
        this.properties.put("translateY", (Property)new SimpleDoubleProperty(TRANSLATE_Y));
        return (B)this;
    }

    public final B padding(Insets INSETS) {
        this.properties.put("padding", (Property)new SimpleObjectProperty((Object)INSETS));
        return (B)this;
    }

    public final BoxPlot build() {
        BoxPlot boxPlot = new BoxPlot();
        if (this.properties.keySet().contains("series")) {
            ChartItemSeries series = (ChartItemSeries)((ObjectProperty)this.properties.get("series")).get();
            boxPlot.setItems(series.getItems());
            boxPlot.setName(series.getName());
        } else if (this.properties.keySet().contains("itemsArray")) {
            boxPlot.setItems((ChartItem[])((ObjectProperty)this.properties.get("itemsArray")).get());
        } else if (this.properties.keySet().contains("itemsList")) {
            boxPlot.setItems((List)((ObjectProperty)this.properties.get("itemsList")).get());
        }
        Iterator<String> iterator = this.properties.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = iterator.next()) {
                case "prefSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    boxPlot.setPrefSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "minSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    boxPlot.setMinSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "maxSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    boxPlot.setMaxSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "prefWidth": {
                    boxPlot.setPrefWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "prefHeight": {
                    boxPlot.setPrefHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "minWidth": {
                    boxPlot.setMinWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "minHeight": {
                    boxPlot.setMinHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "maxWidth": {
                    boxPlot.setMaxWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "maxHeight": {
                    boxPlot.setMaxHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "scaleX": {
                    boxPlot.setScaleX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "scaleY": {
                    boxPlot.setScaleY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "layoutX": {
                    boxPlot.setLayoutX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "layoutY": {
                    boxPlot.setLayoutY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "translateX": {
                    boxPlot.setTranslateX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "translateY": {
                    boxPlot.setTranslateY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "padding": {
                    boxPlot.setPadding((Insets)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "decimals": {
                    boxPlot.setDecimals(((IntegerProperty)this.properties.get(key)).get());
                    break;
                }
                case "locale": {
                    boxPlot.setLocale((Locale)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "name": {
                    boxPlot.setName((String)((StringProperty)this.properties.get(key)).get());
                    break;
                }
                case "backgroundColor": {
                    boxPlot.setBackgroundColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "whiskerStrokeColor": {
                    boxPlot.setWhiskerStrokeColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "iqrFillColor": {
                    boxPlot.setIqrFillColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "iqrStrokeColor": {
                    boxPlot.setIqrStrokeColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "medianStrokeColor": {
                    boxPlot.setMedianStrokeColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "outlierFillColor": {
                    boxPlot.setOutlierFillColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "outlierStrokeColor": {
                    boxPlot.setOutlierStrokeColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "nameVisible": {
                    boxPlot.setNameVisible(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "textFillColor": {
                    boxPlot.setTextFillColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "popupTimeout": {
                    boxPlot.setPopupTimeout(((LongProperty)this.properties.get(key)).get());
                }
            }
        }
        return boxPlot;
    }
}

