/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.data.ChartItem;
import eu.hansolo.fx.charts.event.ChartEvt;
import eu.hansolo.fx.charts.tools.Helper;
import eu.hansolo.fx.charts.tools.TooltipPopup;
import eu.hansolo.fx.geometry.Circle;
import eu.hansolo.toolbox.evt.EvtObserver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javafx.animation.AnimationTimer;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class BubbleChart<T extends ChartItem>
extends Region {
    public static final Color DEFAULT_BACKGROUND_COLOR = Color.TRANSPARENT;
    private static final double PREFERRED_WIDTH = 400.0;
    private static final double PREFERRED_HEIGHT = 400.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 2048.0;
    private static final double MAXIMUM_HEIGHT = 2048.0;
    private double width;
    private double height;
    private double chartCenterX;
    private double chartCenterY;
    private Canvas canvas;
    private GraphicsContext ctx;
    private Color _backgroundColor;
    private ObjectProperty<Color> backgroundColor;
    private TooltipPopup popup;
    private ObservableList<T> items = FXCollections.observableArrayList();
    private EvtObserver<ChartEvt> itemObserver = e -> this.redraw();
    private ListChangeListener<T> itemListListener = c -> {
        while (c.next()) {
            if (c.wasAdded()) {
                c.getAddedSubList().forEach(addedItem -> addedItem.addChartEvtObserver(ChartEvt.ITEM_UPDATE, this.itemObserver));
                continue;
            }
            if (!c.wasRemoved()) continue;
            c.getRemoved().forEach(removedItem -> removedItem.removeChartEvtObserver(ChartEvt.ITEM_UPDATE, this.itemObserver));
        }
        this.max = this.items.stream().max(Comparator.comparingDouble(ChartItem::getValue)).get().getValue();
    };
    private List<BubbleNode> nodes = new ArrayList<BubbleNode>();
    private double max;
    private long lastTimerCall;
    private AnimationTimer timer;

    public BubbleChart() {
        this(new ArrayList());
    }

    public BubbleChart(List<T> ITEMS) {
        this._backgroundColor = DEFAULT_BACKGROUND_COLOR;
        this.popup = new TooltipPopup("", 3500L, true);
        this.items.setAll((Collection)(null == ITEMS ? new ArrayList() : ITEMS));
        this.items.forEach(item -> this.nodes.add(new BubbleNode(this, item)));
        this.lastTimerCall = System.nanoTime();
        this.timer = new AnimationTimer(){

            public void handle(long now) {
                if (now > BubbleChart.this.lastTimerCall + 100000000L) {
                    BubbleChart.this.update();
                    BubbleChart.this.lastTimerCall = now;
                }
            }
        };
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(400.0, 400.0);
            }
        }
        this.canvas = new Canvas(400.0, 400.0);
        this.ctx = this.canvas.getGraphicsContext2D();
        this.getChildren().setAll((Object[])new Node[]{this.canvas});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
        this.items.addListener(this.itemListListener);
        this.canvas.setOnMousePressed(e -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.IndexOutOfBoundsException: Index -1 out of bounds for length 0
             *     at java.base/jdk.internal.util.Preconditions.outOfBounds(Preconditions.java:100)
             *     at java.base/jdk.internal.util.Preconditions.outOfBoundsCheckIndex(Preconditions.java:106)
             *     at java.base/jdk.internal.util.Preconditions.checkIndex(Preconditions.java:302)
             *     at java.base/java.util.Objects.checkIndex(Objects.java:385)
             *     at java.base/java.util.ArrayList.get(ArrayList.java:427)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.StringBuilderRewriter.genStringConcat(StringBuilderRewriter.java:193)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.StringBuilderRewriter.testAppendChain(StringBuilderRewriter.java:180)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.StringBuilderRewriter.rewriteExpression(StringBuilderRewriter.java:43)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:786)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    public void layoutChildren() {
        super.layoutChildren();
    }

    protected double computeMinWidth(double HEIGHT) {
        return 50.0;
    }

    protected double computeMinHeight(double WIDTH) {
        return 50.0;
    }

    protected double computePrefWidth(double HEIGHT) {
        return super.computePrefWidth(HEIGHT);
    }

    protected double computePrefHeight(double WIDTH) {
        return super.computePrefHeight(WIDTH);
    }

    protected double computeMaxWidth(double HEIGHT) {
        return 2048.0;
    }

    protected double computeMaxHeight(double WIDTH) {
        return 2048.0;
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public void dispose() {
        this.items.removeListener(this.itemListListener);
    }

    public List<T> getItems() {
        return this.items;
    }

    public void setItems(T ... ITEMS) {
        this.setItems(Arrays.asList(ITEMS));
    }

    public void setItems(List<T> ITEMS) {
        this.items.setAll(ITEMS);
    }

    public void addItem(T ITEM) {
        if (!this.items.contains(ITEM)) {
            this.items.add(ITEM);
        }
    }

    public void removeItem(T ITEM) {
        if (this.items.contains(ITEM)) {
            this.items.remove(ITEM);
        }
    }

    public Color getBackgroundColor() {
        return null == this.backgroundColor ? this._backgroundColor : (Color)this.backgroundColor.get();
    }

    public void setBackgroundColor(Color backgroundColor) {
        if (null == this.backgroundColor) {
            this._backgroundColor = backgroundColor;
            this.redraw();
        } else {
            this.backgroundColor.set((Object)backgroundColor);
        }
    }

    public ObjectProperty<Color> backgroundColorProperty() {
        if (null == this.backgroundColor) {
            this.backgroundColor = new ObjectPropertyBase<Color>(this._backgroundColor){

                protected void invalidated() {
                    BubbleChart.this.redraw();
                }

                public Object getBean() {
                    return BubbleChart.this;
                }

                public String getName() {
                    return "backgroundColor";
                }
            };
            this._backgroundColor = null;
        }
        return this.backgroundColor;
    }

    public void setPopupTimeout(long milliseconds) {
        this.popup.setTimeout(milliseconds);
    }

    public void start() {
        this.timer.start();
    }

    public void stop() {
        this.timer.stop();
    }

    private void update() {
        this.nodes.forEach(node -> {
            double distanceToCenter = node.distanceToCenter();
            if (distanceToCenter > node.getRadius() * 0.5) {
                double force = node.force();
                double[] xy = node.stepToCenter(force);
                node.setCenter(xy[0], xy[1]);
            }
        });
        this.redraw();
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        this.chartCenterX = this.width * 0.5;
        this.chartCenterY = this.height * 0.5;
        if (this.width > 0.0 && this.height > 0.0) {
            this.canvas.setWidth(this.width);
            this.canvas.setHeight(this.height);
            this.canvas.relocate((this.getWidth() - this.width) * 0.5, (this.getHeight() - this.height) * 0.5);
            this.ctx.setTextBaseline(VPos.CENTER);
        }
        this.redraw();
    }

    private void redraw() {
        this.ctx.clearRect(0.0, 0.0, this.width, this.height);
        this.ctx.setFill((Paint)this.getBackgroundColor());
        this.ctx.fillRect(0.0, 0.0, this.width, this.height);
        if (this.items.isEmpty()) {
            return;
        }
        double min = this.items.stream().min(Comparator.comparingDouble(ChartItem::getValue)).get().getValue();
        double max = this.items.stream().max(Comparator.comparingDouble(ChartItem::getValue)).get().getValue();
        double maxRadius = 50.0;
        double range = max - min;
        double scaleFactor = maxRadius / range;
        this.nodes.forEach(node -> {
            node.setScaleFactor(scaleFactor);
            this.ctx.setFill((Paint)node.getFill());
            this.ctx.fillOval(node.getX(), node.getY(), node.getWidth(), node.getHeight());
        });
    }

    public static class BubbleNode {
        private ChartItem item;
        private Circle circle;
        private double scaleFactor;
        final /* synthetic */ BubbleChart this$0;

        public BubbleNode(T item) {
            this.this$0 = this$0;
            this.item = item;
            this.circle = new Circle(0.0, 0.0, ((ChartItem)item).getValue());
            this.scaleFactor = 1.0;
        }

        public double getValue() {
            return this.item.getValue();
        }

        public Circle getCircle() {
            return this.circle;
        }

        public double getX() {
            return this.circle.getX();
        }

        public double getY() {
            return this.circle.getY();
        }

        public double getWidth() {
            return this.circle.getWidth();
        }

        public double getHeight() {
            return this.circle.getHeight();
        }

        public double getRadius() {
            return this.circle.getRadius();
        }

        public double getCenterX() {
            return this.circle.getCenterX();
        }

        public void setCenterX(double centerX) {
            this.circle.setCenterX(centerX);
        }

        public void setCenter(double centerX, double centerY) {
            this.circle.setCenter(centerX, centerY);
        }

        public double getCenterY() {
            return this.circle.getCenterY();
        }

        public void setCenterY(double centerY) {
            this.circle.setCenterY(centerY);
        }

        public Color getFill() {
            return this.item.getFill();
        }

        public void setFill(Color fill) {
            this.item.setFill(fill);
        }

        public boolean contains(double x, double y) {
            return this.circle.contains(x, y);
        }

        public boolean intersects(BubbleNode other) {
            double d = Math.sqrt((this.getCenterX() - other.getCenterX()) * (this.getCenterX() - other.getCenterX()) + (this.getCenterY() - other.getCenterY()) * (this.getCenterY() - other.getCenterY()));
            return d <= this.circle.getRadius() - other.getRadius() || d <= other.getRadius() - this.circle.getRadius() || d < this.circle.getRadius() + other.getRadius() || d == this.circle.getRadius() + other.getRadius();
        }

        public double distanceTo(BubbleNode other) {
            return Helper.distance(this.getCenterX(), this.getCenterY(), other.getCenterX(), other.getCenterY());
        }

        public double distanceToCenter() {
            return Helper.distance(this.getCenterX(), this.getCenterY(), this.this$0.chartCenterX, this.this$0.chartCenterY);
        }

        public double[] stepToCenter(double step) {
            double x = this.getCenterX() + step / this.distanceToCenter() * (this.this$0.chartCenterX - this.getCenterX());
            double y = this.getCenterY() + step / this.distanceToCenter() * (this.this$0.chartCenterY - this.getCenterY());
            return new double[]{x, y};
        }

        public double getScaleFactor() {
            return this.scaleFactor;
        }

        public void setScaleFactor(double scaleFactor) {
            this.scaleFactor = scaleFactor;
            this.circle.setRadius(this.item.getValue() * scaleFactor);
        }

        public double force() {
            double g = 6.67E-11;
            double distance = this.distanceToCenter() * 1000.0;
            double f = g * this.getValue() / (distance * distance);
            return f;
        }
    }
}

