/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.Axis;
import eu.hansolo.fx.charts.AxisType;
import eu.hansolo.fx.charts.event.ChartEvt;
import eu.hansolo.fx.charts.tools.Helper;
import eu.hansolo.toolbox.evt.EvtObserver;
import java.math.BigDecimal;
import java.math.RoundingMode;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Paint;

@DefaultProperty(value="children")
public class Grid
extends Region {
    private static final double PREFERRED_WIDTH = 250.0;
    private static final double PREFERRED_HEIGHT = 250.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 4096.0;
    private static final double MAXIMUM_HEIGHT = 4096.0;
    private static final double MIN_MAJOR_LINE_WIDTH = 1.0;
    private static final double MIN_MEDIUM_LINE_WIDTH = 0.75;
    private static final double MIN_MINOR_LINE_WIDTH = 0.5;
    private double size;
    private double width;
    private double height;
    private Axis xAxis;
    private Axis yAxis;
    private double _gridOpacity;
    private DoubleProperty gridOpacity;
    private Paint _majorHGridLinePaint;
    private ObjectProperty<Paint> majorHGridLinePaint;
    private Paint _mediumHGridLinePaint;
    private ObjectProperty<Paint> mediumHGridLinePaint;
    private Paint _minorHGridLinePaint;
    private ObjectProperty<Paint> minorHGridLinePaint;
    private boolean _majorHGridLinesVisible;
    private BooleanProperty majorHGridLinesVisible;
    private boolean _mediumHGridLinesVisible;
    private BooleanProperty mediumHGridLinesVisible;
    private boolean _minorHGridLinesVisible;
    private BooleanProperty minorHGridLinesVisible;
    private Paint _majorVGridLinePaint;
    private ObjectProperty<Paint> majorVGridLinePaint;
    private Paint _mediumVGridLinePaint;
    private ObjectProperty<Paint> mediumVGridLinePaint;
    private Paint _minorVGridLinePaint;
    private ObjectProperty<Paint> minorVGridLinePaint;
    private boolean _majorVGridLinesVisible;
    private BooleanProperty majorVGridLinesVisible;
    private boolean _mediumVGridLinesVisible;
    private BooleanProperty mediumVGridLinesVisible;
    private boolean _minorVGridLinesVisible;
    private BooleanProperty minorVGridLinesVisible;
    private double[] dashes;
    private Canvas canvas;
    private GraphicsContext ctx;
    private Pane pane;

    public Grid(Axis X_AXIS, Axis Y_AXIS) {
        if (null == X_AXIS || null == Y_AXIS) {
            throw new IllegalArgumentException("Axis cannot be null");
        }
        this.xAxis = X_AXIS;
        this.yAxis = Y_AXIS;
        this._gridOpacity = 0.25;
        this._majorHGridLinePaint = null;
        this._mediumHGridLinePaint = null;
        this._minorHGridLinePaint = null;
        this._majorHGridLinesVisible = true;
        this._mediumHGridLinesVisible = true;
        this._minorHGridLinesVisible = true;
        this._majorVGridLinePaint = null;
        this._mediumVGridLinePaint = null;
        this._minorVGridLinePaint = null;
        this._majorVGridLinesVisible = true;
        this._mediumVGridLinesVisible = true;
        this._minorVGridLinesVisible = true;
        this.dashes = new double[]{1.0};
        this.setMouseTransparent(true);
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(250.0, 250.0);
            }
        }
        this.canvas = new Canvas(250.0, 250.0);
        this.ctx = this.canvas.getGraphicsContext2D();
        this.pane = new Pane(new Node[]{this.canvas});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
        this.xAxis.addChartEvtObserver(ChartEvt.AXIS_RANGE_CHANGED, (EvtObserver<ChartEvt>)((EvtObserver)e -> this.drawGrid()));
        this.yAxis.addChartEvtObserver(ChartEvt.AXIS_RANGE_CHANGED, (EvtObserver<ChartEvt>)((EvtObserver)e -> this.drawGrid()));
    }

    protected double computeMinWidth(double HEIGHT) {
        return 50.0;
    }

    protected double computeMinHeight(double WIDTH) {
        return 50.0;
    }

    protected double computePrefWidth(double HEIGHT) {
        return super.computePrefWidth(HEIGHT);
    }

    protected double computePrefHeight(double WIDTH) {
        return super.computePrefHeight(WIDTH);
    }

    protected double computeMaxWidth(double HEIGHT) {
        return 4096.0;
    }

    protected double computeMaxHeight(double WIDTH) {
        return 4096.0;
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public double getGridOpacity() {
        return null == this.gridOpacity ? this._gridOpacity : this.gridOpacity.get();
    }

    public void setGridOpacity(double OPACITY) {
        if (null == this.gridOpacity) {
            this._gridOpacity = Helper.clamp(0.0, 1.0, OPACITY);
            this.drawGrid();
        } else {
            this.gridOpacity.set(OPACITY);
        }
    }

    public DoubleProperty gridOpacityProperty() {
        if (null == this.gridOpacity) {
            this.gridOpacity = new DoublePropertyBase(this._gridOpacity){

                protected void invalidated() {
                    Grid.this.drawGrid();
                }

                public Object getBean() {
                    return Grid.this;
                }

                public String getName() {
                    return "gridOpacity";
                }
            };
        }
        return this.gridOpacity;
    }

    public Paint getMajorHGridLinePaint() {
        return null == this.majorHGridLinePaint ? this._majorHGridLinePaint : (Paint)this.majorHGridLinePaint.get();
    }

    public void setMajorHGridLinePaint(Paint PAINT) {
        if (null == this.majorHGridLinePaint) {
            this._majorHGridLinePaint = PAINT;
            this.drawGrid();
        } else {
            this.majorHGridLinePaint.set((Object)PAINT);
        }
    }

    public ObjectProperty<Paint> majorHGridLinePaintProperty() {
        if (null == this.majorHGridLinePaint) {
            this.majorHGridLinePaint = new ObjectPropertyBase<Paint>(this._majorHGridLinePaint){

                protected void invalidated() {
                    Grid.this.drawGrid();
                }

                public Object getBean() {
                    return Grid.this;
                }

                public String getName() {
                    return "majorHGridLinePaint";
                }
            };
            this._majorHGridLinePaint = null;
        }
        return this.majorHGridLinePaint;
    }

    public Paint getMediumHGridLinePaint() {
        return null == this.mediumHGridLinePaint ? this._mediumHGridLinePaint : (Paint)this.mediumHGridLinePaint.get();
    }

    public void setMediumHGridLinePaint(Paint PAINT) {
        if (null == this.mediumHGridLinePaint) {
            this._mediumHGridLinePaint = PAINT;
            this.drawGrid();
        } else {
            this.mediumHGridLinePaint.set((Object)PAINT);
        }
    }

    public ObjectProperty<Paint> mediumHGridLinePaintProperty() {
        if (null == this.mediumHGridLinePaint) {
            this.mediumHGridLinePaint = new ObjectPropertyBase<Paint>(this._mediumHGridLinePaint){

                protected void invalidated() {
                    Grid.this.drawGrid();
                }

                public Object getBean() {
                    return Grid.this;
                }

                public String getName() {
                    return "mediumHGridLinePaint";
                }
            };
            this._mediumHGridLinePaint = null;
        }
        return this.mediumHGridLinePaint;
    }

    public Paint getMinorHGridLinePaint() {
        return null == this.minorHGridLinePaint ? this._minorHGridLinePaint : (Paint)this.minorHGridLinePaint.get();
    }

    public void setMinorHGridLinePaint(Paint PAINT) {
        if (null == this.minorHGridLinePaint) {
            this._minorHGridLinePaint = PAINT;
            this.drawGrid();
        } else {
            this.minorHGridLinePaint.set((Object)PAINT);
        }
    }

    public ObjectProperty<Paint> minorHGridLinePaintProperty() {
        if (null == this.minorHGridLinePaint) {
            this.minorHGridLinePaint = new ObjectPropertyBase<Paint>(this._minorHGridLinePaint){

                protected void invalidated() {
                    Grid.this.drawGrid();
                }

                public Object getBean() {
                    return Grid.this;
                }

                public String getName() {
                    return "minorHGridLinePaint";
                }
            };
            this._minorHGridLinePaint = null;
        }
        return this.minorHGridLinePaint;
    }

    public boolean getMajorHGridLinesVisible() {
        return null == this.majorHGridLinesVisible ? this._majorHGridLinesVisible : this.majorHGridLinesVisible.get();
    }

    public void setMajorHGridLinesVisible(boolean VISIBLE) {
        if (null == this.majorHGridLinesVisible) {
            this._majorHGridLinesVisible = VISIBLE;
            this.drawGrid();
        } else {
            this.majorHGridLinesVisible.set(VISIBLE);
        }
    }

    public BooleanProperty majorHGridLinesVisibleProperty() {
        if (null == this.majorHGridLinesVisible) {
            this.majorHGridLinesVisible = new BooleanPropertyBase(this._majorHGridLinesVisible){

                protected void invalidated() {
                    Grid.this.drawGrid();
                }

                public Object getBean() {
                    return Grid.this;
                }

                public String getName() {
                    return "majorHGridLinesVisible";
                }
            };
        }
        return this.majorHGridLinesVisible;
    }

    public boolean getMediumHGridLinesVisible() {
        return null == this.mediumHGridLinesVisible ? this._mediumHGridLinesVisible : this.mediumHGridLinesVisible.get();
    }

    public void setMediumHGridLinesVisible(boolean VISIBLE) {
        if (null == this.mediumHGridLinesVisible) {
            this._mediumHGridLinesVisible = VISIBLE;
            this.drawGrid();
        } else {
            this.mediumHGridLinesVisible.set(VISIBLE);
        }
    }

    public BooleanProperty mediumHGridLinesVisibleProperty() {
        if (null == this.mediumHGridLinesVisible) {
            this.mediumHGridLinesVisible = new BooleanPropertyBase(this._mediumHGridLinesVisible){

                protected void invalidated() {
                    Grid.this.drawGrid();
                }

                public Object getBean() {
                    return Grid.this;
                }

                public String getName() {
                    return "mediumHGridLinesVisible";
                }
            };
        }
        return this.mediumHGridLinesVisible;
    }

    public boolean getMinorHGridLinesVisible() {
        return null == this.minorHGridLinesVisible ? this._minorHGridLinesVisible : this.minorHGridLinesVisible.get();
    }

    public void setMinorHGridLinesVisible(boolean VISIBLE) {
        if (null == this.minorHGridLinesVisible) {
            this._minorHGridLinesVisible = VISIBLE;
            this.drawGrid();
        } else {
            this.minorHGridLinesVisible.set(VISIBLE);
        }
    }

    public BooleanProperty minorHGridLinesVisibleProperty() {
        if (null == this.minorHGridLinesVisible) {
            this.minorHGridLinesVisible = new BooleanPropertyBase(this._minorHGridLinesVisible){

                protected void invalidated() {
                    Grid.this.drawGrid();
                }

                public Object getBean() {
                    return Grid.this;
                }

                public String getName() {
                    return "minorHGridLinesVisible";
                }
            };
        }
        return this.minorHGridLinesVisible;
    }

    public Paint getMajorVGridLinePaint() {
        return null == this.majorVGridLinePaint ? this._majorVGridLinePaint : (Paint)this.majorVGridLinePaint.get();
    }

    public void setMajorVGridLinePaint(Paint PAINT) {
        if (null == this.majorVGridLinePaint) {
            this._majorVGridLinePaint = PAINT;
            this.drawGrid();
        } else {
            this.majorVGridLinePaint.set((Object)PAINT);
        }
    }

    public ObjectProperty<Paint> majorVGridLinePaintProperty() {
        if (null == this.majorVGridLinePaint) {
            this.majorVGridLinePaint = new ObjectPropertyBase<Paint>(this._majorVGridLinePaint){

                protected void invalidated() {
                    Grid.this.drawGrid();
                }

                public Object getBean() {
                    return Grid.this;
                }

                public String getName() {
                    return "majorVGridLinePaint";
                }
            };
            this._majorVGridLinePaint = null;
        }
        return this.majorVGridLinePaint;
    }

    public Paint getMediumVGridLinePaint() {
        return null == this.mediumVGridLinePaint ? this._mediumVGridLinePaint : (Paint)this.mediumVGridLinePaint.get();
    }

    public void setMediumVGridLinePaint(Paint PAINT) {
        if (null == this.mediumVGridLinePaint) {
            this._mediumVGridLinePaint = PAINT;
            this.drawGrid();
        } else {
            this.mediumVGridLinePaint.set((Object)PAINT);
        }
    }

    public ObjectProperty<Paint> mediumVGridLinePaintProperty() {
        if (null == this.mediumVGridLinePaint) {
            this.mediumVGridLinePaint = new ObjectPropertyBase<Paint>(this._mediumVGridLinePaint){

                protected void invalidated() {
                    Grid.this.drawGrid();
                }

                public Object getBean() {
                    return Grid.this;
                }

                public String getName() {
                    return "mediumVGridLinePaint";
                }
            };
            this._mediumVGridLinePaint = null;
        }
        return this.mediumVGridLinePaint;
    }

    public Paint getMinorVGridLinePaint() {
        return null == this.minorVGridLinePaint ? this._minorVGridLinePaint : (Paint)this.minorVGridLinePaint.get();
    }

    public void setMinorVGridLinePaint(Paint PAINT) {
        if (null == this.minorVGridLinePaint) {
            this._minorVGridLinePaint = PAINT;
            this.drawGrid();
        } else {
            this.minorVGridLinePaint.set((Object)PAINT);
        }
    }

    public ObjectProperty<Paint> minorVGridLinePaintProperty() {
        if (null == this.minorVGridLinePaint) {
            this.minorVGridLinePaint = new ObjectPropertyBase<Paint>(this._minorVGridLinePaint){

                protected void invalidated() {
                    Grid.this.drawGrid();
                }

                public Object getBean() {
                    return Grid.this;
                }

                public String getName() {
                    return "minorVGridLinePaint";
                }
            };
            this._minorVGridLinePaint = null;
        }
        return this.minorVGridLinePaint;
    }

    public boolean getMajorVGridLinesVisible() {
        return null == this.majorVGridLinesVisible ? this._majorVGridLinesVisible : this.majorVGridLinesVisible.get();
    }

    public void setMajorVGridLinesVisible(boolean VISIBLE) {
        if (null == this.majorVGridLinesVisible) {
            this._majorVGridLinesVisible = VISIBLE;
            this.drawGrid();
        } else {
            this.majorVGridLinesVisible.set(VISIBLE);
        }
    }

    public BooleanProperty majorVGridLinesVisibleProperty() {
        if (null == this.majorVGridLinesVisible) {
            this.majorVGridLinesVisible = new BooleanPropertyBase(this._majorVGridLinesVisible){

                protected void invalidated() {
                    Grid.this.drawGrid();
                }

                public Object getBean() {
                    return Grid.this;
                }

                public String getName() {
                    return "majorVGridLinesVisible";
                }
            };
        }
        return this.majorVGridLinesVisible;
    }

    public boolean getMediumVGridLinesVisible() {
        return null == this.mediumVGridLinesVisible ? this._mediumVGridLinesVisible : this.mediumVGridLinesVisible.get();
    }

    public void setMediumVGridLinesVisible(boolean VISIBLE) {
        if (null == this.mediumVGridLinesVisible) {
            this._mediumVGridLinesVisible = VISIBLE;
            this.drawGrid();
        } else {
            this.mediumVGridLinesVisible.set(VISIBLE);
        }
    }

    public BooleanProperty mediumVGridLinesVisibleProperty() {
        if (null == this.mediumVGridLinesVisible) {
            this.mediumVGridLinesVisible = new BooleanPropertyBase(this._mediumVGridLinesVisible){

                protected void invalidated() {
                    Grid.this.drawGrid();
                }

                public Object getBean() {
                    return Grid.this;
                }

                public String getName() {
                    return "mediumVGridLinesVisible";
                }
            };
        }
        return this.mediumVGridLinesVisible;
    }

    public boolean getMinorVGridLinesVisible() {
        return null == this.minorVGridLinesVisible ? this._minorVGridLinesVisible : this.minorVGridLinesVisible.get();
    }

    public void setMinorVGridLinesVisible(boolean VISIBLE) {
        if (null == this.minorVGridLinesVisible) {
            this._minorVGridLinesVisible = VISIBLE;
            this.drawGrid();
        } else {
            this.minorVGridLinesVisible.set(VISIBLE);
        }
    }

    public BooleanProperty minorVGridLinesVisibleProperty() {
        if (null == this.minorVGridLinesVisible) {
            this.minorVGridLinesVisible = new BooleanPropertyBase(this._minorVGridLinesVisible){

                protected void invalidated() {
                    Grid.this.drawGrid();
                }

                public Object getBean() {
                    return Grid.this;
                }

                public String getName() {
                    return "minorVGridLinesVisible";
                }
            };
        }
        return this.minorVGridLinesVisible;
    }

    public void setGridLinePaint(Paint PAINT) {
        this.setMajorHGridLinePaint(PAINT);
        this.setMediumHGridLinePaint(PAINT);
        this.setMinorHGridLinePaint(PAINT);
        this.setMajorVGridLinePaint(PAINT);
        this.setMediumVGridLinePaint(PAINT);
        this.setMinorVGridLinePaint(PAINT);
    }

    public void adjustGridLineVisibilityToAxis() {
        this.setMajorVGridLinesVisible(this.xAxis.getMajorTickMarksVisible());
        this.setMediumVGridLinesVisible(this.xAxis.getMediumTickMarksVisible());
        this.setMinorVGridLinesVisible(this.xAxis.getMinorTickMarksVisible());
        this.setMajorHGridLinesVisible(this.yAxis.getMajorTickMarksVisible());
        this.setMediumHGridLinesVisible(this.yAxis.getMediumTickMarksVisible());
        this.setMinorHGridLinesVisible(this.yAxis.getMinorTickMarksVisible());
    }

    public void setGridLineDashes(double ... DASHES) {
        this.dashes = DASHES;
        this.drawGrid();
    }

    private void drawGrid() {
        block36: {
            boolean minorTickMarksVisible;
            double section;
            AxisType yAxisType;
            Paint majorHGridColor;
            Paint minorHGridColor;
            double minorLineWidth;
            double majorLineWidth;
            block37: {
                boolean isZero;
                double endPointY;
                double endPointX;
                double startPointY;
                double startPointX;
                double i;
                double tmpStep;
                BigDecimal counterBD;
                double tmpStepSize;
                this.ctx.clearRect(0.0, 0.0, this.width, this.height);
                this.ctx.setLineDashes(this.dashes);
                majorLineWidth = 1.0;
                double mediumLineWidth = 0.75;
                minorLineWidth = 0.5;
                minorHGridColor = null == this.getMinorHGridLinePaint() ? Helper.getColorWithOpacity(this.yAxis.getMinorTickMarkColor(), this.getGridOpacity()) : this.getMinorHGridLinePaint();
                Paint mediumHGridColor = null == this.getMediumHGridLinePaint() ? Helper.getColorWithOpacity(this.yAxis.getMediumTickMarkColor(), this.getGridOpacity()) : this.getMediumHGridLinePaint();
                majorHGridColor = null == this.getMinorHGridLinePaint() ? Helper.getColorWithOpacity(this.yAxis.getMajorTickMarkColor(), this.getGridOpacity()) : this.getMinorHGridLinePaint();
                Paint minorVGridColor = null == this.getMajorVGridLinePaint() ? Helper.getColorWithOpacity(this.xAxis.getMinorTickMarkColor(), this.getGridOpacity()) : this.getMajorVGridLinePaint();
                Paint mediumVGridColor = null == this.getMediumVGridLinePaint() ? Helper.getColorWithOpacity(this.xAxis.getMediumTickMarkColor(), this.getGridOpacity()) : this.getMediumVGridLinePaint();
                Paint majorVGridColor = null == this.getMinorVGridLinePaint() ? Helper.getColorWithOpacity(this.xAxis.getMajorTickMarkColor(), this.getGridOpacity()) : this.getMinorVGridLinePaint();
                AxisType xAxisType = this.xAxis.getType();
                double minX = this.xAxis.getMinValue();
                double maxX = this.xAxis.getMaxValue();
                boolean fullRangeX = minX < 0.0 && maxX > 0.0;
                double minorTickSpaceX = this.xAxis.getMinorTickSpace();
                double majorTickSpaceX = this.xAxis.getMajorTickSpace();
                double rangeX = this.xAxis.getRange();
                double stepSizeX = Math.abs(this.width / rangeX);
                double zeroPositionX = this.xAxis.getZeroPosition();
                yAxisType = this.yAxis.getType();
                double minY = this.yAxis.getMinValue();
                double maxY = this.yAxis.getMaxValue();
                boolean fullRangeY = minY < 0.0 && maxY > 0.0;
                double minorTickSpaceY = this.yAxis.getMinorTickSpace();
                double majorTickSpaceY = this.yAxis.getMajorTickSpace();
                double rangeY = this.yAxis.getRange();
                double stepSizeY = Math.abs(this.height / rangeY);
                double zeroPositionY = this.yAxis.getZeroPosition();
                BigDecimal minorTickSpaceBD = BigDecimal.valueOf(minorTickSpaceX);
                BigDecimal majorTickSpaceBD = BigDecimal.valueOf(majorTickSpaceX);
                BigDecimal mediumCheck2 = BigDecimal.valueOf(2.0 * minorTickSpaceX);
                BigDecimal mediumCheck5 = BigDecimal.valueOf(5.0 * minorTickSpaceX);
                if (AxisType.LINEAR == xAxisType || AxisType.TEXT == xAxisType) {
                    tmpStepSize = minorTickSpaceX;
                    counterBD = BigDecimal.valueOf(minX);
                    double counter = minX;
                    BigDecimal tmpStepBD = new BigDecimal(tmpStepSize);
                    tmpStepBD = tmpStepBD.setScale(3, RoundingMode.HALF_UP);
                    tmpStep = tmpStepBD.doubleValue();
                    i = 0.0;
                    while (Double.compare(-rangeX - tmpStep, i) <= 0) {
                        startPointX = this.width + i * stepSizeX;
                        startPointY = 0.0;
                        endPointX = startPointX;
                        endPointY = this.height;
                        if (Double.compare(counterBD.setScale(12, RoundingMode.HALF_UP).remainder(majorTickSpaceBD).doubleValue(), 0.0) == 0) {
                            boolean bl = isZero = Double.compare(0.0, maxX - counter + minX) == 0;
                            if (this.getMajorVGridLinesVisible()) {
                                this.ctx.setStroke((Paint)(fullRangeX && isZero ? this.xAxis.getZeroColor() : majorVGridColor));
                                this.ctx.setLineWidth(majorLineWidth);
                                this.ctx.strokeLine(startPointX, startPointY, endPointX, endPointY);
                            } else if (this.getMinorVGridLinesVisible()) {
                                this.ctx.setStroke((Paint)(fullRangeX && isZero ? this.xAxis.getZeroColor() : minorVGridColor));
                                this.ctx.setLineWidth(minorLineWidth);
                                this.ctx.strokeLine(startPointX, startPointY, endPointX, endPointY);
                            }
                        } else if (this.getMediumVGridLinesVisible() && (double)Double.compare(minorTickSpaceBD.setScale(12, RoundingMode.HALF_UP).remainder(mediumCheck2).doubleValue(), 0.0) != 0.0 && (double)Double.compare(counterBD.setScale(12, RoundingMode.HALF_UP).remainder(mediumCheck5).doubleValue(), 0.0) == 0.0) {
                            this.ctx.setStroke(mediumVGridColor);
                            this.ctx.setLineWidth(mediumLineWidth);
                            this.ctx.strokeLine(startPointX, startPointY, endPointX, endPointY);
                        } else if (this.getMinorVGridLinesVisible() && Double.compare(counterBD.setScale(12, RoundingMode.HALF_UP).remainder(minorTickSpaceBD).doubleValue(), 0.0) == 0) {
                            this.ctx.setStroke(minorVGridColor);
                            this.ctx.setLineWidth(minorLineWidth);
                            this.ctx.strokeLine(startPointX, startPointY, endPointX, endPointY);
                        }
                        counterBD = counterBD.add(minorTickSpaceBD);
                        counter = counterBD.doubleValue();
                        if (!(counter > maxX)) {
                            i -= tmpStep;
                            continue;
                        }
                        break;
                    }
                } else if (AxisType.LOGARITHMIC == xAxisType) {
                    double logUpperBound = Math.log10(this.xAxis.getMaxValue());
                    section = this.width / logUpperBound;
                    boolean majorTickMarksVisible = this.xAxis.getMajorTickMarksVisible();
                    minorTickMarksVisible = this.xAxis.getMinorTickMarksVisible();
                    for (double i2 = 0.0; i2 <= logUpperBound; i2 += 1.0) {
                        for (double j = 1.0; j <= 9.0; j += 1.0) {
                            BigDecimal value = new BigDecimal(j * Math.pow(10.0, i2));
                            double stepSize = i2 > 0.0 ? Math.log10(value.doubleValue()) % i2 : Math.log10(value.doubleValue());
                            double startPointX2 = i2 * section + stepSize * section;
                            double startPointY2 = 0.0;
                            double endPointX2 = startPointX2;
                            double endPointY2 = this.height;
                            if (Helper.isPowerOf10(value.intValue())) {
                                if (majorTickMarksVisible) {
                                    this.ctx.setStroke(majorVGridColor);
                                    this.ctx.setLineWidth(majorLineWidth);
                                } else if (minorTickMarksVisible) {
                                    this.ctx.setStroke(minorVGridColor);
                                    this.ctx.setLineWidth(minorLineWidth);
                                }
                                this.ctx.strokeLine(startPointX2, startPointY2, endPointX2, endPointY2);
                                continue;
                            }
                            if (!minorTickMarksVisible) continue;
                            this.ctx.setStroke(minorVGridColor);
                            this.ctx.setLineWidth(minorLineWidth);
                            this.ctx.strokeLine(startPointX2, startPointY2, endPointX2, endPointY2);
                        }
                    }
                }
                minorTickSpaceBD = BigDecimal.valueOf(minorTickSpaceY);
                majorTickSpaceBD = BigDecimal.valueOf(majorTickSpaceY);
                mediumCheck2 = BigDecimal.valueOf(2.0 * minorTickSpaceY);
                mediumCheck5 = BigDecimal.valueOf(5.0 * minorTickSpaceY);
                if (AxisType.LINEAR != yAxisType && AxisType.TEXT != yAxisType) break block37;
                tmpStepSize = minorTickSpaceY;
                counterBD = BigDecimal.valueOf(minY);
                double counter = minY;
                BigDecimal tmpStepBD = new BigDecimal(tmpStepSize);
                tmpStepBD = tmpStepBD.setScale(3, RoundingMode.HALF_UP);
                tmpStep = tmpStepBD.doubleValue();
                i = 0.0;
                while (Double.compare(-rangeY - tmpStep, i) <= 0) {
                    startPointX = 0.0;
                    startPointY = this.height + i * stepSizeY;
                    endPointX = this.width;
                    endPointY = startPointY;
                    if (Double.compare(counterBD.setScale(12, RoundingMode.HALF_UP).remainder(majorTickSpaceBD).doubleValue(), 0.0) == 0) {
                        boolean bl = isZero = Double.compare(0.0, counter) == 0;
                        if (this.getMajorHGridLinesVisible()) {
                            this.ctx.setStroke((Paint)(fullRangeY && isZero ? this.yAxis.getZeroColor() : majorHGridColor));
                            this.ctx.setLineWidth(majorLineWidth);
                            this.ctx.strokeLine(startPointX, startPointY, endPointX, endPointY);
                        } else if (this.getMinorHGridLinesVisible()) {
                            this.ctx.setStroke((Paint)(fullRangeY && isZero ? this.yAxis.getZeroColor() : minorHGridColor));
                            this.ctx.setLineWidth(minorLineWidth);
                            this.ctx.strokeLine(startPointX, startPointY, endPointX, endPointY);
                        }
                    } else if (this.getMediumHGridLinesVisible() && (double)Double.compare(minorTickSpaceBD.setScale(12, RoundingMode.HALF_UP).remainder(mediumCheck2).doubleValue(), 0.0) != 0.0 && (double)Double.compare(counterBD.setScale(12, RoundingMode.HALF_UP).remainder(mediumCheck5).doubleValue(), 0.0) == 0.0) {
                        this.ctx.setStroke(mediumHGridColor);
                        this.ctx.setLineWidth(mediumLineWidth);
                        this.ctx.strokeLine(startPointX, startPointY, endPointX, endPointY);
                    } else if (this.getMinorHGridLinesVisible() && Double.compare(counterBD.setScale(12, RoundingMode.HALF_UP).remainder(minorTickSpaceBD).doubleValue(), 0.0) == 0) {
                        this.ctx.setStroke(minorHGridColor);
                        this.ctx.setLineWidth(minorLineWidth);
                        this.ctx.strokeLine(startPointX, startPointY, endPointX, endPointY);
                    }
                    counterBD = counterBD.add(minorTickSpaceBD);
                    counter = counterBD.doubleValue();
                    if (!(counter > maxY)) {
                        i -= tmpStep;
                        continue;
                    }
                    break block36;
                }
                break block36;
            }
            if (AxisType.LOGARITHMIC != yAxisType) break block36;
            double logUpperBound = Math.log10(this.yAxis.getMaxValue());
            section = this.height / logUpperBound;
            boolean majorTickMarksVisible = this.yAxis.getMajorTickMarksVisible();
            minorTickMarksVisible = this.yAxis.getMinorTickMarksVisible();
            double maxPosition = this.height;
            for (double i = 0.0; i <= logUpperBound; i += 1.0) {
                for (double j = 1.0; j <= 9.0; j += 1.0) {
                    BigDecimal value = new BigDecimal(j * Math.pow(10.0, i));
                    double stepSize = i > 0.0 ? Math.log10(value.doubleValue()) % i : Math.log10(value.doubleValue());
                    double startPointX = 0.0;
                    double startPointY = maxPosition - i * section - stepSize * section;
                    double endPointX = this.width;
                    double endPointY = startPointY;
                    if (Helper.isPowerOf10(value.intValue())) {
                        if (majorTickMarksVisible) {
                            this.ctx.setStroke(majorHGridColor);
                            this.ctx.setLineWidth(majorLineWidth);
                        } else if (minorTickMarksVisible) {
                            this.ctx.setStroke(minorHGridColor);
                            this.ctx.setLineWidth(minorLineWidth);
                        }
                        this.ctx.strokeLine(startPointX, startPointY, endPointX, endPointY);
                        continue;
                    }
                    if (!minorTickMarksVisible) continue;
                    this.ctx.setStroke(minorHGridColor);
                    this.ctx.setLineWidth(minorLineWidth);
                    this.ctx.strokeLine(startPointX, startPointY, endPointX, endPointY);
                }
            }
        }
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        double d = this.size = this.width < this.height ? this.width : this.height;
        if (this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.width, this.height);
            this.pane.setPrefSize(this.width, this.height);
            this.pane.relocate((this.getWidth() - this.width) * 0.5, (this.getHeight() - this.height) * 0.5);
            this.canvas.setWidth(this.width);
            this.canvas.setHeight(this.height);
            this.drawGrid();
        }
    }
}

