/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.Axis;
import eu.hansolo.fx.charts.Grid;
import java.util.HashMap;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.scene.paint.Paint;

public class GridBuilder<B extends GridBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();
    private Axis xAxis;
    private Axis yAxis;

    protected GridBuilder(Axis X_AXIS, Axis Y_AXIS) {
        this.xAxis = X_AXIS;
        this.yAxis = Y_AXIS;
    }

    public static final GridBuilder create(Axis X_AXIS, Axis Y_AXIS) {
        return new GridBuilder(X_AXIS, Y_AXIS);
    }

    public final B majorHGridLinePaint(Paint PAINT) {
        this.properties.put("majorHGridLinePaint", (Property)new SimpleObjectProperty((Object)PAINT));
        return (B)this;
    }

    public final B mediumHGridLinePaint(Paint PAINT) {
        this.properties.put("mediumHGridLinePaint", (Property)new SimpleObjectProperty((Object)PAINT));
        return (B)this;
    }

    public final B minorHGridLinePaint(Paint PAINT) {
        this.properties.put("minorHGridLinePaint", (Property)new SimpleObjectProperty((Object)PAINT));
        return (B)this;
    }

    public final B majorVGridLinePaint(Paint PAINT) {
        this.properties.put("majorVGridLinePaint", (Property)new SimpleObjectProperty((Object)PAINT));
        return (B)this;
    }

    public final B mediumVGridLinePaint(Paint PAINT) {
        this.properties.put("mediumVGridLinePaint", (Property)new SimpleObjectProperty((Object)PAINT));
        return (B)this;
    }

    public final B minorVGridLinePaint(Paint PAINT) {
        this.properties.put("minorVGridLinePaint", (Property)new SimpleObjectProperty((Object)PAINT));
        return (B)this;
    }

    public final B gridLinePaint(Paint PAINT) {
        this.properties.put("gridLinePaint", (Property)new SimpleObjectProperty((Object)PAINT));
        return (B)this;
    }

    public final B majorHGridLinesVisible(boolean VISIBLE) {
        this.properties.put("majorHGridLinesVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B mediumHGridLinesVisible(boolean VISIBLE) {
        this.properties.put("mediumHGridLinesVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B minorHGridLinesVisible(boolean VISIBLE) {
        this.properties.put("minorHGridLinesVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B majorVGridLinesVisible(boolean VISIBLE) {
        this.properties.put("majorVGridLinesVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B mediumVGridLinesVisible(boolean VISIBLE) {
        this.properties.put("mediumVGridLinesVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B minorVGridLinesVisible(boolean VISIBLE) {
        this.properties.put("minorVGridLinesVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B gridOpacity(double OPACITY) {
        this.properties.put("opacity", (Property)new SimpleDoubleProperty(OPACITY));
        return (B)this;
    }

    public final B gridLineDashes(double ... DASHES) {
        this.properties.put("dashesArray", (Property)new SimpleObjectProperty((Object)DASHES));
        return (B)this;
    }

    public final B prefSize(double WIDTH, double HEIGHT) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B minSize(double WIDTH, double HEIGHT) {
        this.properties.put("minSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B maxSize(double WIDTH, double HEIGHT) {
        this.properties.put("maxSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B prefWidth(double PREF_WIDTH) {
        this.properties.put("prefWidth", (Property)new SimpleDoubleProperty(PREF_WIDTH));
        return (B)this;
    }

    public final B prefHeight(double PREF_HEIGHT) {
        this.properties.put("prefHeight", (Property)new SimpleDoubleProperty(PREF_HEIGHT));
        return (B)this;
    }

    public final B minWidth(double MIN_WIDTH) {
        this.properties.put("minWidth", (Property)new SimpleDoubleProperty(MIN_WIDTH));
        return (B)this;
    }

    public final B minHeight(double MIN_HEIGHT) {
        this.properties.put("minHeight", (Property)new SimpleDoubleProperty(MIN_HEIGHT));
        return (B)this;
    }

    public final B maxWidth(double MAX_WIDTH) {
        this.properties.put("maxWidth", (Property)new SimpleDoubleProperty(MAX_WIDTH));
        return (B)this;
    }

    public final B maxHeight(double MAX_HEIGHT) {
        this.properties.put("maxHeight", (Property)new SimpleDoubleProperty(MAX_HEIGHT));
        return (B)this;
    }

    public final B scaleX(double SCALE_X) {
        this.properties.put("scaleX", (Property)new SimpleDoubleProperty(SCALE_X));
        return (B)this;
    }

    public final B scaleY(double SCALE_Y) {
        this.properties.put("scaleY", (Property)new SimpleDoubleProperty(SCALE_Y));
        return (B)this;
    }

    public final B layoutX(double LAYOUT_X) {
        this.properties.put("layoutX", (Property)new SimpleDoubleProperty(LAYOUT_X));
        return (B)this;
    }

    public final B layoutY(double LAYOUT_Y) {
        this.properties.put("layoutY", (Property)new SimpleDoubleProperty(LAYOUT_Y));
        return (B)this;
    }

    public final B translateX(double TRANSLATE_X) {
        this.properties.put("translateX", (Property)new SimpleDoubleProperty(TRANSLATE_X));
        return (B)this;
    }

    public final B translateY(double TRANSLATE_Y) {
        this.properties.put("translateY", (Property)new SimpleDoubleProperty(TRANSLATE_Y));
        return (B)this;
    }

    public final B padding(Insets INSETS) {
        this.properties.put("padding", (Property)new SimpleObjectProperty((Object)INSETS));
        return (B)this;
    }

    public final Grid build() {
        Grid CONTROL = new Grid(this.xAxis, this.yAxis);
        if (this.properties.keySet().contains("dashesArray")) {
            CONTROL.setGridLineDashes((double[])((ObjectProperty)this.properties.get("dashesArray")).get());
        }
        for (String key : this.properties.keySet()) {
            Dimension2D dim;
            if ("prefSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                CONTROL.setPrefSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("minSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                CONTROL.setMinSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("maxSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                CONTROL.setMaxSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("prefWidth".equals(key)) {
                CONTROL.setPrefWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("prefHeight".equals(key)) {
                CONTROL.setPrefHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minWidth".equals(key)) {
                CONTROL.setMinWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minHeight".equals(key)) {
                CONTROL.setMinHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxWidth".equals(key)) {
                CONTROL.setMaxWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxHeight".equals(key)) {
                CONTROL.setMaxHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("scaleX".equals(key)) {
                CONTROL.setScaleX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("scaleY".equals(key)) {
                CONTROL.setScaleY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("layoutX".equals(key)) {
                CONTROL.setLayoutX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("layoutY".equals(key)) {
                CONTROL.setLayoutY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("translateX".equals(key)) {
                CONTROL.setTranslateX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("translateY".equals(key)) {
                CONTROL.setTranslateY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("padding".equals(key)) {
                CONTROL.setPadding((Insets)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("gridLinePaint".equals(key)) {
                CONTROL.setGridLinePaint((Paint)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("majorHGridLinePaint".equals(key)) {
                CONTROL.setMajorHGridLinePaint((Paint)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("mediumHGridLinePaint".equals(key)) {
                CONTROL.setMediumHGridLinePaint((Paint)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minorHGridLinePaint".equals(key)) {
                CONTROL.setMinorHGridLinePaint((Paint)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("majorVGridLinePaint".equals(key)) {
                CONTROL.setMajorVGridLinePaint((Paint)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("mediumVGridLinePaint".equals(key)) {
                CONTROL.setMediumVGridLinePaint((Paint)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minorVGridLinePaint".equals(key)) {
                CONTROL.setMinorVGridLinePaint((Paint)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("majorHGridLinesVisible".equals(key)) {
                CONTROL.setMajorHGridLinesVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("mediumHGridLinesVisible".equals(key)) {
                CONTROL.setMediumHGridLinesVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minorHGridLinesVisible".equals(key)) {
                CONTROL.setMinorHGridLinesVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("majorVGridLinesVisible".equals(key)) {
                CONTROL.setMajorVGridLinesVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("mediumVGridLinesVisible".equals(key)) {
                CONTROL.setMediumVGridLinesVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minorVGridLinesVisible".equals(key)) {
                CONTROL.setMinorVGridLinesVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if (!"gridOpacity".equals(key)) continue;
            CONTROL.setGridOpacity(((DoubleProperty)this.properties.get(key)).get());
        }
        return CONTROL;
    }
}

