/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.data.ChartItem;
import eu.hansolo.fx.charts.data.DataObject;
import eu.hansolo.fx.charts.event.ChartEvt;
import eu.hansolo.fx.charts.tools.Helper;
import eu.hansolo.fx.charts.tools.Order;
import eu.hansolo.toolbox.evt.Evt;
import eu.hansolo.toolbox.evt.EvtObserver;
import eu.hansolo.toolbox.evt.EvtType;
import eu.hansolo.toolboxfx.font.Fonts;
import eu.hansolo.toolboxfx.geom.Bounds;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.IntegerPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;

@DefaultProperty(value="children")
public class ParallelCoordinatesChart
extends Region {
    private static final double PREFERRED_WIDTH = 600.0;
    private static final double PREFERRED_HEIGHT = 400.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 2048.0;
    private static final double MAXIMUM_HEIGHT = 2048.0;
    private static final double HEADER_HEIGHT = 30.0;
    private static final double AXIS_WIDTH = 10.0;
    private static final double MAJOR_TICK_LENGTH = 6.0;
    private static final double MEDIUM_TICK_LENGTH = 4.0;
    private final ChartEvt SELECTION_EVENT = new ChartEvt((Object)this, ChartEvt.SELECTED);
    private double size;
    private double width;
    private double height;
    private Canvas axisCanvas;
    private GraphicsContext axisCtx;
    private Canvas connectionCanvas;
    private GraphicsContext connectionCtx;
    private Color _axisColor = Color.BLACK;
    private ObjectProperty<Color> axisColor;
    private Color _headerColor = Color.BLACK;
    private ObjectProperty<Color> headerColor;
    private Color _unitColor = Color.BLACK;
    private ObjectProperty<Color> unitColor;
    private Color _tickLabelColor = Color.BLACK;
    private ObjectProperty<Color> tickLabelColor;
    private Locale _locale = Locale.US;
    private ObjectProperty<Locale> locale;
    private int _decimals = 0;
    private IntegerProperty decimals;
    private boolean _tickMarksVisible = true;
    private BooleanProperty tickMarksVisible;
    private Color _selectedColor = Color.BLUE;
    private ObjectProperty<Color> selectedColor;
    private Color _unselectedColor = Color.LIGHTGRAY;
    private ObjectProperty<Color> unselectedColor;
    private Color _selectionRectColor = Color.BLUE;
    private ObjectProperty<Color> selectionRectColor;
    private boolean _smoothConnections = false;
    private BooleanProperty smoothConnections;
    private String formatString = "%." + this._decimals + "f";
    private String selectedCategory;
    private String selectionRectCategory = "";
    private double selectionStartX;
    private double selectionStartY;
    private double selectionEndY;
    private Bounds selectionRect;
    private Map<String, ChartItem> selectedItems = new HashMap<String, ChartItem>();
    private Set<DataObject> selectedObjects = new LinkedHashSet<DataObject>();
    private ObservableList<DataObject> items;
    private ArrayList<String> categories;
    private Map<String, List<DataObject>> categoryObjectMap;
    private Map<Key, ChartItem> categoryObjectItemMap;
    private EvtObserver<ChartEvt> itemObserver;
    private ListChangeListener<DataObject> objectListListener;
    private EventHandler<MouseEvent> mouseHandler;
    private Rectangle rect;
    private Text dragText;
    private boolean wasDragged = false;
    private Map<EvtType, List<EvtObserver<ChartEvt>>> observers;

    public ParallelCoordinatesChart() {
        this.selectionRect = new Bounds();
        this.items = FXCollections.observableArrayList();
        this.itemObserver = e -> this.redraw();
        this.objectListListener = c -> {
            while (c.next()) {
                if (c.wasAdded()) {
                    c.getAddedSubList().forEach(addedObject -> addedObject.getProperties().values().forEach(item -> item.addChartEvtObserver(ChartEvt.ITEM_UPDATE, this.itemObserver)));
                    continue;
                }
                if (!c.wasRemoved()) continue;
                c.getRemoved().forEach(removedObject -> removedObject.getProperties().values().forEach(item -> item.removeChartEvtObserver(ChartEvt.ITEM_UPDATE, this.itemObserver)));
            }
            this.prepareData();
            this.redraw();
        };
        this.categories = new ArrayList();
        this.categoryObjectMap = new HashMap<String, List<DataObject>>();
        this.categoryObjectItemMap = new HashMap<Key, ChartItem>();
        this.mouseHandler = e -> this.handleMouseEvent((MouseEvent)e);
        this.observers = new ConcurrentHashMap<EvtType, List<EvtObserver<ChartEvt>>>();
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(600.0, 400.0);
            }
        }
        this.axisCanvas = new Canvas(600.0, 400.0);
        this.axisCtx = this.axisCanvas.getGraphicsContext2D();
        Color selectionRectColor = this.getSelectionRectColor();
        this.rect = new Rectangle();
        this.rect.setMouseTransparent(true);
        this.rect.setVisible(false);
        this.rect.setStroke((Paint)Helper.getColorWithOpacity(selectionRectColor, 0.5));
        this.rect.setFill((Paint)Helper.getColorWithOpacity(selectionRectColor, 0.25));
        this.connectionCanvas = new Canvas(600.0, 400.0);
        this.connectionCanvas.setMouseTransparent(true);
        this.connectionCtx = this.connectionCanvas.getGraphicsContext2D();
        this.connectionCtx.setTextAlign(TextAlignment.LEFT);
        this.connectionCtx.setTextBaseline(VPos.CENTER);
        this.dragText = new Text("");
        this.dragText.setVisible(false);
        this.dragText.setTextOrigin(VPos.CENTER);
        this.dragText.setFill((Paint)Helper.getColorWithOpacity(this.getHeaderColor(), 0.5));
        this.getChildren().setAll((Object[])new Node[]{this.axisCanvas, this.rect, this.connectionCanvas, this.dragText});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
        this.items.addListener(this.objectListListener);
        this.axisCanvas.addEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseHandler);
        this.axisCanvas.addEventHandler(MouseEvent.MOUSE_DRAGGED, this.mouseHandler);
        this.axisCanvas.addEventHandler(MouseEvent.MOUSE_RELEASED, this.mouseHandler);
    }

    public void layoutChildren() {
        super.layoutChildren();
    }

    protected double computeMinWidth(double HEIGHT) {
        return 50.0;
    }

    protected double computeMinHeight(double WIDTH) {
        return 50.0;
    }

    protected double computePrefWidth(double HEIGHT) {
        return super.computePrefWidth(HEIGHT);
    }

    protected double computePrefHeight(double WIDTH) {
        return super.computePrefHeight(WIDTH);
    }

    protected double computeMaxWidth(double HEIGHT) {
        return 2048.0;
    }

    protected double computeMaxHeight(double WIDTH) {
        return 2048.0;
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public void dispose() {
        this.items.forEach(object -> object.getProperties().values().forEach(item -> item.removeChartEvtObserver(ChartEvt.ITEM_UPDATE, this.itemObserver)));
        this.axisCanvas.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseHandler);
        this.axisCanvas.removeEventHandler(MouseEvent.MOUSE_DRAGGED, this.mouseHandler);
        this.axisCanvas.removeEventHandler(MouseEvent.MOUSE_RELEASED, this.mouseHandler);
    }

    public Color getAxisColor() {
        return null == this.axisColor ? this._axisColor : (Color)this.axisColor.get();
    }

    public void setAxisColor(Color COLOR) {
        if (null == this.axisColor) {
            this._axisColor = COLOR;
            this.redraw();
        } else {
            this.axisColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> axisColorProperty() {
        if (null == this.axisColor) {
            this.axisColor = new ObjectPropertyBase<Color>(this._axisColor){

                protected void invalidated() {
                    ParallelCoordinatesChart.this.redraw();
                }

                public Object getBean() {
                    return ParallelCoordinatesChart.this;
                }

                public String getName() {
                    return "axisColor";
                }
            };
            this._axisColor = null;
        }
        return this.axisColor;
    }

    public Color getHeaderColor() {
        return null == this.headerColor ? this._headerColor : (Color)this.headerColor.get();
    }

    public void setHeaderColor(Color COLOR) {
        if (null == this.headerColor) {
            this._headerColor = COLOR;
            this.dragText.setFill((Paint)Helper.getColorWithOpacity(this._headerColor, 0.5));
            this.redraw();
        } else {
            this.headerColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> headerColorProperty() {
        if (null == this.headerColor) {
            this.headerColor = new ObjectPropertyBase<Color>(this._headerColor){

                protected void invalidated() {
                    ParallelCoordinatesChart.this.dragText.setFill((Paint)Helper.getColorWithOpacity((Color)this.get(), 0.5));
                    ParallelCoordinatesChart.this.redraw();
                }

                public Object getBean() {
                    return ParallelCoordinatesChart.this;
                }

                public String getName() {
                    return "headerColor";
                }
            };
            this._headerColor = null;
        }
        return this.headerColor;
    }

    public Color getUnitColor() {
        return null == this.unitColor ? this._unitColor : (Color)this.unitColor.get();
    }

    public void setUnitColor(Color COLOR) {
        if (null == this.unitColor) {
            this._unitColor = COLOR;
            this.redraw();
        } else {
            this.unitColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> unitColorProperty() {
        if (null == this.unitColor) {
            this.unitColor = new ObjectPropertyBase<Color>(this._unitColor){

                protected void invalidated() {
                    ParallelCoordinatesChart.this.redraw();
                }

                public Object getBean() {
                    return ParallelCoordinatesChart.this;
                }

                public String getName() {
                    return "unitColor";
                }
            };
            this._unitColor = null;
        }
        return this.unitColor;
    }

    public Color getTickLabelColor() {
        return null == this.tickLabelColor ? this._tickLabelColor : (Color)this.tickLabelColor.get();
    }

    public void setTickLabelColor(Color COLOR) {
        if (null == this.tickLabelColor) {
            this._tickLabelColor = COLOR;
            this.redraw();
        } else {
            this.tickLabelColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> tickLabelColorProperty() {
        if (null == this.tickLabelColor) {
            this.tickLabelColor = new ObjectPropertyBase<Color>(this._tickLabelColor){

                protected void invalidated() {
                    ParallelCoordinatesChart.this.redraw();
                }

                public Object getBean() {
                    return ParallelCoordinatesChart.this;
                }

                public String getName() {
                    return "tickLabelColor";
                }
            };
            this._tickLabelColor = null;
        }
        return this.tickLabelColor;
    }

    public Locale getLocale() {
        return null == this.locale ? this._locale : (Locale)this.locale.get();
    }

    public void setLocale(Locale LOCALE) {
        if (null == this.locale) {
            this._locale = LOCALE;
            this.redraw();
        } else {
            this.locale.set((Object)LOCALE);
        }
    }

    public ObjectProperty<Locale> localeProperty() {
        if (null == this.locale) {
            this.locale = new ObjectPropertyBase<Locale>(this._locale){

                protected void invalidated() {
                    ParallelCoordinatesChart.this.redraw();
                }

                public Object getBean() {
                    return ParallelCoordinatesChart.this;
                }

                public String getName() {
                    return "locale";
                }
            };
            this._locale = null;
        }
        return this.locale;
    }

    public int getDecimals() {
        return null == this.decimals ? this._decimals : this.decimals.get();
    }

    public void setDecimals(int DECIMALS) {
        if (null == this.decimals) {
            this._decimals = Helper.clamp(0, 6, DECIMALS);
            this.formatString = "%." + this._decimals + "f";
            this.redraw();
        } else {
            this.decimals.set(DECIMALS);
        }
    }

    public IntegerProperty decimalsProperty() {
        if (null == this.decimals) {
            this.decimals = new IntegerPropertyBase(this._decimals){

                protected void invalidated() {
                    this.set(Helper.clamp(0, 6, this.get()));
                    ParallelCoordinatesChart.this.formatString = "%." + this.get() + "f";
                    ParallelCoordinatesChart.this.redraw();
                }

                public Object getBean() {
                    return ParallelCoordinatesChart.this;
                }

                public String getName() {
                    return "decimals";
                }
            };
        }
        return this.decimals;
    }

    public boolean isTickMarksVisible() {
        return null == this.tickMarksVisible ? this._tickMarksVisible : this.tickMarksVisible.get();
    }

    public void setTickMarksVisible(boolean VISIBLE) {
        if (null == this.tickMarksVisible) {
            this._tickMarksVisible = VISIBLE;
            this.redraw();
        } else {
            this.tickMarksVisible.set(VISIBLE);
        }
    }

    public BooleanProperty tickMarksVisibleProperty() {
        if (null == this.tickMarksVisible) {
            this.tickMarksVisible = new BooleanPropertyBase(this._tickMarksVisible){

                protected void invalidated() {
                    ParallelCoordinatesChart.this.redraw();
                }

                public Object getBean() {
                    return ParallelCoordinatesChart.this;
                }

                public String getName() {
                    return "tickMarksVisible";
                }
            };
        }
        return this.tickMarksVisible;
    }

    public Color getSelectedColor() {
        return null == this.selectedColor ? this._selectedColor : (Color)this.selectedColor.get();
    }

    public void setSelectedColor(Color COLOR) {
        if (null == this.selectedColor) {
            this._selectedColor = COLOR;
            this.redraw();
        } else {
            this.selectedColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> selectedColorProperty() {
        if (null == this.selectedColor) {
            this.selectedColor = new ObjectPropertyBase<Color>(this._selectedColor){

                protected void invalidated() {
                    ParallelCoordinatesChart.this.redraw();
                }

                public Object getBean() {
                    return ParallelCoordinatesChart.this;
                }

                public String getName() {
                    return "selectedColor";
                }
            };
            this._selectedColor = null;
        }
        return this.selectedColor;
    }

    public Color getUnselectedColor() {
        return null == this.unselectedColor ? this._unselectedColor : (Color)this.unselectedColor.get();
    }

    public void setUnselectedColor(Color COLOR) {
        if (null == this.unselectedColor) {
            this._unselectedColor = COLOR;
            this.redraw();
        } else {
            this.unselectedColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> unselectedColorProperty() {
        if (null == this.unselectedColor) {
            this.unselectedColor = new ObjectPropertyBase<Color>(this._unselectedColor){

                protected void invalidated() {
                    ParallelCoordinatesChart.this.redraw();
                }

                public Object getBean() {
                    return ParallelCoordinatesChart.this;
                }

                public String getName() {
                    return "unselectedColor";
                }
            };
            this._unselectedColor = null;
        }
        return this.unselectedColor;
    }

    public Color getSelectionRectColor() {
        return null == this.selectionRectColor ? this._selectionRectColor : (Color)this.selectionRectColor.get();
    }

    public void setSelectionRectColor(Color COLOR) {
        if (null == this.selectionRectColor) {
            this._selectionRectColor = COLOR;
            this.rect.setStroke((Paint)Helper.getColorWithOpacity(this._selectionRectColor, 0.5));
            this.rect.setFill((Paint)Helper.getColorWithOpacity(this._selectionRectColor, 0.25));
            this.redraw();
        } else {
            this.selectionRectColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> selectionRectColorProperty() {
        if (null == this.selectionRectColor) {
            this.selectionRectColor = new ObjectPropertyBase<Color>(this._selectionRectColor){

                protected void invalidated() {
                    ParallelCoordinatesChart.this.rect.setStroke((Paint)Helper.getColorWithOpacity((Color)this.get(), 0.5));
                    ParallelCoordinatesChart.this.rect.setFill((Paint)Helper.getColorWithOpacity((Color)this.get(), 0.25));
                    ParallelCoordinatesChart.this.redraw();
                }

                public Object getBean() {
                    return ParallelCoordinatesChart.this;
                }

                public String getName() {
                    return "selectionRectColor";
                }
            };
            this._selectionRectColor = null;
        }
        return this.selectionRectColor;
    }

    public boolean getSmoothConnections() {
        return null == this.smoothConnections ? this._smoothConnections : this.smoothConnections.get();
    }

    public void setSmoothConnections(boolean SMOOTH) {
        if (null == this.smoothConnections) {
            this._smoothConnections = SMOOTH;
            this.redraw();
        } else {
            this.smoothConnections.set(SMOOTH);
        }
    }

    public BooleanProperty smoothConnectionsProperty() {
        if (null == this.smoothConnections) {
            this.smoothConnections = new BooleanPropertyBase(this._smoothConnections){

                public Object getBean() {
                    return ParallelCoordinatesChart.this;
                }

                public String getName() {
                    return "smoothConnections";
                }
            };
        }
        return this.smoothConnections;
    }

    public List<DataObject> getItems() {
        return this.items;
    }

    public void setItems(DataObject ... ITEMS) {
        this.setItems(Arrays.asList(ITEMS));
    }

    public void setItems(List<DataObject> ITEMS) {
        this.items.setAll(ITEMS);
    }

    public void addItem(DataObject ITEM) {
        if (!this.items.contains((Object)ITEM)) {
            this.items.add((Object)ITEM);
        }
    }

    public void removeItem(DataObject ITEM) {
        if (this.items.contains((Object)ITEM)) {
            this.items.remove((Object)ITEM);
        }
    }

    public Set<DataObject> getSelectedObjects() {
        return this.selectedObjects;
    }

    public void sortCategory(String CATEGORY, List<DataObject> DATA_OBJECTS, Order ORDER) {
        DATA_OBJECTS.sort(Comparator.comparingDouble(object -> object.getProperties().get(CATEGORY).getValue()));
        if (Order.DESCENDING == ORDER) {
            Collections.reverse(DATA_OBJECTS);
        }
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public Map<String, List<DataObject>> getCategoryObjectMap() {
        return this.categoryObjectMap;
    }

    private double[] getMinMax(String CATEGORY) {
        double min = this.categoryObjectMap.get(CATEGORY).stream().mapToDouble(obj -> obj.getProperties().get(CATEGORY).getValue()).min().getAsDouble();
        double max = this.categoryObjectMap.get(CATEGORY).stream().mapToDouble(obj -> obj.getProperties().get(CATEGORY).getValue()).max().getAsDouble();
        return new double[]{min, max};
    }

    private void prepareData() {
        if (this.items.isEmpty()) {
            return;
        }
        this.categoryObjectMap.clear();
        ArrayList<String> keys = new ArrayList<String>(((DataObject)this.items.get(0)).getProperties().keySet());
        if (keys.size() <= 1) {
            throw new RuntimeException("You need at least 2 categories in your DataObject");
        }
        keys.forEach(key -> this.categoryObjectMap.put((String)key, new ArrayList()));
        keys.forEach(key -> this.items.forEach(dataObject -> this.categoryObjectMap.get(key).add((DataObject)dataObject)));
        keys.forEach(key -> this.sortCategory((String)key, this.categoryObjectMap.get(key), Order.DESCENDING));
        this.categories.clear();
        this.categories.addAll(this.categoryObjectMap.keySet());
    }

    private void shiftCategory(String CATEGORY, int INDEX) {
        if (!this.categories.contains(CATEGORY) || INDEX == this.categories.indexOf(CATEGORY) || INDEX < 0 || INDEX >= this.categories.size()) {
            return;
        }
        this.categories.remove(CATEGORY);
        this.categories.add(INDEX, CATEGORY);
    }

    private void selectObjectsAtCategory(String CATEGORY, double MIN_Y, double MAX_Y) {
        this.selectedItems.clear();
        this.categoryObjectItemMap.entrySet().stream().filter(entry -> ((Key)entry.getKey()).getCategory().equals(CATEGORY)).filter(entry -> ((ChartItem)entry.getValue()).getY() > MIN_Y && ((ChartItem)entry.getValue()).getY() < MAX_Y).filter(entry -> ((ChartItem)entry.getValue()).getY() < MAX_Y).forEach(entry -> this.selectedItems.put(((Key)entry.getKey()).getDataObject().getName(), (ChartItem)entry.getValue()));
        this.selectedObjects.clear();
        this.items.forEach(obj -> this.categories.forEach(category -> {
            if (this.selectedItems.size() > 0 && this.selectedItems.keySet().contains(obj.getName())) {
                this.selectedObjects.add((DataObject)obj);
            }
        }));
        if (!this.selectedObjects.isEmpty()) {
            this.fireChartEvt(this.SELECTION_EVENT);
        }
        if (this.getSmoothConnections()) {
            this.drawSmoothConnections();
        } else {
            this.drawConnections();
        }
    }

    private String selectCategory(double X, double Y) {
        int noOfCategories = this.categories.size();
        double availableWidth = this.width - 10.0;
        double spacer = availableWidth / (double)(noOfCategories - 1);
        double thirdSpacer = spacer / 3.0;
        for (int i = 0; i < noOfCategories; ++i) {
            double axisX = (double)i * spacer + 5.0;
            if (i == 0 && X < axisX + thirdSpacer) {
                this.selectionStartX = axisX - 5.0;
                return this.categories.get(i);
            }
            if (!(X > axisX - thirdSpacer) || !(X < axisX + thirdSpacer)) continue;
            this.selectionStartX = axisX - 5.0;
            return this.categories.get(i);
        }
        return null;
    }

    private double getAxisXOfCategory(String CATEGORY) {
        int noOfCategories = this.categories.size();
        double availableWidth = this.width - 10.0;
        double spacer = availableWidth / (double)(noOfCategories - 1);
        for (int i = 0; i < noOfCategories; ++i) {
            double axisX = (double)i * spacer + 5.0;
            if (!this.categories.get(i).equals(CATEGORY)) continue;
            return axisX;
        }
        return -1.0;
    }

    private void resizeSelectionRect() {
        this.rect.setX(this.selectionRect.getX());
        this.rect.setY(this.selectionRect.getY());
        this.rect.setWidth(this.selectionRect.getWidth());
        this.rect.setHeight(this.selectionRect.getHeight());
    }

    private double[] calcAutoScale(double MIN_VALUE, double MAX_VALUE) {
        double maxNoOfMajorTicks = 10.0;
        double maxNoOfMinorTicks = 10.0;
        double niceRange = Helper.calcNiceNumber(MAX_VALUE - MIN_VALUE, false);
        double majorTickSpace = Helper.calcNiceNumber(niceRange / (maxNoOfMajorTicks - 1.0), true);
        double minorTickSpace = Helper.calcNiceNumber(majorTickSpace / (maxNoOfMinorTicks - 1.0), true);
        double niceMinValue = Math.floor(MIN_VALUE / majorTickSpace) * majorTickSpace;
        double niceMaxValue = Math.ceil(MAX_VALUE / majorTickSpace) * majorTickSpace;
        return new double[]{niceMinValue, niceMaxValue, minorTickSpace, majorTickSpace};
    }

    private void handleMouseEvent(MouseEvent EVT) {
        EventType TYPE = EVT.getEventType();
        double X = EVT.getX();
        double Y = EVT.getY();
        if (MouseEvent.MOUSE_PRESSED.equals(TYPE)) {
            this.selectedCategory = this.selectCategory(X, Y);
            double d = this.selectionStartY = null == this.selectedCategory ? -1.0 : Y;
            if (this.selectionStartY >= 30.0) {
                this.selectedObjects.clear();
                this.selectionRectCategory = this.selectedCategory;
                this.selectionRect.setX(this.selectionStartX);
                this.selectionRect.setY(Y);
                this.selectionRect.setWidth(0.0);
                this.selectionRect.setHeight(0.0);
                this.rect.setVisible(true);
                this.resizeSelectionRect();
            } else {
                this.rect.setVisible(false);
                this.dragText.setVisible(true);
                this.dragText.setText(this.selectedCategory);
                this.dragText.setX(X - this.dragText.getLayoutBounds().getWidth() * 0.5);
                this.dragText.setY(Y);
            }
            this.wasDragged = false;
        } else if (MouseEvent.MOUSE_DRAGGED.equals(TYPE)) {
            if (this.rect.isVisible()) {
                this.selectionRect.setHeight(Helper.clamp(this.selectionStartY, this.height - 0.5, Y) - this.selectionRect.getY());
                this.selectionRect.setWidth(10.0);
                this.resizeSelectionRect();
            } else if (this.dragText.isVisible()) {
                this.dragText.setX(X - this.dragText.getLayoutBounds().getWidth() * 0.5);
                this.dragText.setY(Y);
            }
            this.wasDragged = true;
        } else if (MouseEvent.MOUSE_RELEASED.equals(TYPE)) {
            if (this.dragText.isVisible() && this.wasDragged) {
                this.dragText.setVisible(false);
                String targetCategory = this.selectCategory(X, Y);
                if (null != targetCategory) {
                    this.shiftCategory(this.dragText.getText(), this.categories.indexOf(targetCategory));
                    this.selectionRect.setX(this.getAxisXOfCategory(this.selectionRectCategory) - 5.0);
                    this.redraw();
                }
            } else if (this.rect.isVisible() && this.wasDragged) {
                double d = this.selectionEndY = null == this.selectedCategory ? -1.0 : Helper.clamp(this.selectionStartY, this.height - 0.5, Y);
                if (this.selectionStartY > 30.0 && this.selectionEndY > -1.0) {
                    this.selectionRect.setWidth(10.0);
                    this.selectionRect.setY(this.selectionStartY);
                    this.selectionRect.setHeight(this.selectionEndY - this.selectionStartY);
                    this.selectObjectsAtCategory(this.selectedCategory, this.selectionStartY, this.selectionEndY);
                } else {
                    this.selectedItems.clear();
                }
            } else {
                this.selectedItems.clear();
                if (this.getSmoothConnections()) {
                    this.drawSmoothConnections();
                } else {
                    this.drawConnections();
                }
            }
            this.wasDragged = false;
        }
    }

    public void addChartEvtObserver(EvtType type, EvtObserver<ChartEvt> observer) {
        if (!this.observers.containsKey(type)) {
            this.observers.put(type, new CopyOnWriteArrayList());
        }
        if (this.observers.get(type).contains(observer)) {
            return;
        }
        this.observers.get(type).add(observer);
    }

    public void removeChartEvtObserver(EvtType type, EvtObserver<ChartEvt> observer) {
        if (this.observers.containsKey(type) && this.observers.get(type).contains(observer)) {
            this.observers.get(type).remove(observer);
        }
    }

    public void removeAllChartEvtObservers() {
        this.observers.clear();
    }

    public void fireChartEvt(ChartEvt evt) {
        EvtType type = evt.getEvtType();
        this.observers.entrySet().stream().filter(entry -> ((EvtType)entry.getKey()).equals(ChartEvt.ANY)).forEach(entry -> ((List)entry.getValue()).forEach(observer -> observer.handle((Evt)evt)));
        if (this.observers.containsKey(type) && !type.equals(ChartEvt.ANY)) {
            this.observers.get(type).forEach(observer -> observer.handle((Evt)evt));
        }
    }

    private void redraw() {
        this.drawAxis();
        if (this.getSmoothConnections()) {
            this.drawSmoothConnections();
        } else {
            this.drawConnections();
        }
    }

    private void drawAxis() {
        this.axisCtx.clearRect(0.0, 0.0, this.width, this.height);
        this.axisCtx.setTextBaseline(VPos.CENTER);
        int noOfCategories = this.categories.size();
        double availableWidth = this.width - 10.0;
        double availableHeight = this.height - 30.0 - 0.5;
        double axisHeight = this.height - 30.0 - 0.5;
        double halfAxisWidth = 5.0;
        double spacer = availableWidth / (double)(noOfCategories - 1);
        double headerFontSize = this.size * 0.025;
        double unitFontSize = this.size * 0.015;
        double axisFontSize = this.size * 0.0125;
        boolean tickMarksVisible = this.isTickMarksVisible();
        for (int i = 0; i < noOfCategories; ++i) {
            Locale locale = this.getLocale();
            String category = this.categories.get(i);
            String unit = this.categoryObjectMap.get(category).get(0).getProperties().get(category).getUnit();
            double axisX = (double)i * spacer + 5.0;
            double axisY = 30.0;
            double halfMajorTickLength = 3.0;
            double halfMediumTickLength = 2.0;
            double[] minMax = this.getMinMax(category);
            double[] axisParam = this.calcAutoScale(minMax[0], minMax[1]);
            double minValue = axisParam[0];
            double maxValue = axisParam[1];
            double range = maxValue - minValue;
            double minorTickSpace = axisParam[2];
            double majorTickSpace = axisParam[3];
            Font headerFont = Fonts.opensansRegular((double)Helper.clamp(8.0, 24.0, headerFontSize));
            double stepSize = Math.abs(axisHeight / range);
            double maxY = axisY + axisHeight;
            this.dragText.setFont(headerFont);
            if (i == 0) {
                this.axisCtx.setTextAlign(TextAlignment.LEFT);
            } else if (i == noOfCategories - 1) {
                this.axisCtx.setTextAlign(TextAlignment.RIGHT);
            } else {
                this.axisCtx.setTextAlign(TextAlignment.CENTER);
            }
            this.axisCtx.setFill((Paint)this.getHeaderColor());
            this.axisCtx.setFont(headerFont);
            this.axisCtx.fillText(category, axisX, 5.0);
            if (!unit.isEmpty()) {
                this.axisCtx.setFill((Paint)this.getUnitColor());
                this.axisCtx.setFont(Fonts.opensansRegular((double)Helper.clamp(8.0, 24.0, unitFontSize)));
                this.axisCtx.fillText(String.join((CharSequence)"", "[", unit, "]"), axisX, 18.0);
            }
            this.axisCtx.setStroke((Paint)this.getAxisColor());
            this.axisCtx.strokeLine(axisX, axisY, axisX, maxY);
            this.axisCtx.setFont(Fonts.opensansRegular((double)Helper.clamp(8.0, 24.0, axisFontSize)));
            this.axisCtx.setFill((Paint)this.getTickLabelColor());
            double tmpStep = minorTickSpace;
            BigDecimal minorTickSpaceBD = BigDecimal.valueOf(minorTickSpace);
            BigDecimal majorTickSpaceBD = BigDecimal.valueOf(majorTickSpace);
            BigDecimal mediumCheck2 = BigDecimal.valueOf(2.0 * minorTickSpace);
            BigDecimal mediumCheck5 = BigDecimal.valueOf(5.0 * minorTickSpace);
            BigDecimal counterBD = BigDecimal.valueOf(minValue);
            double counter = minValue;
            if (tickMarksVisible) {
                BigDecimal tmpStepBD = new BigDecimal(tmpStep);
                tmpStepBD = tmpStepBD.setScale(6, RoundingMode.HALF_UP);
                tmpStep = tmpStepBD.doubleValue();
                double j = 0.0;
                while (Double.compare(-range - tmpStep, j) <= 0) {
                    double fixedPosition = (counter - minValue) * stepSize + 30.0;
                    double innerPointX = axisX - halfMajorTickLength;
                    double innerPointY = fixedPosition;
                    double outerPointX = axisX + halfMajorTickLength;
                    double outerPointY = fixedPosition;
                    if (Double.compare(counterBD.setScale(12, RoundingMode.HALF_UP).remainder(majorTickSpaceBD).doubleValue(), 0.0) == 0) {
                        this.axisCtx.setStroke((Paint)Color.BLACK);
                        this.axisCtx.setLineWidth(1.0);
                        this.axisCtx.strokeLine(innerPointX, innerPointY, outerPointX, outerPointY);
                        double axisValue = maxValue - counter + minValue;
                        boolean isMinValue = Double.compare(minValue, axisValue) == 0;
                        boolean isMaxValue = Double.compare(maxValue, axisValue) == 0;
                        double offsetY = 0.0;
                        if (isMinValue) {
                            offsetY = -axisFontSize;
                        } else if (isMaxValue) {
                            offsetY = axisFontSize;
                        }
                        if (i == noOfCategories - 1) {
                            this.axisCtx.setTextAlign(TextAlignment.RIGHT);
                            this.axisCtx.fillText(String.format(locale, this.formatString, axisValue), axisX - halfAxisWidth, outerPointY + offsetY);
                        } else {
                            this.axisCtx.setTextAlign(TextAlignment.LEFT);
                            this.axisCtx.fillText(String.format(locale, this.formatString, axisValue), axisX + halfAxisWidth, outerPointY + offsetY);
                        }
                    } else if ((double)Double.compare(minorTickSpaceBD.setScale(12, RoundingMode.HALF_UP).remainder(mediumCheck2).doubleValue(), 0.0) != 0.0 && (double)Double.compare(counterBD.setScale(12, RoundingMode.HALF_UP).remainder(mediumCheck5).doubleValue(), 0.0) == 0.0) {
                        this.axisCtx.strokeLine(axisX - halfMediumTickLength, innerPointY, axisX + halfMediumTickLength, outerPointY);
                    }
                    counterBD = counterBD.add(minorTickSpaceBD);
                    counter = counterBD.doubleValue();
                    if (!(counter > maxValue)) {
                        j -= tmpStep;
                        continue;
                    }
                    break;
                }
            } else {
                this.axisCtx.strokeLine(axisX - 3.0, maxY, axisX + 3.0, maxY);
                this.axisCtx.strokeLine(axisX - 3.0, axisY, axisX + 3.0, axisY);
                this.axisCtx.setFont(Fonts.opensansRegular((double)Helper.clamp(8.0, 24.0, axisFontSize)));
                this.axisCtx.setFill((Paint)Color.BLACK);
                if (i == noOfCategories - 1) {
                    this.axisCtx.setTextAlign(TextAlignment.RIGHT);
                    this.axisCtx.fillText(String.format(locale, this.formatString, minValue), axisX - halfAxisWidth, maxY - axisFontSize);
                    this.axisCtx.fillText(String.format(locale, this.formatString, maxValue), axisX - halfAxisWidth, axisY + axisFontSize);
                } else {
                    this.axisCtx.setTextAlign(TextAlignment.LEFT);
                    this.axisCtx.fillText(String.format(locale, this.formatString, minValue), axisX + halfAxisWidth, maxY - axisFontSize);
                    this.axisCtx.fillText(String.format(locale, this.formatString, maxValue), axisX + halfAxisWidth, axisY + axisFontSize);
                }
            }
            this.categoryObjectMap.get(category).forEach(obj -> {
                ChartItem item = obj.getProperties().get(category);
                double itemY = (item.getValue() - minValue) * stepSize;
                item.setX(axisX);
                item.setY(maxY - itemY);
                Key key = new Key(category, (DataObject)obj);
                this.categoryObjectItemMap.put(key, item);
            });
        }
    }

    private void drawConnections() {
        this.connectionCtx.clearRect(0.0, 0.0, this.width, this.height);
        this.connectionCtx.setFont(Fonts.opensansRegular((double)Helper.clamp(8.0, 24.0, this.size * 0.015)));
        int noOfCategories = this.categories.size();
        Color selectedColor = this.getSelectedColor();
        Color unselectedColor = this.getUnselectedColor();
        this.items.forEach(obj -> {
            Color objStroke = obj.getStroke();
            Key key = new Key(this.categories.get(0), (DataObject)obj);
            ChartItem item = this.categoryObjectItemMap.get(key);
            double lastX = item.getX();
            double lastY = item.getY();
            for (int i = 1; i < noOfCategories; ++i) {
                String category = this.categories.get(i);
                key = new Key(category, (DataObject)obj);
                item = this.categoryObjectItemMap.get(key);
                if (this.selectedItems.size() > 0) {
                    this.connectionCtx.setStroke((Paint)(this.selectedItems.keySet().contains(obj.getName()) ? selectedColor : unselectedColor));
                    if (this.selectedItems.keySet().contains(obj.getName()) && category.equals(this.categories.get(1))) {
                        this.connectionCtx.fillText(obj.getName(), 10.0, lastY);
                    }
                } else {
                    this.connectionCtx.setStroke((Paint)objStroke);
                }
                this.connectionCtx.strokeLine(lastX, lastY, item.getX(), item.getY());
                lastX = item.getX();
                lastY = item.getY();
            }
        });
        if (this.selectedItems.size() > 0) {
            this.resizeSelectionRect();
            this.rect.setVisible(true);
        } else {
            this.rect.setVisible(false);
        }
    }

    private void drawSmoothConnections() {
        int noOfCategories = this.categories.size();
        double availableWidth = this.width - 10.0;
        double spacer = availableWidth / (double)(noOfCategories - 1);
        this.connectionCtx.clearRect(0.0, 0.0, this.width, this.height);
        this.connectionCtx.setFont(Fonts.opensansRegular((double)Helper.clamp(8.0, 24.0, this.size * 0.015)));
        Color selectedColor = this.getSelectedColor();
        Color unselectedColor = this.getUnselectedColor();
        for (DataObject obj : this.items) {
            Color objStroke = obj.getStroke();
            String firstCategory = this.categories.get(0);
            Key firstKey = new Key(firstCategory, obj);
            ChartItem firstItem = this.categoryObjectItemMap.get(firstKey);
            this.connectionCtx.beginPath();
            this.connectionCtx.moveTo(firstItem.getX(), firstItem.getY());
            for (int i = 1; i < noOfCategories; ++i) {
                String lastCategory = this.categories.get(i - 1);
                String category = this.categories.get(i);
                Key key = new Key(category, obj);
                Key lastKey = new Key(lastCategory, obj);
                ChartItem item = this.categoryObjectItemMap.get(key);
                ChartItem lastItem = this.categoryObjectItemMap.get(lastKey);
                if (this.selectedItems.size() > 0) {
                    this.connectionCtx.setStroke((Paint)(this.selectedItems.keySet().contains(obj.getName()) ? selectedColor : unselectedColor));
                    if (this.selectedItems.keySet().contains(obj.getName()) && category.equals(this.categories.get(1))) {
                        this.connectionCtx.fillText(obj.getName(), 10.0, lastItem.getY());
                    }
                } else {
                    this.connectionCtx.setStroke((Paint)objStroke);
                }
                this.connectionCtx.bezierCurveTo(lastItem.getX() + spacer * 0.25, lastItem.getY(), item.getX() - spacer * 0.25, item.getY(), item.getX(), item.getY());
            }
            this.connectionCtx.stroke();
        }
        if (this.selectedItems.size() > 0) {
            this.resizeSelectionRect();
            this.rect.setVisible(true);
        } else {
            this.rect.setVisible(false);
        }
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        double d = this.size = this.width < this.height ? this.width : this.height;
        if (this.width > 0.0 && this.height > 0.0) {
            double rectXFactor = this.selectionRect.getX() / this.connectionCanvas.getWidth();
            double rectYFactor = this.selectionRect.getY() / this.connectionCanvas.getHeight();
            double rectWFactor = this.selectionRect.getWidth() / this.connectionCanvas.getWidth();
            double rectHFactor = this.selectionRect.getHeight() / this.connectionCanvas.getHeight();
            this.axisCanvas.setWidth(this.width);
            this.axisCanvas.setHeight(this.height);
            this.axisCanvas.relocate((this.getWidth() - this.width) * 0.5, (this.getHeight() - this.height) * 0.5);
            this.connectionCanvas.setWidth(this.width);
            this.connectionCanvas.setHeight(this.height);
            this.connectionCanvas.relocate((this.getWidth() - this.width) * 0.5, (this.getHeight() - this.height) * 0.5);
            this.selectionRect.setX(this.width * rectXFactor);
            this.selectionRect.setY(this.height * rectYFactor);
            this.selectionRect.setWidth(this.width * rectWFactor);
            this.selectionRect.setHeight(this.height * rectHFactor);
            this.redraw();
        }
    }

    private class Key {
        private String category;
        private DataObject dataObject;

        public Key(String CATEGORY, DataObject DATA_OBJECT) {
            this.category = CATEGORY;
            this.dataObject = DATA_OBJECT;
        }

        public String getCategory() {
            return this.category;
        }

        public DataObject getDataObject() {
            return this.dataObject;
        }

        public boolean equals(Object OBJ) {
            if (!(OBJ instanceof Key)) {
                return false;
            }
            Key ref = (Key)OBJ;
            return this.category.equals(ref.getCategory()) && this.dataObject.equals(ref.getDataObject());
        }

        public int hashCode() {
            return this.category.hashCode() ^ this.dataObject.hashCode();
        }
    }
}

