/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.SectorChart;
import eu.hansolo.fx.charts.data.ChartItem;
import eu.hansolo.fx.charts.series.ChartItemSeries;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.scene.paint.Color;

public class SectorChartBuilder<B extends SectorChartBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected SectorChartBuilder() {
    }

    public static final SectorChartBuilder create() {
        return new SectorChartBuilder();
    }

    public final B allSeries(List<ChartItemSeries<ChartItem>> ALL_SERIES) {
        this.properties.put("allSeries", (Property)new SimpleObjectProperty(ALL_SERIES));
        return (B)this;
    }

    public final B itemTextVisible(boolean VISIBLE) {
        this.properties.put("itemTextVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B seriesTextVisible(boolean VISIBLE) {
        this.properties.put("seriesTextVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B seriesSumTextVisible(boolean VISIBLE) {
        this.properties.put("seriesSumTextVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B thresholdVisible(boolean VISIBLE) {
        this.properties.put("thresholdVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B threshold(double THRESHOLD) {
        this.properties.put("threshold", (Property)new SimpleDoubleProperty(THRESHOLD));
        return (B)this;
    }

    public final B decimals(int DECIMALS) {
        this.properties.put("decimals", (Property)new SimpleIntegerProperty(DECIMALS));
        return (B)this;
    }

    public final B gridColor(Color COLOR) {
        this.properties.put("gridColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B thresholdColor(Color COLOR) {
        this.properties.put("thresholdColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B prefSize(double WIDTH, double HEIGHT) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B minSize(double WIDTH, double HEIGHT) {
        this.properties.put("minSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B maxSize(double WIDTH, double HEIGHT) {
        this.properties.put("maxSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B prefWidth(double PREF_WIDTH) {
        this.properties.put("prefWidth", (Property)new SimpleDoubleProperty(PREF_WIDTH));
        return (B)this;
    }

    public final B prefHeight(double PREF_HEIGHT) {
        this.properties.put("prefHeight", (Property)new SimpleDoubleProperty(PREF_HEIGHT));
        return (B)this;
    }

    public final B minWidth(double MIN_WIDTH) {
        this.properties.put("minWidth", (Property)new SimpleDoubleProperty(MIN_WIDTH));
        return (B)this;
    }

    public final B minHeight(double MIN_HEIGHT) {
        this.properties.put("minHeight", (Property)new SimpleDoubleProperty(MIN_HEIGHT));
        return (B)this;
    }

    public final B maxWidth(double MAX_WIDTH) {
        this.properties.put("maxWidth", (Property)new SimpleDoubleProperty(MAX_WIDTH));
        return (B)this;
    }

    public final B maxHeight(double MAX_HEIGHT) {
        this.properties.put("maxHeight", (Property)new SimpleDoubleProperty(MAX_HEIGHT));
        return (B)this;
    }

    public final B scaleX(double SCALE_X) {
        this.properties.put("scaleX", (Property)new SimpleDoubleProperty(SCALE_X));
        return (B)this;
    }

    public final B scaleY(double SCALE_Y) {
        this.properties.put("scaleY", (Property)new SimpleDoubleProperty(SCALE_Y));
        return (B)this;
    }

    public final B layoutX(double LAYOUT_X) {
        this.properties.put("layoutX", (Property)new SimpleDoubleProperty(LAYOUT_X));
        return (B)this;
    }

    public final B layoutY(double LAYOUT_Y) {
        this.properties.put("layoutY", (Property)new SimpleDoubleProperty(LAYOUT_Y));
        return (B)this;
    }

    public final B translateX(double TRANSLATE_X) {
        this.properties.put("translateX", (Property)new SimpleDoubleProperty(TRANSLATE_X));
        return (B)this;
    }

    public final B translateY(double TRANSLATE_Y) {
        this.properties.put("translateY", (Property)new SimpleDoubleProperty(TRANSLATE_Y));
        return (B)this;
    }

    public final B padding(Insets INSETS) {
        this.properties.put("padding", (Property)new SimpleObjectProperty((Object)INSETS));
        return (B)this;
    }

    public final SectorChart build() {
        SectorChart sectorChart = this.properties.containsKey("allSeries") ? new SectorChart((List)((ObjectProperty)this.properties.get("allSeries")).get()) : new SectorChart();
        Iterator<String> iterator = this.properties.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = iterator.next()) {
                case "prefSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    sectorChart.setPrefSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "minSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    sectorChart.setMinSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "maxSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    sectorChart.setMaxSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "prefWidth": {
                    sectorChart.setPrefWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "prefHeight": {
                    sectorChart.setPrefHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "minWidth": {
                    sectorChart.setMinWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "minHeight": {
                    sectorChart.setMinHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "maxWidth": {
                    sectorChart.setMaxWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "maxHeight": {
                    sectorChart.setMaxHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "scaleX": {
                    sectorChart.setScaleX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "scaleY": {
                    sectorChart.setScaleY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "layoutX": {
                    sectorChart.setLayoutX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "layoutY": {
                    sectorChart.setLayoutY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "translateX": {
                    sectorChart.setTranslateX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "translateY": {
                    sectorChart.setTranslateY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "padding": {
                    sectorChart.setPadding((Insets)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "itemTextVisible": {
                    sectorChart.setItemTextVisible(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "seriesTextVisible": {
                    sectorChart.setSeriesTextVisible(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "seriesSumTextVisible": {
                    sectorChart.setSeriesSumTextVisible(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "thresholdVisible": {
                    sectorChart.setThresholdVisible(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "threshold": {
                    sectorChart.setThreshold(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "decimals": {
                    sectorChart.setDecimals(((IntegerProperty)this.properties.get(key)).get());
                    break;
                }
                case "gridColor": {
                    sectorChart.setGridColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "thresholdColor": {
                    sectorChart.setThresholdColor((Color)((ObjectProperty)this.properties.get(key)).get());
                }
            }
        }
        return sectorChart;
    }
}

