/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.pareto;

import eu.hansolo.fx.charts.Axis;
import eu.hansolo.fx.charts.Position;
import eu.hansolo.fx.charts.pareto.ParetoBar;
import eu.hansolo.fx.charts.pareto.ParetoInfoPopup;
import eu.hansolo.fx.charts.pareto.ParetoModel;
import eu.hansolo.fx.charts.tools.Helper;
import eu.hansolo.toolboxfx.font.Fonts;
import eu.hansolo.toolboxfx.geom.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Observer;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;

public class ParetoPanel
extends Region {
    private static final double PREFERRED_WIDTH = 600.0;
    private static final double PREFERRED_HEIGHT = 600.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 2048.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private double width;
    private double height;
    private Canvas canvas;
    private GraphicsContext ctx;
    private EventHandler<MouseEvent> mouseHandler;
    private ParetoModel paretoModel;
    private DoubleProperty barSpacing;
    private double _barSpacing;
    private double yZero;
    private int chartFontSize;
    private double _dataDotSize;
    private DoubleProperty dataDotSize;
    private Stack<ParetoModel> modelStack;
    private BooleanProperty smoothPercentageCurve;
    private boolean _smoothPercentageCurve;
    private BooleanProperty useCalculatedSubBarColors;
    private boolean _useCalculatedSubBarColors;
    private BooleanProperty showSubBars;
    private boolean _showSubBars;
    private BooleanProperty singleSubBarCentered;
    private boolean _singelSubBarCentered;
    private int decimals = 1;
    private String numberFormat = "%." + this.decimals + "f";
    private double fontSize;
    private double _valueFontYPosition;
    private DoubleProperty valueFontYPosition;
    private double _identifierFontYPosition;
    private DoubleProperty identifierFontYPosition;
    private double _pathFontYPositon;
    private DoubleProperty pathFontYPosition;
    private Axis yAxisLeft;
    private Axis yAxisRight;
    private List<DataDot> dataDots;
    private ParetoInfoPopup popup;
    private ObjectProperty<Axis> yAxisRightProperty;
    private ObjectProperty<Axis> yAxisLeftProperty;
    private DoubleProperty maxValue;
    private AnchorPane textPane;
    private BorderPane bPane;
    private Canvas labelingCanvas;
    private GraphicsContext labelingCtx;
    private Color _labelingColor;
    private ObjectProperty<Color> labelingColor;
    private Font _labelingFont = Fonts.opensansRegular((double)10.0);
    private ObjectProperty<Font> labelingFont;
    private Color _percentageLineDataDotColor;
    private ObjectProperty<Color> percentageLineDataDotColor;
    private Color _percentageLineColor;
    private ObjectProperty<Color> percentageLineColor;
    private HashMap<String, ArrayList<Color>> colorThemes;
    private boolean delayRedraw;
    private ArrayList<Observer> observerList;

    public ParetoPanel(ParetoModel MODEL) {
        this.paretoModel = MODEL;
        this.init();
    }

    private void init() {
        this.modelStack = new Stack();
        this.dataDots = new ArrayList<DataDot>();
        this.popup = new ParetoInfoPopup();
        this.mouseHandler = this::handleMouseEvents;
        this.modelStack.push(this.paretoModel);
        this._labelingColor = Color.BLACK;
        this._singelSubBarCentered = true;
        this.initGraphics();
        this.registerListeners();
        this.colorThemes = new HashMap();
        ArrayList<Color> defaultColorTheme = new ArrayList<Color>();
        defaultColorTheme.add(Color.BLUE);
        this.colorThemes.putIfAbsent("Default", defaultColorTheme);
        this._valueFontYPosition = 20.0;
        this._identifierFontYPosition = 40.0;
        this._pathFontYPositon = 65.0;
        this._percentageLineDataDotColor = Color.BLACK;
        this._percentageLineColor = Color.BLACK;
        this._useCalculatedSubBarColors = true;
        this._smoothPercentageCurve = false;
        this._showSubBars = true;
        this.textPane = new AnchorPane();
        this.yAxisLeft = Helper.createLeftAxis(0.0, this.paretoModel.getTotal(), false, 80.0);
        this.yAxisRight = Helper.createRightAxis(0.0, 100.0, true, 80.0);
        this.maxValue = new DoublePropertyBase(this.paretoModel.getTotal()){

            public Object getBean() {
                return ParetoPanel.this;
            }

            public String getName() {
                return "maxValue";
            }
        };
        this.yAxisLeft.setTitle(this.paretoModel.getTitle());
        this.yAxisLeft.setTitleFontSize(30.0);
        this.yAxisRight.setTitleFontSize(30.0);
        this.yAxisRight.setUnit("\\u0025");
        this.yAxisLeft.maxValueProperty().bindBidirectional((Property)this.maxValue);
        this.yAxisRight.setPosition(Position.CENTER);
        this.bPane = new BorderPane();
        this.bPane.setPrefWidth(this.yAxisRight.getWidth() + this.canvas.getWidth() + this.yAxisRight.getWidth());
        this.bPane.setCenter((Node)this.canvas);
        this.yAxisRightProperty = new ObjectPropertyBase<Axis>(this.yAxisRight){

            public Object getBean() {
                return ParetoPanel.this;
            }

            public String getName() {
                return "yAxisRight";
            }
        };
        this.yAxisLeftProperty = new ObjectPropertyBase<Axis>(this.yAxisLeft){

            public Object getBean() {
                return ParetoPanel.this;
            }

            public String getName() {
                return "yAxisLeft";
            }
        };
        this.bPane.rightProperty().bind(this.yAxisRightProperty);
        this.bPane.leftProperty().bind(this.yAxisLeftProperty);
        this._barSpacing = 5.0;
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        this.bPane.setMaxSize(this.width, this.height);
        this.bPane.setPrefSize(this.width, this.height);
        this.canvas.setWidth(this.width - this.yAxisRight.getWidth() - this.yAxisLeft.getWidth());
        this.textPane.setMaxHeight(80.0);
        this.textPane.setMinHeight(80.0);
        StackPane test = new StackPane();
        test.setPrefHeight(80.0);
        this.labelingCanvas = new Canvas();
        this.labelingCanvas.setHeight(80.0);
        this.labelingCtx = this.labelingCanvas.getGraphicsContext2D();
        this.delayRedraw = false;
        this.bPane.setBottom((Node)this.labelingCanvas);
        this.getChildren().setAll((Object[])new Node[]{this.bPane});
        this.drawParetoChart();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(600.0, 600.0);
            }
        }
        this.width = 600.0;
        this.height = 600.0;
        this.canvas = new Canvas();
        this.ctx = this.canvas.getGraphicsContext2D();
        this._smoothPercentageCurve = true;
        this._dataDotSize = 20.0;
        this.chartFontSize = 20;
        this.yZero = this.height;
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
        this.canvas.addEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseHandler);
        this.canvas.addEventHandler(MouseEvent.MOUSE_DRAGGED, this.mouseHandler);
        this.canvas.addEventHandler(MouseEvent.MOUSE_RELEASED, this.mouseHandler);
        this.canvas.setFocusTraversable(true);
        this.addChangeListenerToParetobarRecursiv(this.paretoModel.getData());
    }

    private void addChangeListenerToParetobarRecursiv(List<ParetoBar> bars) {
        for (ParetoBar bar : bars) {
            if (null != bar.getBars() && !bar.getBars().isEmpty()) {
                this.addChangeListenerToParetobarRecursiv(bar.getBars());
            }
            bar.fillColorProperty().addListener(observable -> {
                if (!this.delayRedraw) {
                    this.drawParetoChart();
                }
            });
        }
    }

    public void layoutChildren() {
        super.layoutChildren();
    }

    protected double computeMinWidth(double HEIGHT) {
        return 50.0;
    }

    protected double computeMinHeight(double WIDTH) {
        return 50.0;
    }

    protected double computePrefWidth(double HEIGHT) {
        return super.computePrefWidth(HEIGHT);
    }

    protected double computePrefHeight(double WIDTH) {
        return super.computePrefHeight(WIDTH);
    }

    protected double computeMaxWidth(double HEIGHT) {
        return 2048.0;
    }

    protected double computeMaxHeight(double WIDTH) {
        return 1024.0;
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public void dispose() {
        this.canvas.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseHandler);
        this.canvas.removeEventHandler(MouseEvent.MOUSE_DRAGGED, this.mouseHandler);
        this.canvas.removeEventHandler(MouseEvent.MOUSE_RELEASED, this.mouseHandler);
    }

    private boolean insideBar(double X, double Y, ParetoBar BAR) {
        return BAR.getX() <= X && X <= BAR.getX() + BAR.getWidth() && BAR.getY() <= Y && Y <= BAR.getY() + BAR.getHeight();
    }

    private boolean insideDataDot(double X, double Y, DataDot DATA_DOT) {
        return (X - DATA_DOT.getX()) * (X - DATA_DOT.getX()) + (Y - DATA_DOT.getY()) * (Y - DATA_DOT.getY()) < this.getDataDotSize() / 2.0 * (this.getDataDotSize() / 2.0);
    }

    private void handleMouseEvents(MouseEvent EVT) {
        EventType TYPE = EVT.getEventType();
        double X = EVT.getX();
        double Y = EVT.getY();
        if (MouseEvent.MOUSE_PRESSED.equals(TYPE)) {
            for (DataDot dot : this.dataDots) {
                if (!this.insideDataDot(X, Y, dot)) continue;
                this.showPopup(EVT.getScreenX(), EVT.getScreenY(), dot);
                return;
            }
            for (ParetoBar bar : this.paretoModel.getData()) {
                if (!this.insideBar(X, Y, bar)) continue;
                if (EVT.isShiftDown()) {
                    this.filterChartByBar(bar);
                    break;
                }
                this.cascadeIntoBar(bar);
                break;
            }
        }
    }

    private void showPopup(double X, double Y, DataDot DATA_DOT) {
        String[] labels = new String[]{"Total Prozent", "Total Wert"};
        String[] values = new String[2];
        double percentage = DATA_DOT.value / this.paretoModel.getTotal() * 100.0;
        values[0] = Double.toString((double)Math.round(percentage * 100.0) / 100.0);
        values[1] = Double.toString((double)Math.round(DATA_DOT.value * 100.0) / 100.0);
        this.popup.update(labels, values);
        this.popup.setX(X + 15.0);
        this.popup.setY(Y);
        this.popup.animatedShow(this.getScene().getWindow());
    }

    private void hidePopup() {
        this.popup.setOpacity(0.0);
        this.popup.animatedHide();
    }

    private void filterChartByBar(ParetoBar BAR) {
        this.modelStack.push(this.paretoModel);
        ParetoModel model = new ParetoModel(this.paretoModel);
        List<ParetoBar> bars = model.getData().stream().filter(bar2 -> bar2 != BAR).collect(Collectors.toList());
        model.setData(bars);
        this.paretoModel = model;
        this.maxValue.setValue((Number)this.paretoModel.getTotal());
        this.drawParetoChart();
    }

    private void cascadeIntoBar(ParetoBar BAR) {
        if (null == BAR.getBars() || BAR.getBars().isEmpty()) {
            return;
        }
        this.modelStack.push(this.paretoModel);
        ParetoModel model = new ParetoModel(this.paretoModel);
        model.setData(BAR.getBars());
        model.setTitle(this.paretoModel.getTitle() + " / " + BAR.getName());
        this.paretoModel = model;
        this.maxValue.setValue((Number)this.paretoModel.getTotal());
        this.drawParetoChart();
        this.modelChanged();
    }

    private void drawBarsAndLine() {
        ArrayList<ParetoBar> entryList = this.paretoModel.getData();
        double total = this.yAxisLeft.getMaxValue();
        double xStartPosition = this.canvas.getWidth() / (double)this.paretoModel.getData().size() / 100.0 * this.getBarSpacing();
        double barWidth = this.canvas.getWidth() / (double)this.paretoModel.getData().size() - this.canvas.getWidth() / (double)this.paretoModel.getData().size() / 100.0 * this.getBarSpacing() / (double)this.paretoModel.getData().size() * (double)(this.paretoModel.getData().size() + 1);
        double heightPerUnit = this.height / Math.ceil(total);
        entryList.sort((c1, c2) -> {
            if (c1.getValue() == c2.getValue()) {
                return 0;
            }
            return c1.getValue() > c2.getValue() ? -1 : 1;
        });
        Iterator it = entryList.iterator();
        Point[] points = new Point[entryList.size()];
        double sumUp = 0.0;
        int i = 0;
        while (it.hasNext()) {
            ParetoBar bar = (ParetoBar)it.next();
            double barHeight = heightPerUnit * bar.getValue();
            sumUp += bar.getValue().doubleValue();
            Color barColor = bar.getFillColor();
            this.ctx.save();
            this.ctx.setFill((Paint)barColor);
            this.ctx.strokeRect(xStartPosition, this.yZero - barHeight, barWidth, barHeight);
            this.ctx.fillRect(xStartPosition, this.yZero - barHeight, barWidth, barHeight);
            this.ctx.restore();
            if (null != bar.getBars() && !bar.getBars().isEmpty()) {
                double noOfSubBars = bar.getBars().size();
                double subBarWidth = barWidth / noOfSubBars;
                double stepX = 0.0;
                Color subBarColor = barColor;
                if (this.isShowSubBars()) {
                    for (ParetoBar subBar : bar.getBars()) {
                        double subBarHeight = heightPerUnit * subBar.getValue();
                        this.ctx.save();
                        if (this.isUseCalculatedSubBarColors()) {
                            subBarColor = Helper.isBright(barColor) ? Color.hsb((double)subBarColor.getHue(), (double)Helper.clamp(0.0, 1.0, subBarColor.getSaturation() * 1.75), (double)Helper.clamp(0.0, 1.0, subBarColor.getBrightness() * 0.75)) : Color.hsb((double)subBarColor.getHue(), (double)Helper.clamp(0.0, 1.0, subBarColor.getSaturation() * 0.75), (double)Helper.clamp(0.0, 1.0, subBarColor.getBrightness() * 1.75));
                            this.ctx.setFill((Paint)subBarColor);
                        } else {
                            this.ctx.setFill((Paint)subBar.getFillColor());
                        }
                        if (bar.getBars().size() > 1 || !this.getSingleSubBarCentered()) {
                            this.ctx.fillRect(xStartPosition + stepX, this.yZero - subBarHeight, subBarWidth, subBarHeight);
                            this.ctx.restore();
                            stepX += subBarWidth;
                            continue;
                        }
                        this.ctx.fillRect(xStartPosition + stepX + subBarWidth / 4.0, this.yZero - subBarHeight, subBarWidth / 2.0, subBarHeight);
                    }
                }
            }
            bar.setX(xStartPosition);
            bar.setY(this.yZero - barHeight);
            bar.setWidth(barWidth);
            bar.setHeight(barHeight);
            double minValueTextHeight = this.yZero - barHeight / 2.0;
            if (minValueTextHeight > this.yZero - (double)(this.chartFontSize * 2)) {
                minValueTextHeight = this.yZero - (double)(this.chartFontSize * 2);
            }
            this.labelingCtx.setFill((Paint)(this.labelingColor != null ? (Paint)this.labelingColor.getValue() : this._labelingColor));
            this.labelingCtx.setFont(this.labelingFont != null ? (Font)this.labelingFont.getValue() : this._labelingFont);
            this.labelingCtx.setTextAlign(TextAlignment.CENTER);
            this.labelingCtx.fillText(String.format(Locale.US, this.numberFormat, bar.getValue()), xStartPosition + 80.0 + barWidth / 2.0, this.getValueFontYPosition(), barWidth);
            this.labelingCtx.fillText(bar.getName(), xStartPosition + 80.0 + barWidth / 2.0, this.getIdentifierFontYPosition(), barWidth);
            points[i] = new Point(xStartPosition + barWidth / 2.0, this.yZero - this.height * (sumUp / total));
            this.dataDots.add(new DataDot(points[i].getX(), points[i].getY(), sumUp));
            ++i;
            xStartPosition += this.canvas.getWidth() / (double)this.paretoModel.getData().size() / 100.0 * this.getBarSpacing() + barWidth;
        }
        this.labelingCtx.setFont(this.labelingFont != null ? (Font)this.labelingFont.getValue() : this._labelingFont);
        this.labelingCtx.fillText(this.paretoModel.getTitle(), this.width / 2.0, this.getPathFontYPositon(), this.width);
        this.ctx.setLineWidth(3.0);
        this.ctx.setStroke((Paint)this.getPercentageLineColor());
        if (this.isSmoothPercentageCurve()) {
            Point[] newPoints = Helper.subdividePoints(points, 10);
            for (int j = 1; j < newPoints.length; ++j) {
                this.ctx.strokeLine(newPoints[j - 1].getX(), newPoints[j - 1].getY(), newPoints[j].getX(), newPoints[j].getY());
            }
        } else {
            for (int j = 1; j < points.length; ++j) {
                this.ctx.strokeLine(points[j - 1].getX(), points[j - 1].getY(), points[j].getX(), points[j].getY());
            }
        }
        this.ctx.setFill((Paint)this.getPercentageLineDataDotColor());
        for (int j = 0; j < points.length; ++j) {
            this.ctx.fillOval(points[j].getX() - this.getDataDotSize() / 2.0, points[j].getY() - this.getDataDotSize() / 2.0, this.getDataDotSize(), this.getDataDotSize());
        }
    }

    private void drawParetoChart() {
        this.ctx.clearRect(0.0, 0.0, this.width, this.height);
        this.labelingCtx.clearRect(0.0, 0.0, this.labelingCanvas.getWidth(), this.labelingCanvas.getHeight());
        this.ctx.strokeRect(0.0, 0.0, this.width, this.height);
        this.ctx.setStroke((Paint)Color.BLACK);
        this.ctx.setFill((Paint)Color.BLUE);
        this.ctx.setTextAlign(TextAlignment.CENTER);
        this.ctx.setFont(new Font((double)this.chartFontSize));
        this.drawBarsAndLine();
    }

    private void modelChanged() {
        if (null != this.observerList && !this.observerList.isEmpty()) {
            for (Observer observer : this.observerList) {
                observer.update(null, null);
            }
        }
    }

    private void activateColorThemeRecursive(List<ParetoBar> BARS, String NAME) {
        int i = 0;
        for (ParetoBar bar : BARS) {
            if (i >= this.colorThemes.get(NAME).size()) {
                i = 0;
            }
            bar.setFillColor(this.colorThemes.get(NAME).get(i++));
            if (null == bar.getBars() || bar.getBars().isEmpty()) continue;
            this.activateColorThemeRecursive(bar.getBars(), NAME);
        }
    }

    public void returnToPreviousLayer() {
        if (!this.modelStack.empty()) {
            this.paretoModel = this.modelStack.pop();
            this.maxValue.setValue((Number)this.paretoModel.getTotal());
            this.drawParetoChart();
            this.modelChanged();
        }
    }

    public void addColorTheme(String NAME, List<Color> COLOR_THEME) {
        if (null == this.colorThemes) {
            this.colorThemes = new HashMap();
        }
        this.colorThemes.put(NAME, new ArrayList<Color>(COLOR_THEME));
    }

    public Set<String> getColorThemeKeys() {
        return this.colorThemes.keySet();
    }

    public void activateColorTheme(String NAME) {
        if (this.colorThemes.containsKey(NAME)) {
            this.delayRedraw = true;
            this.activateColorThemeRecursive(this.paretoModel.getData(), NAME);
            this.delayRedraw = false;
            this.drawParetoChart();
        } else {
            this.delayRedraw = true;
            this.activateColorThemeRecursive(this.paretoModel.getData(), NAME);
            this.delayRedraw = false;
            this.drawParetoChart();
        }
    }

    public Color getFontColor() {
        return null != this.labelingColor ? (Color)this.labelingColor.getValue() : this._labelingColor;
    }

    public void setFontColor(Color COLOR) {
        if (null != this.labelingColor) {
            this._labelingColor = COLOR;
            this.drawParetoChart();
        } else {
            this.labelingColor.setValue((Object)COLOR);
        }
    }

    public ObjectProperty<Color> fontColorProperty() {
        if (null == this.labelingColor) {
            this.labelingColor = new SimpleObjectProperty((Object)this._labelingColor);
            this.labelingColor.addListener(observable -> this.drawParetoChart());
        }
        return this.labelingColor;
    }

    public Font getFont() {
        return null != this.labelingFont ? (Font)this.labelingFont.getValue() : this._labelingFont;
    }

    public void setFont(Font FONT) {
        if (null == this.labelingFont) {
            this._labelingFont = FONT;
            this.drawParetoChart();
        } else {
            this.labelingFont.setValue((Object)FONT);
        }
    }

    public ObjectProperty<Font> fontProperty() {
        if (null == this.labelingFont) {
            this.labelingFont = new SimpleObjectProperty((Object)this._labelingFont);
            this.labelingFont.addListener(observable -> this.drawParetoChart());
        }
        return this.labelingFont;
    }

    public boolean isSmoothPercentageCurve() {
        return null != this.smoothPercentageCurve ? this.smoothPercentageCurve.getValue() : this._smoothPercentageCurve;
    }

    public void setSmoothPercentageCurve(boolean SMOOTHED) {
        if (null == this.smoothPercentageCurve) {
            this._smoothPercentageCurve = SMOOTHED;
            this.drawParetoChart();
        } else {
            this.smoothPercentageCurve.setValue(Boolean.valueOf(SMOOTHED));
        }
    }

    public BooleanProperty smoothPercentageCurveProperty() {
        if (null == this.smoothPercentageCurve) {
            this.smoothPercentageCurve = new SimpleBooleanProperty(this._smoothPercentageCurve);
            this.smoothPercentageCurve.addListener(observable -> this.drawParetoChart());
        }
        return this.smoothPercentageCurve;
    }

    public double getValueFontYPosition() {
        return null != this.valueFontYPosition ? this.valueFontYPosition.doubleValue() : this._valueFontYPosition;
    }

    public void setValueFontYPosition(double POSITION) {
        if (null == this.valueFontYPosition) {
            this._valueFontYPosition = POSITION;
            this.drawParetoChart();
        } else {
            this.valueFontYPosition.setValue((Number)POSITION);
        }
    }

    public DoubleProperty valueFontYPositionProperty() {
        if (null == this.valueFontYPosition) {
            this.valueFontYPosition = new SimpleDoubleProperty(this._valueFontYPosition);
            this.valueFontYPosition.addListener(observable -> this.drawParetoChart());
        }
        return this.valueFontYPosition;
    }

    public double getIdentifierFontYPosition() {
        return null != this.identifierFontYPosition ? this.identifierFontYPosition.doubleValue() : this._identifierFontYPosition;
    }

    public void setIdentifierFontYPosition(double POSITION) {
        if (null == this.identifierFontYPosition) {
            this._identifierFontYPosition = POSITION;
            this.drawParetoChart();
        } else {
            this.identifierFontYPosition.setValue((Number)POSITION);
        }
    }

    public DoubleProperty identifierFontYPositionProperty() {
        if (null == this.identifierFontYPosition) {
            this.identifierFontYPosition = new SimpleDoubleProperty(this._identifierFontYPosition);
            this.identifierFontYPosition.addListener(observable -> this.drawParetoChart());
        }
        return this.identifierFontYPosition;
    }

    public double getPathFontYPositon() {
        return null != this.pathFontYPosition ? this.pathFontYPosition.getValue() : this._pathFontYPositon;
    }

    public void setPathFontYPosition(double POSITION) {
        if (null == this.pathFontYPosition) {
            this._pathFontYPositon = POSITION;
            this.drawParetoChart();
        } else {
            this.pathFontYPosition.setValue((Number)POSITION);
        }
    }

    public DoubleProperty pathFontYPositionProperty() {
        if (null == this.pathFontYPosition) {
            this.pathFontYPosition = new SimpleDoubleProperty(this._pathFontYPositon);
            this.pathFontYPosition.addListener(observable -> this.drawParetoChart());
        }
        return this.pathFontYPosition;
    }

    public double getDataDotSize() {
        return null != this.dataDotSize ? this.dataDotSize.doubleValue() : this._dataDotSize;
    }

    public void setDataDotSize(double DOT_SIZE) {
        if (null == this.dataDotSize) {
            this._dataDotSize = DOT_SIZE;
            this.drawParetoChart();
        } else {
            this.dataDotSize.setValue((Number)DOT_SIZE);
        }
    }

    public DoubleProperty dataDotSizeProperty() {
        if (null == this.dataDotSize) {
            this.dataDotSize = new SimpleDoubleProperty(this._dataDotSize);
            this.dataDotSize.addListener(observable -> this.drawParetoChart());
        }
        return this.dataDotSize;
    }

    public ParetoModel getParetoModel() {
        return this.paretoModel;
    }

    public double getBarSpacing() {
        return null != this.barSpacing ? this.barSpacing.doubleValue() : this._barSpacing;
    }

    public void setBarSpacing(double SPACING) {
        if (null == this.barSpacing) {
            this._barSpacing = SPACING;
            this.drawParetoChart();
        } else {
            this.barSpacing.setValue((Number)SPACING);
        }
    }

    public DoubleProperty barSpacingProperty() {
        if (null == this.barSpacing) {
            this.barSpacing = new SimpleDoubleProperty(this._barSpacing);
            this.barSpacing.addListener(observable -> this.drawParetoChart());
        }
        return this.barSpacing;
    }

    public Color getPercentageLineDataDotColor() {
        return null != this.percentageLineDataDotColor ? (Color)this.percentageLineDataDotColor.getValue() : this._percentageLineDataDotColor;
    }

    public void setPercentageLineDataDotColor(Color COLOR) {
        if (null == this.percentageLineDataDotColor) {
            this._percentageLineDataDotColor = COLOR;
            this.drawParetoChart();
        } else {
            this.percentageLineDataDotColor.setValue((Object)COLOR);
        }
    }

    public ObjectProperty<Color> percentageLineDataDotColorProperty() {
        if (null == this.percentageLineDataDotColor) {
            this.percentageLineDataDotColor = new ObjectPropertyBase<Color>(this._percentageLineDataDotColor){

                public Object getBean() {
                    return ParetoPanel.this;
                }

                public String getName() {
                    return "percentageLineDataDotColor";
                }
            };
            this._percentageLineDataDotColor = null;
            this.percentageLineDataDotColor.addListener(observable -> this.drawParetoChart());
        }
        return this.percentageLineDataDotColor;
    }

    public Color getPercentageLineColor() {
        return null != this.percentageLineColor ? (Color)this.percentageLineColor.getValue() : this._percentageLineColor;
    }

    public void setPercentageLineColor(Color COLOR) {
        if (null == this.percentageLineColor) {
            this._percentageLineColor = COLOR;
            this.drawParetoChart();
        } else {
            this.percentageLineColor.setValue((Object)COLOR);
        }
    }

    public ObjectProperty<Color> percentageLineColorProperty() {
        if (null == this.percentageLineColor) {
            this.percentageLineColor = new ObjectPropertyBase<Color>(){

                public Object getBean() {
                    return ParetoPanel.this;
                }

                public String getName() {
                    return "percentageLineColor";
                }
            };
            this._percentageLineColor = null;
            this.percentageLineColor.addListener(observable -> this.drawParetoChart());
        }
        return this.percentageLineColor;
    }

    public boolean isUseCalculatedSubBarColors() {
        return null != this.useCalculatedSubBarColors ? this.useCalculatedSubBarColors.getValue() : this._useCalculatedSubBarColors;
    }

    public BooleanProperty useCalculatedSubBarColorsProperty() {
        if (null == this.useCalculatedSubBarColors) {
            this.useCalculatedSubBarColors = new BooleanPropertyBase(this._useCalculatedSubBarColors){

                public Object getBean() {
                    return ParetoPanel.this;
                }

                public String getName() {
                    return "useCalculatedSubBarColors";
                }
            };
            this.useCalculatedSubBarColors.addListener(observable -> this.drawParetoChart());
        }
        return this.useCalculatedSubBarColors;
    }

    public boolean isShowSubBars() {
        return null != this.showSubBars ? this.showSubBars.getValue() : this._showSubBars;
    }

    public void setShowSubBars(boolean SHOW) {
        if (null != this.showSubBars) {
            this.showSubBars.setValue(Boolean.valueOf(SHOW));
        } else {
            this._showSubBars = SHOW;
            this.drawParetoChart();
        }
    }

    public BooleanProperty showSubBarsProperty() {
        if (null == this.showSubBars) {
            this.showSubBars = new SimpleBooleanProperty(this._showSubBars);
            this.showSubBars.addListener(observable -> this.drawParetoChart());
        }
        return this.showSubBars;
    }

    public boolean getSingleSubBarCentered() {
        return null != this.singleSubBarCentered ? this.singleSubBarCentered.getValue() : this._singelSubBarCentered;
    }

    public void setSingleSubBarCentered(boolean CENTERED) {
        if (null == this.singleSubBarCentered) {
            this._singelSubBarCentered = CENTERED;
        } else {
            this.singleSubBarCentered.setValue(Boolean.valueOf(CENTERED));
        }
    }

    public BooleanProperty singleSubBarCenteredProperty() {
        if (null == this.singleSubBarCentered) {
            this.singleSubBarCentered = new BooleanPropertyBase(this._singelSubBarCentered){

                public Object getBean() {
                    return ParetoPanel.this;
                }

                public String getName() {
                    return "singleSubBarCentered";
                }
            };
            this.singleSubBarCentered.addListener(observable -> this.drawParetoChart());
        }
        return this.singleSubBarCentered;
    }

    public void addAndActivatedColorTheme(String NAME, List<Color> THEME) {
        this.addColorTheme(NAME, THEME);
        this.activateColorTheme(NAME);
    }

    public void setUseCalculatedSubBarColors(boolean USE) {
        if (null == this.useCalculatedSubBarColors) {
            this._useCalculatedSubBarColors = USE;
            this.drawParetoChart();
        } else {
            this.useCalculatedSubBarColors.setValue(Boolean.valueOf(USE));
        }
    }

    public void addObserver(Observer observer) {
        if (null == this.observerList) {
            this.observerList = new ArrayList();
        }
        this.observerList.add(observer);
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom() - 80.0;
        if (this.width > 0.0 && this.height > 0.0) {
            this.bPane.setMaxSize(this.width, this.height);
            this.bPane.setPrefSize(this.width, this.height);
            this.canvas.setWidth(this.width - this.yAxisRight.getWidth() - this.yAxisLeft.getWidth());
            this.labelingCanvas.setWidth(this.width);
            this.canvas.setHeight(this.height);
            this.yZero = this.height;
            this.fontSize = this.height * 0.035;
            this.drawParetoChart();
        }
    }

    private class DataDot {
        private double x;
        private double y;
        private double value;

        DataDot(double x, double y, double value) {
            this.x = x;
            this.y = y;
            this.value = value;
        }

        double getX() {
            return this.x;
        }

        public void setX(double x) {
            this.x = x;
        }

        double getY() {
            return this.y;
        }

        public void setY(double y) {
            this.y = y;
        }

        public double getValue() {
            return this.value;
        }

        public void setValue(double value) {
            this.value = value;
        }
    }
}

