/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.series;

import eu.hansolo.fx.charts.ChartType;
import eu.hansolo.fx.charts.Symbol;
import eu.hansolo.fx.charts.data.Item;
import eu.hansolo.fx.charts.data.ValueItem;
import eu.hansolo.fx.charts.series.YSeries;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class YSeriesBuilder<B extends YSeriesBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected YSeriesBuilder() {
    }

    public static final YSeriesBuilder create() {
        return new YSeriesBuilder();
    }

    public final B items(ValueItem ... ITEMS) {
        this.properties.put("itemsArray", (Property)new SimpleObjectProperty((Object)ITEMS));
        return (B)this;
    }

    public final B items(List<ValueItem> ITEMS) {
        this.properties.put("itemsList", (Property)new SimpleObjectProperty(ITEMS));
        return (B)this;
    }

    public final B name(String NAME) {
        this.properties.put("name", (Property)new SimpleStringProperty(NAME));
        return (B)this;
    }

    public final B fill(Paint FILL) {
        this.properties.put("fill", (Property)new SimpleObjectProperty((Object)FILL));
        return (B)this;
    }

    public final B stroke(Paint STROKE) {
        this.properties.put("stroke", (Property)new SimpleObjectProperty((Object)STROKE));
        return (B)this;
    }

    public final B textFill(Color FILL) {
        this.properties.put("textFill", (Property)new SimpleObjectProperty((Object)FILL));
        return (B)this;
    }

    public final B symbolFill(Color FILL) {
        this.properties.put("symbolFill", (Property)new SimpleObjectProperty((Object)FILL));
        return (B)this;
    }

    public final B symbolStroke(Color STROKE) {
        this.properties.put("symbolStroke", (Property)new SimpleObjectProperty((Object)STROKE));
        return (B)this;
    }

    public final B symbol(Symbol SYMBOL) {
        this.properties.put("symbol", (Property)new SimpleObjectProperty((Object)SYMBOL));
        return (B)this;
    }

    public final B chartType(ChartType TYPE) {
        this.properties.put("chartType", (Property)new SimpleObjectProperty((Object)TYPE));
        return (B)this;
    }

    public final B symbolsVisible(boolean VISIBLE) {
        this.properties.put("symbolsVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B symbolSize(double SIZE) {
        this.properties.put("symbolSize", (Property)new SimpleDoubleProperty(SIZE));
        return (B)this;
    }

    public final B strokeWidth(double WIDTH) {
        this.properties.put("strokeWidth", (Property)new SimpleDoubleProperty(WIDTH));
        return (B)this;
    }

    public final B visible(boolean VISIBLE) {
        this.properties.put("visible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B animated(boolean AUTO) {
        this.properties.put("animated", (Property)new SimpleBooleanProperty(AUTO));
        return (B)this;
    }

    public final B animationDuration(long DURATION) {
        this.properties.put("animationDuration", (Property)new SimpleLongProperty(DURATION));
        return (B)this;
    }

    public final YSeries build() {
        YSeries ySeries = new YSeries();
        if (this.properties.keySet().contains("itemsArray")) {
            ySeries.setItems((Item[])((ObjectProperty)this.properties.get("itemsArray")).get());
        }
        if (this.properties.keySet().contains("itemsList")) {
            ySeries.setItems((List)((ObjectProperty)this.properties.get("itemsList")).get());
        }
        Iterator<String> iterator = this.properties.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = iterator.next()) {
                case "name": {
                    ySeries.setName((String)((StringProperty)this.properties.get(key)).get());
                    break;
                }
                case "fill": {
                    ySeries.setFill((Paint)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "stroke": {
                    ySeries.setStroke((Paint)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "textFill": {
                    ySeries.setTextFill((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "symbolFill": {
                    ySeries.setSymbolFill((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "symbolStroke": {
                    ySeries.setSymbolStroke((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "symbol": {
                    ySeries.setSymbol((Symbol)((Object)((ObjectProperty)this.properties.get(key)).get()));
                    break;
                }
                case "chartType": {
                    ySeries.setChartType((ChartType)((Object)((ObjectProperty)this.properties.get(key)).get()));
                    break;
                }
                case "symbolsVisible": {
                    ySeries.setSymbolsVisible(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "symbolSize": {
                    ySeries.setSymbolSize(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "strokeWidth": {
                    ySeries.setStrokeWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "visible": {
                    ySeries.setVisible(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "animated": {
                    ySeries.setAnimated(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "animationDuration": {
                    ySeries.setAnimationDuration(((LongProperty)this.properties.get(key)).get());
                }
            }
        }
        return ySeries;
    }
}

