/*
 * Copyright (c) 2017 by Gerrit Grunwald
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package eu.hansolo.fx.charts.color;

import eu.hansolo.fx.charts.tools.Helper;
import javafx.scene.paint.Color;


public enum MaterialDesignColors implements Colors {
    // RED
    /**
     * The color RED with an RGB value of colorToRGB(244, 67, 54).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(244, 67, 54);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    RED(244, 67, 54),

    /**
     * The color RED 50 with an RGB value of colorToRGB(255, 235, 238).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(255, 235, 238);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    RED_50(255, 235, 238),

    /**
     * The color RED 100 with an RGB value of colorToRGB(255, 205, 210).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(255, 205, 210);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    RED_100(255, 205, 210),

    /**
     * The color RED 200 with an RGB value of colorToRGB(239, 154, 154).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(239, 154, 154);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    RED_200(239, 154, 154),

    /**
     * The color RED 300 with an RGB value of colorToRGB(229, 115, 115).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(229, 115, 115);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    RED_300(229, 115, 115),

    /**
     * The color RED 400 with an RGB value of colorToRGB(239, 83, 80).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(239, 83, 80);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    RED_400(239, 83, 80),

    /**
     * The color RED 500 with an RGB value of colorToRGB(244, 67, 54).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(244, 67, 54);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    RED_500(244, 67, 54),

    /**
     * The color RED 600 with an RGB value of colorToRGB(229, 57, 53).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(229, 57, 53);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    RED_600(229, 57, 53),

    /**
     * The color RED 700 with an RGB value of colorToRGB(211, 47, 47).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(211, 47, 47);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    RED_700(211, 47, 47),

    /**
     * The color RED 800 with an RGB value of colorToRGB(198, 40, 40).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(198, 40, 40);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    RED_800(198, 40, 40),

    /**
     * The color RED 900 with an RGB value of colorToRGB(183, 28, 28).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(183, 28, 28);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    RED_900(183, 28, 28),

    /**
     * The color RED A100 with an RGB value of colorToRGB(255, 138, 128).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(255, 138, 128);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    RED_A100(255, 138, 128),

    /**
     * The color RED A200 with an RGB value of colorToRGB(255, 82, 82).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(255, 82, 82);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    RED_A200(255, 82, 82),

    /**
     * The color RED A400 with an RGB value of colorToRGB(255, 23, 68).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(255, 23, 68);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    RED_A400(255, 23, 68),

    /**
     * The color RED A700 with an RGB value of colorToRGB(213, 0, 0).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(213, 0, 0);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    RED_A700(213, 0, 0),

    // PINK
    /**
     * The color PINK with an RGB value of colorToRGB(233, 30, 99).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(233, 30, 99);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    PINK(233, 30, 99),

    /**
     * The color PINK 50 with an RGB value of colorToRGB(252, 228, 236).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(252, 228, 236);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    PINK_50(252, 228, 236),

    /**
     * The color PINK 100 with an RGB value of colorToRGB(248, 187, 208).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(248, 187, 208);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    PINK_100(248, 187, 208),

    /**
     * The color PINK 200 with an RGB value of colorToRGB(244, 143, 177).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(244, 143, 177);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    PINK_200(244, 143, 177),

    /**
     * The color PINK 300 with an RGB value of colorToRGB(240, 98, 146).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(240, 98, 146);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    PINK_300(240, 98, 146),

    /**
     * The color PINK 400 with an RGB value of colorToRGB(236, 64, 122).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(236, 64, 122);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    PINK_400(236, 64, 122),

    /**
     * The color PINK 500 with an RGB value of colorToRGB(233, 30, 99).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(233, 30, 99);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    PINK_500(233, 30, 99),

    /**
     * The color PINK 600 with an RGB value of colorToRGB(216, 27, 96).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(216, 27, 96);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    PINK_600(216, 27, 96),

    /**
     * The color PINK 700 with an RGB value of colorToRGB(194, 24, 91).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(194, 24, 91);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    PINK_700(194, 24, 91),

    /**
     * The color PINK 800 with an RGB value of colorToRGB(173, 20, 87).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(173, 20, 87);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    PINK_800(173, 20, 87),

    /**
     * The color PINK 900 with an RGB value of colorToRGB(136, 14, 79).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(136, 14, 79);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    PINK_900(136, 14, 79),

    /**
     * The color PINK A100 with an RGB value of colorToRGB(255, 128, 171).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(255, 128, 171);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    PINK_A100(255, 128, 171),

    /**
     * The color PINK A200 with an RGB value of colorToRGB(255, 64, 129).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(255, 64, 129);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    PINK_A200(255, 64, 129),

    /**
     * The color PINK A400 with an RGB value of colorToRGB(245, 0, 87).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(245, 0, 87);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    PINK_A400(245, 0, 87),

    /**
     * The color PINK A700 with an RGB value of colorToRGB(197, 17, 98).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(197, 17, 98);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    PINK_A700(197, 17, 98),

    // PURPLE
    /**
     * The color PURPLE with an RGB value of colorToRGB(156, 39, 176).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(156, 39, 176);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    PURPLE(156, 39, 176),

    /**
     * The color PURPLE 50 with an RGB value of colorToRGB(243, 229, 245).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(243, 229, 245);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    PURPLE_50(243, 229, 245),

    /**
     * The color PURPLE 100 with an RGB value of colorToRGB(225, 190, 231).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(225, 190, 231);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    PURPLE_100(225, 190, 231),

    /**
     * The color PURPLE 200 with an RGB value of colorToRGB(206, 147, 216).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(206, 147, 216);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    PURPLE_200(206, 147, 216),

    /**
     * The color PURPLE 300 with an RGB value of colorToRGB(186, 104, 200).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(186, 104, 200);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    PURPLE_300(186, 104, 200),

    /**
     * The color PURPLE 400 with an RGB value of colorToRGB(171, 71, 188).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(171, 71, 188);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    PURPLE_400(171, 71, 188),

    /**
     * The color PURPLE 500 with an RGB value of colorToRGB(156, 39, 176).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(156, 39, 176);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    PURPLE_500(156, 39, 176),

    /**
     * The color PURPLE 600 with an RGB value of colorToRGB(142, 36, 170).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(142, 36, 170);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    PURPLE_600(142, 36, 170),

    /**
     * The color PURPLE 700 with an RGB value of colorToRGB(123, 31, 162).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(123, 31, 162);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    PURPLE_700(123, 31, 162),

    /**
     * The color PURPLE 800 with an RGB value of colorToRGB(106, 27, 154).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(106, 27, 154);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    PURPLE_800(106, 27, 154),

    /**
     * The color PURPLE 900 with an RGB value of colorToRGB(74, 20, 140).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(74, 20, 140);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    PURPLE_900(74, 20, 140),

    /**
     * The color PURPLE A100 with an RGB value of colorToRGB(234, 128, 252).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(234, 128, 252);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    PURPLE_A100(234, 128, 252),

    /**
     * The color PURPLE A200 with an RGB value of colorToRGB(224, 64, 251).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(224, 64, 251);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    PURPLE_A200(224, 64, 251),

    /**
     * The color PURPLE A400 with an RGB value of colorToRGB(213, 0, 249).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(213, 0, 249);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    PURPLE_A400(213, 0, 249),

    /**
     * The color PURPLE A700 with an RGB value of colorToRGB(170, 0, 255).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(170, 0, 255);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    PURPLE_A700(170, 0, 255),

    // DEEP PURPLE
    /**
     * The color DEEP PURPLE with an RGB value of colorToRGB(103, 58, 183).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(103, 58, 183);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    DEEP_PURPLE(103, 58, 183),

    /**
     * The color DEEP PURPLE 50 with an RGB value of colorToRGB(237, 231, 246).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(237, 231, 246);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    DEEP_PURPLE_50(237, 231, 246),

    /**
     * The color DEEP PURPLE 100 with an RGB value of colorToRGB(209, 196, 233).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(209, 196, 233);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    DEEP_PURPLE_100(209, 196, 233),

    /**
     * The color DEEP PURPLE 200 with an RGB value of colorToRGB(179, 157, 219).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(179, 157, 219);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    DEEP_PURPLE_200(179, 157, 219),

    /**
     * The color DEEP PURPLE 300 with an RGB value of colorToRGB(149, 117, 205).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(149, 117, 205);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    DEEP_PURPLE_300(149, 117, 205),

    /**
     * The color DEEP PURPLE 400 with an RGB value of colorToRGB(126, 87, 194).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(126, 87, 194);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    DEEP_PURPLE_400(126, 87, 194),

    /**
     * The color DEEP PURPLE 500 with an RGB value of colorToRGB(103, 58, 183).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(103, 58, 183);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    DEEP_PURPLE_500(103, 58, 183),

    /**
     * The color DEEP PURPLE 600 with an RGB value of colorToRGB(94, 53, 177).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(94, 53, 177);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    DEEP_PURPLE_600(94, 53, 177),

    /**
     * The color DEEP PURPLE 700 with an RGB value of colorToRGB(81, 45, 168).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(81, 45, 168);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    DEEP_PURPLE_700(81, 45, 168),

    /**
     * The color DEEP PURPLE 800 with an RGB value of colorToRGB(69, 39, 160).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(69, 39, 160);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    DEEP_PURPLE_800(69, 39, 160),

    /**
     * The color DEEP PURPLE 900 with an RGB value of colorToRGB(49, 27, 146).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(49, 27, 146);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    DEEP_PURPLE_900(49, 27, 146),

    /**
     * The color DEEP PURPLE A100 with an RGB value of colorToRGB(179, 136, 255).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(179, 136, 255);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    DEEP_PURPLE_A100(179, 136, 255),

    /**
     * The color DEEP PURPLE A200 with an RGB value of colorToRGB(124, 77, 255).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(124, 77, 255);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    DEEP_PURPLE_A200(124, 77, 255),

    /**
     * The color DEEP PURPLE A400 with an RGB value of colorToRGB(101, 31, 255).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(101, 31, 255);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    DEEP_PURPLE_A400(101, 31, 255),

    /**
     * The color DEEP PURPLE A700 with an RGB value of colorToRGB(98, 0, 234).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(98, 0, 234);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    DEEP_PURPLE_A700(98, 0, 234),

    // INDIGO
    /**
     * The color INDIGO with an RGB value of colorToRGB(63, 81, 181).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(63, 81, 181);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    INDIGO(63, 81, 181),

    /**
     * The color INDIGO 50 with an RGB value of colorToRGB(232, 234, 246).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(232, 234, 246);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    INDIGO_50(232, 234, 246),

    /**
     * The color INDIGO 100 with an RGB value of colorToRGB(197, 202, 233).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(197, 202, 233);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    INDIGO_100(197, 202, 233),

    /**
     * The color INDIGO 200 with an RGB value of colorToRGB(159, 168, 218).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(159, 168, 218);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    INDIGO_200(159, 168, 218),

    /**
     * The color INDIGO 300 with an RGB value of colorToRGB(121, 134, 203).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(121, 134, 203);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    INDIGO_300(121, 134, 203),

    /**
     * The color INDIGO 400 with an RGB value of colorToRGB(92, 107, 192).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(92, 107, 192);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    INDIGO_400(92, 107, 192),

    /**
     * The color INDIGO 500 with an RGB value of colorToRGB(63, 81, 181).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(63, 81, 181);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    INDIGO_500(63, 81, 181),

    /**
     * The color INDIGO 600 with an RGB value of colorToRGB(57, 73, 171).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(57, 73, 171);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    INDIGO_600(57, 73, 171),

    /**
     * The color INDIGO 700 with an RGB value of colorToRGB(48, 63, 159).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(48, 63, 159);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    INDIGO_700(48, 63, 159),

    /**
     * The color INDIGO 800 with an RGB value of colorToRGB(40, 53, 147).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(40, 53, 147);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    INDIGO_800(40, 53, 147),

    /**
     * The color INDIGO 900 with an RGB value of colorToRGB(26, 35, 126).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(26, 35, 126);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    INDIGO_900(26, 35, 126),

    /**
     * The color INDIGO A100 with an RGB value of colorToRGB(140, 158, 255).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(140, 158, 255);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    INDIGO_A100(140, 158, 255),

    /**
     * The color INDIGO A200 with an RGB value of colorToRGB(83, 109, 254).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(83, 109, 254);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    INDIGO_A200(83, 109, 254),

    /**
     * The color INDIGO A400 with an RGB value of colorToRGB(61, 90, 254).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(61, 90, 254);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    INDIGO_A400(61, 90, 254),

    /**
     * The color INDIGO A700 with an RGB value of colorToRGB(48, 79, 254).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(48, 79, 254);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    INDIGO_A700(48, 79, 254),

    // BLUE
    /**
     * The color BLUE with an RGB value of colorToRGB(33, 150, 243).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(33, 150, 243);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    BLUE(33, 150, 243),

    /**
     * The color BLUE 50 with an RGB value of colorToRGB(227, 242, 253).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(227, 242, 253);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    BLUE_50(227, 242, 253),

    /**
     * The color BLUE 100 with an RGB value of colorToRGB(187, 222, 251).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(187, 222, 251);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    BLUE_100(187, 222, 251),

    /**
     * The color BLUE 200 with an RGB value of colorToRGB(144, 202, 249).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(144, 202, 249);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    BLUE_200(144, 202, 249),

    /**
     * The color BLUE 300 with an RGB value of colorToRGB(100, 181, 246).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(100, 181, 246);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    BLUE_300(100, 181, 246),

    /**
     * The color BLUE 400 with an RGB value of colorToRGB(66, 165, 245).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(66, 165, 245);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    BLUE_400(66, 165, 245),

    /**
     * The color BLUE 500 with an RGB value of colorToRGB(33, 150, 243).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(33, 150, 243);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    BLUE_500(33, 150, 243),

    /**
     * The color BLUE 600 with an RGB value of colorToRGB(30, 136, 229).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(30, 136, 229);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    BLUE_600(30, 136, 229),

    /**
     * The color BLUE 700 with an RGB value of colorToRGB(25, 118, 210).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(25, 118, 210);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    BLUE_700(25, 118, 210),

    /**
     * The color BLUE 800 with an RGB value of colorToRGB(21, 101, 192).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(21, 101, 192);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    BLUE_800(21, 101, 192),

    /**
     * The color BLUE 900 with an RGB value of colorToRGB(13, 71, 161).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(13, 71, 161);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    BLUE_900(13, 71, 161),

    /**
     * The color BLUE A100 with an RGB value of colorToRGB(130, 177, 255).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(130, 177, 255);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    BLUE_A100(130, 177, 255),

    /**
     * The color BLUE A200 with an RGB value of colorToRGB(68, 138, 255).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(68, 138, 255);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    BLUE_A200(68, 138, 255),

    /**
     * The color BLUE A400 with an RGB value of colorToRGB(41, 121, 255).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(41, 121, 255);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    BLUE_A400(41, 121, 255),

    /**
     * The color BLUE A700 with an RGB value of colorToRGB(41, 98, 255).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(41, 98, 255);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    BLUE_A700(41, 98, 255),

    // LIGHT_BLUE
    /**
     * The color LIGHT BLUE with an RGB value of colorToRGB(3, 169, 244).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(3, 169, 244);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    LIGHT_BLUE(3, 169, 244),

    /**
     * The color LIGHT BLUE 50 with an RGB value of colorToRGB(225, 245, 254).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(225, 245, 254);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    LIGHT_BLUE_50(225, 245, 254),

    /**
     * The color LIGHT BLUE 100 with an RGB value of colorToRGB(179, 229, 252).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(179, 229, 252);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    LIGHT_BLUE_100(179, 229, 252),

    /**
     * The color LIGHT BLUE 200 with an RGB value of colorToRGB(129, 212, 250).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(129, 212, 250);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    LIGHT_BLUE_200(129, 212, 250),

    /**
     * The color LIGHT BLUE 300 with an RGB value of colorToRGB(79, 195, 247).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(79, 195, 247);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    LIGHT_BLUE_300(79, 195, 247),

    /**
     * The color LIGHT BLUE 400 with an RGB value of colorToRGB(41, 182, 246).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(41, 182, 246);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    LIGHT_BLUE_400(41, 182, 246),

    /**
     * The color LIGHT BLUE 500 with an RGB value of colorToRGB(3, 169, 244).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(3, 169, 244);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    LIGHT_BLUE_500(3, 169, 244),

    /**
     * The color LIGHT BLUE 600 with an RGB value of colorToRGB(3, 155, 229).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(3, 155, 229);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    LIGHT_BLUE_600(3, 155, 229),

    /**
     * The color LIGHT BLUE 700 with an RGB value of colorToRGB(2, 136, 209).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(2, 136, 209);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    LIGHT_BLUE_700(2, 136, 209),

    /**
     * The color LIGHT BLUE 800 with an RGB value of colorToRGB(2, 119, 189).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(2, 119, 189);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    LIGHT_BLUE_800(2, 119, 189),

    /**
     * The color LIGHT BLUE 900 with an RGB value of colorToRGB(1, 87, 155).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(1, 87, 155);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    LIGHT_BLUE_900(1, 87, 155),

    /**
     * The color LIGHT BLUE A100 with an RGB value of colorToRGB(128, 216, 255).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(128, 216, 255);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    LIGHT_BLUE_A100(128, 216, 255),

    /**
     * The color LIGHT BLUE A200 with an RGB value of colorToRGB(64, 196, 255).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(64, 196, 255);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    LIGHT_BLUE_A200(64, 196, 255),

    /**
     * The color LIGHT BLUE A400 with an RGB value of colorToRGB(0, 176, 255).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(0, 176, 255);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    LIGHT_BLUE_A400(0, 176, 255),

    /**
     * The color LIGHT BLUE A700 with an RGB value of colorToRGB(0, 145, 234).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(0, 145, 234);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    LIGHT_BLUE_A700(0, 145, 234),

    // CYAN
    /**
     * The color CYAN with an RGB value of colorToRGB(0, 188, 212).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(0, 188, 212);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    CYAN(0, 188, 212),

    /**
     * The color CYAN 50 with an RGB value of colorToRGB(224, 247, 250).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(224, 247, 250);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    CYAN_50(224, 247, 250),

    /**
     * The color CYAN 100 with an RGB value of colorToRGB(178, 235, 242).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(178, 235, 242);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    CYAN_100(178, 235, 242),

    /**
     * The color CYAN 200 with an RGB value of colorToRGB(128, 222, 234).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(128, 222, 234);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    CYAN_200(128, 222, 234),

    /**
     * The color CYAN 300 with an RGB value of colorToRGB(77, 208, 225).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(77, 208, 225);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    CYAN_300(77, 208, 225),

    /**
     * The color CYAN 400 with an RGB value of colorToRGB(38, 198, 218).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(38, 198, 218);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    CYAN_400(38, 198, 218),

    /**
     * The color CYAN 500 with an RGB value of colorToRGB(0, 188, 212).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(0, 188, 212);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    CYAN_500(0, 188, 212),

    /**
     * The color CYAN 600 with an RGB value of colorToRGB(0, 172, 193).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(0, 172, 193);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    CYAN_600(0, 172, 193),

    /**
     * The color CYAN 700 with an RGB value of colorToRGB(0, 151, 167).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(0, 151, 167);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    CYAN_700(0, 151, 167),

    /**
     * The color CYAN 800 with an RGB value of colorToRGB(0, 131, 143).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(0, 131, 143);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    CYAN_800(0, 131, 143),

    /**
     * The color CYAN 900 with an RGB value of colorToRGB(0, 96, 100).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(0, 96, 100);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    CYAN_900(0, 96, 100),

    /**
     * The color CYAN A100 with an RGB value of colorToRGB(132, 255, 255).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(132, 255, 255);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    CYAN_A100(132, 255, 255),

    /**
     * The color CYAN A200 with an RGB value of colorToRGB(24, 255, 25).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(24, 255, 25);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    CYAN_A200(24, 255, 255),

    /**
     * The color CYAN A400 with an RGB value of colorToRGB(0, 229, 255).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(0, 229, 255);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    CYAN_A400(0, 229, 255),

    /**
     * The color CYAN A700 with an RGB value of colorToRGB(0, 184, 212).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(0, 184, 212);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    CYAN_A700(0, 184, 212),

    // TEAL
    /**
     * The color TEAL with an RGB value of colorToRGB(0, 150, 136).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(0, 150, 136);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    TEAL(0, 150, 136),

    /**
     * The color TEAL 50 with an RGB value of colorToRGB(224, 242, 241).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(224, 242, 241);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    TEAL_50(224, 242, 241),

    /**
     * The color TEAL 100 with an RGB value of colorToRGB(178, 223, 219).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(178, 223, 219);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    TEAL_100(178, 223, 219),

    /**
     * The color TEAL 200 with an RGB value of colorToRGB(128, 203, 196).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(128, 203, 196);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    TEAL_200(128, 203, 196),

    /**
     * The color TEAL 300 with an RGB value of colorToRGB(77, 182, 172).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(77, 182, 172);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    TEAL_300(77, 182, 172),

    /**
     * The color TEAL 400 with an RGB value of colorToRGB(38, 166, 154).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(38, 166, 154);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    TEAL_400(38, 166, 154),

    /**
     * The color TEAL 500 with an RGB value of colorToRGB(0, 150, 136).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(0, 150, 136);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    TEAL_500(0, 150, 136),

    /**
     * The color TEAL 600 with an RGB value of colorToRGB(0, 137, 123).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(0, 137, 123);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    TEAL_600(0, 137, 123),

    /**
     * The color TEAL 700 with an RGB value of colorToRGB(0, 121, 107).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(0, 121, 107);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    TEAL_700(0, 121, 107),

    /**
     * The color TEAL 800 with an RGB value of colorToRGB(0, 105, 92).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(0, 105, 92);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    TEAL_800(0, 105, 92),

    /**
     * The color TEAL 900 with an RGB value of colorToRGB(0, 77, 64).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(0, 77, 64);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    TEAL_900(0, 77, 64),

    /**
     * The color TEAL A100 with an RGB value of colorToRGB(167, 255, 235).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(167, 255, 235);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    TEAL_A100(167, 255, 235),

    /**
     * The color TEAL A200 with an RGB value of colorToRGB(100, 255, 218).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(100, 255, 218);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    TEAL_A200(100, 255, 218),

    /**
     * The color TEAL A400 with an RGB value of colorToRGB(29, 233, 182).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(29, 233, 182);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    TEAL_A400(29, 233, 182),

    /**
     * The color TEAL A700 with an RGB value of colorToRGB(0, 191, 165).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(0, 191, 165);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    TEAL_A700(0, 191, 165),

    // GREEN
    /**
     * The color GREEN with an RGB value of colorToRGB(76, 175, 80).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(76, 175, 80);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    GREEN(76, 175, 80),

    /**
     * The color GREEN 50 with an RGB value of colorToRGB(232, 245, 233).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(232, 245, 233);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    GREEN_50(232, 245, 233),

    /**
     * The color GREEN 100 with an RGB value of colorToRGB(200, 230, 201).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(200, 230, 201);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    GREEN_100(200, 230, 201),

    /**
     * The color GREEN 200 with an RGB value of colorToRGB(165, 214, 167).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(165, 214, 167);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    GREEN_200(165, 214, 167),

    /**
     * The color GREEN 300 with an RGB value of colorToRGB(129, 199, 132).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(129, 199, 132);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    GREEN_300(129, 199, 132),

    /**
     * The color GREEN 400 with an RGB value of colorToRGB(102, 187, 106).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(102, 187, 106);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    GREEN_400(102, 187, 106),

    /**
     * The color GREEN 500 with an RGB value of colorToRGB(76, 175, 80).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(76, 175, 80);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    GREEN_500(76, 175, 80),

    /**
     * The color GREEN 600 with an RGB value of colorToRGB(67, 160, 71).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(67, 160, 71);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    GREEN_600(67, 160, 71),

    /**
     * The color GREEN 700 with an RGB value of colorToRGB(56, 142, 60).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(56, 142, 60);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    GREEN_700(56, 142, 60),

    /**
     * The color GREEN 800 with an RGB value of colorToRGB(46, 125, 50).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(46, 125, 50);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    GREEN_800(46, 125, 50),

    /**
     * The color GREEN 900 with an RGB value of colorToRGB(27, 94, 32).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(27, 94, 32);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    GREEN_900(27, 94, 32),

    /**
     * The color GREEN A100 with an RGB value of colorToRGB(185, 246, 202).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(185, 246, 202);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    GREEN_A100(185, 246, 202),

    /**
     * The color GREEN A200 with an RGB value of colorToRGB(105, 240, 174).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(105, 240, 174);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    GREEN_A200(105, 240, 174),

    /**
     * The color GREEN A400 with an RGB value of colorToRGB(0, 230, 118).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(0, 230, 118);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    GREEN_A400(0, 230, 118),

    /**
     * The color GREEN A700 with an RGB value of colorToRGB(0, 200, 83).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(0, 200, 83);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    GREEN_A700(0, 200, 83),

    // LIGHT_GREEN
    /**
     * The color LIGHT GREEN with an RGB value of colorToRGB(139, 195, 74).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(139, 195, 74);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    LIGHT_GREEN(139, 195, 74),

    /**
     * The color LIGHT GREEN 50 with an RGB value of colorToRGB(241, 248, 233).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(241, 248, 233);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    LIGHT_GREEN_50(241, 248, 233),

    /**
     * The color LIGHT GREEN 100 with an RGB value of colorToRGB(220, 237, 200).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(220, 237, 200);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    LIGHT_GREEN_100(220, 237, 200),

    /**
     * The color LIGHT GREEN 200 with an RGB value of colorToRGB(197, 225, 165).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(197, 225, 165);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    LIGHT_GREEN_200(197, 225, 165),

    /**
     * The color LIGHT GREEN 300 with an RGB value of colorToRGB(174, 213, 129).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(174, 213, 129);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    LIGHT_GREEN_300(174, 213, 129),

    /**
     * The color LIGHT GREEN 400 with an RGB value of colorToRGB(156, 204, 101).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(156, 204, 101);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    LIGHT_GREEN_400(156, 204, 101),

    /**
     * The color LIGHT GREEN 500 with an RGB value of colorToRGB(139, 195, 74).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(139, 195, 74);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    LIGHT_GREEN_500(139, 195, 74),

    /**
     * The color LIGHT GREEN 600 with an RGB value of colorToRGB(124, 179, 66).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(124, 179, 66);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    LIGHT_GREEN_600(124, 179, 66),

    /**
     * The color LIGHT GREEN 700 with an RGB value of colorToRGB(104, 159, 56).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(104, 159, 56);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    LIGHT_GREEN_700(104, 159, 56),

    /**
     * The color LIGHT GREEN 800 with an RGB value of colorToRGB(85, 139, 47).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(85, 139, 47);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    LIGHT_GREEN_800(85, 139, 47),

    /**
     * The color LIGHT GREEN 900 with an RGB value of colorToRGB(51, 105, 30).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(51, 105, 30);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    LIGHT_GREEN_900(51, 105, 30),

    /**
     * The color LIGHT GREEN A100 with an RGB value of colorToRGB(204, 255, 144).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(204, 255, 144);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    LIGHT_GREEN_A100(204, 255, 144),

    /**
     * The color LIGHT GREEN A200 with an RGB value of colorToRGB(178, 255, 89).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(178, 255, 89);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    LIGHT_GREEN_A200(178, 255, 89),

    /**
     * The color LIGHT GREEN A400 with an RGB value of colorToRGB(118, 255, 3).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(118, 255, 3);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    LIGHT_GREEN_A400(118, 255, 3),

    /**
     * The color LIGHT GREEN A700 with an RGB value of colorToRGB(100, 221, 23).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(100, 221, 23);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    LIGHT_GREEN_A700(100, 221, 23),

    //LIME
    /**
     * The color LIME with an RGB value of colorToRGB(205, 220, 57).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(205, 220, 57);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    LIME(205, 220, 57),

    /**
     * The color LIME 50 with an RGB value of colorToRGB(249, 251, 231).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(249, 251, 231);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    LIME_50(249, 251, 231),

    /**
     * The color LIME 100 with an RGB value of colorToRGB(240, 244, 195).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(240, 244, 195);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    LIME_100(240, 244, 195),

    /**
     * The color LIME 200 with an RGB value of colorToRGB(230, 238, 156).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(230, 238, 156);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    LIME_200(230, 238, 156),

    /**
     * The color LIME 300 with an RGB value of colorToRGB(220, 231, 117).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(220, 231, 117);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    LIME_300(220, 231, 117),

    /**
     * The color LIME 400 with an RGB value of colorToRGB(212, 225, 87).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(212, 225, 87);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    LIME_400(212, 225, 87),

    /**
     * The color LIME 500 with an RGB value of colorToRGB(205, 220, 57).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(205, 220, 57);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    LIME_500(205, 220, 57),

    /**
     * The color LIME 600 with an RGB value of colorToRGB(192, 202, 51).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(192, 202, 51);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    LIME_600(192, 202, 51),

    /**
     * The color LIME 700 with an RGB value of colorToRGB(175, 180, 43).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(175, 180, 43);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    LIME_700(175, 180, 43),

    /**
     * The color LIME 800 with an RGB value of colorToRGB(158, 157, 36).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(158, 157, 36);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    LIME_800(158, 157, 36),

    /**
     * The color LIME 900 with an RGB value of colorToRGB(130, 119, 23).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(130, 119, 23);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    LIME_900(130, 119, 23),

    /**
     * The color LIME A100 with an RGB value of colorToRGB(244, 255, 129).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(244, 255, 129);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    LIME_A100(244, 255, 129),

    /**
     * The color LIME A200 with an RGB value of colorToRGB(238, 255, 65).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(238, 255, 65);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    LIME_A200(238, 255, 65),

    /**
     * The color LIME A400 with an RGB value of colorToRGB(198, 255, 0).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(198, 255, 0);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    LIME_A400(198, 255, 0),

    /**
     * The color LIME A700 with an RGB value of colorToRGB(174, 234, 0).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(174, 234, 0);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    LIME_A700(174, 234, 0),

    // YELLOW
    /**
     * The color YELLOW with an RGB value of colorToRGB(255, 235, 59).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(255, 235, 59);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    YELLOW(255, 235, 59),

    /**
     * The color YELLOW 50 with an RGB value of colorToRGB(255, 253, 231).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(255, 253, 231);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    YELLOW_50(255, 253, 231),

    /**
     * The color YELLOW 100 with an RGB value of colorToRGB(255, 249, 196).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(255, 249, 196);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    YELLOW_100(255, 249, 196),

    /**
     * The color YELLOW 200 with an RGB value of colorToRGB(255, 245, 157).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(255, 245, 157);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    YELLOW_200(255, 245, 157),

    /**
     * The color YELLOW 300 with an RGB value of colorToRGB(255, 241, 118).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(255, 241, 118);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    YELLOW_300(255, 241, 118),

    /**
     * The color YELLOW 400 with an RGB value of colorToRGB(255, 238, 88).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(255, 238, 88);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    YELLOW_400(255, 238, 88),

    /**
     * The color YELLOW 500 with an RGB value of colorToRGB(255, 235, 59).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(255, 235, 59);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    YELLOW_500(255, 235, 59),

    /**
     * The color YELLOW 600 with an RGB value of colorToRGB(253, 216, 53).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(253, 216, 53);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    YELLOW_600(253, 216, 53),

    /**
     * The color YELLOW 700 with an RGB value of colorToRGB(251, 192, 45).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(251, 192, 45);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    YELLOW_700(251, 192, 45),

    /**
     * The color YELLOW 800 with an RGB value of colorToRGB(249, 168, 37).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(249, 168, 37);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    YELLOW_800(249, 168, 37),

    /**
     * The color YELLOW 900 with an RGB value of colorToRGB(245, 127, 23).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(245, 127, 23);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    YELLOW_900(245, 127, 23),

    /**
     * The color YELLOW A100 with an RGB value of colorToRGB(255, 255, 141).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(255, 255, 141);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    YELLOW_A100(255, 255, 141),

    /**
     * The color YELLOW A200 with an RGB value of colorToRGB(255, 255, 0).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(255, 255, 0);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    YELLOW_A200(255, 255, 0),

    /**
     * The color YELLOW A400 with an RGB value of colorToRGB(255, 234, 0).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(255, 234, 0);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    YELLOW_A400(255, 234, 0),

    /**
     * The color YELLOW A700 with an RGB value of colorToRGB(255, 214, 0).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(255, 214, 0);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    YELLOW_A700(255, 214, 0),

    // AMBER
    /**
     * The color AMBER with an RGB value of colorToRGB(255, 193, 7).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(255, 193, 7);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    AMBER(255, 193, 7),

    /**
     * The color AMBER 50 with an RGB value of colorToRGB(255, 248, 225).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(255, 248, 225);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    AMBER_50(255, 248, 225),

    /**
     * The color AMBER 100 with an RGB value of colorToRGB(255, 249, 196).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(255, 249, 196);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    AMBER_100(255, 249, 196),

    /**
     * The color AMBER 200 with an RGB value of colorToRGB(255, 224, 130).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(255, 224, 130);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    AMBER_200(255, 224, 130),

    /**
     * The color AMBER 300 with an RGB value of colorToRGB(255, 213, 79).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(255, 213, 79);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    AMBER_300(255, 213, 79),

    /**
     * The color AMBER 400 with an RGB value of colorToRGB(255, 202, 40).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(255, 202, 40);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    AMBER_400(255, 202, 40),

    /**
     * The color AMBER 500 with an RGB value of colorToRGB(255, 193, 7).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(255, 193, 7);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    AMBER_500(255, 193, 7),

    /**
     * The color AMBER 600 with an RGB value of colorToRGB(255, 179, 0).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(255, 179, 0);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    AMBER_600(255, 179, 0),

    /**
     * The color AMBER 700 with an RGB value of colorToRGB(255, 160, 0).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(255, 160, 0);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    AMBER_700(255, 160, 0),

    /**
     * The color AMBER 800 with an RGB value of colorToRGB(255, 143, 0).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(255, 143, 0);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    AMBER_800(255, 143, 0),

    /**
     * The color AMBER 900 with an RGB value of colorToRGB(255, 111, 0).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(255, 111, 0);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    AMBER_900(255, 111, 0),

    /**
     * The color AMBER A100 with an RGB value of colorToRGB(255, 229, 127).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(255, 229, 127);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    AMBER_A100(255, 229, 127),

    /**
     * The color AMBER A200 with an RGB value of colorToRGB(255, 215, 64).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(255, 215, 64);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    AMBER_A200(255, 215, 64),

    /**
     * The color AMBER A400 with an RGB value of colorToRGB(255, 196, 0).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(255, 196, 0);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    AMBER_A400(255, 196, 0),

    /**
     * The color AMBER A700 with an RGB value of colorToRGB(255, 171, 0).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(255, 171, 0);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    AMBER_A700(255, 171, 0),

    // ORANGE
    /**
     * The color ORANGE with an RGB value of colorToRGB(255, 152, 0).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(255, 152, 0);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    ORANGE(255, 152, 0),

    /**
     * The color ORANGE 50 with an RGB value of colorToRGB(255, 243, 224).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(255, 243, 224);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    ORANGE_50(255, 243, 224),

    /**
     * The color ORANGE 100 with an RGB value of colorToRGB(255, 224, 178).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(255, 224, 178);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    ORANGE_100(255, 224, 178),

    /**
     * The color ORANGE 200 with an RGB value of colorToRGB(255, 204, 128).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(255, 204, 128);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    ORANGE_200(255, 204, 128),

    /**
     * The color ORANGE 300 with an RGB value of colorToRGB(255, 183, 77).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(255, 183, 77);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    ORANGE_300(255, 183, 77),

    /**
     * The color ORANGE 400 with an RGB value of colorToRGB(255, 167, 38).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(255, 167, 38);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    ORANGE_400(255, 167, 38),

    /**
     * The color ORANGE 500 with an RGB value of colorToRGB(255, 152, 0).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(255, 152, 0);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    ORANGE_500(255, 152, 0),

    /**
     * The color ORANGE 600 with an RGB value of colorToRGB(251, 140, 0).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(251, 140, 0);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    ORANGE_600(251, 140, 0),

    /**
     * The color ORANGE 700 with an RGB value of colorToRGB(245, 124, 0).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(245, 124, 0);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    ORANGE_700(245, 124, 0),

    /**
     * The color ORANGE 800 with an RGB value of colorToRGB(239, 108, 0).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(239, 108, 0);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    ORANGE_800(239, 108, 0),

    /**
     * The color ORANGE 900 with an RGB value of colorToRGB(230, 81, 0).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(230, 81, 0);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    ORANGE_900(230, 81, 0),

    /**
     * The color ORANGE A100 with an RGB value of colorToRGB(255, 209, 128).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(255, 209, 128);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    ORANGE_A100(255, 209, 128),

    /**
     * The color ORANGE A200 with an RGB value of colorToRGB(255, 171, 64).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(255, 171, 64);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    ORANGE_A200(255, 171, 64),

    /**
     * The color ORANGE A400 with an RGB value of colorToRGB(255, 145, 0).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(255, 145, 0);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    ORANGE_A400(255, 145, 0),

    /**
     * The color ORANGE A700 with an RGB value of colorToRGB(255, 109, 0).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(255, 109, 0);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    ORANGE_A700(255, 109, 0),

    // DEEP_ORANGE
    /**
     * The color DEEP ORANGE with an RGB value of colorToRGB(255, 87, 34).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(255, 87, 34);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    DEEP_ORANGE(255, 87, 34),

    /**
     * The color DEEP ORANGE 50 with an RGB value of colorToRGB(251, 233, 231).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(251, 233, 231);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    DEEP_ORANGE_50(251, 233, 231),

    /**
     * The color DEEP ORANGE 100 with an RGB value of colorToRGB(255, 204, 188).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(255, 204, 188);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    DEEP_ORANGE_100(255, 204, 188),

    /**
     * The color DEEP ORANGE 200 with an RGB value of colorToRGB(255, 171, 145).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(255, 171, 145);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    DEEP_ORANGE_200(255, 171, 145),

    /**
     * The color DEEP ORANGE 300 with an RGB value of colorToRGB(255, 138, 101).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(255, 138, 101);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    DEEP_ORANGE_300(255, 138, 101),

    /**
     * The color DEEP ORANGE 400 with an RGB value of colorToRGB(255, 112, 67).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(255, 112, 67);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    DEEP_ORANGE_400(255, 112, 67),

    /**
     * The color DEEP ORANGE 500 with an RGB value of colorToRGB(255, 87, 34).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(255, 87, 34);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    DEEP_ORANGE_500(255, 87, 34),

    /**
     * The color DEEP ORANGE 600 with an RGB value of colorToRGB(244, 81, 30).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(244, 81, 30);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    DEEP_ORANGE_600(244, 81, 30),

    /**
     * The color DEEP ORANGE 700 with an RGB value of colorToRGB(230, 74, 25).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(230, 74, 25);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    DEEP_ORANGE_700(230, 74, 25),

    /**
     * The color DEEP ORANGE 800 with an RGB value of colorToRGB(216, 67, 21).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(216, 67, 21);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    DEEP_ORANGE_800(216, 67, 21),

    /**
     * The color DEEP ORANGE 900 with an RGB value of colorToRGB(191, 54, 12).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(191, 54, 12);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    DEEP_ORANGE_900(191, 54, 12),

    /**
     * The color DEEP ORANGE A100 with an RGB value of colorToRGB(255, 158, 128).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(255, 158, 128);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    DEEP_ORANGE_A100(255, 158, 128),

    /**
     * The color DEEP ORANGE A200 with an RGB value of colorToRGB(255, 110, 64).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(255, 110, 64);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    DEEP_ORANGE_A200(255, 110, 64),

    /**
     * The color DEEP ORANGE A400 with an RGB value of colorToRGB(255, 61, 0).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(255, 61, 0);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    DEEP_ORANGE_A400(255, 61, 0),

    /**
     * The color DEEP ORANGE A700 with an RGB value of colorToRGB(221, 44, 0).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(221, 44, 0);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    DEEP_ORANGE_A700(221, 44, 0),

    // BROWN
    /**
     * The color BROWN with an RGB value of colorToRGB(121, 85, 72).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(121, 85, 72);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    BROWN(121, 85, 72),

    /**
     * The color BROWN 50 with an RGB value of colorToRGB(239, 235, 233).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(239, 235, 233);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    BROWN_50(239, 235, 233),

    /**
     * The color BROWN 100 with an RGB value of colorToRGB(215, 204, 200).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(215, 204, 200);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    BROWN_100(215, 204, 200),

    /**
     * The color BROWN 200 with an RGB value of colorToRGB(188, 170, 164).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(188, 170, 164);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    BROWN_200(188, 170, 164),

    /**
     * The color BROWN 300 with an RGB value of colorToRGB(161, 136, 127).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(161, 136, 127);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    BROWN_300(161, 136, 127),

    /**
     * The color BROWN 400 with an RGB value of colorToRGB(141, 110, 99).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(141, 110, 99);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    BROWN_400(141, 110, 99),

    /**
     * The color BROWN 500 with an RGB value of colorToRGB(121, 85, 72).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(121, 85, 72);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    BROWN_500(121, 85, 72),

    /**
     * The color BROWN 600 with an RGB value of colorToRGB(109, 76, 65).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(109, 76, 65);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    BROWN_600(109, 76, 65),

    /**
     * The color BROWN 700 with an RGB value of colorToRGB(93, 64, 55).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(93, 64, 55);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    BROWN_700(93, 64, 55),

    /**
     * The color BROWN 800 with an RGB value of colorToRGB(78, 52, 46).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(78, 52, 46);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    BROWN_800(78, 52, 46),

    /**
     * The color BROWN 900 with an RGB value of colorToRGB(62, 39, 35).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(62, 39, 35);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    BROWN_900(62, 39, 35),

    // GREY
    /**
     * The color GREY with an RGB value of colorToRGB(158, 158, 158).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(158, 158, 158);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    GREY(158, 158, 158),

    /**
     * The color GREY 50 with an RGB value of colorToRGB(250, 250, 250).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(250, 250, 250);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    GREY_50(250, 250, 250),

    /**
     * The color GREY 100 with an RGB value of colorToRGB(245, 245, 245).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(245, 245, 245);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    GREY_100(245, 245, 245),

    /**
     * The color GREY 200 with an RGB value of colorToRGB(238, 238, 238).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(238, 238, 238);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    GREY_200(238, 238, 238),

    /**
     * The color GREY 300 with an RGB value of colorToRGB(224, 224, 224).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(224, 224, 224);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    GREY_300(224, 224, 224),

    /**
     * The color GREY 400 with an RGB value of colorToRGB(189, 189, 189).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(189, 189, 189);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    GREY_400(189, 189, 189),

    /**
     * The color GREY 500 with an RGB value of colorToRGB(158, 158, 158).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(158, 158, 158);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    GREY_500(158, 158, 158),

    /**
     * The color GREY 600 with an RGB value of colorToRGB(117, 117, 117).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(117, 117, 117);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    GREY_600(117, 117, 117),

    /**
     * The color GREY 700 with an RGB value of colorToRGB(97, 97, 97).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(97, 97, 97);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    GREY_700(97, 97, 97),

    /**
     * The color GREY 800 with an RGB value of colorToRGB(66, 66, 66).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(66, 66, 66);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    GREY_800(66, 66, 66),

    /**
     * The color GREY 900 with an RGB value of colorToRGB(33, 33, 33).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(33, 33, 33);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    GREY_900(33, 33, 33),

    // BLUE GREY
    /**
     * The color BLUE GREY with an RGB value of colorToRGB(96, 125, 139).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(96, 125, 139);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    BLUE_GREY(96, 125, 139),

    /**
     * The color BLUE GREY 50 with an RGB value of colorToRGB(236, 239, 241).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(236, 239, 241);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    BLUE_GREY_50(236, 239, 241),

    /**
     * The color BLUE GREY 100 with an RGB value of colorToRGB(207, 216, 220).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(207, 216, 220);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    BLUE_GREY_100(207, 216, 220),

    /**
     * The color BLUE GREY 200 with an RGB value of colorToRGB(176, 190, 197).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(176, 190, 197);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    BLUE_GREY_200(176, 190, 197),

    /**
     * The color BLUE GREY 300 with an RGB value of colorToRGB(144, 164, 174).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(144, 164, 174);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    BLUE_GREY_300(144, 164, 174),

    /**
     * The color BLUE GREY 400 with an RGB value of colorToRGB(120, 144, 156).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(120, 144, 156);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    BLUE_GREY_400(120, 144, 156),

    /**
     * The color BLUE GREY 500 with an RGB value of colorToRGB(96, 125, 139).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(96, 125, 139);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    BLUE_GREY_500(96, 125, 139),

    /**
     * The color BLUE GREY 600 with an RGB value of colorToRGB(84, 110, 122).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(84, 110, 122);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    BLUE_GREY_600(84, 110, 122),

    /**
     * The color BLUE GREY 700 with an RGB value of colorToRGB(69, 90, 100).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(69, 90, 100);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    BLUE_GREY_700(69, 90, 100),

    /**
     * The color BLUE GREY 800 with an RGB value of colorToRGB(55, 71, 79).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(55, 71, 79);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    BLUE_GREY_800(55, 71, 79),

    /**
     * The color BLUE GREY 900 with an RGB value of colorToRGB(38, 50, 56).
     * <div style="border:1px solid black;width:40px;height:20px;background-color:colorToRGB(38, 50, 56);float:right;margin: 0 10px 0 0"></div><br><br>
     */
    BLUE_GREY_900(38, 50, 56);

    private final Color COLOR;

    MaterialDesignColors(final int RED, final int GREEN, final int BLUE) {
        COLOR = Color.rgb(RED, GREEN, BLUE);
    }

    @Override public Color get() { return COLOR; }

    @Override public String rgb() { return Helper.colorToRGB(COLOR); }

    @Override public String rgba(final double OPACITY) { return Helper.colorToRGBA(COLOR, OPACITY); }

    @Override public String web() { return Helper.colorToWeb(COLOR); }
}
