/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.data.ChartItem;
import eu.hansolo.fx.charts.event.ChartEvt;
import eu.hansolo.fx.charts.event.SelectionEvt;
import eu.hansolo.fx.charts.series.ChartItemSeries;
import eu.hansolo.fx.charts.series.ChartItemSeriesBuilder;
import eu.hansolo.fx.charts.tools.Helper;
import eu.hansolo.fx.charts.tools.InfoPopup;
import eu.hansolo.fx.charts.tools.NumberFormat;
import eu.hansolo.fx.charts.tools.Order;
import eu.hansolo.fx.geometry.Rectangle;
import eu.hansolo.toolbox.evt.Evt;
import eu.hansolo.toolbox.evt.EvtObserver;
import eu.hansolo.toolbox.evt.EvtType;
import eu.hansolo.toolboxfx.font.Fonts;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.IntegerPropertyBase;
import javafx.beans.property.LongProperty;
import javafx.beans.property.LongPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;

@DefaultProperty(value="children")
public class BarChart<T extends ChartItem>
extends Region {
    private static final double PREFERRED_WIDTH = 250.0;
    private static final double PREFERRED_HEIGHT = 250.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 4096.0;
    private static final double MAXIMUM_HEIGHT = 4096.0;
    private double size;
    private double width;
    private double height;
    private Canvas canvas;
    private GraphicsContext ctx;
    private Pane pane;
    private ChartItemSeries<T> series;
    private Orientation _orientation;
    private ObjectProperty<Orientation> orientation;
    private Paint _backgroundFill;
    private ObjectProperty<Paint> backgroundFill;
    private Paint _namesBackgroundFill;
    private ObjectProperty<Paint> namesBackgroundFill;
    private Color _barBackgroundFill;
    private ObjectProperty<Color> barBackgroundFill;
    private Paint _seriesFill;
    private ObjectProperty<Paint> seriesFill;
    private Color _textFill;
    private ObjectProperty<Color> textFill;
    private Color _namesTextFill;
    private ObjectProperty<Color> namesTextFill;
    private boolean _barBackgroundVisible;
    private BooleanProperty barBackgroundVisible;
    private boolean _shadowsVisible;
    private BooleanProperty shadowsVisible;
    private NumberFormat _numberFormat;
    private ObjectProperty<NumberFormat> numberFormat;
    private boolean _useItemFill;
    private BooleanProperty useItemFill;
    private boolean _useItemTextFill;
    private BooleanProperty useItemTextFill;
    private boolean _useNamesTextFill;
    private BooleanProperty useNamesTextFill;
    private boolean _shortenNumbers;
    private BooleanProperty shortenNumbers;
    private boolean _sorted;
    private BooleanProperty sorted;
    private Order _order;
    private ObjectProperty<Order> order;
    private boolean _animated;
    private BooleanProperty animated;
    private long _animationDuration;
    private LongProperty animationDuration;
    private int _minNumberOfBars;
    private IntegerProperty minNumberOfBars;
    private boolean _useMinNumberOfBars;
    private BooleanProperty useMinNumberOfBars;
    private boolean _useGivenColors;
    private BooleanProperty useGivenColors;
    private List<Color> colors;
    private Map<Rectangle, ChartItem> rectangleItemMap;
    private ListChangeListener<ChartItem> chartItemListener;
    private EvtObserver<ChartEvt> observer;
    private EventHandler<MouseEvent> mouseHandler;
    private Map<EvtType, List<EvtObserver<ChartEvt>>> observers;
    private InfoPopup popup;

    public BarChart() {
        this(new ArrayList());
    }

    public BarChart(List<T> items) {
        if (null == items) {
            throw new IllegalArgumentException("Items cannot be null or empty");
        }
        this._orientation = Orientation.HORIZONTAL;
        this._backgroundFill = Color.TRANSPARENT;
        this._barBackgroundFill = Color.rgb((int)230, (int)230, (int)230);
        this._namesBackgroundFill = Color.TRANSPARENT;
        this._seriesFill = new LinearGradient(0.0, 0.0, 1.0, 0.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)255, (int)105, (int)91)), new Stop(1.0, Color.rgb((int)217, (int)41, (int)76))});
        this._textFill = Color.WHITE;
        this._namesTextFill = Color.BLACK;
        this._barBackgroundVisible = false;
        this._shadowsVisible = false;
        this._numberFormat = NumberFormat.NUMBER;
        this._useItemFill = false;
        this._useItemTextFill = false;
        this._useNamesTextFill = false;
        this._shortenNumbers = false;
        this._sorted = false;
        this._order = Order.DESCENDING;
        this._animated = true;
        this._animationDuration = 1000L;
        this._minNumberOfBars = 5;
        this._useMinNumberOfBars = false;
        this._useGivenColors = false;
        this.colors = new ArrayList<Color>(List.of(Color.rgb((int)253, (int)231, (int)37), Color.rgb((int)170, (int)220, (int)49), Color.rgb((int)94, (int)200, (int)99), Color.rgb((int)40, (int)173, (int)129), Color.rgb((int)33, (int)144, (int)140), Color.rgb((int)44, (int)114, (int)142), Color.rgb((int)59, (int)82, (int)139), Color.rgb((int)71, (int)45, (int)123), Color.rgb((int)68, (int)4, (int)84)));
        this.observers = new ConcurrentHashMap<EvtType, List<EvtObserver<ChartEvt>>>();
        this.popup = new InfoPopup();
        this.rectangleItemMap = new HashMap<Rectangle, ChartItem>();
        this.observer = evt -> {
            EvtType type = evt.getEvtType();
            if (type.equals(ChartEvt.ITEM_UPDATE) || type.equals(ChartEvt.FINISHED)) {
                if (this.getSorted()) {
                    this.series.sort(this.getOrder());
                }
                switch (this.getOrientation()) {
                    case HORIZONTAL: {
                        this.drawHorizontalChart();
                        break;
                    }
                    case VERTICAL: {
                        this.drawVerticalChart();
                    }
                }
            }
        };
        this.chartItemListener = c -> {
            boolean animated = this.series.isAnimated();
            long animationDuration = this.series.getAnimationDuration();
            while (c.next()) {
                if (c.wasAdded()) {
                    c.getAddedSubList().forEach(addedItem -> {
                        addedItem.addChartEvtObserver(ChartEvt.ANY, this.observer);
                        if (animated) {
                            addedItem.setAnimated(animated);
                        }
                        addedItem.setAnimationDuration(animationDuration);
                    });
                    continue;
                }
                if (!c.wasRemoved()) continue;
                c.getRemoved().forEach(removedItem -> removedItem.removeChartEvtObserver(ChartEvt.ANY, this.observer));
            }
            switch (this.getOrientation()) {
                case HORIZONTAL: {
                    this.drawHorizontalChart();
                    break;
                }
                case VERTICAL: {
                    this.drawVerticalChart();
                }
            }
        };
        this.mouseHandler = e -> this.handleMouseEvents((MouseEvent)e);
        this.series = ((ChartItemSeriesBuilder)((ChartItemSeriesBuilder)((ChartItemSeriesBuilder)((ChartItemSeriesBuilder)((ChartItemSeriesBuilder)((ChartItemSeriesBuilder)ChartItemSeriesBuilder.create().name("Series")).items(items)).fill(this._seriesFill)).textFill(this._textFill)).animated(true)).animationDuration(this._animationDuration)).build();
        this.prepareSeries();
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(250.0, 250.0);
            }
        }
        this.getStyleClass().add((Object)"bar-chart");
        this.canvas = new Canvas(this.size * 0.9, 0.9);
        this.ctx = this.canvas.getGraphicsContext2D();
        this.pane = new Pane(new Node[]{this.canvas});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
        this.series.getItems().forEach(item -> item.addChartEvtObserver(ChartEvt.ANY, this.observer));
        this.series.getItems().addListener(this.chartItemListener);
        this.canvas.addEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseHandler);
        this.addChartEvtObserver(SelectionEvt.ANY, (EvtObserver<ChartEvt>)((EvtObserver)e -> {
            this.popup.update((SelectionEvt)e);
            this.popup.animatedShow(this.getScene().getWindow());
        }));
    }

    public void layoutChildren() {
        super.layoutChildren();
    }

    protected double computeMinWidth(double height) {
        return 50.0;
    }

    protected double computeMinHeight(double width) {
        return 50.0;
    }

    protected double computePrefWidth(double height) {
        return super.computePrefWidth(height);
    }

    protected double computePrefHeight(double width) {
        return super.computePrefHeight(width);
    }

    protected double computeMaxWidth(double height) {
        return 4096.0;
    }

    protected double computeMaxHeight(double width) {
        return 4096.0;
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public List<T> getItems() {
        return this.series.getItems();
    }

    public void setItems(T ... items) {
        this.setItems(Arrays.asList(items));
    }

    public void setItems(List<T> items) {
        this.series.getItems().forEach(item -> item.removeChartEvtObserver(ChartEvt.ANY, this.observer));
        this.series.getItems().removeListener(this.chartItemListener);
        this.series.getItems().clear();
        this.series.setItems(items);
        this.prepareSeries();
        this.series.getItems().forEach(item -> item.addChartEvtObserver(ChartEvt.ANY, this.observer));
        this.series.getItems().addListener(this.chartItemListener);
        if (this.getSorted()) {
            this.series.sort(this.getOrder());
        }
        this.redraw();
    }

    public Orientation getOrientation() {
        return null == this.orientation ? this._orientation : (Orientation)this.orientation.get();
    }

    public void setOrientation(Orientation orientation) {
        if (null == this.orientation) {
            this._orientation = orientation;
            this.redraw();
        } else {
            this.orientation.set((Object)orientation);
        }
    }

    public ObjectProperty<Orientation> orientationProperty() {
        if (null == this.orientation) {
            this.orientation = new ObjectPropertyBase<Orientation>(this._orientation){

                protected void invalidated() {
                    BarChart.this.redraw();
                }

                public Object getBean() {
                    return BarChart.this;
                }

                public String getName() {
                    return "orientation";
                }
            };
            this._orientation = null;
        }
        return this.orientation;
    }

    public Paint getBackgroundFill() {
        return null == this.backgroundFill ? this._backgroundFill : (Paint)this.backgroundFill.get();
    }

    public void setBackgroundFill(Paint backgroundFill) {
        if (null == this.backgroundFill) {
            this._backgroundFill = backgroundFill;
            this.redraw();
        } else {
            this.backgroundFill.set((Object)backgroundFill);
        }
    }

    public ObjectProperty<Paint> backgroundFillProperty() {
        if (null == this.backgroundFill) {
            this.backgroundFill = new ObjectPropertyBase<Paint>(this._backgroundFill){

                protected void invalidated() {
                    BarChart.this.redraw();
                }

                public Object getBean() {
                    return BarChart.this;
                }

                public String getName() {
                    return "backgroundFill";
                }
            };
            this._backgroundFill = null;
        }
        return this.backgroundFill;
    }

    public Paint getNamesBackgroundFill() {
        return null == this.namesBackgroundFill ? this._namesBackgroundFill : (Paint)this.namesBackgroundFill.get();
    }

    public void setNamesBackgroundFill(Paint namesBackgroundFill) {
        if (null == this.namesBackgroundFill) {
            this._namesBackgroundFill = namesBackgroundFill;
            this.redraw();
        } else {
            this.namesBackgroundFill.set((Object)namesBackgroundFill);
        }
    }

    public ObjectProperty<Paint> namesBackgroundFillProperty() {
        if (null == this.namesBackgroundFill) {
            this.namesBackgroundFill = new ObjectPropertyBase<Paint>(this._namesBackgroundFill){

                protected void invalidated() {
                    BarChart.this.redraw();
                }

                public Object getBean() {
                    return BarChart.this;
                }

                public String getName() {
                    return "namesBackgroundFill";
                }
            };
            this._namesBackgroundFill = null;
        }
        return this.namesBackgroundFill;
    }

    public Color getBarBackgroundFill() {
        return null == this.barBackgroundFill ? this._barBackgroundFill : (Color)this.barBackgroundFill.get();
    }

    public void setBarBackgroundFill(Color barBackgroundFill) {
        if (null == this.barBackgroundFill) {
            this._barBackgroundFill = barBackgroundFill;
            this.redraw();
        } else {
            this.barBackgroundFill.set((Object)barBackgroundFill);
        }
    }

    public ObjectProperty<Color> barBackgroundFillProperty() {
        if (null == this.barBackgroundFill) {
            this.barBackgroundFill = new ObjectPropertyBase<Color>(this._barBackgroundFill){

                protected void invalidated() {
                    BarChart.this.redraw();
                }

                public Object getBean() {
                    return BarChart.this;
                }

                public String getName() {
                    return "barBackgroundFill";
                }
            };
            this._barBackgroundFill = null;
        }
        return this.barBackgroundFill;
    }

    public Paint getSeriesFill() {
        return null == this.seriesFill ? this._seriesFill : (Paint)this.seriesFill.get();
    }

    public void setSeriesFill(Paint seriesFill) {
        if (null == this.seriesFill) {
            this._seriesFill = seriesFill;
            this.series.setFill(this._seriesFill);
            this.redraw();
        } else {
            this.seriesFill.set((Object)seriesFill);
        }
    }

    public ObjectProperty<Paint> seriesFillProperty() {
        if (null == this.seriesFill) {
            this.seriesFill = new ObjectPropertyBase<Paint>(this._seriesFill){

                protected void invalidated() {
                    BarChart.this.series.setFill((Paint)this.get());
                    BarChart.this.redraw();
                }

                public Object getBean() {
                    return BarChart.this;
                }

                public String getName() {
                    return "seriesFill";
                }
            };
            this._seriesFill = null;
        }
        return this.seriesFill;
    }

    public Color getTextFill() {
        return null == this.textFill ? this._textFill : (Color)this.textFill.get();
    }

    public void setTextFill(Color textFill) {
        if (null == this.textFill) {
            this._textFill = textFill;
            this.redraw();
        } else {
            this.textFill.set((Object)textFill);
        }
    }

    public ObjectProperty<Color> textFillProperty() {
        if (null == this.textFill) {
            this.textFill = new ObjectPropertyBase<Color>(this._textFill){

                protected void invalidated() {
                    BarChart.this.redraw();
                }

                public Object getBean() {
                    return BarChart.this;
                }

                public String getName() {
                    return "textFill";
                }
            };
            this._textFill = null;
        }
        return this.textFill;
    }

    public Color getNamesTextFill() {
        return null == this.namesTextFill ? this._namesTextFill : (Color)this.namesTextFill.get();
    }

    public void setNamesTextFill(Color namesTextFill) {
        if (null == this.namesTextFill) {
            this._namesTextFill = namesTextFill;
            this.redraw();
        } else {
            this.namesTextFill.set((Object)namesTextFill);
        }
    }

    public ObjectProperty<Color> namesTextFillProperty() {
        if (null == this.namesTextFill) {
            this.namesTextFill = new ObjectPropertyBase<Color>(this._namesTextFill){

                protected void invalidated() {
                    BarChart.this.redraw();
                }

                public Object getBean() {
                    return BarChart.this;
                }

                public String getName() {
                    return "namesTextFill";
                }
            };
            this._namesTextFill = null;
        }
        return this.namesTextFill;
    }

    public boolean getBarBackgroundVisible() {
        return null == this.barBackgroundVisible ? this._barBackgroundVisible : this.barBackgroundVisible.get();
    }

    public void setBarBackgroundVisible(boolean barBackgroundVisible) {
        if (null == this.barBackgroundVisible) {
            this._barBackgroundVisible = barBackgroundVisible;
            this.redraw();
        } else {
            this.barBackgroundVisible.set(barBackgroundVisible);
        }
    }

    public BooleanProperty barBackgroundVisibleProperty() {
        if (null == this.barBackgroundVisible) {
            this.barBackgroundVisible = new BooleanPropertyBase(this._barBackgroundVisible){

                protected void invalidated() {
                    BarChart.this.redraw();
                }

                public Object getBean() {
                    return BarChart.this;
                }

                public String getName() {
                    return "barBackgroundVisible";
                }
            };
        }
        return this.barBackgroundVisible;
    }

    public boolean getShadowsVisible() {
        return null == this.shadowsVisible ? this._shadowsVisible : this.shadowsVisible.get();
    }

    public void setShadowsVisible(boolean shadowsVisible) {
        if (null == this.shadowsVisible) {
            this._shadowsVisible = shadowsVisible;
            this.redraw();
        } else {
            this.shadowsVisible.set(shadowsVisible);
        }
    }

    public BooleanProperty shadowsVisibleProperty() {
        if (null == this.shadowsVisible) {
            this.shadowsVisible = new BooleanPropertyBase(this._shadowsVisible){

                protected void invalidated() {
                    BarChart.this.redraw();
                }

                public Object getBean() {
                    return BarChart.this;
                }

                public String getName() {
                    return "shadowsVisible";
                }
            };
        }
        return this.shadowsVisible;
    }

    public NumberFormat getNumberFormat() {
        return null == this.numberFormat ? this._numberFormat : (NumberFormat)((Object)this.numberFormat.get());
    }

    public void setNumberFormat(NumberFormat format) {
        if (null == this.numberFormat) {
            this._numberFormat = format;
            this.updatePopup();
            this.redraw();
        } else {
            this.numberFormat.set((Object)format);
        }
    }

    public ObjectProperty<NumberFormat> numberFormatProperty() {
        if (null == this.numberFormat) {
            this.numberFormat = new ObjectPropertyBase<NumberFormat>(this._numberFormat){

                protected void invalidated() {
                    BarChart.this.updatePopup();
                    BarChart.this.redraw();
                }

                public Object getBean() {
                    return BarChart.this;
                }

                public String getName() {
                    return "numberFormat";
                }
            };
            this._numberFormat = null;
        }
        return this.numberFormat;
    }

    public boolean getUseItemFill() {
        return null == this.useItemFill ? this._useItemFill : this.useItemFill.get();
    }

    public void setUseItemFill(boolean useItemFill) {
        if (null == this.useItemFill) {
            this._useItemFill = useItemFill;
            this.redraw();
        } else {
            this.useItemFill.set(useItemFill);
        }
    }

    public BooleanProperty useItemFillProperty() {
        if (null == this.useItemFill) {
            this.useItemFill = new BooleanPropertyBase(this._useItemFill){

                protected void invalidated() {
                    BarChart.this.redraw();
                }

                public Object getBean() {
                    return BarChart.this;
                }

                public String getName() {
                    return "useItemFill";
                }
            };
        }
        return this.useItemFill;
    }

    public boolean getUseItemTextFill() {
        return null == this.useItemTextFill ? this._useItemTextFill : this.useItemTextFill.get();
    }

    public void setUseItemTextFill(boolean useItemTextFill) {
        if (null == this.useItemTextFill) {
            this._useItemTextFill = useItemTextFill;
            this.redraw();
        } else {
            this.useItemTextFill.set(useItemTextFill);
        }
    }

    public BooleanProperty useItemTextFillProperty() {
        if (null == this.useItemTextFill) {
            this.useItemTextFill = new BooleanPropertyBase(this._useItemTextFill){

                protected void invalidated() {
                    BarChart.this.redraw();
                }

                public Object getBean() {
                    return BarChart.this;
                }

                public String getName() {
                    return "useItemTextFill";
                }
            };
        }
        return this.useItemTextFill;
    }

    public boolean getUseNamesTextFill() {
        return null == this.useNamesTextFill ? this._useNamesTextFill : this.useNamesTextFill.get();
    }

    public void setUseNamesTextFill(boolean useNamesTextFill) {
        if (null == this.useNamesTextFill) {
            this._useNamesTextFill = useNamesTextFill;
            this.redraw();
        } else {
            this.useNamesTextFill.set(useNamesTextFill);
        }
    }

    public BooleanProperty useNamesTextFillProperty() {
        if (null == this.useNamesTextFill) {
            this.useNamesTextFill = new BooleanPropertyBase(this._useNamesTextFill){

                protected void invalidated() {
                    BarChart.this.redraw();
                }

                public Object getBean() {
                    return BarChart.this;
                }

                public String getName() {
                    return "useNamesTextFill";
                }
            };
        }
        return this.useNamesTextFill;
    }

    public boolean getShortenNumbers() {
        return null == this.shortenNumbers ? this._shortenNumbers : this.shortenNumbers.get();
    }

    public void setShortenNumbers(boolean shorten) {
        if (null == this.shortenNumbers) {
            this._shortenNumbers = shorten;
            this.redraw();
        } else {
            this.shortenNumbers.set(shorten);
        }
    }

    public BooleanProperty shortenNumbersProperty() {
        if (null == this.shortenNumbers) {
            this.shortenNumbers = new BooleanPropertyBase(this._shortenNumbers){

                protected void invalidated() {
                    BarChart.this.redraw();
                }

                public Object getBean() {
                    return BarChart.this;
                }

                public String getName() {
                    return "shortenNumbers";
                }
            };
        }
        return this.shortenNumbers;
    }

    public boolean getSorted() {
        return null == this.sorted ? this._sorted : this.sorted.get();
    }

    public void setSorted(boolean sorted) {
        if (null == this.sorted) {
            this._sorted = sorted;
            this.redraw();
        } else {
            this.sorted.set(sorted);
        }
    }

    public BooleanProperty sortedProperty() {
        if (null == this.sorted) {
            this.sorted = new BooleanPropertyBase(){

                protected void invalidated() {
                    BarChart.this.redraw();
                }

                public Object getBean() {
                    return BarChart.this;
                }

                public String getName() {
                    return "sorted";
                }
            };
        }
        return this.sorted;
    }

    public Order getOrder() {
        return null == this.order ? this._order : (Order)((Object)this.order.get());
    }

    public void setOrder(Order order) {
        if (null == this.order) {
            this._order = order;
            this.redraw();
        } else {
            this.order.set((Object)order);
        }
    }

    public ObjectProperty<Order> orderProperty() {
        if (null == this.order) {
            this.order = new ObjectPropertyBase<Order>(this._order){

                protected void invalidated() {
                    BarChart.this.redraw();
                }

                public Object getBean() {
                    return BarChart.this;
                }

                public String getName() {
                    return "order";
                }
            };
            this._order = null;
        }
        return this.order;
    }

    public boolean isAnimated() {
        return null == this.animated ? this._animated : this.animated.get();
    }

    public void setAnimated(boolean animated) {
        if (null == this.animated) {
            this._animated = animated;
            this.series.setAnimated(this._animated);
            this.prepareSeries();
        } else {
            this.animated.set(animated);
        }
    }

    public BooleanProperty animatedProperty() {
        if (null == this.animated) {
            this.animated = new BooleanPropertyBase(this._animated){

                protected void invalidated() {
                    BarChart.this.series.setAnimated(this.get());
                    BarChart.this.prepareSeries();
                }

                public Object getBean() {
                    return BarChart.this;
                }

                public String getName() {
                    return "animated";
                }
            };
        }
        return this.animated;
    }

    public long getAnimationDuration() {
        return null == this.animationDuration ? this._animationDuration : this.animationDuration.get();
    }

    public void setAnimationDuration(long animationDuration) {
        if (null == this.animationDuration) {
            this._animationDuration = Helper.clamp(10L, 10000L, animationDuration);
            this.series.setAnimationDuration(this._animationDuration);
            this.prepareSeries();
        } else {
            this.animationDuration.set(animationDuration);
        }
    }

    public LongProperty animationDurationProperty() {
        if (null == this.animationDuration) {
            this.animationDuration = new LongPropertyBase(this._animationDuration){

                protected void invalidated() {
                    long ad = Helper.clamp(10L, 10000L, this.get());
                    BarChart.this.series.setAnimationDuration(ad);
                    BarChart.this.prepareSeries();
                    this.set(ad);
                }

                public Object getBean() {
                    return BarChart.this;
                }

                public String getName() {
                    return "animationDuration";
                }
            };
        }
        return this.animationDuration;
    }

    public int getMinNumberOfBars() {
        return null == this.minNumberOfBars ? this._minNumberOfBars : this.minNumberOfBars.get();
    }

    public void setMinNumberOfBars(int minNumberOfBars) {
        if (null == this.minNumberOfBars) {
            this._minNumberOfBars = Helper.clamp(1, Integer.MAX_VALUE, minNumberOfBars);
            this.redraw();
        } else {
            this.minNumberOfBars.set(minNumberOfBars);
        }
    }

    public IntegerProperty minNumberOfBarsProperty() {
        if (null == this.minNumberOfBars) {
            this.minNumberOfBars = new IntegerPropertyBase(this._minNumberOfBars){

                protected void invalidated() {
                    this.set(Helper.clamp(1, Integer.MAX_VALUE, this.get()));
                    BarChart.this.redraw();
                }

                public Object getBean() {
                    return BarChart.this;
                }

                public String getName() {
                    return "minNumberOfBars";
                }
            };
        }
        return this.minNumberOfBars;
    }

    public boolean getUseMinNumberOfBars() {
        return null == this.useMinNumberOfBars ? this._useMinNumberOfBars : this.useMinNumberOfBars.get();
    }

    public void setUseMinNumberOfBars(boolean useMinNumberOfBars) {
        if (null == this.useMinNumberOfBars) {
            this._useMinNumberOfBars = useMinNumberOfBars;
            this.redraw();
        } else {
            this.useMinNumberOfBars.set(useMinNumberOfBars);
        }
    }

    public BooleanProperty useMinNumberOfBarsProperty() {
        if (null == this.useMinNumberOfBars) {
            this.useMinNumberOfBars = new BooleanPropertyBase(this._useMinNumberOfBars){

                protected void invalidated() {
                    BarChart.this.redraw();
                }

                public Object getBean() {
                    return BarChart.this;
                }

                public String getName() {
                    return "useMinNumberOfBars";
                }
            };
        }
        return this.useMinNumberOfBars;
    }

    public boolean useGivenColors() {
        return null == this.useGivenColors ? this._useGivenColors : this.useGivenColors.get();
    }

    public void setUseGivenColors(boolean useGivenColors) {
        if (null == this.useGivenColors) {
            this._useGivenColors = useGivenColors;
            this.redraw();
        } else {
            this.useGivenColors.set(useGivenColors);
        }
    }

    public BooleanProperty getUseGivenColorsProperty() {
        if (null == this.useGivenColors) {
            this.useGivenColors = new BooleanPropertyBase(this._useGivenColors){

                protected void invalidated() {
                    BarChart.this.redraw();
                }

                public Object getBean() {
                    return BarChart.this;
                }

                public String getName() {
                    return "useGivenColors";
                }
            };
        }
        return this.useGivenColors;
    }

    public List<Color> getColors() {
        return this.colors;
    }

    public void setColors(List<Color> colors) {
        if (colors.isEmpty()) {
            throw new IllegalArgumentException("colors cannot be empty");
        }
        this.colors.clear();
        this.colors.addAll(colors);
        if (this.useGivenColors()) {
            this.redraw();
        }
    }

    private void handleMouseEvents(MouseEvent evt) {
        double x = evt.getX();
        double y = evt.getY();
        Optional<Map.Entry> opt = this.rectangleItemMap.entrySet().stream().filter(entry -> ((Rectangle)entry.getKey()).contains(x, y)).findFirst();
        if (opt.isPresent()) {
            this.popup.setX(evt.getScreenX());
            this.popup.setY(evt.getScreenY() - this.popup.getHeight());
            ChartItem selectedItem = (ChartItem)opt.get().getValue();
            this.fireChartEvt(new SelectionEvt<ChartItem>(this.series, (ChartItem)opt.get().getValue()));
        }
    }

    private void updatePopup() {
        switch (this.getNumberFormat()) {
            case NUMBER: {
                this.popup.setDecimals(0);
                break;
            }
            case FLOAT_1_DECIMAL: {
                this.popup.setDecimals(1);
                break;
            }
            case FLOAT_2_DECIMALS: {
                this.popup.setDecimals(2);
                break;
            }
            case FLOAT: {
                this.popup.setDecimals(8);
                break;
            }
            case PERCENTAGE: {
                this.popup.setDecimals(0);
                break;
            }
            case PERCENTAGE_1_DECIMAL: {
                this.popup.setDecimals(1);
            }
        }
    }

    public void addChartEvtObserver(EvtType type, EvtObserver<ChartEvt> observer) {
        if (!this.observers.containsKey(type)) {
            this.observers.put(type, new CopyOnWriteArrayList());
        }
        if (this.observers.get(type).contains(observer)) {
            return;
        }
        this.observers.get(type).add(observer);
    }

    public void removeChartEvtObserver(EvtType type, EvtObserver<ChartEvt> observer) {
        if (this.observers.containsKey(type) && this.observers.get(type).contains(observer)) {
            this.observers.get(type).remove(observer);
        }
    }

    public void removeAllChartEvtObservers() {
        this.observers.clear();
    }

    public void fireChartEvt(ChartEvt evt) {
        EvtType type = evt.getEvtType();
        this.observers.entrySet().stream().filter(entry -> ((EvtType)entry.getKey()).equals(ChartEvt.ANY)).forEach(entry -> ((List)entry.getValue()).forEach(observer -> observer.handle((Evt)evt)));
        if (this.observers.containsKey(type) && !type.equals(ChartEvt.ANY)) {
            this.observers.get(type).forEach(observer -> observer.handle((Evt)evt));
        }
    }

    private void prepareSeries() {
        boolean animated = this.series.isAnimated();
        long animationDuration = this.series.getAnimationDuration();
        this.series.getItems().forEach(item -> {
            item.setAnimated(animated);
            item.setAnimationDuration(animationDuration);
        });
    }

    private void drawHorizontalChart() {
        ChartItem item;
        this.rectangleItemMap.clear();
        double inset = 5.0;
        double chartWidth = this.width - 2.0 * inset;
        double chartHeight = this.height - 2.0 * inset;
        ObservableList<T> items = this.series.getItems();
        double noOfItems = items.size();
        double namesWidth = chartWidth * 0.2;
        double maxBarWidth = chartWidth - namesWidth;
        double minNumberOfBars = noOfItems > (double)this.getMinNumberOfBars() ? noOfItems : (double)this.getMinNumberOfBars();
        double barHeight = this.getUseMinNumberOfBars() ? chartHeight / (minNumberOfBars + minNumberOfBars * 0.4) : chartHeight / (noOfItems + noOfItems * 0.4);
        double cornerRadius = barHeight * 0.75;
        double barSpacer = this.getUseMinNumberOfBars() ? (chartHeight - minNumberOfBars * barHeight) / (minNumberOfBars - 1.0) : (chartHeight - noOfItems * barHeight) / (noOfItems - 1.0);
        double maxValue = this.series.getMaxValue();
        NumberFormat numberFormat = this.getNumberFormat();
        Color valueTextFill = this.getTextFill();
        Color namesTextFill = this.getNamesTextFill();
        boolean useItemFill = this.getUseItemFill();
        boolean useItemTextFill = this.getUseItemTextFill();
        boolean useNamesTextFill = this.getUseNamesTextFill();
        String formatString = numberFormat.formatString();
        Paint barFill = this.series.getFill();
        boolean shortenNumbers = this.getShortenNumbers();
        boolean barBackgroundVisible = this.getBarBackgroundVisible();
        Color barBackgroundFill = this.getBarBackgroundFill();
        Paint namesBackgroundFill = this.getNamesBackgroundFill().equals(Color.TRANSPARENT) ? this.getBackgroundFill() : this.getNamesBackgroundFill();
        boolean shadowsVisible = this.getShadowsVisible();
        double valueFontSize = barHeight * 0.5;
        double nameFontSize = barHeight * 0.5;
        Font valueFont = Fonts.latoRegular((double)valueFontSize);
        Font nameFont = Fonts.latoRegular((double)nameFontSize);
        DropShadow shadow = new DropShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)0, (int)0, (int)0, (double)0.15), barHeight * 0.1, 0.0, 1.0, barHeight * 0.1);
        double barX = inset + namesWidth;
        int givenColorCounter = 0;
        this.ctx.clearRect(0.0, 0.0, this.width, this.height);
        this.ctx.setFill(this.getBackgroundFill());
        this.ctx.fillRect(0.0, 0.0, this.width, this.height);
        this.ctx.setLineCap(StrokeLineCap.BUTT);
        this.ctx.setTextAlign(TextAlignment.RIGHT);
        this.ctx.setTextBaseline(VPos.CENTER);
        this.ctx.setFont(valueFont);
        int i = 0;
        while ((double)i < noOfItems) {
            item = (ChartItem)items.get(i);
            double itemValue = Helper.clamp(0.0, Double.MAX_VALUE, item.getValue());
            double barWidth = 0.0 == maxValue ? 0.0 : itemValue / maxValue * maxBarWidth;
            double barY = inset + (double)i * barHeight + (double)i * barSpacer;
            if (barBackgroundVisible) {
                this.ctx.setFill((Paint)barBackgroundFill);
                this.ctx.beginPath();
                this.ctx.moveTo(barX, barY);
                this.ctx.lineTo(barX + maxBarWidth - cornerRadius, barY);
                this.ctx.bezierCurveTo(barX + maxBarWidth, barY, barX + maxBarWidth, barY + barHeight, barX + maxBarWidth - cornerRadius, barY + barHeight);
                this.ctx.lineTo(barX, barY + barHeight);
                this.ctx.lineTo(barX, barY);
                this.ctx.closePath();
                this.ctx.fill();
            }
            this.ctx.save();
            if (shadowsVisible) {
                this.ctx.setEffect((Effect)shadow);
            }
            if (this.useGivenColors()) {
                this.ctx.setFill((Paint)this.colors.get(givenColorCounter));
                if (++givenColorCounter > this.colors.size() - 1) {
                    givenColorCounter = 0;
                }
            } else {
                this.ctx.setFill((Paint)(useItemFill ? item.getFill() : barFill));
            }
            this.ctx.beginPath();
            this.ctx.moveTo(barX, barY);
            if (barWidth < cornerRadius) {
                this.ctx.bezierCurveTo(barX + cornerRadius, barY, barX + cornerRadius, barY + barHeight, barX, barY + barHeight);
            } else {
                this.ctx.lineTo(barX + barWidth - cornerRadius, barY);
                this.ctx.bezierCurveTo(barX + barWidth, barY, barX + barWidth, barY + barHeight, barX + barWidth - cornerRadius, barY + barHeight);
            }
            this.ctx.lineTo(barX, barY + barHeight);
            this.ctx.lineTo(barX, barY);
            this.ctx.closePath();
            this.ctx.fill();
            this.ctx.restore();
            this.rectangleItemMap.put(new Rectangle(barX, barY, barWidth, barHeight), item);
            if (valueFontSize > 6.0) {
                double valueX;
                double valueTextWidth;
                String valueText;
                this.ctx.setFill((Paint)(useItemTextFill ? item.getTextFill() : valueTextFill));
                if (shortenNumbers) {
                    valueText = Helper.shortenNumber((long)itemValue);
                    valueTextWidth = Helper.getTextDimension(valueText, valueFont).getWidth();
                    valueX = barX + barWidth - barHeight * 0.5;
                    this.ctx.setTextAlign(TextAlignment.RIGHT);
                } else if (NumberFormat.PERCENTAGE == numberFormat || NumberFormat.PERCENTAGE_1_DECIMAL == numberFormat) {
                    valueText = String.format(Locale.US, formatString, itemValue / maxValue * 100.0);
                    valueTextWidth = Helper.getTextDimension(valueText, valueFont).getWidth();
                    valueX = barX + 5.0;
                    this.ctx.setTextAlign(TextAlignment.LEFT);
                } else {
                    valueText = String.format(Locale.US, formatString, itemValue);
                    valueTextWidth = Helper.getTextDimension(valueText, valueFont).getWidth();
                    valueX = barX + barWidth - barHeight * 0.5;
                    this.ctx.setTextAlign(TextAlignment.RIGHT);
                }
                valueX = barWidth <= valueTextWidth * 2.0 ? barX + valueTextWidth + 5.0 : valueX;
                this.ctx.fillText(valueText, valueX, barY + barHeight * 0.5);
            }
            ++i;
        }
        this.ctx.setFill(namesBackgroundFill);
        this.ctx.fillRect(inset, inset, namesWidth, chartHeight);
        for (i = 0; i < items.size(); ++i) {
            item = (ChartItem)items.get(i);
            String name = item.getName();
            double nameX = inset + namesWidth * 0.95;
            double nameY = inset + (double)i * barHeight + (double)i * barSpacer;
            this.ctx.setTextAlign(TextAlignment.RIGHT);
            this.ctx.setFill((Paint)(useNamesTextFill ? namesTextFill : item.getTextFill()));
            this.ctx.setFont(nameFont);
            this.ctx.fillText(name, nameX, nameY + barHeight * 0.5, namesWidth * 0.9);
        }
        if (shadowsVisible) {
            this.ctx.setFill((Paint)new LinearGradient(0.0, 0.0, 1.0, 0.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.TRANSPARENT), new Stop(1.0, Color.rgb((int)0, (int)0, (int)0, (double)0.25))}));
            this.ctx.fillRect(inset - 6.0, inset, 6.0, chartHeight);
            this.ctx.setFill((Paint)new LinearGradient(1.0, 0.0, 0.0, 0.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.TRANSPARENT), new Stop(1.0, Color.rgb((int)0, (int)0, (int)0, (double)0.25))}));
            this.ctx.fillRect(inset + namesWidth, inset, 6.0, chartHeight);
        }
    }

    private void drawVerticalChart() {
        ChartItem item;
        this.rectangleItemMap.clear();
        double inset = 5.0;
        double chartWidth = this.width - 2.0 * inset;
        double chartHeight = this.height - 2.0 * inset;
        ObservableList<T> items = this.series.getItems();
        double noOfItems = items.size();
        double namesHeight = chartHeight * 0.1;
        double maxBarHeight = chartHeight - namesHeight;
        double minNumberOfBars = noOfItems > (double)this.getMinNumberOfBars() ? noOfItems : (double)this.getMinNumberOfBars();
        double barWidth = this.getUseMinNumberOfBars() ? chartWidth / (minNumberOfBars + minNumberOfBars * 0.4) : chartWidth / (noOfItems + noOfItems * 0.4);
        double cornerRadius = barWidth * 0.75;
        double barSpacer = this.getUseMinNumberOfBars() ? (chartWidth - minNumberOfBars * barWidth) / (minNumberOfBars - 1.0) : (chartWidth - noOfItems * barWidth) / (noOfItems - 1.0);
        double maxValue = this.series.getMaxValue();
        NumberFormat numberFormat = this.getNumberFormat();
        Color valueTextFill = this.getTextFill();
        Color namesTextFill = this.getNamesTextFill();
        boolean useItemFill = this.getUseItemFill();
        boolean useItemTextFill = this.getUseItemTextFill();
        boolean useNamesTextFill = this.getUseNamesTextFill();
        String formatString = numberFormat.formatString();
        Paint barFill = this.series.getFill();
        boolean shortenNumbers = this.getShortenNumbers();
        boolean barBackgroundVisible = this.getBarBackgroundVisible();
        Color barBackgroundFill = this.getBarBackgroundFill();
        Paint namesBackgroundFill = this.getNamesBackgroundFill().equals(Color.TRANSPARENT) ? this.getBackgroundFill() : this.getNamesBackgroundFill();
        boolean shadowsVisible = this.getShadowsVisible();
        double valueFontSize = barWidth * 0.25;
        double nameFontSize = barWidth * 0.25;
        Font valueFont = Fonts.latoRegular((double)valueFontSize);
        Font nameFont = Fonts.latoRegular((double)nameFontSize);
        DropShadow shadow = new DropShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)0, (int)0, (int)0, (double)0.15), barWidth * 0.1, 0.0, barWidth * 0.1, 1.0);
        double barY = chartHeight - inset - namesHeight;
        int givenColorCounter = 0;
        this.ctx.clearRect(0.0, 0.0, this.width, this.height);
        this.ctx.setFill(this.getBackgroundFill());
        this.ctx.fillRect(0.0, 0.0, this.width, this.height);
        this.ctx.setLineCap(StrokeLineCap.BUTT);
        this.ctx.setTextAlign(TextAlignment.RIGHT);
        this.ctx.setTextBaseline(VPos.CENTER);
        this.ctx.setFont(valueFont);
        int i = 0;
        while ((double)i < noOfItems) {
            item = (ChartItem)items.get(i);
            double itemValue = Helper.clamp(0.0, Double.MAX_VALUE, item.getValue());
            double barHeight = 0.0 == maxValue ? 0.0 : itemValue / maxValue * maxBarHeight;
            double barX = inset + (double)i * barWidth + (double)i * barSpacer;
            if (barBackgroundVisible) {
                this.ctx.setFill((Paint)barBackgroundFill);
                this.ctx.beginPath();
                this.ctx.moveTo(barX, barY);
                this.ctx.lineTo(barX, barY - maxBarHeight + cornerRadius);
                this.ctx.bezierCurveTo(barX, barY - maxBarHeight, barX + barWidth, barY - maxBarHeight, barX + barWidth, barY - maxBarHeight + cornerRadius);
                this.ctx.lineTo(barX + barWidth, barY);
                this.ctx.lineTo(barX, barY);
                this.ctx.closePath();
                this.ctx.fill();
            }
            this.ctx.save();
            if (shadowsVisible) {
                this.ctx.setEffect((Effect)shadow);
            }
            if (this.useGivenColors()) {
                this.ctx.setFill((Paint)this.colors.get(givenColorCounter));
                if (++givenColorCounter > this.colors.size() - 1) {
                    givenColorCounter = 0;
                }
            } else {
                this.ctx.setFill((Paint)(useItemFill ? item.getFill() : barFill));
            }
            this.ctx.beginPath();
            this.ctx.moveTo(barX, barY);
            if (barHeight < cornerRadius) {
                this.ctx.bezierCurveTo(barX, barY - cornerRadius, barX + barWidth, barY - cornerRadius, barX + barWidth, barY);
            } else {
                this.ctx.lineTo(barX, barY - barHeight + cornerRadius);
                this.ctx.bezierCurveTo(barX, barY - barHeight, barX + barWidth, barY - barHeight, barX + barWidth, barY - barHeight + cornerRadius);
            }
            this.ctx.lineTo(barX + barWidth, barY);
            this.ctx.lineTo(barX, barY);
            this.ctx.closePath();
            this.ctx.fill();
            this.ctx.restore();
            this.rectangleItemMap.put(new Rectangle(barX, barY - maxBarHeight, barWidth, barHeight), item);
            if (valueFontSize > 6.0) {
                double valueY;
                double valueTextHeight;
                String valueText;
                this.ctx.setFill((Paint)(useItemTextFill ? item.getTextFill() : valueTextFill));
                this.ctx.setTextAlign(TextAlignment.CENTER);
                if (shortenNumbers) {
                    valueText = Helper.shortenNumber((long)itemValue);
                    valueTextHeight = Helper.getTextDimension(valueText, valueFont).getHeight();
                    valueY = barY - barHeight + barWidth * 0.5;
                } else if (NumberFormat.PERCENTAGE == numberFormat || NumberFormat.PERCENTAGE_1_DECIMAL == numberFormat) {
                    valueText = String.format(Locale.US, formatString, itemValue / maxValue * 100.0);
                    valueTextHeight = Helper.getTextDimension(valueText, valueFont).getHeight();
                    valueY = barY - 5.0 - valueFontSize;
                } else {
                    valueText = String.format(Locale.US, formatString, itemValue);
                    valueTextHeight = Helper.getTextDimension(valueText, valueFont).getHeight();
                    valueY = barY - barHeight + barWidth * 0.5;
                }
                valueY = barHeight <= valueTextHeight * 2.0 ? barY - valueTextHeight - 5.0 : valueY;
                this.ctx.fillText(valueText, barX + barWidth * 0.5, valueY);
            }
            ++i;
        }
        this.ctx.setFill(namesBackgroundFill);
        this.ctx.fillRect(inset, chartHeight - inset - namesHeight, chartWidth, namesHeight);
        for (i = 0; i < items.size(); ++i) {
            item = (ChartItem)items.get(i);
            String name = item.getName();
            double nameY = chartHeight - inset - namesHeight * 0.5;
            double nameX = inset + (double)i * barWidth + (double)i * barSpacer;
            this.ctx.setTextAlign(TextAlignment.CENTER);
            this.ctx.setFill((Paint)(useNamesTextFill ? namesTextFill : item.getTextFill()));
            this.ctx.setFont(nameFont);
            this.ctx.fillText(name, nameX + barWidth * 0.5, nameY, barWidth);
        }
        if (shadowsVisible) {
            this.ctx.setFill((Paint)new LinearGradient(0.0, 1.0, 0.0, 0.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.TRANSPARENT), new Stop(1.0, Color.rgb((int)0, (int)0, (int)0, (double)0.25))}));
            this.ctx.fillRect(inset, chartHeight - namesHeight - inset - 6.0, chartWidth, 6.0);
            this.ctx.setFill((Paint)new LinearGradient(0.0, 0.0, 0.0, 1.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(1.0, Color.rgb((int)0, (int)0, (int)0, (double)0.25)), new Stop(0.0, Color.TRANSPARENT)}));
            this.ctx.fillRect(inset, chartHeight - inset, chartWidth, 6.0);
        }
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        double d = this.size = this.width < this.height ? this.width : this.height;
        if (this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.width, this.height);
            this.pane.setPrefSize(this.width, this.height);
            this.pane.relocate((this.getWidth() - this.width) * 0.5, (this.getHeight() - this.height) * 0.5);
            this.canvas.setWidth(this.width);
            this.canvas.setHeight(this.height);
            this.redraw();
        }
    }

    private void redraw() {
        if (this.getSorted()) {
            this.series.sort(this.getOrder());
        }
        switch (this.getOrientation()) {
            case HORIZONTAL: {
                this.drawHorizontalChart();
                break;
            }
            case VERTICAL: {
                this.drawVerticalChart();
            }
        }
    }
}

