/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.BarChart;
import eu.hansolo.fx.charts.data.ChartItem;
import eu.hansolo.fx.charts.tools.NumberFormat;
import eu.hansolo.fx.charts.tools.Order;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class BarChartBuilder<B extends BarChartBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected BarChartBuilder() {
    }

    public static final BarChartBuilder create() {
        return new BarChartBuilder();
    }

    public final B items(ChartItem ... items) {
        this.properties.put("itemsArray", (Property)new SimpleObjectProperty((Object)items));
        return (B)this;
    }

    public final B items(List<ChartItem> items) {
        this.properties.put("itemsList", (Property)new SimpleObjectProperty(items));
        return (B)this;
    }

    public final B orientation(Orientation orientation) {
        this.properties.put("orientation", (Property)new SimpleObjectProperty((Object)orientation));
        return (B)this;
    }

    public final B backgroundFill(Paint backgroundFill) {
        this.properties.put("backgroundFill", (Property)new SimpleObjectProperty((Object)backgroundFill));
        return (B)this;
    }

    public final B namesBackgroundFill(Paint namesBackgroundFill) {
        this.properties.put("namesBackgroundFill", (Property)new SimpleObjectProperty((Object)namesBackgroundFill));
        return (B)this;
    }

    public final B barBackgroundFill(Color barBackgroundFill) {
        this.properties.put("barBackgroundFill", (Property)new SimpleObjectProperty((Object)barBackgroundFill));
        return (B)this;
    }

    public final B seriesFill(Paint seriesFill) {
        this.properties.put("seriesFill", (Property)new SimpleObjectProperty((Object)seriesFill));
        return (B)this;
    }

    public final B textFill(Color textFill) {
        this.properties.put("textFill", (Property)new SimpleObjectProperty((Object)textFill));
        return (B)this;
    }

    public final B namesTextFill(Color namesTextFill) {
        this.properties.put("namesTextFill", (Property)new SimpleObjectProperty((Object)namesTextFill));
        return (B)this;
    }

    public final B barBackgroundVisible(boolean barBackgroundVisible) {
        this.properties.put("barBackgroundVisible", (Property)new SimpleBooleanProperty(barBackgroundVisible));
        return (B)this;
    }

    public final B shadowsVisible(boolean shadowsVisible) {
        this.properties.put("shadowsVisible", (Property)new SimpleBooleanProperty(shadowsVisible));
        return (B)this;
    }

    public final B numberFormat(NumberFormat numberFormat) {
        this.properties.put("numberFormat", (Property)new SimpleObjectProperty((Object)numberFormat));
        return (B)this;
    }

    public final B useItemFill(boolean useItemFill) {
        this.properties.put("useItemFill", (Property)new SimpleBooleanProperty(useItemFill));
        return (B)this;
    }

    public final B useItemTextFill(boolean useItemTextFill) {
        this.properties.put("useItemTextFill", (Property)new SimpleBooleanProperty(useItemTextFill));
        return (B)this;
    }

    public final B useNamesTextFill(boolean useNamesTextFill) {
        this.properties.put("useNamesTextFill", (Property)new SimpleBooleanProperty(useNamesTextFill));
        return (B)this;
    }

    public final B shortenNumbers(boolean shortenNumbers) {
        this.properties.put("shortenNumbers", (Property)new SimpleBooleanProperty(shortenNumbers));
        return (B)this;
    }

    public final B sorted(boolean sorted) {
        this.properties.put("sorted", (Property)new SimpleBooleanProperty(sorted));
        return (B)this;
    }

    public final B order(Order order) {
        this.properties.put("order", (Property)new SimpleObjectProperty((Object)order));
        return (B)this;
    }

    public final B animated(boolean animated) {
        this.properties.put("animated", (Property)new SimpleBooleanProperty(animated));
        return (B)this;
    }

    public final B animationDuration(long animationDuration) {
        this.properties.put("animationDuration", (Property)new SimpleLongProperty(animationDuration));
        return (B)this;
    }

    public final B minNumberOfBars(int minNumberOfBars) {
        this.properties.put("minNumberOfBars", (Property)new SimpleIntegerProperty(minNumberOfBars));
        return (B)this;
    }

    public final B useMinNumberOfBars(boolean useMinNumberOfBars) {
        this.properties.put("useMinNumberOfBars", (Property)new SimpleBooleanProperty(useMinNumberOfBars));
        return (B)this;
    }

    public final B useGivenColors(boolean useGivenColors) {
        this.properties.put("useGivenColors", (Property)new SimpleBooleanProperty(useGivenColors));
        return (B)this;
    }

    public final B colors(List<Color> colors) {
        this.properties.put("colors", (Property)new SimpleObjectProperty(colors));
        return (B)this;
    }

    public final B prefSize(double width, double height) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(width, height)));
        return (B)this;
    }

    public final B minSize(double width, double height) {
        this.properties.put("minSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(width, height)));
        return (B)this;
    }

    public final B maxSize(double width, double height) {
        this.properties.put("maxSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(width, height)));
        return (B)this;
    }

    public final B prefWidth(double prefWidth) {
        this.properties.put("prefWidth", (Property)new SimpleDoubleProperty(prefWidth));
        return (B)this;
    }

    public final B prefHeight(double prefHeight) {
        this.properties.put("prefHeight", (Property)new SimpleDoubleProperty(prefHeight));
        return (B)this;
    }

    public final B minWidth(double minWidth) {
        this.properties.put("minWidth", (Property)new SimpleDoubleProperty(minWidth));
        return (B)this;
    }

    public final B minHeight(double minHeight) {
        this.properties.put("minHeight", (Property)new SimpleDoubleProperty(minHeight));
        return (B)this;
    }

    public final B maxWidth(double maxWidth) {
        this.properties.put("maxWidth", (Property)new SimpleDoubleProperty(maxWidth));
        return (B)this;
    }

    public final B maxHeight(double maxHeight) {
        this.properties.put("maxHeight", (Property)new SimpleDoubleProperty(maxHeight));
        return (B)this;
    }

    public final B scaleX(double scaleX) {
        this.properties.put("scaleX", (Property)new SimpleDoubleProperty(scaleX));
        return (B)this;
    }

    public final B scaleY(double scaleY) {
        this.properties.put("scaleY", (Property)new SimpleDoubleProperty(scaleY));
        return (B)this;
    }

    public final B layoutX(double layoutX) {
        this.properties.put("layoutX", (Property)new SimpleDoubleProperty(layoutX));
        return (B)this;
    }

    public final B layoutY(double layoutY) {
        this.properties.put("layoutY", (Property)new SimpleDoubleProperty(layoutY));
        return (B)this;
    }

    public final B translateX(double translateX) {
        this.properties.put("translateX", (Property)new SimpleDoubleProperty(translateX));
        return (B)this;
    }

    public final B translateY(double translateY) {
        this.properties.put("translateY", (Property)new SimpleDoubleProperty(translateY));
        return (B)this;
    }

    public final B padding(Insets insets) {
        this.properties.put("padding", (Property)new SimpleObjectProperty((Object)insets));
        return (B)this;
    }

    public final BarChart build() {
        BarChart barChart = new BarChart();
        if (this.properties.keySet().contains("itemsArray")) {
            barChart.setItems((ChartItem[])((ObjectProperty)this.properties.get("itemsArray")).get());
        }
        if (this.properties.keySet().contains("itemsList")) {
            barChart.setItems((List)((ObjectProperty)this.properties.get("itemsList")).get());
        }
        Iterator<String> iterator = this.properties.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = iterator.next()) {
                case "prefSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    barChart.setPrefSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "minSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    barChart.setMinSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "maxSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    barChart.setMaxSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "prefWidth": {
                    barChart.setPrefWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "prefHeight": {
                    barChart.setPrefHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "minWidth": {
                    barChart.setMinWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "minHeight": {
                    barChart.setMinHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "maxWidth": {
                    barChart.setMaxWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "maxHeight": {
                    barChart.setMaxHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "scaleX": {
                    barChart.setScaleX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "scaleY": {
                    barChart.setScaleY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "layoutX": {
                    barChart.setLayoutX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "layoutY": {
                    barChart.setLayoutY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "translateX": {
                    barChart.setTranslateX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "translateY": {
                    barChart.setTranslateY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "padding": {
                    barChart.setPadding((Insets)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "orientation": {
                    barChart.setOrientation((Orientation)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "backgroundFill": {
                    barChart.setBackgroundFill((Paint)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "namesBackgroundFill": {
                    barChart.setNamesBackgroundFill((Paint)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "barBackgroundFill": {
                    barChart.setBarBackgroundFill((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "seriesFill": {
                    barChart.setSeriesFill((Paint)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "textFill": {
                    barChart.setTextFill((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "namesTextFill": {
                    barChart.setNamesTextFill((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "barBackgroundVisible": {
                    barChart.setBarBackgroundVisible(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "shadowsVisible": {
                    barChart.setShadowsVisible(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "numberFormat": {
                    barChart.setNumberFormat((NumberFormat)((Object)((ObjectProperty)this.properties.get(key)).get()));
                    break;
                }
                case "useItemFill": {
                    barChart.setUseItemFill(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "useItemTextFill": {
                    barChart.setUseItemTextFill(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "useNamesTextFill": {
                    barChart.setUseNamesTextFill(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "shortenNumbers": {
                    barChart.setShortenNumbers(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "sorted": {
                    barChart.setSorted(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "order": {
                    barChart.setOrder((Order)((Object)((ObjectProperty)this.properties.get(key)).get()));
                    break;
                }
                case "animated": {
                    barChart.setAnimated(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "animationDuration": {
                    barChart.setAnimationDuration(((LongProperty)this.properties.get(key)).get());
                    break;
                }
                case "minNumberOfBars": {
                    barChart.setMinNumberOfBars(((IntegerProperty)this.properties.get(key)).get());
                    break;
                }
                case "useMinNumberOfBars": {
                    barChart.setUseMinNumberOfBars(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "useGivenColors": {
                    barChart.setUseGivenColors(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "colors": {
                    barChart.setColors((List)((ObjectProperty)this.properties.get(key)).get());
                }
            }
        }
        return barChart;
    }
}

