/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.Axis;
import eu.hansolo.fx.charts.color.MaterialDesignColors;
import eu.hansolo.fx.charts.data.CandleChartItem;
import eu.hansolo.fx.charts.data.ChartItem;
import eu.hansolo.fx.charts.event.ChartEvt;
import eu.hansolo.fx.charts.tools.Helper;
import eu.hansolo.fx.charts.tools.TooltipPopup;
import eu.hansolo.fx.geometry.Rectangle;
import eu.hansolo.toolbox.evt.EvtObserver;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.IntegerPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

@DefaultProperty(value="children")
public class CandleChart
extends Region {
    private static final double PREFERRED_WIDTH = 600.0;
    private static final double PREFERRED_HEIGHT = 400.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 2048.0;
    private static final double MAXIMUM_HEIGHT = 2048.0;
    private static final Color DEFAULT_BACKGROUND_COLOR = Color.TRANSPARENT;
    private static final Color DEFAULT_BULLISH_COLOR = MaterialDesignColors.GREEN_300.get();
    private static final Color DEFAULT_BEARISH_COLOR = MaterialDesignColors.RED_300.get();
    private static final Color DEFAULT_STROKE = Color.BLACK;
    private static final DateTimeFormatter DTF = DateTimeFormatter.ofPattern("dd.MM.yyyy", Locale.US);
    private String userAgentStyleSheet;
    private double width;
    private double height;
    private Canvas canvas;
    private GraphicsContext ctx;
    private ObservableList<CandleChartItem> items = FXCollections.observableArrayList();
    private EvtObserver<ChartEvt> itemObserver = e -> this.redraw();
    private ListChangeListener<CandleChartItem> itemListListener = c -> {
        while (c.next()) {
            if (c.wasAdded()) {
                c.getAddedSubList().forEach(addedItem -> addedItem.addChartEvtObserver(ChartEvt.ITEM_UPDATE, this.itemObserver));
                continue;
            }
            if (!c.wasRemoved()) continue;
            c.getRemoved().forEach(removedItem -> removedItem.removeChartEvtObserver(ChartEvt.ITEM_UPDATE, this.itemObserver));
        }
        this.minValue = this.items.stream().min(Comparator.comparing(CandleChartItem::getLow)).get().getLow();
        this.maxValue = this.items.stream().max(Comparator.comparing(CandleChartItem::getHigh)).get().getHigh();
        this.calculatedRange = this.maxValue - this.minValue;
        this.sorted = false;
    };
    private int _decimals = 0;
    private IntegerProperty decimals;
    private Locale _locale;
    private ObjectProperty<Locale> locale;
    private String formatString;
    private Map<Rectangle, CandleChartItem> paths;
    private TooltipPopup popup;
    private double minValue = 100.0;
    private double maxValue = 0.0;
    private double calculatedRange = 100.0;
    private Color _backgroundColor = DEFAULT_BACKGROUND_COLOR;
    private ObjectProperty<Color> backgroundColor;
    private Color _bullishColor = DEFAULT_BULLISH_COLOR;
    private ObjectProperty<Color> bullishColor;
    private Color _bearishColor = DEFAULT_BEARISH_COLOR;
    private ObjectProperty<Color> bearishColor;
    private Color _strokeColor = DEFAULT_STROKE;
    private ObjectProperty<Color> strokeColor;
    private boolean _endLinesVisible = false;
    private BooleanProperty endLinesVisible;
    private boolean _useItemColorForStroke = false;
    private BooleanProperty useItemColorForStroke;
    private int _minNumberOfItems = 10;
    private IntegerProperty minNumberOfItems;
    private boolean _useMinNumberOfItems = false;
    private BooleanProperty useMinNumberOfItems;
    private Axis _yAxis = null;
    private ObjectProperty<Axis> yAxis;
    private boolean sorted = false;

    public CandleChart() {
        this(new ArrayList<CandleChartItem>());
    }

    public CandleChart(List<CandleChartItem> ITEMS) {
        this._locale = Locale.getDefault();
        this.paths = new ConcurrentHashMap<Rectangle, CandleChartItem>();
        this.formatString = "%." + this._decimals + "f";
        this.popup = new TooltipPopup("", 3500L, true);
        this.items.setAll((Collection)(null == ITEMS ? new ArrayList() : ITEMS));
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(600.0, 400.0);
            }
        }
        this.getStyleClass().add((Object)"candle-chart");
        this.canvas = new Canvas(600.0, 400.0);
        this.ctx = this.canvas.getGraphicsContext2D();
        this.getChildren().setAll((Object[])new Node[]{this.canvas});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
        this.popup.setOnHiding(e -> this.popup.setText(""));
        this.items.addListener(this.itemListListener);
        this.canvas.setOnMousePressed(e -> this.paths.forEach((path, chartItem) -> {
            double eventY;
            double eventX = e.getX();
            if (path.contains(eventX, eventY = e.getY())) {
                boolean bullish = chartItem.getOpen() < chartItem.getClose();
                String tooltipText = chartItem.getName() + "\n" + "timestamp: " + DTF.format(LocalDateTime.ofInstant(chartItem.getTimestamp(), ZoneId.systemDefault())) + "\n" + "high     : " + String.format(this.getLocale(), this.formatString, chartItem.getHigh()) + "\n" + (bullish ? "close    : " : "open     : ") + (bullish ? String.format(this.getLocale(), this.formatString, chartItem.getClose()) : String.format(this.getLocale(), this.formatString, chartItem.getOpen())) + "\n" + (bullish ? "open     : " : "close    : ") + (bullish ? String.format(this.getLocale(), this.formatString, chartItem.getOpen()) : String.format(this.getLocale(), this.formatString, chartItem.getClose())) + "\n" + "low      : " + String.format(this.getLocale(), this.formatString, chartItem.getLow());
                if (!tooltipText.isEmpty()) {
                    this.popup.setX(e.getScreenX() - this.popup.getWidth() * 0.5);
                    this.popup.setY(e.getScreenY() - 30.0);
                    this.popup.setText(tooltipText);
                    this.popup.animatedShow(this.getScene().getWindow());
                }
            }
        }));
    }

    public void layoutChildren() {
        super.layoutChildren();
    }

    protected double computeMinWidth(double HEIGHT) {
        return 50.0;
    }

    protected double computeMinHeight(double WIDTH) {
        return 50.0;
    }

    protected double computePrefWidth(double HEIGHT) {
        return super.computePrefWidth(HEIGHT);
    }

    protected double computePrefHeight(double WIDTH) {
        return super.computePrefHeight(WIDTH);
    }

    protected double computeMaxWidth(double HEIGHT) {
        return 2048.0;
    }

    protected double computeMaxHeight(double WIDTH) {
        return 2048.0;
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public void dispose() {
        this.items.removeListener(this.itemListListener);
    }

    public List<CandleChartItem> getItems() {
        return this.items;
    }

    public void setItems(CandleChartItem ... ITEMS) {
        this.setItems(Arrays.asList(ITEMS));
    }

    public void setItems(List<CandleChartItem> ITEMS) {
        this.items.setAll(ITEMS);
    }

    public void addItem(CandleChartItem ITEM) {
        if (!this.items.contains((Object)ITEM)) {
            this.items.add((Object)ITEM);
        }
    }

    public void removeItem(CandleChartItem ITEM) {
        if (this.items.contains((Object)ITEM)) {
            this.items.remove((Object)ITEM);
        }
    }

    public int getDecimals() {
        return null == this.decimals ? this._decimals : this.decimals.get();
    }

    public void setDecimals(int DECIMALS) {
        if (null == this.decimals) {
            this._decimals = Helper.clamp(0, 6, DECIMALS);
            this.formatString = "%." + this.getDecimals() + "f";
            this.redraw();
        } else {
            this.decimals.set(DECIMALS);
        }
    }

    public IntegerProperty decimalsProperty() {
        if (null == this.decimals) {
            this.decimals = new IntegerPropertyBase(this._decimals){

                protected void invalidated() {
                    this.set(Helper.clamp(0, 6, this.get()));
                    CandleChart.this.formatString = "%." + this.get() + "f";
                    CandleChart.this.redraw();
                }

                public Object getBean() {
                    return CandleChart.this;
                }

                public String getName() {
                    return "decimals";
                }
            };
        }
        return this.decimals;
    }

    public Locale getLocale() {
        return null == this.locale ? this._locale : (Locale)this.locale.get();
    }

    public void setLocale(Locale LOCALE) {
        if (null == this.locale) {
            this._locale = LOCALE;
        } else {
            this.locale.set((Object)LOCALE);
        }
    }

    public ObjectProperty<Locale> localeProperty() {
        if (null == this.locale) {
            this.locale = new ObjectPropertyBase<Locale>(this._locale){

                protected void invalidated() {
                }

                public Object getBean() {
                    return CandleChart.this;
                }

                public String getName() {
                    return "locale";
                }
            };
        }
        this._locale = null;
        return this.locale;
    }

    public Color getBackgroundColor() {
        return null == this.backgroundColor ? this._backgroundColor : (Color)this.backgroundColor.get();
    }

    public void setBackgroundColor(Color backgroundColor) {
        if (null == this.backgroundColor) {
            this._backgroundColor = backgroundColor;
            this.redraw();
        } else {
            this.backgroundColor.set((Object)backgroundColor);
        }
    }

    public ObjectProperty<Color> backgroundColorProperty() {
        if (null == this.backgroundColor) {
            this.backgroundColor = new ObjectPropertyBase<Color>(this._backgroundColor){

                protected void invalidated() {
                    CandleChart.this.redraw();
                }

                public Object getBean() {
                    return CandleChart.this;
                }

                public String getName() {
                    return "backgroundColor";
                }
            };
            this._backgroundColor = null;
        }
        return this.backgroundColor;
    }

    public Color getBullishColor() {
        return null == this.bullishColor ? this._bullishColor : (Color)this.bullishColor.get();
    }

    public void setBullishColor(Color bullishColor) {
        if (null == this.bullishColor) {
            this._bullishColor = bullishColor;
            this.redraw();
        } else {
            this.bullishColor.set((Object)bullishColor);
        }
    }

    public ObjectProperty<Color> bullishColorProperty() {
        if (null == this.bullishColor) {
            this.bullishColor = new ObjectPropertyBase<Color>(this._bullishColor){

                protected void invalidated() {
                    CandleChart.this.redraw();
                }

                public Object getBean() {
                    return CandleChart.this;
                }

                public String getName() {
                    return "bullishColor";
                }
            };
            this._bullishColor = null;
        }
        return this.bullishColor;
    }

    public Color getBearishColor() {
        return null == this.bearishColor ? this._bearishColor : (Color)this.bearishColor.get();
    }

    public void setBearishColor(Color bearishColor) {
        if (null == this.bearishColor) {
            this._bearishColor = bearishColor;
            this.redraw();
        } else {
            this.bearishColor.set((Object)bearishColor);
        }
    }

    public ObjectProperty<Color> bearishColorProperty() {
        if (null == this.bearishColor) {
            this.bearishColor = new ObjectPropertyBase<Color>(this._bearishColor){

                protected void invalidated() {
                    CandleChart.this.redraw();
                }

                public Object getBean() {
                    return CandleChart.this;
                }

                public String getName() {
                    return "bearishColor";
                }
            };
            this._bearishColor = null;
        }
        return this.bearishColor;
    }

    public Color getStrokeColor() {
        return null == this.strokeColor ? this._strokeColor : (Color)this.strokeColor.get();
    }

    public void setStrokeColor(Color strokeColor) {
        if (null == this.strokeColor) {
            this._strokeColor = strokeColor;
            this.redraw();
        } else {
            this.strokeColor.set((Object)strokeColor);
        }
    }

    public ObjectProperty<Color> strokeColorProperty() {
        if (null == this.strokeColor) {
            this.strokeColor = new ObjectPropertyBase<Color>(this._strokeColor){

                protected void invalidated() {
                    CandleChart.this.redraw();
                }

                public Object getBean() {
                    return CandleChart.this;
                }

                public String getName() {
                    return "strokeColor";
                }
            };
            this._strokeColor = null;
        }
        return this.strokeColor;
    }

    public boolean getEndLinesVisible() {
        return null == this.endLinesVisible ? this._endLinesVisible : this.endLinesVisible.get();
    }

    public void setEndLinesVisible(boolean endLinesVisible) {
        if (null == this.endLinesVisible) {
            this._endLinesVisible = endLinesVisible;
            this.redraw();
        } else {
            this.endLinesVisible.set(endLinesVisible);
        }
    }

    public BooleanProperty endLinesVisibleProperty() {
        if (null == this.endLinesVisible) {
            this.endLinesVisible = new BooleanPropertyBase(this._endLinesVisible){

                protected void invalidated() {
                    CandleChart.this.redraw();
                }

                public Object getBean() {
                    return CandleChart.this;
                }

                public String getName() {
                    return "endLinesVisible";
                }
            };
        }
        return this.endLinesVisible;
    }

    public boolean getUseItemColorForStroke() {
        return null == this.useItemColorForStroke ? this._useItemColorForStroke : this.useItemColorForStroke.get();
    }

    public void setUseItemColorForStroke(boolean useItemColorForStroke) {
        if (null == this.useItemColorForStroke) {
            this._useItemColorForStroke = useItemColorForStroke;
            this.redraw();
        } else {
            this.useItemColorForStroke.set(useItemColorForStroke);
        }
    }

    public BooleanProperty useItemColorForStrokeProperty() {
        if (null == this.useItemColorForStroke) {
            this.useItemColorForStroke = new BooleanPropertyBase(this._useItemColorForStroke){

                protected void invalidated() {
                    CandleChart.this.redraw();
                }

                public Object getBean() {
                    return CandleChart.this;
                }

                public String getName() {
                    return "useItemColorForStroke";
                }
            };
        }
        return this.useItemColorForStroke;
    }

    public int getMinNumberOfItems() {
        return null == this.minNumberOfItems ? this._minNumberOfItems : this.minNumberOfItems.get();
    }

    public void setMinNumberOfItems(int minNumberOfItems) {
        if (null == this.minNumberOfItems) {
            this._minNumberOfItems = Helper.clamp(1, Integer.MAX_VALUE, minNumberOfItems);
            this.redraw();
        } else {
            this.minNumberOfItems.set(minNumberOfItems);
        }
    }

    public IntegerProperty minNumberOfItemsProperty() {
        if (null == this.minNumberOfItems) {
            this.minNumberOfItems = new IntegerPropertyBase(this._minNumberOfItems){

                protected void invalidated() {
                    this.set(Helper.clamp(1, Integer.MAX_VALUE, this.get()));
                    CandleChart.this.redraw();
                }

                public Object getBean() {
                    return CandleChart.this;
                }

                public String getName() {
                    return "minNumberOfItems";
                }
            };
        }
        return this.minNumberOfItems;
    }

    public boolean getUseMinNumberOfItems() {
        return null == this.useMinNumberOfItems ? this._useMinNumberOfItems : this.useMinNumberOfItems.get();
    }

    public void setUseMinNumberOfItems(boolean useMinNumberOfItems) {
        if (null == this.useMinNumberOfItems) {
            this._useMinNumberOfItems = useMinNumberOfItems;
            this.redraw();
        } else {
            this.useMinNumberOfItems.set(useMinNumberOfItems);
        }
    }

    public BooleanProperty useMinNumberOfItemsProperty() {
        if (null == this.useMinNumberOfItems) {
            this.useMinNumberOfItems = new BooleanPropertyBase(this._useMinNumberOfItems){

                protected void invalidated() {
                    CandleChart.this.redraw();
                }

                public Object getBean() {
                    return CandleChart.this;
                }

                public String getName() {
                    return "useMinNumberOfItems";
                }
            };
        }
        return this.useMinNumberOfItems;
    }

    public Axis getYAxis() {
        return null == this.yAxis ? this._yAxis : (Axis)((Object)this.yAxis.get());
    }

    public void setYAxis(Axis yAxis) {
        if (null == this.yAxis) {
            this._yAxis = yAxis;
            this.redraw();
        } else {
            this.yAxis.set((Object)yAxis);
        }
    }

    public ObjectProperty<Axis> yAxisProperty() {
        if (null == this.yAxis) {
            this.yAxis = new ObjectPropertyBase<Axis>(this._yAxis){

                protected void invalidated() {
                    CandleChart.this.redraw();
                }

                public Object getBean() {
                    return CandleChart.this;
                }

                public String getName() {
                    return "yAxis";
                }
            };
        }
        return this.yAxis;
    }

    public void resetYAxis() {
        this._yAxis = null;
        this.yAxis = null;
        this.minValue = this.items.stream().min(Comparator.comparing(CandleChartItem::getLow)).get().getLow();
        this.maxValue = this.items.stream().max(Comparator.comparing(CandleChartItem::getHigh)).get().getHigh();
        this.redraw();
    }

    public void setPopupTimeout(long milliseconds) {
        this.popup.setTimeout(milliseconds);
    }

    public String getUserAgentStylesheet() {
        if (null == this.userAgentStyleSheet) {
            this.userAgentStyleSheet = CandleChart.class.getResource("chart.css").toExternalForm();
        }
        return this.userAgentStyleSheet;
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        if (this.width > 0.0 && this.height > 0.0) {
            this.canvas.setWidth(this.width);
            this.canvas.setHeight(this.height);
            this.canvas.relocate((this.getWidth() - this.width) * 0.5, (this.getHeight() - this.height) * 0.5);
            this.ctx.setTextBaseline(VPos.CENTER);
        }
        this.redraw();
    }

    private void redraw() {
        double rangeY;
        int noOfItems;
        this.paths.clear();
        double inset = 5.0;
        double chartWidth = this.width - 2.0 * inset;
        double chartHeight = this.height - 2.0 * inset;
        this.ctx.clearRect(0.0, 0.0, this.width, this.height);
        this.ctx.setFill((Paint)this.getBackgroundColor());
        this.ctx.fillRect(0.0, 0.0, this.width, this.height);
        if (this.items.isEmpty()) {
            return;
        }
        if (!this.sorted) {
            Collections.sort(this.items, Comparator.comparing(ChartItem::getTimestamp));
            this.sorted = true;
        }
        double minNumberOfItems = (noOfItems = this.items.size()) > this.getMinNumberOfItems() ? (double)noOfItems : (double)this.getMinNumberOfItems();
        double itemWidth = this.getUseMinNumberOfItems() ? chartWidth / (minNumberOfItems + minNumberOfItems * 0.2) : chartWidth / ((double)noOfItems + (double)noOfItems * 0.2);
        double halfItemWidth = itemWidth * 0.5;
        double quarterItemWidth = halfItemWidth * 0.5;
        double itemSpacer = (chartWidth - (double)noOfItems * itemWidth) / (double)(noOfItems - 1);
        Axis yAxis = this.getYAxis();
        if (null == yAxis) {
            rangeY = this.calculatedRange;
        } else {
            rangeY = yAxis.getMaxValue() - yAxis.getMinValue();
            this.minValue = yAxis.getMinValue();
            this.maxValue = yAxis.getMaxValue();
        }
        double calculatedScaleFactorY = chartHeight / rangeY;
        for (int i = 0; i < noOfItems; ++i) {
            double boxHeight;
            double close;
            CandleChartItem item = (CandleChartItem)this.items.get(i);
            double high = item.getHigh();
            double low = item.getLow();
            double open = item.getOpen();
            Color fill = open < (close = item.getClose()) ? this.getBullishColor() : this.getBearishColor();
            double x = inset + halfItemWidth + (double)i * itemWidth + (double)i * itemSpacer;
            double yLow = (low - this.minValue) * calculatedScaleFactorY;
            double yHigh = (high - this.minValue) * calculatedScaleFactorY;
            double yOpen = (open - this.minValue) * calculatedScaleFactorY;
            double yClose = (close - this.minValue) * calculatedScaleFactorY;
            double d = boxHeight = open < close ? yClose - yOpen : yOpen - yClose;
            if (this.getUseItemColorForStroke()) {
                this.ctx.setStroke((Paint)(fill.equals((Object)Color.TRANSPARENT) ? this.getStrokeColor() : fill));
            } else {
                this.ctx.setStroke((Paint)this.getStrokeColor());
            }
            if (this.getEndLinesVisible()) {
                this.ctx.strokeLine(x - quarterItemWidth, this.height - inset - yHigh, x + quarterItemWidth, this.height - inset - yHigh);
                this.ctx.strokeLine(x - quarterItemWidth, this.height - inset - yLow, x + quarterItemWidth, this.height - inset - yLow);
            }
            this.ctx.strokeLine(x, this.height - inset - yHigh, x, this.height - inset - yLow);
            this.ctx.setFill((Paint)(fill.equals((Object)Color.TRANSPARENT) ? this.getBackgroundColor() : fill));
            this.ctx.setStroke((Paint)(fill.equals((Object)Color.TRANSPARENT) ? this.getStrokeColor() : fill));
            this.ctx.fillRect(x - halfItemWidth, this.height - inset - (open < close ? yClose : yOpen), itemWidth, boxHeight);
            this.ctx.strokeRect(x - halfItemWidth, this.height - inset - (open < close ? yClose : yOpen), itemWidth, boxHeight);
            this.paths.put(new Rectangle(x - halfItemWidth, this.height - inset - yHigh, itemWidth, yHigh - yLow), item);
        }
    }
}

